#ifndef _CEGOQUERYCURSOR_H_INCLUDED_
#define _CEGOQUERYCURSOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoQueryCursor.h
// -----------------
// Cego query cursor class definition
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2026 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoQueryCursor
// 
// Description: Query cursor for high level data access
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoTableCursor.h"
#include "CegoAttrCond.h"
#include "CegoField.h"
#include "CegoTableCache.h"
#include "CegoPredicate.h"
#include "CegoProcBlock.h"


class CegoQueryManager;

class CegoQueryCursor  {
    
public:
    
    CegoQueryCursor();
    CegoQueryCursor(CegoQueryManager* pGTM, CegoContentObject *pCO, CegoProcBlock *pBlock); 
    ~CegoQueryCursor();

    void querySetup( ListT<CegoField>** pFLA, CegoPredicate *pPred);
    void querySetup(CegoAttrCond& attrCond, ListT<CegoField>** pFLA, CegoPredicate *pPred);
    
    // bool nextTuple(ListT<CegoField>& fl);
    bool nextTuple(ListT<CegoField>** pFLA, unsigned pos, unsigned size);

    void reset();

    Element* getPlan();

 private:

    void useCursorObject();
    void unuseCursorObject();
    void checkType();
    
    void sysSetup();
    void joinSetup(const CegoAttrCond& attrCond);
    bool evalCondition(ListT<CegoField>** pFLA, unsigned pos, unsigned size);
    bool evalCompare(CegoAttrComp* pAC, ListT<CegoField>** pFLA, unsigned pos, unsigned size);
    bool getTuple(ListT<CegoField>** pFLA, unsigned offset, unsigned size);

    void nextRight(ListT<CegoField>** pFLA, unsigned offset, unsigned size);
    void nextLeft(ListT<CegoField>** pFLA, unsigned offset, unsigned size);

    void finishCaching();
    
    CegoQueryManager* _pGTM;
    CegoTableCache* _pCache;
    
    Chain _tableName;
    Chain _tableAlias;

    unsigned _tabSetId;

    CegoSelect *_pSelect;
    CegoTableCursor* _pTC;
    CegoObjectCursor* _pC;

    CegoQueryCursor* _pTCLeft;
    CegoQueryCursor* _pTCRight;

    CegoTableObject* _pTO;
    CegoQueryCursor* _pTCTab;
    ListT<CegoField>* _pFLAmap;
    
    CegoContentObject *_pCO;
    CegoDatabaseManager *_pDBMng;

    ListT<CegoField> _schema;

    unsigned long _modId;

    bool _cursorObjectUsed;
    bool _moreTuple;
    bool _isFirst;

    bool _useCache;
    unsigned _cacheRows;
    unsigned _cacheCols;
    
    unsigned _cachePos;
    
    bool _evalPredicate;
    bool _isAttrCondValid;
    
    bool _doEval;
    
    bool _moreLeft;
    bool _moreRight;

    CegoPredicate* _pPropPred;
    CegoPredicate* _pJoinPred;
    
    CegoAttrCond _cursorCond;
    CegoAttrCond _innerCond;
    CegoAttrCond _outerCond;

    CegoAttrCond::IndexMatch _idxMatch;

    ListT<Chain> _sysObjList;

    unsigned _cacheEntrySize;
    ListT<CegoField> _cacheSchema;
    CegoFieldValue*** _pCacheArray;
    ListT< ListT<CegoFieldValue> >* _pCacheList;
    bool _isCached;

    CegoProcBlock* _pBlock; 
    ListT<CegoField>** _pFLA;
};
#endif
