///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcThrowStmt.cc  
// --------------------                                                     
// Cego procedure throw statement implementation
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2025 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Description: Stored procedure exception throw statement
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Exception.h>
#include <lfcbase/Tokenizer.h>
#include <lfcbase/Datetime.h>

// cego includes
#include "CegoProcThrowStmt.h"
#include "CegoDatabaseFormater.h"

CegoProcThrowStmt::CegoProcThrowStmt(CegoExpr *pExpr,
				     CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _pExpr = pExpr;
    _pBlock = pBlock;
}

CegoProcThrowStmt::~CegoProcThrowStmt()  
{
    if ( _pExpr )
    {
	delete _pExpr;    
    }
}

CegoException CegoProcThrowStmt::execute()
{    
    CegoFieldValue fv;
    fv = _pExpr->evalFieldValue(0, _pBlock);

    _pBlock->setExceptionMsg(fv.toChain());
    return OTHER_EXCEP;
}

void CegoProcThrowStmt::cleanUp()
{
    _pExpr->cleanUp();
}

Chain CegoProcThrowStmt::toChain(unsigned defTabSetId, const Chain& indent) const
{
    Chain s;	    
    s =  indent + Chain("throw ") + _pExpr->toChain(defTabSetId);
    return s;
}

Chain CegoProcThrowStmt::dbFormat(CegoDatabaseFormater *pForm) const
{
    return pForm->formatProcThrowStmt(_pExpr);
}

bool CegoProcThrowStmt::isStatic() const
{
    try
    {
	_pExpr->getId(_pBlock);
	return true;
    }
    catch ( Exception e )
    {
	return false;
    }
}
