#ifndef _CEGOPROCIFSTMT_H_INCLUDED_
#define _CEGOPROCIFSTMT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcIfStatement.h  
// ---------------------
// Cego procedure if statement class definition
//
// Design and Implementation by Bjoern Lemke               
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcIfStatement
// 
// Description: Stored procedure if-statement block handling
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// cego includes
#include "CegoPredicate.h"
#include "CegoProcBlock.h"
#include "CegoProcStmt.h"

class CegoProcIfStmt : public CegoProcStmt {
    
public:
    
    CegoProcIfStmt(ListT<CegoPredicate*>& predList,
		   ListT<CegoProcBlock*>& ifBlockList,
		   CegoProcBlock *pBlock);
    ~CegoProcIfStmt();

    CegoException execute();
    void cleanUp();
    Chain toChain(unsigned defTabSetId, const Chain& indent = Chain("")) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    bool isStatic() const;
    
private:

    ListT<CegoPredicate*> _predList;
    ListT<CegoProcBlock*> _ifBlockList;
    CegoProcBlock* _pBlock;
};
#endif
