#ifndef _CEGOGROUPCURSOR_H_INCLUDED_
#define _CEGOGROUPCURSOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoGroupCursor.h
// -----------------
// Cego group cursor class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoGroupCursor
// 
// Description: A cursor, to trace group space tables
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/AVLTreeT.h>

// CEGO INCLUDES
#include "CegoGroupNode.h"

class CegoGroupCursor {
    
public:
    
    CegoGroupCursor(ListT<CegoField>& schema, AVLTreeT<CegoGroupNode>* pAVL);
    ~CegoGroupCursor();
    
    bool getFirst(ListT<CegoField>& fl);
    bool getNext(ListT<CegoField>& fl);
    
    void abort();

 private:

    AVLTreeT<CegoGroupNode>* _pAVL;
    ListT<unsigned> _avgIdxList;
};
#endif
