#ifndef _CEGOFIELD_H_INCLUDED_
#define _CEGOFIELD_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoField.h
// -----------
// Cego data Field class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//         
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoField
// 
// Description: Cego data field container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcxml/Element.h>

// CEGO INCLUDES
#include "CegoDataType.h"
#include "CegoFieldValue.h"

class CegoField {
    
public:

    CegoField();
    CegoField(const CegoField& f);
    CegoField(const Chain& tableName, const Chain& attrName);
    
    CegoField(const Chain& tableName, const Chain& tableAlias, const Chain& attrName,
	      CegoDataType type, unsigned len, unsigned dim = 0,
	      const CegoFieldValue& defVal = CegoFieldValue(),
	      bool isNullable = false, unsigned id = 0);
    
    CegoField(const CegoFieldValue& fv);

    ~CegoField();

    void setNullable(bool isNullable);
    bool isNullable() const;

    void setTableName(const Chain& tableName);
    const Chain& getTableName() const;

    void setTableAlias(const Chain& tableAlias);
    const Chain& getTableAlias() const;

    void setId(unsigned id);
    unsigned getId() const;

    void setAttrName(const Chain& attrName);
    const Chain& getAttrName() const;

    const CegoDataType& getType() const;
    void setType(const CegoDataType t);

    unsigned getLength() const;
    void setLength(unsigned l);

    unsigned getDim() const;
    void setDim(unsigned d);

    const CegoFieldValue& getValue() const;
    void setValue(const CegoFieldValue& fv);

    // performance critical setup
    void setupNull();
    void setupValue(CegoDataType type, void* pValue, unsigned len);

    unsigned size() const;
    CegoField& operator = ( const CegoField& f);
    bool operator == ( const CegoField& f);
    bool operator != ( const CegoField& f);

    Chain typeToChain() const;
    
private:
    
    Chain _tableName;
    Chain _tableAlias;
    Chain _attrName;
    unsigned _id;    
    CegoFieldValue _fv;
    bool _isNullable;
    
    CegoDataType _type;
    unsigned _len;
    unsigned _dim;
};
#endif
