#ifndef _CEGOCASECOND_H_INCLUDED_
#define _CEGOCASECOND_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoCaseCond.h
// --------------
// Cego case condition structure class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoCaseCond
//
// Description: Query case condition container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// CEGO INCLUDES
#include "CegoPredicate.h"
#include "CegoExpr.h"

class CegoDatabaseFormater;

class CegoCaseCond {
    
public:

    CegoCaseCond();
    CegoCaseCond(char* buf, CegoQueryManager *pGTM, CegoProcBlock *pBlock, unsigned tabSetId);
    ~CegoCaseCond();

    void cleanUp();    

    void setTabSetId(unsigned tabSetId);
    
    void addPred(CegoPredicate *CegoPredDesc, CegoExpr* pExpr);
    void setElseExpr(CegoExpr *pExpr);

    ListT<CegoPredicate*>& getPredList();
    ListT<CegoExpr*>& getExprList();
    CegoExpr* getElseExpr();

    ListT<CegoAttrDesc*> getAttrRefList() const;
    unsigned evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);
    ListT<CegoAggregation*> getAggregationList();
    
    void clearAttrCache();

    void getFieldList(ListT<CegoField>& fl, ListT<CegoField>** pFLA) const;
    CegoField evalField(const ListT<CegoField>& fl, bool graceful = false) const;
    
    CegoFieldValue evalFieldValue(ListT<CegoField> **pFLA, CegoProcBlock *pBlock) const;

    CegoCaseCond* clone(bool isAttrRef = false);
    
    CegoCaseCond& operator = ( const CegoCaseCond& cc);

    void getSelectQueryList(ListT<CegoSelect*>& queryList);
    
    Chain getId(CegoProcBlock *pBlock) const;
    Chain toChain(unsigned defTabSetId) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    
    void encode(char *buf, CegoProcBlock *pBlock);
    void decode(char *buf, CegoQueryManager* pGTM, CegoProcBlock *pBlock, unsigned tabSetId);
    unsigned getEncodingLength(CegoProcBlock *pBlock) const;

    void getPlanList(ListT<Element*>& planList);
	
    friend ostream& operator << (ostream& s, const CegoCaseCond& cc);

    CegoCaseCond* map(const Chain& viewAlias, const ListT<CegoExpr*>& exprList) const;
    
private:

    ListT<CegoPredicate*> _predList;
    ListT<CegoExpr*> _exprList;
    CegoExpr* _elseExpr;

};
#endif
