#ifndef _CEGOADMINTHREAD_H_INCLUDED_
#define _CEGOADMINTHREAD_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAdminThread.h  
// -----------------
// Cego admin thread class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAdminThread
// 
// Description: Handling all database admin requests
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/Thread.h>
#include <lfcbase/NetHandler.h>
#include <lfcbase/NanoTimer.h>
#include <lfcbase/OutStream.h>

// CEGO INCLUDES
#include "CegoAdminHandler.h"
#include "CegoDatabaseManager.h"
#include "CegoQueryManager.h"
#include "CegoDbThreadPool.h"

class CegoAdminThreadPool;

class CegoAdminThread : public Thread {
    
public:
    
    CegoAdminThread();
    CegoAdminThread(CegoAdminThreadPool *pPool, CegoDatabaseManager *pDBMng, CegoDbThreadPool *pDbPool);
    ~CegoAdminThread();
    
    const Chain& lastAction() const;
    void* job(void* arg);
    
private:
    
    class BackupStream : public OutStream {
    public:
	
        BackupStream(CegoAdminHandler* pAH)
	{
	    _pAH = pAH;
	}
	
	~BackupStream()
	{
	}
	
	bool nextLine(const Chain& line)
	{
	    return _pAH->syncWithInfo(Chain("local"), Chain("local"), line, 0);
	}
	
    private:
	
	CegoAdminHandler* _pAH;
    };

    class LogInfoStream : public OutStream {	
    public:
	
        LogInfoStream() : OutStream()
	{
	};
    
	bool nextLine(const Chain& line)
	{	    
	    _result = line;
	    return true;
	};

	Chain getResult()
	{
	    return _result;
	}
	
    private:

	Chain _result;
    };

    
    void serveSession(CegoAdminHandler *pAH);
    bool serveRequest(CegoAdminHandler *pAH, CegoAdminHandler::RequestType reqType);

    void srvGetTableSetList(CegoAdminHandler *pAH);
    void srvGetTSInfo(CegoAdminHandler *pAH);
    void srvGetDetailedTSInfo(CegoAdminHandler *pAH);

    void srvLockInfo(CegoAdminHandler *pAH);
    void srvLockStat(CegoAdminHandler *pAH);
    void srvParameterInfo(CegoAdminHandler *pAH);
    void srvPoolInfo(CegoAdminHandler *pAH);
    void srvPoolEntryList(CegoAdminHandler *pAH);
    void srvThreadInfo(CegoAdminHandler *pAH);

    void srvDbThreadInfo(CegoAdminHandler *pAH);
    void srvDbThreadHistory(CegoAdminHandler *pAH);

    void srvQueryHistoryLast(CegoAdminHandler *pAH);
    void srvQueryHistoryCost(CegoAdminHandler *pAH);

    void srvNumQueryLast(CegoAdminHandler *pAH);
    void srvNumQueryCost(CegoAdminHandler *pAH);
    
    void srvAdmThreadInfo(CegoAdminHandler *pAH);
    void srvDbThreadAbort(CegoAdminHandler *pAH);

    void srvShowQueryCache(CegoAdminHandler *pAH);
    void srvListQueryCache(CegoAdminHandler *pAH);
    void srvCleanQueryCache(CegoAdminHandler *pAH);
    void srvSetQueryCacheParam(CegoAdminHandler *pAH);

    void srvShowTableCache(CegoAdminHandler *pAH);
    void srvListTableCache(CegoAdminHandler *pAH);
    void srvCleanTableCache(CegoAdminHandler *pAH);
    void srvSetTableCacheParam(CegoAdminHandler *pAH);

    void srvDefineTableSet(CegoAdminHandler *pAH);
    void srvRemoveTableSet(CegoAdminHandler *pAH);
    void srvResetTableSet(CegoAdminHandler *pAH);
    void srvCreateTableSet(CegoAdminHandler *pAH);
    void srvDropTableSet(CegoAdminHandler *pAH);
    void srvStartTableSet(CegoAdminHandler *pAH);
    void srvStopTableSet(CegoAdminHandler *pAH);
    void srvDumpObject(CegoAdminHandler *pAH);
    void srvSetLogMng(CegoAdminHandler *pAH);
    void srvShowLogMng(CegoAdminHandler *pAH);
    void srvSetBackupMng(CegoAdminHandler *pAH);
    void srvShowBackupMng(CegoAdminHandler *pAH);
    void srvSetCheckpoint(CegoAdminHandler *pAH);
    void srvSetTSInitFile(CegoAdminHandler *pAH);
    void srvSetTSSysSize(CegoAdminHandler *pAH);
    void srvSetTSTmpSize(CegoAdminHandler *pAH);
    void srvSetTSAppSize(CegoAdminHandler *pAH);
    void srvSetTSRootPath(CegoAdminHandler *pAH);
    void srvSetTSLogNum(CegoAdminHandler *pAH);
    void srvSetTSLogSize(CegoAdminHandler *pAH);
    void srvSetTSSortAreaSize(CegoAdminHandler *pAH);
    void srvSetTSLogUser(CegoAdminHandler *pAH);

    void srvStartRecovery(CegoAdminHandler *pAH);	      	
    void srvStopRecovery(CegoAdminHandler *pAH);
    void srvGetDbSpec(CegoAdminHandler *pAH);
    void srvGetDbInfo(CegoAdminHandler *pAH);
    
    void srvGetArchLogInfo(CegoAdminHandler *pAH);
    void srvGetTransactionInfo(CegoAdminHandler *pAH);
    void srvGetBUStatInfo(CegoAdminHandler *pAH);

    void srvSetLSN(CegoAdminHandler *pAH);
    void srvExportTableSet(CegoAdminHandler *pAH);
    void srvImportTableSet(CegoAdminHandler *pAH);
    void srvExportTable(CegoAdminHandler *pAH);
    void srvImportTable(CegoAdminHandler *pAH);
    void srvAddDatafile(CegoAdminHandler *pAH);

    void srvUserInfo(CegoAdminHandler *pAH);
    void srvAddUser(CegoAdminHandler *pAH);
    void srvRemoveUser(CegoAdminHandler *pAH);
    void srvChangePwd(CegoAdminHandler *pAH);
    void srvListRole(CegoAdminHandler *pAH);
    void srvShowRole(CegoAdminHandler *pAH);
    void srvCreateRole(CegoAdminHandler *pAH);
    void srvDropRole(CegoAdminHandler *pAH);
    void srvAssignRole(CegoAdminHandler *pAH);
    void srvRemoveRole(CegoAdminHandler *pAH);
    void srvSetPerm(CegoAdminHandler *pAH);
    void srvRemovePerm(CegoAdminHandler *pAH);
    void srvUserTrace(CegoAdminHandler *pAH);

    void srvSyncTableSet(CegoAdminHandler *pAH);
    void srvInitLogs(CegoAdminHandler *pAH);

    void srvAddArchLog(CegoAdminHandler *pAH);
    void srvRemoveArchLog(CegoAdminHandler *pAH);

    void srvBeginBackup(CegoAdminHandler *pAH);
    void srvExecuteBackup(CegoAdminHandler *pAH);
    void srvEndBackup(CegoAdminHandler *pAH);
    void srvListBackup(CegoAdminHandler *pAH);
    
    void srvRestore(CegoAdminHandler *pAH);
    void srvRecover(CegoAdminHandler *pAH);

    void srvEnableTableCache(CegoAdminHandler *pAH);
    void srvDisableTableCache(CegoAdminHandler *pAH);

    void srvEnableQueryCache(CegoAdminHandler *pAH);
    void srvDisableQueryCache(CegoAdminHandler *pAH);

    void srvVerifyTableSet(CegoAdminHandler *pAH);
    void srvCorrectTableSet(CegoAdminHandler *pAH);

    void srvEnableArchLog(CegoAdminHandler *pAH);
    void srvDisableArchLog(CegoAdminHandler *pAH);

    void srvEnableAppendMode(CegoAdminHandler *pAH);
    void srvDisableAppendMode(CegoAdminHandler *pAH);

    void srvEnableAutoCorrect(CegoAdminHandler *pAH);
    void srvDisableAutoCorrect(CegoAdminHandler *pAH);

    void srvResetBUStat(CegoAdminHandler *pAH);

    
    // mediator services

    /*
    void medNotify(CegoAdminHandler *pAH);
    void medDefineTableSet(CegoAdminHandler *pAH);
    void medRemoveTableSet(CegoAdminHandler *pAH);
    void medResetTableSet(CegoAdminHandler *pAH);

    void medCreateTableSet(CegoAdminHandler *pAH);
    void medDropTableSet(CegoAdminHandler *pAH);

    void medStartTableSet(CegoAdminHandler *pAH);
    void medStopTableSet(CegoAdminHandler *pAH);

    void medCopyTableSet(CegoAdminHandler *pAH);
    void medSwitchTableSet(CegoAdminHandler *pAH);

    void medAddArchLog(CegoAdminHandler *pAH);
    void medRemoveArchLog(CegoAdminHandler *pAH);
    void medAddDatafile(CegoAdminHandler *pAH);

    void medGetDetailedTableSetInfo(CegoAdminHandler *pAH);
    void medGetArchLogInfo(CegoAdminHandler *pAH);

    void medGetObjectInfo(CegoAdminHandler *pAH);
    void medGetTransactionInfo(CegoAdminHandler *pAH);
    void medGetBUStatInfo(CegoAdminHandler *pAH);


    void medBeginBackup(CegoAdminHandler *pAH);
    void medExecuteBackup(CegoAdminHandler *pAH);
    void medEndBackup(CegoAdminHandler *pAH);
    void medListBackup(CegoAdminHandler *pAH);
    void medRestore(CegoAdminHandler *pAH);
    void medRecover(CegoAdminHandler *pAH);
    void medSecSwitch(CegoAdminHandler *pAH);

    void medSecRelocate(CegoAdminHandler *pAH);

    // secondary services
    void secMedSwitch(CegoAdminHandler *pAH);
    void secMedRelocate(CegoAdminHandler *pAH);

    */
    
    CegoAdminHandler* getSession(const Chain& role, const Chain& hostname, const Chain& user, const Chain& pwd);
    void closeSession(CegoAdminHandler* pAH);

    void addTableSetUsage(Element *pTSE);

    Element* getDetailedTSInfo(const Chain& tableSet);
    Element* getArchLogInfo(const Chain& tableSet);
    Element* getObjectInfo(const Chain& tableSet);
    Element* getTransactionInfo(const Chain& tableSet);
    Element* getBUStatInfo(const Chain& tableSet);

    Element* getBackupInfo(const Chain& tableSet, const Chain& pit);
    
    Element* checkTS(const Chain& hostType, const Chain& hostName, Element *pInfo, CegoAdminHandler *pPAH, CegoAdminHandler *pSAH);

    Chain executeBackup(CegoAdminHandler* pAH, const Chain& tableSet, const Chain& msg);
    ListT<Chain> executeListBackup(const Chain& tableSet, const Chain& pit);
    Chain executeRestore(CegoAdminHandler* pAH, const Chain& tableSet, const Chain& backupId);

    Chain executeLogInfo(const Chain& tableSet, const Chain& archPath);
	
    unsigned long long _idx;

    CegoDatabaseManager* _pDBMng;
    CegoAdminThreadPool* _pPool;
    NetHandler* _pRequest;
    CegoQueryManager* _pTabMng;

    CegoDbThreadPool* _pDbPool;

    Chain _lastAction;

    Chain _user;
    Chain _password;

    NanoTimer* _pTim;

    unsigned long _modId;
};
#endif
