//
// File: CegoAdm.cc
// This code was produced by the dragon parser generator
//
#include "CegoAdm.h"
#include <lfcbase/Exception.h>
#include <lfcbase/StackT.h>

CegoAdm::ScannerStateEntry::ScannerStateEntry()
{
}

CegoAdm::ScannerStateEntry::ScannerStateEntry(unsigned state, ScannerStateType type)
{
   _state = state;
   _type = type;
}

CegoAdm::ScannerStateEntry& CegoAdm::ScannerStateEntry::operator = (const CegoAdm::ScannerStateEntry& s)
{
   _state = s._state;
   _type = s._type;
   return(*this);
}

bool CegoAdm::ScannerStateEntry::operator == (const CegoAdm::ScannerStateEntry& s)
{
   if ( _state == s._state )
      return true;
   return false;
}

CegoAdm::ScannerStateType CegoAdm::ScannerStateEntry::getType()
{
   return _type;
}
unsigned CegoAdm::ScannerStateEntry::getState()
{
   return _state;
}


CegoAdm::ScannerTransEntry::ScannerTransEntry()
{
}

CegoAdm::ScannerTransEntry::ScannerTransEntry(unsigned state, char c)
{
   _state = state;
   _c = c;
}

CegoAdm::ScannerTransEntry::ScannerTransEntry(unsigned state, char c, unsigned fstate)
{
   _state = state;
   _c = c;
   _fstate = fstate;
}

CegoAdm::ScannerTransEntry& CegoAdm::ScannerTransEntry::operator = (const CegoAdm::ScannerTransEntry& s)
{
   _state = s._state;
   _c = s._c;
   _fstate = s._fstate;
   return(*this);
}

bool CegoAdm::ScannerTransEntry::operator == (const CegoAdm::ScannerTransEntry& s)
{
   if ( _state == s._state && _c == s._c)
      return true;
   return false;
}

unsigned CegoAdm::ScannerTransEntry::getFState()
{
   return _fstate;
}


CegoAdm::Scanner::Scanner()
{
}


CegoAdm::Scanner::Scanner(Token t)
{
   _token = t;
}

CegoAdm::Token CegoAdm::Scanner::getToken()
{
   return _token;
}

void CegoAdm::Scanner::addState(ScannerStateEntry s)
{
   _stateList.Insert(s);
}

void CegoAdm::Scanner::addTransition(ScannerTransEntry t)
{
   _transList.Insert(t);
}

bool CegoAdm::Scanner::checkPattern(const Chain& p)
{
   unsigned long state = 0;
   ScannerStateEntry* pS = _stateList.First();
   while (pS)
   {
      if (pS->getType() == START || pS->getType() == ANY)
      {
         state = pS->getState();
         pS = 0;
      }
      else
      {
         pS = _stateList.Next();
      }
   }
   unsigned long i = 0;
   ScannerTransEntry* pT = 
   _transList.Find(ScannerTransEntry(state, p[i]));
   while (pT)
   {
      ScannerStateEntry* pS = _stateList.Find(ScannerStateEntry(pT->getFState())); 
      if (pS)
      {
         if ( ( i == p.length()-2 ) && ( pS->getType() == FINAL || pS->getType() == ANY))
         {
            return true;
         }
         else
         {
            state = pT->getFState();
         }
      }
      else
      {
         return false;
      }
      i++;
      pT = _transList.Find(ScannerTransEntry(state, p[i]));
   }
   return false;
}
CegoAdm::StackEntry::StackEntry()
{
   _symbol = NONE;
}

CegoAdm::StackEntry::StackEntry(Symbol symbol, unsigned num, unsigned state, Chain tval)
{
   _symbol=symbol;
   _num=num;
   _state=state;
   _tval=tval;
}

CegoAdm::StackEntry& CegoAdm::StackEntry::operator = (const CegoAdm::StackEntry& se)
{
   _symbol=se._symbol;
   _num=se._num;
   _state=se._state;
   _tval=se._tval;
   return(*this);
}

unsigned CegoAdm::StackEntry::getState()
{
   return _state;
}
CegoAdm::Symbol CegoAdm::StackEntry::getSymbol()
{
   return _symbol;
}
Chain& CegoAdm::StackEntry::getTval()
{
   return _tval;
}

CegoAdm::ActionEntry::ActionEntry()
{
   _action=NULLACTION;
}

CegoAdm::ActionEntry::ActionEntry(Action action , unsigned num)
{
   _action=action;
   _num=num;
}

bool CegoAdm::ActionEntry::operator == (const CegoAdm::ActionEntry& ae)
{
   if (_action == ae._action && _num == ae._num)
      return true;
   return false;
}

CegoAdm::ActionEntry& CegoAdm::ActionEntry::operator = (const CegoAdm::ActionEntry& ae)
{
   _action=ae._action;
   _num=ae._num;
   return(*this);
}

CegoAdm::Action CegoAdm::ActionEntry::getAction()
{
   return _action;
}

unsigned CegoAdm::ActionEntry::getNum()
{
   return _num;
}

CegoAdm::ProdEntry::ProdEntry()
{
}

CegoAdm::ProdEntry::ProdEntry(unsigned id)
{
   _id = id;
}

CegoAdm::ProdEntry::ProdEntry(unsigned id, Production prod, unsigned numSymbol)
{
   _id = id;
   _prod = prod;
   _numSymbol = numSymbol;
}

bool CegoAdm::ProdEntry::operator == (const CegoAdm::ProdEntry& pe)
{
   if (_id == pe._id)
      return true;
   return false;
}

CegoAdm::ProdEntry& CegoAdm::ProdEntry::operator = (const CegoAdm::ProdEntry& pe)
{
   _id = pe._id;
   _prod = pe._prod;
   _numSymbol = pe._numSymbol;
   return(*this);
}


unsigned CegoAdm::ProdEntry::getId()
{
   return _id;
}

CegoAdm::Production CegoAdm::ProdEntry::getProd()
{
   return _prod;
}

unsigned CegoAdm::ProdEntry::getNumSymbol()
{
   return _numSymbol;
}
void CegoAdm::loadScanner()
{
   Scanner s0(ABORT);
   s0.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(2 ,START));
   s0.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(5 ,FINAL));
   s0.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s0.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s0.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s0.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s0.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s0);

   Scanner s1(ADD);
   s1.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(2 ,START));
   s1.addState(ScannerStateEntry(3 ,FINAL));
   s1.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s1.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s1.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s1);

   Scanner s2(ADM);
   s2.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(2 ,START));
   s2.addState(ScannerStateEntry(3 ,FINAL));
   s2.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s2.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s2.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s2);

   Scanner s3(APPENDMODE);
   s3.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(2 ,START));
   s3.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(10 ,FINAL));
   s3.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s3.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s3.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s3.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s3.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s3.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s3.addTransition(ScannerTransEntry(6 ,'m' ,7));
   s3.addTransition(ScannerTransEntry(7 ,'o' ,8));
   s3.addTransition(ScannerTransEntry(8 ,'d' ,9));
   s3.addTransition(ScannerTransEntry(9 ,'e' ,10));
   _scannerList.Insert(s3);

   Scanner s4(APPSIZE);
   s4.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(2 ,START));
   s4.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(7 ,FINAL));
   s4.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s4.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s4.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s4.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s4.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s4.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s4.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s4);

   Scanner s5(ARCHLOG);
   s5.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(2 ,START));
   s5.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(7 ,FINAL));
   s5.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s5.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s5.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s5.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s5.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s5.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s5.addTransition(ScannerTransEntry(6 ,'g' ,7));
   _scannerList.Insert(s5);

   Scanner s6(ASSIGN);
   s6.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(2 ,START));
   s6.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(6 ,FINAL));
   s6.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s6.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s6.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s6.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s6.addTransition(ScannerTransEntry(4 ,'g' ,5));
   s6.addTransition(ScannerTransEntry(5 ,'n' ,6));
   _scannerList.Insert(s6);

   Scanner s7(AUTOCORRECT);
   s7.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(2 ,START));
   s7.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(11 ,FINAL));
   s7.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s7.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s7.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s7.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s7.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s7.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s7.addTransition(ScannerTransEntry(6 ,'r' ,7));
   s7.addTransition(ScannerTransEntry(7 ,'r' ,8));
   s7.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s7.addTransition(ScannerTransEntry(9 ,'c' ,10));
   s7.addTransition(ScannerTransEntry(10 ,'t' ,11));
   _scannerList.Insert(s7);

   Scanner s8(BACKUP);
   s8.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(2 ,START));
   s8.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(6 ,FINAL));
   s8.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s8.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s8.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s8.addTransition(ScannerTransEntry(3 ,'k' ,4));
   s8.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s8.addTransition(ScannerTransEntry(5 ,'p' ,6));
   _scannerList.Insert(s8);

   Scanner s9(BACKUPMNG);
   s9.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(2 ,START));
   s9.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(9 ,FINAL));
   s9.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s9.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s9.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s9.addTransition(ScannerTransEntry(3 ,'k' ,4));
   s9.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s9.addTransition(ScannerTransEntry(5 ,'p' ,6));
   s9.addTransition(ScannerTransEntry(6 ,'m' ,7));
   s9.addTransition(ScannerTransEntry(7 ,'n' ,8));
   s9.addTransition(ScannerTransEntry(8 ,'g' ,9));
   _scannerList.Insert(s9);

   Scanner s10(BEGIN_TOKEN);
   s10.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(2 ,START));
   s10.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(5 ,FINAL));
   s10.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s10.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s10.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s10.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s10.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s10);

   Scanner s11(BINARY);
   s11.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(2 ,START));
   s11.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(6 ,FINAL));
   s11.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s11.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s11.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s11.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s11.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s11.addTransition(ScannerTransEntry(5 ,'y' ,6));
   _scannerList.Insert(s11);

   Scanner s12(BRANCHID);
   s12.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(2 ,START));
   s12.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(8 ,FINAL));
   s12.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s12.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s12.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s12.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s12.addTransition(ScannerTransEntry(5 ,'h' ,6));
   s12.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s12.addTransition(ScannerTransEntry(7 ,'d' ,8));
   _scannerList.Insert(s12);

   Scanner s13(BUFILE);
   s13.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(2 ,START));
   s13.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(6 ,FINAL));
   s13.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s13.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s13.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s13.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s13.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s13);

   Scanner s14(BUSTAT);
   s14.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(2 ,START));
   s14.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(6 ,FINAL));
   s14.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s14.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s14.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s14.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s14.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s14.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s14);

   Scanner s15(TSTICKET);
   s15.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(2 ,START));
   s15.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(8 ,FINAL));
   s15.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s15.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s15.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s15.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s15.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s15.addTransition(ScannerTransEntry(5 ,'k' ,6));
   s15.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s15.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s15);

   Scanner s16(BY);
   s16.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(1 ,FINAL));
   s16.addState(ScannerStateEntry(2 ,START));
   s16.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s16.addTransition(ScannerTransEntry(2 ,'b' ,0));
   _scannerList.Insert(s16);

   Scanner s17(CHECKPOINT);
   s17.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(2 ,START));
   s17.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(10 ,FINAL));
   s17.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s17.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s17.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s17.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s17.addTransition(ScannerTransEntry(4 ,'k' ,5));
   s17.addTransition(ScannerTransEntry(5 ,'p' ,6));
   s17.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s17.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s17.addTransition(ScannerTransEntry(8 ,'n' ,9));
   s17.addTransition(ScannerTransEntry(9 ,'t' ,10));
   _scannerList.Insert(s17);

   Scanner s18(CLEAN);
   s18.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(2 ,START));
   s18.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(5 ,FINAL));
   s18.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s18.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s18.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s18.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s18.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s18);

   Scanner s19(CLEANUP);
   s19.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(2 ,START));
   s19.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(7 ,FINAL));
   s19.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s19.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s19.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s19.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s19.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s19.addTransition(ScannerTransEntry(5 ,'u' ,6));
   s19.addTransition(ScannerTransEntry(6 ,'p' ,7));
   _scannerList.Insert(s19);

   Scanner s20(CLOSE);
   s20.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(2 ,START));
   s20.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(5 ,FINAL));
   s20.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s20.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s20.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s20.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s20.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s20);

   Scanner s21(CONNECT);
   s21.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(2 ,START));
   s21.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(7 ,FINAL));
   s21.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s21.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s21.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s21.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s21.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s21.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s21.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s21);

   Scanner s22(CORRECT);
   s22.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(2 ,START));
   s22.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(7 ,FINAL));
   s22.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s22.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s22.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s22.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s22.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s22.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s22.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s22);

   Scanner s23(COST);
   s23.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(2 ,START));
   s23.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(4 ,FINAL));
   s23.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s23.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s23.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s23.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s23);

   Scanner s24(CPDUMP);
   s24.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(2 ,START));
   s24.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(6 ,FINAL));
   s24.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s24.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s24.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s24.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s24.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s24.addTransition(ScannerTransEntry(5 ,'p' ,6));
   _scannerList.Insert(s24);

   Scanner s25(CREATE);
   s25.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(2 ,START));
   s25.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(6 ,FINAL));
   s25.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s25.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s25.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s25.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s25.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s25.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s25);

   Scanner s26(DATAFILE);
   s26.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(2 ,START));
   s26.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(8 ,FINAL));
   s26.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s26.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s26.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s26.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s26.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s26.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s26.addTransition(ScannerTransEntry(6 ,'l' ,7));
   s26.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s26);

   Scanner s27(DB);
   s27.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(1 ,FINAL));
   s27.addState(ScannerStateEntry(2 ,START));
   s27.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s27.addTransition(ScannerTransEntry(2 ,'d' ,0));
   _scannerList.Insert(s27);

   Scanner s28(DEFINE);
   s28.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(2 ,START));
   s28.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(6 ,FINAL));
   s28.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s28.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s28.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s28.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s28.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s28.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s28);

   Scanner s29(DISABLE);
   s29.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(2 ,START));
   s29.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(7 ,FINAL));
   s29.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s29.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s29.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s29.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s29.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s29.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s29.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s29);

   Scanner s30(DROP);
   s30.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(2 ,START));
   s30.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(4 ,FINAL));
   s30.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s30.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s30.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s30.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s30);

   Scanner s31(DUMP);
   s31.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(2 ,START));
   s31.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(4 ,FINAL));
   s31.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s31.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s31.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s31.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s31);

   Scanner s32(ENABLE);
   s32.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(2 ,START));
   s32.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(6 ,FINAL));
   s32.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s32.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s32.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s32.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s32.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s32.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s32);

   Scanner s33(END_TOKEN);
   s33.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(2 ,START));
   s33.addState(ScannerStateEntry(3 ,FINAL));
   s33.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s33.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s33.addTransition(ScannerTransEntry(2 ,'e' ,0));
   _scannerList.Insert(s33);

   Scanner s34(MAXENTRY);
   s34.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(2 ,START));
   s34.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(8 ,FINAL));
   s34.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s34.addTransition(ScannerTransEntry(1 ,'x' ,3));
   s34.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s34.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s34.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s34.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s34.addTransition(ScannerTransEntry(6 ,'r' ,7));
   s34.addTransition(ScannerTransEntry(7 ,'y' ,8));
   _scannerList.Insert(s34);

   Scanner s35(EXPORT);
   s35.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(2 ,START));
   s35.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(6 ,FINAL));
   s35.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s35.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s35.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s35.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s35.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s35.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s35);

   Scanner s36(FILE);
   s36.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(2 ,START));
   s36.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(4 ,FINAL));
   s36.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s36.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s36.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s36.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s36);

   Scanner s37(FILTER);
   s37.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(2 ,START));
   s37.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(6 ,FINAL));
   s37.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s37.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s37.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s37.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s37.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s37.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s37);

   Scanner s38(FOR);
   s38.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(2 ,START));
   s38.addState(ScannerStateEntry(3 ,FINAL));
   s38.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s38.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s38.addTransition(ScannerTransEntry(2 ,'f' ,0));
   _scannerList.Insert(s38);

   Scanner s39(FORCELOAD);
   s39.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(2 ,START));
   s39.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(9 ,FINAL));
   s39.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s39.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s39.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s39.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s39.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s39.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s39.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s39.addTransition(ScannerTransEntry(7 ,'a' ,8));
   s39.addTransition(ScannerTransEntry(8 ,'d' ,9));
   _scannerList.Insert(s39);

   Scanner s40(FROM);
   s40.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(2 ,START));
   s40.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(4 ,FINAL));
   s40.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s40.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s40.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s40.addTransition(ScannerTransEntry(3 ,'m' ,4));
   _scannerList.Insert(s40);

   Scanner s41(GETDBSPEC);
   s41.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(2 ,START));
   s41.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(9 ,FINAL));
   s41.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s41.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s41.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s41.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s41.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s41.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s41.addTransition(ScannerTransEntry(6 ,'p' ,7));
   s41.addTransition(ScannerTransEntry(7 ,'e' ,8));
   s41.addTransition(ScannerTransEntry(8 ,'c' ,9));
   _scannerList.Insert(s41);

   Scanner s42(GETTSLIST);
   s42.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(2 ,START));
   s42.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(9 ,FINAL));
   s42.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s42.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s42.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s42.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s42.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s42.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s42.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s42.addTransition(ScannerTransEntry(7 ,'s' ,8));
   s42.addTransition(ScannerTransEntry(8 ,'t' ,9));
   _scannerList.Insert(s42);

   Scanner s43(GETNODELIST);
   s43.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(2 ,START));
   s43.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(11 ,FINAL));
   s43.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s43.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s43.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s43.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s43.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s43.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s43.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s43.addTransition(ScannerTransEntry(7 ,'l' ,8));
   s43.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s43.addTransition(ScannerTransEntry(9 ,'s' ,10));
   s43.addTransition(ScannerTransEntry(10 ,'t' ,11));
   _scannerList.Insert(s43);

   Scanner s44(GETDBINFO);
   s44.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(2 ,START));
   s44.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(9 ,FINAL));
   s44.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s44.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s44.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s44.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s44.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s44.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s44.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s44.addTransition(ScannerTransEntry(7 ,'f' ,8));
   s44.addTransition(ScannerTransEntry(8 ,'o' ,9));
   _scannerList.Insert(s44);

   Scanner s45(HASHRANGE);
   s45.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(2 ,START));
   s45.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(9 ,FINAL));
   s45.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s45.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s45.addTransition(ScannerTransEntry(2 ,'h' ,0));
   s45.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s45.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s45.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s45.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s45.addTransition(ScannerTransEntry(7 ,'g' ,8));
   s45.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s45);

   Scanner s46(IMPORT);
   s46.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(2 ,START));
   s46.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(6 ,FINAL));
   s46.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s46.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s46.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s46.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s46.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s46.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s46);

   Scanner s47(INITFILE);
   s47.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(2 ,START));
   s47.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(8 ,FINAL));
   s47.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s47.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s47.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s47.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s47.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s47.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s47.addTransition(ScannerTransEntry(6 ,'l' ,7));
   s47.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s47);

   Scanner s48(KEEP);
   s48.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(2 ,START));
   s48.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(4 ,FINAL));
   s48.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s48.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s48.addTransition(ScannerTransEntry(2 ,'k' ,0));
   s48.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s48);

   Scanner s49(LAST);
   s49.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(2 ,START));
   s49.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(4 ,FINAL));
   s49.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s49.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s49.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s49.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s49);

   Scanner s50(LIST);
   s50.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(2 ,START));
   s50.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(4 ,FINAL));
   s50.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s50.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s50.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s50.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s50);

   Scanner s51(LSN);
   s51.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(2 ,START));
   s51.addState(ScannerStateEntry(3 ,FINAL));
   s51.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s51.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s51.addTransition(ScannerTransEntry(2 ,'l' ,0));
   _scannerList.Insert(s51);

   Scanner s52(LOCK);
   s52.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(2 ,START));
   s52.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(4 ,FINAL));
   s52.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s52.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s52.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s52.addTransition(ScannerTransEntry(3 ,'k' ,4));
   _scannerList.Insert(s52);

   Scanner s53(LOCKSTAT);
   s53.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(2 ,START));
   s53.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(8 ,FINAL));
   s53.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s53.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s53.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s53.addTransition(ScannerTransEntry(3 ,'k' ,4));
   s53.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s53.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s53.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s53.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s53);

   Scanner s54(LOG);
   s54.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(2 ,START));
   s54.addState(ScannerStateEntry(3 ,FINAL));
   s54.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s54.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s54.addTransition(ScannerTransEntry(2 ,'l' ,0));
   _scannerList.Insert(s54);

   Scanner s55(LOGFILE);
   s55.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(2 ,START));
   s55.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(7 ,FINAL));
   s55.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s55.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s55.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s55.addTransition(ScannerTransEntry(3 ,'f' ,4));
   s55.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s55.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s55.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s55);

   Scanner s56(LOGMNG);
   s56.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(2 ,START));
   s56.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(6 ,FINAL));
   s56.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s56.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s56.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s56.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s56.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s56.addTransition(ScannerTransEntry(5 ,'g' ,6));
   _scannerList.Insert(s56);

   Scanner s57(LOGNUM);
   s57.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(2 ,START));
   s57.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(6 ,FINAL));
   s57.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s57.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s57.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s57.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s57.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s57.addTransition(ScannerTransEntry(5 ,'m' ,6));
   _scannerList.Insert(s57);

   Scanner s58(LOGSIZE);
   s58.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(2 ,START));
   s58.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(7 ,FINAL));
   s58.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s58.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s58.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s58.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s58.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s58.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s58.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s58);

   Scanner s59(LOGUSER);
   s59.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(2 ,START));
   s59.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(7 ,FINAL));
   s59.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s59.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s59.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s59.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s59.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s59.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s59.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s59);

   Scanner s60(IDENTIFIED);
   s60.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(2 ,START));
   s60.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(10 ,FINAL));
   s60.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s60.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s60.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s60.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s60.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s60.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s60.addTransition(ScannerTransEntry(6 ,'f' ,7));
   s60.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s60.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s60.addTransition(ScannerTransEntry(9 ,'d' ,10));
   _scannerList.Insert(s60);

   Scanner s61(UINDEX);
   s61.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(2 ,START));
   s61.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(6 ,FINAL));
   s61.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s61.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s61.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s61.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s61.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s61.addTransition(ScannerTransEntry(5 ,'x' ,6));
   _scannerList.Insert(s61);

   Scanner s62(MAXSIZE);
   s62.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(2 ,START));
   s62.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(7 ,FINAL));
   s62.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s62.addTransition(ScannerTransEntry(1 ,'x' ,3));
   s62.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s62.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s62.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s62.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s62.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s62);

   Scanner s63(MEDIATOR);
   s63.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(2 ,START));
   s63.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(8 ,FINAL));
   s63.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s63.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s63.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s63.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s63.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s63.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s63.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s63.addTransition(ScannerTransEntry(7 ,'r' ,8));
   _scannerList.Insert(s63);

   Scanner s64(MESSAGE);
   s64.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(2 ,START));
   s64.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(7 ,FINAL));
   s64.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s64.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s64.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s64.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s64.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s64.addTransition(ScannerTransEntry(5 ,'g' ,6));
   s64.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s64);

   Scanner s65(NODE);
   s65.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(2 ,START));
   s65.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(4 ,FINAL));
   s65.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s65.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s65.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s65.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s65);

   Scanner s66(NOINIT);
   s66.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(2 ,START));
   s66.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(6 ,FINAL));
   s66.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s66.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s66.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s66.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s66.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s66.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s66);

   Scanner s67(OBJECT);
   s67.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(2 ,START));
   s67.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(6 ,FINAL));
   s67.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s67.addTransition(ScannerTransEntry(1 ,'j' ,3));
   s67.addTransition(ScannerTransEntry(2 ,'o' ,0));
   s67.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s67.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s67.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s67);

   Scanner s68(OFF);
   s68.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(2 ,START));
   s68.addState(ScannerStateEntry(3 ,FINAL));
   s68.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s68.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s68.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s68);

   Scanner s69(ON);
   s69.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(1 ,FINAL));
   s69.addState(ScannerStateEntry(2 ,START));
   s69.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s69.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s69);

   Scanner s70(PARAMETER);
   s70.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(2 ,START));
   s70.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(9 ,FINAL));
   s70.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s70.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s70.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s70.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s70.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s70.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s70.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s70.addTransition(ScannerTransEntry(7 ,'e' ,8));
   s70.addTransition(ScannerTransEntry(8 ,'r' ,9));
   _scannerList.Insert(s70);

   Scanner s71(PATH);
   s71.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(2 ,START));
   s71.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(4 ,FINAL));
   s71.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s71.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s71.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s71.addTransition(ScannerTransEntry(3 ,'h' ,4));
   _scannerList.Insert(s71);

   Scanner s72(PASSWD);
   s72.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(2 ,START));
   s72.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(6 ,FINAL));
   s72.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s72.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s72.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s72.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s72.addTransition(ScannerTransEntry(4 ,'w' ,5));
   s72.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s72);

   Scanner s73(PERMISSION);
   s73.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(2 ,START));
   s73.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(10 ,FINAL));
   s73.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s73.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s73.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s73.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s73.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s73.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s73.addTransition(ScannerTransEntry(6 ,'s' ,7));
   s73.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s73.addTransition(ScannerTransEntry(8 ,'o' ,9));
   s73.addTransition(ScannerTransEntry(9 ,'n' ,10));
   _scannerList.Insert(s73);

   Scanner s74(PIT);
   s74.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(2 ,START));
   s74.addState(ScannerStateEntry(3 ,FINAL));
   s74.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s74.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s74.addTransition(ScannerTransEntry(2 ,'p' ,0));
   _scannerList.Insert(s74);

   Scanner s75(PLAIN);
   s75.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(2 ,START));
   s75.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(5 ,FINAL));
   s75.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s75.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s75.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s75.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s75.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s75);

   Scanner s76(POOL);
   s76.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(2 ,START));
   s76.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(4 ,FINAL));
   s76.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s76.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s76.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s76.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s76);

   Scanner s77(QUERYCACHE);
   s77.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(2 ,START));
   s77.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(10 ,FINAL));
   s77.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s77.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s77.addTransition(ScannerTransEntry(2 ,'q' ,0));
   s77.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s77.addTransition(ScannerTransEntry(4 ,'y' ,5));
   s77.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s77.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s77.addTransition(ScannerTransEntry(7 ,'c' ,8));
   s77.addTransition(ScannerTransEntry(8 ,'h' ,9));
   s77.addTransition(ScannerTransEntry(9 ,'e' ,10));
   _scannerList.Insert(s77);

   Scanner s78(QUERYHIST);
   s78.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(2 ,START));
   s78.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(9 ,FINAL));
   s78.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s78.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s78.addTransition(ScannerTransEntry(2 ,'q' ,0));
   s78.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s78.addTransition(ScannerTransEntry(4 ,'y' ,5));
   s78.addTransition(ScannerTransEntry(5 ,'h' ,6));
   s78.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s78.addTransition(ScannerTransEntry(7 ,'s' ,8));
   s78.addTransition(ScannerTransEntry(8 ,'t' ,9));
   _scannerList.Insert(s78);

   Scanner s79(QUIT);
   s79.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(2 ,START));
   s79.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(4 ,FINAL));
   s79.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s79.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s79.addTransition(ScannerTransEntry(2 ,'q' ,0));
   s79.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s79);

   Scanner s80(RAWMODE);
   s80.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(2 ,START));
   s80.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(7 ,FINAL));
   s80.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s80.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s80.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s80.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s80.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s80.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s80.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s80);

   Scanner s81(RELOCATE);
   s81.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(2 ,START));
   s81.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(8 ,FINAL));
   s81.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s81.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s81.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s81.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s81.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s81.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s81.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s81.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s81);

   Scanner s82(REMOVE);
   s82.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(2 ,START));
   s82.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(6 ,FINAL));
   s82.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s82.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s82.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s82.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s82.addTransition(ScannerTransEntry(4 ,'v' ,5));
   s82.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s82);

   Scanner s83(RECOVER);
   s83.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(2 ,START));
   s83.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(7 ,FINAL));
   s83.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s83.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s83.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s83.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s83.addTransition(ScannerTransEntry(4 ,'v' ,5));
   s83.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s83.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s83);

   Scanner s84(RECOVERY);
   s84.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(2 ,START));
   s84.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(8 ,FINAL));
   s84.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s84.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s84.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s84.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s84.addTransition(ScannerTransEntry(4 ,'v' ,5));
   s84.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s84.addTransition(ScannerTransEntry(6 ,'r' ,7));
   s84.addTransition(ScannerTransEntry(7 ,'y' ,8));
   _scannerList.Insert(s84);

   Scanner s85(RESET);
   s85.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(2 ,START));
   s85.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(5 ,FINAL));
   s85.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s85.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s85.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s85.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s85.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s85);

   Scanner s86(RESTORE);
   s86.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(2 ,START));
   s86.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(7 ,FINAL));
   s86.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s86.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s86.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s86.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s86.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s86.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s86.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s86);

   Scanner s87(RIGHT);
   s87.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(2 ,START));
   s87.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(5 ,FINAL));
   s87.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s87.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s87.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s87.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s87.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s87);

   Scanner s88(ROLE);
   s88.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(2 ,START));
   s88.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(4 ,FINAL));
   s88.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s88.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s88.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s88.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s88);

   Scanner s89(SESSION);
   s89.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(2 ,START));
   s89.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(7 ,FINAL));
   s89.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s89.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s89.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s89.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s89.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s89.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s89.addTransition(ScannerTransEntry(6 ,'n' ,7));
   _scannerList.Insert(s89);

   Scanner s90(SET);
   s90.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(2 ,START));
   s90.addState(ScannerStateEntry(3 ,FINAL));
   s90.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s90.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s90.addTransition(ScannerTransEntry(2 ,'s' ,0));
   _scannerList.Insert(s90);

   Scanner s91(SIZE);
   s91.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(2 ,START));
   s91.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(4 ,FINAL));
   s91.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s91.addTransition(ScannerTransEntry(1 ,'z' ,3));
   s91.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s91.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s91);

   Scanner s92(SORTAREASIZE);
   s92.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(2 ,START));
   s92.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(11 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(12 ,FINAL));
   s92.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s92.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s92.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s92.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s92.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s92.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s92.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s92.addTransition(ScannerTransEntry(7 ,'a' ,8));
   s92.addTransition(ScannerTransEntry(8 ,'s' ,9));
   s92.addTransition(ScannerTransEntry(9 ,'i' ,10));
   s92.addTransition(ScannerTransEntry(10 ,'z' ,11));
   s92.addTransition(ScannerTransEntry(11 ,'e' ,12));
   _scannerList.Insert(s92);

   Scanner s93(STRUCTURE);
   s93.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(2 ,START));
   s93.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(9 ,FINAL));
   s93.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s93.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s93.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s93.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s93.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s93.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s93.addTransition(ScannerTransEntry(6 ,'u' ,7));
   s93.addTransition(ScannerTransEntry(7 ,'r' ,8));
   s93.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s93);

   Scanner s94(SHOW);
   s94.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(2 ,START));
   s94.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(4 ,FINAL));
   s94.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s94.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s94.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s94.addTransition(ScannerTransEntry(3 ,'w' ,4));
   _scannerList.Insert(s94);

   Scanner s95(START_TOK);
   s95.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(2 ,START));
   s95.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(5 ,FINAL));
   s95.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s95.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s95.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s95.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s95.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s95);

   Scanner s96(STOP_TOK);
   s96.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(2 ,START));
   s96.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(4 ,FINAL));
   s96.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s96.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s96.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s96.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s96);

   Scanner s97(SWITCH);
   s97.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(2 ,START));
   s97.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(6 ,FINAL));
   s97.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s97.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s97.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s97.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s97.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s97.addTransition(ScannerTransEntry(5 ,'h' ,6));
   _scannerList.Insert(s97);

   Scanner s98(SYNC);
   s98.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(2 ,START));
   s98.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(4 ,FINAL));
   s98.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s98.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s98.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s98.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s98);

   Scanner s99(SYSSIZE);
   s99.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(2 ,START));
   s99.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(7 ,FINAL));
   s99.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s99.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s99.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s99.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s99.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s99.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s99.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s99);

   Scanner s100(TABLE);
   s100.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(2 ,START));
   s100.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(5 ,FINAL));
   s100.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s100.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s100.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s100.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s100.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s100);

   Scanner s101(TABLECACHE);
   s101.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(2 ,START));
   s101.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(10 ,FINAL));
   s101.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s101.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s101.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s101.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s101.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s101.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s101.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s101.addTransition(ScannerTransEntry(7 ,'c' ,8));
   s101.addTransition(ScannerTransEntry(8 ,'h' ,9));
   s101.addTransition(ScannerTransEntry(9 ,'e' ,10));
   _scannerList.Insert(s101);

   Scanner s102(TABLESET);
   s102.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(2 ,START));
   s102.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(8 ,FINAL));
   s102.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s102.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s102.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s102.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s102.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s102.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s102.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s102.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s102);

   Scanner s103(TIMEOUT);
   s103.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(2 ,START));
   s103.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(7 ,FINAL));
   s103.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s103.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s103.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s103.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s103.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s103.addTransition(ScannerTransEntry(5 ,'u' ,6));
   s103.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s103);

   Scanner s104(THREAD);
   s104.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(2 ,START));
   s104.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(6 ,FINAL));
   s104.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s104.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s104.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s104.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s104.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s104);

   Scanner s105(THREADINFO);
   s105.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(2 ,START));
   s105.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(10 ,FINAL));
   s105.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s105.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s105.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s105.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s105.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s105.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s105.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s105.addTransition(ScannerTransEntry(7 ,'n' ,8));
   s105.addTransition(ScannerTransEntry(8 ,'f' ,9));
   s105.addTransition(ScannerTransEntry(9 ,'o' ,10));
   _scannerList.Insert(s105);

   Scanner s106(THRESHOLD);
   s106.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(2 ,START));
   s106.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(9 ,FINAL));
   s106.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s106.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s106.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s106.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s106.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s106.addTransition(ScannerTransEntry(5 ,'h' ,6));
   s106.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s106.addTransition(ScannerTransEntry(7 ,'l' ,8));
   s106.addTransition(ScannerTransEntry(8 ,'d' ,9));
   _scannerList.Insert(s106);

   Scanner s107(TMPSIZE);
   s107.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(2 ,START));
   s107.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(7 ,FINAL));
   s107.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s107.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s107.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s107.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s107.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s107.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s107.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s107);

   Scanner s108(TO);
   s108.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(1 ,FINAL));
   s108.addState(ScannerStateEntry(2 ,START));
   s108.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s108.addTransition(ScannerTransEntry(2 ,'t' ,0));
   _scannerList.Insert(s108);

   Scanner s109(TRACE);
   s109.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(2 ,START));
   s109.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(5 ,FINAL));
   s109.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s109.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s109.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s109.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s109.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s109);

   Scanner s110(TRANSACTION);
   s110.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(2 ,START));
   s110.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(11 ,FINAL));
   s110.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s110.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s110.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s110.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s110.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s110.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s110.addTransition(ScannerTransEntry(7 ,'t' ,8));
   s110.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s110.addTransition(ScannerTransEntry(9 ,'o' ,10));
   s110.addTransition(ScannerTransEntry(10 ,'n' ,11));
   _scannerList.Insert(s110);

   Scanner s111(TSROOT);
   s111.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(2 ,START));
   s111.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(6 ,FINAL));
   s111.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s111.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s111.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s111.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s111.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s111.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s111);

   Scanner s112(USER);
   s112.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(2 ,START));
   s112.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(4 ,FINAL));
   s112.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s112.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s112.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s112.addTransition(ScannerTransEntry(3 ,'r' ,4));
   _scannerList.Insert(s112);

   Scanner s113(VERIFY);
   s113.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(2 ,START));
   s113.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(6 ,FINAL));
   s113.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s113.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s113.addTransition(ScannerTransEntry(2 ,'v' ,0));
   s113.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s113.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s113.addTransition(ScannerTransEntry(5 ,'y' ,6));
   _scannerList.Insert(s113);

   Scanner s114(WITH);
   s114.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(2 ,START));
   s114.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(4 ,FINAL));
   s114.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s114.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s114.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s114.addTransition(ScannerTransEntry(3 ,'h' ,4));
   _scannerList.Insert(s114);

   Scanner s115(XML);
   s115.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(2 ,START));
   s115.addState(ScannerStateEntry(3 ,FINAL));
   s115.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s115.addTransition(ScannerTransEntry(2 ,'x' ,0));
   _scannerList.Insert(s115);

   Scanner s116(KSEP);
   s116.addState(ScannerStateEntry(0 ,START));
   s116.addState(ScannerStateEntry(1 ,FINAL));
   s116.addTransition(ScannerTransEntry(0 ,',' ,1));
   _scannerList.Insert(s116);

   Scanner s117(SEMICOLON);
   s117.addState(ScannerStateEntry(0 ,START));
   s117.addState(ScannerStateEntry(1 ,FINAL));
   s117.addTransition(ScannerTransEntry(0 ,';' ,1));
   _scannerList.Insert(s117);

   Scanner s118(EQU);
   s118.addState(ScannerStateEntry(0 ,START));
   s118.addState(ScannerStateEntry(1 ,FINAL));
   s118.addTransition(ScannerTransEntry(0 ,'=' ,1));
   _scannerList.Insert(s118);

   Scanner s119(INTVAL);
   s119.addState(ScannerStateEntry(0 ,START));
   s119.addState(ScannerStateEntry(1 ,FINAL));
   s119.addState(ScannerStateEntry(2 ,FINAL));
   s119.addTransition(ScannerTransEntry(0 ,'1' ,1));
   s119.addTransition(ScannerTransEntry(0 ,'2' ,1));
   s119.addTransition(ScannerTransEntry(0 ,'3' ,1));
   s119.addTransition(ScannerTransEntry(0 ,'4' ,1));
   s119.addTransition(ScannerTransEntry(0 ,'5' ,1));
   s119.addTransition(ScannerTransEntry(0 ,'6' ,1));
   s119.addTransition(ScannerTransEntry(0 ,'7' ,1));
   s119.addTransition(ScannerTransEntry(0 ,'8' ,1));
   s119.addTransition(ScannerTransEntry(0 ,'9' ,1));
   s119.addTransition(ScannerTransEntry(0 ,'0' ,2));
   s119.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s119.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s119.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s119.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s119.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s119.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s119.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s119.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s119.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s119.addTransition(ScannerTransEntry(1 ,'9' ,1));
   _scannerList.Insert(s119);

   Scanner s120(IDENTIFIER);
   s120.addState(ScannerStateEntry(0 ,START));
   s120.addState(ScannerStateEntry(1 ,FINAL));
   s120.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'z' ,1));
   _scannerList.Insert(s120);

}
void CegoAdm::loadParser0()
{
   _actionMap[425][SEMICOLON] = ActionEntry(REDUCE, 33);
   _actionMap[426][SEMICOLON] = ActionEntry(REDUCE, 110);
   _actionMap[427][SEMICOLON] = ActionEntry(REDUCE, 113);
   _actionMap[406][SEMICOLON] = ActionEntry(REDUCE, 57);
   _actionMap[407][IDENTIFIER] = ActionEntry(SHIFT, 425);
   _actionMap[408][SEMICOLON] = ActionEntry(REDUCE, 140);
   _actionMap[408][SYSSIZE] = ActionEntry(REDUCE, 140);
   _actionMap[408][TMPSIZE] = ActionEntry(REDUCE, 140);
   _actionMap[408][LOGSIZE] = ActionEntry(REDUCE, 140);
   _actionMap[408][LOGNUM] = ActionEntry(REDUCE, 140);
   _actionMap[408][APPSIZE] = ActionEntry(REDUCE, 140);
   _actionMap[408][SORTAREASIZE] = ActionEntry(REDUCE, 140);
   _actionMap[408][TSROOT] = ActionEntry(REDUCE, 140);
   _actionMap[408][BRANCHID] = ActionEntry(REDUCE, 140);
   _actionMap[409][SEMICOLON] = ActionEntry(REDUCE, 143);
   _actionMap[409][SYSSIZE] = ActionEntry(REDUCE, 143);
   _actionMap[409][TMPSIZE] = ActionEntry(REDUCE, 143);
   _actionMap[409][LOGSIZE] = ActionEntry(REDUCE, 143);
   _actionMap[409][LOGNUM] = ActionEntry(REDUCE, 143);
   _actionMap[409][APPSIZE] = ActionEntry(REDUCE, 143);
   _actionMap[409][SORTAREASIZE] = ActionEntry(REDUCE, 143);
   _actionMap[409][TSROOT] = ActionEntry(REDUCE, 143);
   _actionMap[409][BRANCHID] = ActionEntry(REDUCE, 143);
   _actionMap[410][SEMICOLON] = ActionEntry(REDUCE, 139);
   _actionMap[410][SYSSIZE] = ActionEntry(REDUCE, 139);
   _actionMap[410][TMPSIZE] = ActionEntry(REDUCE, 139);
   _actionMap[410][LOGSIZE] = ActionEntry(REDUCE, 139);
   _actionMap[410][LOGNUM] = ActionEntry(REDUCE, 139);
   _actionMap[410][APPSIZE] = ActionEntry(REDUCE, 139);
   _actionMap[410][SORTAREASIZE] = ActionEntry(REDUCE, 139);
   _actionMap[410][TSROOT] = ActionEntry(REDUCE, 139);
   _actionMap[410][BRANCHID] = ActionEntry(REDUCE, 139);
   _actionMap[411][SEMICOLON] = ActionEntry(REDUCE, 138);
   _actionMap[411][SYSSIZE] = ActionEntry(REDUCE, 138);
   _actionMap[411][TMPSIZE] = ActionEntry(REDUCE, 138);
   _actionMap[411][LOGSIZE] = ActionEntry(REDUCE, 138);
   _actionMap[411][LOGNUM] = ActionEntry(REDUCE, 138);
   _actionMap[411][APPSIZE] = ActionEntry(REDUCE, 138);
   _actionMap[411][SORTAREASIZE] = ActionEntry(REDUCE, 138);
   _actionMap[411][TSROOT] = ActionEntry(REDUCE, 138);
   _actionMap[411][BRANCHID] = ActionEntry(REDUCE, 138);
   _actionMap[412][SEMICOLON] = ActionEntry(REDUCE, 141);
   _actionMap[412][SYSSIZE] = ActionEntry(REDUCE, 141);
   _actionMap[412][TMPSIZE] = ActionEntry(REDUCE, 141);
   _actionMap[412][LOGSIZE] = ActionEntry(REDUCE, 141);
   _actionMap[412][LOGNUM] = ActionEntry(REDUCE, 141);
   _actionMap[412][APPSIZE] = ActionEntry(REDUCE, 141);
   _actionMap[412][SORTAREASIZE] = ActionEntry(REDUCE, 141);
   _actionMap[412][TSROOT] = ActionEntry(REDUCE, 141);
   _actionMap[412][BRANCHID] = ActionEntry(REDUCE, 141);
}
void CegoAdm::loadParser1()
{
   _actionMap[413][SEMICOLON] = ActionEntry(REDUCE, 136);
   _actionMap[413][SYSSIZE] = ActionEntry(REDUCE, 136);
   _actionMap[413][TMPSIZE] = ActionEntry(REDUCE, 136);
   _actionMap[413][LOGSIZE] = ActionEntry(REDUCE, 136);
   _actionMap[413][LOGNUM] = ActionEntry(REDUCE, 136);
   _actionMap[413][APPSIZE] = ActionEntry(REDUCE, 136);
   _actionMap[413][SORTAREASIZE] = ActionEntry(REDUCE, 136);
   _actionMap[413][TSROOT] = ActionEntry(REDUCE, 136);
   _actionMap[413][BRANCHID] = ActionEntry(REDUCE, 136);
   _actionMap[414][SEMICOLON] = ActionEntry(REDUCE, 137);
   _actionMap[414][SYSSIZE] = ActionEntry(REDUCE, 137);
   _actionMap[414][TMPSIZE] = ActionEntry(REDUCE, 137);
   _actionMap[414][LOGSIZE] = ActionEntry(REDUCE, 137);
   _actionMap[414][LOGNUM] = ActionEntry(REDUCE, 137);
   _actionMap[414][APPSIZE] = ActionEntry(REDUCE, 137);
   _actionMap[414][SORTAREASIZE] = ActionEntry(REDUCE, 137);
   _actionMap[414][TSROOT] = ActionEntry(REDUCE, 137);
   _actionMap[414][BRANCHID] = ActionEntry(REDUCE, 137);
   _actionMap[415][SEMICOLON] = ActionEntry(REDUCE, 142);
   _actionMap[415][SYSSIZE] = ActionEntry(REDUCE, 142);
   _actionMap[415][TMPSIZE] = ActionEntry(REDUCE, 142);
   _actionMap[415][LOGSIZE] = ActionEntry(REDUCE, 142);
   _actionMap[415][LOGNUM] = ActionEntry(REDUCE, 142);
   _actionMap[415][APPSIZE] = ActionEntry(REDUCE, 142);
   _actionMap[415][SORTAREASIZE] = ActionEntry(REDUCE, 142);
   _actionMap[415][TSROOT] = ActionEntry(REDUCE, 142);
   _actionMap[415][BRANCHID] = ActionEntry(REDUCE, 142);
   _actionMap[416][STRINGVAL] = ActionEntry(SHIFT, 426);
   _actionMap[417][SEMICOLON] = ActionEntry(REDUCE, 112);
   _actionMap[418][STRINGVAL] = ActionEntry(SHIFT, 427);
   _actionMap[419][SEMICOLON] = ActionEntry(REDUCE, 115);
   _actionMap[420][SEMICOLON] = ActionEntry(REDUCE, 46);
   _actionMap[421][KSEP] = ActionEntry(REDUCE, 47);
   _actionMap[421][FOR] = ActionEntry(REDUCE, 47);
   _actionMap[422][KSEP] = ActionEntry(REDUCE, 50);
   _actionMap[422][FOR] = ActionEntry(REDUCE, 50);
   _actionMap[423][KSEP] = ActionEntry(REDUCE, 51);
   _actionMap[423][FOR] = ActionEntry(REDUCE, 51);
   _actionMap[424][KSEP] = ActionEntry(REDUCE, 49);
   _actionMap[424][FOR] = ActionEntry(REDUCE, 49);
   _actionMap[378][IDENTIFIER] = ActionEntry(SHIFT, 406);
   _actionMap[379][SEMICOLON] = ActionEntry(REDUCE, 36);
   _actionMap[380][TO] = ActionEntry(SHIFT, 407);
   _actionMap[381][INTVAL] = ActionEntry(SHIFT, 408);
   _actionMap[382][INTVAL] = ActionEntry(SHIFT, 409);
   _actionMap[383][INTVAL] = ActionEntry(SHIFT, 410);
   _actionMap[384][INTVAL] = ActionEntry(SHIFT, 411);
   _actionMap[385][INTVAL] = ActionEntry(SHIFT, 412);
   _actionMap[386][INTVAL] = ActionEntry(SHIFT, 413);
   _actionMap[387][INTVAL] = ActionEntry(SHIFT, 414);
}
void CegoAdm::loadParser2()
{
   _actionMap[388][STRINGVAL] = ActionEntry(SHIFT, 415);
   _actionMap[389][SEMICOLON] = ActionEntry(REDUCE, 116);
   _actionMap[390][TO] = ActionEntry(SHIFT, 416);
   _actionMap[391][STRINGVAL] = ActionEntry(SHIFT, 417);
   _actionMap[392][SEMICOLON] = ActionEntry(REDUCE, 111);
   _actionMap[393][FROM] = ActionEntry(SHIFT, 418);
   _actionMap[394][STRINGVAL] = ActionEntry(SHIFT, 419);
   _actionMap[395][SEMICOLON] = ActionEntry(REDUCE, 114);
   _actionMap[396][SEMICOLON] = ActionEntry(REDUCE, 144);
   _actionMap[397][SEMICOLON] = ActionEntry(REDUCE, 39);
   _actionMap[398][SEMICOLON] = ActionEntry(REDUCE, 147);
   _actionMap[399][SEMICOLON] = ActionEntry(REDUCE, 146);
   _actionMap[400][IDENTIFIER] = ActionEntry(SHIFT, 420);
   _actionMap[401][TABLESET] = ActionEntry(SHIFT, 355);
   _actionMap[401][FILTER] = ActionEntry(SHIFT, 353);
   _actionMap[401][RIGHT] = ActionEntry(SHIFT, 354);
   _jumpMap[401][PermEntry] = 421;
   _actionMap[402][STRINGVAL] = ActionEntry(SHIFT, 422);
   _actionMap[403][IDENTIFIER] = ActionEntry(SHIFT, 423);
   _actionMap[404][IDENTIFIER] = ActionEntry(SHIFT, 424);
   _actionMap[405][MESSAGE] = ActionEntry(REDUCE, 118);
   _actionMap[405][KEEP] = ActionEntry(REDUCE, 118);
   _actionMap[405][SEMICOLON] = ActionEntry(REDUCE, 118);
   _actionMap[309][TO] = ActionEntry(SHIFT, 378);
   _actionMap[310][STRINGVAL] = ActionEntry(SHIFT, 379);
   _actionMap[311][INTVAL] = ActionEntry(SHIFT, 380);
   _actionMap[312][SEMICOLON] = ActionEntry(REDUCE, 40);
   _actionMap[313][KEEP] = ActionEntry(REDUCE, 122);
   _actionMap[313][SEMICOLON] = ActionEntry(REDUCE, 122);
   _actionMap[314][SEMICOLON] = ActionEntry(REDUCE, 59);
   _actionMap[315][SEMICOLON] = ActionEntry(REDUCE, 134);
   _actionMap[315][SYSSIZE] = ActionEntry(REDUCE, 134);
   _actionMap[315][TMPSIZE] = ActionEntry(REDUCE, 134);
   _actionMap[315][LOGSIZE] = ActionEntry(REDUCE, 134);
   _actionMap[315][LOGNUM] = ActionEntry(REDUCE, 134);
   _actionMap[315][APPSIZE] = ActionEntry(REDUCE, 134);
   _actionMap[315][SORTAREASIZE] = ActionEntry(REDUCE, 134);
   _actionMap[315][TSROOT] = ActionEntry(REDUCE, 134);
   _actionMap[315][BRANCHID] = ActionEntry(REDUCE, 134);
   _actionMap[316][EQU] = ActionEntry(SHIFT, 381);
   _actionMap[317][EQU] = ActionEntry(SHIFT, 382);
   _actionMap[318][EQU] = ActionEntry(SHIFT, 383);
   _actionMap[319][EQU] = ActionEntry(SHIFT, 384);
   _actionMap[320][EQU] = ActionEntry(SHIFT, 385);
   _actionMap[321][EQU] = ActionEntry(SHIFT, 386);
   _actionMap[322][EQU] = ActionEntry(SHIFT, 387);
   _actionMap[323][EQU] = ActionEntry(SHIFT, 388);
   _actionMap[324][SEMICOLON] = ActionEntry(REDUCE, 150);
   _actionMap[325][SEMICOLON] = ActionEntry(REDUCE, 149);
   _actionMap[326][SEMICOLON] = ActionEntry(REDUCE, 61);
}
void CegoAdm::loadParser3()
{
   _actionMap[327][KEEP] = ActionEntry(SHIFT, 328);
   _actionMap[327][SEMICOLON] = ActionEntry(REDUCE, 117);
   _jumpMap[327][KeepTicketOpt] = 326;
   _actionMap[328][TSTICKET] = ActionEntry(SHIFT, 389);
   _actionMap[329][IDENTIFIER] = ActionEntry(SHIFT, 390);
   _actionMap[330][TO] = ActionEntry(SHIFT, 391);
   _actionMap[331][STRINGVAL] = ActionEntry(SHIFT, 392);
   _actionMap[332][IDENTIFIER] = ActionEntry(SHIFT, 393);
   _actionMap[333][FROM] = ActionEntry(SHIFT, 394);
   _actionMap[334][STRINGVAL] = ActionEntry(SHIFT, 395);
   _actionMap[335][SEMICOLON] = ActionEntry(REDUCE, 62);
   _actionMap[336][STRINGVAL] = ActionEntry(SHIFT, 396);
   _actionMap[337][STRINGVAL] = ActionEntry(SHIFT, 397);
   _actionMap[338][SEMICOLON] = ActionEntry(REDUCE, 58);
   _actionMap[339][SEMICOLON] = ActionEntry(REDUCE, 52);
   _actionMap[340][SEMICOLON] = ActionEntry(REDUCE, 41);
   _actionMap[341][INTVAL] = ActionEntry(SHIFT, 398);
   _actionMap[342][STRINGVAL] = ActionEntry(SHIFT, 399);
   _actionMap[343][SEMICOLON] = ActionEntry(REDUCE, 64);
   _actionMap[344][SEMICOLON] = ActionEntry(REDUCE, 74);
   _actionMap[345][SEMICOLON] = ActionEntry(REDUCE, 71);
   _actionMap[346][SEMICOLON] = ActionEntry(REDUCE, 70);
   _actionMap[347][MESSAGE] = ActionEntry(REDUCE, 120);
   _actionMap[347][KEEP] = ActionEntry(REDUCE, 120);
   _actionMap[347][SEMICOLON] = ActionEntry(REDUCE, 120);
   _actionMap[348][SEMICOLON] = ActionEntry(REDUCE, 76);
   _actionMap[349][SEMICOLON] = ActionEntry(REDUCE, 77);
   _actionMap[350][SEMICOLON] = ActionEntry(REDUCE, 79);
   _actionMap[351][FOR] = ActionEntry(SHIFT, 400);
   _actionMap[351][KSEP] = ActionEntry(SHIFT, 401);
   _actionMap[352][KSEP] = ActionEntry(REDUCE, 48);
   _actionMap[352][FOR] = ActionEntry(REDUCE, 48);
   _actionMap[353][EQU] = ActionEntry(SHIFT, 402);
   _actionMap[354][EQU] = ActionEntry(SHIFT, 403);
   _actionMap[355][EQU] = ActionEntry(SHIFT, 404);
   _actionMap[356][SEMICOLON] = ActionEntry(REDUCE, 103);
   _actionMap[357][KSEP] = ActionEntry(REDUCE, 104);
   _actionMap[357][FOR] = ActionEntry(REDUCE, 104);
   _actionMap[358][KSEP] = ActionEntry(REDUCE, 106);
   _actionMap[358][FOR] = ActionEntry(REDUCE, 106);
   _actionMap[359][KSEP] = ActionEntry(REDUCE, 108);
   _actionMap[359][FOR] = ActionEntry(REDUCE, 108);
   _actionMap[360][KSEP] = ActionEntry(REDUCE, 107);
   _actionMap[360][FOR] = ActionEntry(REDUCE, 107);
   _actionMap[361][KSEP] = ActionEntry(REDUCE, 109);
   _actionMap[361][FOR] = ActionEntry(REDUCE, 109);
   _actionMap[362][SEMICOLON] = ActionEntry(REDUCE, 78);
   _actionMap[363][SEMICOLON] = ActionEntry(REDUCE, 72);
   _actionMap[364][SEMICOLON] = ActionEntry(REDUCE, 91);
   _actionMap[365][KSEP] = ActionEntry(REDUCE, 92);
}
void CegoAdm::loadParser4()
{
   _actionMap[365][FOR] = ActionEntry(REDUCE, 92);
   _actionMap[366][KSEP] = ActionEntry(REDUCE, 96);
   _actionMap[366][FOR] = ActionEntry(REDUCE, 96);
   _actionMap[367][KSEP] = ActionEntry(REDUCE, 94);
   _actionMap[367][FOR] = ActionEntry(REDUCE, 94);
   _actionMap[368][KSEP] = ActionEntry(REDUCE, 97);
   _actionMap[368][FOR] = ActionEntry(REDUCE, 97);
   _actionMap[369][KSEP] = ActionEntry(REDUCE, 95);
   _actionMap[369][FOR] = ActionEntry(REDUCE, 95);
   _actionMap[370][SEMICOLON] = ActionEntry(REDUCE, 73);
   _actionMap[371][SEMICOLON] = ActionEntry(REDUCE, 75);
   _actionMap[372][SEMICOLON] = ActionEntry(REDUCE, 124);
   _actionMap[372][CLEANUP] = ActionEntry(REDUCE, 124);
   _actionMap[372][FORCELOAD] = ActionEntry(REDUCE, 124);
   _actionMap[372][CPDUMP] = ActionEntry(REDUCE, 124);
   _actionMap[372][NOINIT] = ActionEntry(REDUCE, 124);
   _actionMap[373][SEMICOLON] = ActionEntry(REDUCE, 126);
   _actionMap[373][CLEANUP] = ActionEntry(REDUCE, 126);
   _actionMap[373][FORCELOAD] = ActionEntry(REDUCE, 126);
   _actionMap[373][CPDUMP] = ActionEntry(REDUCE, 126);
   _actionMap[373][NOINIT] = ActionEntry(REDUCE, 126);
   _actionMap[374][SEMICOLON] = ActionEntry(REDUCE, 128);
   _actionMap[374][CLEANUP] = ActionEntry(REDUCE, 128);
   _actionMap[374][FORCELOAD] = ActionEntry(REDUCE, 128);
   _actionMap[374][CPDUMP] = ActionEntry(REDUCE, 128);
   _actionMap[374][NOINIT] = ActionEntry(REDUCE, 128);
   _actionMap[375][SEMICOLON] = ActionEntry(REDUCE, 127);
   _actionMap[375][CLEANUP] = ActionEntry(REDUCE, 127);
   _actionMap[375][FORCELOAD] = ActionEntry(REDUCE, 127);
   _actionMap[375][CPDUMP] = ActionEntry(REDUCE, 127);
   _actionMap[375][NOINIT] = ActionEntry(REDUCE, 127);
   _actionMap[376][SEMICOLON] = ActionEntry(REDUCE, 129);
   _actionMap[376][CLEANUP] = ActionEntry(REDUCE, 129);
   _actionMap[376][FORCELOAD] = ActionEntry(REDUCE, 129);
   _actionMap[376][CPDUMP] = ActionEntry(REDUCE, 129);
   _actionMap[376][NOINIT] = ActionEntry(REDUCE, 129);
   _actionMap[377][TIMEOUT] = ActionEntry(SHIFT, 278);
   _actionMap[377][MESSAGE] = ActionEntry(REDUCE, 121);
   _actionMap[377][KEEP] = ActionEntry(REDUCE, 121);
   _actionMap[377][SEMICOLON] = ActionEntry(REDUCE, 121);
   _jumpMap[377][TimeoutOpt] = 405;
   _actionMap[226][SEMICOLON] = ActionEntry(REDUCE, 24);
   _actionMap[227][STRINGVAL] = ActionEntry(SHIFT, 309);
   _actionMap[228][BY] = ActionEntry(SHIFT, 310);
   _actionMap[229][SIZE] = ActionEntry(SHIFT, 311);
   _actionMap[230][IDENTIFIER] = ActionEntry(SHIFT, 312);
   _actionMap[231][SEMICOLON] = ActionEntry(REDUCE, 60);
   _actionMap[232][STRINGVAL] = ActionEntry(SHIFT, 313);
   _actionMap[233][MESSAGE] = ActionEntry(SHIFT, 232);
   _actionMap[233][SEMICOLON] = ActionEntry(REDUCE, 123);
}
void CegoAdm::loadParser5()
{
   _jumpMap[233][MsgOption] = 314;
   _actionMap[234][SEMICOLON] = ActionEntry(REDUCE, 102);
   _actionMap[235][SEMICOLON] = ActionEntry(REDUCE, 90);
   _actionMap[236][SEMICOLON] = ActionEntry(REDUCE, 25);
   _actionMap[236][SYSSIZE] = ActionEntry(SHIFT, 321);
   _actionMap[236][TMPSIZE] = ActionEntry(SHIFT, 322);
   _actionMap[236][LOGSIZE] = ActionEntry(SHIFT, 319);
   _actionMap[236][LOGNUM] = ActionEntry(SHIFT, 318);
   _actionMap[236][APPSIZE] = ActionEntry(SHIFT, 316);
   _actionMap[236][SORTAREASIZE] = ActionEntry(SHIFT, 320);
   _actionMap[236][TSROOT] = ActionEntry(SHIFT, 323);
   _actionMap[236][BRANCHID] = ActionEntry(SHIFT, 317);
   _jumpMap[236][Attr] = 315;
   _actionMap[237][SEMICOLON] = ActionEntry(REDUCE, 83);
   _actionMap[238][SEMICOLON] = ActionEntry(REDUCE, 56);
   _actionMap[239][SEMICOLON] = ActionEntry(REDUCE, 85);
   _actionMap[240][SEMICOLON] = ActionEntry(REDUCE, 99);
   _actionMap[241][SEMICOLON] = ActionEntry(REDUCE, 87);
   _actionMap[242][IDENTIFIER] = ActionEntry(SHIFT, 324);
   _actionMap[243][IDENTIFIER] = ActionEntry(SHIFT, 325);
   _actionMap[244][SEMICOLON] = ActionEntry(REDUCE, 82);
   _actionMap[245][SEMICOLON] = ActionEntry(REDUCE, 55);
   _actionMap[246][SEMICOLON] = ActionEntry(REDUCE, 84);
   _actionMap[247][SEMICOLON] = ActionEntry(REDUCE, 98);
   _actionMap[248][SEMICOLON] = ActionEntry(REDUCE, 86);
   _actionMap[249][MESSAGE] = ActionEntry(SHIFT, 232);
   _actionMap[249][KEEP] = ActionEntry(REDUCE, 123);
   _actionMap[249][SEMICOLON] = ActionEntry(REDUCE, 123);
   _jumpMap[249][MsgOption] = 327;
   _jumpMap[249][KeepTicketOpt] = 326;
   _actionMap[250][FROM] = ActionEntry(SHIFT, 329);
   _actionMap[251][IDENTIFIER] = ActionEntry(SHIFT, 330);
   _actionMap[252][TO] = ActionEntry(SHIFT, 331);
   _actionMap[253][TO] = ActionEntry(SHIFT, 332);
   _actionMap[254][IDENTIFIER] = ActionEntry(SHIFT, 333);
   _actionMap[255][FROM] = ActionEntry(SHIFT, 334);
   _actionMap[256][SEMICOLON] = ActionEntry(REDUCE, 10);
   _actionMap[257][TO] = ActionEntry(SHIFT, 336);
   _actionMap[257][SEMICOLON] = ActionEntry(REDUCE, 145);
   _jumpMap[257][ListBuOption] = 335;
   _actionMap[258][SEMICOLON] = ActionEntry(REDUCE, 13);
   _actionMap[259][SEMICOLON] = ActionEntry(REDUCE, 14);
   _actionMap[260][SEMICOLON] = ActionEntry(REDUCE, 9);
   _actionMap[261][SEMICOLON] = ActionEntry(REDUCE, 11);
   _actionMap[262][SEMICOLON] = ActionEntry(REDUCE, 12);
   _actionMap[263][SEMICOLON] = ActionEntry(REDUCE, 100);
   _actionMap[264][SEMICOLON] = ActionEntry(REDUCE, 88);
   _actionMap[265][SEMICOLON] = ActionEntry(REDUCE, 23);
   _actionMap[266][BY] = ActionEntry(SHIFT, 337);
   _actionMap[267][IDENTIFIER] = ActionEntry(SHIFT, 338);
}
void CegoAdm::loadParser6()
{
   _actionMap[268][IDENTIFIER] = ActionEntry(SHIFT, 339);
   _actionMap[269][IDENTIFIER] = ActionEntry(SHIFT, 340);
   _actionMap[270][SEMICOLON] = ActionEntry(REDUCE, 65);
   _actionMap[271][PIT] = ActionEntry(SHIFT, 342);
   _actionMap[271][LSN] = ActionEntry(SHIFT, 341);
   _actionMap[272][SEMICOLON] = ActionEntry(REDUCE, 15);
   _actionMap[273][STRINGVAL] = ActionEntry(SHIFT, 343);
   _actionMap[274][IDENTIFIER] = ActionEntry(SHIFT, 344);
   _actionMap[275][IDENTIFIER] = ActionEntry(SHIFT, 345);
   _actionMap[276][IDENTIFIER] = ActionEntry(SHIFT, 346);
   _actionMap[277][SEMICOLON] = ActionEntry(REDUCE, 66);
   _actionMap[278][INTVAL] = ActionEntry(SHIFT, 347);
   _actionMap[279][IDENTIFIER] = ActionEntry(SHIFT, 348);
   _actionMap[280][IDENTIFIER] = ActionEntry(SHIFT, 349);
   _actionMap[281][IDENTIFIER] = ActionEntry(SHIFT, 350);
   _actionMap[282][TABLESET] = ActionEntry(SHIFT, 355);
   _actionMap[282][FILTER] = ActionEntry(SHIFT, 353);
   _actionMap[282][RIGHT] = ActionEntry(SHIFT, 354);
   _jumpMap[282][PermEntry] = 352;
   _jumpMap[282][PermList] = 351;
   _actionMap[283][IDENTIFIER] = ActionEntry(SHIFT, 356);
   _actionMap[284][MAXENTRY] = ActionEntry(SHIFT, 198);
   _actionMap[284][MAXSIZE] = ActionEntry(SHIFT, 200);
   _actionMap[284][HASHRANGE] = ActionEntry(SHIFT, 199);
   _actionMap[284][THRESHOLD] = ActionEntry(SHIFT, 201);
   _jumpMap[284][QueryCacheParam] = 357;
   _actionMap[285][INTVAL] = ActionEntry(SHIFT, 358);
   _actionMap[286][INTVAL] = ActionEntry(SHIFT, 359);
   _actionMap[287][INTVAL] = ActionEntry(SHIFT, 360);
   _actionMap[288][INTVAL] = ActionEntry(SHIFT, 361);
   _actionMap[289][SEMICOLON] = ActionEntry(REDUCE, 81);
   _actionMap[290][SEMICOLON] = ActionEntry(REDUCE, 80);
   _actionMap[291][IDENTIFIER] = ActionEntry(SHIFT, 362);
   _actionMap[292][IDENTIFIER] = ActionEntry(SHIFT, 363);
   _actionMap[293][IDENTIFIER] = ActionEntry(SHIFT, 364);
   _actionMap[294][FILTER] = ActionEntry(SHIFT, 209);
   _actionMap[294][MAXSIZE] = ActionEntry(SHIFT, 211);
   _actionMap[294][MAXENTRY] = ActionEntry(SHIFT, 208);
   _actionMap[294][HASHRANGE] = ActionEntry(SHIFT, 210);
   _jumpMap[294][TableCacheParam] = 365;
   _actionMap[295][INTVAL] = ActionEntry(SHIFT, 366);
   _actionMap[296][STRINGVAL] = ActionEntry(SHIFT, 367);
   _actionMap[297][INTVAL] = ActionEntry(SHIFT, 368);
   _actionMap[298][INTVAL] = ActionEntry(SHIFT, 369);
   _actionMap[299][IDENTIFIER] = ActionEntry(SHIFT, 370);
   _actionMap[300][IDENTIFIER] = ActionEntry(SHIFT, 371);
   _actionMap[301][SEMICOLON] = ActionEntry(REDUCE, 101);
   _actionMap[302][SEMICOLON] = ActionEntry(REDUCE, 89);
   _actionMap[303][SEMICOLON] = ActionEntry(REDUCE, 27);
   _actionMap[303][CLEANUP] = ActionEntry(SHIFT, 373);
}
void CegoAdm::loadParser7()
{
   _actionMap[303][FORCELOAD] = ActionEntry(SHIFT, 375);
   _actionMap[303][CPDUMP] = ActionEntry(SHIFT, 374);
   _actionMap[303][NOINIT] = ActionEntry(SHIFT, 376);
   _jumpMap[303][StartOpt] = 372;
   _actionMap[304][MESSAGE] = ActionEntry(SHIFT, 232);
   _actionMap[304][SEMICOLON] = ActionEntry(REDUCE, 123);
   _jumpMap[304][MsgOption] = 305;
   _actionMap[305][SEMICOLON] = ActionEntry(REDUCE, 63);
   _actionMap[306][STRINGVAL] = ActionEntry(SHIFT, 377);
   _actionMap[307][SEMICOLON] = ActionEntry(REDUCE, 54);
   _actionMap[308][SEMICOLON] = ActionEntry(REDUCE, 53);
   _actionMap[132][INTVAL] = ActionEntry(SHIFT, 226);
   _actionMap[133][PATH] = ActionEntry(SHIFT, 227);
   _actionMap[134][IDENTIFIED] = ActionEntry(SHIFT, 228);
   _actionMap[135][STRINGVAL] = ActionEntry(SHIFT, 229);
   _actionMap[136][TO] = ActionEntry(SHIFT, 230);
   _actionMap[137][MESSAGE] = ActionEntry(SHIFT, 232);
   _actionMap[137][SEMICOLON] = ActionEntry(REDUCE, 123);
   _jumpMap[137][MsgOption] = 231;
   _actionMap[138][IDENTIFIER] = ActionEntry(SHIFT, 233);
   _actionMap[139][IDENTIFIER] = ActionEntry(SHIFT, 234);
   _actionMap[140][IDENTIFIER] = ActionEntry(SHIFT, 235);
   _actionMap[141][SEMICOLON] = ActionEntry(REDUCE, 35);
   _actionMap[142][SEMICOLON] = ActionEntry(REDUCE, 44);
   _actionMap[143][SEMICOLON] = ActionEntry(REDUCE, 26);
   _actionMap[144][SYSSIZE] = ActionEntry(REDUCE, 135);
   _actionMap[144][TMPSIZE] = ActionEntry(REDUCE, 135);
   _actionMap[144][LOGSIZE] = ActionEntry(REDUCE, 135);
   _actionMap[144][LOGNUM] = ActionEntry(REDUCE, 135);
   _actionMap[144][APPSIZE] = ActionEntry(REDUCE, 135);
   _actionMap[144][SORTAREASIZE] = ActionEntry(REDUCE, 135);
   _actionMap[144][TSROOT] = ActionEntry(REDUCE, 135);
   _actionMap[144][BRANCHID] = ActionEntry(REDUCE, 135);
   _actionMap[144][SEMICOLON] = ActionEntry(REDUCE, 135);
   _jumpMap[144][AttrList] = 236;
   _actionMap[145][IDENTIFIER] = ActionEntry(SHIFT, 237);
   _actionMap[146][IDENTIFIER] = ActionEntry(SHIFT, 238);
   _actionMap[147][IDENTIFIER] = ActionEntry(SHIFT, 239);
   _actionMap[148][IDENTIFIER] = ActionEntry(SHIFT, 240);
   _actionMap[149][IDENTIFIER] = ActionEntry(SHIFT, 241);
   _actionMap[150][SEMICOLON] = ActionEntry(REDUCE, 45);
   _actionMap[151][SEMICOLON] = ActionEntry(REDUCE, 31);
   _actionMap[152][SEMICOLON] = ActionEntry(REDUCE, 38);
   _actionMap[153][FOR] = ActionEntry(SHIFT, 242);
   _actionMap[154][FOR] = ActionEntry(SHIFT, 243);
   _actionMap[155][IDENTIFIER] = ActionEntry(SHIFT, 244);
   _actionMap[156][IDENTIFIER] = ActionEntry(SHIFT, 245);
   _actionMap[157][IDENTIFIER] = ActionEntry(SHIFT, 246);
   _actionMap[158][IDENTIFIER] = ActionEntry(SHIFT, 247);
   _actionMap[159][IDENTIFIER] = ActionEntry(SHIFT, 248);
}
void CegoAdm::loadParser8()
{
   _actionMap[160][IDENTIFIER] = ActionEntry(SHIFT, 249);
   _actionMap[161][IDENTIFIER] = ActionEntry(SHIFT, 250);
   _actionMap[162][IDENTIFIER] = ActionEntry(SHIFT, 252);
   _actionMap[162][STRUCTURE] = ActionEntry(SHIFT, 251);
   _actionMap[163][IDENTIFIER] = ActionEntry(SHIFT, 253);
   _actionMap[164][IDENTIFIER] = ActionEntry(SHIFT, 255);
   _actionMap[164][STRUCTURE] = ActionEntry(SHIFT, 254);
   _actionMap[165][IDENTIFIER] = ActionEntry(SHIFT, 256);
   _actionMap[166][IDENTIFIER] = ActionEntry(SHIFT, 257);
   _actionMap[167][IDENTIFIER] = ActionEntry(SHIFT, 258);
   _actionMap[168][IDENTIFIER] = ActionEntry(SHIFT, 259);
   _actionMap[169][IDENTIFIER] = ActionEntry(SHIFT, 260);
   _actionMap[170][IDENTIFIER] = ActionEntry(SHIFT, 261);
   _actionMap[171][IDENTIFIER] = ActionEntry(SHIFT, 262);
   _actionMap[172][IDENTIFIER] = ActionEntry(SHIFT, 263);
   _actionMap[173][IDENTIFIER] = ActionEntry(SHIFT, 264);
   _actionMap[174][IDENTIFIER] = ActionEntry(SHIFT, 265);
   _actionMap[175][SEMICOLON] = ActionEntry(REDUCE, 7);
   _actionMap[176][IDENTIFIED] = ActionEntry(SHIFT, 266);
   _actionMap[177][SEMICOLON] = ActionEntry(REDUCE, 21);
   _actionMap[178][SEMICOLON] = ActionEntry(REDUCE, 20);
   _actionMap[179][SEMICOLON] = ActionEntry(REDUCE, 19);
   _actionMap[180][FROM] = ActionEntry(SHIFT, 267);
   _actionMap[181][FROM] = ActionEntry(SHIFT, 268);
   _actionMap[182][FROM] = ActionEntry(SHIFT, 269);
   _actionMap[183][SEMICOLON] = ActionEntry(REDUCE, 32);
   _actionMap[184][TO] = ActionEntry(SHIFT, 271);
   _actionMap[184][SEMICOLON] = ActionEntry(REDUCE, 148);
   _jumpMap[184][RecoverOption] = 270;
   _actionMap[185][IDENTIFIER] = ActionEntry(SHIFT, 272);
   _actionMap[186][FROM] = ActionEntry(SHIFT, 273);
   _actionMap[187][FOR] = ActionEntry(SHIFT, 274);
   _actionMap[188][SEMICOLON] = ActionEntry(REDUCE, 67);
   _actionMap[189][FOR] = ActionEntry(SHIFT, 275);
   _actionMap[190][FOR] = ActionEntry(SHIFT, 276);
   _actionMap[191][TIMEOUT] = ActionEntry(SHIFT, 278);
   _actionMap[191][SEMICOLON] = ActionEntry(REDUCE, 121);
   _jumpMap[191][TimeoutOpt] = 277;
   _actionMap[192][FOR] = ActionEntry(SHIFT, 279);
   _actionMap[193][FOR] = ActionEntry(SHIFT, 280);
   _actionMap[194][FOR] = ActionEntry(SHIFT, 281);
   _actionMap[195][WITH] = ActionEntry(SHIFT, 282);
   _actionMap[196][FOR] = ActionEntry(SHIFT, 283);
   _actionMap[196][KSEP] = ActionEntry(SHIFT, 284);
   _actionMap[197][KSEP] = ActionEntry(REDUCE, 105);
   _actionMap[197][FOR] = ActionEntry(REDUCE, 105);
   _actionMap[198][EQU] = ActionEntry(SHIFT, 285);
   _actionMap[199][EQU] = ActionEntry(SHIFT, 286);
   _actionMap[200][EQU] = ActionEntry(SHIFT, 287);
   _actionMap[201][EQU] = ActionEntry(SHIFT, 288);
}
void CegoAdm::loadParser9()
{
   _actionMap[202][INTVAL] = ActionEntry(SHIFT, 289);
   _actionMap[203][INTVAL] = ActionEntry(SHIFT, 290);
   _actionMap[204][FOR] = ActionEntry(SHIFT, 291);
   _actionMap[205][FOR] = ActionEntry(SHIFT, 292);
   _actionMap[206][FOR] = ActionEntry(SHIFT, 293);
   _actionMap[206][KSEP] = ActionEntry(SHIFT, 294);
   _actionMap[207][KSEP] = ActionEntry(REDUCE, 93);
   _actionMap[207][FOR] = ActionEntry(REDUCE, 93);
   _actionMap[208][EQU] = ActionEntry(SHIFT, 295);
   _actionMap[209][EQU] = ActionEntry(SHIFT, 296);
   _actionMap[210][EQU] = ActionEntry(SHIFT, 297);
   _actionMap[211][EQU] = ActionEntry(SHIFT, 298);
   _actionMap[212][FOR] = ActionEntry(SHIFT, 299);
   _actionMap[213][FOR] = ActionEntry(SHIFT, 300);
   _actionMap[214][IDENTIFIER] = ActionEntry(SHIFT, 301);
   _actionMap[215][SEMICOLON] = ActionEntry(REDUCE, 43);
   _actionMap[216][IDENTIFIER] = ActionEntry(SHIFT, 302);
   _actionMap[217][SEMICOLON] = ActionEntry(REDUCE, 3);
   _actionMap[218][SEMICOLON] = ActionEntry(REDUCE, 29);
   _actionMap[219][CLEANUP] = ActionEntry(REDUCE, 125);
   _actionMap[219][FORCELOAD] = ActionEntry(REDUCE, 125);
   _actionMap[219][CPDUMP] = ActionEntry(REDUCE, 125);
   _actionMap[219][NOINIT] = ActionEntry(REDUCE, 125);
   _actionMap[219][SEMICOLON] = ActionEntry(REDUCE, 125);
   _jumpMap[219][StartOptList] = 303;
   _actionMap[220][SEMICOLON] = ActionEntry(REDUCE, 30);
   _actionMap[221][SEMICOLON] = ActionEntry(REDUCE, 28);
   _actionMap[222][WITH] = ActionEntry(SHIFT, 306);
   _actionMap[222][MESSAGE] = ActionEntry(REDUCE, 119);
   _actionMap[222][KEEP] = ActionEntry(REDUCE, 119);
   _actionMap[222][SEMICOLON] = ActionEntry(REDUCE, 119);
   _jumpMap[222][MsgOption] = 305;
   _jumpMap[222][SyncCmdOption] = 304;
   _actionMap[223][IDENTIFIER] = ActionEntry(SHIFT, 307);
   _actionMap[224][IDENTIFIER] = ActionEntry(SHIFT, 308);
   _actionMap[225][SEMICOLON] = ActionEntry(REDUCE, 34);
   _actionMap[35][ENDTOKEN] = ActionEntry(ACCEPT, 0);
   _actionMap[36][THREAD] = ActionEntry(SHIFT, 132);
   _actionMap[37][IDENTIFIER] = ActionEntry(SHIFT, 133);
   _actionMap[38][IDENTIFIER] = ActionEntry(SHIFT, 134);
   _actionMap[39][DATAFILE] = ActionEntry(SHIFT, 135);
   _actionMap[40][IDENTIFIER] = ActionEntry(SHIFT, 136);
   _actionMap[41][IDENTIFIER] = ActionEntry(SHIFT, 137);
   _actionMap[42][FOR] = ActionEntry(SHIFT, 138);
   _actionMap[43][FOR] = ActionEntry(SHIFT, 139);
   _actionMap[44][FOR] = ActionEntry(SHIFT, 140);
   _actionMap[45][IDENTIFIER] = ActionEntry(SHIFT, 141);
   _actionMap[46][IDENTIFIER] = ActionEntry(SHIFT, 142);
   _actionMap[47][IDENTIFIER] = ActionEntry(SHIFT, 143);
   _actionMap[48][IDENTIFIER] = ActionEntry(SHIFT, 144);
}
void CegoAdm::loadParser10()
{
   _actionMap[49][FOR] = ActionEntry(SHIFT, 145);
   _actionMap[50][FOR] = ActionEntry(SHIFT, 146);
   _actionMap[51][FOR] = ActionEntry(SHIFT, 147);
   _actionMap[52][FOR] = ActionEntry(SHIFT, 148);
   _actionMap[53][FOR] = ActionEntry(SHIFT, 149);
   _actionMap[54][IDENTIFIER] = ActionEntry(SHIFT, 150);
   _actionMap[55][IDENTIFIER] = ActionEntry(SHIFT, 151);
   _actionMap[56][IDENTIFIER] = ActionEntry(SHIFT, 152);
   _actionMap[57][IDENTIFIER] = ActionEntry(SHIFT, 153);
   _actionMap[58][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[59][FOR] = ActionEntry(SHIFT, 155);
   _actionMap[60][FOR] = ActionEntry(SHIFT, 156);
   _actionMap[61][FOR] = ActionEntry(SHIFT, 157);
   _actionMap[62][FOR] = ActionEntry(SHIFT, 158);
   _actionMap[63][FOR] = ActionEntry(SHIFT, 159);
   _actionMap[64][FOR] = ActionEntry(SHIFT, 160);
   _actionMap[65][TABLESET] = ActionEntry(SHIFT, 162);
   _actionMap[65][TABLE] = ActionEntry(SHIFT, 161);
   _actionMap[66][TABLESET] = ActionEntry(REDUCE, 131);
   _actionMap[66][TABLE] = ActionEntry(REDUCE, 131);
   _actionMap[67][TABLESET] = ActionEntry(REDUCE, 132);
   _actionMap[67][TABLE] = ActionEntry(REDUCE, 132);
   _actionMap[68][TABLESET] = ActionEntry(REDUCE, 130);
   _actionMap[68][TABLE] = ActionEntry(REDUCE, 130);
   _actionMap[69][TABLESET] = ActionEntry(SHIFT, 164);
   _actionMap[69][TABLE] = ActionEntry(SHIFT, 163);
   _actionMap[70][FOR] = ActionEntry(SHIFT, 165);
   _actionMap[71][FOR] = ActionEntry(SHIFT, 166);
   _actionMap[72][FOR] = ActionEntry(SHIFT, 167);
   _actionMap[73][FOR] = ActionEntry(SHIFT, 168);
   _actionMap[74][FOR] = ActionEntry(SHIFT, 169);
   _actionMap[75][FOR] = ActionEntry(SHIFT, 170);
   _actionMap[76][FOR] = ActionEntry(SHIFT, 171);
   _actionMap[77][SEMICOLON] = ActionEntry(REDUCE, 4);
   _actionMap[78][FOR] = ActionEntry(SHIFT, 172);
   _actionMap[79][SEMICOLON] = ActionEntry(REDUCE, 42);
   _actionMap[80][FOR] = ActionEntry(SHIFT, 173);
   _actionMap[81][SEMICOLON] = ActionEntry(REDUCE, 8);
   _actionMap[82][FOR] = ActionEntry(SHIFT, 174);
   _actionMap[83][SEMICOLON] = ActionEntry(REDUCE, 37);
   _actionMap[84][LOCK] = ActionEntry(SHIFT, 175);
   _actionMap[85][IDENTIFIER] = ActionEntry(SHIFT, 176);
   _actionMap[86][INTVAL] = ActionEntry(SHIFT, 177);
   _actionMap[87][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[88][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[89][SEMICOLON] = ActionEntry(REDUCE, 6);
   _actionMap[90][SEMICOLON] = ActionEntry(REDUCE, 5);
   _actionMap[91][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[92][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[93][IDENTIFIER] = ActionEntry(SHIFT, 182);
}
void CegoAdm::loadParser11()
{
   _actionMap[94][IDENTIFIER] = ActionEntry(SHIFT, 183);
   _actionMap[95][IDENTIFIER] = ActionEntry(SHIFT, 184);
   _actionMap[96][FOR] = ActionEntry(SHIFT, 185);
   _actionMap[97][IDENTIFIER] = ActionEntry(SHIFT, 186);
   _actionMap[98][INTVAL] = ActionEntry(SHIFT, 187);
   _actionMap[99][STRINGVAL] = ActionEntry(SHIFT, 188);
   _actionMap[100][INTVAL] = ActionEntry(SHIFT, 189);
   _actionMap[101][STRINGVAL] = ActionEntry(SHIFT, 190);
   _actionMap[102][STRINGVAL] = ActionEntry(SHIFT, 191);
   _actionMap[103][INTVAL] = ActionEntry(SHIFT, 192);
   _actionMap[104][INTVAL] = ActionEntry(SHIFT, 193);
   _actionMap[105][IDENTIFIER] = ActionEntry(SHIFT, 194);
   _actionMap[106][IDENTIFIER] = ActionEntry(SHIFT, 195);
   _actionMap[107][MAXENTRY] = ActionEntry(SHIFT, 198);
   _actionMap[107][MAXSIZE] = ActionEntry(SHIFT, 200);
   _actionMap[107][HASHRANGE] = ActionEntry(SHIFT, 199);
   _actionMap[107][THRESHOLD] = ActionEntry(SHIFT, 201);
   _jumpMap[107][QueryCacheParam] = 197;
   _jumpMap[107][QueryCacheParamList] = 196;
   _actionMap[108][COST] = ActionEntry(SHIFT, 202);
   _actionMap[108][LAST] = ActionEntry(SHIFT, 203);
   _actionMap[109][INTVAL] = ActionEntry(SHIFT, 204);
   _actionMap[110][INTVAL] = ActionEntry(SHIFT, 205);
   _actionMap[111][FILTER] = ActionEntry(SHIFT, 209);
   _actionMap[111][MAXSIZE] = ActionEntry(SHIFT, 211);
   _actionMap[111][MAXENTRY] = ActionEntry(SHIFT, 208);
   _actionMap[111][HASHRANGE] = ActionEntry(SHIFT, 210);
   _jumpMap[111][TableCacheParam] = 207;
   _jumpMap[111][TableCacheParamList] = 206;
   _actionMap[112][INTVAL] = ActionEntry(SHIFT, 212);
   _actionMap[113][STRINGVAL] = ActionEntry(SHIFT, 213);
   _actionMap[114][SEMICOLON] = ActionEntry(REDUCE, 69);
   _actionMap[115][SEMICOLON] = ActionEntry(REDUCE, 68);
   _actionMap[116][SEMICOLON] = ActionEntry(REDUCE, 2);
   _actionMap[117][SEMICOLON] = ActionEntry(REDUCE, 1);
   _actionMap[118][FOR] = ActionEntry(SHIFT, 214);
   _actionMap[119][IDENTIFIER] = ActionEntry(SHIFT, 215);
   _actionMap[120][FOR] = ActionEntry(SHIFT, 216);
   _actionMap[121][IDENTIFIER] = ActionEntry(SHIFT, 217);
   _actionMap[122][IDENTIFIER] = ActionEntry(SHIFT, 218);
   _actionMap[123][IDENTIFIER] = ActionEntry(SHIFT, 219);
   _actionMap[124][IDENTIFIER] = ActionEntry(SHIFT, 220);
   _actionMap[125][IDENTIFIER] = ActionEntry(SHIFT, 221);
   _actionMap[126][IDENTIFIER] = ActionEntry(SHIFT, 222);
   _actionMap[127][SEMICOLON] = ActionEntry(REDUCE, 22);
   _actionMap[128][SEMICOLON] = ActionEntry(REDUCE, 18);
   _actionMap[129][USER] = ActionEntry(SHIFT, 223);
   _actionMap[130][USER] = ActionEntry(SHIFT, 224);
   _actionMap[131][IDENTIFIER] = ActionEntry(SHIFT, 225);
   _actionMap[1][SEMICOLON] = ActionEntry(SHIFT, 35);
}
void CegoAdm::loadParser12()
{
   _actionMap[2][DB] = ActionEntry(SHIFT, 36);
   _actionMap[3][IDENTIFIER] = ActionEntry(SHIFT, 39);
   _actionMap[3][USER] = ActionEntry(SHIFT, 38);
   _actionMap[3][ARCHLOG] = ActionEntry(SHIFT, 37);
   _actionMap[4][ROLE] = ActionEntry(SHIFT, 40);
   _actionMap[5][TABLESET] = ActionEntry(SHIFT, 41);
   _actionMap[6][BACKUP] = ActionEntry(SHIFT, 42);
   _actionMap[7][TABLECACHE] = ActionEntry(SHIFT, 44);
   _actionMap[7][QUERYCACHE] = ActionEntry(SHIFT, 43);
   _actionMap[8][TABLESET] = ActionEntry(SHIFT, 45);
   _actionMap[9][TABLESET] = ActionEntry(SHIFT, 47);
   _actionMap[9][ROLE] = ActionEntry(SHIFT, 46);
   _actionMap[10][TABLESET] = ActionEntry(SHIFT, 48);
   _actionMap[11][ARCHLOG] = ActionEntry(SHIFT, 50);
   _actionMap[11][APPENDMODE] = ActionEntry(SHIFT, 49);
   _actionMap[11][AUTOCORRECT] = ActionEntry(SHIFT, 51);
   _actionMap[11][TABLECACHE] = ActionEntry(SHIFT, 53);
   _actionMap[11][QUERYCACHE] = ActionEntry(SHIFT, 52);
   _actionMap[12][TABLESET] = ActionEntry(SHIFT, 55);
   _actionMap[12][USER] = ActionEntry(SHIFT, 56);
   _actionMap[12][ROLE] = ActionEntry(SHIFT, 54);
   _actionMap[13][TABLE] = ActionEntry(SHIFT, 58);
   _actionMap[13][UINDEX] = ActionEntry(SHIFT, 57);
   _actionMap[14][ARCHLOG] = ActionEntry(SHIFT, 60);
   _actionMap[14][APPENDMODE] = ActionEntry(SHIFT, 59);
   _actionMap[14][AUTOCORRECT] = ActionEntry(SHIFT, 61);
   _actionMap[14][TABLECACHE] = ActionEntry(SHIFT, 63);
   _actionMap[14][QUERYCACHE] = ActionEntry(SHIFT, 62);
   _actionMap[15][BACKUP] = ActionEntry(SHIFT, 64);
   _actionMap[16][XML] = ActionEntry(SHIFT, 68);
   _actionMap[16][BINARY] = ActionEntry(SHIFT, 66);
   _actionMap[16][PLAIN] = ActionEntry(SHIFT, 67);
   _actionMap[16][TABLE] = ActionEntry(REDUCE, 133);
   _actionMap[16][TABLESET] = ActionEntry(REDUCE, 133);
   _jumpMap[16][XPMode] = 65;
   _actionMap[17][XML] = ActionEntry(SHIFT, 68);
   _actionMap[17][BINARY] = ActionEntry(SHIFT, 66);
   _actionMap[17][PLAIN] = ActionEntry(SHIFT, 67);
   _actionMap[17][TABLE] = ActionEntry(REDUCE, 133);
   _actionMap[17][TABLESET] = ActionEntry(REDUCE, 133);
   _jumpMap[17][XPMode] = 69;
   _actionMap[18][POOL] = ActionEntry(SHIFT, 77);
   _actionMap[18][IDENTIFIER] = ActionEntry(SHIFT, 84);
   _actionMap[18][TABLESET] = ActionEntry(SHIFT, 81);
   _actionMap[18][DATAFILE] = ActionEntry(SHIFT, 74);
   _actionMap[18][ARCHLOG] = ActionEntry(SHIFT, 70);
   _actionMap[18][LOGFILE] = ActionEntry(SHIFT, 75);
   _actionMap[18][OBJECT] = ActionEntry(SHIFT, 76);
   _actionMap[18][BUFILE] = ActionEntry(SHIFT, 72);
   _actionMap[18][BUSTAT] = ActionEntry(SHIFT, 73);
}
void CegoAdm::loadParser13()
{
   _actionMap[18][TRANSACTION] = ActionEntry(SHIFT, 82);
   _actionMap[18][USER] = ActionEntry(SHIFT, 83);
   _actionMap[18][ROLE] = ActionEntry(SHIFT, 79);
   _actionMap[18][BACKUP] = ActionEntry(SHIFT, 71);
   _actionMap[18][TABLECACHE] = ActionEntry(SHIFT, 80);
   _actionMap[18][QUERYCACHE] = ActionEntry(SHIFT, 78);
   _actionMap[19][SEMICOLON] = ActionEntry(REDUCE, 17);
   _actionMap[20][USER] = ActionEntry(SHIFT, 85);
   _actionMap[21][THREAD] = ActionEntry(SHIFT, 88);
   _actionMap[21][LAST] = ActionEntry(SHIFT, 87);
   _actionMap[21][COST] = ActionEntry(SHIFT, 86);
   _actionMap[22][ON] = ActionEntry(SHIFT, 90);
   _actionMap[22][OFF] = ActionEntry(SHIFT, 89);
   _actionMap[23][TABLESET] = ActionEntry(SHIFT, 94);
   _actionMap[23][ROLE] = ActionEntry(SHIFT, 93);
   _actionMap[23][PERMISSION] = ActionEntry(SHIFT, 92);
   _actionMap[23][ARCHLOG] = ActionEntry(SHIFT, 91);
   _actionMap[24][TABLESET] = ActionEntry(SHIFT, 95);
   _actionMap[25][BUSTAT] = ActionEntry(SHIFT, 96);
   _actionMap[26][TABLESET] = ActionEntry(SHIFT, 97);
   _actionMap[27][PERMISSION] = ActionEntry(SHIFT, 106);
   _actionMap[27][LOGMNG] = ActionEntry(SHIFT, 102);
   _actionMap[27][BACKUPMNG] = ActionEntry(SHIFT, 99);
   _actionMap[27][INITFILE] = ActionEntry(SHIFT, 101);
   _actionMap[27][CHECKPOINT] = ActionEntry(SHIFT, 100);
   _actionMap[27][SYSSIZE] = ActionEntry(SHIFT, 110);
   _actionMap[27][TMPSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[27][APPSIZE] = ActionEntry(SHIFT, 98);
   _actionMap[27][TSROOT] = ActionEntry(SHIFT, 113);
   _actionMap[27][LOGNUM] = ActionEntry(SHIFT, 103);
   _actionMap[27][LOGSIZE] = ActionEntry(SHIFT, 104);
   _actionMap[27][SORTAREASIZE] = ActionEntry(SHIFT, 109);
   _actionMap[27][LOGUSER] = ActionEntry(SHIFT, 105);
   _actionMap[27][QUERYHIST] = ActionEntry(SHIFT, 108);
   _actionMap[27][TABLECACHE] = ActionEntry(SHIFT, 111);
   _actionMap[27][QUERYCACHE] = ActionEntry(SHIFT, 107);
   _actionMap[28][POOL] = ActionEntry(SHIFT, 117);
   _actionMap[28][PARAMETER] = ActionEntry(SHIFT, 116);
   _actionMap[28][TABLESET] = ActionEntry(SHIFT, 121);
   _actionMap[28][ROLE] = ActionEntry(SHIFT, 119);
   _actionMap[28][LOGMNG] = ActionEntry(SHIFT, 115);
   _actionMap[28][BACKUPMNG] = ActionEntry(SHIFT, 114);
   _actionMap[28][TABLECACHE] = ActionEntry(SHIFT, 120);
   _actionMap[28][QUERYCACHE] = ActionEntry(SHIFT, 118);
   _actionMap[29][TABLESET] = ActionEntry(SHIFT, 123);
   _actionMap[29][RECOVERY] = ActionEntry(SHIFT, 122);
   _actionMap[30][TABLESET] = ActionEntry(SHIFT, 125);
   _actionMap[30][RECOVERY] = ActionEntry(SHIFT, 124);
   _actionMap[31][TABLESET] = ActionEntry(SHIFT, 126);
   _actionMap[32][SEMICOLON] = ActionEntry(REDUCE, 16);
}
void CegoAdm::loadParser14()
{
   _actionMap[32][DB] = ActionEntry(SHIFT, 128);
   _actionMap[32][ADM] = ActionEntry(SHIFT, 127);
   _actionMap[33][ON] = ActionEntry(SHIFT, 130);
   _actionMap[33][OFF] = ActionEntry(SHIFT, 129);
   _actionMap[34][TABLESET] = ActionEntry(SHIFT, 131);
   _actionMap[0][SHOW] = ActionEntry(SHIFT, 28);
   _actionMap[0][LIST] = ActionEntry(SHIFT, 18);
   _actionMap[0][RAWMODE] = ActionEntry(SHIFT, 22);
   _actionMap[0][RESET] = ActionEntry(SHIFT, 25);
   _actionMap[0][THREADINFO] = ActionEntry(SHIFT, 32);
   _actionMap[0][LOCKSTAT] = ActionEntry(SHIFT, 19);
   _actionMap[0][QUERYHIST] = ActionEntry(SHIFT, 21);
   _actionMap[0][ABORT] = ActionEntry(SHIFT, 2);
   _actionMap[0][DEFINE] = ActionEntry(SHIFT, 10);
   _actionMap[0][CREATE] = ActionEntry(SHIFT, 9);
   _actionMap[0][START_TOK] = ActionEntry(SHIFT, 29);
   _actionMap[0][STOP_TOK] = ActionEntry(SHIFT, 30);
   _actionMap[0][DROP] = ActionEntry(SHIFT, 12);
   _actionMap[0][REMOVE] = ActionEntry(SHIFT, 23);
   _actionMap[0][ADD] = ActionEntry(SHIFT, 3);
   _actionMap[0][VERIFY] = ActionEntry(SHIFT, 34);
   _actionMap[0][CORRECT] = ActionEntry(SHIFT, 8);
   _actionMap[0][PASSWD] = ActionEntry(SHIFT, 20);
   _actionMap[0][ASSIGN] = ActionEntry(SHIFT, 4);
   _actionMap[0][SET] = ActionEntry(SHIFT, 27);
   _actionMap[0][TRACE] = ActionEntry(SHIFT, 33);
   _actionMap[0][ENABLE] = ActionEntry(SHIFT, 14);
   _actionMap[0][DISABLE] = ActionEntry(SHIFT, 11);
   _actionMap[0][BEGIN_TOKEN] = ActionEntry(SHIFT, 6);
   _actionMap[0][BACKUP] = ActionEntry(SHIFT, 5);
   _actionMap[0][END_TOKEN] = ActionEntry(SHIFT, 15);
   _actionMap[0][SYNC] = ActionEntry(SHIFT, 31);
   _actionMap[0][RESTORE] = ActionEntry(SHIFT, 26);
   _actionMap[0][RECOVER] = ActionEntry(SHIFT, 24);
   _actionMap[0][CLEAN] = ActionEntry(SHIFT, 7);
   _actionMap[0][EXPORT] = ActionEntry(SHIFT, 16);
   _actionMap[0][IMPORT] = ActionEntry(SHIFT, 17);
   _actionMap[0][DUMP] = ActionEntry(SHIFT, 13);
   _jumpMap[0][Statement] = 1;
}
void CegoAdm::loadParser15()
{
   _prodInfo.Insert(ProdEntry(150, Statement, 5));
   _prodInfo.Insert(ProdEntry(149, Statement, 5));
   _prodInfo.Insert(ProdEntry(148, RecoverOption, 0));
   _prodInfo.Insert(ProdEntry(147, RecoverOption, 3));
   _prodInfo.Insert(ProdEntry(146, RecoverOption, 3));
   _prodInfo.Insert(ProdEntry(145, ListBuOption, 0));
   _prodInfo.Insert(ProdEntry(144, ListBuOption, 2));
   _prodInfo.Insert(ProdEntry(143, Attr, 3));
   _prodInfo.Insert(ProdEntry(142, Attr, 3));
   _prodInfo.Insert(ProdEntry(141, Attr, 3));
   _prodInfo.Insert(ProdEntry(140, Attr, 3));
   _prodInfo.Insert(ProdEntry(139, Attr, 3));
   _prodInfo.Insert(ProdEntry(138, Attr, 3));
   _prodInfo.Insert(ProdEntry(137, Attr, 3));
   _prodInfo.Insert(ProdEntry(136, Attr, 3));
   _prodInfo.Insert(ProdEntry(135, AttrList, 0));
   _prodInfo.Insert(ProdEntry(134, AttrList, 2));
   _prodInfo.Insert(ProdEntry(133, XPMode, 0));
   _prodInfo.Insert(ProdEntry(132, XPMode, 1));
   _prodInfo.Insert(ProdEntry(131, XPMode, 1));
   _prodInfo.Insert(ProdEntry(130, XPMode, 1));
   _prodInfo.Insert(ProdEntry(129, StartOpt, 1));
   _prodInfo.Insert(ProdEntry(128, StartOpt, 1));
   _prodInfo.Insert(ProdEntry(127, StartOpt, 1));
   _prodInfo.Insert(ProdEntry(126, StartOpt, 1));
   _prodInfo.Insert(ProdEntry(125, StartOptList, 0));
   _prodInfo.Insert(ProdEntry(124, StartOptList, 2));
   _prodInfo.Insert(ProdEntry(123, MsgOption, 0));
   _prodInfo.Insert(ProdEntry(122, MsgOption, 2));
   _prodInfo.Insert(ProdEntry(121, TimeoutOpt, 0));
   _prodInfo.Insert(ProdEntry(120, TimeoutOpt, 2));
   _prodInfo.Insert(ProdEntry(119, SyncCmdOption, 0));
   _prodInfo.Insert(ProdEntry(118, SyncCmdOption, 3));
   _prodInfo.Insert(ProdEntry(117, KeepTicketOpt, 0));
   _prodInfo.Insert(ProdEntry(116, KeepTicketOpt, 2));
   _prodInfo.Insert(ProdEntry(115, Statement, 7));
   _prodInfo.Insert(ProdEntry(114, Statement, 6));
   _prodInfo.Insert(ProdEntry(113, Statement, 8));
   _prodInfo.Insert(ProdEntry(112, Statement, 7));
   _prodInfo.Insert(ProdEntry(111, Statement, 6));
   _prodInfo.Insert(ProdEntry(110, Statement, 8));
   _prodInfo.Insert(ProdEntry(109, QueryCacheParam, 3));
   _prodInfo.Insert(ProdEntry(108, QueryCacheParam, 3));
   _prodInfo.Insert(ProdEntry(107, QueryCacheParam, 3));
   _prodInfo.Insert(ProdEntry(106, QueryCacheParam, 3));
   _prodInfo.Insert(ProdEntry(105, QueryCacheParamList, 1));
   _prodInfo.Insert(ProdEntry(104, QueryCacheParamList, 3));
   _prodInfo.Insert(ProdEntry(103, Statement, 5));
   _prodInfo.Insert(ProdEntry(102, Statement, 4));
   _prodInfo.Insert(ProdEntry(101, Statement, 4));
   _prodInfo.Insert(ProdEntry(100, Statement, 4));
   _prodInfo.Insert(ProdEntry(99, Statement, 4));
   _prodInfo.Insert(ProdEntry(98, Statement, 4));
   _prodInfo.Insert(ProdEntry(97, TableCacheParam, 3));
   _prodInfo.Insert(ProdEntry(96, TableCacheParam, 3));
   _prodInfo.Insert(ProdEntry(95, TableCacheParam, 3));
   _prodInfo.Insert(ProdEntry(94, TableCacheParam, 3));
   _prodInfo.Insert(ProdEntry(93, TableCacheParamList, 1));
   _prodInfo.Insert(ProdEntry(92, TableCacheParamList, 3));
   _prodInfo.Insert(ProdEntry(91, Statement, 5));
   _prodInfo.Insert(ProdEntry(90, Statement, 4));
   _prodInfo.Insert(ProdEntry(89, Statement, 4));
   _prodInfo.Insert(ProdEntry(88, Statement, 4));
   _prodInfo.Insert(ProdEntry(87, Statement, 4));
   _prodInfo.Insert(ProdEntry(86, Statement, 4));
   _prodInfo.Insert(ProdEntry(85, Statement, 4));
   _prodInfo.Insert(ProdEntry(84, Statement, 4));
   _prodInfo.Insert(ProdEntry(83, Statement, 4));
   _prodInfo.Insert(ProdEntry(82, Statement, 4));
   _prodInfo.Insert(ProdEntry(81, Statement, 4));
   _prodInfo.Insert(ProdEntry(80, Statement, 4));
   _prodInfo.Insert(ProdEntry(79, Statement, 5));
   _prodInfo.Insert(ProdEntry(78, Statement, 5));
   _prodInfo.Insert(ProdEntry(77, Statement, 5));
   _prodInfo.Insert(ProdEntry(76, Statement, 5));
   _prodInfo.Insert(ProdEntry(75, Statement, 5));
   _prodInfo.Insert(ProdEntry(74, Statement, 5));
   _prodInfo.Insert(ProdEntry(73, Statement, 5));
   _prodInfo.Insert(ProdEntry(72, Statement, 5));
   _prodInfo.Insert(ProdEntry(71, Statement, 5));
   _prodInfo.Insert(ProdEntry(70, Statement, 5));
   _prodInfo.Insert(ProdEntry(69, Statement, 2));
   _prodInfo.Insert(ProdEntry(68, Statement, 2));
   _prodInfo.Insert(ProdEntry(67, Statement, 3));
   _prodInfo.Insert(ProdEntry(66, Statement, 4));
   _prodInfo.Insert(ProdEntry(65, Statement, 4));
   _prodInfo.Insert(ProdEntry(64, Statement, 5));
   _prodInfo.Insert(ProdEntry(63, Statement, 5));
   _prodInfo.Insert(ProdEntry(62, Statement, 5));
   _prodInfo.Insert(ProdEntry(61, Statement, 6));
   _prodInfo.Insert(ProdEntry(60, Statement, 4));
   _prodInfo.Insert(ProdEntry(59, Statement, 5));
   _prodInfo.Insert(ProdEntry(58, Statement, 5));
   _prodInfo.Insert(ProdEntry(57, Statement, 7));
   _prodInfo.Insert(ProdEntry(56, Statement, 4));
   _prodInfo.Insert(ProdEntry(55, Statement, 4));
   _prodInfo.Insert(ProdEntry(54, Statement, 4));
   _prodInfo.Insert(ProdEntry(53, Statement, 4));
   _prodInfo.Insert(ProdEntry(52, Statement, 5));
   _prodInfo.Insert(ProdEntry(51, PermEntry, 3));
   _prodInfo.Insert(ProdEntry(50, PermEntry, 3));
   _prodInfo.Insert(ProdEntry(49, PermEntry, 3));
   _prodInfo.Insert(ProdEntry(48, PermList, 1));
   _prodInfo.Insert(ProdEntry(47, PermList, 3));
   _prodInfo.Insert(ProdEntry(46, Statement, 7));
   _prodInfo.Insert(ProdEntry(45, Statement, 3));
   _prodInfo.Insert(ProdEntry(44, Statement, 3));
   _prodInfo.Insert(ProdEntry(43, Statement, 3));
   _prodInfo.Insert(ProdEntry(42, Statement, 2));
   _prodInfo.Insert(ProdEntry(41, Statement, 5));
   _prodInfo.Insert(ProdEntry(40, Statement, 5));
   _prodInfo.Insert(ProdEntry(39, Statement, 6));
   _prodInfo.Insert(ProdEntry(38, Statement, 3));
   _prodInfo.Insert(ProdEntry(37, Statement, 2));
   _prodInfo.Insert(ProdEntry(36, Statement, 6));
   _prodInfo.Insert(ProdEntry(35, Statement, 3));
   _prodInfo.Insert(ProdEntry(34, Statement, 3));
   _prodInfo.Insert(ProdEntry(33, Statement, 8));
   _prodInfo.Insert(ProdEntry(32, Statement, 3));
   _prodInfo.Insert(ProdEntry(31, Statement, 3));
   _prodInfo.Insert(ProdEntry(30, Statement, 3));
   _prodInfo.Insert(ProdEntry(29, Statement, 3));
   _prodInfo.Insert(ProdEntry(28, Statement, 3));
   _prodInfo.Insert(ProdEntry(27, Statement, 4));
   _prodInfo.Insert(ProdEntry(26, Statement, 3));
   _prodInfo.Insert(ProdEntry(25, Statement, 4));
   _prodInfo.Insert(ProdEntry(24, Statement, 4));
   _prodInfo.Insert(ProdEntry(23, Statement, 4));
   _prodInfo.Insert(ProdEntry(22, Statement, 2));
   _prodInfo.Insert(ProdEntry(21, Statement, 3));
   _prodInfo.Insert(ProdEntry(20, Statement, 3));
   _prodInfo.Insert(ProdEntry(19, Statement, 3));
   _prodInfo.Insert(ProdEntry(18, Statement, 2));
   _prodInfo.Insert(ProdEntry(17, Statement, 1));
   _prodInfo.Insert(ProdEntry(16, Statement, 1));
   _prodInfo.Insert(ProdEntry(15, Statement, 4));
   _prodInfo.Insert(ProdEntry(14, Statement, 4));
   _prodInfo.Insert(ProdEntry(13, Statement, 4));
   _prodInfo.Insert(ProdEntry(12, Statement, 4));
   _prodInfo.Insert(ProdEntry(11, Statement, 4));
   _prodInfo.Insert(ProdEntry(10, Statement, 4));
   _prodInfo.Insert(ProdEntry(9, Statement, 4));
   _prodInfo.Insert(ProdEntry(8, Statement, 2));
   _prodInfo.Insert(ProdEntry(7, Statement, 3));
   _prodInfo.Insert(ProdEntry(6, Statement, 2));
   _prodInfo.Insert(ProdEntry(5, Statement, 2));
   _prodInfo.Insert(ProdEntry(4, Statement, 2));
   _prodInfo.Insert(ProdEntry(3, Statement, 3));
   _prodInfo.Insert(ProdEntry(2, Statement, 2));
   _prodInfo.Insert(ProdEntry(1, Statement, 2));
   _prodInfo.Insert(ProdEntry(0, Start, 2));
}

CegoAdm::CegoAdm()
{
   loadScanner();
   for ( unsigned i=0; i < 428; i++)
   {
      unsigned j;
      for ( j = 0; j < 123; j++)
         _actionMap[i][j] = ActionEntry();
      for ( j = 0; j < 20; j++)
         _jumpMap[i][j] = -1;
   }
   loadParser0();
   loadParser1();
   loadParser2();
   loadParser3();
   loadParser4();
   loadParser5();
   loadParser6();
   loadParser7();
   loadParser8();
   loadParser9();
   loadParser10();
   loadParser11();
   loadParser12();
   loadParser13();
   loadParser14();
   loadParser15();
   _isReserved = false;
}

CegoAdm::~CegoAdm()
{
}

void CegoAdm::parse()
{
   StackT<StackEntry> s;
   StackEntry se(NONE, 0, 0);
   s.Push(se);
   _isReserved = false;
   if ( shiftToken() == false )
   {
      Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
      throw Exception(EXLOC, msg);
   }
   while ( true )
   {
      Action a;
      unsigned num;
      if ( getAction(s.getTop()->getState(), _token, a, num) )
      {
         switch (a)
         {
            case SHIFT:
            {
               StackEntry se(TOKEN, _token, num, _tokenVal);
               s.Push(se);
               if ( shiftToken() == false )
               {
                  Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
                  throw Exception(EXLOC, msg);
               }
               break;
            }
            case REDUCE:
            {
               _tokenList.Empty();
               ProdEntry* pPE = _prodInfo.Find(num);
               for (unsigned i=0; i<pPE->getNumSymbol();i++)
               {
                  StackEntry se;
                  s.Pop(se);
                  if (se.getSymbol() == TOKEN)
                     _tokenList.Insert(se.getTval());
               }
               unsigned fstate;
               if (getJump(s.getTop()->getState(), pPE->getProd(), fstate))
               {
                  StackEntry se(PROD, pPE->getId(), fstate, _tokenVal);
                  s.Push(se);
               }
               else
               {
                  Chain msg = "Cannot reduce after token <" + Chain(_tokenVal) + ">.";
                  throw Exception(EXLOC, msg);
               }
               switch (num)
               {
                  case 150:
                     dumpUIndex();
                     break;
                  case 149:
                     dumpTable();
                     break;
                  case 147:
                     storeLsn();
                     break;
                  case 146:
                     storePit();
                     break;
                  case 144:
                     storePit();
                     break;
                  case 143:
                     storeBranchAttr();
                     break;
                  case 142:
                     storeTSRootAttr();
                     break;
                  case 141:
                     storeSortAreaAttr();
                     break;
                  case 140:
                     storeAppSizeAttr();
                     break;
                  case 139:
                     storeLogNumAttr();
                     break;
                  case 138:
                     storeLogSizeAttr();
                     break;
                  case 137:
                     storeTmpSizeAttr();
                     break;
                  case 136:
                     storeSysSizeAttr();
                     break;
                  case 132:
                     plainModeAction();
                     break;
                  case 131:
                     binModeAction();
                     break;
                  case 130:
                     xmlModeAction();
                     break;
                  case 129:
                     noInitAction();
                     break;
                  case 128:
                     cpDumpAction();
                     break;
                  case 127:
                     forceloadAction();
                     break;
                  case 126:
                     cleanupAction();
                     break;
                  case 122:
                     msgAction();
                     break;
                  case 120:
                     timeoutAction();
                     break;
                  case 118:
                     syncCmdAction();
                     break;
                  case 116:
                     keepTicketAction();
                     break;
                  case 115:
                     importTableSetStructureAction();
                     break;
                  case 114:
                     importTableSetAction();
                     break;
                  case 113:
                     importTableAction();
                     break;
                  case 112:
                     exportTableSetStructureAction();
                     break;
                  case 111:
                     exportTableSetAction();
                     break;
                  case 110:
                     exportTableAction();
                     break;
                  case 109:
                     setQueryCacheThreshold();
                     break;
                  case 108:
                     setQueryCacheHashRange();
                     break;
                  case 107:
                     setQueryCacheMaxSize();
                     break;
                  case 106:
                     setQueryCacheMaxEntry();
                     break;
                  case 103:
                     setQueryCacheParamAction();
                     break;
                  case 102:
                     cleanQueryCacheAction();
                     break;
                  case 101:
                     showQueryCacheAction();
                     break;
                  case 100:
                     listQueryCacheAction();
                     break;
                  case 99:
                     disableQueryCacheAction();
                     break;
                  case 98:
                     enableQueryCacheAction();
                     break;
                  case 97:
                     setTableCacheHashRange();
                     break;
                  case 96:
                     setTableCacheMaxEntry();
                     break;
                  case 95:
                     setTableCacheMaxSize();
                     break;
                  case 94:
                     setTableCacheFilter();
                     break;
                  case 91:
                     setTableCacheParamAction();
                     break;
                  case 90:
                     cleanTableCacheAction();
                     break;
                  case 89:
                     showTableCacheAction();
                     break;
                  case 88:
                     listTableCacheAction();
                     break;
                  case 87:
                     disableTableCacheAction();
                     break;
                  case 86:
                     enableTableCacheAction();
                     break;
                  case 85:
                     disableAutoCorrectAction();
                     break;
                  case 84:
                     enableAutoCorrectAction();
                     break;
                  case 83:
                     disableAppendModeAction();
                     break;
                  case 82:
                     enableAppendModeAction();
                     break;
                  case 81:
                     setNumQueryCostAction();
                     break;
                  case 80:
                     setNumQueryLastAction();
                     break;
                  case 79:
                     setTSLogUserAction();
                     break;
                  case 78:
                     setTSSortAreaSizeAction();
                     break;
                  case 77:
                     setTSLogSizeAction();
                     break;
                  case 76:
                     setTSLogNumAction();
                     break;
                  case 75:
                     setTSRootPathAction();
                     break;
                  case 74:
                     setTSAppSizeAction();
                     break;
                  case 73:
                     setTSTmpSizeAction();
                     break;
                  case 72:
                     setTSSysSizeAction();
                     break;
                  case 71:
                     setCheckpointAction();
                     break;
                  case 70:
                     setTSInitFileAction();
                     break;
                  case 69:
                     showBackupMngAction();
                     break;
                  case 68:
                     showLogMngAction();
                     break;
                  case 67:
                     setBackupMngAction();
                     break;
                  case 66:
                     setLogMngAction();
                     break;
                  case 65:
                     recoverTableSetAction();
                     break;
                  case 64:
                     restoreTableSetAction();
                     break;
                  case 63:
                     syncTableSetAction();
                     break;
                  case 62:
                     listBackupAction();
                     break;
                  case 61:
                     endBackupAction();
                     break;
                  case 60:
                     executeBackupAction();
                     break;
                  case 59:
                     beginBackupAction();
                     break;
                  case 58:
                     removeArchLogAction();
                     break;
                  case 57:
                     addArchLogAction();
                     break;
                  case 56:
                     disableArchLogAction();
                     break;
                  case 55:
                     enableArchLogAction();
                     break;
                  case 54:
                     traceOffAction();
                     break;
                  case 53:
                     traceOnAction();
                     break;
                  case 52:
                     removePermAction();
                     break;
                  case 51:
                     setRightPerm();
                     break;
                  case 50:
                     setFilterPerm();
                     break;
                  case 49:
                     setTableSetPerm();
                     break;
                  case 46:
                     setPermAction();
                     break;
                  case 45:
                     dropRoleAction();
                     break;
                  case 44:
                     createRoleAction();
                     break;
                  case 43:
                     showRoleAction();
                     break;
                  case 42:
                     listRoleAction();
                     break;
                  case 41:
                     removeRoleAction();
                     break;
                  case 40:
                     assignRoleAction();
                     break;
                  case 39:
                     changePwdAction();
                     break;
                  case 38:
                     removeUserAction();
                     break;
                  case 37:
                     listUserAction();
                     break;
                  case 36:
                     addUserAction();
                     break;
                  case 35:
                     correctTableSetAction();
                     break;
                  case 34:
                     verifyTableSetAction();
                     break;
                  case 33:
                     addDataFileAction();
                     break;
                  case 32:
                     removeTableSetAction();
                     break;
                  case 31:
                     dropTableSetAction();
                     break;
                  case 30:
                     stopRecoveryAction();
                     break;
                  case 29:
                     startRecoveryAction();
                     break;
                  case 28:
                     stopTableSetAction();
                     break;
                  case 27:
                     startTableSetAction();
                     break;
                  case 26:
                     createTableSetAction();
                     break;
                  case 25:
                     defineTableSetAction();
                     break;
                  case 24:
                     abortDbThreadAction();
                     break;
                  case 23:
                     transactionInfoAction();
                     break;
                  case 22:
                     admThreadInfoAction();
                     break;
                  case 21:
                     dbQueryHistCostAction();
                     break;
                  case 20:
                     dbQueryHistLastAction();
                     break;
                  case 19:
                     dbThreadQueryHistAction();
                     break;
                  case 18:
                     dbThreadInfoAction();
                     break;
                  case 17:
                     lockStatAction();
                     break;
                  case 16:
                     threadInfoAction();
                     break;
                  case 15:
                     buStatResetAction();
                     break;
                  case 14:
                     buStatInfoAction();
                     break;
                  case 13:
                     buFileInfoAction();
                     break;
                  case 12:
                     objInfoAction();
                     break;
                  case 11:
                     logInfoAction();
                     break;
                  case 10:
                     archLogInfoAction();
                     break;
                  case 9:
                     dataFileInfoAction();
                     break;
                  case 8:
                     listTableSetAction();
                     break;
                  case 7:
                     lockInfoAction();
                     break;
                  case 6:
                     rawModeOff();
                     break;
                  case 5:
                     rawModeOn();
                     break;
                  case 4:
                     poolEntryListAction();
                     break;
                  case 3:
                     tableSetInfoAction();
                     break;
                  case 2:
                     parameterInfoAction();
                     break;
                  case 1:
                     poolInfoAction();
                     break;
               }
               break;
            }
            case ACCEPT:
            {
               statementAction();
               return;
            }
            case NULLACTION:
               break;
         }
      }
      else
      {
         Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
         throw Exception(EXLOC, msg);
      }
   }
}


bool CegoAdm::getAction(unsigned state, CegoAdm::Token token, CegoAdm::Action& a, unsigned& num)
{
    if (_actionMap[state][token].getAction() != NULLACTION )
    {
	a = _actionMap[state][token].getAction();
	num = _actionMap[state][token].getNum();
	return true;
    }
    else
    {
	return false;
    }
}

bool CegoAdm::getJump(unsigned state, Production prod, unsigned& fstate)
{
    if ( _jumpMap[state][prod] > 0 )
    {
       fstate = _jumpMap[state][prod];
	    return true;
    }
    else
    {
	    return false;
    }
}

bool CegoAdm::isSepSign(char c)
{
   if (c == '.') return true;
   if (c == ';') return true;
   if (c == ',') return true;
   if (c == '=') return true;
   if (c == '<') return true;
   if (c == '>') return true;
   if (c == ')') return true;
   if (c == '(') return true;
   if (c == '[') return true;
   if (c == ']') return true;
   if (c == '*') return true;
   if (c == '/') return true;
   if (c == '+') return true;
   if (c == '-') return true;
   if (c == '|') return true;
   return false;
}
bool CegoAdm::isSepIgnore(char c)
{
   if (c == '\t') return true;
   if (c == ' ') return true;
   return false;
}
bool CegoAdm::shiftToken()
{
   unsigned long i=0;
   char c;
   while ( isSepIgnore(c = nextChar()) && ! _isReserved );
   if ( _isReserved )
   {
      _token = _reservedToken;
      _isReserved = false;
      return true;
   }
   if (c == 0)
   {
      _token = ENDTOKEN;
      return true;
   }
   if (isSepSign(c))
   {
      _tokenVal[i]=c;
       i++;
   }
   else
   {
      while (c && ! isSepIgnore(c) && ! ( isSepSign(c) && i>0 ) )
      {
         _tokenVal[i]=c;
         i++;
         if ( i >= MAXTOKENVAL )
         {
            throw Exception(EXLOC, Chain("Token length exceeded"));
         }
         c = nextChar();
      }
      if (isSepSign(c)) backChar();
   }
   _tokenVal[i]=0;
   Scanner* pS = _scannerList.First();
   while (pS)
   {
      if (pS->checkPattern(_tokenVal))
      {
         _token = pS->getToken();
         return true;
      }
      pS=_scannerList.Next();
   }
   return false;
}
void CegoAdm::setReserved(Token t)
{
   _reservedToken = t;
   _isReserved = true;
}
