#ifndef _CEGOTRANSACTIONMANAGER_H_INCLUDED_
#define _CEGOTRANSACTIONMANAGER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTransactionManager.h
// ------------------------
// Cego transaction manager class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoTransactionManager
// 
// Description: Transaction data structures
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/SetT.h>
#include <lfcbase/Chain.h>

// cego includes
#include "CegoDefs.h"
#include "CegoTableManager.h"
#include "CegoTableObject.h"
#include "CegoQueryHelper.h"

#define MAXTRANSACTION 30

// forward declaration
class CegoTableManager;

class CegoTransactionManager {
    
public:

    CegoTransactionManager(CegoTableManager* pTM);
    ~CegoTransactionManager();
       
    void release(unsigned tabSetId);
    void reorgSystemSpace(unsigned tabSetId);
    void recordUpdate(unsigned tabSetId, unsigned long long tid, const CegoDataPointer& dp );
    void commitUpdate(unsigned tabSetId, const Chain& idxName, const CegoObject::ObjectType idxType, unsigned long long tid, bool doAppend);
    void abortUpdate(unsigned tabSetId, unsigned long long tid);
    void getRBDataPtr(unsigned tabSetId, unsigned long long tid, PageIdType pageId, unsigned offset, unsigned& rbfileId, unsigned& rbpageId, unsigned& rboffset);
    void newRBEntry(unsigned tabSetId, unsigned long long tid, PageIdType pageId, unsigned offset, const Chain& tableName);
    unsigned long long commitTransaction(unsigned tabSetId, unsigned long long tid);
    void getCrashAffectedTables(unsigned tabSetId, SetT<Chain>& tableList);
    void getTransactionAffectedTables(unsigned tabSetId, unsigned long long tid, SetT<Chain>& tableList);
    bool hasOpenTransaction(unsigned tabSetId, const Chain& tableName) const;
    void finishOpenTransaction(unsigned tabSetId);
    unsigned long long rollbackTransaction(unsigned tabSetId, unsigned long long tid);
    void getTransactionInfo(unsigned tabSetId, const Chain& rbo, unsigned& numop);
     
private:
    
    class TAEntry {
	
    public:
	
	TAEntry();
	TAEntry(const unsigned long long tid);
	TAEntry(const unsigned long long tid,
		// const CegoBufferPage& bp,
		const CegoTableObject& oe);
	~TAEntry();
	
	const unsigned long long getTid() const;
	
	CegoTableObject& getTableObject();
	
	TAEntry& operator = ( const TAEntry& t);
        bool operator == ( const TAEntry& t);
	
	friend ostream& operator << (ostream& s, const TAEntry& t)
	{
	    s << "(" << t._tid << ")";
	    return s;
	}

    private:

	unsigned long long _tid;
	CegoTableObject _oe;
    };

    unsigned long long doCommit(unsigned tabSetId, const Chain& rbo);
    unsigned long long doRollback(unsigned tabSetId, const Chain& rbo);

    ListT<TAEntry> _taList;
    ListT<TAEntry> _udList;
    CegoDatabaseManager *_pDBMng;
    CegoTableManager* _pTabMng;
    ListT<CegoField> _updSchema;
    ListT<CegoField> _rbcatSchema;
    CegoQueryHelper _qh;

    unsigned long _modId;
};
#endif
