///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcQueryStmt.cc  
// --------------------
// Cego procedure query statement implementation
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2025 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcQueryStmt
// 
// Description: Stored procedure query statement
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// cego include
#include "CegoQueryException.h"
#include "CegoProcQueryStmt.h"
#include "CegoExpr.h"
#include "CegoDatabaseFormater.h"

CegoProcQueryStmt::CegoProcQueryStmt(CegoQuery *pQuery,
				     CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _pQuery = pQuery;
}

CegoProcQueryStmt::~CegoProcQueryStmt()  
{
    delete _pQuery;
}

CegoException CegoProcQueryStmt::execute()
{
    // _pQuery->setBlock(getParentBlock());    
    
    try 
    {
	Chain msg = _pQuery->execute(getParentBlock());
    }
    catch ( CegoQueryException qe ) 
    {
	CegoProcBlock *pBlock = getParentBlock();
	if ( pBlock )
	{
	    Chain excepMsg;	    
	    excepMsg = qe.getBaseMsg();
	    pBlock->setExceptionMsg(excepMsg);
	}
	
	return qe.getException();
    }
    
    return NONE_EXCEP;
}

void CegoProcQueryStmt::cleanUp()
{
    _pQuery->cleanUp();
}

Chain CegoProcQueryStmt::toChain(unsigned defTabSetId, const Chain& indent) const
{
    Chain s;
    s = indent + _pQuery->toChain(defTabSetId, indent);
    return s;
}

Chain CegoProcQueryStmt::dbFormat(CegoDatabaseFormater *pForm) const
{
    return pForm->formatProcQueryStmt(_pQuery);
}

bool CegoProcQueryStmt::isStatic() const
{
    return false;
}
