#ifndef _CEGOPROCOBJECT_H_INCLUDED_
#define _CEGOPROCOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcObject.h
// ----------------
// Cego procedure object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcObject
// 
// Description: Container class for Cego stored procedures
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// xml includes
#include <lfcxml/Element.h>

// cego includes
#include "CegoField.h"
#include "CegoDecodableObject.h"

class CegoProcObject : public CegoDecodableObject {

public:

    CegoProcObject();
    CegoProcObject(const CegoProcObject& ko);
    CegoProcObject(const Chain& procName, unsigned tabSetId = 0);
    CegoProcObject(unsigned tabSetId, const Chain& procName, const Chain& procText);
    ~CegoProcObject();
    
    unsigned getEntrySize() const;
    void encode(char *buf) const;
    void decode(char *buf);
    const Chain& getProcText() const;
    void setEmpty();

    Chain getInfo() const;
    
    CegoProcObject& operator = ( const CegoProcObject& oe);
    bool operator == ( const CegoProcObject& oe);

private:

    Chain _procText;

};
#endif

