#ifndef _CEGOGROUPSPACE_H_INCLUDED_
#define _CEGOGROUPSPACE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoGroupSpace.h
// -----------------
// Cego group space class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoGroupSpace
// 
// Description: Utility class for grouping tuples
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// CEGo INCLUDES
#include "CegoDefs.h"
#include "CegoAttrDesc.h"
#include "CegoTableManager.h"
#include "CegoGroupCursor.h"
#include "CegoGroupNode.h"

class CegoGroupSpace {
    
public:

    CegoGroupSpace();
    ~CegoGroupSpace();
       
    void initGroupSpace(const ListT<CegoField>& schema, ListT<CegoAggregation*>& aggList, unsigned long long maxGroupSize);

    void insertTuple(ListT<CegoField>& groupTuple);

    void resetGroupSpace();

    ListT<CegoField> getSchema();

    CegoGroupCursor* getCursor();

    unsigned long long numAllocated() const;

private:

    ListT<CegoField> initGrouping(ListT<CegoField>& dataTuple);
    ListT<CegoField> aggGrouping(ListT<CegoField>& aggValues, ListT<CegoField>& dataTuple);

    CegoFieldValue getValueForAgg(CegoAggregation* pAgg, ListT<CegoField>& dataTuple);

    unsigned _groupingOffset;

    ListT<CegoField> _groupSchema;

    CegoAggregation* _pCountAgg;

    ListT<CegoAggregation*> _aggList;
    ListT<CegoField> _aggSchema;

    AVLTreeT<CegoGroupNode>* _pAVL;

    unsigned long long _maxOrderSize;
    unsigned long long _orderSize;
};
#endif
