#ifndef _CEGODISTDBHANDLER_H_INCLUDED_
#define _CEGODISTDBHANDLER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDistDbHandler.h
// -------------------
// Cego distributed db handler class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoDistDbHandler
// 
// Description: Database client interface to the access the database backend via network 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/NetHandler.h>
#include <lfcxml/XMLSuite.h>

// CEGO INCLUDES
#include "CegoAlterDesc.h"
#include "CegoDbHandler.h"
// #include "CegoPredicate.h"
#include "CegoObject.h"
#include "CegoTableObject.h"
#include "CegoKeyObject.h"
#include "CegoCheckObject.h"
#include "CegoProcVar.h"

class CegoDistDbHandler : public CegoDbHandler {
    
public:
   
    CegoDistDbHandler(NetHandler *pN, ProtocolType pt, CegoModule *pModule);
    ~CegoDistDbHandler();

    ResultType reqInsertOp(const Chain& tableSet, const Chain& tableName, const ListT<CegoField>& fl);    

    /*
    ResultType reqUpdateOp(const Chain& tableSet, 
			   const Chain& tableName,
			   const ListT<CegoField>& updSchema, 
			   const ListT<CegoExpr*>& exprList,
			   CegoPredDesc* pPred);

    ResultType reqDeleteOp(const Chain& tableSet, const Chain& tableName, CegoPredDesc* pPred);
    */
    
    ResultType reqCreateTableOp(const Chain& tableSet, const Chain& tableName, CegoObject::ObjectType type, const ListT<CegoField>& fl, const ListT<CegoField>& idxList);


    // ResultType reqAlterTableOp(const Chain& tableSet, const Chain& tableName, const ListT<CegoAlterDesc>& alterList);
    
    ResultType reqCreateIndexOp(const Chain& tableSet, const Chain& indexName, const Chain& tableName, CegoObject::ObjectType type, const ListT<CegoField>& idxList);
    ResultType reqCreateFKeyOp(unsigned tabSetId, const Chain& fkey, const Chain& tableName, const ListT<CegoField>& keyList, const Chain& refTable, const ListT<CegoField>& refList);

    ResultType reqDropObjectOp(const Chain& tableSet, const Chain& tableName, CegoObject::ObjectType type);

    ResultType reqObjectInfoOp(unsigned tabSetId, const Chain& objName, CegoObject::ObjectType type);

    ResultType reqCreateViewOp(const Chain& tableSet, const Chain& viewName, const ListT<CegoField>& fl, const Chain& viewText);
    ResultType reqCreateProcOp(const Chain& tableSet, const Chain& procName, const Chain& procText);

    ResultType reqCreateTriggerOp(const Chain& tableSet, const Chain& triggerName, const Chain& tableName, const Chain& triggerText);

    ResultType reqTableDataOp(unsigned tabSetId, const Chain& tableName, CegoObject::ObjectType type);

    ResultType reqGetObjectListOp(unsigned tabSetId, CegoObject::ObjectType type);
    ResultType reqGetObjectByTableListOp(const Chain& tableSet, const Chain& tableName); 

    ResultType reqRenameOp(const Chain& tableSet, const Chain& objName, CegoObject::ObjectType type, const Chain& newObjName);
    ResultType reqSyncOp(const Chain& tableSet, const Chain& escCmd, unsigned timeout);

    ResultType reqGetPageCount(const Chain& tableSet, const Chain& objName, CegoObject::ObjectType type);    

    ResultType reqReorgObjectOp(const Chain& tableSet, const Chain& tableName, CegoObject::ObjectType type);


    // ResultType reqCreateCheckOp(const Chain& tableSet, const Chain& checkName, const Chain& tableName, CegoPredDesc* pPred);

    ResultType reqStartTransactionOp(const Chain& tableSet);
    ResultType reqCommitTransactionOp(const Chain& tableSet);
    ResultType reqRollbackTransactionOp(const Chain& tableSet);
    ResultType reqGetTidOp(const Chain& tableSet);

    void getArgValue(const Chain& arg, Chain& value);

    void getInsertArg(Chain& tableSet, Chain& tableName, ListT<CegoField>& fl);

    
    // deprecated
    // void getDeleteArg(Chain& tableSet, Chain& tableName, CegoPredDesc*& pPred, CegoDistManager* pGTM);
    // void getUpdateArg(Chain& tableSet, Chain& tableName, ListT<CegoField>& fl, ListT<CegoExpr*>& exprList, CegoPredDesc*& pPred, CegoDistManager* pGTM);
    
    void getCreateTableArg(Chain& tableSet, Chain& tableName, ListT<CegoField>& fl, ListT<CegoField>& idxList);

    void getCreateViewArg(Chain& tableSet, Chain& viewName, ListT<CegoField>& fl, Chain& viewText);
    void getCreateProcedureArg(Chain& tableSet, Chain& procName, Chain& procText);


    // deprecated
    // void getCreateCheckArg(Chain& tableSet, Chain& checkName, Chain& tableName, CegoPredDesc*& pPred, CegoDistManager* pGTM);
    // void getAlterTableArg(Chain& tableSet, Chain& tableName, ListT<CegoAlterDesc>& alterList);

    void getDropTableArg(Chain& tableSet, Chain& tableName, CegoObject::ObjectType& type);
    void getCreateIndexArg(Chain& tableSet, Chain& indexName, Chain& tableName, ListT<CegoField>& idxList, CegoObject::ObjectType& type);
    void getObjectInfoArg(unsigned& tabSetId, Chain& objName, CegoObject::ObjectType& type);
    void getGetTableArg(unsigned& tabSetId, Chain& tableName, CegoObject::ObjectType& type);

    void getRenameArg(Chain& tableSet, Chain& objName, CegoObject::ObjectType& type, Chain& newObjName);

    void getReorgArg(Chain& tableSet, Chain& objName, CegoObject::ObjectType& type);

    void getGetObjectListArg(unsigned& tabSetId, CegoObject::ObjectType& type);

    void getGetObjectByTableListArg(Chain& tableSet, Chain& tableName);
    void getSyncArg(Chain& tableSet, Chain& escCmd, unsigned& timeout);

    void getDropTableArg(Chain& tableName);
    void getPageCountArg(Chain& tableSet, Chain& objName, CegoObject::ObjectType& type);

    void sendPageCount(unsigned pageCount);
    void sendTID(unsigned tid);
    void sendObjList(const ListT<Chain>& objList);
    void sendObjByTableList(const ListT<CegoTableObject>& idxList, const ListT<CegoKeyObject>& keyList, const ListT<CegoCheckObject>& checkList);

    void getObjectList(ListT<Chain>& objList);
    void getObjectByTableList(ListT<CegoTableObject>& idxList, ListT<CegoKeyObject>& keyList, ListT<CegoCheckObject>& checkList);
    void getPageCount(unsigned& pageCount);    

private:

    unsigned long _modId;
};
#endif
