#ifndef _CEGODISTCURSOR_H_INCLUDED_
#define _CEGODISTCURSOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDistCursor.h
// ----------------
// Cego distributed table cursor class definition
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoDistCursor
// 
// Description: Table cursor for distributed table access
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoTableCursor.h"
#include "CegoAttrCond.h"
#include "CegoField.h"
#include "CegoDistDbHandler.h"
#include "CegoTableCache.h"
#include "CegoPredicate.h"
#include "CegoProcBlock.h"


class CegoDistManager;

class CegoDistCursor  {
    
public:
    
    CegoDistCursor();
    CegoDistCursor(CegoDistManager* pGTM, CegoContentObject *pCO, CegoProcBlock *pBlock); 
    ~CegoDistCursor();

    void distSetup( ListT<CegoField>** pFLA, CegoPredicate *pPred);
    void distSetup(CegoAttrCond& attrCond, ListT<CegoField>** pFLA, CegoPredicate *pPred);
    
    // bool nextTuple(ListT<CegoField>& fl);
    bool nextTuple(ListT<CegoField>** pFLA, unsigned pos, unsigned size);

    void reset();

    Element* getPlan();

 private:

    void useCursorObject();
    void unuseCursorObject();
    void checkType();
    
    void sysSetup();
    void joinSetup(const CegoAttrCond& attrCond);
    bool evalCondition(ListT<CegoField>** pFLA, unsigned pos, unsigned size);
    bool evalCompare(CegoAttrComp* pAC, ListT<CegoField>** pFLA, unsigned pos, unsigned size);
    bool getTuple(ListT<CegoField>** pFLA, unsigned offset, unsigned size);

    void nextRight(ListT<CegoField>** pFLA, unsigned offset, unsigned size);
    void nextLeft(ListT<CegoField>** pFLA, unsigned offset, unsigned size);

    void finishCaching();
    
    CegoDistManager* _pGTM;
    CegoTableCache* _pCache;
    
    Chain _tableName;
    Chain _tableAlias;

    unsigned _tabSetId;

    CegoSelect *_pSelect;
    CegoTableCursor* _pTC;
    CegoObjectCursor* _pC;

    CegoDistCursor* _pTCLeft;
    CegoDistCursor* _pTCRight;

    CegoTableObject* _pTO;
    CegoDistCursor* _pTCTab;
    ListT<CegoField>* _pFLAmap;
    
    CegoContentObject *_pCO;
    CegoDatabaseManager *_pDBMng;
    CegoDistDbHandler* _pSH; 

    ListT<CegoField> _schema;

    unsigned long _modId;

    bool _cursorObjectUsed;
    bool _isLocal;
    bool _moreTuple;
    bool _isFirst;

    bool _useCache;
    unsigned _cacheRows;
    unsigned _cacheCols;
    
    unsigned _cachePos;
    
    bool _evalPredicate;
    bool _isAttrCondValid;
    
    bool _doEval;
    
    bool _moreLeft;
    bool _moreRight;

    CegoPredicate* _pPropPred;
    CegoPredicate* _pJoinPred;
    
    CegoAttrCond _cursorCond;
    CegoAttrCond _innerCond;
    CegoAttrCond _outerCond;

    CegoAttrCond::IndexMatch _idxMatch;

    ListT<Chain> _sysObjList;

    unsigned _cacheEntrySize;
    ListT<CegoField> _cacheSchema;
    CegoFieldValue*** _pCacheArray;
    ListT< ListT<CegoFieldValue> >* _pCacheList;
    bool _isCached;

    CegoProcBlock* _pBlock; 
    ListT<CegoField>** _pFLA;
};
#endif
