#ifndef _CEGODEFS_H_INCLUDED_
#define _CEGODEFS_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDefs.h
// ----------
// Cego database tuning parameters
//                                                         
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: NA
// 
// Description: All constant definitions 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include <config.h>

#define CEGO_PRODUCT PACKAGE_NAME
#define CEGO_VERSION PACKAGE_VERSION
#define CEGO_COPYRIGHT "Copyright (C) 2000-2026 by Bjoern Lemke. All rights reserved"

#define CGEXESHELLVARNAME "CGEXESHELL"
#define CGSTDEXESHELL "/bin/sh"

/*******************************/
/* File Management Parameters */
/*******************************/

/* maximum number of datafiles, that can be managed */
/* Please note, that id values from 1 to TABMNG_MAXTABSET are reserved for system files */
#define FILMNG_MAXDATAFILE 5000

#define PageIdType unsigned long long

/*******************************/
/* Table Management Parameters */
/*******************************/

/* maximum number of tablesets, that can be managed */
#define TABMNG_MAXTABSET 200

/* maximum size of index entry values */
#define TABMNG_MAXINDEXVALUE 1000
/* maximum size of btree dimension */
#define TABMNG_MAXBTREECOMP 10

/* size of the hash array for parallel object access */
#define TABMNG_HASHSIZE 15

/* suffix defs */
#define TABMNG_PIDX_SUFFIX "_pidx"
#define TABMNG_PBTREE_SUFFIX "_pbtree"
#define TABMNG_SYSSUFFIX ".sys"
#define TABMNG_TEMPSUFFIX ".temp"
#define TABMNG_APPSUFFIX ".dat"
#define TABMNG_LOGSUFFIX ".log"
#define TABMNG_XMLSUFFIX ".xml"

/* how many tables can be joned with one select */
#define TABMNG_MAXJOINLEVEL 30
#define TABMNG_MAXTMPSCHEMA 30

/******************************************/
/* Log and Recovery Management Parameters */
/******************************************/

#define LOGMNG_RECOVERY_DELAY 2
#define LOGMNG_LOGSWITCH_WAIT_DELAY 2
#define LOGMNG_MAXLOGCOUNT 200
#define LOGMNG_RECBUFSIZE 65536
#define LOGMNG_NONEPROG "NONE"
#define LOGMNG_WBUFSIZE 1024
#define LOGMNG_MAXNUMLOGFILE 100
#define LOGMNG_ARCHLOGSEP "-"
#define LOGMNG_ARCHLOGSUFFIX ".dbf"

/************************/
/* Data Type Parameters */
/************************/
#define MAX_INT_LEN 10
#define MAX_LONG_LEN 20
#define MAX_FLOAT_LEN 40
#define MAX_DOUBLE_LEN 45
#define MAX_SMALLINT_LEN 6
#define MAX_TINYINT_LEN 4
#define MAX_DATETIME_LEN 30 /* Mon Dec 11 09:10:26 2006 CET*/
#define MAX_BOOL_LEN 5 /* false */
#define MAX_BLOB_LEN 10
#define MAX_NULL_LEN 4 /* null */
#define MAX_OBJNAME_LEN 50 
#define MAXSTRINGLEN 10000
#define BLOB_BLOCKSIZE 1024
#define CLOB_BLOCKSIZE 1024
#define STATICFIELDBUF 20 /* statically allocated buffer for field values, should be at least 8 byte */
#define CLOB_FORMAT_LEN 30
#define RETVAL_LEN 30

/* Number of bytes which are reserved for btree objects for type fixed, decimal and bigint
   This is the max dimension, the attributes can be defined, if btree objects should be created on it */
#define RESERVED_BTREE_FLOATLEN 30

#define MAX_CAST 20
/******************************/
/* Lock Management Parameters */
/******************************/

/* heart beat delay for writing lock file */
#define LCKMNG_BEATDELAY 15

/* the amount of semaphores used for locking database data files  */
#define LCKMNG_NUM_DATAFILE_SEMA 1021

/* number of semaphores allocated for buffer pool page locking */
#define LCKMNG_NUM_BUFFERPOOL_SEMA 1021

/* number of semaphores allocated for record lock operations */
#define LCKMNG_NUM_RECORD_SEMA 1021

/* number of semaphores allocated for rb record lock operations */
#define LCKMNG_NUM_RBRECORD_SEMA 1021

/* number of semaphores allocated for rb record lock operations */
#define LCKMNG_NUM_SYSRECORD_SEMA 1021

/* number of semaphores allocated for system page lock operations */
#define LCKMNG_NUM_SYSPAGE_SEMA 1021

/* number of semaphores allocated for data page lock operations */
#define LCKMNG_NUM_DATAPAGE_SEMA 1021

/* number of semaphores allocated for index page lock operations */
#define LCKMNG_NUM_IDXPAGE_SEMA 1021

/* number of semaphores allocated for rb page lock operations */
#define LCKMNG_NUM_RBPAGE_SEMA 1021

/* number of record, system- and data page lock operations that can be done in parallel by one thread.
   Note: the number of lock operations may be higher that the number of available semaphores
   Value is valid per file-, bufferpool-, record-, system page- and data page locks */ 
#define LCKMNG_NUMLOCKS 50

/* the interval in msec a thread goes asleep waiting to achieve a lock.
   Setting this value higher decreases CPU load but delays thread synchronization */
#define LCKMNG_LOCKWAITDELAY 10

/* lock delay resolution */
#define LCKMNG_DELRES 1000

#define LCKMNG_NUMLOCKTRIES 3

/* FileHandler lock timeout in msec */
#define FH_LOCKTIMEOUT 30000

/* BufferPool lock timeout in msec */

/* this was increased becasue for large bufferpool configurations, timeouts may 
   occur during checkpoint writes, of caused by deadlocks */
#define BP_LOCKTIMEOUT 60000

/* Page lock timeout in msec */
#define PG_LOCKTIMEOUT 30000

/* Record lock timeout in msec */
#define RC_LOCKTIMEOUT 30000

/* XMLSpace lock timeout in msec */
#define XS_LOCKTIMEOUT 30000

/* Db Thread Query History lock timeout in msec */
#define QH_LOCKTIMEOUT 30000

/* Date Format lock timeout in msec */
#define DF_LOCKTIMEOUT 30000

/* Log manager lock timeout in msec */
#define LM_LOCKTIMEOUT 30000

/* Database Manager lock timeout in msec */
#define DBM_LOCKTIMEOUT 30000

/* Database Manager number of lock tries */
#define DBM_MAXLOCKTRIES 30

/* Database manager lock delay timeout in msec */
#define DBM_LOCKDELAY 2500

/* Tableset Manager stop delay to await save hanging query termination */
#define TS_STOPDELAY 3

#define RECLOCKGROUP "RECLOCK"
#define RBRECLOCKGROUP "RBRECLOCK"
#define SYSRECLOCKGROUP "SYSRECLOCK"
#define SYSPAGELOCKGROUP "SYSPAGELOCK"
#define DATAPAGELOCKGROUP "DATAPAGELOCK"
#define IDXPAGELOCKGROUP "IDXPAGELOCK"
#define RBPAGELOCKGROUP "RBPAGELOCK"
#define DATAFILELOCKGROUP "DATAFILELOCK"
#define POOLLOCKGROUP "POOLLOCK"

/* max number of object usage for any object in parallel
   this also limits the recursive depth for any user defined function/procedure call */

#define MAX_OBJECT_USAGE 200

/*************************************/
/* Buffer Pool Management Parameters */
/*************************************/

/* BUPMNG_MAXFIXTRIES is the range for searching a free slot in the buffer pool
   Increasing this values leads to a better usage of the bufferpool but 
   less performance */
 
#define BUPMNG_MAXFIXTRIES 30

/* For each buffer page, a number of pointer entries ( sizeof int ) is reserved for free pointer management
   The number of pointers is calculated based on the current pagesize. BUPMNG_MINFREERATIO percent of the
   page is reserved for pointers to free blocks. 
   To avoid a minfree exception, the BUPMNG_MINFREERATIO value should be set to the minimum tuple size of the database
   */

#define BUPMNG_MINFREERATIO 10

/* For some processor architecture ( SPARC ) , an adress alignment is required for pointer arithmetic 
   Normally, this is the natural word size of the machine */

#define BUPMNG_ALIGNMENT sizeof(long)

/* The Cego BufferPool collects some statistic information ( e.g. number and avg performance of disk io )
   Since the collected values may exceed after some time, the corresponding counters must be reset.
   The reset is triggered after BUPMNG_STATSPERIOD bufferFix operations have been performed */  

#define BUPMNG_STATSPERIOD 100000
#define BUPMNG_STATDTFORMAT "%d.%m.%Y %H:%M:%S"

/* number of tries to fix a buffer by checkpointing */
#define BUPMNG_FIXLOOP 3

/* maximum number of released pages in the checkpoint queue */
#define BUPMNG_MAXPAGEDELETE 500

/* maximum number of released pages in the checkpoint queue */
#define BUPMNG_RELOCATION_THRESHOLD 10

/* timeout value for synchronous checkpoint escape command ( in seconds ) */
#define ESCCMDTIMEOUT 60

/* timeout value for logfile archiving ( in seconds ) */
#define LOGARCHTIMEOUT 60

#define CHECKPOINTINTERVAL 3600
#define CHECKPOINTDUMPFILE "cpdump"
#define DUMP_PROCESS_POSTFIX ".dip"
#define DUMP_READY_POSTFIX ".rdy"

/**********************/
/* Network Parameters */
/**********************/

// size info buffer len
// don't chane this value, since it must correlate with several DB driver implementation ( DBD, JDBC ) 
#define NETMNG_SIZEBUFLEN 10

// msg timeout for select system call in usec
#define NETMNG_SELECT_TIMEOUT 3000000 // 3 sec

// message queue delay to avoid CPU load in usec
#define NETMNG_QUEUE_DELAY 200000 // 200 msec

// msg timeout for recv system call in sec
#define NETMNG_SEND_TIMEOUT 180

// msg timeout for recv system call in sec
#define NETMNG_RECV_TIMEOUT 180

// msg timeout for recv system call in msec
#define NETMNG_WAITMSG_TIMEOUT 10000

// maximum net msg size
#define NETMNG_MSG_BUFLEN 4096 

// max send len of network msg
// it has been observed, that on FreeBSD based systems, this size should be set to a higher value,
// if large network messages occur. Otherwise, network performance is throttled down, since for a single message,
// subsequent ::send socket calls have to be done. On Mac OSX this behaviour has not been observed
// A value of 8k seems to be appropriate
#define NETMNG_MAXSENDLEN 8192

/* prefix sign for unique col identification */
#define NETMNG_COLPREFIX "c"

/* the maximum number of tuples, which are transferd with one socket send call */
#define NETMNG_MAXTUPLECOUNT 500
#define NETMNG_MAXBYTECOUNT 10000000

/* check interval to check for expired db connections in seconds */
#define NETMNG_DBHANDLE_CHK 10

/* time to life for a created db session handler in seconds */
#define NETMNG_DBHANDLE_TTL 60

// maximum number of requests in poolconnection queue
#define NETMNG_MAXQUEUELEN 10

/*******************/
/* Pool Parameters */
/*******************/

// wait delay for thread termination of all threads in db, admin and log pool ( in sec )
#define POOL_TERMWAIT 20

/******************************/
/* User Management Parameters */
/******************************/

// encryption seed, should match with defintion in JDBC driver 
#define CEGOSALT "$1$hgz"
#define CEGOAESKEYLEN 128
#define CEGOAESKEY "thisisthecegoaeskey"

/*************************/
/* Stored Procedure Defs */
/*************************/

/* name of variable, to store exception information message */
#define EXCEPINFO "excep_info"
#define COREOP_EXCEP_ID "core_op"
#define OTHER_EXCEP_ID "other"
#define ANY_EXCEP_ID "any"

/*********************/
/* Index customizing */
/*********************/

// allow duplicated null values for unique indexes
#define ALLOW_UNIQUE_NULL true 

/*********************/
/* XPort customizing */
/*********************/

/* import read buffer for identifiers, procedure text and view stmts */
#define XP_MAXINBUF 5000
/* import column buffer for any kind of datatypes */
#define XP_MAXCOLBUF 10000
/* export/import predicate description buffer */
#define XP_MAXPDBUF 10000
#define XP_ROWINTERVAL 5000
/* maximum length of a single row */
#define XP_MAXROWBUF 20000

/********************/
/* field value defs */
/********************/

#define BLOBCHUNKSIZE 1024
#define CLOBCHUNKSIZE 1024
#define LOBSEP "[]"
#define DEFAULTDATETIMEFORMAT1 "%d.%m.%Y %H:%M:%S"
#define DEFAULTDATETIMEFORMAT2 "%d.%m.%Y"
#define DEFAULTDATETIMEFORMAT3 "%Y-%m-%d %H:%M:%S"
#define DEFAULTDATETIMEFORMAT4 "%Y-%m-%d"
#define DEFAULTINDENT "   "

/*********************/
/* system table defs */
/*********************/

#define SYSTAB_PREFIX '$'
#define SYSTAB_TABLE_ID "table"
#define SYSTAB_VIEW_ID "view"
#define SYSTAB_PROC_ID "procedure"
#define SYSTAB_INDEX_ID "index"
#define SYSTAB_BTREE_ID "btree"
#define SYSTAB_KEY_ID "key"
#define SYSTAB_NAME_ATTR "name"
#define SYSTAB_SIZE_ATTR "size"
#define SYSTAB_STATUS_ATTR "status"
#define SYSTAB_BUSTAT_ID "bustat"
#define SYSTAB_TS_ATTR "msgts"
#define SYSTAB_BUINFO_ATTR "buinfo"
#define SYSTAB_BUMSG_ATTR "msg"

/*****************/
/* grouping defs */
/*****************/

#define MIN_GROUP "MIN"
#define MAX_GROUP "MAX"
#define AVG_GROUP "AVG"
#define COUNT_GROUP "COUNT"
#define SUM_GROUP "SUM"

/*****************/
/* select defs */
/*****************/

#define SELECTION_WILDCARD "*"
#define MOD_QUERY_ID "MOD_QUERY"

/*****************/
/* info defs */
/*****************/

#define INFO_TABLESET "Tableset"
#define INFO_RUNSTATE "RunState"
#define INFO_SYNCSTATE "SyncState"
#define INFO_PRIMARY "Primary"
#define INFO_SECONDARY "Secondary"
#define INFO_MEDIATOR "Mediator"
#define INFO_ROOTPATH "RootPath"
#define INFO_TICKET "Ticket"
#define INFO_TSINITFILE "InitFile"
#define INFO_CHECKPOINT "Checkpoint"
#define INFO_LOGUSER "LogUser"
#define INFO_SYSTEMPAGETOTAL "SystemPageTotal"
#define INFO_SYSTEMPAGEUSED "SystemPageUsed"
#define INFO_TEMPPAGETOTAL "TempPageTotal"
#define INFO_TEMPPAGEUSED "TempPageUsed"
#define INFO_APPPAGETOTAL "AppPageTotal"
#define INFO_APPPAGEUSED "AppPageUsed"
#define INFO_SORTAREASIZE "SortAreaSize"
#define INFO_BRANCHID "BranchId"
#define INFO_TID "Tid"
#define INFO_CLSN "CLSN"
#define INFO_WLSN "WLSN"
#define INFO_ARCHMODE "ArchMode"
#define INFO_AUTOCORRECT "AutoCorrect"
#define INFO_APPENDMODE "AppendMode"
#define INFO_CPDUMP "CP Dump"
#define INFO_TABLECACHE "TableCache"
#define INFO_QUERYCACHE "QueryCache"
#define INFO_TABLECACHEFILTER "TC Filter"
#define INFO_TABLECACHEMAXSIZE "TC MaxSize"
#define INFO_TABLECACHEMAXENTRY "TC MaxEntry"
#define INFO_TABLECACHEHASHRANGE "TC HashRange"
#define INFO_TABLECACHEUSEDSIZE "TC UsedSize"
#define INFO_QUERYCACHEMAXENTRY "QC MaxEntry"
#define INFO_QUERYCACHEMAXSIZE "QC MaxEntrySize"
#define INFO_QUERYCACHETHRESHOLD "QC Threshold"
#define INFO_QUERYCACHEHASHRANGE "QC HashRange"
#define INFO_QUERYCACHEUSEDNUM "QC UsedNum"
#define INFO_QUERYCACHEUSEDSIZE "QC UsedSize"
#define INFO_QUERYCACHENUMFAIL "QC NumFail"
#define INFO_LOGFILE "LogFile"
#define INFO_LOGSIZE "LogSize"
#define INFO_MAXCACHEIDLEN 30

/*****************/
/* role defs */
/*****************/

#define ROLE_ADMIN "admin"
#define ROLE_JDBC "jdbc"

/*********************/
/* thread management */
/*********************/

#define THRMNG_NUMLOADSAMPLE 5

/************/
/* xml defs */
/************/
#define CEGO_DB_DOC "CEGO_DB_SPEC"
#define XML_VERSION_ATTR "version"
#define XML_VERSION_VALUE "1.0"

#define MAX_CLUSTERED_INSERT 300

/*************************/
/* procedure query cache */
/*************************/

#define PROCQUERYCACHE_MAXNUM 5

/*************************/
/* query and table cache */
/*************************/

#define QUERYCACHE_MAXTRY 7
/* delay in msec */
#define QUERYCACHE_TRYDELAYBASE 10
#define TABLECACHE_MAXTRY 7
/* delay in msec */
#define TABLECACHE_TRYDELAYBASE 10


// we take a wednesday in september as proof day, since wednesday and september are max name len
#define PROOFDATE_VALUE  "04.09.2024 12:00:00"
#define PROOFDATE_FORMAT "%d.%m.%Y %H:%M:%S"

#define REPLACER_MAXNUM 100
#define REPLACER_HASHRANGE 3


#endif
