#ifndef _CEGOBUFFERPAGE_H_INCLUDED_
#define _CEGOBUFFERPAGE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBufferPage.h
// ----------------
// Cego BufferPage Class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoBufferPage
// 
// Description: Database page container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include "CegoDefs.h"

class CegoBufferPage {
    
public:
    
    enum PageType { TABLE, TUPLE, BLOB, CLOB, BTREE_NODE, BTREE_LEAF };
    
    typedef struct PageHead {
	PageType pageType;
	PageIdType nextPageId;
    } PageHead;
    
    CegoBufferPage();
    CegoBufferPage(const CegoBufferPage& bp);
    CegoBufferPage(void *pagePtr, unsigned pageSize);
    ~CegoBufferPage();
    
    void initPage(PageType t);

    void setFixed(bool isFixed);
    bool isFixed() const;

    void setPageId(PageIdType pageId);
    PageIdType& getPageId();
        
    void setNextPageId(PageIdType pageId);
    PageIdType& getNextPageId() const;
    
    void* newEntry(unsigned size);
    void freeEntry(void *);
  
    unsigned getNumEntries();
    
    void* getFirstEntry();
    void* getNextEntry();

    char* getChunkEntry() const;

    unsigned getPageSize() const;
    unsigned getChunkLen() const;
    unsigned getEntryLen() const;
    unsigned getEntryPos() const;
    
    void setType(PageType t);
    PageType& getType() const;

    void setPagePtr(char* ptr);
    void setPageHead(PageHead* ptr);
    void setPageSize(unsigned pageSize);    

    void* getPagePtr() const;
    
    void printPage();

    CegoBufferPage& operator = ( const CegoBufferPage& bp);  
    bool operator == ( const CegoBufferPage& bp);
    bool operator != ( const CegoBufferPage& bp);

 private:

    PageIdType _pageId;
    
    unsigned _pageSize;
    char *_pagePtr;
    
    char *_ePtr;
    char *_blobPtr;
    
    unsigned _entryLen;
    unsigned _entryPos;
    
    PageHead* _pageHead;

    bool _isFixed;
};
#endif
