#ifndef _CEGOATTRCOND_H_INCLUDED_
#define _CEGOATTRCOND_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAttrCond.h
// --------------
// Cego attribute condition structure class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAttrCond
// 
// Description: Attribute condition description used for index cursors
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/ListT.h>
#include <lfcbase/TreeT.h>
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoAttrComp.h"
#include "CegoPredicate.h"

class CegoAttrCond {
    
public:
    
    enum IndexMatch { FULL, PART, INAPP };
    
    CegoAttrCond();
    ~CegoAttrCond();

    Chain getId() const;
    
    void add(const CegoAttrComp& attrComp);

    unsigned numComp() const;
    unsigned getStrength() const;

    const TreeT<CegoAttrComp>& getAttrCompSet() const;

    bool setup(const ListT<CegoField>& fl);
    bool setup(ListT<CegoField>** pJoinBuf, unsigned offset);

    bool setup(ListT<CegoField>** pParentJoinBuf, unsigned parentOffset, ListT<CegoField>** pJoinBuf, unsigned offset);
    
    CegoAttrCond getFilterCond(const ListT<CegoField>& fl, bool ignoreNullComp) const;    
    CegoAttrCond getIndexCond(const ListT<CegoField>& fl) const;

    IndexMatch checkIndex(const ListT<CegoField>& schema) const;
    // void setIdxSchema(const ListT<CegoField>& schema);

    CegoAttrComp::CompMode getPrimaryCompMode() const;

    CegoComparison getPrimaryComparison() const;
    void setPrimaryComparison(CegoComparison comp);

    bool asConjunctionList(const ListT<CegoExpr*>& exprList, ListT<CegoPredicate*>& conjunctionList) const;

    CegoPredicate*  getPred4Comp(const ListT<CegoExpr*> exprList, CegoAttrComp* pAC) const;
	
    CegoAttrComp* findComp(CegoAttrComp* pAttrComp) const;
    
    bool diff( const CegoAttrCond& ac) const;
    void update( const CegoAttrCond& ac);

    void setAnd(bool isAnd);    
    bool isAnd() const;
    ListT<CegoAttrCond> getAndCondList() const;
    
    CegoAttrCond& operator = ( const CegoAttrCond& ac);
    bool operator == ( const CegoAttrCond& ac) const;
    bool operator != ( const CegoAttrCond& ac) const;

    friend CegoAttrCond operator + ( const CegoAttrCond& ac1, const CegoAttrCond& ac2);

    bool hasIndexCandidate();
    
    void clean();
    
    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoAttrCond& ac);
    
private:

    CegoExpr* getExpressionForAlias(const ListT<CegoExpr*>& exprList, const Chain& alias) const;

    // ListT<CegoField> _idxSchema;
    TreeT<CegoAttrComp> _attrCompSet;
    // ListT<CegoAttrComp> _attrCompSet;

    bool _isAnd;
};
#endif
