#ifndef _CEGOADMACTION_H_INCLUDED_
#define _CEGOADMACTION_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAdmAction.h  
// ---------------
// Cego semantic adm actions interface definition
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAdmAction
// 
// Description: All administration actions are parsed using a dedicated admin parser. This class implements
//              all required semnatic action for the admin parser. 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/SigHandler.h>

#include "CegoAdm.h"
#include "CegoAdminHandler.h"
#include "CegoDefs.h"

class CegoAdmAction : public CegoAdm, public SigHandler {
    
public:

    enum ResultMode { VERBOSE, NORMAL, QUIET };

    CegoAdmAction(CegoAdminHandler *pAH, CegoModule *pModule, ResultMode resultMode, bool rawMode);
    ~CegoAdmAction();

    void sigCatch(int sig);
	
    void setCommandChain(char* pC);
    char nextChar();
    void readChain();
    void backChar();

    void setPitFormat(const Chain& pitFormat);
    void setDefault();

    void printTokenList();
    void statementAction();

    void rawModeOn();
    void rawModeOff();
    bool getRawMode();

    void lockInfoAction();
    void lockStatAction();
    void poolInfoAction();
    void parameterInfoAction();
    void poolEntryListAction();
    void listTableSetAction();
    void tableSetInfoAction();
    void dataFileInfoAction();
    void archLogInfoAction();
    void logInfoAction();
    void objInfoAction();
    void transactionInfoAction(); 
    void threadInfoAction();
    void dbThreadInfoAction();    
    void dbThreadQueryHistAction();
    void dbQueryHistLastAction();
    void dbQueryHistCostAction();
    
    void admThreadInfoAction();
    void logThreadInfoAction();
    void copyInfoAction();

    void buFileInfoAction();
    void buStatInfoAction();
    void buStatResetAction();
    void keepTicketAction();
    void syncCmdAction();
    void timeoutAction();
    void nologAction();
    void msgAction();
    void cleanupAction();
    void forceloadAction();
    void cpDumpAction();
    void noInitAction();
    
    void xmlModeAction();
    void binModeAction();
    void plainModeAction();

    void dbSessionInfoAction();
    void listNodeAction();

    void startTableSetAction();
    void stopTableSetAction();

    void retrieveTableSetAction();
    void defineTableSetAction();
    void dropTableSetAction();
    void removeTableSetAction();
    void resetTableSetAction();
    void createTableSetAction();
    void switchTableSetAction();
    void copyTableSetAction();

    void restoreTableSetAction();
    void recoverTableSetAction();
    void setLogMngAction();
    void setBackupMngAction();
    void showLogMngAction();
    void showBackupMngAction();
    void setTSInitFileAction();
    void setCheckpointAction();

    void setTSLogUserAction();
    void setTSSysSizeAction();
    void setTSTmpSizeAction();
    void setTSAppSizeAction();
    void setTSRootPathAction();

    void setTSTicketAction();
    void setTSLogNumAction();
    void setTSLogSizeAction();
    void setTSSortAreaSizeAction();

    void setNumQueryLastAction();
    void setNumQueryCostAction();
	
    void switchSecondaryAction();
    void switchMediatorAction();

    void relocateSecondaryAction();
    void relocateMediatorAction();

    void checkTableSetAction();
    void verifyTableSetAction();
    void correctTableSetAction();

    void beginBackupAction();
    void executeBackupAction();
    void endBackupAction();
    void listBackupAction();

    void syncTableSetAction();

    void getDbSpecAction();

    void getNodeListAction();
    void getDbInfoAction();

    void setTableSetNodeAction();

    void copyFileAction();

    void exportTableAction();
    void exportTableSetAction();
    void exportTableSetStructureAction();

    void importTableAction();
    void importTableSetAction();
    void importTableSetStructureAction();

    void addDataFileAction();

    void listUserAction();
    void addUserAction();
    void removeUserAction();
    void changePwdAction();    
    void assignRoleAction();
    void removeRoleAction();

    void listRoleAction();
    void showRoleAction();
    void createRoleAction();
    void dropRoleAction();
    void setPermAction();

    void setTableSetPerm();
    void setFilterPerm();
    void setRightPerm();

    void removePermAction();

    void traceOnAction();
    void traceOffAction();

    void abortDbThreadAction();

    void addArchLogAction();
    void removeArchLogAction();

    void enableArchLogAction();
    void disableArchLogAction();

    void enableAppendModeAction();
    void disableAppendModeAction();

    void enableAutoCorrectAction();
    void disableAutoCorrectAction();

    void enableTableCacheAction();
    void disableTableCacheAction();

    void enableQueryCacheAction();
    void disableQueryCacheAction();

    void listQueryCacheAction();
    void showQueryCacheAction();
    void cleanQueryCacheAction();
    void setQueryCacheParamAction();

    void setQueryCacheMaxEntry();
    void setQueryCacheMaxSize();
    void setQueryCacheHashRange();
    void setQueryCacheThreshold();

    void listTableCacheAction();
    void showTableCacheAction();
    void cleanTableCacheAction();
    void setTableCacheParamAction();

    void setTableCacheMaxEntry();
    void setTableCacheMaxSize();
    void setTableCacheHashRange();
    void setTableCacheFilter();
    
    void storePrimaryAttr();
    void storeSecondaryAttr();
    void storeSysSizeAttr();
    void storeTmpSizeAttr();
    void storeLogSizeAttr();
    void storeAppSizeAttr();
    void storeLogNumAttr();
    void storeSortAreaAttr();
    void storeTSRootAttr();
    void storeBranchAttr();

    void storePit();

    void dumpTable();
    void dumpUIndex();

    void cleanUp();
    void enableAbort(bool abortEnabled) { _abortEnabled = abortEnabled; }

private:

    void reallocateStringBuf();
    void handleMedResult(CegoAdminHandler::ResultType res);

    bool _abortEnabled;
    bool _isAborted;
    
    char *_pC;

    unsigned _stringBufLen;
    char *_stringBuf; // [MAXSTRINGLEN];

    CegoModule *_pModule;
    CegoAdminHandler* _pAH;

    Chain _tsRoot;
    Chain _primary;
    Chain _secondary;

    unsigned _sysSize;
    unsigned _tmpSize;
    unsigned _appSize;

    unsigned _logSize;
    unsigned _logNum;
    unsigned long long _sortAreaSize;
    unsigned _branchId;
    Chain _pit;

    bool _rawMode;
    ResultMode _resultMode;

    Chain _syncCmd;
    bool _keepTicket;
    unsigned _timeout;

    bool _doCleanup;
    bool _doForceload;
    bool _doCPDump;
    bool _doNoInit;
    
    Chain _xportMode;

    Chain _buMsg;

    Chain _tsPerm;
    Chain _filterPerm;
    Chain _rightPerm;

    // query and table cache params
    unsigned _maxEntry;
    unsigned _maxSize;
    unsigned _threshold;
    unsigned _hashRange;
    Chain _cacheFilter;
    
    unsigned long _modId;

    ListT<CegoField> _admSchema;
};
#endif
