--
-- ### Cast check for procedure parameters
--

drop if exists procedure calcInflFactor;
@
create procedure calcInflFactor(tstart in datetime, tend in datetime, infl in float) return float
begin
      var sm float;
      var em float;
      var sy int;
      var ey int;
      var ifac float;

      :ifac = 1.0;

      -- this should be casted from int to float
      :sm = 12 - str2int(ltrim(date2str(:tstart, '%m'), '0'));
      -- this should be casted from int to float
      :em = str2int(ltrim(date2str(:tend, '%m'), '0'));
     
      :sy = str2int(date2str(:tstart, '%Y'));
      :ey = str2int(date2str(:tend, '%Y'));
     
      :ifac = :ifac + :ifac * :infl * :sm / 12.0;
     
      while ( :sy < :ey )
      begin
             :ifac = :ifac + :ifac * :infl;
             :sy = :sy + 1;
      end;
     
     :ifac = :ifac + :ifac * :infl * :em;
     
      return :ifac;
end;
@

select calcInflFactor('01.04.2018 12:00:00', '01.07.2028 12:00:00', 0.0124);
select calcInflFactor('01.02.2015 12:00:00', '01.07.2030 12:00:00', 0.0217);
select calcInflFactor('01.09.2012 12:00:00', '01.02.2025 12:00:00', 0.043);

