///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoReplacer.cc
// ---------------
// Cego regex replacer container class
//      
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2025 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoReplacer
// 
// Description: Container class with unique replace id for cego regex replacers
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoReplacer.h"

CegoReplacer::CegoReplacer()
{
    _pattern = Chain();
    _replace = Chain();
    _pRep = 0;
}

CegoReplacer::CegoReplacer(const Chain& pattern, const Chain& replace)
{
    _pattern = pattern;
    _replace = replace;
    _pRep = 0;
}

CegoReplacer::~CegoReplacer()
{
}
     
Chain CegoReplacer::getId() const
{
    return _pattern + Chain("#") + _replace;
}

unsigned CegoReplacer::replace(const Chain& src, Chain& target)
{
    if ( _pRep == 0 )
    {
	_pRep = new Replacer(_pattern, _replace);
	_pRep->prepare();
    }
    return _pRep->replace(src, target);
}

void CegoReplacer::clean()
{
    if ( _pRep )
	delete _pRep;
    _pRep = 0;
}

unsigned CegoReplacer::getHashPos(unsigned hashSize) const
{
    Chain id = _pattern + Chain("#") + _replace;
    return id.getHashPos(hashSize);
}

CegoReplacer& CegoReplacer::operator = ( const CegoReplacer& rp)
{
    _pattern = rp._pattern;
    _replace = rp._replace;
    _pRep = rp._pRep;
    return (*this);
}

bool CegoReplacer::operator == ( const CegoReplacer& rp)
{
    if ( _pattern == rp._pattern && _replace == rp._replace )
	return true;
    return false;
}

ostream& operator << (ostream& s, const CegoReplacer& rp)
{    
    s <<  rp._pattern << "#" << rp._replace;
    return s;
}
