#ifndef _CEGOPROCCURSORCREATESTMT_H_INCLUDED_
#define _CEGOPROCCURSORCREATESTMT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcCursorCreateStmt.h  
// --------------------------
// Cego procedure cursor create statement interface
//
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcCursorCreateStmt
// 
// Description: Stored procedure statement for cursor creation
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoProcStmt.h"
#include "CegoExpr.h"
#include "CegoProcBlock.h"

class CegoProcCursorCreateStmt : public CegoProcStmt {
    
public:
    
    CegoProcCursorCreateStmt(const Chain& name, CegoSelect *pSelect, CegoProcBlock *pBlock);
    ~CegoProcCursorCreateStmt();

    CegoException execute();
    void cleanUp();
    Chain toChain(unsigned defTabSetId, const Chain& indent) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    bool isStatic() const;
    
private:
    
    Chain _name;
    CegoSelect *_pSelect;    
};
#endif
