#ifndef _CEGOBTREEVALUE_H_INCLUDED_
#define _CEGOBTREEVALUE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBTreeValue.h
// ----------------
// Multidimensional btree value class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoBTreeValue
// 
// Description: This class handles all operations on btree values. Since the values are sequentially stored
//              in a byte array, conversion methods are required to store, retrieve and for compare these values 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/ListT.h>

// CEGO INCLUDES
#include "CegoDefs.h"
#include "CegoField.h"

class CegoBTreeValue {

public:
    
    enum Comparison { LESS, EQUAL, MORE };
    
    CegoBTreeValue();
    CegoBTreeValue(char *p, unsigned len);
    ~CegoBTreeValue();

    static bool isNullTerminated(CegoDataType type);
    static unsigned getKeyLen(const ListT<CegoField>& schema);
    static unsigned getKeyPos(const Chain& attrName, const ListT<CegoField>& schema);

    bool isNull(const ListT<CegoField>& schema) const;
    bool hasNull(const ListT<CegoField>& schema) const;
    
    void valueFromSchema(ListT<CegoField>* pSchema);
    void valueFromSchema(const ListT<CegoField> tableSchema, const ListT<CegoField> indexSchema);

    ListT<CegoFieldValue> valueToFVL(const ListT<CegoField>& schema) const;

    void setPtr(char* p, unsigned len);
    char* getPtr() const;
    
    CegoBTreeValue& operator = (const CegoBTreeValue& iv);

    Comparison comp(const CegoBTreeValue& iv, ListT<CegoField>* pSchema) const;

    bool isHigher(const CegoBTreeValue& iv, ListT<CegoField>* pSchema) const;
    bool isEqualHigher(const CegoBTreeValue& iv, ListT<CegoField>* pSchema) const;
    bool isEqual(const CegoBTreeValue& iv, ListT<CegoField>* pSchema) const;
    // bool operator > ( const CegoBTreeValue& iv) const;

    Chain toChain(ListT<CegoField>* pSchema) const;    
	
private:

    static unsigned getReservedLength(CegoField* pF);
    
    char *_pI;
    unsigned _len;
    char* _idxArray; 
};
#endif
