--
-- ### Data type checks
-- 
--

drop if exists table t1;
create table t_int ( a int );
insert into t_int values ( 33 );
insert into t_int values ( 34 );
insert into t_int values ( 35 );
select * from t_int;
drop table t_int;

drop if exists table t_string;
create table t_string ( a string(30));
desc table t_string;
insert into t_string values ( 'alpha' );
insert into t_string values ( 'beta' );
insert into t_string values ( 'gamma' );
select * from t_string;
drop table t_string;

drop if exists table t_datetime;
create table t_datetime ( a datetime );
insert into t_datetime values ( scandate('%d.%m.%Y %H:%M:%S %Z','01.02.2007 02:23:00 CET'));
insert into t_datetime values ( newdate(2017,8,11,17,38,12));	
select date2str(a, '%d.%m.%y') from t_datetime;
select date2long(a) from t_datetime;

drop table t_datetime;

drop if exists table t_bool;
create table t_bool ( a bool );
insert into t_bool values ( true );
insert into t_bool values ( false );
select * from t_bool;
drop table t_bool;

drop if exists table t_bigint;
create table t_bigint ( a bigint(20));
desc table t_bigint;
insert into t_bigint values ( (bigint)445543245 );
insert into t_bigint values ( (bigint)1548333245 );
insert into t_bigint values ( (bigint)982638723433 );
select * from t_bigint;
drop table t_bigint;

drop if exists table t_float;
create table t_float ( a float);
desc table t_float;
insert into t_float values ( 44.54 );
insert into t_float values ( 0.32 );
insert into t_float values ( 1.985 );
select * from t_float;
drop table t_float;

drop if exists table t_double;
create table t_double ( a double);
desc table t_double;
insert into t_double values ( (double)44.54 );
insert into t_double values ( (double)0.32 );
insert into t_double values ( (double)1.985 );
select * from t_double;
drop table t_double;

drop if exists table t_decimal;
create table t_decimal ( a decimal(15,3));
desc table t_decimal;
insert into t_decimal values ( (decimal)44.541 );
insert into t_decimal values ( (decimal)0.322 );
insert into t_decimal values ( (decimal)1.985 );
select * from t_decimal;
drop table t_decimal;

drop if exists table t_smallint;
create table t_smallint ( a smallint );
insert into t_smallint values ( (smallint)33 );
insert into t_smallint values ( (smallint)34 );
insert into t_smallint values ( (smallint)35 );
select * from t_smallint;
drop table t_smallint;

drop if exists table t_tinyint;
create table t_tinyint ( a tinyint );
insert into t_tinyint values ( (tinyint)33 );
insert into t_tinyint values ( (tinyint)34 );
insert into t_tinyint values ( (tinyint)35 );
select * from t_tinyint;
drop table t_tinyint;
