#ifndef _CEGOTRIGGER_H_INCLUDED_
#define _CEGOTRIGGER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTrigger.h  
// -------------
// Cego trigger class definition
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoTrigger
// 
// Description: Trigger container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/ListT.h>
#include <lfcbase/Chain.h>

// cego includes
#include "CegoProcBlock.h"
#include "CegoProcVar.h"
#include "CegoExpr.h"

class CegoDatabaseFormater;

class CegoTrigger {
    
public:

    CegoTrigger();
    CegoTrigger(const Chain& triggerName,
		bool isBefore,
		bool isOnInsert,
		bool isOnUpdate,
		bool isOnDelete,	       
		const Chain& tableName,CegoProcBlock *pBlock);
    ~CegoTrigger();
        
    const Chain& getName() const;
    bool isBefore() const;
    bool isOnInsert() const;
    bool isOnUpdate() const;
    bool isOnDelete() const;
    const Chain& getTableName() const;
    CegoProcBlock* getBlock();
    void execute(ListT<CegoField>* pTriggerValueList = 0);
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    Chain getTriggerText(unsigned defTabSetId) const;
    Chain toChain(unsigned defTabSetId) const;

    CegoTrigger& operator = (const CegoTrigger& p);
    bool operator == (const CegoTrigger& p) const;
    
 private:
    
    Chain _triggerName;
    Chain _tableName;
    CegoProcBlock* _pBlock;
    bool _isBefore;
    bool _isOnInsert;
    bool _isOnUpdate;
    bool _isOnDelete;    
};
#endif
