#ifndef _CEGOPROCSTMT_H_INCLUDED_
#define _CEGOPROCSTMT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcStmt.h  
// --------------
// Cego procedure statement super class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcStmt
//
// Description: Super class for all stored procedure statements
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoException.h"
#include "CegoFieldValue.h"
#include "CegoProcVar.h"
#include "CegoProcBlock.h"

class CegoProcBlock;

class CegoProcStmt  {
    
public:
  
    CegoProcStmt(CegoProcBlock* pBlock);
    virtual ~CegoProcStmt();

    virtual CegoException execute() = 0;
    virtual void cleanUp() = 0;
    virtual Chain toChain(unsigned defTabSetId, const Chain& indent = Chain("")) const = 0;
    virtual Chain dbFormat(CegoDatabaseFormater *pForm) const = 0;
    virtual bool isStatic() const = 0;

    CegoFieldValue getValue(const Chain& param) const;
    void setValue(const Chain& param, const CegoFieldValue& fv);
    CegoProcBlock* getParentBlock();

private:

    CegoProcBlock* _pBlock;
    bool _isDebug;
};
#endif
