///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcException.cc
// --------------------
// Cego procedure exception container class
//      
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2025 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcException
//
// Description: Stored procedure exception statement
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoDefs.h"
#include "CegoProcException.h"
#include "CegoDatabaseFormater.h"

CegoProcException::CegoProcException(CegoException excep, CegoProcBlock *pBlock, CegoProcBlock *pParentBlock) : CegoProcStmt(pParentBlock)
{
    _excep = excep;
    _pBlock = pBlock;
}

CegoProcException::~CegoProcException()
{
}
    
CegoException CegoProcException::getException() const
{
    return _excep;
}

CegoProcBlock* CegoProcException::getBlock()
{
    return _pBlock;
}

CegoException CegoProcException::execute()
{
    return NONE_EXCEP;
}

void CegoProcException::cleanUp()
{
    _pBlock->cleanUp();
}

CegoProcException& CegoProcException::operator = ( const CegoProcException& pe)
{
    _excep = pe._excep;
    _pBlock = pe._pBlock;
    return (*this);
}

bool CegoProcException::operator == ( const CegoProcException& pe)
{
    if ( _excep == pe._excep )
	return true;
    return false;
}

Chain CegoProcException::toChain(unsigned defTabSetId, const Chain& indent) const
{
    Chain s = indent;

    if ( _excep == COREOP_EXCEP ) 
    {
	s += Chain(COREOP_EXCEP_ID);
    }
    else if ( _excep == ANY_EXCEP ) 
    {
	s += Chain(ANY_EXCEP_ID);
    }
    else
    {
	s += Chain(OTHER_EXCEP_ID);
    }

    return s;
}

Chain CegoProcException::dbFormat(CegoDatabaseFormater *pForm) const
{
    return pForm->formatProcException(_excep);
}

bool CegoProcException::isStatic() const
{
    ListT<CegoProcStmt*> stmtList = _pBlock->getStmtList();
	
    CegoProcStmt **pStmt = stmtList.First();
    while ( pStmt )
    {
	if ( (*pStmt)->isStatic() == false )
	    return false;
    }
    return true;
}

ostream& operator << (ostream& s, const CegoProcException& pe)
{    
    s << pe.toChain(0);
    return s;
}
