--
-- ### Checking new introduced regmatch function
-- 


drop if exists table t1;
create table t1 ( a decimal(20,2), b string(50) );

insert into t1 values ( (decimal)74382473289.98, 'Hello.world');
insert into t1 values ( (decimal)843945222.32, 'You.Love');
insert into t1 values ( (decimal)13848423.28, 'Ping.Pong');
insert into t1 values ( (decimal)27743120.73, 'one.two');


drop if exists procedure dec2mny;
@
create procedure dec2mny(d in decimal(10,2)) return string(20)
begin
	var pat string(20);
	var rep string(20);
	var m string(20);
	var n int;

	:pat = '([0-9])([0-9][0-9][0-9][.])';
	:rep = '$1.$2';
	
	:m = regmatch(:pat, :rep, :d, :n);
	while :n > 0
	begin
		:m = regmatch(:pat, :rep, :m, :n);
	end;
	
	return :m;
	
end;
@

drop if exists procedure flipPos;
@
create procedure flipPos(s in string(50)) return string(50)
begin
	var pat string(20);
	var rep string(20);
	var m string(20);

	:pat = '([a-zA-Z]*)[.]([a-zA-Z]*)';
	:rep = '$2.$1';
	
	:m = regmatch(:pat, :rep, :s);
	
	return :m;
	
end;
@

select dec2mny(a) from t1;
select flipPos(b) from t1;

