#ifndef _CEGOSERIAL_H_INCLUDED_
#define _CEGOSERIAL_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoSerial.h
// ------------
// Cego serializer class definition
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoSerial
// 
// Description: This class implements the serialization of any query request and response data
//              Since the xml protocol seems to throttle down query performance, this class
//              was introduced
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// lfc includes
#include <lfcbase/Chain.h>
#include <lfcbase/Tokenizer.h>
#include <lfcbase/NetHandler.h>

// cego includes
#include "CegoField.h"
#include "CegoFieldValue.h"
#include "CegoDecodableObject.h"

class CegoSerial {
    
public:
    
    CegoSerial(NetHandler *pN, bool isFast);
    ~CegoSerial();
    
    void reset();
    bool isReset() const;
    void writeChain(const Chain& s);
    void writeRow(const ListT<CegoField>& fl);
    void writeRow(const ListT<CegoFieldValue>& fvl);
    void writeSchema(const ListT<CegoField>& schema);
    void writeObject(const CegoDecodableObject& oe);
    Chain readChain();
    void readRow(const ListT<CegoField>& schema, ListT<CegoFieldValue>& fvl);    
    ListT<CegoField> readSchema();
    int numWritten() const;
    int numAhead() const;
    Chain toChain() const;

    friend ostream& operator << (ostream& s, const CegoSerial& ser);

private:
    
    bool _isFast;
    char*  _pFastCursor;
    NetHandler* _pN;
    Tokenizer* _pTok;
};
#endif
