///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcReturnStmt.cc  
// ---------------------
// Cego procedure return statement implementation
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2025 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcReturnStmt
//
// Description: Stored procedure return statement
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Exception.h>
#include <lfcbase/Tokenizer.h>
#include <lfcbase/Datetime.h>

// cego includes
#include "CegoProcReturnStmt.h"
#include "CegoDatabaseFormater.h"

CegoProcReturnStmt::CegoProcReturnStmt(CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _pExpr = 0;
    _pBlock = pBlock;
}

CegoProcReturnStmt::CegoProcReturnStmt(CegoExpr *pExpr,
				       CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _pExpr = pExpr;
    _pBlock = pBlock;
}

CegoProcReturnStmt::~CegoProcReturnStmt()  
{
    if ( _pExpr )
	delete _pExpr;
}

CegoException CegoProcReturnStmt::execute()
{
    if ( _pExpr )
    {
	getParentBlock()->setRetVal(_pExpr->evalFieldValue(0, getParentBlock()));
    }
    return RETURN_EXCEP;
}

void CegoProcReturnStmt::cleanUp()
{
    _pExpr->cleanUp();
}

Chain CegoProcReturnStmt::toChain(int defTabSetId, const Chain& indent) const
{
    Chain s;
    s = indent + Chain("return");
    if ( _pExpr )
	s += Chain(" ") + _pExpr->toChain(defTabSetId);
    return s;
}

Chain CegoProcReturnStmt::dbFormat(CegoDatabaseFormater *pForm) const
{
    return pForm->formatProcReturnStmt(_pExpr);
}

bool CegoProcReturnStmt::isStatic() const
{
    try
    {
	_pExpr->getId(_pBlock);
	return true;
    }
    catch ( Exception e )
    {
	return false;
    }
}
