#ifndef _CEGOKEYOBJECT_H_INCLUDED_
#define _CEGOKEYOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoKeyObject.h
// ---------------
// key object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoKeyObject
// 
// Description: Derived class from CegoObject to use as a container class for foreign key objects
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/ListT.h>
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoField.h"
#include "CegoObject.h"
#include "CegoDecodableObject.h"

class CegoKeyObject : public CegoDecodableObject {

public:

    CegoKeyObject();    
    CegoKeyObject(const CegoKeyObject& ko);    
    CegoKeyObject(ObjectType type,
		  const Chain& objName,
		  int tabSetId = 0);
    CegoKeyObject(int tabSetId,
		  const Chain& fkey, 
		  const Chain& tabName, 
		  const ListT<CegoField>& schemaList,
		  const Chain& refTable,
		  const ListT<CegoField>& refList);	
    ~CegoKeyObject();

    void setTabName(const Chain& name);
    const Chain& getTabName() const;
    void setKeySchema(const ListT<CegoField>& keySchema);   
    const ListT<CegoField>& getKeySchema() const;
    void setRefTable(const Chain& refTable);
    const Chain& getRefTable() const;
    void setRefSchema(const ListT<CegoField>& refSchema);   
    const ListT<CegoField>& getRefSchema() const;
    int getEntrySize() const;
    void encode(char *buf) const;
    void decode(char *buf);
    void setEmpty();

    Chain getInfo() const;
    
    CegoKeyObject& operator = ( const CegoKeyObject& oe);
    bool operator == ( const CegoKeyObject& oe);

private:

    Chain _tabName;
    Chain _refTable;
    ListT<CegoField> _keySchema;
    ListT<CegoField> _refSchema;
};
#endif
