//
// File: CegoAdm.cc
// This code was produced by the dragon parser generator
//
#include "CegoAdm.h"
#include <lfcbase/Exception.h>
#include <lfcbase/StackT.h>

CegoAdm::ScannerStateEntry::ScannerStateEntry()
{
}

CegoAdm::ScannerStateEntry::ScannerStateEntry(int state, ScannerStateType type)
{
   _state = state;
   _type = type;
}

CegoAdm::ScannerStateEntry& CegoAdm::ScannerStateEntry::operator = (const CegoAdm::ScannerStateEntry& s)
{
   _state = s._state;
   _type = s._type;
   return(*this);
}

bool CegoAdm::ScannerStateEntry::operator == (const CegoAdm::ScannerStateEntry& s)
{
   if ( _state == s._state )
      return true;
   return false;
}

CegoAdm::ScannerStateType CegoAdm::ScannerStateEntry::getType()
{
   return _type;
}
int CegoAdm::ScannerStateEntry::getState()
{
   return _state;
}


CegoAdm::ScannerTransEntry::ScannerTransEntry()
{
}

CegoAdm::ScannerTransEntry::ScannerTransEntry(int state, char c)
{
   _state = state;
   _c = c;
}

CegoAdm::ScannerTransEntry::ScannerTransEntry(int state, char c, int fstate)
{
   _state = state;
   _c = c;
   _fstate = fstate;
}

CegoAdm::ScannerTransEntry& CegoAdm::ScannerTransEntry::operator = (const CegoAdm::ScannerTransEntry& s)
{
   _state = s._state;
   _c = s._c;
   _fstate = s._fstate;
   return(*this);
}

bool CegoAdm::ScannerTransEntry::operator == (const CegoAdm::ScannerTransEntry& s)
{
   if ( _state == s._state && _c == s._c)
      return true;
   return false;
}

int CegoAdm::ScannerTransEntry::getFState()
{
   return _fstate;
}


CegoAdm::Scanner::Scanner()
{
}


CegoAdm::Scanner::Scanner(Token t)
{
   _token = t;
}

CegoAdm::Token CegoAdm::Scanner::getToken()
{
   return _token;
}

void CegoAdm::Scanner::addState(ScannerStateEntry s)
{
   _stateList.Insert(s);
}

void CegoAdm::Scanner::addTransition(ScannerTransEntry t)
{
   _transList.Insert(t);
}

bool CegoAdm::Scanner::checkPattern(const Chain& p)
{
   unsigned long state = 0;
   ScannerStateEntry* pS = _stateList.First();
   while (pS)
   {
      if (pS->getType() == START || pS->getType() == ANY)
      {
         state = pS->getState();
         pS = 0;
      }
      else
      {
         pS = _stateList.Next();
      }
   }
   unsigned long i = 0;
   ScannerTransEntry* pT = 
   _transList.Find(ScannerTransEntry(state, p[i]));
   while (pT)
   {
      ScannerStateEntry* pS = _stateList.Find(ScannerStateEntry(pT->getFState())); 
      if (pS)
      {
         if ( ( i == p.length()-2 ) && ( pS->getType() == FINAL || pS->getType() == ANY))
         {
            return true;
         }
         else
         {
            state = pT->getFState();
         }
      }
      else
      {
         return false;
      }
      i++;
      pT = _transList.Find(ScannerTransEntry(state, p[i]));
   }
   return false;
}
CegoAdm::StackEntry::StackEntry()
{
   _symbol = NONE;
}

CegoAdm::StackEntry::StackEntry(Symbol symbol, int num, int state, Chain tval)
{
   _symbol=symbol;
   _num=num;
   _state=state;
   _tval=tval;
}

CegoAdm::StackEntry& CegoAdm::StackEntry::operator = (const CegoAdm::StackEntry& se)
{
   _symbol=se._symbol;
   _num=se._num;
   _state=se._state;
   _tval=se._tval;
   return(*this);
}

int CegoAdm::StackEntry::getState()
{
   return _state;
}
CegoAdm::Symbol CegoAdm::StackEntry::getSymbol()
{
   return _symbol;
}
Chain& CegoAdm::StackEntry::getTval()
{
   return _tval;
}

CegoAdm::ActionEntry::ActionEntry()
{
   _action=NULLACTION;
}

CegoAdm::ActionEntry::ActionEntry(Action action , int num)
{
   _action=action;
   _num=num;
}

bool CegoAdm::ActionEntry::operator == (const CegoAdm::ActionEntry& ae)
{
   if (_action == ae._action && _num == ae._num)
      return true;
   return false;
}

CegoAdm::ActionEntry& CegoAdm::ActionEntry::operator = (const CegoAdm::ActionEntry& ae)
{
   _action=ae._action;
   _num=ae._num;
   return(*this);
}

CegoAdm::Action CegoAdm::ActionEntry::getAction()
{
   return _action;
}

int CegoAdm::ActionEntry::getNum()
{
   return _num;
}

CegoAdm::ProdEntry::ProdEntry()
{
}

CegoAdm::ProdEntry::ProdEntry(int id)
{
   _id = id;
}

CegoAdm::ProdEntry::ProdEntry(int id, Production prod, int numSymbol)
{
   _id = id;
   _prod = prod;
   _numSymbol = numSymbol;
}

bool CegoAdm::ProdEntry::operator == (const CegoAdm::ProdEntry& pe)
{
   if (_id == pe._id)
      return true;
   return false;
}

CegoAdm::ProdEntry& CegoAdm::ProdEntry::operator = (const CegoAdm::ProdEntry& pe)
{
   _id = pe._id;
   _prod = pe._prod;
   _numSymbol = pe._numSymbol;
   return(*this);
}


int CegoAdm::ProdEntry::getId()
{
   return _id;
}

CegoAdm::Production CegoAdm::ProdEntry::getProd()
{
   return _prod;
}

int CegoAdm::ProdEntry::getNumSymbol()
{
   return _numSymbol;
}
void CegoAdm::loadScanner()
{
   Scanner s0(ABORT);
   s0.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(2 ,START));
   s0.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(5 ,FINAL));
   s0.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s0.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s0.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s0.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s0.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s0);

   Scanner s1(ADD);
   s1.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(2 ,START));
   s1.addState(ScannerStateEntry(3 ,FINAL));
   s1.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s1.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s1.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s1);

   Scanner s2(ADM);
   s2.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(2 ,START));
   s2.addState(ScannerStateEntry(3 ,FINAL));
   s2.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s2.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s2.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s2);

   Scanner s3(APPENDMODE);
   s3.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(2 ,START));
   s3.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(10 ,FINAL));
   s3.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s3.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s3.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s3.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s3.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s3.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s3.addTransition(ScannerTransEntry(6 ,'m' ,7));
   s3.addTransition(ScannerTransEntry(7 ,'o' ,8));
   s3.addTransition(ScannerTransEntry(8 ,'d' ,9));
   s3.addTransition(ScannerTransEntry(9 ,'e' ,10));
   _scannerList.Insert(s3);

   Scanner s4(APPSIZE);
   s4.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(2 ,START));
   s4.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(7 ,FINAL));
   s4.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s4.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s4.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s4.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s4.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s4.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s4.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s4);

   Scanner s5(ARCHLOG);
   s5.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(2 ,START));
   s5.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(7 ,FINAL));
   s5.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s5.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s5.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s5.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s5.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s5.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s5.addTransition(ScannerTransEntry(6 ,'g' ,7));
   _scannerList.Insert(s5);

   Scanner s6(ASSIGN);
   s6.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(2 ,START));
   s6.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(6 ,FINAL));
   s6.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s6.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s6.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s6.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s6.addTransition(ScannerTransEntry(4 ,'g' ,5));
   s6.addTransition(ScannerTransEntry(5 ,'n' ,6));
   _scannerList.Insert(s6);

   Scanner s7(AUTOCORRECT);
   s7.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(2 ,START));
   s7.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(11 ,FINAL));
   s7.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s7.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s7.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s7.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s7.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s7.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s7.addTransition(ScannerTransEntry(6 ,'r' ,7));
   s7.addTransition(ScannerTransEntry(7 ,'r' ,8));
   s7.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s7.addTransition(ScannerTransEntry(9 ,'c' ,10));
   s7.addTransition(ScannerTransEntry(10 ,'t' ,11));
   _scannerList.Insert(s7);

   Scanner s8(BACKUP);
   s8.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(2 ,START));
   s8.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(6 ,FINAL));
   s8.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s8.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s8.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s8.addTransition(ScannerTransEntry(3 ,'k' ,4));
   s8.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s8.addTransition(ScannerTransEntry(5 ,'p' ,6));
   _scannerList.Insert(s8);

   Scanner s9(BACKUPMNG);
   s9.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(2 ,START));
   s9.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(9 ,FINAL));
   s9.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s9.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s9.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s9.addTransition(ScannerTransEntry(3 ,'k' ,4));
   s9.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s9.addTransition(ScannerTransEntry(5 ,'p' ,6));
   s9.addTransition(ScannerTransEntry(6 ,'m' ,7));
   s9.addTransition(ScannerTransEntry(7 ,'n' ,8));
   s9.addTransition(ScannerTransEntry(8 ,'g' ,9));
   _scannerList.Insert(s9);

   Scanner s10(BEGIN_TOKEN);
   s10.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(2 ,START));
   s10.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(5 ,FINAL));
   s10.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s10.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s10.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s10.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s10.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s10);

   Scanner s11(BINARY);
   s11.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(2 ,START));
   s11.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(6 ,FINAL));
   s11.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s11.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s11.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s11.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s11.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s11.addTransition(ScannerTransEntry(5 ,'y' ,6));
   _scannerList.Insert(s11);

   Scanner s12(BRANCHID);
   s12.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(2 ,START));
   s12.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(8 ,FINAL));
   s12.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s12.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s12.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s12.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s12.addTransition(ScannerTransEntry(5 ,'h' ,6));
   s12.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s12.addTransition(ScannerTransEntry(7 ,'d' ,8));
   _scannerList.Insert(s12);

   Scanner s13(BUFILE);
   s13.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(2 ,START));
   s13.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(6 ,FINAL));
   s13.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s13.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s13.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s13.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s13.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s13);

   Scanner s14(BUSTAT);
   s14.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(2 ,START));
   s14.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(6 ,FINAL));
   s14.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s14.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s14.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s14.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s14.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s14.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s14);

   Scanner s15(TSTICKET);
   s15.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(2 ,START));
   s15.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(8 ,FINAL));
   s15.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s15.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s15.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s15.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s15.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s15.addTransition(ScannerTransEntry(5 ,'k' ,6));
   s15.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s15.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s15);

   Scanner s16(BY);
   s16.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(1 ,FINAL));
   s16.addState(ScannerStateEntry(2 ,START));
   s16.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s16.addTransition(ScannerTransEntry(2 ,'b' ,0));
   _scannerList.Insert(s16);

   Scanner s17(CHECK);
   s17.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(2 ,START));
   s17.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(5 ,FINAL));
   s17.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s17.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s17.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s17.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s17.addTransition(ScannerTransEntry(4 ,'k' ,5));
   _scannerList.Insert(s17);

   Scanner s18(CHECKPOINT);
   s18.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(2 ,START));
   s18.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(10 ,FINAL));
   s18.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s18.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s18.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s18.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s18.addTransition(ScannerTransEntry(4 ,'k' ,5));
   s18.addTransition(ScannerTransEntry(5 ,'p' ,6));
   s18.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s18.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s18.addTransition(ScannerTransEntry(8 ,'n' ,9));
   s18.addTransition(ScannerTransEntry(9 ,'t' ,10));
   _scannerList.Insert(s18);

   Scanner s19(CLEAN);
   s19.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(2 ,START));
   s19.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(5 ,FINAL));
   s19.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s19.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s19.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s19.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s19.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s19);

   Scanner s20(CLEANUP);
   s20.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(2 ,START));
   s20.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(7 ,FINAL));
   s20.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s20.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s20.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s20.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s20.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s20.addTransition(ScannerTransEntry(5 ,'u' ,6));
   s20.addTransition(ScannerTransEntry(6 ,'p' ,7));
   _scannerList.Insert(s20);

   Scanner s21(CLOSE);
   s21.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(2 ,START));
   s21.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(5 ,FINAL));
   s21.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s21.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s21.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s21.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s21.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s21);

   Scanner s22(CONNECT);
   s22.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(2 ,START));
   s22.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(7 ,FINAL));
   s22.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s22.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s22.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s22.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s22.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s22.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s22.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s22);

   Scanner s23(COPY);
   s23.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(2 ,START));
   s23.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(4 ,FINAL));
   s23.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s23.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s23.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s23.addTransition(ScannerTransEntry(3 ,'y' ,4));
   _scannerList.Insert(s23);

   Scanner s24(CORRECT);
   s24.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(2 ,START));
   s24.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(7 ,FINAL));
   s24.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s24.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s24.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s24.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s24.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s24.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s24.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s24);

   Scanner s25(COST);
   s25.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(2 ,START));
   s25.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(4 ,FINAL));
   s25.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s25.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s25.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s25.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s25);

   Scanner s26(CPDUMP);
   s26.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(2 ,START));
   s26.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(6 ,FINAL));
   s26.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s26.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s26.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s26.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s26.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s26.addTransition(ScannerTransEntry(5 ,'p' ,6));
   _scannerList.Insert(s26);

   Scanner s27(CREATE);
   s27.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(2 ,START));
   s27.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(6 ,FINAL));
   s27.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s27.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s27.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s27.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s27.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s27.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s27);

   Scanner s28(DATAFILE);
   s28.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(2 ,START));
   s28.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(8 ,FINAL));
   s28.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s28.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s28.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s28.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s28.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s28.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s28.addTransition(ScannerTransEntry(6 ,'l' ,7));
   s28.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s28);

   Scanner s29(DB);
   s29.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(1 ,FINAL));
   s29.addState(ScannerStateEntry(2 ,START));
   s29.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s29.addTransition(ScannerTransEntry(2 ,'d' ,0));
   _scannerList.Insert(s29);

   Scanner s30(DEFINE);
   s30.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(2 ,START));
   s30.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(6 ,FINAL));
   s30.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s30.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s30.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s30.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s30.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s30.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s30);

   Scanner s31(DISABLE);
   s31.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(2 ,START));
   s31.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(7 ,FINAL));
   s31.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s31.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s31.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s31.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s31.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s31.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s31.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s31);

   Scanner s32(DROP);
   s32.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(2 ,START));
   s32.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(4 ,FINAL));
   s32.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s32.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s32.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s32.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s32);

   Scanner s33(DUMP);
   s33.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(2 ,START));
   s33.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(4 ,FINAL));
   s33.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s33.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s33.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s33.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s33);

   Scanner s34(ENABLE);
   s34.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(2 ,START));
   s34.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(6 ,FINAL));
   s34.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s34.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s34.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s34.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s34.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s34.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s34);

   Scanner s35(END_TOKEN);
   s35.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(2 ,START));
   s35.addState(ScannerStateEntry(3 ,FINAL));
   s35.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s35.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s35.addTransition(ScannerTransEntry(2 ,'e' ,0));
   _scannerList.Insert(s35);

   Scanner s36(MAXENTRY);
   s36.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(2 ,START));
   s36.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(8 ,FINAL));
   s36.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s36.addTransition(ScannerTransEntry(1 ,'x' ,3));
   s36.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s36.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s36.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s36.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s36.addTransition(ScannerTransEntry(6 ,'r' ,7));
   s36.addTransition(ScannerTransEntry(7 ,'y' ,8));
   _scannerList.Insert(s36);

   Scanner s37(EXPORT);
   s37.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(2 ,START));
   s37.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(6 ,FINAL));
   s37.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s37.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s37.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s37.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s37.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s37.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s37);

   Scanner s38(FILE);
   s38.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(2 ,START));
   s38.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(4 ,FINAL));
   s38.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s38.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s38.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s38.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s38);

   Scanner s39(FILTER);
   s39.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(2 ,START));
   s39.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(6 ,FINAL));
   s39.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s39.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s39.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s39.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s39.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s39.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s39);

   Scanner s40(FOR);
   s40.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(2 ,START));
   s40.addState(ScannerStateEntry(3 ,FINAL));
   s40.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s40.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s40.addTransition(ScannerTransEntry(2 ,'f' ,0));
   _scannerList.Insert(s40);

   Scanner s41(FORCELOAD);
   s41.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(2 ,START));
   s41.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(9 ,FINAL));
   s41.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s41.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s41.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s41.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s41.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s41.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s41.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s41.addTransition(ScannerTransEntry(7 ,'a' ,8));
   s41.addTransition(ScannerTransEntry(8 ,'d' ,9));
   _scannerList.Insert(s41);

   Scanner s42(FROM);
   s42.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(2 ,START));
   s42.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(4 ,FINAL));
   s42.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s42.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s42.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s42.addTransition(ScannerTransEntry(3 ,'m' ,4));
   _scannerList.Insert(s42);

   Scanner s43(GETDBSPEC);
   s43.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(2 ,START));
   s43.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(9 ,FINAL));
   s43.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s43.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s43.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s43.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s43.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s43.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s43.addTransition(ScannerTransEntry(6 ,'p' ,7));
   s43.addTransition(ScannerTransEntry(7 ,'e' ,8));
   s43.addTransition(ScannerTransEntry(8 ,'c' ,9));
   _scannerList.Insert(s43);

   Scanner s44(GETTSLIST);
   s44.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(2 ,START));
   s44.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(9 ,FINAL));
   s44.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s44.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s44.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s44.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s44.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s44.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s44.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s44.addTransition(ScannerTransEntry(7 ,'s' ,8));
   s44.addTransition(ScannerTransEntry(8 ,'t' ,9));
   _scannerList.Insert(s44);

   Scanner s45(GETNODELIST);
   s45.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(2 ,START));
   s45.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(11 ,FINAL));
   s45.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s45.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s45.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s45.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s45.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s45.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s45.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s45.addTransition(ScannerTransEntry(7 ,'l' ,8));
   s45.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s45.addTransition(ScannerTransEntry(9 ,'s' ,10));
   s45.addTransition(ScannerTransEntry(10 ,'t' ,11));
   _scannerList.Insert(s45);

   Scanner s46(GETDBINFO);
   s46.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(2 ,START));
   s46.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(9 ,FINAL));
   s46.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s46.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s46.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s46.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s46.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s46.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s46.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s46.addTransition(ScannerTransEntry(7 ,'f' ,8));
   s46.addTransition(ScannerTransEntry(8 ,'o' ,9));
   _scannerList.Insert(s46);

   Scanner s47(HASHRANGE);
   s47.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(2 ,START));
   s47.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(9 ,FINAL));
   s47.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s47.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s47.addTransition(ScannerTransEntry(2 ,'h' ,0));
   s47.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s47.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s47.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s47.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s47.addTransition(ScannerTransEntry(7 ,'g' ,8));
   s47.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s47);

   Scanner s48(IMPORT);
   s48.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(2 ,START));
   s48.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(6 ,FINAL));
   s48.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s48.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s48.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s48.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s48.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s48.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s48);

   Scanner s49(INITFILE);
   s49.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(2 ,START));
   s49.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(8 ,FINAL));
   s49.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s49.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s49.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s49.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s49.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s49.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s49.addTransition(ScannerTransEntry(6 ,'l' ,7));
   s49.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s49);

   Scanner s50(KEEP);
   s50.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(2 ,START));
   s50.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(4 ,FINAL));
   s50.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s50.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s50.addTransition(ScannerTransEntry(2 ,'k' ,0));
   s50.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s50);

   Scanner s51(LAST);
   s51.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(2 ,START));
   s51.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(4 ,FINAL));
   s51.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s51.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s51.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s51.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s51);

   Scanner s52(LIST);
   s52.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(2 ,START));
   s52.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(4 ,FINAL));
   s52.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s52.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s52.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s52.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s52);

   Scanner s53(LOCK);
   s53.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(2 ,START));
   s53.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(4 ,FINAL));
   s53.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s53.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s53.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s53.addTransition(ScannerTransEntry(3 ,'k' ,4));
   _scannerList.Insert(s53);

   Scanner s54(LOCKSTAT);
   s54.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(2 ,START));
   s54.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(8 ,FINAL));
   s54.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s54.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s54.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s54.addTransition(ScannerTransEntry(3 ,'k' ,4));
   s54.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s54.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s54.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s54.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s54);

   Scanner s55(LOG);
   s55.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(2 ,START));
   s55.addState(ScannerStateEntry(3 ,FINAL));
   s55.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s55.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s55.addTransition(ScannerTransEntry(2 ,'l' ,0));
   _scannerList.Insert(s55);

   Scanner s56(LOGFILE);
   s56.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(2 ,START));
   s56.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(7 ,FINAL));
   s56.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s56.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s56.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s56.addTransition(ScannerTransEntry(3 ,'f' ,4));
   s56.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s56.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s56.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s56);

   Scanner s57(LOGMNG);
   s57.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(2 ,START));
   s57.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(6 ,FINAL));
   s57.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s57.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s57.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s57.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s57.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s57.addTransition(ScannerTransEntry(5 ,'g' ,6));
   _scannerList.Insert(s57);

   Scanner s58(LOGNUM);
   s58.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(2 ,START));
   s58.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(6 ,FINAL));
   s58.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s58.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s58.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s58.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s58.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s58.addTransition(ScannerTransEntry(5 ,'m' ,6));
   _scannerList.Insert(s58);

   Scanner s59(LOGSIZE);
   s59.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(2 ,START));
   s59.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(7 ,FINAL));
   s59.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s59.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s59.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s59.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s59.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s59.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s59.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s59);

   Scanner s60(LOGUSER);
   s60.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(2 ,START));
   s60.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(7 ,FINAL));
   s60.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s60.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s60.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s60.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s60.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s60.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s60.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s60);

   Scanner s61(IDENTIFIED);
   s61.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(2 ,START));
   s61.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(10 ,FINAL));
   s61.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s61.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s61.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s61.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s61.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s61.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s61.addTransition(ScannerTransEntry(6 ,'f' ,7));
   s61.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s61.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s61.addTransition(ScannerTransEntry(9 ,'d' ,10));
   _scannerList.Insert(s61);

   Scanner s62(UINDEX);
   s62.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(2 ,START));
   s62.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(6 ,FINAL));
   s62.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s62.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s62.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s62.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s62.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s62.addTransition(ScannerTransEntry(5 ,'x' ,6));
   _scannerList.Insert(s62);

   Scanner s63(MAXSIZE);
   s63.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(2 ,START));
   s63.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(7 ,FINAL));
   s63.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s63.addTransition(ScannerTransEntry(1 ,'x' ,3));
   s63.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s63.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s63.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s63.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s63.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s63);

   Scanner s64(MEDIATOR);
   s64.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(2 ,START));
   s64.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(8 ,FINAL));
   s64.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s64.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s64.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s64.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s64.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s64.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s64.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s64.addTransition(ScannerTransEntry(7 ,'r' ,8));
   _scannerList.Insert(s64);

   Scanner s65(MESSAGE);
   s65.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(2 ,START));
   s65.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(7 ,FINAL));
   s65.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s65.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s65.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s65.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s65.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s65.addTransition(ScannerTransEntry(5 ,'g' ,6));
   s65.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s65);

   Scanner s66(NODE);
   s66.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(2 ,START));
   s66.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(4 ,FINAL));
   s66.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s66.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s66.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s66.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s66);

   Scanner s67(NOINIT);
   s67.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(2 ,START));
   s67.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(6 ,FINAL));
   s67.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s67.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s67.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s67.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s67.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s67.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s67);

   Scanner s68(OBJECT);
   s68.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(2 ,START));
   s68.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(6 ,FINAL));
   s68.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s68.addTransition(ScannerTransEntry(1 ,'j' ,3));
   s68.addTransition(ScannerTransEntry(2 ,'o' ,0));
   s68.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s68.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s68.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s68);

   Scanner s69(OFF);
   s69.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(2 ,START));
   s69.addState(ScannerStateEntry(3 ,FINAL));
   s69.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s69.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s69.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s69);

   Scanner s70(ON);
   s70.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(1 ,FINAL));
   s70.addState(ScannerStateEntry(2 ,START));
   s70.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s70.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s70);

   Scanner s71(PARAMETER);
   s71.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(2 ,START));
   s71.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(9 ,FINAL));
   s71.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s71.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s71.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s71.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s71.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s71.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s71.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s71.addTransition(ScannerTransEntry(7 ,'e' ,8));
   s71.addTransition(ScannerTransEntry(8 ,'r' ,9));
   _scannerList.Insert(s71);

   Scanner s72(PATH);
   s72.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(2 ,START));
   s72.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(4 ,FINAL));
   s72.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s72.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s72.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s72.addTransition(ScannerTransEntry(3 ,'h' ,4));
   _scannerList.Insert(s72);

   Scanner s73(PASSWD);
   s73.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(2 ,START));
   s73.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(6 ,FINAL));
   s73.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s73.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s73.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s73.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s73.addTransition(ScannerTransEntry(4 ,'w' ,5));
   s73.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s73);

   Scanner s74(PERMISSION);
   s74.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(2 ,START));
   s74.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(10 ,FINAL));
   s74.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s74.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s74.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s74.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s74.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s74.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s74.addTransition(ScannerTransEntry(6 ,'s' ,7));
   s74.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s74.addTransition(ScannerTransEntry(8 ,'o' ,9));
   s74.addTransition(ScannerTransEntry(9 ,'n' ,10));
   _scannerList.Insert(s74);

   Scanner s75(PLAIN);
   s75.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(2 ,START));
   s75.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(5 ,FINAL));
   s75.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s75.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s75.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s75.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s75.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s75);

   Scanner s76(POOL);
   s76.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(2 ,START));
   s76.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(4 ,FINAL));
   s76.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s76.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s76.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s76.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s76);

   Scanner s77(PRIMARY);
   s77.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(2 ,START));
   s77.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(7 ,FINAL));
   s77.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s77.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s77.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s77.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s77.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s77.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s77.addTransition(ScannerTransEntry(6 ,'y' ,7));
   _scannerList.Insert(s77);

   Scanner s78(QUERYCACHE);
   s78.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(2 ,START));
   s78.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(10 ,FINAL));
   s78.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s78.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s78.addTransition(ScannerTransEntry(2 ,'q' ,0));
   s78.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s78.addTransition(ScannerTransEntry(4 ,'y' ,5));
   s78.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s78.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s78.addTransition(ScannerTransEntry(7 ,'c' ,8));
   s78.addTransition(ScannerTransEntry(8 ,'h' ,9));
   s78.addTransition(ScannerTransEntry(9 ,'e' ,10));
   _scannerList.Insert(s78);

   Scanner s79(QUERYHIST);
   s79.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(2 ,START));
   s79.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(9 ,FINAL));
   s79.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s79.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s79.addTransition(ScannerTransEntry(2 ,'q' ,0));
   s79.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s79.addTransition(ScannerTransEntry(4 ,'y' ,5));
   s79.addTransition(ScannerTransEntry(5 ,'h' ,6));
   s79.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s79.addTransition(ScannerTransEntry(7 ,'s' ,8));
   s79.addTransition(ScannerTransEntry(8 ,'t' ,9));
   _scannerList.Insert(s79);

   Scanner s80(QUIT);
   s80.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(2 ,START));
   s80.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(4 ,FINAL));
   s80.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s80.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s80.addTransition(ScannerTransEntry(2 ,'q' ,0));
   s80.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s80);

   Scanner s81(RAWMODE);
   s81.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(2 ,START));
   s81.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(7 ,FINAL));
   s81.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s81.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s81.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s81.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s81.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s81.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s81.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s81);

   Scanner s82(RELOCATE);
   s82.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(2 ,START));
   s82.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(8 ,FINAL));
   s82.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s82.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s82.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s82.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s82.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s82.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s82.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s82.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s82);

   Scanner s83(REMOVE);
   s83.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(2 ,START));
   s83.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(6 ,FINAL));
   s83.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s83.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s83.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s83.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s83.addTransition(ScannerTransEntry(4 ,'v' ,5));
   s83.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s83);

   Scanner s84(RECOVER);
   s84.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(2 ,START));
   s84.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(7 ,FINAL));
   s84.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s84.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s84.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s84.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s84.addTransition(ScannerTransEntry(4 ,'v' ,5));
   s84.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s84.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s84);

   Scanner s85(RESET);
   s85.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(2 ,START));
   s85.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(5 ,FINAL));
   s85.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s85.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s85.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s85.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s85.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s85);

   Scanner s86(RESTORE);
   s86.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(2 ,START));
   s86.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(7 ,FINAL));
   s86.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s86.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s86.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s86.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s86.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s86.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s86.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s86);

   Scanner s87(RETRIEVE);
   s87.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(2 ,START));
   s87.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(8 ,FINAL));
   s87.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s87.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s87.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s87.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s87.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s87.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s87.addTransition(ScannerTransEntry(6 ,'v' ,7));
   s87.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s87);

   Scanner s88(RIGHT);
   s88.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(2 ,START));
   s88.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(5 ,FINAL));
   s88.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s88.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s88.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s88.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s88.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s88);

   Scanner s89(ROLE);
   s89.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(2 ,START));
   s89.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(4 ,FINAL));
   s89.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s89.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s89.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s89.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s89);

   Scanner s90(SECONDARY);
   s90.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(2 ,START));
   s90.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(9 ,FINAL));
   s90.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s90.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s90.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s90.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s90.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s90.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s90.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s90.addTransition(ScannerTransEntry(7 ,'r' ,8));
   s90.addTransition(ScannerTransEntry(8 ,'y' ,9));
   _scannerList.Insert(s90);

   Scanner s91(SESSION);
   s91.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(2 ,START));
   s91.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(7 ,FINAL));
   s91.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s91.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s91.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s91.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s91.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s91.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s91.addTransition(ScannerTransEntry(6 ,'n' ,7));
   _scannerList.Insert(s91);

   Scanner s92(SET);
   s92.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(2 ,START));
   s92.addState(ScannerStateEntry(3 ,FINAL));
   s92.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s92.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s92.addTransition(ScannerTransEntry(2 ,'s' ,0));
   _scannerList.Insert(s92);

   Scanner s93(SETTSNODEINFO);
   s93.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(2 ,START));
   s93.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(11 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(12 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(13 ,FINAL));
   s93.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s93.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s93.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s93.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s93.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s93.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s93.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s93.addTransition(ScannerTransEntry(7 ,'d' ,8));
   s93.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s93.addTransition(ScannerTransEntry(9 ,'i' ,10));
   s93.addTransition(ScannerTransEntry(10 ,'n' ,11));
   s93.addTransition(ScannerTransEntry(11 ,'f' ,12));
   s93.addTransition(ScannerTransEntry(12 ,'o' ,13));
   _scannerList.Insert(s93);

   Scanner s94(SIZE);
   s94.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(2 ,START));
   s94.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(4 ,FINAL));
   s94.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s94.addTransition(ScannerTransEntry(1 ,'z' ,3));
   s94.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s94.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s94);

   Scanner s95(SORTAREASIZE);
   s95.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(2 ,START));
   s95.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(11 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(12 ,FINAL));
   s95.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s95.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s95.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s95.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s95.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s95.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s95.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s95.addTransition(ScannerTransEntry(7 ,'a' ,8));
   s95.addTransition(ScannerTransEntry(8 ,'s' ,9));
   s95.addTransition(ScannerTransEntry(9 ,'i' ,10));
   s95.addTransition(ScannerTransEntry(10 ,'z' ,11));
   s95.addTransition(ScannerTransEntry(11 ,'e' ,12));
   _scannerList.Insert(s95);

   Scanner s96(STRUCTURE);
   s96.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(2 ,START));
   s96.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(9 ,FINAL));
   s96.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s96.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s96.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s96.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s96.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s96.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s96.addTransition(ScannerTransEntry(6 ,'u' ,7));
   s96.addTransition(ScannerTransEntry(7 ,'r' ,8));
   s96.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s96);

   Scanner s97(SHOW);
   s97.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(2 ,START));
   s97.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(4 ,FINAL));
   s97.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s97.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s97.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s97.addTransition(ScannerTransEntry(3 ,'w' ,4));
   _scannerList.Insert(s97);

   Scanner s98(START_TOK);
   s98.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(2 ,START));
   s98.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(5 ,FINAL));
   s98.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s98.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s98.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s98.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s98.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s98);

   Scanner s99(STOP_TOK);
   s99.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(2 ,START));
   s99.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(4 ,FINAL));
   s99.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s99.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s99.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s99.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s99);

   Scanner s100(SWITCH);
   s100.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(2 ,START));
   s100.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(6 ,FINAL));
   s100.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s100.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s100.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s100.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s100.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s100.addTransition(ScannerTransEntry(5 ,'h' ,6));
   _scannerList.Insert(s100);

   Scanner s101(SYNC);
   s101.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(2 ,START));
   s101.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(4 ,FINAL));
   s101.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s101.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s101.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s101.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s101);

   Scanner s102(SYSSIZE);
   s102.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(2 ,START));
   s102.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(7 ,FINAL));
   s102.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s102.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s102.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s102.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s102.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s102.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s102.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s102);

   Scanner s103(TABLE);
   s103.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(2 ,START));
   s103.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(5 ,FINAL));
   s103.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s103.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s103.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s103.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s103.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s103);

   Scanner s104(TABLECACHE);
   s104.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(2 ,START));
   s104.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(10 ,FINAL));
   s104.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s104.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s104.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s104.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s104.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s104.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s104.addTransition(ScannerTransEntry(7 ,'c' ,8));
   s104.addTransition(ScannerTransEntry(8 ,'h' ,9));
   s104.addTransition(ScannerTransEntry(9 ,'e' ,10));
   _scannerList.Insert(s104);

   Scanner s105(TABLESET);
   s105.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(2 ,START));
   s105.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(8 ,FINAL));
   s105.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s105.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s105.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s105.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s105.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s105.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s105.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s105.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s105);

   Scanner s106(TIMEOUT);
   s106.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(2 ,START));
   s106.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(7 ,FINAL));
   s106.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s106.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s106.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s106.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s106.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s106.addTransition(ScannerTransEntry(5 ,'u' ,6));
   s106.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s106);

   Scanner s107(THREAD);
   s107.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(2 ,START));
   s107.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(6 ,FINAL));
   s107.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s107.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s107.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s107.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s107.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s107.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s107);

   Scanner s108(THREADINFO);
   s108.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(2 ,START));
   s108.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(10 ,FINAL));
   s108.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s108.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s108.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s108.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s108.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s108.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s108.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s108.addTransition(ScannerTransEntry(7 ,'n' ,8));
   s108.addTransition(ScannerTransEntry(8 ,'f' ,9));
   s108.addTransition(ScannerTransEntry(9 ,'o' ,10));
   _scannerList.Insert(s108);

   Scanner s109(THRESHOLD);
   s109.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(2 ,START));
   s109.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(9 ,FINAL));
   s109.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s109.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s109.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s109.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s109.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s109.addTransition(ScannerTransEntry(5 ,'h' ,6));
   s109.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s109.addTransition(ScannerTransEntry(7 ,'l' ,8));
   s109.addTransition(ScannerTransEntry(8 ,'d' ,9));
   _scannerList.Insert(s109);

   Scanner s110(TMPSIZE);
   s110.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(2 ,START));
   s110.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(7 ,FINAL));
   s110.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s110.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s110.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s110.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s110.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s110.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s110);

   Scanner s111(TO);
   s111.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(1 ,FINAL));
   s111.addState(ScannerStateEntry(2 ,START));
   s111.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s111.addTransition(ScannerTransEntry(2 ,'t' ,0));
   _scannerList.Insert(s111);

   Scanner s112(TRACE);
   s112.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(2 ,START));
   s112.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(5 ,FINAL));
   s112.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s112.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s112.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s112.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s112.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s112);

   Scanner s113(TRANSACTION);
   s113.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(2 ,START));
   s113.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(11 ,FINAL));
   s113.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s113.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s113.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s113.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s113.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s113.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s113.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s113.addTransition(ScannerTransEntry(7 ,'t' ,8));
   s113.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s113.addTransition(ScannerTransEntry(9 ,'o' ,10));
   s113.addTransition(ScannerTransEntry(10 ,'n' ,11));
   _scannerList.Insert(s113);

   Scanner s114(TSROOT);
   s114.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(2 ,START));
   s114.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(6 ,FINAL));
   s114.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s114.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s114.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s114.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s114.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s114.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s114);

   Scanner s115(USER);
   s115.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(2 ,START));
   s115.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(4 ,FINAL));
   s115.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s115.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s115.addTransition(ScannerTransEntry(3 ,'r' ,4));
   _scannerList.Insert(s115);

   Scanner s116(VERIFY);
   s116.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(2 ,START));
   s116.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(6 ,FINAL));
   s116.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s116.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s116.addTransition(ScannerTransEntry(2 ,'v' ,0));
   s116.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s116.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s116.addTransition(ScannerTransEntry(5 ,'y' ,6));
   _scannerList.Insert(s116);

   Scanner s117(WITH);
   s117.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(2 ,START));
   s117.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(4 ,FINAL));
   s117.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s117.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s117.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s117.addTransition(ScannerTransEntry(3 ,'h' ,4));
   _scannerList.Insert(s117);

   Scanner s118(XML);
   s118.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(2 ,START));
   s118.addState(ScannerStateEntry(3 ,FINAL));
   s118.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s118.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s118.addTransition(ScannerTransEntry(2 ,'x' ,0));
   _scannerList.Insert(s118);

   Scanner s119(KSEP);
   s119.addState(ScannerStateEntry(0 ,START));
   s119.addState(ScannerStateEntry(1 ,FINAL));
   s119.addTransition(ScannerTransEntry(0 ,',' ,1));
   _scannerList.Insert(s119);

   Scanner s120(SEMICOLON);
   s120.addState(ScannerStateEntry(0 ,START));
   s120.addState(ScannerStateEntry(1 ,FINAL));
   s120.addTransition(ScannerTransEntry(0 ,';' ,1));
   _scannerList.Insert(s120);

   Scanner s121(EQU);
   s121.addState(ScannerStateEntry(0 ,START));
   s121.addState(ScannerStateEntry(1 ,FINAL));
   s121.addTransition(ScannerTransEntry(0 ,'=' ,1));
   _scannerList.Insert(s121);

   Scanner s122(INTVAL);
   s122.addState(ScannerStateEntry(0 ,START));
   s122.addState(ScannerStateEntry(1 ,FINAL));
   s122.addState(ScannerStateEntry(2 ,FINAL));
   s122.addTransition(ScannerTransEntry(0 ,'1' ,1));
   s122.addTransition(ScannerTransEntry(0 ,'2' ,1));
   s122.addTransition(ScannerTransEntry(0 ,'3' ,1));
   s122.addTransition(ScannerTransEntry(0 ,'4' ,1));
   s122.addTransition(ScannerTransEntry(0 ,'5' ,1));
   s122.addTransition(ScannerTransEntry(0 ,'6' ,1));
   s122.addTransition(ScannerTransEntry(0 ,'7' ,1));
   s122.addTransition(ScannerTransEntry(0 ,'8' ,1));
   s122.addTransition(ScannerTransEntry(0 ,'9' ,1));
   s122.addTransition(ScannerTransEntry(0 ,'0' ,2));
   s122.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s122.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s122.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s122.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s122.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s122.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s122.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s122.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s122.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s122.addTransition(ScannerTransEntry(1 ,'9' ,1));
   _scannerList.Insert(s122);

   Scanner s123(IDENTIFIER);
   s123.addState(ScannerStateEntry(0 ,START));
   s123.addState(ScannerStateEntry(1 ,FINAL));
   s123.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'z' ,1));
   _scannerList.Insert(s123);

}
void CegoAdm::loadParser0()
{
   _actionMap[467][SEMICOLON] = ActionEntry(REDUCE, 43);
   _actionMap[468][SEMICOLON] = ActionEntry(REDUCE, 121);
   _actionMap[469][SEMICOLON] = ActionEntry(REDUCE, 124);
   _actionMap[446][SEMICOLON] = ActionEntry(REDUCE, 68);
   _actionMap[447][IDENTIFIER] = ActionEntry(SHIFT, 467);
   _actionMap[448][SEMICOLON] = ActionEntry(REDUCE, 153);
   _actionMap[448][PRIMARY] = ActionEntry(REDUCE, 153);
   _actionMap[448][SECONDARY] = ActionEntry(REDUCE, 153);
   _actionMap[448][SYSSIZE] = ActionEntry(REDUCE, 153);
   _actionMap[448][TMPSIZE] = ActionEntry(REDUCE, 153);
   _actionMap[448][LOGSIZE] = ActionEntry(REDUCE, 153);
   _actionMap[448][LOGNUM] = ActionEntry(REDUCE, 153);
   _actionMap[448][APPSIZE] = ActionEntry(REDUCE, 153);
   _actionMap[448][SORTAREASIZE] = ActionEntry(REDUCE, 153);
   _actionMap[448][TSROOT] = ActionEntry(REDUCE, 153);
   _actionMap[448][BRANCHID] = ActionEntry(REDUCE, 153);
   _actionMap[449][SEMICOLON] = ActionEntry(REDUCE, 156);
   _actionMap[449][PRIMARY] = ActionEntry(REDUCE, 156);
   _actionMap[449][SECONDARY] = ActionEntry(REDUCE, 156);
   _actionMap[449][SYSSIZE] = ActionEntry(REDUCE, 156);
   _actionMap[449][TMPSIZE] = ActionEntry(REDUCE, 156);
   _actionMap[449][LOGSIZE] = ActionEntry(REDUCE, 156);
   _actionMap[449][LOGNUM] = ActionEntry(REDUCE, 156);
   _actionMap[449][APPSIZE] = ActionEntry(REDUCE, 156);
   _actionMap[449][SORTAREASIZE] = ActionEntry(REDUCE, 156);
   _actionMap[449][TSROOT] = ActionEntry(REDUCE, 156);
   _actionMap[449][BRANCHID] = ActionEntry(REDUCE, 156);
   _actionMap[450][SEMICOLON] = ActionEntry(REDUCE, 152);
   _actionMap[450][PRIMARY] = ActionEntry(REDUCE, 152);
   _actionMap[450][SECONDARY] = ActionEntry(REDUCE, 152);
   _actionMap[450][SYSSIZE] = ActionEntry(REDUCE, 152);
   _actionMap[450][TMPSIZE] = ActionEntry(REDUCE, 152);
   _actionMap[450][LOGSIZE] = ActionEntry(REDUCE, 152);
   _actionMap[450][LOGNUM] = ActionEntry(REDUCE, 152);
   _actionMap[450][APPSIZE] = ActionEntry(REDUCE, 152);
   _actionMap[450][SORTAREASIZE] = ActionEntry(REDUCE, 152);
   _actionMap[450][TSROOT] = ActionEntry(REDUCE, 152);
   _actionMap[450][BRANCHID] = ActionEntry(REDUCE, 152);
   _actionMap[451][SEMICOLON] = ActionEntry(REDUCE, 151);
   _actionMap[451][PRIMARY] = ActionEntry(REDUCE, 151);
   _actionMap[451][SECONDARY] = ActionEntry(REDUCE, 151);
   _actionMap[451][SYSSIZE] = ActionEntry(REDUCE, 151);
   _actionMap[451][TMPSIZE] = ActionEntry(REDUCE, 151);
   _actionMap[451][LOGSIZE] = ActionEntry(REDUCE, 151);
   _actionMap[451][LOGNUM] = ActionEntry(REDUCE, 151);
   _actionMap[451][APPSIZE] = ActionEntry(REDUCE, 151);
   _actionMap[451][SORTAREASIZE] = ActionEntry(REDUCE, 151);
   _actionMap[451][TSROOT] = ActionEntry(REDUCE, 151);
   _actionMap[451][BRANCHID] = ActionEntry(REDUCE, 151);
   _actionMap[452][SEMICOLON] = ActionEntry(REDUCE, 147);
}
void CegoAdm::loadParser1()
{
   _actionMap[452][PRIMARY] = ActionEntry(REDUCE, 147);
   _actionMap[452][SECONDARY] = ActionEntry(REDUCE, 147);
   _actionMap[452][SYSSIZE] = ActionEntry(REDUCE, 147);
   _actionMap[452][TMPSIZE] = ActionEntry(REDUCE, 147);
   _actionMap[452][LOGSIZE] = ActionEntry(REDUCE, 147);
   _actionMap[452][LOGNUM] = ActionEntry(REDUCE, 147);
   _actionMap[452][APPSIZE] = ActionEntry(REDUCE, 147);
   _actionMap[452][SORTAREASIZE] = ActionEntry(REDUCE, 147);
   _actionMap[452][TSROOT] = ActionEntry(REDUCE, 147);
   _actionMap[452][BRANCHID] = ActionEntry(REDUCE, 147);
   _actionMap[453][SEMICOLON] = ActionEntry(REDUCE, 148);
   _actionMap[453][PRIMARY] = ActionEntry(REDUCE, 148);
   _actionMap[453][SECONDARY] = ActionEntry(REDUCE, 148);
   _actionMap[453][SYSSIZE] = ActionEntry(REDUCE, 148);
   _actionMap[453][TMPSIZE] = ActionEntry(REDUCE, 148);
   _actionMap[453][LOGSIZE] = ActionEntry(REDUCE, 148);
   _actionMap[453][LOGNUM] = ActionEntry(REDUCE, 148);
   _actionMap[453][APPSIZE] = ActionEntry(REDUCE, 148);
   _actionMap[453][SORTAREASIZE] = ActionEntry(REDUCE, 148);
   _actionMap[453][TSROOT] = ActionEntry(REDUCE, 148);
   _actionMap[453][BRANCHID] = ActionEntry(REDUCE, 148);
   _actionMap[454][SEMICOLON] = ActionEntry(REDUCE, 154);
   _actionMap[454][PRIMARY] = ActionEntry(REDUCE, 154);
   _actionMap[454][SECONDARY] = ActionEntry(REDUCE, 154);
   _actionMap[454][SYSSIZE] = ActionEntry(REDUCE, 154);
   _actionMap[454][TMPSIZE] = ActionEntry(REDUCE, 154);
   _actionMap[454][LOGSIZE] = ActionEntry(REDUCE, 154);
   _actionMap[454][LOGNUM] = ActionEntry(REDUCE, 154);
   _actionMap[454][APPSIZE] = ActionEntry(REDUCE, 154);
   _actionMap[454][SORTAREASIZE] = ActionEntry(REDUCE, 154);
   _actionMap[454][TSROOT] = ActionEntry(REDUCE, 154);
   _actionMap[454][BRANCHID] = ActionEntry(REDUCE, 154);
   _actionMap[455][SEMICOLON] = ActionEntry(REDUCE, 149);
   _actionMap[455][PRIMARY] = ActionEntry(REDUCE, 149);
   _actionMap[455][SECONDARY] = ActionEntry(REDUCE, 149);
   _actionMap[455][SYSSIZE] = ActionEntry(REDUCE, 149);
   _actionMap[455][TMPSIZE] = ActionEntry(REDUCE, 149);
   _actionMap[455][LOGSIZE] = ActionEntry(REDUCE, 149);
   _actionMap[455][LOGNUM] = ActionEntry(REDUCE, 149);
   _actionMap[455][APPSIZE] = ActionEntry(REDUCE, 149);
   _actionMap[455][SORTAREASIZE] = ActionEntry(REDUCE, 149);
   _actionMap[455][TSROOT] = ActionEntry(REDUCE, 149);
   _actionMap[455][BRANCHID] = ActionEntry(REDUCE, 149);
   _actionMap[456][SEMICOLON] = ActionEntry(REDUCE, 150);
   _actionMap[456][PRIMARY] = ActionEntry(REDUCE, 150);
   _actionMap[456][SECONDARY] = ActionEntry(REDUCE, 150);
   _actionMap[456][SYSSIZE] = ActionEntry(REDUCE, 150);
   _actionMap[456][TMPSIZE] = ActionEntry(REDUCE, 150);
   _actionMap[456][LOGSIZE] = ActionEntry(REDUCE, 150);
   _actionMap[456][LOGNUM] = ActionEntry(REDUCE, 150);
}
void CegoAdm::loadParser2()
{
   _actionMap[456][APPSIZE] = ActionEntry(REDUCE, 150);
   _actionMap[456][SORTAREASIZE] = ActionEntry(REDUCE, 150);
   _actionMap[456][TSROOT] = ActionEntry(REDUCE, 150);
   _actionMap[456][BRANCHID] = ActionEntry(REDUCE, 150);
   _actionMap[457][SEMICOLON] = ActionEntry(REDUCE, 155);
   _actionMap[457][PRIMARY] = ActionEntry(REDUCE, 155);
   _actionMap[457][SECONDARY] = ActionEntry(REDUCE, 155);
   _actionMap[457][SYSSIZE] = ActionEntry(REDUCE, 155);
   _actionMap[457][TMPSIZE] = ActionEntry(REDUCE, 155);
   _actionMap[457][LOGSIZE] = ActionEntry(REDUCE, 155);
   _actionMap[457][LOGNUM] = ActionEntry(REDUCE, 155);
   _actionMap[457][APPSIZE] = ActionEntry(REDUCE, 155);
   _actionMap[457][SORTAREASIZE] = ActionEntry(REDUCE, 155);
   _actionMap[457][TSROOT] = ActionEntry(REDUCE, 155);
   _actionMap[457][BRANCHID] = ActionEntry(REDUCE, 155);
   _actionMap[458][STRINGVAL] = ActionEntry(SHIFT, 468);
   _actionMap[459][SEMICOLON] = ActionEntry(REDUCE, 123);
   _actionMap[460][STRINGVAL] = ActionEntry(SHIFT, 469);
   _actionMap[461][SEMICOLON] = ActionEntry(REDUCE, 126);
   _actionMap[462][SEMICOLON] = ActionEntry(REDUCE, 57);
   _actionMap[463][KSEP] = ActionEntry(REDUCE, 58);
   _actionMap[463][FOR] = ActionEntry(REDUCE, 58);
   _actionMap[464][KSEP] = ActionEntry(REDUCE, 61);
   _actionMap[464][FOR] = ActionEntry(REDUCE, 61);
   _actionMap[465][KSEP] = ActionEntry(REDUCE, 62);
   _actionMap[465][FOR] = ActionEntry(REDUCE, 62);
   _actionMap[466][KSEP] = ActionEntry(REDUCE, 60);
   _actionMap[466][FOR] = ActionEntry(REDUCE, 60);
   _actionMap[417][IDENTIFIER] = ActionEntry(SHIFT, 446);
   _actionMap[418][SEMICOLON] = ActionEntry(REDUCE, 47);
   _actionMap[419][TO] = ActionEntry(SHIFT, 447);
   _actionMap[420][INTVAL] = ActionEntry(SHIFT, 448);
   _actionMap[421][INTVAL] = ActionEntry(SHIFT, 449);
   _actionMap[422][INTVAL] = ActionEntry(SHIFT, 450);
   _actionMap[423][INTVAL] = ActionEntry(SHIFT, 451);
   _actionMap[424][STRINGVAL] = ActionEntry(SHIFT, 452);
   _actionMap[425][STRINGVAL] = ActionEntry(SHIFT, 453);
   _actionMap[426][INTVAL] = ActionEntry(SHIFT, 454);
   _actionMap[427][INTVAL] = ActionEntry(SHIFT, 455);
   _actionMap[428][INTVAL] = ActionEntry(SHIFT, 456);
   _actionMap[429][STRINGVAL] = ActionEntry(SHIFT, 457);
   _actionMap[430][SEMICOLON] = ActionEntry(REDUCE, 127);
   _actionMap[431][TO] = ActionEntry(SHIFT, 458);
   _actionMap[432][STRINGVAL] = ActionEntry(SHIFT, 459);
   _actionMap[433][SEMICOLON] = ActionEntry(REDUCE, 122);
   _actionMap[434][FROM] = ActionEntry(SHIFT, 460);
   _actionMap[435][STRINGVAL] = ActionEntry(SHIFT, 461);
   _actionMap[436][SEMICOLON] = ActionEntry(REDUCE, 125);
   _actionMap[437][SEMICOLON] = ActionEntry(REDUCE, 50);
   _actionMap[438][SEMICOLON] = ActionEntry(REDUCE, 39);
}
void CegoAdm::loadParser3()
{
   _actionMap[439][SEMICOLON] = ActionEntry(REDUCE, 38);
   _actionMap[440][IDENTIFIER] = ActionEntry(SHIFT, 462);
   _actionMap[441][TABLESET] = ActionEntry(SHIFT, 393);
   _actionMap[441][FILTER] = ActionEntry(SHIFT, 391);
   _actionMap[441][RIGHT] = ActionEntry(SHIFT, 392);
   _jumpMap[441][PermEntry] = 463;
   _actionMap[442][STRINGVAL] = ActionEntry(SHIFT, 464);
   _actionMap[443][IDENTIFIER] = ActionEntry(SHIFT, 465);
   _actionMap[444][IDENTIFIER] = ActionEntry(SHIFT, 466);
   _actionMap[445][MESSAGE] = ActionEntry(REDUCE, 129);
   _actionMap[445][KEEP] = ActionEntry(REDUCE, 129);
   _actionMap[445][SEMICOLON] = ActionEntry(REDUCE, 129);
   _actionMap[345][TO] = ActionEntry(SHIFT, 417);
   _actionMap[346][STRINGVAL] = ActionEntry(SHIFT, 418);
   _actionMap[347][INTVAL] = ActionEntry(SHIFT, 419);
   _actionMap[348][SEMICOLON] = ActionEntry(REDUCE, 51);
   _actionMap[349][KEEP] = ActionEntry(REDUCE, 133);
   _actionMap[349][SEMICOLON] = ActionEntry(REDUCE, 133);
   _actionMap[350][SEMICOLON] = ActionEntry(REDUCE, 70);
   _actionMap[351][SEMICOLON] = ActionEntry(REDUCE, 145);
   _actionMap[351][PRIMARY] = ActionEntry(REDUCE, 145);
   _actionMap[351][SECONDARY] = ActionEntry(REDUCE, 145);
   _actionMap[351][SYSSIZE] = ActionEntry(REDUCE, 145);
   _actionMap[351][TMPSIZE] = ActionEntry(REDUCE, 145);
   _actionMap[351][LOGSIZE] = ActionEntry(REDUCE, 145);
   _actionMap[351][LOGNUM] = ActionEntry(REDUCE, 145);
   _actionMap[351][APPSIZE] = ActionEntry(REDUCE, 145);
   _actionMap[351][SORTAREASIZE] = ActionEntry(REDUCE, 145);
   _actionMap[351][TSROOT] = ActionEntry(REDUCE, 145);
   _actionMap[351][BRANCHID] = ActionEntry(REDUCE, 145);
   _actionMap[352][EQU] = ActionEntry(SHIFT, 420);
   _actionMap[353][EQU] = ActionEntry(SHIFT, 421);
   _actionMap[354][EQU] = ActionEntry(SHIFT, 422);
   _actionMap[355][EQU] = ActionEntry(SHIFT, 423);
   _actionMap[356][EQU] = ActionEntry(SHIFT, 424);
   _actionMap[357][EQU] = ActionEntry(SHIFT, 425);
   _actionMap[358][EQU] = ActionEntry(SHIFT, 426);
   _actionMap[359][EQU] = ActionEntry(SHIFT, 427);
   _actionMap[360][EQU] = ActionEntry(SHIFT, 428);
   _actionMap[361][EQU] = ActionEntry(SHIFT, 429);
   _actionMap[362][SEMICOLON] = ActionEntry(REDUCE, 164);
   _actionMap[363][SEMICOLON] = ActionEntry(REDUCE, 163);
   _actionMap[364][SEMICOLON] = ActionEntry(REDUCE, 72);
   _actionMap[365][KEEP] = ActionEntry(SHIFT, 366);
   _actionMap[365][SEMICOLON] = ActionEntry(REDUCE, 128);
   _jumpMap[365][KeepTicketOpt] = 364;
   _actionMap[366][TSTICKET] = ActionEntry(SHIFT, 430);
   _actionMap[367][IDENTIFIER] = ActionEntry(SHIFT, 431);
   _actionMap[368][TO] = ActionEntry(SHIFT, 432);
   _actionMap[369][STRINGVAL] = ActionEntry(SHIFT, 433);
}
void CegoAdm::loadParser4()
{
   _actionMap[370][IDENTIFIER] = ActionEntry(SHIFT, 434);
   _actionMap[371][FROM] = ActionEntry(SHIFT, 435);
   _actionMap[372][STRINGVAL] = ActionEntry(SHIFT, 436);
   _actionMap[373][SEMICOLON] = ActionEntry(REDUCE, 73);
   _actionMap[374][STRINGVAL] = ActionEntry(SHIFT, 437);
   _actionMap[375][STRINGVAL] = ActionEntry(SHIFT, 438);
   _actionMap[376][STRINGVAL] = ActionEntry(SHIFT, 439);
   _actionMap[377][SEMICOLON] = ActionEntry(REDUCE, 69);
   _actionMap[378][SEMICOLON] = ActionEntry(REDUCE, 63);
   _actionMap[379][SEMICOLON] = ActionEntry(REDUCE, 52);
   _actionMap[380][SEMICOLON] = ActionEntry(REDUCE, 157);
   _actionMap[381][SEMICOLON] = ActionEntry(REDUCE, 75);
   _actionMap[382][SEMICOLON] = ActionEntry(REDUCE, 85);
   _actionMap[383][SEMICOLON] = ActionEntry(REDUCE, 82);
   _actionMap[384][SEMICOLON] = ActionEntry(REDUCE, 81);
   _actionMap[385][MESSAGE] = ActionEntry(REDUCE, 131);
   _actionMap[385][KEEP] = ActionEntry(REDUCE, 131);
   _actionMap[385][SEMICOLON] = ActionEntry(REDUCE, 131);
   _actionMap[386][SEMICOLON] = ActionEntry(REDUCE, 87);
   _actionMap[387][SEMICOLON] = ActionEntry(REDUCE, 88);
   _actionMap[388][SEMICOLON] = ActionEntry(REDUCE, 90);
   _actionMap[389][FOR] = ActionEntry(SHIFT, 440);
   _actionMap[389][KSEP] = ActionEntry(SHIFT, 441);
   _actionMap[390][KSEP] = ActionEntry(REDUCE, 59);
   _actionMap[390][FOR] = ActionEntry(REDUCE, 59);
   _actionMap[391][EQU] = ActionEntry(SHIFT, 442);
   _actionMap[392][EQU] = ActionEntry(SHIFT, 443);
   _actionMap[393][EQU] = ActionEntry(SHIFT, 444);
   _actionMap[394][SEMICOLON] = ActionEntry(REDUCE, 114);
   _actionMap[395][KSEP] = ActionEntry(REDUCE, 115);
   _actionMap[395][FOR] = ActionEntry(REDUCE, 115);
   _actionMap[396][KSEP] = ActionEntry(REDUCE, 117);
   _actionMap[396][FOR] = ActionEntry(REDUCE, 117);
   _actionMap[397][KSEP] = ActionEntry(REDUCE, 119);
   _actionMap[397][FOR] = ActionEntry(REDUCE, 119);
   _actionMap[398][KSEP] = ActionEntry(REDUCE, 118);
   _actionMap[398][FOR] = ActionEntry(REDUCE, 118);
   _actionMap[399][KSEP] = ActionEntry(REDUCE, 120);
   _actionMap[399][FOR] = ActionEntry(REDUCE, 120);
   _actionMap[400][SEMICOLON] = ActionEntry(REDUCE, 89);
   _actionMap[401][SEMICOLON] = ActionEntry(REDUCE, 83);
   _actionMap[402][SEMICOLON] = ActionEntry(REDUCE, 102);
   _actionMap[403][KSEP] = ActionEntry(REDUCE, 103);
   _actionMap[403][FOR] = ActionEntry(REDUCE, 103);
   _actionMap[404][KSEP] = ActionEntry(REDUCE, 107);
   _actionMap[404][FOR] = ActionEntry(REDUCE, 107);
   _actionMap[405][KSEP] = ActionEntry(REDUCE, 105);
   _actionMap[405][FOR] = ActionEntry(REDUCE, 105);
   _actionMap[406][KSEP] = ActionEntry(REDUCE, 108);
   _actionMap[406][FOR] = ActionEntry(REDUCE, 108);
}
void CegoAdm::loadParser5()
{
   _actionMap[407][KSEP] = ActionEntry(REDUCE, 106);
   _actionMap[407][FOR] = ActionEntry(REDUCE, 106);
   _actionMap[408][SEMICOLON] = ActionEntry(REDUCE, 84);
   _actionMap[409][SEMICOLON] = ActionEntry(REDUCE, 86);
   _actionMap[410][SEMICOLON] = ActionEntry(REDUCE, 161);
   _actionMap[411][SEMICOLON] = ActionEntry(REDUCE, 135);
   _actionMap[411][CLEANUP] = ActionEntry(REDUCE, 135);
   _actionMap[411][FORCELOAD] = ActionEntry(REDUCE, 135);
   _actionMap[411][CPDUMP] = ActionEntry(REDUCE, 135);
   _actionMap[411][NOINIT] = ActionEntry(REDUCE, 135);
   _actionMap[412][SEMICOLON] = ActionEntry(REDUCE, 137);
   _actionMap[412][CLEANUP] = ActionEntry(REDUCE, 137);
   _actionMap[412][FORCELOAD] = ActionEntry(REDUCE, 137);
   _actionMap[412][CPDUMP] = ActionEntry(REDUCE, 137);
   _actionMap[412][NOINIT] = ActionEntry(REDUCE, 137);
   _actionMap[413][SEMICOLON] = ActionEntry(REDUCE, 139);
   _actionMap[413][CLEANUP] = ActionEntry(REDUCE, 139);
   _actionMap[413][FORCELOAD] = ActionEntry(REDUCE, 139);
   _actionMap[413][CPDUMP] = ActionEntry(REDUCE, 139);
   _actionMap[413][NOINIT] = ActionEntry(REDUCE, 139);
   _actionMap[414][SEMICOLON] = ActionEntry(REDUCE, 138);
   _actionMap[414][CLEANUP] = ActionEntry(REDUCE, 138);
   _actionMap[414][FORCELOAD] = ActionEntry(REDUCE, 138);
   _actionMap[414][CPDUMP] = ActionEntry(REDUCE, 138);
   _actionMap[414][NOINIT] = ActionEntry(REDUCE, 138);
   _actionMap[415][SEMICOLON] = ActionEntry(REDUCE, 140);
   _actionMap[415][CLEANUP] = ActionEntry(REDUCE, 140);
   _actionMap[415][FORCELOAD] = ActionEntry(REDUCE, 140);
   _actionMap[415][CPDUMP] = ActionEntry(REDUCE, 140);
   _actionMap[415][NOINIT] = ActionEntry(REDUCE, 140);
   _actionMap[416][TIMEOUT] = ActionEntry(SHIFT, 311);
   _actionMap[416][MESSAGE] = ActionEntry(REDUCE, 132);
   _actionMap[416][KEEP] = ActionEntry(REDUCE, 132);
   _actionMap[416][SEMICOLON] = ActionEntry(REDUCE, 132);
   _jumpMap[416][TimeoutOpt] = 445;
   _actionMap[256][SEMICOLON] = ActionEntry(REDUCE, 28);
   _actionMap[257][STRINGVAL] = ActionEntry(SHIFT, 345);
   _actionMap[258][BY] = ActionEntry(SHIFT, 346);
   _actionMap[259][SIZE] = ActionEntry(SHIFT, 347);
   _actionMap[260][IDENTIFIER] = ActionEntry(SHIFT, 348);
   _actionMap[261][SEMICOLON] = ActionEntry(REDUCE, 71);
   _actionMap[262][STRINGVAL] = ActionEntry(SHIFT, 349);
   _actionMap[263][MESSAGE] = ActionEntry(SHIFT, 262);
   _actionMap[263][SEMICOLON] = ActionEntry(REDUCE, 134);
   _jumpMap[263][MsgOption] = 350;
   _actionMap[264][SEMICOLON] = ActionEntry(REDUCE, 113);
   _actionMap[265][SEMICOLON] = ActionEntry(REDUCE, 101);
   _actionMap[266][SEMICOLON] = ActionEntry(REDUCE, 30);
   _actionMap[266][PRIMARY] = ActionEntry(SHIFT, 356);
   _actionMap[266][SECONDARY] = ActionEntry(SHIFT, 357);
}
void CegoAdm::loadParser6()
{
   _actionMap[266][SYSSIZE] = ActionEntry(SHIFT, 359);
   _actionMap[266][TMPSIZE] = ActionEntry(SHIFT, 360);
   _actionMap[266][LOGSIZE] = ActionEntry(SHIFT, 355);
   _actionMap[266][LOGNUM] = ActionEntry(SHIFT, 354);
   _actionMap[266][APPSIZE] = ActionEntry(SHIFT, 352);
   _actionMap[266][SORTAREASIZE] = ActionEntry(SHIFT, 358);
   _actionMap[266][TSROOT] = ActionEntry(SHIFT, 361);
   _actionMap[266][BRANCHID] = ActionEntry(SHIFT, 353);
   _jumpMap[266][Attr] = 351;
   _actionMap[267][SEMICOLON] = ActionEntry(REDUCE, 94);
   _actionMap[268][SEMICOLON] = ActionEntry(REDUCE, 67);
   _actionMap[269][SEMICOLON] = ActionEntry(REDUCE, 96);
   _actionMap[270][SEMICOLON] = ActionEntry(REDUCE, 110);
   _actionMap[271][SEMICOLON] = ActionEntry(REDUCE, 98);
   _actionMap[272][IDENTIFIER] = ActionEntry(SHIFT, 362);
   _actionMap[273][IDENTIFIER] = ActionEntry(SHIFT, 363);
   _actionMap[274][SEMICOLON] = ActionEntry(REDUCE, 93);
   _actionMap[275][SEMICOLON] = ActionEntry(REDUCE, 66);
   _actionMap[276][SEMICOLON] = ActionEntry(REDUCE, 95);
   _actionMap[277][SEMICOLON] = ActionEntry(REDUCE, 109);
   _actionMap[278][SEMICOLON] = ActionEntry(REDUCE, 97);
   _actionMap[279][MESSAGE] = ActionEntry(SHIFT, 262);
   _actionMap[279][KEEP] = ActionEntry(REDUCE, 134);
   _actionMap[279][SEMICOLON] = ActionEntry(REDUCE, 134);
   _jumpMap[279][MsgOption] = 365;
   _jumpMap[279][KeepTicketOpt] = 364;
   _actionMap[280][FROM] = ActionEntry(SHIFT, 367);
   _actionMap[281][IDENTIFIER] = ActionEntry(SHIFT, 368);
   _actionMap[282][TO] = ActionEntry(SHIFT, 369);
   _actionMap[283][TO] = ActionEntry(SHIFT, 370);
   _actionMap[284][IDENTIFIER] = ActionEntry(SHIFT, 371);
   _actionMap[285][FROM] = ActionEntry(SHIFT, 372);
   _actionMap[286][SEMICOLON] = ActionEntry(REDUCE, 10);
   _actionMap[287][TO] = ActionEntry(SHIFT, 303);
   _actionMap[287][SEMICOLON] = ActionEntry(REDUCE, 158);
   _jumpMap[287][PitOption] = 373;
   _actionMap[288][SEMICOLON] = ActionEntry(REDUCE, 15);
   _actionMap[289][SEMICOLON] = ActionEntry(REDUCE, 16);
   _actionMap[290][SEMICOLON] = ActionEntry(REDUCE, 9);
   _actionMap[291][SEMICOLON] = ActionEntry(REDUCE, 11);
   _actionMap[292][SEMICOLON] = ActionEntry(REDUCE, 12);
   _actionMap[293][SEMICOLON] = ActionEntry(REDUCE, 111);
   _actionMap[294][SEMICOLON] = ActionEntry(REDUCE, 99);
   _actionMap[295][SEMICOLON] = ActionEntry(REDUCE, 27);
   _actionMap[296][BY] = ActionEntry(SHIFT, 374);
   _actionMap[297][TO] = ActionEntry(SHIFT, 375);
   _actionMap[298][TO] = ActionEntry(SHIFT, 376);
   _actionMap[299][IDENTIFIER] = ActionEntry(SHIFT, 377);
   _actionMap[300][IDENTIFIER] = ActionEntry(SHIFT, 378);
   _actionMap[301][IDENTIFIER] = ActionEntry(SHIFT, 379);
}
void CegoAdm::loadParser7()
{
   _actionMap[302][SEMICOLON] = ActionEntry(REDUCE, 76);
   _actionMap[303][STRINGVAL] = ActionEntry(SHIFT, 380);
   _actionMap[304][SEMICOLON] = ActionEntry(REDUCE, 17);
   _actionMap[305][STRINGVAL] = ActionEntry(SHIFT, 381);
   _actionMap[306][SEMICOLON] = ActionEntry(REDUCE, 29);
   _actionMap[307][IDENTIFIER] = ActionEntry(SHIFT, 382);
   _actionMap[308][IDENTIFIER] = ActionEntry(SHIFT, 383);
   _actionMap[309][IDENTIFIER] = ActionEntry(SHIFT, 384);
   _actionMap[310][SEMICOLON] = ActionEntry(REDUCE, 77);
   _actionMap[311][INTVAL] = ActionEntry(SHIFT, 385);
   _actionMap[312][IDENTIFIER] = ActionEntry(SHIFT, 386);
   _actionMap[313][IDENTIFIER] = ActionEntry(SHIFT, 387);
   _actionMap[314][IDENTIFIER] = ActionEntry(SHIFT, 388);
   _actionMap[315][TABLESET] = ActionEntry(SHIFT, 393);
   _actionMap[315][FILTER] = ActionEntry(SHIFT, 391);
   _actionMap[315][RIGHT] = ActionEntry(SHIFT, 392);
   _jumpMap[315][PermEntry] = 390;
   _jumpMap[315][PermList] = 389;
   _actionMap[316][IDENTIFIER] = ActionEntry(SHIFT, 394);
   _actionMap[317][MAXENTRY] = ActionEntry(SHIFT, 226);
   _actionMap[317][MAXSIZE] = ActionEntry(SHIFT, 228);
   _actionMap[317][HASHRANGE] = ActionEntry(SHIFT, 227);
   _actionMap[317][THRESHOLD] = ActionEntry(SHIFT, 229);
   _jumpMap[317][QueryCacheParam] = 395;
   _actionMap[318][INTVAL] = ActionEntry(SHIFT, 396);
   _actionMap[319][INTVAL] = ActionEntry(SHIFT, 397);
   _actionMap[320][INTVAL] = ActionEntry(SHIFT, 398);
   _actionMap[321][INTVAL] = ActionEntry(SHIFT, 399);
   _actionMap[322][SEMICOLON] = ActionEntry(REDUCE, 92);
   _actionMap[323][SEMICOLON] = ActionEntry(REDUCE, 91);
   _actionMap[324][IDENTIFIER] = ActionEntry(SHIFT, 400);
   _actionMap[325][IDENTIFIER] = ActionEntry(SHIFT, 401);
   _actionMap[326][IDENTIFIER] = ActionEntry(SHIFT, 402);
   _actionMap[327][FILTER] = ActionEntry(SHIFT, 237);
   _actionMap[327][MAXSIZE] = ActionEntry(SHIFT, 239);
   _actionMap[327][MAXENTRY] = ActionEntry(SHIFT, 236);
   _actionMap[327][HASHRANGE] = ActionEntry(SHIFT, 238);
   _jumpMap[327][TableCacheParam] = 403;
   _actionMap[328][INTVAL] = ActionEntry(SHIFT, 404);
   _actionMap[329][STRINGVAL] = ActionEntry(SHIFT, 405);
   _actionMap[330][INTVAL] = ActionEntry(SHIFT, 406);
   _actionMap[331][INTVAL] = ActionEntry(SHIFT, 407);
   _actionMap[332][IDENTIFIER] = ActionEntry(SHIFT, 408);
   _actionMap[333][IDENTIFIER] = ActionEntry(SHIFT, 409);
   _actionMap[334][IDENTIFIER] = ActionEntry(SHIFT, 410);
   _actionMap[335][SEMICOLON] = ActionEntry(REDUCE, 112);
   _actionMap[336][SEMICOLON] = ActionEntry(REDUCE, 100);
   _actionMap[337][SEMICOLON] = ActionEntry(REDUCE, 32);
   _actionMap[337][CLEANUP] = ActionEntry(SHIFT, 412);
   _actionMap[337][FORCELOAD] = ActionEntry(SHIFT, 414);
}
void CegoAdm::loadParser8()
{
   _actionMap[337][CPDUMP] = ActionEntry(SHIFT, 413);
   _actionMap[337][NOINIT] = ActionEntry(SHIFT, 415);
   _jumpMap[337][StartOpt] = 411;
   _actionMap[338][SEMICOLON] = ActionEntry(REDUCE, 37);
   _actionMap[339][SEMICOLON] = ActionEntry(REDUCE, 36);
   _actionMap[340][MESSAGE] = ActionEntry(SHIFT, 262);
   _actionMap[340][SEMICOLON] = ActionEntry(REDUCE, 134);
   _jumpMap[340][MsgOption] = 341;
   _actionMap[341][SEMICOLON] = ActionEntry(REDUCE, 74);
   _actionMap[342][STRINGVAL] = ActionEntry(SHIFT, 416);
   _actionMap[343][SEMICOLON] = ActionEntry(REDUCE, 65);
   _actionMap[344][SEMICOLON] = ActionEntry(REDUCE, 64);
   _actionMap[153][INTVAL] = ActionEntry(SHIFT, 256);
   _actionMap[154][PATH] = ActionEntry(SHIFT, 257);
   _actionMap[155][IDENTIFIED] = ActionEntry(SHIFT, 258);
   _actionMap[156][STRINGVAL] = ActionEntry(SHIFT, 259);
   _actionMap[157][TO] = ActionEntry(SHIFT, 260);
   _actionMap[158][MESSAGE] = ActionEntry(SHIFT, 262);
   _actionMap[158][SEMICOLON] = ActionEntry(REDUCE, 134);
   _jumpMap[158][MsgOption] = 261;
   _actionMap[159][IDENTIFIER] = ActionEntry(SHIFT, 263);
   _actionMap[160][SEMICOLON] = ActionEntry(REDUCE, 44);
   _actionMap[161][IDENTIFIER] = ActionEntry(SHIFT, 264);
   _actionMap[162][IDENTIFIER] = ActionEntry(SHIFT, 265);
   _actionMap[163][SEMICOLON] = ActionEntry(REDUCE, 162);
   _actionMap[164][SEMICOLON] = ActionEntry(REDUCE, 34);
   _actionMap[165][SEMICOLON] = ActionEntry(REDUCE, 46);
   _actionMap[166][SEMICOLON] = ActionEntry(REDUCE, 55);
   _actionMap[167][SEMICOLON] = ActionEntry(REDUCE, 31);
   _actionMap[168][PRIMARY] = ActionEntry(REDUCE, 146);
   _actionMap[168][SECONDARY] = ActionEntry(REDUCE, 146);
   _actionMap[168][SYSSIZE] = ActionEntry(REDUCE, 146);
   _actionMap[168][TMPSIZE] = ActionEntry(REDUCE, 146);
   _actionMap[168][LOGSIZE] = ActionEntry(REDUCE, 146);
   _actionMap[168][LOGNUM] = ActionEntry(REDUCE, 146);
   _actionMap[168][APPSIZE] = ActionEntry(REDUCE, 146);
   _actionMap[168][SORTAREASIZE] = ActionEntry(REDUCE, 146);
   _actionMap[168][TSROOT] = ActionEntry(REDUCE, 146);
   _actionMap[168][BRANCHID] = ActionEntry(REDUCE, 146);
   _actionMap[168][SEMICOLON] = ActionEntry(REDUCE, 146);
   _jumpMap[168][AttrList] = 266;
   _actionMap[169][IDENTIFIER] = ActionEntry(SHIFT, 267);
   _actionMap[170][IDENTIFIER] = ActionEntry(SHIFT, 268);
   _actionMap[171][IDENTIFIER] = ActionEntry(SHIFT, 269);
   _actionMap[172][IDENTIFIER] = ActionEntry(SHIFT, 270);
   _actionMap[173][IDENTIFIER] = ActionEntry(SHIFT, 271);
   _actionMap[174][SEMICOLON] = ActionEntry(REDUCE, 56);
   _actionMap[175][SEMICOLON] = ActionEntry(REDUCE, 40);
   _actionMap[176][SEMICOLON] = ActionEntry(REDUCE, 49);
   _actionMap[177][FOR] = ActionEntry(SHIFT, 272);
}
void CegoAdm::loadParser9()
{
   _actionMap[178][FOR] = ActionEntry(SHIFT, 273);
   _actionMap[179][IDENTIFIER] = ActionEntry(SHIFT, 274);
   _actionMap[180][IDENTIFIER] = ActionEntry(SHIFT, 275);
   _actionMap[181][IDENTIFIER] = ActionEntry(SHIFT, 276);
   _actionMap[182][IDENTIFIER] = ActionEntry(SHIFT, 277);
   _actionMap[183][IDENTIFIER] = ActionEntry(SHIFT, 278);
   _actionMap[184][IDENTIFIER] = ActionEntry(SHIFT, 279);
   _actionMap[185][IDENTIFIER] = ActionEntry(SHIFT, 280);
   _actionMap[186][IDENTIFIER] = ActionEntry(SHIFT, 282);
   _actionMap[186][STRUCTURE] = ActionEntry(SHIFT, 281);
   _actionMap[187][IDENTIFIER] = ActionEntry(SHIFT, 283);
   _actionMap[188][IDENTIFIER] = ActionEntry(SHIFT, 285);
   _actionMap[188][STRUCTURE] = ActionEntry(SHIFT, 284);
   _actionMap[189][IDENTIFIER] = ActionEntry(SHIFT, 286);
   _actionMap[190][IDENTIFIER] = ActionEntry(SHIFT, 287);
   _actionMap[191][IDENTIFIER] = ActionEntry(SHIFT, 288);
   _actionMap[192][IDENTIFIER] = ActionEntry(SHIFT, 289);
   _actionMap[193][IDENTIFIER] = ActionEntry(SHIFT, 290);
   _actionMap[194][IDENTIFIER] = ActionEntry(SHIFT, 291);
   _actionMap[195][IDENTIFIER] = ActionEntry(SHIFT, 292);
   _actionMap[196][IDENTIFIER] = ActionEntry(SHIFT, 293);
   _actionMap[197][IDENTIFIER] = ActionEntry(SHIFT, 294);
   _actionMap[198][IDENTIFIER] = ActionEntry(SHIFT, 295);
   _actionMap[199][SEMICOLON] = ActionEntry(REDUCE, 7);
   _actionMap[200][IDENTIFIED] = ActionEntry(SHIFT, 296);
   _actionMap[201][SEMICOLON] = ActionEntry(REDUCE, 23);
   _actionMap[202][SEMICOLON] = ActionEntry(REDUCE, 22);
   _actionMap[203][SEMICOLON] = ActionEntry(REDUCE, 21);
   _actionMap[204][IDENTIFIER] = ActionEntry(SHIFT, 297);
   _actionMap[205][IDENTIFIER] = ActionEntry(SHIFT, 298);
   _actionMap[206][FROM] = ActionEntry(SHIFT, 299);
   _actionMap[207][FROM] = ActionEntry(SHIFT, 300);
   _actionMap[208][FROM] = ActionEntry(SHIFT, 301);
   _actionMap[209][SEMICOLON] = ActionEntry(REDUCE, 41);
   _actionMap[210][TO] = ActionEntry(SHIFT, 303);
   _actionMap[210][SEMICOLON] = ActionEntry(REDUCE, 158);
   _jumpMap[210][PitOption] = 302;
   _actionMap[211][IDENTIFIER] = ActionEntry(SHIFT, 304);
   _actionMap[212][SEMICOLON] = ActionEntry(REDUCE, 42);
   _actionMap[213][FROM] = ActionEntry(SHIFT, 305);
   _actionMap[214][STRINGVAL] = ActionEntry(SHIFT, 306);
   _actionMap[215][FOR] = ActionEntry(SHIFT, 307);
   _actionMap[216][SEMICOLON] = ActionEntry(REDUCE, 78);
   _actionMap[217][FOR] = ActionEntry(SHIFT, 308);
   _actionMap[218][FOR] = ActionEntry(SHIFT, 309);
   _actionMap[219][TIMEOUT] = ActionEntry(SHIFT, 311);
   _actionMap[219][SEMICOLON] = ActionEntry(REDUCE, 132);
   _jumpMap[219][TimeoutOpt] = 310;
   _actionMap[220][FOR] = ActionEntry(SHIFT, 312);
   _actionMap[221][FOR] = ActionEntry(SHIFT, 313);
}
void CegoAdm::loadParser10()
{
   _actionMap[222][FOR] = ActionEntry(SHIFT, 314);
   _actionMap[223][WITH] = ActionEntry(SHIFT, 315);
   _actionMap[224][FOR] = ActionEntry(SHIFT, 316);
   _actionMap[224][KSEP] = ActionEntry(SHIFT, 317);
   _actionMap[225][KSEP] = ActionEntry(REDUCE, 116);
   _actionMap[225][FOR] = ActionEntry(REDUCE, 116);
   _actionMap[226][EQU] = ActionEntry(SHIFT, 318);
   _actionMap[227][EQU] = ActionEntry(SHIFT, 319);
   _actionMap[228][EQU] = ActionEntry(SHIFT, 320);
   _actionMap[229][EQU] = ActionEntry(SHIFT, 321);
   _actionMap[230][INTVAL] = ActionEntry(SHIFT, 322);
   _actionMap[231][INTVAL] = ActionEntry(SHIFT, 323);
   _actionMap[232][FOR] = ActionEntry(SHIFT, 324);
   _actionMap[233][FOR] = ActionEntry(SHIFT, 325);
   _actionMap[234][FOR] = ActionEntry(SHIFT, 326);
   _actionMap[234][KSEP] = ActionEntry(SHIFT, 327);
   _actionMap[235][KSEP] = ActionEntry(REDUCE, 104);
   _actionMap[235][FOR] = ActionEntry(REDUCE, 104);
   _actionMap[236][EQU] = ActionEntry(SHIFT, 328);
   _actionMap[237][EQU] = ActionEntry(SHIFT, 329);
   _actionMap[238][EQU] = ActionEntry(SHIFT, 330);
   _actionMap[239][EQU] = ActionEntry(SHIFT, 331);
   _actionMap[240][FOR] = ActionEntry(SHIFT, 332);
   _actionMap[241][FOR] = ActionEntry(SHIFT, 333);
   _actionMap[242][IDENTIFIER] = ActionEntry(SHIFT, 334);
   _actionMap[243][IDENTIFIER] = ActionEntry(SHIFT, 335);
   _actionMap[244][SEMICOLON] = ActionEntry(REDUCE, 54);
   _actionMap[245][IDENTIFIER] = ActionEntry(SHIFT, 336);
   _actionMap[246][SEMICOLON] = ActionEntry(REDUCE, 3);
   _actionMap[247][CLEANUP] = ActionEntry(REDUCE, 136);
   _actionMap[247][FORCELOAD] = ActionEntry(REDUCE, 136);
   _actionMap[247][CPDUMP] = ActionEntry(REDUCE, 136);
   _actionMap[247][NOINIT] = ActionEntry(REDUCE, 136);
   _actionMap[247][SEMICOLON] = ActionEntry(REDUCE, 136);
   _jumpMap[247][StartOptList] = 337;
   _actionMap[248][SEMICOLON] = ActionEntry(REDUCE, 33);
   _actionMap[249][IDENTIFIER] = ActionEntry(SHIFT, 338);
   _actionMap[250][IDENTIFIER] = ActionEntry(SHIFT, 339);
   _actionMap[251][SEMICOLON] = ActionEntry(REDUCE, 35);
   _actionMap[252][WITH] = ActionEntry(SHIFT, 342);
   _actionMap[252][MESSAGE] = ActionEntry(REDUCE, 130);
   _actionMap[252][KEEP] = ActionEntry(REDUCE, 130);
   _actionMap[252][SEMICOLON] = ActionEntry(REDUCE, 130);
   _jumpMap[252][MsgOption] = 341;
   _jumpMap[252][SyncCmdOption] = 340;
   _actionMap[253][IDENTIFIER] = ActionEntry(SHIFT, 343);
   _actionMap[254][IDENTIFIER] = ActionEntry(SHIFT, 344);
   _actionMap[255][SEMICOLON] = ActionEntry(REDUCE, 45);
   _actionMap[43][ENDTOKEN] = ActionEntry(ACCEPT, 0);
   _actionMap[44][THREAD] = ActionEntry(SHIFT, 153);
}
void CegoAdm::loadParser11()
{
   _actionMap[45][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[46][IDENTIFIER] = ActionEntry(SHIFT, 155);
   _actionMap[47][DATAFILE] = ActionEntry(SHIFT, 156);
   _actionMap[48][IDENTIFIER] = ActionEntry(SHIFT, 157);
   _actionMap[49][IDENTIFIER] = ActionEntry(SHIFT, 158);
   _actionMap[50][FOR] = ActionEntry(SHIFT, 159);
   _actionMap[51][IDENTIFIER] = ActionEntry(SHIFT, 160);
   _actionMap[52][FOR] = ActionEntry(SHIFT, 161);
   _actionMap[53][FOR] = ActionEntry(SHIFT, 162);
   _actionMap[54][STRINGVAL] = ActionEntry(SHIFT, 163);
   _actionMap[55][IDENTIFIER] = ActionEntry(SHIFT, 164);
   _actionMap[56][IDENTIFIER] = ActionEntry(SHIFT, 165);
   _actionMap[57][IDENTIFIER] = ActionEntry(SHIFT, 166);
   _actionMap[58][IDENTIFIER] = ActionEntry(SHIFT, 167);
   _actionMap[59][IDENTIFIER] = ActionEntry(SHIFT, 168);
   _actionMap[60][FOR] = ActionEntry(SHIFT, 169);
   _actionMap[61][FOR] = ActionEntry(SHIFT, 170);
   _actionMap[62][FOR] = ActionEntry(SHIFT, 171);
   _actionMap[63][FOR] = ActionEntry(SHIFT, 172);
   _actionMap[64][FOR] = ActionEntry(SHIFT, 173);
   _actionMap[65][IDENTIFIER] = ActionEntry(SHIFT, 174);
   _actionMap[66][IDENTIFIER] = ActionEntry(SHIFT, 175);
   _actionMap[67][IDENTIFIER] = ActionEntry(SHIFT, 176);
   _actionMap[68][IDENTIFIER] = ActionEntry(SHIFT, 177);
   _actionMap[69][IDENTIFIER] = ActionEntry(SHIFT, 178);
   _actionMap[70][FOR] = ActionEntry(SHIFT, 179);
   _actionMap[71][FOR] = ActionEntry(SHIFT, 180);
   _actionMap[72][FOR] = ActionEntry(SHIFT, 181);
   _actionMap[73][FOR] = ActionEntry(SHIFT, 182);
   _actionMap[74][FOR] = ActionEntry(SHIFT, 183);
   _actionMap[75][FOR] = ActionEntry(SHIFT, 184);
   _actionMap[76][TABLESET] = ActionEntry(SHIFT, 186);
   _actionMap[76][TABLE] = ActionEntry(SHIFT, 185);
   _actionMap[77][TABLESET] = ActionEntry(REDUCE, 142);
   _actionMap[77][TABLE] = ActionEntry(REDUCE, 142);
   _actionMap[78][TABLESET] = ActionEntry(REDUCE, 143);
   _actionMap[78][TABLE] = ActionEntry(REDUCE, 143);
   _actionMap[79][TABLESET] = ActionEntry(REDUCE, 141);
   _actionMap[79][TABLE] = ActionEntry(REDUCE, 141);
   _actionMap[80][TABLESET] = ActionEntry(SHIFT, 188);
   _actionMap[80][TABLE] = ActionEntry(SHIFT, 187);
   _actionMap[81][FOR] = ActionEntry(SHIFT, 189);
   _actionMap[82][FOR] = ActionEntry(SHIFT, 190);
   _actionMap[83][FOR] = ActionEntry(SHIFT, 191);
   _actionMap[84][FOR] = ActionEntry(SHIFT, 192);
   _actionMap[85][SEMICOLON] = ActionEntry(REDUCE, 26);
   _actionMap[86][FOR] = ActionEntry(SHIFT, 193);
   _actionMap[87][FOR] = ActionEntry(SHIFT, 194);
   _actionMap[88][SEMICOLON] = ActionEntry(REDUCE, 13);
   _actionMap[89][FOR] = ActionEntry(SHIFT, 195);
}
void CegoAdm::loadParser12()
{
   _actionMap[90][SEMICOLON] = ActionEntry(REDUCE, 4);
   _actionMap[91][FOR] = ActionEntry(SHIFT, 196);
   _actionMap[92][SEMICOLON] = ActionEntry(REDUCE, 53);
   _actionMap[93][SEMICOLON] = ActionEntry(REDUCE, 14);
   _actionMap[94][FOR] = ActionEntry(SHIFT, 197);
   _actionMap[95][SEMICOLON] = ActionEntry(REDUCE, 8);
   _actionMap[96][FOR] = ActionEntry(SHIFT, 198);
   _actionMap[97][SEMICOLON] = ActionEntry(REDUCE, 48);
   _actionMap[98][LOCK] = ActionEntry(SHIFT, 199);
   _actionMap[99][IDENTIFIER] = ActionEntry(SHIFT, 200);
   _actionMap[100][INTVAL] = ActionEntry(SHIFT, 201);
   _actionMap[101][INTVAL] = ActionEntry(SHIFT, 202);
   _actionMap[102][INTVAL] = ActionEntry(SHIFT, 203);
   _actionMap[103][SEMICOLON] = ActionEntry(REDUCE, 6);
   _actionMap[104][SEMICOLON] = ActionEntry(REDUCE, 5);
   _actionMap[105][FOR] = ActionEntry(SHIFT, 204);
   _actionMap[106][FOR] = ActionEntry(SHIFT, 205);
   _actionMap[107][IDENTIFIER] = ActionEntry(SHIFT, 206);
   _actionMap[108][IDENTIFIER] = ActionEntry(SHIFT, 207);
   _actionMap[109][IDENTIFIER] = ActionEntry(SHIFT, 208);
   _actionMap[110][IDENTIFIER] = ActionEntry(SHIFT, 209);
   _actionMap[111][IDENTIFIER] = ActionEntry(SHIFT, 210);
   _actionMap[112][FOR] = ActionEntry(SHIFT, 211);
   _actionMap[113][IDENTIFIER] = ActionEntry(SHIFT, 212);
   _actionMap[114][IDENTIFIER] = ActionEntry(SHIFT, 213);
   _actionMap[115][FROM] = ActionEntry(SHIFT, 214);
   _actionMap[116][INTVAL] = ActionEntry(SHIFT, 215);
   _actionMap[117][STRINGVAL] = ActionEntry(SHIFT, 216);
   _actionMap[118][INTVAL] = ActionEntry(SHIFT, 217);
   _actionMap[119][STRINGVAL] = ActionEntry(SHIFT, 218);
   _actionMap[120][STRINGVAL] = ActionEntry(SHIFT, 219);
   _actionMap[121][INTVAL] = ActionEntry(SHIFT, 220);
   _actionMap[122][INTVAL] = ActionEntry(SHIFT, 221);
   _actionMap[123][IDENTIFIER] = ActionEntry(SHIFT, 222);
   _actionMap[124][IDENTIFIER] = ActionEntry(SHIFT, 223);
   _actionMap[125][MAXENTRY] = ActionEntry(SHIFT, 226);
   _actionMap[125][MAXSIZE] = ActionEntry(SHIFT, 228);
   _actionMap[125][HASHRANGE] = ActionEntry(SHIFT, 227);
   _actionMap[125][THRESHOLD] = ActionEntry(SHIFT, 229);
   _jumpMap[125][QueryCacheParam] = 225;
   _jumpMap[125][QueryCacheParamList] = 224;
   _actionMap[126][COST] = ActionEntry(SHIFT, 230);
   _actionMap[126][LAST] = ActionEntry(SHIFT, 231);
   _actionMap[127][INTVAL] = ActionEntry(SHIFT, 232);
   _actionMap[128][INTVAL] = ActionEntry(SHIFT, 233);
   _actionMap[129][FILTER] = ActionEntry(SHIFT, 237);
   _actionMap[129][MAXSIZE] = ActionEntry(SHIFT, 239);
   _actionMap[129][MAXENTRY] = ActionEntry(SHIFT, 236);
   _actionMap[129][HASHRANGE] = ActionEntry(SHIFT, 238);
   _jumpMap[129][TableCacheParam] = 235;
}
void CegoAdm::loadParser13()
{
   _jumpMap[129][TableCacheParamList] = 234;
   _actionMap[130][INTVAL] = ActionEntry(SHIFT, 240);
   _actionMap[131][STRINGVAL] = ActionEntry(SHIFT, 241);
   _actionMap[132][IDENTIFIER] = ActionEntry(SHIFT, 242);
   _actionMap[133][SEMICOLON] = ActionEntry(REDUCE, 80);
   _actionMap[134][SEMICOLON] = ActionEntry(REDUCE, 79);
   _actionMap[135][SEMICOLON] = ActionEntry(REDUCE, 2);
   _actionMap[136][SEMICOLON] = ActionEntry(REDUCE, 1);
   _actionMap[137][FOR] = ActionEntry(SHIFT, 243);
   _actionMap[138][IDENTIFIER] = ActionEntry(SHIFT, 244);
   _actionMap[139][FOR] = ActionEntry(SHIFT, 245);
   _actionMap[140][IDENTIFIER] = ActionEntry(SHIFT, 246);
   _actionMap[141][IDENTIFIER] = ActionEntry(SHIFT, 247);
   _actionMap[142][IDENTIFIER] = ActionEntry(SHIFT, 248);
   _actionMap[143][FOR] = ActionEntry(SHIFT, 249);
   _actionMap[144][FOR] = ActionEntry(SHIFT, 250);
   _actionMap[145][IDENTIFIER] = ActionEntry(SHIFT, 251);
   _actionMap[146][IDENTIFIER] = ActionEntry(SHIFT, 252);
   _actionMap[147][SEMICOLON] = ActionEntry(REDUCE, 24);
   _actionMap[148][SEMICOLON] = ActionEntry(REDUCE, 20);
   _actionMap[149][SEMICOLON] = ActionEntry(REDUCE, 25);
   _actionMap[150][USER] = ActionEntry(SHIFT, 253);
   _actionMap[151][USER] = ActionEntry(SHIFT, 254);
   _actionMap[152][IDENTIFIER] = ActionEntry(SHIFT, 255);
   _actionMap[1][SEMICOLON] = ActionEntry(SHIFT, 43);
   _actionMap[2][DB] = ActionEntry(SHIFT, 44);
   _actionMap[3][IDENTIFIER] = ActionEntry(SHIFT, 47);
   _actionMap[3][USER] = ActionEntry(SHIFT, 46);
   _actionMap[3][ARCHLOG] = ActionEntry(SHIFT, 45);
   _actionMap[4][ROLE] = ActionEntry(SHIFT, 48);
   _actionMap[5][TABLESET] = ActionEntry(SHIFT, 49);
   _actionMap[6][BACKUP] = ActionEntry(SHIFT, 50);
   _actionMap[7][TABLESET] = ActionEntry(SHIFT, 51);
   _actionMap[8][TABLECACHE] = ActionEntry(SHIFT, 53);
   _actionMap[8][QUERYCACHE] = ActionEntry(SHIFT, 52);
   _actionMap[9][TABLESET] = ActionEntry(SHIFT, 55);
   _actionMap[9][FILE] = ActionEntry(SHIFT, 54);
   _actionMap[10][TABLESET] = ActionEntry(SHIFT, 56);
   _actionMap[11][TABLESET] = ActionEntry(SHIFT, 58);
   _actionMap[11][ROLE] = ActionEntry(SHIFT, 57);
   _actionMap[12][TABLESET] = ActionEntry(SHIFT, 59);
   _actionMap[13][ARCHLOG] = ActionEntry(SHIFT, 61);
   _actionMap[13][APPENDMODE] = ActionEntry(SHIFT, 60);
   _actionMap[13][AUTOCORRECT] = ActionEntry(SHIFT, 62);
   _actionMap[13][TABLECACHE] = ActionEntry(SHIFT, 64);
   _actionMap[13][QUERYCACHE] = ActionEntry(SHIFT, 63);
   _actionMap[14][TABLESET] = ActionEntry(SHIFT, 66);
   _actionMap[14][USER] = ActionEntry(SHIFT, 67);
   _actionMap[14][ROLE] = ActionEntry(SHIFT, 65);
   _actionMap[15][TABLE] = ActionEntry(SHIFT, 69);
}
void CegoAdm::loadParser14()
{
   _actionMap[15][UINDEX] = ActionEntry(SHIFT, 68);
   _actionMap[16][ARCHLOG] = ActionEntry(SHIFT, 71);
   _actionMap[16][APPENDMODE] = ActionEntry(SHIFT, 70);
   _actionMap[16][AUTOCORRECT] = ActionEntry(SHIFT, 72);
   _actionMap[16][TABLECACHE] = ActionEntry(SHIFT, 74);
   _actionMap[16][QUERYCACHE] = ActionEntry(SHIFT, 73);
   _actionMap[17][BACKUP] = ActionEntry(SHIFT, 75);
   _actionMap[18][XML] = ActionEntry(SHIFT, 79);
   _actionMap[18][BINARY] = ActionEntry(SHIFT, 77);
   _actionMap[18][PLAIN] = ActionEntry(SHIFT, 78);
   _actionMap[18][TABLE] = ActionEntry(REDUCE, 144);
   _actionMap[18][TABLESET] = ActionEntry(REDUCE, 144);
   _jumpMap[18][XPMode] = 76;
   _actionMap[19][SEMICOLON] = ActionEntry(REDUCE, 159);
   _actionMap[20][SEMICOLON] = ActionEntry(REDUCE, 160);
   _actionMap[21][XML] = ActionEntry(SHIFT, 79);
   _actionMap[21][BINARY] = ActionEntry(SHIFT, 77);
   _actionMap[21][PLAIN] = ActionEntry(SHIFT, 78);
   _actionMap[21][TABLE] = ActionEntry(REDUCE, 144);
   _actionMap[21][TABLESET] = ActionEntry(REDUCE, 144);
   _jumpMap[21][XPMode] = 80;
   _actionMap[22][POOL] = ActionEntry(SHIFT, 90);
   _actionMap[22][IDENTIFIER] = ActionEntry(SHIFT, 98);
   _actionMap[22][TABLESET] = ActionEntry(SHIFT, 95);
   _actionMap[22][DATAFILE] = ActionEntry(SHIFT, 86);
   _actionMap[22][ARCHLOG] = ActionEntry(SHIFT, 81);
   _actionMap[22][LOGFILE] = ActionEntry(SHIFT, 87);
   _actionMap[22][OBJECT] = ActionEntry(SHIFT, 89);
   _actionMap[22][NODE] = ActionEntry(SHIFT, 88);
   _actionMap[22][SESSION] = ActionEntry(SHIFT, 93);
   _actionMap[22][BUFILE] = ActionEntry(SHIFT, 83);
   _actionMap[22][BUSTAT] = ActionEntry(SHIFT, 84);
   _actionMap[22][COPY] = ActionEntry(SHIFT, 85);
   _actionMap[22][TRANSACTION] = ActionEntry(SHIFT, 96);
   _actionMap[22][USER] = ActionEntry(SHIFT, 97);
   _actionMap[22][ROLE] = ActionEntry(SHIFT, 92);
   _actionMap[22][BACKUP] = ActionEntry(SHIFT, 82);
   _actionMap[22][TABLECACHE] = ActionEntry(SHIFT, 94);
   _actionMap[22][QUERYCACHE] = ActionEntry(SHIFT, 91);
   _actionMap[23][SEMICOLON] = ActionEntry(REDUCE, 19);
   _actionMap[24][USER] = ActionEntry(SHIFT, 99);
   _actionMap[25][THREAD] = ActionEntry(SHIFT, 102);
   _actionMap[25][LAST] = ActionEntry(SHIFT, 101);
   _actionMap[25][COST] = ActionEntry(SHIFT, 100);
   _actionMap[26][ON] = ActionEntry(SHIFT, 104);
   _actionMap[26][OFF] = ActionEntry(SHIFT, 103);
   _actionMap[27][SECONDARY] = ActionEntry(SHIFT, 106);
   _actionMap[27][MEDIATOR] = ActionEntry(SHIFT, 105);
   _actionMap[28][TABLESET] = ActionEntry(SHIFT, 110);
   _actionMap[28][ROLE] = ActionEntry(SHIFT, 109);
}
void CegoAdm::loadParser15()
{
   _actionMap[28][PERMISSION] = ActionEntry(SHIFT, 108);
   _actionMap[28][ARCHLOG] = ActionEntry(SHIFT, 107);
   _actionMap[29][TABLESET] = ActionEntry(SHIFT, 111);
   _actionMap[30][BUSTAT] = ActionEntry(SHIFT, 112);
   _actionMap[30][TABLESET] = ActionEntry(SHIFT, 113);
   _actionMap[31][TABLESET] = ActionEntry(SHIFT, 114);
   _actionMap[32][TABLESET] = ActionEntry(SHIFT, 115);
   _actionMap[33][PERMISSION] = ActionEntry(SHIFT, 124);
   _actionMap[33][LOGMNG] = ActionEntry(SHIFT, 120);
   _actionMap[33][BACKUPMNG] = ActionEntry(SHIFT, 117);
   _actionMap[33][INITFILE] = ActionEntry(SHIFT, 119);
   _actionMap[33][CHECKPOINT] = ActionEntry(SHIFT, 118);
   _actionMap[33][SYSSIZE] = ActionEntry(SHIFT, 128);
   _actionMap[33][TMPSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[33][APPSIZE] = ActionEntry(SHIFT, 116);
   _actionMap[33][TSROOT] = ActionEntry(SHIFT, 131);
   _actionMap[33][LOGNUM] = ActionEntry(SHIFT, 121);
   _actionMap[33][LOGSIZE] = ActionEntry(SHIFT, 122);
   _actionMap[33][SORTAREASIZE] = ActionEntry(SHIFT, 127);
   _actionMap[33][LOGUSER] = ActionEntry(SHIFT, 123);
   _actionMap[33][QUERYHIST] = ActionEntry(SHIFT, 126);
   _actionMap[33][TABLECACHE] = ActionEntry(SHIFT, 129);
   _actionMap[33][QUERYCACHE] = ActionEntry(SHIFT, 125);
   _actionMap[34][IDENTIFIER] = ActionEntry(SHIFT, 132);
   _actionMap[35][POOL] = ActionEntry(SHIFT, 136);
   _actionMap[35][PARAMETER] = ActionEntry(SHIFT, 135);
   _actionMap[35][TABLESET] = ActionEntry(SHIFT, 140);
   _actionMap[35][ROLE] = ActionEntry(SHIFT, 138);
   _actionMap[35][LOGMNG] = ActionEntry(SHIFT, 134);
   _actionMap[35][BACKUPMNG] = ActionEntry(SHIFT, 133);
   _actionMap[35][TABLECACHE] = ActionEntry(SHIFT, 139);
   _actionMap[35][QUERYCACHE] = ActionEntry(SHIFT, 137);
   _actionMap[36][TABLESET] = ActionEntry(SHIFT, 141);
   _actionMap[37][TABLESET] = ActionEntry(SHIFT, 142);
   _actionMap[38][TABLESET] = ActionEntry(SHIFT, 145);
   _actionMap[38][SECONDARY] = ActionEntry(SHIFT, 144);
   _actionMap[38][MEDIATOR] = ActionEntry(SHIFT, 143);
   _actionMap[39][TABLESET] = ActionEntry(SHIFT, 146);
   _actionMap[40][SEMICOLON] = ActionEntry(REDUCE, 18);
   _actionMap[40][DB] = ActionEntry(SHIFT, 148);
   _actionMap[40][ADM] = ActionEntry(SHIFT, 147);
   _actionMap[40][LOG] = ActionEntry(SHIFT, 149);
   _actionMap[41][ON] = ActionEntry(SHIFT, 151);
   _actionMap[41][OFF] = ActionEntry(SHIFT, 150);
   _actionMap[42][TABLESET] = ActionEntry(SHIFT, 152);
   _actionMap[0][SHOW] = ActionEntry(SHIFT, 35);
   _actionMap[0][LIST] = ActionEntry(SHIFT, 22);
   _actionMap[0][RAWMODE] = ActionEntry(SHIFT, 26);
   _actionMap[0][RESET] = ActionEntry(SHIFT, 30);
   _actionMap[0][THREADINFO] = ActionEntry(SHIFT, 40);
}
void CegoAdm::loadParser16()
{
   _actionMap[0][LOCKSTAT] = ActionEntry(SHIFT, 23);
   _actionMap[0][QUERYHIST] = ActionEntry(SHIFT, 25);
   _actionMap[0][ABORT] = ActionEntry(SHIFT, 2);
   _actionMap[0][RETRIEVE] = ActionEntry(SHIFT, 32);
   _actionMap[0][DEFINE] = ActionEntry(SHIFT, 12);
   _actionMap[0][CREATE] = ActionEntry(SHIFT, 11);
   _actionMap[0][START_TOK] = ActionEntry(SHIFT, 36);
   _actionMap[0][STOP_TOK] = ActionEntry(SHIFT, 37);
   _actionMap[0][COPY] = ActionEntry(SHIFT, 9);
   _actionMap[0][SWITCH] = ActionEntry(SHIFT, 38);
   _actionMap[0][RELOCATE] = ActionEntry(SHIFT, 27);
   _actionMap[0][DROP] = ActionEntry(SHIFT, 14);
   _actionMap[0][REMOVE] = ActionEntry(SHIFT, 28);
   _actionMap[0][ADD] = ActionEntry(SHIFT, 3);
   _actionMap[0][CHECK] = ActionEntry(SHIFT, 7);
   _actionMap[0][VERIFY] = ActionEntry(SHIFT, 42);
   _actionMap[0][CORRECT] = ActionEntry(SHIFT, 10);
   _actionMap[0][PASSWD] = ActionEntry(SHIFT, 24);
   _actionMap[0][ASSIGN] = ActionEntry(SHIFT, 4);
   _actionMap[0][SET] = ActionEntry(SHIFT, 33);
   _actionMap[0][TRACE] = ActionEntry(SHIFT, 41);
   _actionMap[0][ENABLE] = ActionEntry(SHIFT, 16);
   _actionMap[0][DISABLE] = ActionEntry(SHIFT, 13);
   _actionMap[0][BEGIN_TOKEN] = ActionEntry(SHIFT, 6);
   _actionMap[0][BACKUP] = ActionEntry(SHIFT, 5);
   _actionMap[0][END_TOKEN] = ActionEntry(SHIFT, 17);
   _actionMap[0][SYNC] = ActionEntry(SHIFT, 39);
   _actionMap[0][RESTORE] = ActionEntry(SHIFT, 31);
   _actionMap[0][RECOVER] = ActionEntry(SHIFT, 29);
   _actionMap[0][CLEAN] = ActionEntry(SHIFT, 8);
   _actionMap[0][EXPORT] = ActionEntry(SHIFT, 18);
   _actionMap[0][IMPORT] = ActionEntry(SHIFT, 21);
   _actionMap[0][GETDBSPEC] = ActionEntry(SHIFT, 19);
   _actionMap[0][GETDBINFO] = ActionEntry(SHIFT, 20);
   _actionMap[0][SETTSNODEINFO] = ActionEntry(SHIFT, 34);
   _actionMap[0][DUMP] = ActionEntry(SHIFT, 15);
   _jumpMap[0][Statement] = 1;
}
void CegoAdm::loadParser17()
{
   _prodInfo.Insert(ProdEntry(164, Statement, 5));
   _prodInfo.Insert(ProdEntry(163, Statement, 5));
   _prodInfo.Insert(ProdEntry(162, Statement, 3));
   _prodInfo.Insert(ProdEntry(161, Statement, 5));
   _prodInfo.Insert(ProdEntry(160, Statement, 1));
   _prodInfo.Insert(ProdEntry(159, Statement, 1));
   _prodInfo.Insert(ProdEntry(158, PitOption, 0));
   _prodInfo.Insert(ProdEntry(157, PitOption, 2));
   _prodInfo.Insert(ProdEntry(156, Attr, 3));
   _prodInfo.Insert(ProdEntry(155, Attr, 3));
   _prodInfo.Insert(ProdEntry(154, Attr, 3));
   _prodInfo.Insert(ProdEntry(153, Attr, 3));
   _prodInfo.Insert(ProdEntry(152, Attr, 3));
   _prodInfo.Insert(ProdEntry(151, Attr, 3));
   _prodInfo.Insert(ProdEntry(150, Attr, 3));
   _prodInfo.Insert(ProdEntry(149, Attr, 3));
   _prodInfo.Insert(ProdEntry(148, Attr, 3));
   _prodInfo.Insert(ProdEntry(147, Attr, 3));
   _prodInfo.Insert(ProdEntry(146, AttrList, 0));
   _prodInfo.Insert(ProdEntry(145, AttrList, 2));
   _prodInfo.Insert(ProdEntry(144, XPMode, 0));
   _prodInfo.Insert(ProdEntry(143, XPMode, 1));
   _prodInfo.Insert(ProdEntry(142, XPMode, 1));
   _prodInfo.Insert(ProdEntry(141, XPMode, 1));
   _prodInfo.Insert(ProdEntry(140, StartOpt, 1));
   _prodInfo.Insert(ProdEntry(139, StartOpt, 1));
   _prodInfo.Insert(ProdEntry(138, StartOpt, 1));
   _prodInfo.Insert(ProdEntry(137, StartOpt, 1));
   _prodInfo.Insert(ProdEntry(136, StartOptList, 0));
   _prodInfo.Insert(ProdEntry(135, StartOptList, 2));
   _prodInfo.Insert(ProdEntry(134, MsgOption, 0));
   _prodInfo.Insert(ProdEntry(133, MsgOption, 2));
   _prodInfo.Insert(ProdEntry(132, TimeoutOpt, 0));
   _prodInfo.Insert(ProdEntry(131, TimeoutOpt, 2));
   _prodInfo.Insert(ProdEntry(130, SyncCmdOption, 0));
   _prodInfo.Insert(ProdEntry(129, SyncCmdOption, 3));
   _prodInfo.Insert(ProdEntry(128, KeepTicketOpt, 0));
   _prodInfo.Insert(ProdEntry(127, KeepTicketOpt, 2));
   _prodInfo.Insert(ProdEntry(126, Statement, 7));
   _prodInfo.Insert(ProdEntry(125, Statement, 6));
   _prodInfo.Insert(ProdEntry(124, Statement, 8));
   _prodInfo.Insert(ProdEntry(123, Statement, 7));
   _prodInfo.Insert(ProdEntry(122, Statement, 6));
   _prodInfo.Insert(ProdEntry(121, Statement, 8));
   _prodInfo.Insert(ProdEntry(120, QueryCacheParam, 3));
   _prodInfo.Insert(ProdEntry(119, QueryCacheParam, 3));
   _prodInfo.Insert(ProdEntry(118, QueryCacheParam, 3));
   _prodInfo.Insert(ProdEntry(117, QueryCacheParam, 3));
   _prodInfo.Insert(ProdEntry(116, QueryCacheParamList, 1));
   _prodInfo.Insert(ProdEntry(115, QueryCacheParamList, 3));
   _prodInfo.Insert(ProdEntry(114, Statement, 5));
   _prodInfo.Insert(ProdEntry(113, Statement, 4));
   _prodInfo.Insert(ProdEntry(112, Statement, 4));
   _prodInfo.Insert(ProdEntry(111, Statement, 4));
   _prodInfo.Insert(ProdEntry(110, Statement, 4));
   _prodInfo.Insert(ProdEntry(109, Statement, 4));
   _prodInfo.Insert(ProdEntry(108, TableCacheParam, 3));
   _prodInfo.Insert(ProdEntry(107, TableCacheParam, 3));
   _prodInfo.Insert(ProdEntry(106, TableCacheParam, 3));
   _prodInfo.Insert(ProdEntry(105, TableCacheParam, 3));
   _prodInfo.Insert(ProdEntry(104, TableCacheParamList, 1));
   _prodInfo.Insert(ProdEntry(103, TableCacheParamList, 3));
   _prodInfo.Insert(ProdEntry(102, Statement, 5));
   _prodInfo.Insert(ProdEntry(101, Statement, 4));
   _prodInfo.Insert(ProdEntry(100, Statement, 4));
   _prodInfo.Insert(ProdEntry(99, Statement, 4));
   _prodInfo.Insert(ProdEntry(98, Statement, 4));
   _prodInfo.Insert(ProdEntry(97, Statement, 4));
   _prodInfo.Insert(ProdEntry(96, Statement, 4));
   _prodInfo.Insert(ProdEntry(95, Statement, 4));
   _prodInfo.Insert(ProdEntry(94, Statement, 4));
   _prodInfo.Insert(ProdEntry(93, Statement, 4));
   _prodInfo.Insert(ProdEntry(92, Statement, 4));
   _prodInfo.Insert(ProdEntry(91, Statement, 4));
   _prodInfo.Insert(ProdEntry(90, Statement, 5));
   _prodInfo.Insert(ProdEntry(89, Statement, 5));
   _prodInfo.Insert(ProdEntry(88, Statement, 5));
   _prodInfo.Insert(ProdEntry(87, Statement, 5));
   _prodInfo.Insert(ProdEntry(86, Statement, 5));
   _prodInfo.Insert(ProdEntry(85, Statement, 5));
   _prodInfo.Insert(ProdEntry(84, Statement, 5));
   _prodInfo.Insert(ProdEntry(83, Statement, 5));
   _prodInfo.Insert(ProdEntry(82, Statement, 5));
   _prodInfo.Insert(ProdEntry(81, Statement, 5));
   _prodInfo.Insert(ProdEntry(80, Statement, 2));
   _prodInfo.Insert(ProdEntry(79, Statement, 2));
   _prodInfo.Insert(ProdEntry(78, Statement, 3));
   _prodInfo.Insert(ProdEntry(77, Statement, 4));
   _prodInfo.Insert(ProdEntry(76, Statement, 4));
   _prodInfo.Insert(ProdEntry(75, Statement, 5));
   _prodInfo.Insert(ProdEntry(74, Statement, 5));
   _prodInfo.Insert(ProdEntry(73, Statement, 5));
   _prodInfo.Insert(ProdEntry(72, Statement, 6));
   _prodInfo.Insert(ProdEntry(71, Statement, 4));
   _prodInfo.Insert(ProdEntry(70, Statement, 5));
   _prodInfo.Insert(ProdEntry(69, Statement, 5));
   _prodInfo.Insert(ProdEntry(68, Statement, 7));
   _prodInfo.Insert(ProdEntry(67, Statement, 4));
   _prodInfo.Insert(ProdEntry(66, Statement, 4));
   _prodInfo.Insert(ProdEntry(65, Statement, 4));
   _prodInfo.Insert(ProdEntry(64, Statement, 4));
   _prodInfo.Insert(ProdEntry(63, Statement, 5));
   _prodInfo.Insert(ProdEntry(62, PermEntry, 3));
   _prodInfo.Insert(ProdEntry(61, PermEntry, 3));
   _prodInfo.Insert(ProdEntry(60, PermEntry, 3));
   _prodInfo.Insert(ProdEntry(59, PermList, 1));
   _prodInfo.Insert(ProdEntry(58, PermList, 3));
   _prodInfo.Insert(ProdEntry(57, Statement, 7));
   _prodInfo.Insert(ProdEntry(56, Statement, 3));
   _prodInfo.Insert(ProdEntry(55, Statement, 3));
   _prodInfo.Insert(ProdEntry(54, Statement, 3));
   _prodInfo.Insert(ProdEntry(53, Statement, 2));
   _prodInfo.Insert(ProdEntry(52, Statement, 5));
   _prodInfo.Insert(ProdEntry(51, Statement, 5));
   _prodInfo.Insert(ProdEntry(50, Statement, 6));
   _prodInfo.Insert(ProdEntry(49, Statement, 3));
   _prodInfo.Insert(ProdEntry(48, Statement, 2));
   _prodInfo.Insert(ProdEntry(47, Statement, 6));
   _prodInfo.Insert(ProdEntry(46, Statement, 3));
   _prodInfo.Insert(ProdEntry(45, Statement, 3));
   _prodInfo.Insert(ProdEntry(44, Statement, 3));
   _prodInfo.Insert(ProdEntry(43, Statement, 8));
   _prodInfo.Insert(ProdEntry(42, Statement, 3));
   _prodInfo.Insert(ProdEntry(41, Statement, 3));
   _prodInfo.Insert(ProdEntry(40, Statement, 3));
   _prodInfo.Insert(ProdEntry(39, Statement, 6));
   _prodInfo.Insert(ProdEntry(38, Statement, 6));
   _prodInfo.Insert(ProdEntry(37, Statement, 4));
   _prodInfo.Insert(ProdEntry(36, Statement, 4));
   _prodInfo.Insert(ProdEntry(35, Statement, 3));
   _prodInfo.Insert(ProdEntry(34, Statement, 3));
   _prodInfo.Insert(ProdEntry(33, Statement, 3));
   _prodInfo.Insert(ProdEntry(32, Statement, 4));
   _prodInfo.Insert(ProdEntry(31, Statement, 3));
   _prodInfo.Insert(ProdEntry(30, Statement, 4));
   _prodInfo.Insert(ProdEntry(29, Statement, 4));
   _prodInfo.Insert(ProdEntry(28, Statement, 4));
   _prodInfo.Insert(ProdEntry(27, Statement, 4));
   _prodInfo.Insert(ProdEntry(26, Statement, 2));
   _prodInfo.Insert(ProdEntry(25, Statement, 2));
   _prodInfo.Insert(ProdEntry(24, Statement, 2));
   _prodInfo.Insert(ProdEntry(23, Statement, 3));
   _prodInfo.Insert(ProdEntry(22, Statement, 3));
   _prodInfo.Insert(ProdEntry(21, Statement, 3));
   _prodInfo.Insert(ProdEntry(20, Statement, 2));
   _prodInfo.Insert(ProdEntry(19, Statement, 1));
   _prodInfo.Insert(ProdEntry(18, Statement, 1));
   _prodInfo.Insert(ProdEntry(17, Statement, 4));
   _prodInfo.Insert(ProdEntry(16, Statement, 4));
   _prodInfo.Insert(ProdEntry(15, Statement, 4));
   _prodInfo.Insert(ProdEntry(14, Statement, 2));
   _prodInfo.Insert(ProdEntry(13, Statement, 2));
   _prodInfo.Insert(ProdEntry(12, Statement, 4));
   _prodInfo.Insert(ProdEntry(11, Statement, 4));
   _prodInfo.Insert(ProdEntry(10, Statement, 4));
   _prodInfo.Insert(ProdEntry(9, Statement, 4));
   _prodInfo.Insert(ProdEntry(8, Statement, 2));
   _prodInfo.Insert(ProdEntry(7, Statement, 3));
   _prodInfo.Insert(ProdEntry(6, Statement, 2));
   _prodInfo.Insert(ProdEntry(5, Statement, 2));
   _prodInfo.Insert(ProdEntry(4, Statement, 2));
   _prodInfo.Insert(ProdEntry(3, Statement, 3));
   _prodInfo.Insert(ProdEntry(2, Statement, 2));
   _prodInfo.Insert(ProdEntry(1, Statement, 2));
   _prodInfo.Insert(ProdEntry(0, Start, 2));
}

CegoAdm::CegoAdm()
{
   loadScanner();
   for ( int i=0; i < 470; i++)
   {
      int j;
      for ( j = 0; j < 126; j++)
         _actionMap[i][j] = ActionEntry();
      for ( j = 0; j < 19; j++)
         _jumpMap[i][j] = -1;
   }
   loadParser0();
   loadParser1();
   loadParser2();
   loadParser3();
   loadParser4();
   loadParser5();
   loadParser6();
   loadParser7();
   loadParser8();
   loadParser9();
   loadParser10();
   loadParser11();
   loadParser12();
   loadParser13();
   loadParser14();
   loadParser15();
   loadParser16();
   loadParser17();
   _isReserved = false;
}

CegoAdm::~CegoAdm()
{
}

void CegoAdm::parse()
{
   StackT<StackEntry> s;
   StackEntry se(NONE, 0, 0);
   s.Push(se);
   _isReserved = false;
   if ( shiftToken() == false )
   {
      Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
      throw Exception(EXLOC, msg);
   }
   while ( true )
   {
      Action a;
      int num;
      if ( getAction(s.getTop()->getState(), _token, a, num) )
      {
         switch (a)
         {
            case SHIFT:
            {
               StackEntry se(TOKEN, _token, num, _tokenVal);
               s.Push(se);
               if ( shiftToken() == false )
               {
                  Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
                  throw Exception(EXLOC, msg);
               }
               break;
            }
            case REDUCE:
            {
               _tokenList.Empty();
               ProdEntry* pPE = _prodInfo.Find(num);
               for (int i=0; i<pPE->getNumSymbol();i++)
               {
                  StackEntry se;
                  s.Pop(se);
                  if (se.getSymbol() == TOKEN)
                     _tokenList.Insert(se.getTval());
               }
               int fstate;
               if (getJump(s.getTop()->getState(), pPE->getProd(), fstate))
               {
                  StackEntry se(PROD, pPE->getId(), fstate, _tokenVal);
                  s.Push(se);
               }
               else
               {
                  Chain msg = "Cannot reduce after token <" + Chain(_tokenVal) + ">.";
                  throw Exception(EXLOC, msg);
               }
               switch (num)
               {
                  case 164:
                     dumpUIndex();
                     break;
                  case 163:
                     dumpTable();
                     break;
                  case 162:
                     copyFileAction();
                     break;
                  case 161:
                     setTableSetNodeAction();
                     break;
                  case 160:
                     getDbInfoAction();
                     break;
                  case 159:
                     getDbSpecAction();
                     break;
                  case 157:
                     storePit();
                     break;
                  case 156:
                     storeBranchAttr();
                     break;
                  case 155:
                     storeTSRootAttr();
                     break;
                  case 154:
                     storeSortAreaAttr();
                     break;
                  case 153:
                     storeAppSizeAttr();
                     break;
                  case 152:
                     storeLogNumAttr();
                     break;
                  case 151:
                     storeLogSizeAttr();
                     break;
                  case 150:
                     storeTmpSizeAttr();
                     break;
                  case 149:
                     storeSysSizeAttr();
                     break;
                  case 148:
                     storeSecondaryAttr();
                     break;
                  case 147:
                     storePrimaryAttr();
                     break;
                  case 143:
                     plainModeAction();
                     break;
                  case 142:
                     binModeAction();
                     break;
                  case 141:
                     xmlModeAction();
                     break;
                  case 140:
                     noInitAction();
                     break;
                  case 139:
                     cpDumpAction();
                     break;
                  case 138:
                     forceloadAction();
                     break;
                  case 137:
                     cleanupAction();
                     break;
                  case 133:
                     msgAction();
                     break;
                  case 131:
                     timeoutAction();
                     break;
                  case 129:
                     syncCmdAction();
                     break;
                  case 127:
                     keepTicketAction();
                     break;
                  case 126:
                     importTableSetStructureAction();
                     break;
                  case 125:
                     importTableSetAction();
                     break;
                  case 124:
                     importTableAction();
                     break;
                  case 123:
                     exportTableSetStructureAction();
                     break;
                  case 122:
                     exportTableSetAction();
                     break;
                  case 121:
                     exportTableAction();
                     break;
                  case 120:
                     setQueryCacheThreshold();
                     break;
                  case 119:
                     setQueryCacheHashRange();
                     break;
                  case 118:
                     setQueryCacheMaxSize();
                     break;
                  case 117:
                     setQueryCacheMaxEntry();
                     break;
                  case 114:
                     setQueryCacheParamAction();
                     break;
                  case 113:
                     cleanQueryCacheAction();
                     break;
                  case 112:
                     showQueryCacheAction();
                     break;
                  case 111:
                     listQueryCacheAction();
                     break;
                  case 110:
                     disableQueryCacheAction();
                     break;
                  case 109:
                     enableQueryCacheAction();
                     break;
                  case 108:
                     setTableCacheHashRange();
                     break;
                  case 107:
                     setTableCacheMaxEntry();
                     break;
                  case 106:
                     setTableCacheMaxSize();
                     break;
                  case 105:
                     setTableCacheFilter();
                     break;
                  case 102:
                     setTableCacheParamAction();
                     break;
                  case 101:
                     cleanTableCacheAction();
                     break;
                  case 100:
                     showTableCacheAction();
                     break;
                  case 99:
                     listTableCacheAction();
                     break;
                  case 98:
                     disableTableCacheAction();
                     break;
                  case 97:
                     enableTableCacheAction();
                     break;
                  case 96:
                     disableAutoCorrectAction();
                     break;
                  case 95:
                     enableAutoCorrectAction();
                     break;
                  case 94:
                     disableAppendModeAction();
                     break;
                  case 93:
                     enableAppendModeAction();
                     break;
                  case 92:
                     setNumQueryCostAction();
                     break;
                  case 91:
                     setNumQueryLastAction();
                     break;
                  case 90:
                     setTSLogUserAction();
                     break;
                  case 89:
                     setTSSortAreaSizeAction();
                     break;
                  case 88:
                     setTSLogSizeAction();
                     break;
                  case 87:
                     setTSLogNumAction();
                     break;
                  case 86:
                     setTSRootPathAction();
                     break;
                  case 85:
                     setTSAppSizeAction();
                     break;
                  case 84:
                     setTSTmpSizeAction();
                     break;
                  case 83:
                     setTSSysSizeAction();
                     break;
                  case 82:
                     setCheckpointAction();
                     break;
                  case 81:
                     setTSInitFileAction();
                     break;
                  case 80:
                     showBackupMngAction();
                     break;
                  case 79:
                     showLogMngAction();
                     break;
                  case 78:
                     setBackupMngAction();
                     break;
                  case 77:
                     setLogMngAction();
                     break;
                  case 76:
                     recoverTableSetAction();
                     break;
                  case 75:
                     restoreTableSetAction();
                     break;
                  case 74:
                     syncTableSetAction();
                     break;
                  case 73:
                     listBackupAction();
                     break;
                  case 72:
                     endBackupAction();
                     break;
                  case 71:
                     executeBackupAction();
                     break;
                  case 70:
                     beginBackupAction();
                     break;
                  case 69:
                     removeArchLogAction();
                     break;
                  case 68:
                     addArchLogAction();
                     break;
                  case 67:
                     disableArchLogAction();
                     break;
                  case 66:
                     enableArchLogAction();
                     break;
                  case 65:
                     traceOffAction();
                     break;
                  case 64:
                     traceOnAction();
                     break;
                  case 63:
                     removePermAction();
                     break;
                  case 62:
                     setRightPerm();
                     break;
                  case 61:
                     setFilterPerm();
                     break;
                  case 60:
                     setTableSetPerm();
                     break;
                  case 57:
                     setPermAction();
                     break;
                  case 56:
                     dropRoleAction();
                     break;
                  case 55:
                     createRoleAction();
                     break;
                  case 54:
                     showRoleAction();
                     break;
                  case 53:
                     listRoleAction();
                     break;
                  case 52:
                     removeRoleAction();
                     break;
                  case 51:
                     assignRoleAction();
                     break;
                  case 50:
                     changePwdAction();
                     break;
                  case 49:
                     removeUserAction();
                     break;
                  case 48:
                     listUserAction();
                     break;
                  case 47:
                     addUserAction();
                     break;
                  case 46:
                     correctTableSetAction();
                     break;
                  case 45:
                     verifyTableSetAction();
                     break;
                  case 44:
                     checkTableSetAction();
                     break;
                  case 43:
                     addDataFileAction();
                     break;
                  case 42:
                     resetTableSetAction();
                     break;
                  case 41:
                     removeTableSetAction();
                     break;
                  case 40:
                     dropTableSetAction();
                     break;
                  case 39:
                     relocateMediatorAction();
                     break;
                  case 38:
                     relocateSecondaryAction();
                     break;
                  case 37:
                     switchMediatorAction();
                     break;
                  case 36:
                     switchSecondaryAction();
                     break;
                  case 35:
                     switchTableSetAction();
                     break;
                  case 34:
                     copyTableSetAction();
                     break;
                  case 33:
                     stopTableSetAction();
                     break;
                  case 32:
                     startTableSetAction();
                     break;
                  case 31:
                     createTableSetAction();
                     break;
                  case 30:
                     defineTableSetAction();
                     break;
                  case 29:
                     retrieveTableSetAction();
                     break;
                  case 28:
                     abortDbThreadAction();
                     break;
                  case 27:
                     transactionInfoAction();
                     break;
                  case 26:
                     copyInfoAction();
                     break;
                  case 25:
                     logThreadInfoAction();
                     break;
                  case 24:
                     admThreadInfoAction();
                     break;
                  case 23:
                     dbQueryHistCostAction();
                     break;
                  case 22:
                     dbQueryHistLastAction();
                     break;
                  case 21:
                     dbThreadQueryHistAction();
                     break;
                  case 20:
                     dbThreadInfoAction();
                     break;
                  case 19:
                     lockStatAction();
                     break;
                  case 18:
                     threadInfoAction();
                     break;
                  case 17:
                     buStatResetAction();
                     break;
                  case 16:
                     buStatInfoAction();
                     break;
                  case 15:
                     buFileInfoAction();
                     break;
                  case 14:
                     dbSessionInfoAction();
                     break;
                  case 13:
                     listNodeAction();
                     break;
                  case 12:
                     objInfoAction();
                     break;
                  case 11:
                     logInfoAction();
                     break;
                  case 10:
                     archLogInfoAction();
                     break;
                  case 9:
                     dataFileInfoAction();
                     break;
                  case 8:
                     listTableSetAction();
                     break;
                  case 7:
                     lockInfoAction();
                     break;
                  case 6:
                     rawModeOff();
                     break;
                  case 5:
                     rawModeOn();
                     break;
                  case 4:
                     poolEntryListAction();
                     break;
                  case 3:
                     tableSetInfoAction();
                     break;
                  case 2:
                     parameterInfoAction();
                     break;
                  case 1:
                     poolInfoAction();
                     break;
               }
               break;
            }
            case ACCEPT:
            {
               statementAction();
               return;
            }
            case NULLACTION:
               break;
         }
      }
      else
      {
         Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
         throw Exception(EXLOC, msg);
      }
   }
}


bool CegoAdm::getAction(int state, CegoAdm::Token token, CegoAdm::Action& a, int& num)
{
    if (_actionMap[state][token].getAction() != NULLACTION )
    {
	a = _actionMap[state][token].getAction();
	num = _actionMap[state][token].getNum();
	return true;
    }
    else
    {
	return false;
    }
}

bool CegoAdm::getJump(int state, Production prod, int& fstate)
{
    if ( _jumpMap[state][prod] > 0 )
    {
       fstate = _jumpMap[state][prod];
	    return true;
    }
    else
    {
	    return false;
    }
}

bool CegoAdm::isSepSign(char c)
{
   if (c == '.') return true;
   if (c == ';') return true;
   if (c == ',') return true;
   if (c == '=') return true;
   if (c == '<') return true;
   if (c == '>') return true;
   if (c == ')') return true;
   if (c == '(') return true;
   if (c == '[') return true;
   if (c == ']') return true;
   if (c == '*') return true;
   if (c == '/') return true;
   if (c == '+') return true;
   if (c == '-') return true;
   if (c == '|') return true;
   return false;
}
bool CegoAdm::isSepIgnore(char c)
{
   if (c == '\t') return true;
   if (c == ' ') return true;
   return false;
}
bool CegoAdm::shiftToken()
{
   unsigned long i=0;
   char c;
   while ( isSepIgnore(c = nextChar()) && ! _isReserved );
   if ( _isReserved )
   {
      _token = _reservedToken;
      _isReserved = false;
      return true;
   }
   if (c == 0)
   {
      _token = ENDTOKEN;
      return true;
   }
   if (isSepSign(c))
   {
      _tokenVal[i]=c;
       i++;
   }
   else
   {
      while (c && ! isSepIgnore(c) && ! ( isSepSign(c) && i>0 ) )
      {
         _tokenVal[i]=c;
         i++;
         if ( i >= MAXTOKENVAL )
         {
            throw Exception(EXLOC, Chain("Token length exceeded"));
         }
         c = nextChar();
      }
      if (isSepSign(c)) backChar();
   }
   _tokenVal[i]=0;
   Scanner* pS = _scannerList.First();
   while (pS)
   {
      if (pS->checkPattern(_tokenVal))
      {
         _token = pS->getToken();
         return true;
      }
      pS=_scannerList.Next();
   }
   return false;
}
void CegoAdm::setReserved(Token t)
{
   _reservedToken = t;
   _isReserved = true;
}
