--
-- ### Nested view reference check
-- 

drop if exists table sysmt_device;
create table sysmt_device(
       devid int not null,
       devname string(100) not null,
       devserial string(100),
       devstatus string(20),
       devtype string(20),
       devdesc string(3000),
       rckid int);
       
create primary btree on sysmt_device(devid);

insert into sysmt_device ( devid, devname ) values (10010, 'NDC-EMC-GV');
insert into sysmt_device ( devid, devname ) values (10014, 'SAP-Software');
insert into sysmt_device ( devid, devname ) values (10016, 'MyDevice');
insert into sysmt_device ( devid, devname ) values (10017, 'MySW');
insert into sysmt_device ( devid, devname ) values (10011, 'NDC-EMC-MD');
insert into sysmt_device ( devid, devname ) values (10007, 'EMC-SOD001');
insert into sysmt_device ( devid, devname ) values (10003, 'SAPVIPXXX');


drop if exists table sysmt_devicecomp;
create table sysmt_devicecomp(
       cpid int not null,
       devid int not null,
       coid int not null,
       compname string(100) not null,
       ismulti string(1) not null );

create primary btree on sysmt_devicecomp(cpid);

insert into sysmt_devicecomp values (10013,10007,10018,'WWN78fds6786f7ds8fds', 'Y');
insert into sysmt_devicecomp values (10082,10003,10,'VIP010', 'Y');
insert into sysmt_devicecomp values (10033,10003,10,'VIP001', 'Y');
insert into sysmt_devicecomp values (10017,10003,10,'DG3-VIP', 'Y');
insert into sysmt_devicecomp values (10032,10003,10,'VIP002', 'Y');
insert into sysmt_devicecomp values (10018,10007,10018,'COMPNAME', 'Y');
insert into sysmt_devicecomp values (10019,10007,10018,'COMPNAME', 'Y');
insert into sysmt_devicecomp values (10021,10007,10018,'WWN23456738383', 'Y');
insert into sysmt_devicecomp values (10022,10007,10018,'COMPNAME', 'Y');
insert into sysmt_devicecomp values (10023,10007,10018,'COMPNAME', 'Y');
insert into sysmt_devicecomp values (10034,10003,10,'VIP004', 'Y');
insert into sysmt_devicecomp values (10035,10003,10,'VIP005', 'Y');
insert into sysmt_devicecomp values (10036,10003,10,'VIP006', 'Y');
insert into sysmt_devicecomp values (10037,10003,10,'VIP007', 'Y');
insert into sysmt_devicecomp values (10038,10003,10,'VIP008', 'Y');
insert into sysmt_devicecomp values (10039,10003,10,'VIP009', 'Y');
insert into sysmt_devicecomp values (10081,10003,10,'VIP011', 'Y');



drop if exists table sysmt_dev2srv;
create table sysmt_dev2srv(
       devid int not null,	
       srvtype string(100) not null);

create primary btree on sysmt_dev2srv(devid, srvtype);
insert into sysmt_dev2srv values (10003,'SAP');
insert into sysmt_dev2srv values (10007,'SAP');
insert into sysmt_dev2srv values (10010,'SAP');
insert into sysmt_dev2srv values (10011,'SAP');
insert into sysmt_dev2srv values (10014,'SAP');
insert into sysmt_dev2srv values (10016,'SAP');

drop if exists view compview;
create view compview as
select d.devid as devid,
c.cpid as cpid,
c.ismulti as ismulti
from
sysmt_device d,
sysmt_devicecomp c
where ( d.devid = c.devid );

select dcv.cpid as cpid,
dcv.devid as devid,
d2x.srvtype as srvtype
from
compview dcv,
sysmt_dev2srv d2x
where  dcv.devid = d2x.devid and d2x.srvtype = 'SAP';
