--
-- ### Check advanced join condition 
--
-- and basic table creation / retrieval
--

drop if exists table t1; -- comment after
-- comment at the beginning
create table t1 ( a int, b string(30));
    -- comment with indent
create btree b1 on t1(a, b);

drop if exists table t2;
create table t2 ( c int, d string(30));

create btree b2 on t2(c, d);


insert into t1 values ( 1, 'Alpha');
insert into t1 values ( 2, 'Beta');
insert into t1 values ( 3, 'Gamma');


insert into t2 values ( 1, 'Alpha');
insert into t2 values ( 2, 'Beta');
insert into t2 values ( 3, 'Gamma');


-- for this join, the btree for the inner join condition should be used now
plan select a, b
from t1 inner join t2
on t2.c = t1.a and t2.d = t1.b  and ( t2.d = 'Alpha' or t2.d = 'Beta' )
where t1.a = 1 or t1.a = 2;

-- for this join, full btrees should be used now
plan select a, b
from t1 inner join t2
on t2.c = t1.a and t2.d = t1.b  and ( t2.d = 'Alpha' or t2.d = 'Beta' )
where t1.a = 1;

