#ifndef _CEGOBUFFERPOOLENTRY_H_INCLUDED_
#define _CEGOBUFFERPOOLENTRY_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBufferPoolEntry.h
// ---------------------
// Cego buffer pool entry definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoBufferPoolEntry
//
// Description: Bufferpool entry handle
// 
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>

#include "CegoDefs.h"

class CegoBufferPoolEntry {

public:
  
    CegoBufferPoolEntry();  
    CegoBufferPoolEntry(int seg, int pos, const Chain& occState, bool isDirty, int numFixes, int tabSetId, PageIdType pageId, unsigned fixStat, unsigned long long numUsage);
    ~CegoBufferPoolEntry();

    int getSegment() const;
    int getPos() const;
    const Chain& getOccState() const;
    bool isDirty() const;
    int getNumFixes() const;
    int getTabSetId() const;
    PageIdType getPageId() const;
    unsigned getFixStat() const;
    unsigned long long getNumUsage() const;

    CegoBufferPoolEntry& operator = ( const CegoBufferPoolEntry& b);
    bool operator == ( const CegoBufferPoolEntry& b);

    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoBufferPoolEntry& b);
    
private:

    int _seg;
    int _pos;
    Chain _occState;
    bool _isDirty;
    int _numFixes;
    int _tabSetId;
    PageIdType _pageId;
    unsigned _fixStat;
    unsigned long long _numUsage;
};
#endif
