#ifndef _CEGOTRIGGEROBJECT_H_INCLUDED_
#define _CEGOTRIGGEROBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTriggerObject.h
// -----------------
// Cego trigger object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoTriggerObject
// 
// Description: Derived class from CegoDecodable to use as a container class for trigger objects
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/ListT.h>
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoField.h"
#include "CegoObject.h"
#include "CegoDecodableObject.h"

class CegoTriggerObject : public CegoDecodableObject {

public:

    CegoTriggerObject();
    CegoTriggerObject(const CegoTriggerObject& co);
    CegoTriggerObject(ObjectType type,  const Chain& objName, int tabSetId = 0);
    CegoTriggerObject(int tabSetId,
		      const Chain& triggerName,
		      bool isBefore,
		      bool isOnInsert,
		      bool isOnUpdate,
		      bool isOnDelete,				     
		      const Chain& tabName,
		      const Chain& triggerText);
    ~CegoTriggerObject();

    void setBefore(bool isBefore);
    bool isBefore() const;
    void setOnInsert(bool isOnInsert);
    bool isOnInsert() const;
    void setOnUpdate(bool isOnUpdate);
    bool isOnUpdate() const;
    void setOnDelete(bool isOnDelete);
    bool isOnDelete() const;
    void setTabName(const Chain& name);
    const Chain& getTabName() const;
    void setTriggerText(const Chain& triggerText);   
    const Chain& getTriggerText() const;
    int getEntrySize() const;
    void encode(char *buf) const;
    void decode(char *buf);
    Chain toChain() const;
    Chain getFormatted() const;
    
    CegoTriggerObject& operator = ( const CegoTriggerObject& oe);
    bool operator == ( const CegoTriggerObject& oe);

private:

    Chain fill(const Chain& s, int num) const;
    
    bool _isBefore;
    bool _isOnInsert;
    bool _isOnUpdate;
    bool _isOnDelete;
    Chain _tabName;
    Chain _triggerText;
};
#endif
