#ifndef _CEGOQUERYCACHE_H_INCLUDED_
#define _CEGOQUERYCACHE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoQueryCache.h
// ----------------
// Cego query cache interface defintion
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoQueryCache
// 
// Description: Query Cache Management
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/SetT.h>
#include <lfcbase/HashT.h>

#include "CegoField.h"
#include "CegoFieldValue.h"
#include "CegoAttrDesc.h"
#include "CegoComparison.h"

class CegoQueryCache {

public:

    CegoQueryCache(int tabSetId, int maxEntry, int maxSize, int threshold, int hashRange);
    ~CegoQueryCache();
    
    Element* getCacheInfo();
    Element* getCacheList();
    int getMaxEntry() const;
    int getMaxSize() const;
    int getThreshold() const;
    int getNumQueryCache() const;
    unsigned long long getUsedSize() const;
    double getHitRate() const;
    int getNumFail() const;
    void invalidate(const CegoObject& td);
    CegoFieldValue*** claimEntry(const Chain& queryId, ListT<CegoField>& cacheSchema, int& cacheRows);
    void releaseEntry(const Chain& queryId);
    bool addEntry(const Chain& queryId, const SetT<CegoObject>& objList, ListT< ListT<CegoFieldValue> >* pCacheList, const ListT<CegoField>& cacheSchema);
    void clean();
    void getQCLockStat(int& lockCount, unsigned long long &numRdLock, unsigned long long &numWrLock, unsigned long long &sumRdDelay, unsigned long long &sumWrDelay);
    
private:
    
    class QueryCacheEntry {
	
    public:

	QueryCacheEntry();
	QueryCacheEntry(const Chain& queryId);
	QueryCacheEntry(const Chain& queryId, const SetT<CegoObject>& objectList, ListT< ListT<CegoFieldValue> >* pCacheList, const ListT<CegoField>& cacheSchema);
	~QueryCacheEntry();

	int getSize() const;
	
	int getHashPos(int hashSize) const;

	bool cleanCache();
	const Chain getQueryId() const;
	int getNumRows() const;
	int getNumUsed() const;

	const SetT<CegoObject>& getObjectList() const;

	CegoFieldValue*** claimCache();
	void releaseCache();
	
	const ListT<CegoField>& getSchema() const;
	
	unsigned long getHit() const;
	void incHit();
	
	QueryCacheEntry& operator = ( const QueryCacheEntry& qce);
        bool operator == ( const QueryCacheEntry& qce);
	
	friend ostream& operator << (ostream& s, const QueryCacheEntry& qce)
	{
	    s << "Cache " << qce._queryId;
	    return s;
	}

    private:

	void calcSize();
	
	Chain _queryId;
	SetT<CegoObject> _objList;
	CegoFieldValue*** _pCacheArray;
	ListT<CegoField> _cacheSchema;
	unsigned long _numHit;
	int _numRow;
	int _numCol;
	int _numUsed;
	int _size;
    };

    void PR();
    void PW();
    void V();

    int _tabSetId;
    int _maxEntry;
    int _threshold;
    int _maxSize;
    int _hashRange;
    unsigned long long _usedSize;
    int _numFail;
    int _numTry;
    int _numHit;
    HashT<QueryCacheEntry>* _pQueryCache;
};
#endif
