#ifndef _CEGOPROCTHROWSTMT_H_INCLUDED_
#define _CEGOPROCTHROWSTMT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcThrowStmt.h  
// -------------------
// Cego procedure throw statement implementation
//
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcThrowStmt
// 
// Description: Stored procedure throw exception statement
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoProcStmt.h"
#include "CegoExpr.h"
#include "CegoProcBlock.h"

class CegoProcThrowStmt : public CegoProcStmt  {
    
public:
    
    CegoProcThrowStmt(CegoExpr *pExpr,
		    CegoProcBlock *pBlock);
    ~CegoProcThrowStmt();

    CegoException execute();
    void cleanUp();
    Chain toChain(int defTabSetId, const Chain& indent) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    bool isStatic() const;
    
private:

    CegoProcBlock* _pBlock;
    CegoExpr* _pExpr;
};
#endif
