#ifndef _CEGOPROCCOND_H_INCLUDED_
#define _CEGOPROCCOND_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcCond.h  
// --------------
// Cego procedure condition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcCond
// 
// Description: Stored procedure block condition ( if and while )
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoProcPred.h"
#include "CegoProcStmt.h"

class CegoProcPred;

class CegoProcCond  {
    
public:
    
    enum ConditionMode { AND, OR, PRED };
    
    CegoProcCond();
    CegoProcCond(CegoProcCond* pCond, CegoProcPred *pPred, ConditionMode mode);
    CegoProcCond(CegoProcPred *pPred);
    ~CegoProcCond();

    void setBlock(CegoProcBlock *pBlock);
    bool eval() const;
    void cleanUp();
    Chain toChain(int defTabSetId) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;

    CegoProcCond& operator = (const CegoProcCond& c);
    friend ostream& operator << (ostream& s, const CegoProcCond& c);
    
private:

    ConditionMode _mode;
    CegoProcCond* _pCond;
    CegoProcPred* _pPred;    
};
#endif
