#ifndef _CEGOIMPINSTREAM_H_INCLUDED_
#define _CEGOIMPINSTREAM_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoImpInStream.h
// -----------------
// Cego import instream description
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoImpInStream
// 
// Description: Database import via XML or binary
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcxml/Attribute.h>
#include <lfcxml/XMLInStream.h>

// CEGO INCLUDES
#include "CegoDatabaseManager.h"
#include "CegoTableObject.h"
#include "CegoBTreeObject.h"
#include "CegoKeyObject.h"
#include "CegoCheckObject.h"
#include "CegoTriggerObject.h"
#include "CegoAliasObject.h"
#include "CegoAdminHandler.h"

class CegoDistManager;

class CegoImpInStream : public XMLInStream {
    
public:
    
    CegoImpInStream(const Chain& tableSet, CegoDistManager* pGTM, CegoAdminHandler* pAH);
    CegoImpInStream(const Chain& tableSet, const Chain& tableName, CegoDistManager* pGTM, CegoAdminHandler* pAH);
    ~CegoImpInStream();

    unsigned long long numImported() const;
    void putFirst(Element* pParent, const Chain& name, const ListT<Attribute>& attrList, ListT<char*>& dataList);
    void putNext(Element* pParent, const Chain& name, const ListT<Attribute>& attrList, ListT<char*>& dataList);
    
private:

    enum ImpMode { IMP_ALL, IMP_TABLE};

    void insertData(const Chain& tabName, const ListT<Attribute>& attrList, ListT<char*> dataList);
    
    CegoDistManager* _pGTM;
    Chain _tableSet;
    Chain _impTable;
    ListT<CegoField> _schema;
    CegoDatabaseManager* _pDBMng;
    CegoAdminHandler* _pAH;
    bool _isFirst;
    ImpMode _mode;
    CegoTableObject _oe;

    ListT<CegoTableObject> _idxList;
    ListT<CegoBTreeObject> _btreeList;
    ListT<CegoKeyObject> _keyList;
    ListT<CegoCheckObject> _checkList;
    ListT<CegoTriggerObject> _triggerList;
    ListT<CegoAliasObject> _aliasList;
    
    CegoBufferPage _bp;
    CegoDataPointer _sysEntry;

    unsigned long long _rowCount;
    unsigned long _modId;
};
#endif
