#ifndef _CEGODISTCURSOR_H_INCLUDED_
#define _CEGODISTCURSOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDistCursor.h
// ----------------
// Cego distributed table cursor class definition
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoDistCursor
// 
// Description: Table cursor for distributed table access
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoTableCursor.h"
#include "CegoAttrCond.h"
#include "CegoField.h"
#include "CegoDistDbHandler.h"
#include "CegoTableCache.h"

class CegoDistManager;

class CegoDistCursor  {
    
public:
    
    CegoDistCursor();
    CegoDistCursor(CegoDistManager* pGTM, CegoContentObject *pCO); 
    ~CegoDistCursor();

    void distSetup(ListT<CegoField>** pFLA);
    void distSetup(CegoAttrCond& attrCond, ListT<CegoField>** pFLA);

    // bool nextTuple(ListT<CegoField>& fl);
    bool nextTuple(ListT<CegoField>** pFLA, int pos, int size);

    void reset();

    Element* getPlan();

 private:

    void useCursorObject();
    void unuseCursorObject();
    void checkType();
    
    void sysSetup();
    void joinSetup(const CegoAttrCond& attrCond);
    bool evalCondition(ListT<CegoField>** pFLA, int pos, int size);
    bool getTuple(ListT<CegoField>** pFLA, int offset, int size);

    void nextRight(ListT<CegoField>** pFLA, int offset, int size);
    void nextLeft(ListT<CegoField>** pFLA, int offset, int size);

    void finishCaching();
    
    CegoDistManager* _pGTM;
    CegoTableCache* _pCache;
    
    Chain _tableName;
    Chain _tableAlias;

    int _tabSetId;

    CegoSelect *_pSelect;
    CegoTableCursor* _pTC;
    CegoObjectCursor* _pC;

    CegoDistCursor* _pTCLeft;
    CegoDistCursor* _pTCRight;

    CegoTableObject* _pTO;
    CegoDistCursor* _pTCTab;
    ListT<CegoField>* _pFLAmap;
    
    CegoContentObject *_pCO;
    CegoDatabaseManager *_pDBMng;
    CegoDistDbHandler* _pSH; 

    ListT<CegoField> _schema;

    unsigned long _modId;

    bool _cursorObjectUsed;
    bool _isLocal;
    bool _moreTuple;
    bool _isFirst;

    bool _useCache;
    int _cacheRows;
    int _cacheCols;
    
    int _cachePos;
    
    bool _evalPredicate;
    bool _isAttrCondValid;
    bool _doEval;
    bool _moreLeft;
    bool _moreRight;

    CegoAttrCond _cursorCond;
    CegoAttrCond _innerCond;
    CegoAttrCond _outerCond;

    CegoAttrCond::IndexMatch _idxMatch;

    ListT<Chain> _sysObjList;

    int _cacheEntrySize;
    ListT<CegoField> _cacheSchema;
    CegoFieldValue*** _pCacheArray;
    ListT< ListT<CegoFieldValue> >* _pCacheList;
    bool _isCached;

    ListT<CegoField>** _pFLA;
};
#endif
