#ifndef _CEGOCONDITION_H_INCLUDED_
#define _CEGOCONDITION_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoCondition.h
// ---------------
// Cego condition structure class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoCondition
//
// Description: Condition container class used for queries and stored procedures
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoPredicate.h"

class CegoCondition {

public:
    
    enum CondType { AND, OR, PRED };
    
    CegoCondition(char *buf, CegoDistManager *pGTM, CegoProcBlock *pBlock, int tabSetId);
    CegoCondition(CondType ct);
    ~CegoCondition();

    void setTabSetId(int tabSetId);
    
    void getPlanList(ListT<Element*>& planList);

    CegoPredicate* Left();
    CegoPredicate* Right();
    
    void setLeft(CegoPredicate* pP);
    void setRight(CegoPredicate* pP);

    void setCondType(CondType ct);
    CondType getCondType();

    void encode(char *buf, CegoProcBlock *pBlock);
    void decode(char *buf, CegoDistManager *pGTM, CegoProcBlock *pBlock, int tabSetId);
    int getEncodingLength(CegoProcBlock *pBlock) const;

    void clearAttrCache();
    
    ListT<CegoAttrDesc*> getAttrRefList() const;
    void getFieldList(ListT<CegoField>& fl, ListT<CegoField>** pFLA) const;

    int evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);
    ListT<CegoAggregation*> getAggregationList();

    void setAggregationValue(ListT<CegoField>& jfl);
	
    CegoField evalField(const ListT<CegoField>& fl, bool graceful) const;

    CegoFieldValue evalFieldValue(ListT<CegoField>** pFLA, CegoProcBlock *pBlock) const;
    
    
    void cleanUp();

    Chain getId(CegoProcBlock *pBlock) const;

    Chain toChain(int defTabSetId) const;
    Chain dbFormat(CegoDatabaseFormater *pForm);
    
    CegoCondition* clone(bool isAttrRef = false);

private:

    CondType _condType;
    CegoPredicate *_pLeft;
    CegoPredicate *_pRight;

};
#endif
