#ifndef _CEGOALIASOBJECT_H_INCLUDED_
#define _CEGOALIASOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAliasObject.h
// -----------------
// Cego alias object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAliasObject
// 
// Description: Derived class from CegoDecodable to use as a container class for alias objects
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/ListT.h>
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoField.h"
#include "CegoObject.h"
#include "CegoDecodableObject.h"
#include "CegoAttrAlias.h"

class CegoAliasObject : public CegoContentObject {

 public:

    CegoAliasObject();
    CegoAliasObject(const CegoAliasObject& ao);
    CegoAliasObject(int tabSetId, const Chain& aliasName);
    CegoAliasObject(int tabSetId, const Chain& aliasName, const Chain& tabName, const ListT<CegoAttrAlias>& aliasList);
	
    ~CegoAliasObject();
    
    void setAliasList(const ListT<CegoAttrAlias>& aliasList);   
    const ListT<CegoAttrAlias>& getAliasList();

    int getEntrySize() const;

    void encode(char *buf) const;
    void decode(char *buf);
    
    void setSchema(const ListT<CegoField>& schema);
    void mapSchema();
    
    CegoAliasObject& operator = ( const CegoAliasObject& ae);
    bool operator == ( const CegoAliasObject& oe);
    
    Chain getId(CegoProcBlock *pBlock) const;
    Chain toChain(int defTabSetId) const;
    CegoContentObject* clone(bool isAttrRef = false);
    
    Chain getFormatted() const;

 private:

    Chain fill(const Chain& s, int num) const;
    ListT<CegoAttrAlias> _aliasList;
};
#endif
