#ifndef _CEGOADMNET_H_INCLUDED_
#define _CEGOADMNET_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAdmNet.h
// ------------
// Cego admin client API
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAdmNet
// 
// Description: Database administration API 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/NetHandler.h>

// cego includes
#include "CegoModule.h"
#include "CegoAdminHandler.h"

class CegoAdmNet {

 public:

    CegoAdmNet();
    CegoAdmNet(const Chain& logFile, const Chain& progName, const Chain& logMode );
    ~CegoAdmNet();
    
    void connect(const Chain& serverName, int port, const Chain& user, const Chain& pwd);

    void getTableSetList(ListT<Chain>& tslist);
    void getTableSetInfo(const Chain& tableSet, 
			 ListT<Chain>& tsInfoList,
			 ListT<Chain>& fileInfoList,
			 ListT<Chain>& logInfoList);

    void startTableSet(const Chain& tableSet, bool doCleanup, bool forceload, bool cpDump, bool noInit);
    void stopTableSet(const Chain& tableSet);

    void getThreadInfo(ListT<Chain>& threadInfoList);

    void getDbThreadInfo(ListT<Chain>& dbThreadInfoList);
    void getAdmThreadInfo(ListT<Chain>& admThreadInfoList);
    void getLogThreadInfo(ListT<Chain>& logThreadInfoList);

    void importTableSet(const Chain& tableSet, const Chain& impMode, const Chain& impFile);
    void exportTableSet(const Chain& tableSet, const Chain& expMode, const Chain& expFile);

    void addDataFile(const Chain& tableSet, const Chain& fileType, const Chain& dataFile, int numPages);
    
    void defineTableSet(const Chain& tableSet, 
			const Chain& tsRoot,
			const Chain& primary,
			const Chain& secondary,
			int sysSize,
			int tmpSize,
			int appSize,
			int logSize,
			int logNum, 
			unsigned long long orderSize);
    
    void createTableSet(const Chain& tableSet);
    void dropTableSet(const Chain& tableSet);

    void switchSecondary(const Chain& tableSet);
    void switchMediatorAction(const Chain& tableSet);
    void relocateSecondary(const Chain& tableSet, const Chain& secondary);
    void relocateMediator(const Chain& tableSet, const Chain& mediator);

    void recoverTableSet(const Chain& tableSet, const Chain& pit);

    void disconnect();

private:

    void handleMedResult(CegoAdminHandler::ResultType res);
    
    Chain _logFile;
    Chain _progName;
    Chain _logLevel;

    NetHandler* _pN;
    CegoAdminHandler* _pAH;
    CegoModule* _pModule;
};
#endif
