//
// File: Cego.cc
// This code was produced by the dragon parser generator
//
#include "Cego.h"
#include <lfcbase/Exception.h>
#include <lfcbase/StackT.h>

Cego::ScannerStateEntry::ScannerStateEntry()
{
}

Cego::ScannerStateEntry::ScannerStateEntry(int state, ScannerStateType type)
{
   _state = state;
   _type = type;
}

Cego::ScannerStateEntry& Cego::ScannerStateEntry::operator = (const Cego::ScannerStateEntry& s)
{
   _state = s._state;
   _type = s._type;
   return(*this);
}

bool Cego::ScannerStateEntry::operator == (const Cego::ScannerStateEntry& s)
{
   if ( _state == s._state )
      return true;
   return false;
}

Cego::ScannerStateType Cego::ScannerStateEntry::getType()
{
   return _type;
}
int Cego::ScannerStateEntry::getState()
{
   return _state;
}


Cego::ScannerTransEntry::ScannerTransEntry()
{
}

Cego::ScannerTransEntry::ScannerTransEntry(int state, char c)
{
   _state = state;
   _c = c;
}

Cego::ScannerTransEntry::ScannerTransEntry(int state, char c, int fstate)
{
   _state = state;
   _c = c;
   _fstate = fstate;
}

Cego::ScannerTransEntry& Cego::ScannerTransEntry::operator = (const Cego::ScannerTransEntry& s)
{
   _state = s._state;
   _c = s._c;
   _fstate = s._fstate;
   return(*this);
}

bool Cego::ScannerTransEntry::operator == (const Cego::ScannerTransEntry& s)
{
   if ( _state == s._state && _c == s._c)
      return true;
   return false;
}

int Cego::ScannerTransEntry::getFState()
{
   return _fstate;
}


Cego::Scanner::Scanner()
{
}


Cego::Scanner::Scanner(Token t)
{
   _token = t;
}

Cego::Token Cego::Scanner::getToken()
{
   return _token;
}

void Cego::Scanner::addState(ScannerStateEntry s)
{
   _stateList.Insert(s);
}

void Cego::Scanner::addTransition(ScannerTransEntry t)
{
   _transList.Insert(t);
}

bool Cego::Scanner::checkPattern(const Chain& p)
{
   unsigned long state = 0;
   ScannerStateEntry* pS = _stateList.First();
   while (pS)
   {
      if (pS->getType() == START || pS->getType() == ANY)
      {
         state = pS->getState();
         pS = 0;
      }
      else
      {
         pS = _stateList.Next();
      }
   }
   unsigned long i = 0;
   ScannerTransEntry* pT = 
   _transList.Find(ScannerTransEntry(state, p[i]));
   while (pT)
   {
      ScannerStateEntry* pS = _stateList.Find(ScannerStateEntry(pT->getFState())); 
      if (pS)
      {
         if ( ( i == p.length()-2 ) && ( pS->getType() == FINAL || pS->getType() == ANY))
         {
            return true;
         }
         else
         {
            state = pT->getFState();
         }
      }
      else
      {
         return false;
      }
      i++;
      pT = _transList.Find(ScannerTransEntry(state, p[i]));
   }
   return false;
}
Cego::StackEntry::StackEntry()
{
   _symbol = NONE;
}

Cego::StackEntry::StackEntry(Symbol symbol, int num, int state, Chain tval)
{
   _symbol=symbol;
   _num=num;
   _state=state;
   _tval=tval;
}

Cego::StackEntry& Cego::StackEntry::operator = (const Cego::StackEntry& se)
{
   _symbol=se._symbol;
   _num=se._num;
   _state=se._state;
   _tval=se._tval;
   return(*this);
}

int Cego::StackEntry::getState()
{
   return _state;
}
Cego::Symbol Cego::StackEntry::getSymbol()
{
   return _symbol;
}
Chain& Cego::StackEntry::getTval()
{
   return _tval;
}

Cego::ActionEntry::ActionEntry()
{
   _action=NULLACTION;
}

Cego::ActionEntry::ActionEntry(Action action , int num)
{
   _action=action;
   _num=num;
}

bool Cego::ActionEntry::operator == (const Cego::ActionEntry& ae)
{
   if (_action == ae._action && _num == ae._num)
      return true;
   return false;
}

Cego::ActionEntry& Cego::ActionEntry::operator = (const Cego::ActionEntry& ae)
{
   _action=ae._action;
   _num=ae._num;
   return(*this);
}

Cego::Action Cego::ActionEntry::getAction()
{
   return _action;
}

int Cego::ActionEntry::getNum()
{
   return _num;
}

Cego::ProdEntry::ProdEntry()
{
}

Cego::ProdEntry::ProdEntry(int id)
{
   _id = id;
}

Cego::ProdEntry::ProdEntry(int id, Production prod, int numSymbol)
{
   _id = id;
   _prod = prod;
   _numSymbol = numSymbol;
}

bool Cego::ProdEntry::operator == (const Cego::ProdEntry& pe)
{
   if (_id == pe._id)
      return true;
   return false;
}

Cego::ProdEntry& Cego::ProdEntry::operator = (const Cego::ProdEntry& pe)
{
   _id = pe._id;
   _prod = pe._prod;
   _numSymbol = pe._numSymbol;
   return(*this);
}


int Cego::ProdEntry::getId()
{
   return _id;
}

Cego::Production Cego::ProdEntry::getProd()
{
   return _prod;
}

int Cego::ProdEntry::getNumSymbol()
{
   return _numSymbol;
}
void Cego::loadScanner()
{
   Scanner s0(ADD);
   s0.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(2 ,START));
   s0.addState(ScannerStateEntry(3 ,FINAL));
   s0.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s0.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s0.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s0.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s0.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s0.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s0);

   Scanner s1(AFTER);
   s1.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(2 ,START));
   s1.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(5 ,FINAL));
   s1.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s1.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s1.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s1.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s1.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s1.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s1.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s1.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s1.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s1.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s1);

   Scanner s2(ALIAS);
   s2.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(2 ,START));
   s2.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(5 ,FINAL));
   s2.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s2.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s2.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s2.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s2.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s2.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s2.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s2.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s2.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s2.addTransition(ScannerTransEntry(4 ,'s' ,5));
   _scannerList.Insert(s2);

   Scanner s3(AND);
   s3.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(2 ,START));
   s3.addState(ScannerStateEntry(3 ,FINAL));
   s3.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s3.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s3.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s3.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s3.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s3.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s3);

   Scanner s4(ALL);
   s4.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(2 ,START));
   s4.addState(ScannerStateEntry(3 ,FINAL));
   s4.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s4.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s4.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s4.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s4.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s4.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s4);

   Scanner s5(ALTER);
   s5.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(2 ,START));
   s5.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(5 ,FINAL));
   s5.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s5.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s5.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s5.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s5.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s5.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s5.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s5.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s5.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s5.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s5);

   Scanner s6(APPEND);
   s6.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(2 ,START));
   s6.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(6 ,FINAL));
   s6.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s6.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s6.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s6.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s6.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s6.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s6.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s6.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s6.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s6.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s6.addTransition(ScannerTransEntry(5 ,'D' ,6));
   s6.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s6);

   Scanner s7(AS);
   s7.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(1 ,FINAL));
   s7.addState(ScannerStateEntry(2 ,START));
   s7.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s7.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s7.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s7.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s7);

   Scanner s8(ASC);
   s8.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(2 ,START));
   s8.addState(ScannerStateEntry(3 ,FINAL));
   s8.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s8.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s8.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s8.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s8.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s8.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s8);

   Scanner s9(ASC2INT);
   s9.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(2 ,START));
   s9.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(7 ,FINAL));
   s9.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s9.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s9.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s9.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s9.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s9.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s9.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s9.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s9.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s9.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s9.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s9.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s9.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s9);

   Scanner s10(AUTHORIZE);
   s10.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(2 ,START));
   s10.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(9 ,FINAL));
   s10.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s10.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s10.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s10.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s10.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s10.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s10.addTransition(ScannerTransEntry(3 ,'H' ,4));
   s10.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s10.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s10.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s10.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s10.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s10.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s10.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s10.addTransition(ScannerTransEntry(7 ,'Z' ,8));
   s10.addTransition(ScannerTransEntry(7 ,'z' ,8));
   s10.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s10.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s10);

   Scanner s11(AUTOCOMMIT);
   s11.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(2 ,START));
   s11.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(10 ,FINAL));
   s11.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s11.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s11.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s11.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s11.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s11.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s11.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s11.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s11.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s11.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s11.addTransition(ScannerTransEntry(5 ,'O' ,6));
   s11.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s11.addTransition(ScannerTransEntry(6 ,'M' ,7));
   s11.addTransition(ScannerTransEntry(6 ,'m' ,7));
   s11.addTransition(ScannerTransEntry(7 ,'M' ,8));
   s11.addTransition(ScannerTransEntry(7 ,'m' ,8));
   s11.addTransition(ScannerTransEntry(8 ,'I' ,9));
   s11.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s11.addTransition(ScannerTransEntry(9 ,'T' ,10));
   s11.addTransition(ScannerTransEntry(9 ,'t' ,10));
   _scannerList.Insert(s11);

   Scanner s12(AVG);
   s12.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(2 ,START));
   s12.addState(ScannerStateEntry(3 ,FINAL));
   s12.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s12.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'G' ,3));
   s12.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s12.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s12.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s12);

   Scanner s13(AVLTREE);
   s13.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(2 ,START));
   s13.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(7 ,FINAL));
   s13.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s13.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s13.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s13.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s13.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s13.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s13.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s13.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s13.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s13.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s13.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s13.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s13);

   Scanner s14(BEFORE);
   s14.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(2 ,START));
   s14.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(6 ,FINAL));
   s14.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s14.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s14.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s14.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s14.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s14.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s14.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s14.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s14.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s14.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s14.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s14.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s14);

   Scanner s15(BEGIN);
   s15.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(2 ,START));
   s15.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(5 ,FINAL));
   s15.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s15.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s15.addTransition(ScannerTransEntry(1 ,'G' ,3));
   s15.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s15.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s15.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s15.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s15.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s15.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s15.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s15);

   Scanner s16(BETWEEN);
   s16.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(2 ,START));
   s16.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(7 ,FINAL));
   s16.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s16.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s16.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s16.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s16.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s16.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s16.addTransition(ScannerTransEntry(3 ,'W' ,4));
   s16.addTransition(ScannerTransEntry(3 ,'w' ,4));
   s16.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s16.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s16.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s16.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s16.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s16.addTransition(ScannerTransEntry(6 ,'n' ,7));
   _scannerList.Insert(s16);

   Scanner s17(BIGINT);
   s17.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(2 ,START));
   s17.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(6 ,FINAL));
   s17.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s17.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s17.addTransition(ScannerTransEntry(1 ,'G' ,3));
   s17.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s17.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s17.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s17.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s17.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s17.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s17.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s17.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s17.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s17);

   Scanner s18(BITAND);
   s18.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(2 ,START));
   s18.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(6 ,FINAL));
   s18.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s18.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s18.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s18.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s18.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s18.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s18.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s18.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s18.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s18.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s18.addTransition(ScannerTransEntry(5 ,'D' ,6));
   s18.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s18);

   Scanner s19(BITOR);
   s19.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(2 ,START));
   s19.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(5 ,FINAL));
   s19.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s19.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s19.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s19.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s19.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s19.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s19.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s19.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s19.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s19.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s19);

   Scanner s20(BITXOR);
   s20.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(2 ,START));
   s20.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(6 ,FINAL));
   s20.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s20.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s20.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s20.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s20.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s20.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s20.addTransition(ScannerTransEntry(3 ,'X' ,4));
   s20.addTransition(ScannerTransEntry(3 ,'x' ,4));
   s20.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s20.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s20.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s20.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s20);

   Scanner s21(BLOB);
   s21.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(2 ,START));
   s21.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(4 ,FINAL));
   s21.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s21.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s21.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s21.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s21.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s21.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s21.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s21.addTransition(ScannerTransEntry(3 ,'b' ,4));
   _scannerList.Insert(s21);

   Scanner s22(BLOBSIZE);
   s22.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(2 ,START));
   s22.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(8 ,FINAL));
   s22.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s22.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s22.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s22.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s22.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s22.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s22.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s22.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s22.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s22.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s22.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s22.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s22.addTransition(ScannerTransEntry(6 ,'Z' ,7));
   s22.addTransition(ScannerTransEntry(6 ,'z' ,7));
   s22.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s22.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s22);

   Scanner s23(BLOBREF);
   s23.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(2 ,START));
   s23.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(7 ,FINAL));
   s23.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s23.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s23.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s23.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s23.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s23.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s23.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s23.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s23.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s23.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s23.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s23.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s23.addTransition(ScannerTransEntry(6 ,'F' ,7));
   s23.addTransition(ScannerTransEntry(6 ,'f' ,7));
   _scannerList.Insert(s23);

   Scanner s24(BOOL);
   s24.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(2 ,START));
   s24.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(4 ,FINAL));
   s24.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s24.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s24.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s24.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s24.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s24.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s24.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s24.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s24);

   Scanner s25(BTREE);
   s25.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(2 ,START));
   s25.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(5 ,FINAL));
   s25.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s25.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s25.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s25.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s25.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s25.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s25.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s25.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s25.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s25.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s25);

   Scanner s26(BY);
   s26.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(1 ,FINAL));
   s26.addState(ScannerStateEntry(2 ,START));
   s26.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s26.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s26.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s26.addTransition(ScannerTransEntry(2 ,'b' ,0));
   _scannerList.Insert(s26);

   Scanner s27(CACHED);
   s27.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(2 ,START));
   s27.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(6 ,FINAL));
   s27.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s27.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s27.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s27.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s27.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s27.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s27.addTransition(ScannerTransEntry(3 ,'H' ,4));
   s27.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s27.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s27.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s27.addTransition(ScannerTransEntry(5 ,'D' ,6));
   s27.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s27);

   Scanner s28(CALL);
   s28.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(2 ,START));
   s28.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(4 ,FINAL));
   s28.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s28.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s28.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s28.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s28.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s28.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s28.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s28.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s28);

   Scanner s29(CASE);
   s29.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(2 ,START));
   s29.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(4 ,FINAL));
   s29.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s29.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s29.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s29.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s29.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s29.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s29.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s29.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s29);

   Scanner s30(CHECK);
   s30.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(2 ,START));
   s30.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(5 ,FINAL));
   s30.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s30.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s30.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s30.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s30.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s30.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s30.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s30.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s30.addTransition(ScannerTransEntry(4 ,'K' ,5));
   s30.addTransition(ScannerTransEntry(4 ,'k' ,5));
   _scannerList.Insert(s30);

   Scanner s31(CLOB);
   s31.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(2 ,START));
   s31.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(4 ,FINAL));
   s31.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s31.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s31.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s31.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s31.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s31.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s31.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s31.addTransition(ScannerTransEntry(3 ,'b' ,4));
   _scannerList.Insert(s31);

   Scanner s32(CLOBSIZE);
   s32.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(2 ,START));
   s32.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(8 ,FINAL));
   s32.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s32.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s32.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s32.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s32.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s32.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s32.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s32.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s32.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s32.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s32.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s32.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s32.addTransition(ScannerTransEntry(6 ,'Z' ,7));
   s32.addTransition(ScannerTransEntry(6 ,'z' ,7));
   s32.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s32.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s32);

   Scanner s33(CLOBREF);
   s33.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(2 ,START));
   s33.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(7 ,FINAL));
   s33.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s33.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s33.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s33.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s33.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s33.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s33.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s33.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s33.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s33.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s33.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s33.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s33.addTransition(ScannerTransEntry(6 ,'F' ,7));
   s33.addTransition(ScannerTransEntry(6 ,'f' ,7));
   _scannerList.Insert(s33);

   Scanner s34(CLOB2STR);
   s34.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(2 ,START));
   s34.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(8 ,FINAL));
   s34.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s34.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s34.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s34.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s34.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s34.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s34.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s34.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s34.addTransition(ScannerTransEntry(4 ,'2' ,5));
   s34.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s34.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s34.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s34.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s34.addTransition(ScannerTransEntry(7 ,'R' ,8));
   s34.addTransition(ScannerTransEntry(7 ,'r' ,8));
   _scannerList.Insert(s34);

   Scanner s35(CLOSE);
   s35.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(2 ,START));
   s35.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(5 ,FINAL));
   s35.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s35.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s35.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s35.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s35.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s35.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s35.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s35.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s35.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s35.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s35);

   Scanner s36(COMMIT);
   s36.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(2 ,START));
   s36.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(6 ,FINAL));
   s36.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s36.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s36.addTransition(ScannerTransEntry(1 ,'M' ,3));
   s36.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s36.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s36.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s36.addTransition(ScannerTransEntry(3 ,'M' ,4));
   s36.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s36.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s36.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s36.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s36.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s36);

   Scanner s37(COLUMN);
   s37.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(2 ,START));
   s37.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(6 ,FINAL));
   s37.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s37.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s37.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s37.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s37.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s37.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s37.addTransition(ScannerTransEntry(3 ,'U' ,4));
   s37.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s37.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s37.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s37.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s37.addTransition(ScannerTransEntry(5 ,'n' ,6));
   _scannerList.Insert(s37);

   Scanner s38(CONDITION);
   s38.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(2 ,START));
   s38.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(9 ,FINAL));
   s38.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s38.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s38.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s38.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s38.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s38.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s38.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s38.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s38.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s38.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s38.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s38.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s38.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s38.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s38.addTransition(ScannerTransEntry(7 ,'O' ,8));
   s38.addTransition(ScannerTransEntry(7 ,'o' ,8));
   s38.addTransition(ScannerTransEntry(8 ,'N' ,9));
   s38.addTransition(ScannerTransEntry(8 ,'n' ,9));
   _scannerList.Insert(s38);

   Scanner s39(CONSTRAINT);
   s39.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(2 ,START));
   s39.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(10 ,FINAL));
   s39.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s39.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s39.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s39.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s39.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s39.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s39.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s39.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s39.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s39.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s39.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s39.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s39.addTransition(ScannerTransEntry(6 ,'A' ,7));
   s39.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s39.addTransition(ScannerTransEntry(7 ,'I' ,8));
   s39.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s39.addTransition(ScannerTransEntry(8 ,'N' ,9));
   s39.addTransition(ScannerTransEntry(8 ,'n' ,9));
   s39.addTransition(ScannerTransEntry(9 ,'T' ,10));
   s39.addTransition(ScannerTransEntry(9 ,'t' ,10));
   _scannerList.Insert(s39);

   Scanner s40(COUNT);
   s40.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(2 ,START));
   s40.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(5 ,FINAL));
   s40.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s40.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s40.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s40.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s40.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s40.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s40.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s40.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s40.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s40.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s40);

   Scanner s41(COUNTER);
   s41.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(2 ,START));
   s41.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(7 ,FINAL));
   s41.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s41.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s41.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s41.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s41.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s41.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s41.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s41.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s41.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s41.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s41.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s41.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s41.addTransition(ScannerTransEntry(6 ,'R' ,7));
   s41.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s41);

   Scanner s42(CREATE);
   s42.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(2 ,START));
   s42.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(6 ,FINAL));
   s42.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s42.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s42.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s42.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s42.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s42.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s42.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s42.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s42.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s42.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s42.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s42.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s42);

   Scanner s43(CURSOR);
   s43.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(2 ,START));
   s43.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(6 ,FINAL));
   s43.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s43.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s43.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s43.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s43.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s43.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s43.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s43.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s43.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s43.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s43.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s43.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s43);

   Scanner s44(DATE2STR);
   s44.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(2 ,START));
   s44.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(8 ,FINAL));
   s44.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s44.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s44.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s44.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s44.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s44.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s44.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s44.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s44.addTransition(ScannerTransEntry(4 ,'2' ,5));
   s44.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s44.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s44.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s44.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s44.addTransition(ScannerTransEntry(7 ,'R' ,8));
   s44.addTransition(ScannerTransEntry(7 ,'r' ,8));
   _scannerList.Insert(s44);

   Scanner s45(DATE2LONG);
   s45.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(2 ,START));
   s45.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(9 ,FINAL));
   s45.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s45.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s45.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s45.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s45.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s45.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s45.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s45.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s45.addTransition(ScannerTransEntry(4 ,'2' ,5));
   s45.addTransition(ScannerTransEntry(5 ,'L' ,6));
   s45.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s45.addTransition(ScannerTransEntry(6 ,'O' ,7));
   s45.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s45.addTransition(ScannerTransEntry(7 ,'N' ,8));
   s45.addTransition(ScannerTransEntry(7 ,'n' ,8));
   s45.addTransition(ScannerTransEntry(8 ,'G' ,9));
   s45.addTransition(ScannerTransEntry(8 ,'g' ,9));
   _scannerList.Insert(s45);

   Scanner s46(DATETIME);
   s46.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(2 ,START));
   s46.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(8 ,FINAL));
   s46.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s46.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s46.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s46.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s46.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s46.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s46.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s46.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s46.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s46.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s46.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s46.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s46.addTransition(ScannerTransEntry(6 ,'M' ,7));
   s46.addTransition(ScannerTransEntry(6 ,'m' ,7));
   s46.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s46.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s46);

   Scanner s47(DECIMAL);
   s47.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(2 ,START));
   s47.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(7 ,FINAL));
   s47.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s47.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s47.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s47.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s47.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s47.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s47.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s47.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s47.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s47.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s47.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s47.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s47.addTransition(ScannerTransEntry(6 ,'L' ,7));
   s47.addTransition(ScannerTransEntry(6 ,'l' ,7));
   _scannerList.Insert(s47);

   Scanner s48(DEFAULT);
   s48.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(2 ,START));
   s48.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(7 ,FINAL));
   s48.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s48.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s48.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s48.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s48.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s48.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s48.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s48.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s48.addTransition(ScannerTransEntry(4 ,'U' ,5));
   s48.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s48.addTransition(ScannerTransEntry(5 ,'L' ,6));
   s48.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s48.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s48.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s48);

   Scanner s49(DELETETOK);
   s49.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(2 ,START));
   s49.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(6 ,FINAL));
   s49.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s49.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s49.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s49.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s49.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s49.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s49.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s49.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s49.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s49.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s49.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s49.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s49);

   Scanner s50(DESC);
   s50.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(2 ,START));
   s50.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(4 ,FINAL));
   s50.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s50.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s50.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s50.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s50.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s50.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s50.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s50.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s50);

   Scanner s51(DISTINCT);
   s51.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(2 ,START));
   s51.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(8 ,FINAL));
   s51.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s51.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s51.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s51.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s51.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s51.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s51.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s51.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s51.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s51.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s51.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s51.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s51.addTransition(ScannerTransEntry(6 ,'C' ,7));
   s51.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s51.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s51.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s51);

   Scanner s52(DIV);
   s52.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(2 ,START));
   s52.addState(ScannerStateEntry(3 ,FINAL));
   s52.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s52.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s52.addTransition(ScannerTransEntry(1 ,'V' ,3));
   s52.addTransition(ScannerTransEntry(1 ,'v' ,3));
   s52.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s52.addTransition(ScannerTransEntry(2 ,'d' ,0));
   _scannerList.Insert(s52);

   Scanner s53(DOUBLE);
   s53.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(2 ,START));
   s53.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(6 ,FINAL));
   s53.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s53.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s53.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s53.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s53.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s53.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s53.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s53.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s53.addTransition(ScannerTransEntry(4 ,'L' ,5));
   s53.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s53.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s53.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s53);

   Scanner s54(DROP);
   s54.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(2 ,START));
   s54.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(4 ,FINAL));
   s54.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s54.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s54.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s54.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s54.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s54.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s54.addTransition(ScannerTransEntry(3 ,'P' ,4));
   s54.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s54);

   Scanner s55(ELSE);
   s55.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(2 ,START));
   s55.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(4 ,FINAL));
   s55.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s55.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s55.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s55.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s55.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s55.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s55.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s55.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s55);

   Scanner s56(ELSIF);
   s56.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(2 ,START));
   s56.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(5 ,FINAL));
   s56.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s56.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s56.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s56.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s56.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s56.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s56.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s56.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s56.addTransition(ScannerTransEntry(4 ,'F' ,5));
   s56.addTransition(ScannerTransEntry(4 ,'f' ,5));
   _scannerList.Insert(s56);

   Scanner s57(END_TOKEN);
   s57.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(2 ,START));
   s57.addState(ScannerStateEntry(3 ,FINAL));
   s57.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s57.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s57.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s57.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s57.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s57.addTransition(ScannerTransEntry(2 ,'e' ,0));
   _scannerList.Insert(s57);

   Scanner s58(EXCEPTION);
   s58.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(2 ,START));
   s58.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(9 ,FINAL));
   s58.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s58.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s58.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s58.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s58.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s58.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s58.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s58.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s58.addTransition(ScannerTransEntry(4 ,'P' ,5));
   s58.addTransition(ScannerTransEntry(4 ,'p' ,5));
   s58.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s58.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s58.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s58.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s58.addTransition(ScannerTransEntry(7 ,'O' ,8));
   s58.addTransition(ScannerTransEntry(7 ,'o' ,8));
   s58.addTransition(ScannerTransEntry(8 ,'N' ,9));
   s58.addTransition(ScannerTransEntry(8 ,'n' ,9));
   _scannerList.Insert(s58);

   Scanner s59(EXISTS);
   s59.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(2 ,START));
   s59.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(6 ,FINAL));
   s59.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s59.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s59.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s59.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s59.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s59.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s59.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s59.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s59.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s59.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s59.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s59.addTransition(ScannerTransEntry(5 ,'s' ,6));
   _scannerList.Insert(s59);

   Scanner s60(FALSEVAL);
   s60.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(2 ,START));
   s60.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(5 ,FINAL));
   s60.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s60.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s60.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s60.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s60.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s60.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s60.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s60.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s60.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s60.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s60);

   Scanner s61(FETCH);
   s61.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(2 ,START));
   s61.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(5 ,FINAL));
   s61.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s61.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s61.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s61.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s61.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s61.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s61.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s61.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s61.addTransition(ScannerTransEntry(4 ,'H' ,5));
   s61.addTransition(ScannerTransEntry(4 ,'h' ,5));
   _scannerList.Insert(s61);

   Scanner s62(FIRST);
   s62.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(2 ,START));
   s62.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(5 ,FINAL));
   s62.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s62.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s62.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s62.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s62.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s62.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s62.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s62.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s62.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s62.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s62);

   Scanner s63(FLOAT);
   s63.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(2 ,START));
   s63.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(5 ,FINAL));
   s63.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s63.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s63.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s63.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s63.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s63.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s63.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s63.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s63.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s63.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s63);

   Scanner s64(FOR);
   s64.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(2 ,START));
   s64.addState(ScannerStateEntry(3 ,FINAL));
   s64.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s64.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s64.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s64.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s64.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s64.addTransition(ScannerTransEntry(2 ,'f' ,0));
   _scannerList.Insert(s64);

   Scanner s65(FOREIGN);
   s65.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(2 ,START));
   s65.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(7 ,FINAL));
   s65.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s65.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s65.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s65.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s65.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s65.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s65.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s65.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s65.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s65.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s65.addTransition(ScannerTransEntry(5 ,'G' ,6));
   s65.addTransition(ScannerTransEntry(5 ,'g' ,6));
   s65.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s65.addTransition(ScannerTransEntry(6 ,'n' ,7));
   _scannerList.Insert(s65);

   Scanner s66(FROM);
   s66.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(2 ,START));
   s66.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(4 ,FINAL));
   s66.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s66.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s66.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s66.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s66.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s66.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s66.addTransition(ScannerTransEntry(3 ,'M' ,4));
   s66.addTransition(ScannerTransEntry(3 ,'m' ,4));
   _scannerList.Insert(s66);

   Scanner s67(GETCOUNT);
   s67.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(2 ,START));
   s67.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(8 ,FINAL));
   s67.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s67.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s67.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s67.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s67.addTransition(ScannerTransEntry(2 ,'G' ,0));
   s67.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s67.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s67.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s67.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s67.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s67.addTransition(ScannerTransEntry(5 ,'U' ,6));
   s67.addTransition(ScannerTransEntry(5 ,'u' ,6));
   s67.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s67.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s67.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s67.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s67);

   Scanner s68(GETPOS);
   s68.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(2 ,START));
   s68.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(6 ,FINAL));
   s68.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s68.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s68.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s68.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s68.addTransition(ScannerTransEntry(2 ,'G' ,0));
   s68.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s68.addTransition(ScannerTransEntry(3 ,'P' ,4));
   s68.addTransition(ScannerTransEntry(3 ,'p' ,4));
   s68.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s68.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s68.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s68.addTransition(ScannerTransEntry(5 ,'s' ,6));
   _scannerList.Insert(s68);

   Scanner s69(GRACE);
   s69.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(2 ,START));
   s69.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(5 ,FINAL));
   s69.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s69.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s69.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s69.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s69.addTransition(ScannerTransEntry(2 ,'G' ,0));
   s69.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s69.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s69.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s69.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s69.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s69);

   Scanner s70(GROUP);
   s70.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(2 ,START));
   s70.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(5 ,FINAL));
   s70.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s70.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s70.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s70.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s70.addTransition(ScannerTransEntry(2 ,'G' ,0));
   s70.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s70.addTransition(ScannerTransEntry(3 ,'U' ,4));
   s70.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s70.addTransition(ScannerTransEntry(4 ,'P' ,5));
   s70.addTransition(ScannerTransEntry(4 ,'p' ,5));
   _scannerList.Insert(s70);

   Scanner s71(HAVING);
   s71.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(2 ,START));
   s71.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(6 ,FINAL));
   s71.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s71.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s71.addTransition(ScannerTransEntry(1 ,'V' ,3));
   s71.addTransition(ScannerTransEntry(1 ,'v' ,3));
   s71.addTransition(ScannerTransEntry(2 ,'H' ,0));
   s71.addTransition(ScannerTransEntry(2 ,'h' ,0));
   s71.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s71.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s71.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s71.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s71.addTransition(ScannerTransEntry(5 ,'G' ,6));
   s71.addTransition(ScannerTransEntry(5 ,'g' ,6));
   _scannerList.Insert(s71);

   Scanner s72(IDENTIFIED);
   s72.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(2 ,START));
   s72.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(10 ,FINAL));
   s72.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s72.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s72.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s72.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s72.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s72.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s72.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s72.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s72.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s72.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s72.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s72.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s72.addTransition(ScannerTransEntry(6 ,'F' ,7));
   s72.addTransition(ScannerTransEntry(6 ,'f' ,7));
   s72.addTransition(ScannerTransEntry(7 ,'I' ,8));
   s72.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s72.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s72.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s72.addTransition(ScannerTransEntry(9 ,'D' ,10));
   s72.addTransition(ScannerTransEntry(9 ,'d' ,10));
   _scannerList.Insert(s72);

   Scanner s73(IF);
   s73.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(1 ,FINAL));
   s73.addState(ScannerStateEntry(2 ,START));
   s73.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s73.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s73.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s73.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s73);

   Scanner s74(INDEX);
   s74.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(2 ,START));
   s74.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(5 ,FINAL));
   s74.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s74.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s74.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s74.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s74.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s74.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s74.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s74.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s74.addTransition(ScannerTransEntry(4 ,'X' ,5));
   s74.addTransition(ScannerTransEntry(4 ,'x' ,5));
   _scannerList.Insert(s74);

   Scanner s75(INTOK);
   s75.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(1 ,FINAL));
   s75.addState(ScannerStateEntry(2 ,START));
   s75.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s75.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s75.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s75.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s75);

   Scanner s76(INNER);
   s76.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(2 ,START));
   s76.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(5 ,FINAL));
   s76.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s76.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s76.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s76.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s76.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s76.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s76.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s76.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s76.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s76.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s76);

   Scanner s77(INT);
   s77.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(2 ,START));
   s77.addState(ScannerStateEntry(3 ,FINAL));
   s77.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s77.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s77.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s77.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s77.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s77.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s77);

   Scanner s78(INTO);
   s78.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(2 ,START));
   s78.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(4 ,FINAL));
   s78.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s78.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s78.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s78.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s78.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s78.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s78.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s78.addTransition(ScannerTransEntry(3 ,'o' ,4));
   _scannerList.Insert(s78);

   Scanner s79(LONG2DATE);
   s79.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(2 ,START));
   s79.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(9 ,FINAL));
   s79.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s79.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s79.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s79.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s79.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s79.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s79.addTransition(ScannerTransEntry(3 ,'G' ,4));
   s79.addTransition(ScannerTransEntry(3 ,'g' ,4));
   s79.addTransition(ScannerTransEntry(4 ,'2' ,5));
   s79.addTransition(ScannerTransEntry(5 ,'D' ,6));
   s79.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s79.addTransition(ScannerTransEntry(6 ,'A' ,7));
   s79.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s79.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s79.addTransition(ScannerTransEntry(7 ,'t' ,8));
   s79.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s79.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s79);

   Scanner s80(NEWDATE);
   s80.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(2 ,START));
   s80.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(7 ,FINAL));
   s80.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s80.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s80.addTransition(ScannerTransEntry(1 ,'W' ,3));
   s80.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s80.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s80.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s80.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s80.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s80.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s80.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s80.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s80.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s80.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s80.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s80);

   Scanner s81(INSERT);
   s81.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(2 ,START));
   s81.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(6 ,FINAL));
   s81.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s81.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s81.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s81.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s81.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s81.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s81.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s81.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s81.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s81.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s81.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s81.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s81);

   Scanner s82(INT2ASC);
   s82.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(2 ,START));
   s82.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(7 ,FINAL));
   s82.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s82.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s82.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s82.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s82.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s82.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s82.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s82.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s82.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s82.addTransition(ScannerTransEntry(5 ,'C' ,6));
   s82.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s82.addTransition(ScannerTransEntry(6 ,'C' ,7));
   s82.addTransition(ScannerTransEntry(6 ,'c' ,7));
   _scannerList.Insert(s82);

   Scanner s83(IS);
   s83.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(1 ,FINAL));
   s83.addState(ScannerStateEntry(2 ,START));
   s83.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s83.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s83.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s83.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s83);

   Scanner s84(ISOLATION);
   s84.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(2 ,START));
   s84.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(9 ,FINAL));
   s84.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s84.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s84.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s84.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s84.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s84.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s84.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s84.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s84.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s84.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s84.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s84.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s84.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s84.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s84.addTransition(ScannerTransEntry(7 ,'O' ,8));
   s84.addTransition(ScannerTransEntry(7 ,'o' ,8));
   s84.addTransition(ScannerTransEntry(8 ,'N' ,9));
   s84.addTransition(ScannerTransEntry(8 ,'n' ,9));
   _scannerList.Insert(s84);

   Scanner s85(JDBC);
   s85.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(2 ,START));
   s85.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(4 ,FINAL));
   s85.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s85.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s85.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s85.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s85.addTransition(ScannerTransEntry(2 ,'J' ,0));
   s85.addTransition(ScannerTransEntry(2 ,'j' ,0));
   s85.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s85.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s85);

   Scanner s86(JOIN);
   s86.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(2 ,START));
   s86.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(4 ,FINAL));
   s86.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s86.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s86.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s86.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s86.addTransition(ScannerTransEntry(2 ,'J' ,0));
   s86.addTransition(ScannerTransEntry(2 ,'j' ,0));
   s86.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s86.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s86);

   Scanner s87(KEY);
   s87.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(2 ,START));
   s87.addState(ScannerStateEntry(3 ,FINAL));
   s87.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s87.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s87.addTransition(ScannerTransEntry(1 ,'Y' ,3));
   s87.addTransition(ScannerTransEntry(1 ,'y' ,3));
   s87.addTransition(ScannerTransEntry(2 ,'K' ,0));
   s87.addTransition(ScannerTransEntry(2 ,'k' ,0));
   _scannerList.Insert(s87);

   Scanner s88(LEFT);
   s88.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(2 ,START));
   s88.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(4 ,FINAL));
   s88.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s88.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s88.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s88.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s88.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s88.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s88.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s88.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s88);

   Scanner s89(LENGTH);
   s89.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(2 ,START));
   s89.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(6 ,FINAL));
   s89.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s89.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s89.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s89.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s89.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s89.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s89.addTransition(ScannerTransEntry(3 ,'G' ,4));
   s89.addTransition(ScannerTransEntry(3 ,'g' ,4));
   s89.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s89.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s89.addTransition(ScannerTransEntry(5 ,'H' ,6));
   s89.addTransition(ScannerTransEntry(5 ,'h' ,6));
   _scannerList.Insert(s89);

   Scanner s90(LIKE);
   s90.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(2 ,START));
   s90.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(4 ,FINAL));
   s90.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s90.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s90.addTransition(ScannerTransEntry(1 ,'K' ,3));
   s90.addTransition(ScannerTransEntry(1 ,'k' ,3));
   s90.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s90.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s90.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s90.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s90);

   Scanner s91(LIST);
   s91.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(2 ,START));
   s91.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(4 ,FINAL));
   s91.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s91.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s91.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s91.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s91.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s91.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s91.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s91.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s91);

   Scanner s92(LDIV);
   s92.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(2 ,START));
   s92.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(4 ,FINAL));
   s92.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s92.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s92.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s92.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s92.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s92.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s92.addTransition(ScannerTransEntry(3 ,'V' ,4));
   s92.addTransition(ScannerTransEntry(3 ,'v' ,4));
   _scannerList.Insert(s92);

   Scanner s93(LMOD);
   s93.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(2 ,START));
   s93.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(4 ,FINAL));
   s93.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s93.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s93.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s93.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s93.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s93.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s93.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s93.addTransition(ScannerTransEntry(3 ,'d' ,4));
   _scannerList.Insert(s93);

   Scanner s94(LOAD);
   s94.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(2 ,START));
   s94.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(4 ,FINAL));
   s94.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s94.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s94.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s94.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s94.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s94.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s94.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s94.addTransition(ScannerTransEntry(3 ,'d' ,4));
   _scannerList.Insert(s94);

   Scanner s95(LOCK);
   s95.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(2 ,START));
   s95.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(4 ,FINAL));
   s95.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s95.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s95.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s95.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s95.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s95.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s95.addTransition(ScannerTransEntry(3 ,'K' ,4));
   s95.addTransition(ScannerTransEntry(3 ,'k' ,4));
   _scannerList.Insert(s95);

   Scanner s96(UNLOCK);
   s96.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(2 ,START));
   s96.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(6 ,FINAL));
   s96.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s96.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s96.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s96.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s96.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s96.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s96.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s96.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s96.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s96.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s96.addTransition(ScannerTransEntry(5 ,'K' ,6));
   s96.addTransition(ScannerTransEntry(5 ,'k' ,6));
   _scannerList.Insert(s96);

   Scanner s97(LONG);
   s97.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(2 ,START));
   s97.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(4 ,FINAL));
   s97.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s97.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s97.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s97.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s97.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s97.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s97.addTransition(ScannerTransEntry(3 ,'G' ,4));
   s97.addTransition(ScannerTransEntry(3 ,'g' ,4));
   _scannerList.Insert(s97);

   Scanner s98(LOWER);
   s98.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(2 ,START));
   s98.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(5 ,FINAL));
   s98.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s98.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s98.addTransition(ScannerTransEntry(1 ,'W' ,3));
   s98.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s98.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s98.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s98.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s98.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s98.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s98.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s98);

   Scanner s99(LTRIM);
   s99.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(2 ,START));
   s99.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(5 ,FINAL));
   s99.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s99.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s99.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s99.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s99.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s99.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s99.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s99.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s99.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s99.addTransition(ScannerTransEntry(4 ,'m' ,5));
   _scannerList.Insert(s99);

   Scanner s100(MIN);
   s100.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(2 ,START));
   s100.addState(ScannerStateEntry(3 ,FINAL));
   s100.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s100.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s100.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s100.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s100.addTransition(ScannerTransEntry(2 ,'M' ,0));
   s100.addTransition(ScannerTransEntry(2 ,'m' ,0));
   _scannerList.Insert(s100);

   Scanner s101(MAX);
   s101.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(2 ,START));
   s101.addState(ScannerStateEntry(3 ,FINAL));
   s101.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s101.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s101.addTransition(ScannerTransEntry(1 ,'X' ,3));
   s101.addTransition(ScannerTransEntry(1 ,'x' ,3));
   s101.addTransition(ScannerTransEntry(2 ,'M' ,0));
   s101.addTransition(ScannerTransEntry(2 ,'m' ,0));
   _scannerList.Insert(s101);

   Scanner s102(MOD);
   s102.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(2 ,START));
   s102.addState(ScannerStateEntry(3 ,FINAL));
   s102.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s102.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s102.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s102.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s102.addTransition(ScannerTransEntry(2 ,'M' ,0));
   s102.addTransition(ScannerTransEntry(2 ,'m' ,0));
   _scannerList.Insert(s102);

   Scanner s103(MODIFY);
   s103.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(2 ,START));
   s103.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(6 ,FINAL));
   s103.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s103.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s103.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s103.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s103.addTransition(ScannerTransEntry(2 ,'M' ,0));
   s103.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s103.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s103.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s103.addTransition(ScannerTransEntry(4 ,'F' ,5));
   s103.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s103.addTransition(ScannerTransEntry(5 ,'Y' ,6));
   s103.addTransition(ScannerTransEntry(5 ,'y' ,6));
   _scannerList.Insert(s103);

   Scanner s104(NEXTCOUNT);
   s104.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(2 ,START));
   s104.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(9 ,FINAL));
   s104.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'X' ,3));
   s104.addTransition(ScannerTransEntry(1 ,'x' ,3));
   s104.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s104.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s104.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s104.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s104.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s104.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s104.addTransition(ScannerTransEntry(5 ,'O' ,6));
   s104.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s104.addTransition(ScannerTransEntry(6 ,'U' ,7));
   s104.addTransition(ScannerTransEntry(6 ,'u' ,7));
   s104.addTransition(ScannerTransEntry(7 ,'N' ,8));
   s104.addTransition(ScannerTransEntry(7 ,'n' ,8));
   s104.addTransition(ScannerTransEntry(8 ,'T' ,9));
   s104.addTransition(ScannerTransEntry(8 ,'t' ,9));
   _scannerList.Insert(s104);

   Scanner s105(NOOP);
   s105.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(2 ,START));
   s105.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(4 ,FINAL));
   s105.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s105.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s105.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s105.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s105.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s105.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s105.addTransition(ScannerTransEntry(3 ,'P' ,4));
   s105.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s105);

   Scanner s106(NOT);
   s106.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(2 ,START));
   s106.addState(ScannerStateEntry(3 ,FINAL));
   s106.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s106.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s106.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s106.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s106.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s106.addTransition(ScannerTransEntry(2 ,'n' ,0));
   _scannerList.Insert(s106);

   Scanner s107(NULLTOKEN);
   s107.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(2 ,START));
   s107.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(4 ,FINAL));
   s107.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s107.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s107.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s107.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s107.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s107.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s107.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s107.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s107);

   Scanner s108(OFF);
   s108.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(2 ,START));
   s108.addState(ScannerStateEntry(3 ,FINAL));
   s108.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s108.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s108.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s108.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s108.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s108.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s108);

   Scanner s109(ON);
   s109.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(1 ,FINAL));
   s109.addState(ScannerStateEntry(2 ,START));
   s109.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s109.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s109.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s109.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s109);

   Scanner s110(OUTTOK);
   s110.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(2 ,START));
   s110.addState(ScannerStateEntry(3 ,FINAL));
   s110.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s110.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s110.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s110.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s110);

   Scanner s111(OUTER);
   s111.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(2 ,START));
   s111.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(5 ,FINAL));
   s111.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s111.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s111.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s111.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s111.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s111.addTransition(ScannerTransEntry(2 ,'o' ,0));
   s111.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s111.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s111.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s111.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s111);

   Scanner s112(OR);
   s112.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(1 ,FINAL));
   s112.addState(ScannerStateEntry(2 ,START));
   s112.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s112.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s112.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s112.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s112);

   Scanner s113(ORDER);
   s113.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(2 ,START));
   s113.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(5 ,FINAL));
   s113.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s113.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s113.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s113.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s113.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s113.addTransition(ScannerTransEntry(2 ,'o' ,0));
   s113.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s113.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s113.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s113.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s113);

   Scanner s114(PLAN);
   s114.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(2 ,START));
   s114.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(4 ,FINAL));
   s114.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s114.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s114.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s114.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s114.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s114.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s114.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s114.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s114);

   Scanner s115(POOL);
   s115.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(2 ,START));
   s115.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(4 ,FINAL));
   s115.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s115.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s115.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s115.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s115.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s115.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s115);

   Scanner s116(POWER);
   s116.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(2 ,START));
   s116.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(5 ,FINAL));
   s116.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s116.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s116.addTransition(ScannerTransEntry(1 ,'W' ,3));
   s116.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s116.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s116.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s116.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s116.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s116.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s116.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s116);

   Scanner s117(PRIMARY);
   s117.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(2 ,START));
   s117.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(7 ,FINAL));
   s117.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s117.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s117.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s117.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s117.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s117.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s117.addTransition(ScannerTransEntry(3 ,'M' ,4));
   s117.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s117.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s117.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s117.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s117.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s117.addTransition(ScannerTransEntry(6 ,'Y' ,7));
   s117.addTransition(ScannerTransEntry(6 ,'y' ,7));
   _scannerList.Insert(s117);

   Scanner s118(PRINT);
   s118.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(2 ,START));
   s118.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(5 ,FINAL));
   s118.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s118.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s118.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s118.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s118.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s118.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s118.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s118.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s118.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s118.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s118);

   Scanner s119(PROCEDURE);
   s119.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(2 ,START));
   s119.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(9 ,FINAL));
   s119.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s119.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s119.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s119.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s119.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s119.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s119.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s119.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s119.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s119.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s119.addTransition(ScannerTransEntry(5 ,'D' ,6));
   s119.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s119.addTransition(ScannerTransEntry(6 ,'U' ,7));
   s119.addTransition(ScannerTransEntry(6 ,'u' ,7));
   s119.addTransition(ScannerTransEntry(7 ,'R' ,8));
   s119.addTransition(ScannerTransEntry(7 ,'r' ,8));
   s119.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s119.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s119);

   Scanner s120(QUIT);
   s120.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(2 ,START));
   s120.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(4 ,FINAL));
   s120.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s120.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s120.addTransition(ScannerTransEntry(2 ,'Q' ,0));
   s120.addTransition(ScannerTransEntry(2 ,'q' ,0));
   s120.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s120.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s120);

   Scanner s121(RANDSTR);
   s121.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(2 ,START));
   s121.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(7 ,FINAL));
   s121.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s121.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s121.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s121.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s121.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s121.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s121.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s121.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s121.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s121.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s121.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s121.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s121.addTransition(ScannerTransEntry(6 ,'R' ,7));
   s121.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s121);

   Scanner s122(RANDINT);
   s122.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(2 ,START));
   s122.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(7 ,FINAL));
   s122.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s122.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s122.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s122.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s122.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s122.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s122.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s122.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s122.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s122.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s122.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s122.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s122.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s122.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s122);

   Scanner s123(RBSEG);
   s123.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(2 ,START));
   s123.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(5 ,FINAL));
   s123.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s123.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s123.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s123.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s123.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s123.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s123.addTransition(ScannerTransEntry(4 ,'G' ,5));
   s123.addTransition(ScannerTransEntry(4 ,'g' ,5));
   _scannerList.Insert(s123);

   Scanner s124(REFERENCES);
   s124.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(2 ,START));
   s124.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(10 ,FINAL));
   s124.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s124.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s124.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s124.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s124.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s124.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s124.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s124.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s124.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s124.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s124.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s124.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s124.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s124.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s124.addTransition(ScannerTransEntry(7 ,'C' ,8));
   s124.addTransition(ScannerTransEntry(7 ,'c' ,8));
   s124.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s124.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s124.addTransition(ScannerTransEntry(9 ,'S' ,10));
   s124.addTransition(ScannerTransEntry(9 ,'s' ,10));
   _scannerList.Insert(s124);

   Scanner s125(RENAME);
   s125.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(2 ,START));
   s125.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(6 ,FINAL));
   s125.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s125.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s125.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s125.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s125.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s125.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s125.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s125.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s125.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s125.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s125.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s125.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s125);

   Scanner s126(REORGANIZE);
   s126.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(2 ,START));
   s126.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(10 ,FINAL));
   s126.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s126.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s126.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s126.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s126.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s126.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s126.addTransition(ScannerTransEntry(3 ,'R' ,4));
   s126.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s126.addTransition(ScannerTransEntry(4 ,'G' ,5));
   s126.addTransition(ScannerTransEntry(4 ,'g' ,5));
   s126.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s126.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s126.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s126.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s126.addTransition(ScannerTransEntry(7 ,'I' ,8));
   s126.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s126.addTransition(ScannerTransEntry(8 ,'Z' ,9));
   s126.addTransition(ScannerTransEntry(8 ,'z' ,9));
   s126.addTransition(ScannerTransEntry(9 ,'E' ,10));
   s126.addTransition(ScannerTransEntry(9 ,'e' ,10));
   _scannerList.Insert(s126);

   Scanner s127(RETURNTOKEN);
   s127.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(2 ,START));
   s127.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(6 ,FINAL));
   s127.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s127.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s127.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s127.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s127.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s127.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s127.addTransition(ScannerTransEntry(3 ,'U' ,4));
   s127.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s127.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s127.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s127.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s127.addTransition(ScannerTransEntry(5 ,'n' ,6));
   _scannerList.Insert(s127);

   Scanner s128(REMOVE);
   s128.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(2 ,START));
   s128.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(6 ,FINAL));
   s128.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s128.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s128.addTransition(ScannerTransEntry(1 ,'M' ,3));
   s128.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s128.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s128.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s128.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s128.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s128.addTransition(ScannerTransEntry(4 ,'V' ,5));
   s128.addTransition(ScannerTransEntry(4 ,'v' ,5));
   s128.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s128.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s128);

   Scanner s129(REPLACE);
   s129.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(2 ,START));
   s129.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(7 ,FINAL));
   s129.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s129.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s129.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s129.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s129.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s129.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s129.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s129.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s129.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s129.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s129.addTransition(ScannerTransEntry(5 ,'C' ,6));
   s129.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s129.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s129.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s129);

   Scanner s130(RIGHT);
   s130.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(2 ,START));
   s130.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(5 ,FINAL));
   s130.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s130.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s130.addTransition(ScannerTransEntry(1 ,'G' ,3));
   s130.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s130.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s130.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s130.addTransition(ScannerTransEntry(3 ,'H' ,4));
   s130.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s130.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s130.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s130);

   Scanner s131(ROLLBACK);
   s131.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(2 ,START));
   s131.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(8 ,FINAL));
   s131.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s131.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s131.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s131.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s131.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s131.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s131.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s131.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s131.addTransition(ScannerTransEntry(4 ,'B' ,5));
   s131.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s131.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s131.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s131.addTransition(ScannerTransEntry(6 ,'C' ,7));
   s131.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s131.addTransition(ScannerTransEntry(7 ,'K' ,8));
   s131.addTransition(ScannerTransEntry(7 ,'k' ,8));
   _scannerList.Insert(s131);

   Scanner s132(ROUND);
   s132.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(2 ,START));
   s132.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(5 ,FINAL));
   s132.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s132.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s132.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s132.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s132.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s132.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s132.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s132.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s132.addTransition(ScannerTransEntry(4 ,'D' ,5));
   s132.addTransition(ScannerTransEntry(4 ,'d' ,5));
   _scannerList.Insert(s132);

   Scanner s133(ROWLIMIT);
   s133.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(2 ,START));
   s133.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(8 ,FINAL));
   s133.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s133.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s133.addTransition(ScannerTransEntry(1 ,'W' ,3));
   s133.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s133.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s133.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s133.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s133.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s133.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s133.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s133.addTransition(ScannerTransEntry(5 ,'M' ,6));
   s133.addTransition(ScannerTransEntry(5 ,'m' ,6));
   s133.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s133.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s133.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s133.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s133);

   Scanner s134(RTRIM);
   s134.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(2 ,START));
   s134.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(5 ,FINAL));
   s134.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s134.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s134.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s134.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s134.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s134.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s134.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s134.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s134.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s134.addTransition(ScannerTransEntry(4 ,'m' ,5));
   _scannerList.Insert(s134);

   Scanner s135(SCANDATE);
   s135.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(2 ,START));
   s135.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(8 ,FINAL));
   s135.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s135.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s135.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s135.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s135.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s135.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s135.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s135.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s135.addTransition(ScannerTransEntry(4 ,'D' ,5));
   s135.addTransition(ScannerTransEntry(4 ,'d' ,5));
   s135.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s135.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s135.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s135.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s135.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s135.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s135);

   Scanner s136(SELECT);
   s136.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(2 ,START));
   s136.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(6 ,FINAL));
   s136.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s136.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s136.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s136.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s136.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s136.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s136.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s136.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s136.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s136.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s136.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s136.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s136);

   Scanner s137(SET);
   s137.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(2 ,START));
   s137.addState(ScannerStateEntry(3 ,FINAL));
   s137.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s137.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s137.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s137.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s137.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s137.addTransition(ScannerTransEntry(2 ,'s' ,0));
   _scannerList.Insert(s137);

   Scanner s138(SETCOUNT);
   s138.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(2 ,START));
   s138.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(8 ,FINAL));
   s138.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s138.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s138.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s138.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s138.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s138.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s138.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s138.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s138.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s138.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s138.addTransition(ScannerTransEntry(5 ,'U' ,6));
   s138.addTransition(ScannerTransEntry(5 ,'u' ,6));
   s138.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s138.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s138.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s138.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s138);

   Scanner s139(SHOW);
   s139.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(2 ,START));
   s139.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(4 ,FINAL));
   s139.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s139.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s139.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s139.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s139.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s139.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s139.addTransition(ScannerTransEntry(3 ,'W' ,4));
   s139.addTransition(ScannerTransEntry(3 ,'w' ,4));
   _scannerList.Insert(s139);

   Scanner s140(SMALLINT);
   s140.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(2 ,START));
   s140.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(8 ,FINAL));
   s140.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s140.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s140.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s140.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s140.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s140.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s140.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s140.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s140.addTransition(ScannerTransEntry(4 ,'L' ,5));
   s140.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s140.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s140.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s140.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s140.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s140.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s140.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s140);

   Scanner s141(START_TOKEN);
   s141.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(2 ,START));
   s141.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(5 ,FINAL));
   s141.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s141.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s141.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s141.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s141.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s141.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s141.addTransition(ScannerTransEntry(3 ,'R' ,4));
   s141.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s141.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s141.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s141);

   Scanner s142(STRING);
   s142.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(2 ,START));
   s142.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(6 ,FINAL));
   s142.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s142.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s142.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s142.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s142.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s142.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s142.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s142.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s142.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s142.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s142.addTransition(ScannerTransEntry(5 ,'G' ,6));
   s142.addTransition(ScannerTransEntry(5 ,'g' ,6));
   _scannerList.Insert(s142);

   Scanner s143(SUBSTR);
   s143.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(2 ,START));
   s143.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(6 ,FINAL));
   s143.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s143.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s143.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s143.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s143.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s143.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s143.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s143.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s143.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s143.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s143.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s143.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s143);

   Scanner s144(SUM);
   s144.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(2 ,START));
   s144.addState(ScannerStateEntry(3 ,FINAL));
   s144.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s144.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s144.addTransition(ScannerTransEntry(1 ,'M' ,3));
   s144.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s144.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s144.addTransition(ScannerTransEntry(2 ,'s' ,0));
   _scannerList.Insert(s144);

   Scanner s145(SYNC);
   s145.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(2 ,START));
   s145.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(4 ,FINAL));
   s145.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s145.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s145.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s145.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s145.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s145.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s145.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s145.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s145);

   Scanner s146(SYSDATE);
   s146.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(2 ,START));
   s146.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(7 ,FINAL));
   s146.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s146.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s146.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s146.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s146.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s146.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s146.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s146.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s146.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s146.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s146.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s146.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s146.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s146.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s146);

   Scanner s147(SYSTEMSPACE);
   s147.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(2 ,START));
   s147.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(11 ,FINAL));
   s147.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s147.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s147.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s147.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s147.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s147.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s147.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s147.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s147.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s147.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s147.addTransition(ScannerTransEntry(5 ,'M' ,6));
   s147.addTransition(ScannerTransEntry(5 ,'m' ,6));
   s147.addTransition(ScannerTransEntry(6 ,'S' ,7));
   s147.addTransition(ScannerTransEntry(6 ,'s' ,7));
   s147.addTransition(ScannerTransEntry(7 ,'P' ,8));
   s147.addTransition(ScannerTransEntry(7 ,'p' ,8));
   s147.addTransition(ScannerTransEntry(8 ,'A' ,9));
   s147.addTransition(ScannerTransEntry(8 ,'a' ,9));
   s147.addTransition(ScannerTransEntry(9 ,'C' ,10));
   s147.addTransition(ScannerTransEntry(9 ,'c' ,10));
   s147.addTransition(ScannerTransEntry(10 ,'E' ,11));
   s147.addTransition(ScannerTransEntry(10 ,'e' ,11));
   _scannerList.Insert(s147);

   Scanner s148(SYSOBJ);
   s148.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(2 ,START));
   s148.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(6 ,FINAL));
   s148.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s148.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s148.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s148.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s148.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s148.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s148.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s148.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s148.addTransition(ScannerTransEntry(4 ,'B' ,5));
   s148.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s148.addTransition(ScannerTransEntry(5 ,'J' ,6));
   s148.addTransition(ScannerTransEntry(5 ,'j' ,6));
   _scannerList.Insert(s148);

   Scanner s149(TABLEINFO);
   s149.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(2 ,START));
   s149.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(9 ,FINAL));
   s149.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s149.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s149.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s149.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s149.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s149.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s149.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s149.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s149.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s149.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s149.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s149.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s149.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s149.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s149.addTransition(ScannerTransEntry(7 ,'F' ,8));
   s149.addTransition(ScannerTransEntry(7 ,'f' ,8));
   s149.addTransition(ScannerTransEntry(8 ,'O' ,9));
   s149.addTransition(ScannerTransEntry(8 ,'o' ,9));
   _scannerList.Insert(s149);

   Scanner s150(TABLESIZE);
   s150.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(2 ,START));
   s150.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(9 ,FINAL));
   s150.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s150.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s150.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s150.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s150.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s150.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s150.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s150.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s150.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s150.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s150.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s150.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s150.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s150.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s150.addTransition(ScannerTransEntry(7 ,'Z' ,8));
   s150.addTransition(ScannerTransEntry(7 ,'z' ,8));
   s150.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s150.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s150);

   Scanner s151(TABLE);
   s151.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(2 ,START));
   s151.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(5 ,FINAL));
   s151.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s151.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s151.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s151.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s151.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s151.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s151.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s151.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s151.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s151.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s151);

   Scanner s152(TABLESET);
   s152.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(2 ,START));
   s152.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(8 ,FINAL));
   s152.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s152.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s152.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s152.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s152.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s152.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s152.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s152.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s152.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s152.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s152.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s152.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s152.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s152.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s152.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s152.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s152);

   Scanner s153(THEN);
   s153.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(2 ,START));
   s153.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(4 ,FINAL));
   s153.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s153.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s153.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s153.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s153.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s153.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s153.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s153.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s153);

   Scanner s154(THROW);
   s154.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(2 ,START));
   s154.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(5 ,FINAL));
   s154.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s154.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s154.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s154.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s154.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s154.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s154.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s154.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s154.addTransition(ScannerTransEntry(4 ,'W' ,5));
   s154.addTransition(ScannerTransEntry(4 ,'w' ,5));
   _scannerList.Insert(s154);

   Scanner s155(TINYINT);
   s155.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(2 ,START));
   s155.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(7 ,FINAL));
   s155.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s155.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s155.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s155.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s155.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s155.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s155.addTransition(ScannerTransEntry(3 ,'Y' ,4));
   s155.addTransition(ScannerTransEntry(3 ,'y' ,4));
   s155.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s155.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s155.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s155.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s155.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s155.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s155);

   Scanner s156(TMPOBJ);
   s156.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(2 ,START));
   s156.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(6 ,FINAL));
   s156.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s156.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s156.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s156.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s156.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s156.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s156.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s156.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s156.addTransition(ScannerTransEntry(4 ,'B' ,5));
   s156.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s156.addTransition(ScannerTransEntry(5 ,'J' ,6));
   s156.addTransition(ScannerTransEntry(5 ,'j' ,6));
   _scannerList.Insert(s156);

   Scanner s157(TRANSACTION);
   s157.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(2 ,START));
   s157.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(11 ,FINAL));
   s157.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s157.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s157.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s157.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s157.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s157.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s157.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s157.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s157.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s157.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s157.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s157.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s157.addTransition(ScannerTransEntry(6 ,'C' ,7));
   s157.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s157.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s157.addTransition(ScannerTransEntry(7 ,'t' ,8));
   s157.addTransition(ScannerTransEntry(8 ,'I' ,9));
   s157.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s157.addTransition(ScannerTransEntry(9 ,'O' ,10));
   s157.addTransition(ScannerTransEntry(9 ,'o' ,10));
   s157.addTransition(ScannerTransEntry(10 ,'N' ,11));
   s157.addTransition(ScannerTransEntry(10 ,'n' ,11));
   _scannerList.Insert(s157);

   Scanner s158(TRIGGER);
   s158.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(2 ,START));
   s158.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(7 ,FINAL));
   s158.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s158.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s158.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s158.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s158.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s158.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s158.addTransition(ScannerTransEntry(3 ,'G' ,4));
   s158.addTransition(ScannerTransEntry(3 ,'g' ,4));
   s158.addTransition(ScannerTransEntry(4 ,'G' ,5));
   s158.addTransition(ScannerTransEntry(4 ,'g' ,5));
   s158.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s158.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s158.addTransition(ScannerTransEntry(6 ,'R' ,7));
   s158.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s158);

   Scanner s159(TUPLEINFO);
   s159.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(2 ,START));
   s159.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(9 ,FINAL));
   s159.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s159.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s159.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s159.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s159.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s159.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s159.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s159.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s159.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s159.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s159.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s159.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s159.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s159.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s159.addTransition(ScannerTransEntry(7 ,'F' ,8));
   s159.addTransition(ScannerTransEntry(7 ,'f' ,8));
   s159.addTransition(ScannerTransEntry(8 ,'O' ,9));
   s159.addTransition(ScannerTransEntry(8 ,'o' ,9));
   _scannerList.Insert(s159);

   Scanner s160(STR2INT);
   s160.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(2 ,START));
   s160.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(7 ,FINAL));
   s160.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s160.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s160.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s160.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s160.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s160.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s160.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s160.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s160.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s160.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s160.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s160.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s160.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s160);

   Scanner s161(STR2LONG);
   s161.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s161.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s161.addState(ScannerStateEntry(2 ,START));
   s161.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s161.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s161.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s161.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s161.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s161.addState(ScannerStateEntry(8 ,FINAL));
   s161.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s161.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s161.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s161.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s161.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s161.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s161.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s161.addTransition(ScannerTransEntry(4 ,'L' ,5));
   s161.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s161.addTransition(ScannerTransEntry(5 ,'O' ,6));
   s161.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s161.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s161.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s161.addTransition(ScannerTransEntry(7 ,'G' ,8));
   s161.addTransition(ScannerTransEntry(7 ,'g' ,8));
   _scannerList.Insert(s161);

   Scanner s162(TO);
   s162.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s162.addState(ScannerStateEntry(1 ,FINAL));
   s162.addState(ScannerStateEntry(2 ,START));
   s162.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s162.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s162.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s162.addTransition(ScannerTransEntry(2 ,'t' ,0));
   _scannerList.Insert(s162);

   Scanner s163(TRIM);
   s163.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s163.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s163.addState(ScannerStateEntry(2 ,START));
   s163.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s163.addState(ScannerStateEntry(4 ,FINAL));
   s163.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s163.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s163.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s163.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s163.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s163.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s163.addTransition(ScannerTransEntry(3 ,'M' ,4));
   s163.addTransition(ScannerTransEntry(3 ,'m' ,4));
   _scannerList.Insert(s163);

   Scanner s164(TRUEVAL);
   s164.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s164.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s164.addState(ScannerStateEntry(2 ,START));
   s164.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s164.addState(ScannerStateEntry(4 ,FINAL));
   s164.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s164.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s164.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s164.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s164.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s164.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s164.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s164.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s164);

   Scanner s165(TRUNC);
   s165.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s165.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s165.addState(ScannerStateEntry(2 ,START));
   s165.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s165.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s165.addState(ScannerStateEntry(5 ,FINAL));
   s165.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s165.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s165.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s165.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s165.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s165.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s165.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s165.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s165.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s165.addTransition(ScannerTransEntry(4 ,'c' ,5));
   _scannerList.Insert(s165);

   Scanner s166(TRUNCATE);
   s166.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s166.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s166.addState(ScannerStateEntry(2 ,START));
   s166.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s166.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s166.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s166.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s166.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s166.addState(ScannerStateEntry(8 ,FINAL));
   s166.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s166.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s166.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s166.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s166.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s166.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s166.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s166.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s166.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s166.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s166.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s166.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s166.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s166.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s166.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s166.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s166);

   Scanner s167(UNION);
   s167.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s167.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s167.addState(ScannerStateEntry(2 ,START));
   s167.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s167.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s167.addState(ScannerStateEntry(5 ,FINAL));
   s167.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s167.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s167.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s167.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s167.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s167.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s167.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s167.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s167.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s167.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s167);

   Scanner s168(UNIQUE);
   s168.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s168.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s168.addState(ScannerStateEntry(2 ,START));
   s168.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s168.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s168.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s168.addState(ScannerStateEntry(6 ,FINAL));
   s168.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s168.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s168.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s168.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s168.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s168.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s168.addTransition(ScannerTransEntry(3 ,'Q' ,4));
   s168.addTransition(ScannerTransEntry(3 ,'q' ,4));
   s168.addTransition(ScannerTransEntry(4 ,'U' ,5));
   s168.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s168.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s168.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s168);

   Scanner s169(UPDATE);
   s169.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s169.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s169.addState(ScannerStateEntry(2 ,START));
   s169.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s169.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s169.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s169.addState(ScannerStateEntry(6 ,FINAL));
   s169.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s169.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s169.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s169.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s169.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s169.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s169.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s169.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s169.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s169.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s169.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s169.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s169);

   Scanner s170(UPTIME);
   s170.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s170.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s170.addState(ScannerStateEntry(2 ,START));
   s170.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s170.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s170.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s170.addState(ScannerStateEntry(6 ,FINAL));
   s170.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s170.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s170.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s170.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s170.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s170.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s170.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s170.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s170.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s170.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s170.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s170.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s170);

   Scanner s171(UPPER);
   s171.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s171.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s171.addState(ScannerStateEntry(2 ,START));
   s171.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s171.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s171.addState(ScannerStateEntry(5 ,FINAL));
   s171.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s171.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s171.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s171.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s171.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s171.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s171.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s171.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s171);

   Scanner s172(VAR);
   s172.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s172.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s172.addState(ScannerStateEntry(2 ,START));
   s172.addState(ScannerStateEntry(3 ,FINAL));
   s172.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s172.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s172.addTransition(ScannerTransEntry(2 ,'V' ,0));
   s172.addTransition(ScannerTransEntry(2 ,'v' ,0));
   _scannerList.Insert(s172);

   Scanner s173(VALUES);
   s173.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s173.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s173.addState(ScannerStateEntry(2 ,START));
   s173.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s173.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s173.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s173.addState(ScannerStateEntry(6 ,FINAL));
   s173.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s173.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'V' ,0));
   s173.addTransition(ScannerTransEntry(2 ,'v' ,0));
   s173.addTransition(ScannerTransEntry(3 ,'U' ,4));
   s173.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s173.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s173.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s173.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s173.addTransition(ScannerTransEntry(5 ,'s' ,6));
   _scannerList.Insert(s173);

   Scanner s174(VIEW);
   s174.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s174.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s174.addState(ScannerStateEntry(2 ,START));
   s174.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s174.addState(ScannerStateEntry(4 ,FINAL));
   s174.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s174.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s174.addTransition(ScannerTransEntry(2 ,'V' ,0));
   s174.addTransition(ScannerTransEntry(2 ,'v' ,0));
   s174.addTransition(ScannerTransEntry(3 ,'W' ,4));
   s174.addTransition(ScannerTransEntry(3 ,'w' ,4));
   _scannerList.Insert(s174);

   Scanner s175(WHEN);
   s175.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s175.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s175.addState(ScannerStateEntry(2 ,START));
   s175.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s175.addState(ScannerStateEntry(4 ,FINAL));
   s175.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s175.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'W' ,0));
   s175.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s175.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s175.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s175);

   Scanner s176(WHERE);
   s176.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s176.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s176.addState(ScannerStateEntry(2 ,START));
   s176.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s176.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s176.addState(ScannerStateEntry(5 ,FINAL));
   s176.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s176.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s176.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s176.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s176.addTransition(ScannerTransEntry(2 ,'W' ,0));
   s176.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s176.addTransition(ScannerTransEntry(3 ,'R' ,4));
   s176.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s176.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s176.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s176);

   Scanner s177(WHILE);
   s177.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s177.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s177.addState(ScannerStateEntry(2 ,START));
   s177.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s177.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s177.addState(ScannerStateEntry(5 ,FINAL));
   s177.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s177.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s177.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s177.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s177.addTransition(ScannerTransEntry(2 ,'W' ,0));
   s177.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s177.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s177.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s177.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s177.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s177);

   Scanner s178(CONCAT);
   s178.addState(ScannerStateEntry(0 ,START));
   s178.addState(ScannerStateEntry(1 ,FINAL));
   s178.addTransition(ScannerTransEntry(0 ,'|' ,1));
   _scannerList.Insert(s178);

   Scanner s179(EQU);
   s179.addState(ScannerStateEntry(0 ,START));
   s179.addState(ScannerStateEntry(1 ,FINAL));
   s179.addTransition(ScannerTransEntry(0 ,'=' ,1));
   _scannerList.Insert(s179);

   Scanner s180(KSEP);
   s180.addState(ScannerStateEntry(0 ,START));
   s180.addState(ScannerStateEntry(1 ,FINAL));
   s180.addTransition(ScannerTransEntry(0 ,',' ,1));
   _scannerList.Insert(s180);

   Scanner s181(LB);
   s181.addState(ScannerStateEntry(0 ,START));
   s181.addState(ScannerStateEntry(1 ,FINAL));
   s181.addTransition(ScannerTransEntry(0 ,'(' ,1));
   _scannerList.Insert(s181);

   Scanner s182(LT);
   s182.addState(ScannerStateEntry(0 ,START));
   s182.addState(ScannerStateEntry(1 ,FINAL));
   s182.addTransition(ScannerTransEntry(0 ,'<' ,1));
   _scannerList.Insert(s182);

   Scanner s183(MT);
   s183.addState(ScannerStateEntry(0 ,START));
   s183.addState(ScannerStateEntry(1 ,FINAL));
   s183.addTransition(ScannerTransEntry(0 ,'>' ,1));
   _scannerList.Insert(s183);

   Scanner s184(NEGATION);
   s184.addState(ScannerStateEntry(0 ,START));
   s184.addState(ScannerStateEntry(1 ,FINAL));
   s184.addTransition(ScannerTransEntry(0 ,'!' ,1));
   _scannerList.Insert(s184);

   Scanner s185(RB);
   s185.addState(ScannerStateEntry(0 ,START));
   s185.addState(ScannerStateEntry(1 ,FINAL));
   s185.addTransition(ScannerTransEntry(0 ,')' ,1));
   _scannerList.Insert(s185);

   Scanner s186(LAB);
   s186.addState(ScannerStateEntry(0 ,START));
   s186.addState(ScannerStateEntry(1 ,FINAL));
   s186.addTransition(ScannerTransEntry(0 ,'[' ,1));
   _scannerList.Insert(s186);

   Scanner s187(RAB);
   s187.addState(ScannerStateEntry(0 ,START));
   s187.addState(ScannerStateEntry(1 ,FINAL));
   s187.addTransition(ScannerTransEntry(0 ,']' ,1));
   _scannerList.Insert(s187);

   Scanner s188(SEMICOLON);
   s188.addState(ScannerStateEntry(0 ,START));
   s188.addState(ScannerStateEntry(1 ,FINAL));
   s188.addTransition(ScannerTransEntry(0 ,';' ,1));
   _scannerList.Insert(s188);

   Scanner s189(STAR);
   s189.addState(ScannerStateEntry(0 ,START));
   s189.addState(ScannerStateEntry(1 ,FINAL));
   s189.addTransition(ScannerTransEntry(0 ,'*' ,1));
   _scannerList.Insert(s189);

   Scanner s190(DIVISION);
   s190.addState(ScannerStateEntry(0 ,START));
   s190.addState(ScannerStateEntry(1 ,FINAL));
   s190.addTransition(ScannerTransEntry(0 ,'/' ,1));
   _scannerList.Insert(s190);

   Scanner s191(MINUS);
   s191.addState(ScannerStateEntry(0 ,START));
   s191.addState(ScannerStateEntry(1 ,FINAL));
   s191.addTransition(ScannerTransEntry(0 ,'-' ,1));
   _scannerList.Insert(s191);

   Scanner s192(PLUS);
   s192.addState(ScannerStateEntry(0 ,START));
   s192.addState(ScannerStateEntry(1 ,FINAL));
   s192.addTransition(ScannerTransEntry(0 ,'+' ,1));
   _scannerList.Insert(s192);

   Scanner s193(INTVAL);
   s193.addState(ScannerStateEntry(0 ,START));
   s193.addState(ScannerStateEntry(1 ,FINAL));
   s193.addState(ScannerStateEntry(2 ,FINAL));
   s193.addTransition(ScannerTransEntry(0 ,'1' ,1));
   s193.addTransition(ScannerTransEntry(0 ,'2' ,1));
   s193.addTransition(ScannerTransEntry(0 ,'3' ,1));
   s193.addTransition(ScannerTransEntry(0 ,'4' ,1));
   s193.addTransition(ScannerTransEntry(0 ,'5' ,1));
   s193.addTransition(ScannerTransEntry(0 ,'6' ,1));
   s193.addTransition(ScannerTransEntry(0 ,'7' ,1));
   s193.addTransition(ScannerTransEntry(0 ,'8' ,1));
   s193.addTransition(ScannerTransEntry(0 ,'9' ,1));
   s193.addTransition(ScannerTransEntry(0 ,'0' ,2));
   s193.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'9' ,1));
   _scannerList.Insert(s193);

   Scanner s194(FLOATVAL);
   s194.addState(ScannerStateEntry(0 ,START));
   s194.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s194.addState(ScannerStateEntry(2 ,INTERMEDIATE));
   s194.addState(ScannerStateEntry(3 ,FINAL));
   s194.addTransition(ScannerTransEntry(0 ,'1' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'2' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'3' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'4' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'5' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'6' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'7' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'8' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'9' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'0' ,2));
   s194.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'.' ,3));
   s194.addTransition(ScannerTransEntry(2 ,'.' ,3));
   s194.addTransition(ScannerTransEntry(3 ,'0' ,3));
   s194.addTransition(ScannerTransEntry(3 ,'1' ,3));
   s194.addTransition(ScannerTransEntry(3 ,'2' ,3));
   s194.addTransition(ScannerTransEntry(3 ,'3' ,3));
   s194.addTransition(ScannerTransEntry(3 ,'4' ,3));
   s194.addTransition(ScannerTransEntry(3 ,'5' ,3));
   s194.addTransition(ScannerTransEntry(3 ,'6' ,3));
   s194.addTransition(ScannerTransEntry(3 ,'7' ,3));
   s194.addTransition(ScannerTransEntry(3 ,'8' ,3));
   s194.addTransition(ScannerTransEntry(3 ,'9' ,3));
   _scannerList.Insert(s194);

   Scanner s195(IDENTIFIER);
   s195.addState(ScannerStateEntry(0 ,START));
   s195.addState(ScannerStateEntry(1 ,FINAL));
   s195.addTransition(ScannerTransEntry(0 ,'$' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'z' ,1));
   _scannerList.Insert(s195);

   Scanner s196(VARREF);
   s196.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s196.addState(ScannerStateEntry(1 ,FINAL));
   s196.addState(ScannerStateEntry(2 ,START));
   s196.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s196.addTransition(ScannerTransEntry(2 ,':' ,0));
   _scannerList.Insert(s196);

   Scanner s197(QUALIFIEDOBJ);
   s197.addState(ScannerStateEntry(0 ,START));
   s197.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s197.addState(ScannerStateEntry(2 ,INTERMEDIATE));
   s197.addState(ScannerStateEntry(3 ,FINAL));
   s197.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'.' ,2));
   s197.addTransition(ScannerTransEntry(2 ,'$' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'A' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'B' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'C' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'D' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'E' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'F' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'G' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'H' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'I' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'J' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'K' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'L' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'M' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'N' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'O' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'P' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'Q' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'R' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'S' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'T' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'U' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'V' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'W' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'X' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'Y' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'Z' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'a' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'b' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'c' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'d' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'e' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'f' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'g' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'h' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'i' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'j' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'k' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'l' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'m' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'n' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'o' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'p' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'q' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'r' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'s' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'t' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'u' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'v' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'w' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'x' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'y' ,3));
   s197.addTransition(ScannerTransEntry(2 ,'z' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'0' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'1' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'2' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'3' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'4' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'5' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'6' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'7' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'8' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'9' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'A' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'B' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'C' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'D' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'E' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'F' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'G' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'H' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'I' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'J' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'K' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'L' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'M' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'N' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'O' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'P' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'Q' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'R' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'S' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'T' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'U' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'V' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'W' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'X' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'Y' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'Z' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'_' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'a' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'b' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'c' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'d' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'e' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'f' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'g' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'h' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'i' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'j' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'k' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'l' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'m' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'n' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'o' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'p' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'q' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'r' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'s' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'t' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'u' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'v' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'w' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'x' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'y' ,3));
   s197.addTransition(ScannerTransEntry(3 ,'z' ,3));
   _scannerList.Insert(s197);

   Scanner s198(QUALIFIEDPRE);
   s198.addState(ScannerStateEntry(0 ,START));
   s198.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s198.addState(ScannerStateEntry(2 ,FINAL));
   s198.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'.' ,2));
   _scannerList.Insert(s198);

   Scanner s199(QUALIFIEDTS);
   s199.addState(ScannerStateEntry(0 ,START));
   s199.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s199.addState(ScannerStateEntry(2 ,INTERMEDIATE));
   s199.addState(ScannerStateEntry(3 ,FINAL));
   s199.addTransition(ScannerTransEntry(0 ,'$' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'@' ,2));
   s199.addTransition(ScannerTransEntry(2 ,'A' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'B' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'C' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'D' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'E' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'F' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'G' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'H' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'I' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'J' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'K' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'L' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'M' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'N' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'O' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'P' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'Q' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'R' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'S' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'T' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'U' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'V' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'W' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'X' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'Y' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'Z' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'a' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'b' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'c' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'d' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'e' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'f' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'g' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'h' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'i' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'j' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'k' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'l' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'m' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'n' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'o' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'p' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'q' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'r' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'s' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'t' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'u' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'v' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'w' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'x' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'y' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'z' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'0' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'1' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'2' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'3' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'4' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'5' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'6' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'7' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'8' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'9' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'A' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'B' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'C' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'D' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'E' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'F' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'G' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'H' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'I' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'J' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'K' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'L' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'M' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'N' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'O' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'P' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'Q' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'R' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'S' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'T' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'U' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'V' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'W' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'X' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'Y' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'Z' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'_' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'a' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'b' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'c' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'d' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'e' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'f' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'g' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'h' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'i' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'j' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'k' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'l' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'m' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'n' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'o' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'p' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'q' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'r' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'s' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'t' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'u' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'v' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'w' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'x' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'y' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'z' ,3));
   _scannerList.Insert(s199);

}
void Cego::loadParser0()
{
   _actionMap[937][SEMICOLON] = ActionEntry(REDUCE, 88);
   _actionMap[936][RB] = ActionEntry(SHIFT, 937);
   _actionMap[935][IDENTIFIER] = ActionEntry(SHIFT, 812);
   _jumpMap[935][SimpleAttr] = 811;
   _jumpMap[935][SimpleAttrList] = 936;
   _actionMap[933][LB] = ActionEntry(SHIFT, 935);
   _actionMap[934][ROWLIMIT] = ActionEntry(REDUCE, 208);
   _actionMap[934][UNION] = ActionEntry(REDUCE, 208);
   _actionMap[934][ENDTOKEN] = ActionEntry(REDUCE, 208);
   _actionMap[934][RB] = ActionEntry(REDUCE, 208);
   _actionMap[934][SEMICOLON] = ActionEntry(REDUCE, 208);
   _actionMap[934][KSEP] = ActionEntry(REDUCE, 208);
   _actionMap[930][IDENTIFIER] = ActionEntry(SHIFT, 933);
   _actionMap[931][SEMICOLON] = ActionEntry(REDUCE, 220);
   _actionMap[931][RB] = ActionEntry(REDUCE, 220);
   _actionMap[932][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[932][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[932][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[932][ASC] = ActionEntry(SHIFT, 924);
   _actionMap[932][ROWLIMIT] = ActionEntry(REDUCE, 213);
   _actionMap[932][DESC] = ActionEntry(SHIFT, 925);
   _actionMap[932][UNION] = ActionEntry(REDUCE, 213);
   _actionMap[932][ENDTOKEN] = ActionEntry(REDUCE, 213);
   _actionMap[932][RB] = ActionEntry(REDUCE, 213);
   _actionMap[932][SEMICOLON] = ActionEntry(REDUCE, 213);
   _actionMap[932][KSEP] = ActionEntry(REDUCE, 213);
   _jumpMap[932][DefaultOrderOpt] = 923;
   _jumpMap[932][OrderingOpt] = 934;
   _actionMap[916][REFERENCES] = ActionEntry(SHIFT, 930);
   _actionMap[917][ELSE] = ActionEntry(REDUCE, 278);
   _actionMap[917][ELSIF] = ActionEntry(REDUCE, 278);
   _actionMap[917][EXCEPTION] = ActionEntry(REDUCE, 278);
   _actionMap[917][END_TOKEN] = ActionEntry(REDUCE, 278);
   _actionMap[917][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[917][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[917][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[917][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[917][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[917][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[917][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[917][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[917][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[917][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[917][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[917][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[917][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[917][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[917][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[917][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[917][LEFT] = ActionEntry(SHIFT, 148);
}
void Cego::loadParser1()
{
   _actionMap[917][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[917][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[917][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[917][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[917][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[917][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[917][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[917][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[917][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[917][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[917][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[917][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[917][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[917][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[917][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[917][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[917][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[917][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[917][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[917][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[917][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[917][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[917][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[917][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[917][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[917][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[917][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[917][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[917][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[917][LB] = ActionEntry(SHIFT, 177);
   _actionMap[917][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[917][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[917][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[917][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[917][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[917][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[917][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[917][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[917][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[917][VARREF] = ActionEntry(SHIFT, 418);
   _actionMap[917][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[917][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[917][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[917][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[917][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[917][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[917][IF] = ActionEntry(SHIFT, 412);
   _actionMap[917][BEGIN] = ActionEntry(SHIFT, 409);
   _actionMap[917][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[917][LOCK] = ActionEntry(SHIFT, 27);
}
void Cego::loadParser2()
{
   _actionMap[917][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[917][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[917][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[917][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[917][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[917][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[917][VAR] = ActionEntry(SHIFT, 416);
   _actionMap[917][CURSOR] = ActionEntry(SHIFT, 411);
   _actionMap[917][CLOSE] = ActionEntry(SHIFT, 410);
   _actionMap[917][NOOP] = ActionEntry(SHIFT, 413);
   _actionMap[917][THROW] = ActionEntry(SHIFT, 415);
   _actionMap[917][RETURNTOKEN] = ActionEntry(SHIFT, 414);
   _actionMap[917][WHILE] = ActionEntry(SHIFT, 417);
   _jumpMap[917][ObjSpec] = 122;
   _jumpMap[917][Constant] = 121;
   _jumpMap[917][SignedFloat] = 120;
   _jumpMap[917][SignedInt] = 119;
   _jumpMap[917][Attribute] = 118;
   _jumpMap[917][Function] = 117;
   _jumpMap[917][Factor] = 116;
   _jumpMap[917][Term] = 115;
   _jumpMap[917][Expr] = 408;
   _jumpMap[917][ProcStatement] = 557;
   _jumpMap[917][ProcIfPart] = 406;
   _jumpMap[917][ProcBlockStart] = 405;
   _jumpMap[917][DeleteStatement] = 402;
   _jumpMap[917][UpdateStatement] = 401;
   _jumpMap[917][InsertStatement] = 400;
   _jumpMap[917][UnlockStatement] = 399;
   _jumpMap[917][LockStatement] = 398;
   _jumpMap[917][RollbackStatement] = 397;
   _jumpMap[917][CommitStatement] = 396;
   _jumpMap[917][StartStatement] = 395;
   _jumpMap[917][CasePrepare] = 113;
   _jumpMap[917][CaseClause] = 112;
   _actionMap[918][RB] = ActionEntry(REDUCE, 391);
   _actionMap[919][SEMICOLON] = ActionEntry(REDUCE, 66);
   _actionMap[920][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[920][SelectStatement] = 931;
   _actionMap[921][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[921][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[921][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[921][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[921][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[921][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[921][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[921][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[921][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[921][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[921][DATE2STR] = ActionEntry(SHIFT, 138);
}
void Cego::loadParser3()
{
   _actionMap[921][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[921][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[921][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[921][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[921][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[921][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[921][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[921][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[921][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[921][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[921][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[921][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[921][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[921][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[921][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[921][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[921][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[921][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[921][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[921][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[921][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[921][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[921][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[921][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[921][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[921][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[921][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[921][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[921][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[921][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[921][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[921][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[921][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[921][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[921][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[921][LB] = ActionEntry(SHIFT, 177);
   _actionMap[921][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[921][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[921][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[921][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[921][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[921][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[921][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[921][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[921][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[921][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[921][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[921][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[921][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[921][AVG] = ActionEntry(SHIFT, 125);
}
void Cego::loadParser4()
{
   _actionMap[921][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[921][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[921][ObjSpec] = 122;
   _jumpMap[921][Constant] = 121;
   _jumpMap[921][SignedFloat] = 120;
   _jumpMap[921][SignedInt] = 119;
   _jumpMap[921][Attribute] = 118;
   _jumpMap[921][Function] = 117;
   _jumpMap[921][Factor] = 116;
   _jumpMap[921][Term] = 115;
   _jumpMap[921][Expr] = 932;
   _jumpMap[921][CasePrepare] = 113;
   _jumpMap[921][CaseClause] = 112;
   _actionMap[922][ROWLIMIT] = ActionEntry(REDUCE, 209);
   _actionMap[922][UNION] = ActionEntry(REDUCE, 209);
   _actionMap[922][ENDTOKEN] = ActionEntry(REDUCE, 209);
   _actionMap[922][RB] = ActionEntry(REDUCE, 209);
   _actionMap[922][SEMICOLON] = ActionEntry(REDUCE, 209);
   _actionMap[922][KSEP] = ActionEntry(REDUCE, 209);
   _actionMap[923][ROWLIMIT] = ActionEntry(REDUCE, 210);
   _actionMap[923][UNION] = ActionEntry(REDUCE, 210);
   _actionMap[923][ENDTOKEN] = ActionEntry(REDUCE, 210);
   _actionMap[923][RB] = ActionEntry(REDUCE, 210);
   _actionMap[923][SEMICOLON] = ActionEntry(REDUCE, 210);
   _actionMap[923][KSEP] = ActionEntry(REDUCE, 210);
   _actionMap[924][ROWLIMIT] = ActionEntry(REDUCE, 212);
   _actionMap[924][UNION] = ActionEntry(REDUCE, 212);
   _actionMap[924][ENDTOKEN] = ActionEntry(REDUCE, 212);
   _actionMap[924][RB] = ActionEntry(REDUCE, 212);
   _actionMap[924][SEMICOLON] = ActionEntry(REDUCE, 212);
   _actionMap[924][KSEP] = ActionEntry(REDUCE, 212);
   _actionMap[925][ROWLIMIT] = ActionEntry(REDUCE, 211);
   _actionMap[925][UNION] = ActionEntry(REDUCE, 211);
   _actionMap[925][ENDTOKEN] = ActionEntry(REDUCE, 211);
   _actionMap[925][RB] = ActionEntry(REDUCE, 211);
   _actionMap[925][SEMICOLON] = ActionEntry(REDUCE, 211);
   _actionMap[925][KSEP] = ActionEntry(REDUCE, 211);
   _actionMap[926][AND] = ActionEntry(SHIFT, 440);
   _actionMap[926][OR] = ActionEntry(SHIFT, 441);
   _actionMap[926][ORDER] = ActionEntry(REDUCE, 202);
   _actionMap[926][ROWLIMIT] = ActionEntry(REDUCE, 202);
   _actionMap[926][UNION] = ActionEntry(REDUCE, 202);
   _actionMap[926][ENDTOKEN] = ActionEntry(REDUCE, 202);
   _actionMap[926][RB] = ActionEntry(REDUCE, 202);
   _actionMap[926][SEMICOLON] = ActionEntry(REDUCE, 202);
   _actionMap[927][KSEP] = ActionEntry(REDUCE, 200);
   _actionMap[927][HAVING] = ActionEntry(REDUCE, 200);
   _actionMap[927][ORDER] = ActionEntry(REDUCE, 200);
   _actionMap[927][ROWLIMIT] = ActionEntry(REDUCE, 200);
   _actionMap[927][UNION] = ActionEntry(REDUCE, 200);
}
void Cego::loadParser5()
{
   _actionMap[927][ENDTOKEN] = ActionEntry(REDUCE, 200);
   _actionMap[927][RB] = ActionEntry(REDUCE, 200);
   _actionMap[927][SEMICOLON] = ActionEntry(REDUCE, 200);
   _actionMap[928][AND] = ActionEntry(SHIFT, 440);
   _actionMap[928][OR] = ActionEntry(SHIFT, 441);
   _actionMap[928][LEFT] = ActionEntry(REDUCE, 184);
   _actionMap[928][RIGHT] = ActionEntry(REDUCE, 184);
   _actionMap[928][INNER] = ActionEntry(REDUCE, 184);
   _actionMap[928][JOIN] = ActionEntry(REDUCE, 184);
   _actionMap[928][RB] = ActionEntry(REDUCE, 184);
   _actionMap[928][ENDTOKEN] = ActionEntry(REDUCE, 184);
   _actionMap[928][UNION] = ActionEntry(REDUCE, 184);
   _actionMap[928][ROWLIMIT] = ActionEntry(REDUCE, 184);
   _actionMap[928][ORDER] = ActionEntry(REDUCE, 184);
   _actionMap[928][GROUP] = ActionEntry(REDUCE, 184);
   _actionMap[928][SEMICOLON] = ActionEntry(REDUCE, 184);
   _actionMap[928][RETURNTOKEN] = ActionEntry(REDUCE, 184);
   _actionMap[928][WHERE] = ActionEntry(REDUCE, 184);
   _actionMap[929][AND] = ActionEntry(SHIFT, 440);
   _actionMap[929][OR] = ActionEntry(SHIFT, 441);
   _actionMap[929][LEFT] = ActionEntry(REDUCE, 186);
   _actionMap[929][RIGHT] = ActionEntry(REDUCE, 186);
   _actionMap[929][INNER] = ActionEntry(REDUCE, 186);
   _actionMap[929][JOIN] = ActionEntry(REDUCE, 186);
   _actionMap[929][RB] = ActionEntry(REDUCE, 186);
   _actionMap[929][ENDTOKEN] = ActionEntry(REDUCE, 186);
   _actionMap[929][UNION] = ActionEntry(REDUCE, 186);
   _actionMap[929][ROWLIMIT] = ActionEntry(REDUCE, 186);
   _actionMap[929][ORDER] = ActionEntry(REDUCE, 186);
   _actionMap[929][GROUP] = ActionEntry(REDUCE, 186);
   _actionMap[929][SEMICOLON] = ActionEntry(REDUCE, 186);
   _actionMap[929][RETURNTOKEN] = ActionEntry(REDUCE, 186);
   _actionMap[929][WHERE] = ActionEntry(REDUCE, 186);
   _actionMap[889][RB] = ActionEntry(SHIFT, 916);
   _actionMap[890][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[890][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[890][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[890][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[890][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[890][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[890][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[890][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[890][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[890][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[890][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[890][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[890][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[890][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[890][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[890][UPPER] = ActionEntry(SHIFT, 176);
}
void Cego::loadParser6()
{
   _actionMap[890][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[890][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[890][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[890][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[890][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[890][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[890][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[890][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[890][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[890][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[890][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[890][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[890][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[890][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[890][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[890][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[890][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[890][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[890][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[890][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[890][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[890][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[890][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[890][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[890][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[890][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[890][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[890][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[890][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[890][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[890][LB] = ActionEntry(SHIFT, 177);
   _actionMap[890][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[890][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[890][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[890][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[890][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[890][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[890][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[890][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[890][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[890][VARREF] = ActionEntry(SHIFT, 418);
   _actionMap[890][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[890][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[890][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[890][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[890][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[890][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[890][IF] = ActionEntry(SHIFT, 412);
   _actionMap[890][BEGIN] = ActionEntry(SHIFT, 409);
   _actionMap[890][UNLOCK] = ActionEntry(SHIFT, 28);
}
void Cego::loadParser7()
{
   _actionMap[890][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[890][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[890][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[890][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[890][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[890][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[890][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[890][VAR] = ActionEntry(SHIFT, 416);
   _actionMap[890][CURSOR] = ActionEntry(SHIFT, 411);
   _actionMap[890][CLOSE] = ActionEntry(SHIFT, 410);
   _actionMap[890][NOOP] = ActionEntry(SHIFT, 413);
   _actionMap[890][THROW] = ActionEntry(SHIFT, 415);
   _actionMap[890][RETURNTOKEN] = ActionEntry(SHIFT, 414);
   _actionMap[890][WHILE] = ActionEntry(SHIFT, 417);
   _jumpMap[890][ObjSpec] = 122;
   _jumpMap[890][Constant] = 121;
   _jumpMap[890][SignedFloat] = 120;
   _jumpMap[890][SignedInt] = 119;
   _jumpMap[890][Attribute] = 118;
   _jumpMap[890][Function] = 117;
   _jumpMap[890][Factor] = 116;
   _jumpMap[890][Term] = 115;
   _jumpMap[890][Expr] = 408;
   _jumpMap[890][ProcStatement] = 407;
   _jumpMap[890][ProcIfPart] = 406;
   _jumpMap[890][ProcBlockStart] = 405;
   _jumpMap[890][ProcStatementList] = 917;
   _jumpMap[890][DeleteStatement] = 402;
   _jumpMap[890][UpdateStatement] = 401;
   _jumpMap[890][InsertStatement] = 400;
   _jumpMap[890][UnlockStatement] = 399;
   _jumpMap[890][LockStatement] = 398;
   _jumpMap[890][RollbackStatement] = 397;
   _jumpMap[890][CommitStatement] = 396;
   _jumpMap[890][StartStatement] = 395;
   _jumpMap[890][CasePrepare] = 113;
   _jumpMap[890][CaseClause] = 112;
   _actionMap[891][BEGIN] = ActionEntry(REDUCE, 382);
   _actionMap[891][EQU] = ActionEntry(REDUCE, 382);
   _actionMap[891][DEFAULT] = ActionEntry(REDUCE, 382);
   _actionMap[891][NULLTOKEN] = ActionEntry(REDUCE, 382);
   _actionMap[891][NOT] = ActionEntry(REDUCE, 382);
   _actionMap[891][KSEP] = ActionEntry(REDUCE, 382);
   _actionMap[891][SEMICOLON] = ActionEntry(REDUCE, 382);
   _actionMap[891][RB] = ActionEntry(REDUCE, 382);
   _actionMap[892][BEGIN] = ActionEntry(REDUCE, 387);
   _actionMap[892][EQU] = ActionEntry(REDUCE, 387);
   _actionMap[892][DEFAULT] = ActionEntry(REDUCE, 387);
   _actionMap[892][NULLTOKEN] = ActionEntry(REDUCE, 387);
   _actionMap[892][NOT] = ActionEntry(REDUCE, 387);
}
void Cego::loadParser8()
{
   _actionMap[892][KSEP] = ActionEntry(REDUCE, 387);
   _actionMap[892][SEMICOLON] = ActionEntry(REDUCE, 387);
   _actionMap[892][RB] = ActionEntry(REDUCE, 387);
   _actionMap[893][INTVAL] = ActionEntry(SHIFT, 918);
   _actionMap[894][BEGIN] = ActionEntry(REDUCE, 379);
   _actionMap[894][EQU] = ActionEntry(REDUCE, 379);
   _actionMap[894][DEFAULT] = ActionEntry(REDUCE, 379);
   _actionMap[894][NULLTOKEN] = ActionEntry(REDUCE, 379);
   _actionMap[894][NOT] = ActionEntry(REDUCE, 379);
   _actionMap[894][KSEP] = ActionEntry(REDUCE, 379);
   _actionMap[894][SEMICOLON] = ActionEntry(REDUCE, 379);
   _actionMap[894][RB] = ActionEntry(REDUCE, 379);
   _actionMap[895][CACHED] = ActionEntry(SHIFT, 899);
   _actionMap[895][SEMICOLON] = ActionEntry(REDUCE, 68);
   _jumpMap[895][CachedOpt] = 919;
   _actionMap[896][KSEP] = ActionEntry(REDUCE, 70);
   _actionMap[896][RB] = ActionEntry(REDUCE, 70);
   _actionMap[897][KSEP] = ActionEntry(REDUCE, 72);
   _actionMap[897][RB] = ActionEntry(REDUCE, 72);
   _actionMap[898][SEMICOLON] = ActionEntry(REDUCE, 65);
   _actionMap[899][SEMICOLON] = ActionEntry(REDUCE, 67);
   _actionMap[900][RB] = ActionEntry(REDUCE, 128);
   _actionMap[901][SEMICOLON] = ActionEntry(REDUCE, 122);
   _actionMap[901][KSEP] = ActionEntry(REDUCE, 122);
   _actionMap[901][RB] = ActionEntry(REDUCE, 122);
   _actionMap[902][SEMICOLON] = ActionEntry(REDUCE, 169);
   _actionMap[902][RB] = ActionEntry(REDUCE, 169);
   _actionMap[903][ALL] = ActionEntry(SHIFT, 920);
   _actionMap[904][UNION] = ActionEntry(REDUCE, 217);
   _actionMap[904][ENDTOKEN] = ActionEntry(REDUCE, 217);
   _actionMap[904][RB] = ActionEntry(REDUCE, 217);
   _actionMap[904][SEMICOLON] = ActionEntry(REDUCE, 217);
   _actionMap[905][KSEP] = ActionEntry(SHIFT, 921);
   _actionMap[905][ROWLIMIT] = ActionEntry(REDUCE, 205);
   _actionMap[905][UNION] = ActionEntry(REDUCE, 205);
   _actionMap[905][ENDTOKEN] = ActionEntry(REDUCE, 205);
   _actionMap[905][RB] = ActionEntry(REDUCE, 205);
   _actionMap[905][SEMICOLON] = ActionEntry(REDUCE, 205);
   _actionMap[906][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[906][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[906][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[906][ASC] = ActionEntry(SHIFT, 924);
   _actionMap[906][ROWLIMIT] = ActionEntry(REDUCE, 213);
   _actionMap[906][DESC] = ActionEntry(SHIFT, 925);
   _actionMap[906][UNION] = ActionEntry(REDUCE, 213);
   _actionMap[906][ENDTOKEN] = ActionEntry(REDUCE, 213);
   _actionMap[906][RB] = ActionEntry(REDUCE, 213);
   _actionMap[906][SEMICOLON] = ActionEntry(REDUCE, 213);
   _actionMap[906][KSEP] = ActionEntry(REDUCE, 213);
   _jumpMap[906][DefaultOrderOpt] = 923;
}
void Cego::loadParser9()
{
   _jumpMap[906][OrderingOpt] = 922;
   _actionMap[907][ORDER] = ActionEntry(REDUCE, 197);
   _actionMap[907][ROWLIMIT] = ActionEntry(REDUCE, 197);
   _actionMap[907][UNION] = ActionEntry(REDUCE, 197);
   _actionMap[907][ENDTOKEN] = ActionEntry(REDUCE, 197);
   _actionMap[907][RB] = ActionEntry(REDUCE, 197);
   _actionMap[907][SEMICOLON] = ActionEntry(REDUCE, 197);
   _actionMap[908][ORDER] = ActionEntry(REDUCE, 203);
   _actionMap[908][ROWLIMIT] = ActionEntry(REDUCE, 203);
   _actionMap[908][UNION] = ActionEntry(REDUCE, 203);
   _actionMap[908][ENDTOKEN] = ActionEntry(REDUCE, 203);
   _actionMap[908][RB] = ActionEntry(REDUCE, 203);
   _actionMap[908][SEMICOLON] = ActionEntry(REDUCE, 203);
   _actionMap[909][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[909][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[909][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[909][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[909][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[909][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[909][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[909][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[909][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[909][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[909][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[909][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[909][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[909][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[909][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[909][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[909][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[909][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[909][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[909][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[909][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[909][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[909][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[909][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[909][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[909][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[909][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[909][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[909][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[909][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[909][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[909][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[909][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[909][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[909][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[909][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[909][BLOBREF] = ActionEntry(SHIFT, 131);
}
void Cego::loadParser10()
{
   _actionMap[909][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[909][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[909][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[909][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[909][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[909][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[909][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[909][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[909][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[909][LB] = ActionEntry(SHIFT, 177);
   _actionMap[909][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[909][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[909][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[909][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[909][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[909][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[909][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[909][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[909][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[909][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[909][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[909][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[909][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[909][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[909][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[909][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[909][EXISTS] = ActionEntry(SHIFT, 275);
   _actionMap[909][NOT] = ActionEntry(SHIFT, 276);
   _jumpMap[909][ObjSpec] = 122;
   _jumpMap[909][Constant] = 121;
   _jumpMap[909][SignedFloat] = 120;
   _jumpMap[909][SignedInt] = 119;
   _jumpMap[909][Attribute] = 118;
   _jumpMap[909][Function] = 117;
   _jumpMap[909][Factor] = 116;
   _jumpMap[909][Term] = 115;
   _jumpMap[909][Expr] = 274;
   _jumpMap[909][Predicate] = 273;
   _jumpMap[909][Condition] = 926;
   _jumpMap[909][CasePrepare] = 113;
   _jumpMap[909][CaseClause] = 112;
   _actionMap[910][IDENTIFIER] = ActionEntry(SHIFT, 881);
   _actionMap[910][QUALIFIEDOBJ] = ActionEntry(SHIFT, 882);
   _actionMap[910][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _jumpMap[910][Attribute] = 927;
   _actionMap[911][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[911][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[911][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[911][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[911][ASC2INT] = ActionEntry(SHIFT, 124);
}
void Cego::loadParser11()
{
   _actionMap[911][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[911][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[911][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[911][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[911][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[911][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[911][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[911][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[911][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[911][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[911][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[911][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[911][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[911][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[911][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[911][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[911][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[911][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[911][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[911][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[911][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[911][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[911][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[911][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[911][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[911][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[911][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[911][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[911][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[911][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[911][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[911][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[911][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[911][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[911][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[911][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[911][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[911][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[911][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[911][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[911][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[911][LB] = ActionEntry(SHIFT, 177);
   _actionMap[911][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[911][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[911][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[911][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[911][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[911][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[911][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[911][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
}
void Cego::loadParser12()
{
   _actionMap[911][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[911][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[911][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[911][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[911][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[911][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[911][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[911][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[911][EXISTS] = ActionEntry(SHIFT, 275);
   _actionMap[911][NOT] = ActionEntry(SHIFT, 276);
   _jumpMap[911][ObjSpec] = 122;
   _jumpMap[911][Constant] = 121;
   _jumpMap[911][SignedFloat] = 120;
   _jumpMap[911][SignedInt] = 119;
   _jumpMap[911][Attribute] = 118;
   _jumpMap[911][Function] = 117;
   _jumpMap[911][Factor] = 116;
   _jumpMap[911][Term] = 115;
   _jumpMap[911][Expr] = 274;
   _jumpMap[911][Predicate] = 273;
   _jumpMap[911][Condition] = 928;
   _jumpMap[911][CasePrepare] = 113;
   _jumpMap[911][CaseClause] = 112;
   _actionMap[912][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[912][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[912][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[912][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[912][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[912][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[912][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[912][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[912][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[912][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[912][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[912][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[912][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[912][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[912][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[912][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[912][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[912][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[912][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[912][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[912][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[912][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[912][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[912][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[912][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[912][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[912][RANDINT] = ActionEntry(SHIFT, 161);
}
void Cego::loadParser13()
{
   _actionMap[912][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[912][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[912][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[912][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[912][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[912][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[912][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[912][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[912][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[912][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[912][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[912][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[912][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[912][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[912][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[912][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[912][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[912][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[912][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[912][LB] = ActionEntry(SHIFT, 177);
   _actionMap[912][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[912][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[912][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[912][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[912][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[912][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[912][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[912][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[912][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[912][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[912][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[912][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[912][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[912][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[912][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[912][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[912][EXISTS] = ActionEntry(SHIFT, 275);
   _actionMap[912][NOT] = ActionEntry(SHIFT, 276);
   _jumpMap[912][ObjSpec] = 122;
   _jumpMap[912][Constant] = 121;
   _jumpMap[912][SignedFloat] = 120;
   _jumpMap[912][SignedInt] = 119;
   _jumpMap[912][Attribute] = 118;
   _jumpMap[912][Function] = 117;
   _jumpMap[912][Factor] = 116;
   _jumpMap[912][Term] = 115;
   _jumpMap[912][Expr] = 274;
   _jumpMap[912][Predicate] = 273;
   _jumpMap[912][Condition] = 929;
   _jumpMap[912][CasePrepare] = 113;
}
void Cego::loadParser14()
{
   _jumpMap[912][CaseClause] = 112;
   _actionMap[913][SEMICOLON] = ActionEntry(REDUCE, 162);
   _actionMap[913][KSEP] = ActionEntry(REDUCE, 162);
   _actionMap[914][KSEP] = ActionEntry(SHIFT, 886);
   _actionMap[914][SEMICOLON] = ActionEntry(REDUCE, 158);
   _actionMap[915][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[915][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[915][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[915][SEMICOLON] = ActionEntry(REDUCE, 164);
   _actionMap[915][KSEP] = ActionEntry(REDUCE, 164);
   _actionMap[846][AND] = ActionEntry(SHIFT, 440);
   _actionMap[846][OR] = ActionEntry(SHIFT, 441);
   _actionMap[846][SEMICOLON] = ActionEntry(REDUCE, 89);
   _actionMap[847][IDENTIFIER] = ActionEntry(SHIFT, 812);
   _jumpMap[847][SimpleAttr] = 811;
   _jumpMap[847][SimpleAttrList] = 889;
   _actionMap[848][SEMICOLON] = ActionEntry(REDUCE, 231);
   _actionMap[848][KSEP] = ActionEntry(REDUCE, 231);
   _actionMap[849][LONG] = ActionEntry(SHIFT, 342);
   _actionMap[849][BIGINT] = ActionEntry(SHIFT, 339);
   _actionMap[849][SMALLINT] = ActionEntry(SHIFT, 343);
   _actionMap[849][TINYINT] = ActionEntry(SHIFT, 344);
   _actionMap[849][DOUBLE] = ActionEntry(SHIFT, 341);
   _actionMap[849][DECIMAL] = ActionEntry(SHIFT, 340);
   _actionMap[850][SEMICOLON] = ActionEntry(REDUCE, 232);
   _actionMap[850][KSEP] = ActionEntry(REDUCE, 232);
   _actionMap[851][THEN] = ActionEntry(SHIFT, 890);
   _actionMap[852][THEN] = ActionEntry(REDUCE, 283);
   _actionMap[853][END_TOKEN] = ActionEntry(REDUCE, 288);
   _actionMap[853][ELSE] = ActionEntry(REDUCE, 288);
   _actionMap[853][ELSIF] = ActionEntry(REDUCE, 288);
   _actionMap[854][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[854][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[854][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[854][SEMICOLON] = ActionEntry(REDUCE, 260);
   _actionMap[855][RB] = ActionEntry(SHIFT, 891);
   _actionMap[856][RB] = ActionEntry(SHIFT, 892);
   _actionMap[857][RB] = ActionEntry(REDUCE, 390);
   _actionMap[857][KSEP] = ActionEntry(SHIFT, 893);
   _actionMap[858][RB] = ActionEntry(SHIFT, 894);
   _actionMap[859][SEMICOLON] = ActionEntry(REDUCE, 294);
   _actionMap[860][RB] = ActionEntry(SHIFT, 895);
   _actionMap[861][IDENTIFIER] = ActionEntry(SHIFT, 809);
   _jumpMap[861][AliasAttr] = 896;
   _actionMap[862][SEMICOLON] = ActionEntry(REDUCE, 69);
   _actionMap[863][IDENTIFIER] = ActionEntry(SHIFT, 897);
   _actionMap[864][CACHED] = ActionEntry(SHIFT, 899);
   _actionMap[864][SEMICOLON] = ActionEntry(REDUCE, 68);
   _jumpMap[864][CachedOpt] = 898;
   _actionMap[865][IDENTIFIER] = ActionEntry(SHIFT, 812);
}
void Cego::loadParser15()
{
   _jumpMap[865][SimpleAttr] = 811;
   _jumpMap[865][SimpleAttrList] = 900;
   _actionMap[866][SEMICOLON] = ActionEntry(REDUCE, 120);
   _actionMap[866][KSEP] = ActionEntry(REDUCE, 120);
   _actionMap[866][RB] = ActionEntry(REDUCE, 120);
   _actionMap[867][SEMICOLON] = ActionEntry(REDUCE, 123);
   _actionMap[867][KSEP] = ActionEntry(REDUCE, 123);
   _actionMap[867][RB] = ActionEntry(REDUCE, 123);
   _actionMap[868][NULLTOKEN] = ActionEntry(SHIFT, 901);
   _actionMap[869][SEMICOLON] = ActionEntry(REDUCE, 121);
   _actionMap[869][KSEP] = ActionEntry(REDUCE, 121);
   _actionMap[869][RB] = ActionEntry(REDUCE, 121);
   _actionMap[870][NULLTOKEN] = ActionEntry(REDUCE, 125);
   _actionMap[870][NOT] = ActionEntry(REDUCE, 125);
   _actionMap[870][KSEP] = ActionEntry(REDUCE, 125);
   _actionMap[870][SEMICOLON] = ActionEntry(REDUCE, 125);
   _actionMap[870][RB] = ActionEntry(REDUCE, 125);
   _actionMap[871][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[871][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[871][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[871][KSEP] = ActionEntry(REDUCE, 152);
   _actionMap[871][RB] = ActionEntry(REDUCE, 152);
   _actionMap[872][LEFT] = ActionEntry(REDUCE, 303);
   _actionMap[872][RIGHT] = ActionEntry(REDUCE, 303);
   _actionMap[872][INNER] = ActionEntry(REDUCE, 303);
   _actionMap[872][JOIN] = ActionEntry(REDUCE, 303);
   _actionMap[872][ENDTOKEN] = ActionEntry(REDUCE, 303);
   _actionMap[872][UNION] = ActionEntry(REDUCE, 303);
   _actionMap[872][ROWLIMIT] = ActionEntry(REDUCE, 303);
   _actionMap[872][ORDER] = ActionEntry(REDUCE, 303);
   _actionMap[872][GROUP] = ActionEntry(REDUCE, 303);
   _actionMap[872][SEMICOLON] = ActionEntry(REDUCE, 303);
   _actionMap[872][RETURNTOKEN] = ActionEntry(REDUCE, 303);
   _actionMap[872][WHERE] = ActionEntry(REDUCE, 303);
   _actionMap[872][RB] = ActionEntry(REDUCE, 303);
   _actionMap[872][BEGIN] = ActionEntry(REDUCE, 303);
   _actionMap[872][THEN] = ActionEntry(REDUCE, 303);
   _actionMap[872][AND] = ActionEntry(REDUCE, 303);
   _actionMap[872][OR] = ActionEntry(REDUCE, 303);
   _actionMap[873][LEFT] = ActionEntry(REDUCE, 301);
   _actionMap[873][RIGHT] = ActionEntry(REDUCE, 301);
   _actionMap[873][INNER] = ActionEntry(REDUCE, 301);
   _actionMap[873][JOIN] = ActionEntry(REDUCE, 301);
   _actionMap[873][ENDTOKEN] = ActionEntry(REDUCE, 301);
   _actionMap[873][UNION] = ActionEntry(REDUCE, 301);
   _actionMap[873][ROWLIMIT] = ActionEntry(REDUCE, 301);
   _actionMap[873][ORDER] = ActionEntry(REDUCE, 301);
   _actionMap[873][GROUP] = ActionEntry(REDUCE, 301);
   _actionMap[873][SEMICOLON] = ActionEntry(REDUCE, 301);
   _actionMap[873][RETURNTOKEN] = ActionEntry(REDUCE, 301);
}
void Cego::loadParser16()
{
   _actionMap[873][WHERE] = ActionEntry(REDUCE, 301);
   _actionMap[873][RB] = ActionEntry(REDUCE, 301);
   _actionMap[873][BEGIN] = ActionEntry(REDUCE, 301);
   _actionMap[873][THEN] = ActionEntry(REDUCE, 301);
   _actionMap[873][AND] = ActionEntry(REDUCE, 301);
   _actionMap[873][OR] = ActionEntry(REDUCE, 301);
   _actionMap[874][KSEP] = ActionEntry(REDUCE, 114);
   _actionMap[874][RB] = ActionEntry(REDUCE, 114);
   _actionMap[875][UNION] = ActionEntry(SHIFT, 903);
   _actionMap[875][SEMICOLON] = ActionEntry(REDUCE, 221);
   _actionMap[875][RB] = ActionEntry(REDUCE, 221);
   _jumpMap[875][UnionAllOpt] = 902;
   _actionMap[876][UNION] = ActionEntry(REDUCE, 218);
   _actionMap[876][ENDTOKEN] = ActionEntry(REDUCE, 218);
   _actionMap[876][RB] = ActionEntry(REDUCE, 218);
   _actionMap[876][SEMICOLON] = ActionEntry(REDUCE, 218);
   _actionMap[877][INTVAL] = ActionEntry(SHIFT, 904);
   _actionMap[878][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[878][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[878][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[878][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[878][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[878][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[878][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[878][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[878][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[878][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[878][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[878][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[878][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[878][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[878][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[878][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[878][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[878][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[878][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[878][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[878][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[878][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[878][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[878][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[878][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[878][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[878][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[878][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[878][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[878][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[878][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[878][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[878][BITAND] = ActionEntry(SHIFT, 126);
}
void Cego::loadParser17()
{
   _actionMap[878][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[878][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[878][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[878][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[878][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[878][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[878][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[878][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[878][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[878][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[878][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[878][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[878][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[878][LB] = ActionEntry(SHIFT, 177);
   _actionMap[878][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[878][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[878][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[878][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[878][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[878][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[878][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[878][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[878][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[878][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[878][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[878][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[878][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[878][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[878][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[878][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[878][ObjSpec] = 122;
   _jumpMap[878][Constant] = 121;
   _jumpMap[878][SignedFloat] = 120;
   _jumpMap[878][SignedInt] = 119;
   _jumpMap[878][Attribute] = 118;
   _jumpMap[878][Function] = 117;
   _jumpMap[878][Factor] = 116;
   _jumpMap[878][Term] = 115;
   _jumpMap[878][Expr] = 906;
   _jumpMap[878][OrderingList] = 905;
   _jumpMap[878][CasePrepare] = 113;
   _jumpMap[878][CaseClause] = 112;
   _actionMap[879][KSEP] = ActionEntry(SHIFT, 910);
   _actionMap[879][ORDER] = ActionEntry(REDUCE, 204);
   _actionMap[879][HAVING] = ActionEntry(SHIFT, 909);
   _actionMap[879][ROWLIMIT] = ActionEntry(REDUCE, 204);
   _actionMap[879][UNION] = ActionEntry(REDUCE, 204);
   _actionMap[879][ENDTOKEN] = ActionEntry(REDUCE, 204);
   _actionMap[879][RB] = ActionEntry(REDUCE, 204);
   _actionMap[879][SEMICOLON] = ActionEntry(REDUCE, 204);
}
void Cego::loadParser18()
{
   _jumpMap[879][NoHaving] = 908;
   _jumpMap[879][HavingClause] = 907;
   _actionMap[880][KSEP] = ActionEntry(REDUCE, 201);
   _actionMap[880][HAVING] = ActionEntry(REDUCE, 201);
   _actionMap[880][ORDER] = ActionEntry(REDUCE, 201);
   _actionMap[880][ROWLIMIT] = ActionEntry(REDUCE, 201);
   _actionMap[880][UNION] = ActionEntry(REDUCE, 201);
   _actionMap[880][ENDTOKEN] = ActionEntry(REDUCE, 201);
   _actionMap[880][RB] = ActionEntry(REDUCE, 201);
   _actionMap[880][SEMICOLON] = ActionEntry(REDUCE, 201);
   _actionMap[881][KSEP] = ActionEntry(REDUCE, 398);
   _actionMap[881][HAVING] = ActionEntry(REDUCE, 398);
   _actionMap[881][ORDER] = ActionEntry(REDUCE, 398);
   _actionMap[881][ROWLIMIT] = ActionEntry(REDUCE, 398);
   _actionMap[881][UNION] = ActionEntry(REDUCE, 398);
   _actionMap[881][ENDTOKEN] = ActionEntry(REDUCE, 398);
   _actionMap[881][RB] = ActionEntry(REDUCE, 398);
   _actionMap[881][SEMICOLON] = ActionEntry(REDUCE, 398);
   _actionMap[882][KSEP] = ActionEntry(REDUCE, 399);
   _actionMap[882][HAVING] = ActionEntry(REDUCE, 399);
   _actionMap[882][ORDER] = ActionEntry(REDUCE, 399);
   _actionMap[882][ROWLIMIT] = ActionEntry(REDUCE, 399);
   _actionMap[882][UNION] = ActionEntry(REDUCE, 399);
   _actionMap[882][ENDTOKEN] = ActionEntry(REDUCE, 399);
   _actionMap[882][RB] = ActionEntry(REDUCE, 399);
   _actionMap[882][SEMICOLON] = ActionEntry(REDUCE, 399);
   _actionMap[883][AND] = ActionEntry(SHIFT, 440);
   _actionMap[883][OR] = ActionEntry(SHIFT, 441);
   _actionMap[883][LEFT] = ActionEntry(REDUCE, 182);
   _actionMap[883][RIGHT] = ActionEntry(REDUCE, 182);
   _actionMap[883][INNER] = ActionEntry(REDUCE, 182);
   _actionMap[883][JOIN] = ActionEntry(REDUCE, 182);
   _actionMap[883][RB] = ActionEntry(REDUCE, 182);
   _actionMap[883][ENDTOKEN] = ActionEntry(REDUCE, 182);
   _actionMap[883][UNION] = ActionEntry(REDUCE, 182);
   _actionMap[883][ROWLIMIT] = ActionEntry(REDUCE, 182);
   _actionMap[883][ORDER] = ActionEntry(REDUCE, 182);
   _actionMap[883][GROUP] = ActionEntry(REDUCE, 182);
   _actionMap[883][SEMICOLON] = ActionEntry(REDUCE, 182);
   _actionMap[883][RETURNTOKEN] = ActionEntry(REDUCE, 182);
   _actionMap[883][WHERE] = ActionEntry(REDUCE, 182);
   _actionMap[884][ON] = ActionEntry(SHIFT, 911);
   _actionMap[884][LEFT] = ActionEntry(REDUCE, 183);
   _actionMap[884][RIGHT] = ActionEntry(REDUCE, 183);
   _actionMap[884][INNER] = ActionEntry(REDUCE, 183);
   _actionMap[884][JOIN] = ActionEntry(REDUCE, 183);
   _actionMap[884][RB] = ActionEntry(REDUCE, 183);
   _actionMap[884][ENDTOKEN] = ActionEntry(REDUCE, 183);
   _actionMap[884][UNION] = ActionEntry(REDUCE, 183);
   _actionMap[884][ROWLIMIT] = ActionEntry(REDUCE, 183);
}
void Cego::loadParser19()
{
   _actionMap[884][ORDER] = ActionEntry(REDUCE, 183);
   _actionMap[884][GROUP] = ActionEntry(REDUCE, 183);
   _actionMap[884][SEMICOLON] = ActionEntry(REDUCE, 183);
   _actionMap[884][RETURNTOKEN] = ActionEntry(REDUCE, 183);
   _actionMap[884][WHERE] = ActionEntry(REDUCE, 183);
   _actionMap[885][ON] = ActionEntry(SHIFT, 912);
   _actionMap[885][LEFT] = ActionEntry(REDUCE, 185);
   _actionMap[885][RIGHT] = ActionEntry(REDUCE, 185);
   _actionMap[885][INNER] = ActionEntry(REDUCE, 185);
   _actionMap[885][JOIN] = ActionEntry(REDUCE, 185);
   _actionMap[885][RB] = ActionEntry(REDUCE, 185);
   _actionMap[885][ENDTOKEN] = ActionEntry(REDUCE, 185);
   _actionMap[885][UNION] = ActionEntry(REDUCE, 185);
   _actionMap[885][ROWLIMIT] = ActionEntry(REDUCE, 185);
   _actionMap[885][ORDER] = ActionEntry(REDUCE, 185);
   _actionMap[885][GROUP] = ActionEntry(REDUCE, 185);
   _actionMap[885][SEMICOLON] = ActionEntry(REDUCE, 185);
   _actionMap[885][RETURNTOKEN] = ActionEntry(REDUCE, 185);
   _actionMap[885][WHERE] = ActionEntry(REDUCE, 185);
   _actionMap[886][VARREF] = ActionEntry(SHIFT, 845);
   _jumpMap[886][ReturnVar] = 913;
   _actionMap[887][VARREF] = ActionEntry(SHIFT, 845);
   _jumpMap[887][ReturnVar] = 843;
   _jumpMap[887][ReturnVarList] = 914;
   _actionMap[888][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[888][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[888][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[888][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[888][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[888][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[888][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[888][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[888][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[888][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[888][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[888][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[888][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[888][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[888][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[888][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[888][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[888][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[888][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[888][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[888][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[888][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[888][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[888][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[888][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[888][RANDSTR] = ActionEntry(SHIFT, 160);
}
void Cego::loadParser20()
{
   _actionMap[888][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[888][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[888][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[888][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[888][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[888][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[888][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[888][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[888][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[888][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[888][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[888][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[888][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[888][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[888][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[888][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[888][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[888][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[888][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[888][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[888][LB] = ActionEntry(SHIFT, 177);
   _actionMap[888][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[888][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[888][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[888][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[888][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[888][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[888][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[888][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[888][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[888][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[888][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[888][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[888][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[888][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[888][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[888][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[888][ObjSpec] = 122;
   _jumpMap[888][Constant] = 121;
   _jumpMap[888][SignedFloat] = 120;
   _jumpMap[888][SignedInt] = 119;
   _jumpMap[888][Attribute] = 118;
   _jumpMap[888][Function] = 117;
   _jumpMap[888][Factor] = 116;
   _jumpMap[888][Term] = 115;
   _jumpMap[888][Expr] = 915;
   _jumpMap[888][CasePrepare] = 113;
   _jumpMap[888][CaseClause] = 112;
   _actionMap[789][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[789][MINUS] = ActionEntry(SHIFT, 178);
}
void Cego::loadParser21()
{
   _actionMap[789][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[789][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[789][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[789][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[789][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[789][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[789][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[789][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[789][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[789][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[789][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[789][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[789][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[789][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[789][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[789][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[789][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[789][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[789][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[789][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[789][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[789][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[789][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[789][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[789][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[789][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[789][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[789][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[789][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[789][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[789][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[789][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[789][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[789][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[789][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[789][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[789][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[789][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[789][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[789][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[789][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[789][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[789][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[789][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[789][LB] = ActionEntry(SHIFT, 177);
   _actionMap[789][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[789][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[789][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[789][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[789][FALSEVAL] = ActionEntry(SHIFT, 141);
}
void Cego::loadParser22()
{
   _actionMap[789][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[789][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[789][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[789][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[789][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[789][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[789][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[789][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[789][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[789][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[789][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[789][EXISTS] = ActionEntry(SHIFT, 275);
   _actionMap[789][NOT] = ActionEntry(SHIFT, 276);
   _jumpMap[789][ObjSpec] = 122;
   _jumpMap[789][Constant] = 121;
   _jumpMap[789][SignedFloat] = 120;
   _jumpMap[789][SignedInt] = 119;
   _jumpMap[789][Attribute] = 118;
   _jumpMap[789][Function] = 117;
   _jumpMap[789][Factor] = 116;
   _jumpMap[789][Term] = 115;
   _jumpMap[789][Expr] = 274;
   _jumpMap[789][Predicate] = 273;
   _jumpMap[789][Condition] = 846;
   _jumpMap[789][CasePrepare] = 113;
   _jumpMap[789][CaseClause] = 112;
   _actionMap[790][LB] = ActionEntry(SHIFT, 847);
   _actionMap[791][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[791][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[791][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[791][LB] = ActionEntry(SHIFT, 849);
   _actionMap[791][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[791][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[791][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[791][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[791][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[791][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[791][CLOB] = ActionEntry(SHIFT, 133);
   _jumpMap[791][Constant] = 848;
   _jumpMap[791][SignedFloat] = 120;
   _jumpMap[791][SignedInt] = 119;
   _actionMap[792][IDENTIFIER] = ActionEntry(SHIFT, 850);
   _actionMap[793][SEMICOLON] = ActionEntry(REDUCE, 36);
   _actionMap[794][IDENTIFIER] = ActionEntry(SHIFT, 852);
   _jumpMap[794][ProcExceptionType] = 851;
   _actionMap[795][END_TOKEN] = ActionEntry(REDUCE, 289);
   _actionMap[796][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[796][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[796][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[796][INT2ASC] = ActionEntry(SHIFT, 147);
}
void Cego::loadParser23()
{
   _actionMap[796][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[796][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[796][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[796][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[796][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[796][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[796][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[796][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[796][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[796][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[796][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[796][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[796][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[796][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[796][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[796][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[796][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[796][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[796][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[796][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[796][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[796][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[796][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[796][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[796][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[796][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[796][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[796][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[796][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[796][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[796][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[796][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[796][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[796][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[796][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[796][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[796][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[796][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[796][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[796][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[796][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[796][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[796][LB] = ActionEntry(SHIFT, 177);
   _actionMap[796][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[796][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[796][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[796][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[796][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[796][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[796][CLOB] = ActionEntry(SHIFT, 133);
}
void Cego::loadParser24()
{
   _actionMap[796][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[796][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[796][VARREF] = ActionEntry(SHIFT, 418);
   _actionMap[796][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[796][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[796][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[796][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[796][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[796][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[796][IF] = ActionEntry(SHIFT, 412);
   _actionMap[796][BEGIN] = ActionEntry(SHIFT, 409);
   _actionMap[796][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[796][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[796][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[796][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[796][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[796][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[796][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[796][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[796][VAR] = ActionEntry(SHIFT, 416);
   _actionMap[796][CURSOR] = ActionEntry(SHIFT, 411);
   _actionMap[796][CLOSE] = ActionEntry(SHIFT, 410);
   _actionMap[796][NOOP] = ActionEntry(SHIFT, 413);
   _actionMap[796][THROW] = ActionEntry(SHIFT, 415);
   _actionMap[796][RETURNTOKEN] = ActionEntry(SHIFT, 414);
   _actionMap[796][WHILE] = ActionEntry(SHIFT, 417);
   _jumpMap[796][ObjSpec] = 122;
   _jumpMap[796][Constant] = 121;
   _jumpMap[796][SignedFloat] = 120;
   _jumpMap[796][SignedInt] = 119;
   _jumpMap[796][Attribute] = 118;
   _jumpMap[796][Function] = 117;
   _jumpMap[796][Factor] = 116;
   _jumpMap[796][Term] = 115;
   _jumpMap[796][Expr] = 408;
   _jumpMap[796][ProcStatement] = 407;
   _jumpMap[796][ProcIfPart] = 406;
   _jumpMap[796][ProcBlockStart] = 405;
   _jumpMap[796][ProcStatementList] = 404;
   _jumpMap[796][ProcStmtBlock] = 853;
   _jumpMap[796][DeleteStatement] = 402;
   _jumpMap[796][UpdateStatement] = 401;
   _jumpMap[796][InsertStatement] = 400;
   _jumpMap[796][UnlockStatement] = 399;
   _jumpMap[796][LockStatement] = 398;
   _jumpMap[796][RollbackStatement] = 397;
   _jumpMap[796][CommitStatement] = 396;
   _jumpMap[796][StartStatement] = 395;
   _jumpMap[796][CasePrepare] = 113;
   _jumpMap[796][CaseClause] = 112;
}
void Cego::loadParser25()
{
   _actionMap[797][SEMICOLON] = ActionEntry(REDUCE, 255);
   _actionMap[798][END_TOKEN] = ActionEntry(REDUCE, 285);
   _actionMap[798][ELSE] = ActionEntry(REDUCE, 285);
   _actionMap[798][ELSIF] = ActionEntry(REDUCE, 285);
   _actionMap[799][SEMICOLON] = ActionEntry(REDUCE, 254);
   _actionMap[800][SEMICOLON] = ActionEntry(REDUCE, 261);
   _actionMap[801][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[801][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[801][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[801][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[801][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[801][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[801][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[801][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[801][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[801][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[801][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[801][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[801][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[801][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[801][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[801][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[801][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[801][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[801][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[801][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[801][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[801][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[801][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[801][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[801][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[801][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[801][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[801][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[801][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[801][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[801][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[801][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[801][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[801][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[801][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[801][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[801][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[801][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[801][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[801][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[801][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[801][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[801][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[801][IDENTIFIER] = ActionEntry(SHIFT, 181);
}
void Cego::loadParser26()
{
   _actionMap[801][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[801][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[801][LB] = ActionEntry(SHIFT, 177);
   _actionMap[801][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[801][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[801][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[801][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[801][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[801][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[801][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[801][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[801][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[801][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[801][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[801][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[801][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[801][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[801][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[801][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[801][ObjSpec] = 122;
   _jumpMap[801][Constant] = 121;
   _jumpMap[801][SignedFloat] = 120;
   _jumpMap[801][SignedInt] = 119;
   _jumpMap[801][Attribute] = 118;
   _jumpMap[801][Function] = 117;
   _jumpMap[801][Factor] = 116;
   _jumpMap[801][Term] = 115;
   _jumpMap[801][Expr] = 854;
   _jumpMap[801][CasePrepare] = 113;
   _jumpMap[801][CaseClause] = 112;
   _actionMap[802][INTVAL] = ActionEntry(SHIFT, 855);
   _actionMap[803][INTVAL] = ActionEntry(SHIFT, 857);
   _jumpMap[803][DecimalDim] = 856;
   _actionMap[804][INTVAL] = ActionEntry(SHIFT, 858);
   _actionMap[805][END_TOKEN] = ActionEntry(SHIFT, 859);
   _actionMap[806][IDENTIFIER] = ActionEntry(SHIFT, 812);
   _jumpMap[806][SimpleAttr] = 811;
   _jumpMap[806][SimpleAttrList] = 860;
   _actionMap[807][RB] = ActionEntry(SHIFT, 862);
   _actionMap[807][KSEP] = ActionEntry(SHIFT, 861);
   _actionMap[808][KSEP] = ActionEntry(REDUCE, 71);
   _actionMap[808][RB] = ActionEntry(REDUCE, 71);
   _actionMap[809][AS] = ActionEntry(SHIFT, 863);
   _actionMap[810][RB] = ActionEntry(SHIFT, 864);
   _actionMap[811][KSEP] = ActionEntry(SHIFT, 865);
   _actionMap[811][RB] = ActionEntry(REDUCE, 129);
   _actionMap[812][RB] = ActionEntry(REDUCE, 130);
   _actionMap[812][KSEP] = ActionEntry(REDUCE, 130);
   _actionMap[813][KSEP] = ActionEntry(REDUCE, 247);
   _actionMap[813][RB] = ActionEntry(REDUCE, 247);
}
void Cego::loadParser27()
{
   _actionMap[814][BEGIN] = ActionEntry(REDUCE, 243);
   _actionMap[815][KSEP] = ActionEntry(REDUCE, 249);
   _actionMap[815][RB] = ActionEntry(REDUCE, 249);
   _actionMap[816][KSEP] = ActionEntry(REDUCE, 250);
   _actionMap[816][RB] = ActionEntry(REDUCE, 250);
   _actionMap[817][KSEP] = ActionEntry(REDUCE, 116);
   _actionMap[817][RB] = ActionEntry(REDUCE, 116);
   _actionMap[818][SEMICOLON] = ActionEntry(REDUCE, 124);
   _actionMap[818][NULLTOKEN] = ActionEntry(SHIFT, 869);
   _actionMap[818][NOT] = ActionEntry(SHIFT, 868);
   _actionMap[818][KSEP] = ActionEntry(REDUCE, 124);
   _actionMap[818][RB] = ActionEntry(REDUCE, 124);
   _jumpMap[818][DefaultNullOpt] = 867;
   _jumpMap[818][NullOpt] = 866;
   _actionMap[819][NULLTOKEN] = ActionEntry(REDUCE, 126);
   _actionMap[819][NOT] = ActionEntry(REDUCE, 126);
   _actionMap[819][KSEP] = ActionEntry(REDUCE, 126);
   _actionMap[819][SEMICOLON] = ActionEntry(REDUCE, 126);
   _actionMap[819][RB] = ActionEntry(REDUCE, 126);
   _actionMap[820][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[820][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[820][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[820][LB] = ActionEntry(SHIFT, 849);
   _actionMap[820][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[820][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[820][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[820][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[820][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[820][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[820][CLOB] = ActionEntry(SHIFT, 133);
   _jumpMap[820][Constant] = 870;
   _jumpMap[820][SignedFloat] = 120;
   _jumpMap[820][SignedInt] = 119;
   _actionMap[821][BEGIN] = ActionEntry(REDUCE, 101);
   _actionMap[822][OR] = ActionEntry(REDUCE, 104);
   _actionMap[822][ON] = ActionEntry(REDUCE, 104);
   _actionMap[823][SEMICOLON] = ActionEntry(REDUCE, 147);
   _actionMap[823][KSEP] = ActionEntry(REDUCE, 147);
   _actionMap[824][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[824][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[824][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[824][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[824][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[824][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[824][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[824][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[824][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[824][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[824][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[824][DATE2LONG] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser28()
{
   _actionMap[824][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[824][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[824][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[824][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[824][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[824][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[824][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[824][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[824][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[824][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[824][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[824][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[824][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[824][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[824][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[824][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[824][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[824][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[824][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[824][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[824][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[824][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[824][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[824][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[824][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[824][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[824][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[824][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[824][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[824][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[824][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[824][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[824][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[824][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[824][LB] = ActionEntry(SHIFT, 177);
   _actionMap[824][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[824][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[824][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[824][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[824][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[824][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[824][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[824][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[824][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[824][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[824][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[824][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[824][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[824][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[824][MIN] = ActionEntry(SHIFT, 154);
}
void Cego::loadParser29()
{
   _actionMap[824][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[824][ObjSpec] = 122;
   _jumpMap[824][Constant] = 121;
   _jumpMap[824][SignedFloat] = 120;
   _jumpMap[824][SignedInt] = 119;
   _jumpMap[824][Attribute] = 118;
   _jumpMap[824][Function] = 117;
   _jumpMap[824][Factor] = 116;
   _jumpMap[824][Term] = 115;
   _jumpMap[824][Expr] = 871;
   _jumpMap[824][CasePrepare] = 113;
   _jumpMap[824][CaseClause] = 112;
   _actionMap[825][SEMICOLON] = ActionEntry(REDUCE, 149);
   _actionMap[825][KSEP] = ActionEntry(REDUCE, 149);
   _actionMap[826][KSEP] = ActionEntry(REDUCE, 150);
   _actionMap[826][RB] = ActionEntry(REDUCE, 150);
   _actionMap[827][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[827][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[827][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[827][LEFT] = ActionEntry(REDUCE, 305);
   _actionMap[827][RIGHT] = ActionEntry(REDUCE, 305);
   _actionMap[827][INNER] = ActionEntry(REDUCE, 305);
   _actionMap[827][JOIN] = ActionEntry(REDUCE, 305);
   _actionMap[827][ENDTOKEN] = ActionEntry(REDUCE, 305);
   _actionMap[827][UNION] = ActionEntry(REDUCE, 305);
   _actionMap[827][ROWLIMIT] = ActionEntry(REDUCE, 305);
   _actionMap[827][ORDER] = ActionEntry(REDUCE, 305);
   _actionMap[827][GROUP] = ActionEntry(REDUCE, 305);
   _actionMap[827][SEMICOLON] = ActionEntry(REDUCE, 305);
   _actionMap[827][RETURNTOKEN] = ActionEntry(REDUCE, 305);
   _actionMap[827][WHERE] = ActionEntry(REDUCE, 305);
   _actionMap[827][RB] = ActionEntry(REDUCE, 305);
   _actionMap[827][BEGIN] = ActionEntry(REDUCE, 305);
   _actionMap[827][THEN] = ActionEntry(REDUCE, 305);
   _actionMap[827][AND] = ActionEntry(REDUCE, 305);
   _actionMap[827][OR] = ActionEntry(REDUCE, 305);
   _actionMap[828][LEFT] = ActionEntry(REDUCE, 302);
   _actionMap[828][RIGHT] = ActionEntry(REDUCE, 302);
   _actionMap[828][INNER] = ActionEntry(REDUCE, 302);
   _actionMap[828][JOIN] = ActionEntry(REDUCE, 302);
   _actionMap[828][ENDTOKEN] = ActionEntry(REDUCE, 302);
   _actionMap[828][UNION] = ActionEntry(REDUCE, 302);
   _actionMap[828][ROWLIMIT] = ActionEntry(REDUCE, 302);
   _actionMap[828][ORDER] = ActionEntry(REDUCE, 302);
   _actionMap[828][GROUP] = ActionEntry(REDUCE, 302);
   _actionMap[828][SEMICOLON] = ActionEntry(REDUCE, 302);
   _actionMap[828][RETURNTOKEN] = ActionEntry(REDUCE, 302);
   _actionMap[828][WHERE] = ActionEntry(REDUCE, 302);
   _actionMap[828][RB] = ActionEntry(REDUCE, 302);
   _actionMap[828][BEGIN] = ActionEntry(REDUCE, 302);
}
void Cego::loadParser30()
{
   _actionMap[828][THEN] = ActionEntry(REDUCE, 302);
   _actionMap[828][AND] = ActionEntry(REDUCE, 302);
   _actionMap[828][OR] = ActionEntry(REDUCE, 302);
   _actionMap[829][LEFT] = ActionEntry(REDUCE, 300);
   _actionMap[829][RIGHT] = ActionEntry(REDUCE, 300);
   _actionMap[829][INNER] = ActionEntry(REDUCE, 300);
   _actionMap[829][JOIN] = ActionEntry(REDUCE, 300);
   _actionMap[829][ENDTOKEN] = ActionEntry(REDUCE, 300);
   _actionMap[829][UNION] = ActionEntry(REDUCE, 300);
   _actionMap[829][ROWLIMIT] = ActionEntry(REDUCE, 300);
   _actionMap[829][ORDER] = ActionEntry(REDUCE, 300);
   _actionMap[829][GROUP] = ActionEntry(REDUCE, 300);
   _actionMap[829][SEMICOLON] = ActionEntry(REDUCE, 300);
   _actionMap[829][RETURNTOKEN] = ActionEntry(REDUCE, 300);
   _actionMap[829][WHERE] = ActionEntry(REDUCE, 300);
   _actionMap[829][RB] = ActionEntry(REDUCE, 300);
   _actionMap[829][BEGIN] = ActionEntry(REDUCE, 300);
   _actionMap[829][THEN] = ActionEntry(REDUCE, 300);
   _actionMap[829][AND] = ActionEntry(REDUCE, 300);
   _actionMap[829][OR] = ActionEntry(REDUCE, 300);
   _actionMap[830][RB] = ActionEntry(SHIFT, 872);
   _actionMap[831][RB] = ActionEntry(SHIFT, 873);
   _actionMap[831][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[832][VARREF] = ActionEntry(SHIFT, 874);
   _actionMap[833][WHEN] = ActionEntry(REDUCE, 321);
   _actionMap[833][ELSE] = ActionEntry(REDUCE, 321);
   _actionMap[833][LEFT] = ActionEntry(REDUCE, 321);
   _actionMap[833][RIGHT] = ActionEntry(REDUCE, 321);
   _actionMap[833][INNER] = ActionEntry(REDUCE, 321);
   _actionMap[833][JOIN] = ActionEntry(REDUCE, 321);
   _actionMap[833][ORDER] = ActionEntry(REDUCE, 321);
   _actionMap[833][GROUP] = ActionEntry(REDUCE, 321);
   _actionMap[833][RETURNTOKEN] = ActionEntry(REDUCE, 321);
   _actionMap[833][WHERE] = ActionEntry(REDUCE, 321);
   _actionMap[833][AS] = ActionEntry(REDUCE, 321);
   _actionMap[833][FROM] = ActionEntry(REDUCE, 321);
   _actionMap[833][END_TOKEN] = ActionEntry(REDUCE, 321);
   _actionMap[833][BEGIN] = ActionEntry(REDUCE, 321);
   _actionMap[833][THEN] = ActionEntry(REDUCE, 321);
   _actionMap[833][OR] = ActionEntry(REDUCE, 321);
   _actionMap[833][AND] = ActionEntry(REDUCE, 321);
   _actionMap[833][LIKE] = ActionEntry(REDUCE, 321);
   _actionMap[833][IS] = ActionEntry(REDUCE, 321);
   _actionMap[833][BETWEEN] = ActionEntry(REDUCE, 321);
   _actionMap[833][EQU] = ActionEntry(REDUCE, 321);
   _actionMap[833][NEGATION] = ActionEntry(REDUCE, 321);
   _actionMap[833][LT] = ActionEntry(REDUCE, 321);
   _actionMap[833][MT] = ActionEntry(REDUCE, 321);
   _actionMap[833][NOT] = ActionEntry(REDUCE, 321);
   _actionMap[833][INTOK] = ActionEntry(REDUCE, 321);
}
void Cego::loadParser31()
{
   _actionMap[833][DESC] = ActionEntry(REDUCE, 321);
   _actionMap[833][ASC] = ActionEntry(REDUCE, 321);
   _actionMap[833][KSEP] = ActionEntry(REDUCE, 321);
   _actionMap[833][ROWLIMIT] = ActionEntry(REDUCE, 321);
   _actionMap[833][UNION] = ActionEntry(REDUCE, 321);
   _actionMap[833][ENDTOKEN] = ActionEntry(REDUCE, 321);
   _actionMap[833][RB] = ActionEntry(REDUCE, 321);
   _actionMap[833][CONCAT] = ActionEntry(REDUCE, 321);
   _actionMap[833][STAR] = ActionEntry(REDUCE, 321);
   _actionMap[833][DIVISION] = ActionEntry(REDUCE, 321);
   _actionMap[833][MINUS] = ActionEntry(REDUCE, 321);
   _actionMap[833][PLUS] = ActionEntry(REDUCE, 321);
   _actionMap[833][SEMICOLON] = ActionEntry(REDUCE, 321);
   _actionMap[834][WHEN] = ActionEntry(REDUCE, 371);
   _actionMap[834][ELSE] = ActionEntry(REDUCE, 371);
   _actionMap[834][FROM] = ActionEntry(REDUCE, 371);
   _actionMap[834][AS] = ActionEntry(REDUCE, 371);
   _actionMap[834][END_TOKEN] = ActionEntry(REDUCE, 371);
   _actionMap[834][BEGIN] = ActionEntry(REDUCE, 371);
   _actionMap[834][THEN] = ActionEntry(REDUCE, 371);
   _actionMap[834][LEFT] = ActionEntry(REDUCE, 371);
   _actionMap[834][RIGHT] = ActionEntry(REDUCE, 371);
   _actionMap[834][INNER] = ActionEntry(REDUCE, 371);
   _actionMap[834][JOIN] = ActionEntry(REDUCE, 371);
   _actionMap[834][ORDER] = ActionEntry(REDUCE, 371);
   _actionMap[834][GROUP] = ActionEntry(REDUCE, 371);
   _actionMap[834][RETURNTOKEN] = ActionEntry(REDUCE, 371);
   _actionMap[834][WHERE] = ActionEntry(REDUCE, 371);
   _actionMap[834][AND] = ActionEntry(REDUCE, 371);
   _actionMap[834][OR] = ActionEntry(REDUCE, 371);
   _actionMap[834][INTOK] = ActionEntry(REDUCE, 371);
   _actionMap[834][NOT] = ActionEntry(REDUCE, 371);
   _actionMap[834][MT] = ActionEntry(REDUCE, 371);
   _actionMap[834][LT] = ActionEntry(REDUCE, 371);
   _actionMap[834][NEGATION] = ActionEntry(REDUCE, 371);
   _actionMap[834][EQU] = ActionEntry(REDUCE, 371);
   _actionMap[834][BETWEEN] = ActionEntry(REDUCE, 371);
   _actionMap[834][IS] = ActionEntry(REDUCE, 371);
   _actionMap[834][LIKE] = ActionEntry(REDUCE, 371);
   _actionMap[834][RB] = ActionEntry(REDUCE, 371);
   _actionMap[834][ENDTOKEN] = ActionEntry(REDUCE, 371);
   _actionMap[834][UNION] = ActionEntry(REDUCE, 371);
   _actionMap[834][ROWLIMIT] = ActionEntry(REDUCE, 371);
   _actionMap[834][KSEP] = ActionEntry(REDUCE, 371);
   _actionMap[834][ASC] = ActionEntry(REDUCE, 371);
   _actionMap[834][DESC] = ActionEntry(REDUCE, 371);
   _actionMap[834][PLUS] = ActionEntry(REDUCE, 371);
   _actionMap[834][MINUS] = ActionEntry(REDUCE, 371);
   _actionMap[834][DIVISION] = ActionEntry(REDUCE, 371);
   _actionMap[834][STAR] = ActionEntry(REDUCE, 371);
}
void Cego::loadParser32()
{
   _actionMap[834][CONCAT] = ActionEntry(REDUCE, 371);
   _actionMap[834][SEMICOLON] = ActionEntry(REDUCE, 371);
   _actionMap[835][SEMICOLON] = ActionEntry(REDUCE, 219);
   _actionMap[835][RB] = ActionEntry(REDUCE, 219);
   _actionMap[835][ENDTOKEN] = ActionEntry(REDUCE, 219);
   _actionMap[835][UNION] = ActionEntry(REDUCE, 219);
   _actionMap[835][ROWLIMIT] = ActionEntry(SHIFT, 877);
   _jumpMap[835][NoLimit] = 876;
   _jumpMap[835][LimitOpt] = 875;
   _actionMap[836][ROWLIMIT] = ActionEntry(REDUCE, 206);
   _actionMap[836][UNION] = ActionEntry(REDUCE, 206);
   _actionMap[836][ENDTOKEN] = ActionEntry(REDUCE, 206);
   _actionMap[836][RB] = ActionEntry(REDUCE, 206);
   _actionMap[836][SEMICOLON] = ActionEntry(REDUCE, 206);
   _actionMap[837][BY] = ActionEntry(SHIFT, 878);
   _actionMap[838][IDENTIFIER] = ActionEntry(SHIFT, 881);
   _actionMap[838][QUALIFIEDOBJ] = ActionEntry(SHIFT, 882);
   _actionMap[838][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _jumpMap[838][Attribute] = 880;
   _jumpMap[838][GroupList] = 879;
   _actionMap[839][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[839][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[839][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[839][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[839][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[839][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[839][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[839][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[839][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[839][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[839][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[839][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[839][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[839][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[839][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[839][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[839][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[839][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[839][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[839][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[839][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[839][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[839][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[839][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[839][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[839][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[839][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[839][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[839][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[839][LMOD] = ActionEntry(SHIFT, 151);
}
void Cego::loadParser33()
{
   _actionMap[839][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[839][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[839][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[839][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[839][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[839][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[839][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[839][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[839][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[839][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[839][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[839][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[839][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[839][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[839][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[839][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[839][LB] = ActionEntry(SHIFT, 177);
   _actionMap[839][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[839][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[839][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[839][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[839][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[839][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[839][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[839][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[839][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[839][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[839][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[839][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[839][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[839][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[839][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[839][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[839][EXISTS] = ActionEntry(SHIFT, 275);
   _actionMap[839][NOT] = ActionEntry(SHIFT, 276);
   _jumpMap[839][ObjSpec] = 122;
   _jumpMap[839][Constant] = 121;
   _jumpMap[839][SignedFloat] = 120;
   _jumpMap[839][SignedInt] = 119;
   _jumpMap[839][Attribute] = 118;
   _jumpMap[839][Function] = 117;
   _jumpMap[839][Factor] = 116;
   _jumpMap[839][Term] = 115;
   _jumpMap[839][Expr] = 274;
   _jumpMap[839][Predicate] = 273;
   _jumpMap[839][Condition] = 883;
   _jumpMap[839][CasePrepare] = 113;
   _jumpMap[839][CaseClause] = 112;
   _actionMap[840][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[840][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
}
void Cego::loadParser34()
{
   _actionMap[840][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[840][ObjSpec] = 535;
   _jumpMap[840][JoinTable] = 884;
   _jumpMap[840][Table] = 775;
   _actionMap[841][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[841][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[841][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[841][ObjSpec] = 535;
   _jumpMap[841][JoinTable] = 885;
   _jumpMap[841][Table] = 775;
   _actionMap[842][KSEP] = ActionEntry(SHIFT, 886);
   _actionMap[842][SEMICOLON] = ActionEntry(REDUCE, 159);
   _actionMap[843][SEMICOLON] = ActionEntry(REDUCE, 163);
   _actionMap[843][KSEP] = ActionEntry(REDUCE, 163);
   _actionMap[844][FIRST] = ActionEntry(SHIFT, 887);
   _actionMap[845][EQU] = ActionEntry(SHIFT, 888);
   _actionMap[700][SEMICOLON] = ActionEntry(REDUCE, 226);
   _actionMap[701][COLUMN] = ActionEntry(SHIFT, 548);
   _actionMap[702][ON] = ActionEntry(SHIFT, 789);
   _actionMap[703][SEMICOLON] = ActionEntry(REDUCE, 229);
   _actionMap[703][KSEP] = ActionEntry(REDUCE, 229);
   _actionMap[704][IDENTIFIER] = ActionEntry(SHIFT, 790);
   _actionMap[705][SEMICOLON] = ActionEntry(REDUCE, 228);
   _actionMap[705][KSEP] = ActionEntry(REDUCE, 228);
   _actionMap[706][SEMICOLON] = ActionEntry(REDUCE, 230);
   _actionMap[706][KSEP] = ActionEntry(REDUCE, 230);
   _actionMap[707][DEFAULT] = ActionEntry(SHIFT, 791);
   _actionMap[707][INT] = ActionEntry(SHIFT, 733);
   _actionMap[707][LONG] = ActionEntry(SHIFT, 734);
   _actionMap[707][STRING] = ActionEntry(SHIFT, 736);
   _actionMap[707][DATETIME] = ActionEntry(SHIFT, 729);
   _actionMap[707][BOOL] = ActionEntry(SHIFT, 727);
   _actionMap[707][BIGINT] = ActionEntry(SHIFT, 725);
   _actionMap[707][FLOAT] = ActionEntry(SHIFT, 732);
   _actionMap[707][DOUBLE] = ActionEntry(SHIFT, 731);
   _actionMap[707][SMALLINT] = ActionEntry(SHIFT, 735);
   _actionMap[707][TINYINT] = ActionEntry(SHIFT, 737);
   _actionMap[707][DECIMAL] = ActionEntry(SHIFT, 730);
   _actionMap[707][BLOB] = ActionEntry(SHIFT, 726);
   _actionMap[707][CLOB] = ActionEntry(SHIFT, 728);
   _jumpMap[707][DataTypeProd] = 751;
   _actionMap[708][TO] = ActionEntry(SHIFT, 792);
   _actionMap[709][IDENTIFIER] = ActionEntry(SHIFT, 793);
   _actionMap[710][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[710][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[710][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[710][KSEP] = ActionEntry(REDUCE, 281);
   _actionMap[710][RB] = ActionEntry(REDUCE, 281);
   _actionMap[711][ELSE] = ActionEntry(REDUCE, 276);
   _actionMap[711][ELSIF] = ActionEntry(REDUCE, 276);
}
void Cego::loadParser35()
{
   _actionMap[711][EXCEPTION] = ActionEntry(REDUCE, 276);
   _actionMap[711][END_TOKEN] = ActionEntry(REDUCE, 276);
   _actionMap[712][WHEN] = ActionEntry(SHIFT, 794);
   _actionMap[713][EXCEPTION] = ActionEntry(REDUCE, 252);
   _actionMap[713][END_TOKEN] = ActionEntry(REDUCE, 252);
   _actionMap[713][ELSE] = ActionEntry(REDUCE, 252);
   _actionMap[713][ELSIF] = ActionEntry(REDUCE, 252);
   _actionMap[713][VAR] = ActionEntry(REDUCE, 252);
   _actionMap[713][CURSOR] = ActionEntry(REDUCE, 252);
   _actionMap[713][CLOSE] = ActionEntry(REDUCE, 252);
   _actionMap[713][VARREF] = ActionEntry(REDUCE, 252);
   _actionMap[713][NOOP] = ActionEntry(REDUCE, 252);
   _actionMap[713][THROW] = ActionEntry(REDUCE, 252);
   _actionMap[713][RETURNTOKEN] = ActionEntry(REDUCE, 252);
   _actionMap[713][WHILE] = ActionEntry(REDUCE, 252);
   _actionMap[713][IF] = ActionEntry(REDUCE, 252);
   _actionMap[713][BEGIN] = ActionEntry(REDUCE, 252);
   _actionMap[713][UNLOCK] = ActionEntry(REDUCE, 252);
   _actionMap[713][LOCK] = ActionEntry(REDUCE, 252);
   _actionMap[713][ROLLBACK] = ActionEntry(REDUCE, 252);
   _actionMap[713][COMMIT] = ActionEntry(REDUCE, 252);
   _actionMap[713][START_TOKEN] = ActionEntry(REDUCE, 252);
   _actionMap[713][UPDATE] = ActionEntry(REDUCE, 252);
   _actionMap[713][DELETETOK] = ActionEntry(REDUCE, 252);
   _actionMap[713][INSERT] = ActionEntry(REDUCE, 252);
   _actionMap[713][FETCH] = ActionEntry(REDUCE, 252);
   _actionMap[713][LB] = ActionEntry(REDUCE, 252);
   _actionMap[713][COUNT] = ActionEntry(REDUCE, 252);
   _actionMap[713][SUM] = ActionEntry(REDUCE, 252);
   _actionMap[713][AVG] = ActionEntry(REDUCE, 252);
   _actionMap[713][MIN] = ActionEntry(REDUCE, 252);
   _actionMap[713][MAX] = ActionEntry(REDUCE, 252);
   _actionMap[713][CASE] = ActionEntry(REDUCE, 252);
   _actionMap[713][INT2ASC] = ActionEntry(REDUCE, 252);
   _actionMap[713][ASC2INT] = ActionEntry(REDUCE, 252);
   _actionMap[713][TRIM] = ActionEntry(REDUCE, 252);
   _actionMap[713][RTRIM] = ActionEntry(REDUCE, 252);
   _actionMap[713][LTRIM] = ActionEntry(REDUCE, 252);
   _actionMap[713][ROUND] = ActionEntry(REDUCE, 252);
   _actionMap[713][SCANDATE] = ActionEntry(REDUCE, 252);
   _actionMap[713][DATE2STR] = ActionEntry(REDUCE, 252);
   _actionMap[713][DATE2LONG] = ActionEntry(REDUCE, 252);
   _actionMap[713][LONG2DATE] = ActionEntry(REDUCE, 252);
   _actionMap[713][NEWDATE] = ActionEntry(REDUCE, 252);
   _actionMap[713][LOWER] = ActionEntry(REDUCE, 252);
   _actionMap[713][UPPER] = ActionEntry(REDUCE, 252);
   _actionMap[713][LEFT] = ActionEntry(REDUCE, 252);
   _actionMap[713][RIGHT] = ActionEntry(REDUCE, 252);
   _actionMap[713][GETPOS] = ActionEntry(REDUCE, 252);
   _actionMap[713][SUBSTR] = ActionEntry(REDUCE, 252);
}
void Cego::loadParser36()
{
   _actionMap[713][REPLACE] = ActionEntry(REDUCE, 252);
   _actionMap[713][LENGTH] = ActionEntry(REDUCE, 252);
   _actionMap[713][TRUNC] = ActionEntry(REDUCE, 252);
   _actionMap[713][STR2INT] = ActionEntry(REDUCE, 252);
   _actionMap[713][STR2LONG] = ActionEntry(REDUCE, 252);
   _actionMap[713][RANDSTR] = ActionEntry(REDUCE, 252);
   _actionMap[713][RANDINT] = ActionEntry(REDUCE, 252);
   _actionMap[713][MOD] = ActionEntry(REDUCE, 252);
   _actionMap[713][DIV] = ActionEntry(REDUCE, 252);
   _actionMap[713][LMOD] = ActionEntry(REDUCE, 252);
   _actionMap[713][LDIV] = ActionEntry(REDUCE, 252);
   _actionMap[713][POWER] = ActionEntry(REDUCE, 252);
   _actionMap[713][BITAND] = ActionEntry(REDUCE, 252);
   _actionMap[713][BITOR] = ActionEntry(REDUCE, 252);
   _actionMap[713][BITXOR] = ActionEntry(REDUCE, 252);
   _actionMap[713][BLOBSIZE] = ActionEntry(REDUCE, 252);
   _actionMap[713][BLOBREF] = ActionEntry(REDUCE, 252);
   _actionMap[713][CLOBSIZE] = ActionEntry(REDUCE, 252);
   _actionMap[713][CLOBREF] = ActionEntry(REDUCE, 252);
   _actionMap[713][CLOB2STR] = ActionEntry(REDUCE, 252);
   _actionMap[713][NEXTCOUNT] = ActionEntry(REDUCE, 252);
   _actionMap[713][SETCOUNT] = ActionEntry(REDUCE, 252);
   _actionMap[713][GETCOUNT] = ActionEntry(REDUCE, 252);
   _actionMap[713][IDENTIFIER] = ActionEntry(REDUCE, 252);
   _actionMap[713][QUALIFIEDOBJ] = ActionEntry(REDUCE, 252);
   _actionMap[713][QUALIFIEDTS] = ActionEntry(REDUCE, 252);
   _actionMap[713][QUALIFIEDPRE] = ActionEntry(REDUCE, 252);
   _actionMap[713][STRINGVAL] = ActionEntry(REDUCE, 252);
   _actionMap[713][SYSDATE] = ActionEntry(REDUCE, 252);
   _actionMap[713][NULLTOKEN] = ActionEntry(REDUCE, 252);
   _actionMap[713][TRUEVAL] = ActionEntry(REDUCE, 252);
   _actionMap[713][FALSEVAL] = ActionEntry(REDUCE, 252);
   _actionMap[713][BLOB] = ActionEntry(REDUCE, 252);
   _actionMap[713][CLOB] = ActionEntry(REDUCE, 252);
   _actionMap[713][FLOATVAL] = ActionEntry(REDUCE, 252);
   _actionMap[713][MINUS] = ActionEntry(REDUCE, 252);
   _actionMap[713][INTVAL] = ActionEntry(REDUCE, 252);
   _actionMap[714][SEMICOLON] = ActionEntry(REDUCE, 274);
   _actionMap[715][END_TOKEN] = ActionEntry(SHIFT, 718);
   _actionMap[716][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[716][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[716][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[716][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[716][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[716][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[716][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[716][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[716][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[716][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[716][DATE2STR] = ActionEntry(SHIFT, 138);
}
void Cego::loadParser37()
{
   _actionMap[716][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[716][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[716][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[716][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[716][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[716][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[716][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[716][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[716][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[716][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[716][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[716][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[716][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[716][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[716][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[716][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[716][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[716][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[716][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[716][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[716][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[716][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[716][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[716][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[716][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[716][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[716][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[716][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[716][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[716][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[716][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[716][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[716][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[716][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[716][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[716][LB] = ActionEntry(SHIFT, 177);
   _actionMap[716][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[716][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[716][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[716][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[716][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[716][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[716][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[716][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[716][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[716][VARREF] = ActionEntry(SHIFT, 418);
   _actionMap[716][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[716][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[716][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[716][AVG] = ActionEntry(SHIFT, 125);
}
void Cego::loadParser38()
{
   _actionMap[716][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[716][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[716][IF] = ActionEntry(SHIFT, 412);
   _actionMap[716][BEGIN] = ActionEntry(SHIFT, 409);
   _actionMap[716][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[716][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[716][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[716][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[716][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[716][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[716][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[716][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[716][VAR] = ActionEntry(SHIFT, 416);
   _actionMap[716][CURSOR] = ActionEntry(SHIFT, 411);
   _actionMap[716][CLOSE] = ActionEntry(SHIFT, 410);
   _actionMap[716][NOOP] = ActionEntry(SHIFT, 413);
   _actionMap[716][THROW] = ActionEntry(SHIFT, 415);
   _actionMap[716][RETURNTOKEN] = ActionEntry(SHIFT, 414);
   _actionMap[716][WHILE] = ActionEntry(SHIFT, 417);
   _jumpMap[716][ObjSpec] = 122;
   _jumpMap[716][Constant] = 121;
   _jumpMap[716][SignedFloat] = 120;
   _jumpMap[716][SignedInt] = 119;
   _jumpMap[716][Attribute] = 118;
   _jumpMap[716][Function] = 117;
   _jumpMap[716][Factor] = 116;
   _jumpMap[716][Term] = 115;
   _jumpMap[716][Expr] = 408;
   _jumpMap[716][ProcStatement] = 407;
   _jumpMap[716][ProcIfPart] = 406;
   _jumpMap[716][ProcBlockStart] = 405;
   _jumpMap[716][ProcStatementList] = 404;
   _jumpMap[716][ProcStmtBlock] = 795;
   _jumpMap[716][DeleteStatement] = 402;
   _jumpMap[716][UpdateStatement] = 401;
   _jumpMap[716][InsertStatement] = 400;
   _jumpMap[716][UnlockStatement] = 399;
   _jumpMap[716][LockStatement] = 398;
   _jumpMap[716][RollbackStatement] = 397;
   _jumpMap[716][CommitStatement] = 396;
   _jumpMap[716][StartStatement] = 395;
   _jumpMap[716][CasePrepare] = 113;
   _jumpMap[716][CaseClause] = 112;
   _actionMap[717][VAR] = ActionEntry(REDUCE, 291);
   _actionMap[717][CURSOR] = ActionEntry(REDUCE, 291);
   _actionMap[717][CLOSE] = ActionEntry(REDUCE, 291);
   _actionMap[717][VARREF] = ActionEntry(REDUCE, 291);
   _actionMap[717][NOOP] = ActionEntry(REDUCE, 291);
   _actionMap[717][THROW] = ActionEntry(REDUCE, 291);
   _actionMap[717][RETURNTOKEN] = ActionEntry(REDUCE, 291);
}
void Cego::loadParser39()
{
   _actionMap[717][WHILE] = ActionEntry(REDUCE, 291);
   _actionMap[717][IF] = ActionEntry(REDUCE, 291);
   _actionMap[717][BEGIN] = ActionEntry(REDUCE, 291);
   _actionMap[717][UNLOCK] = ActionEntry(REDUCE, 291);
   _actionMap[717][LOCK] = ActionEntry(REDUCE, 291);
   _actionMap[717][ROLLBACK] = ActionEntry(REDUCE, 291);
   _actionMap[717][COMMIT] = ActionEntry(REDUCE, 291);
   _actionMap[717][START_TOKEN] = ActionEntry(REDUCE, 291);
   _actionMap[717][UPDATE] = ActionEntry(REDUCE, 291);
   _actionMap[717][DELETETOK] = ActionEntry(REDUCE, 291);
   _actionMap[717][INSERT] = ActionEntry(REDUCE, 291);
   _actionMap[717][FETCH] = ActionEntry(REDUCE, 291);
   _actionMap[717][LB] = ActionEntry(REDUCE, 291);
   _actionMap[717][COUNT] = ActionEntry(REDUCE, 291);
   _actionMap[717][SUM] = ActionEntry(REDUCE, 291);
   _actionMap[717][AVG] = ActionEntry(REDUCE, 291);
   _actionMap[717][MIN] = ActionEntry(REDUCE, 291);
   _actionMap[717][MAX] = ActionEntry(REDUCE, 291);
   _actionMap[717][CASE] = ActionEntry(REDUCE, 291);
   _actionMap[717][INT2ASC] = ActionEntry(REDUCE, 291);
   _actionMap[717][ASC2INT] = ActionEntry(REDUCE, 291);
   _actionMap[717][TRIM] = ActionEntry(REDUCE, 291);
   _actionMap[717][RTRIM] = ActionEntry(REDUCE, 291);
   _actionMap[717][LTRIM] = ActionEntry(REDUCE, 291);
   _actionMap[717][ROUND] = ActionEntry(REDUCE, 291);
   _actionMap[717][SCANDATE] = ActionEntry(REDUCE, 291);
   _actionMap[717][DATE2STR] = ActionEntry(REDUCE, 291);
   _actionMap[717][DATE2LONG] = ActionEntry(REDUCE, 291);
   _actionMap[717][LONG2DATE] = ActionEntry(REDUCE, 291);
   _actionMap[717][NEWDATE] = ActionEntry(REDUCE, 291);
   _actionMap[717][LOWER] = ActionEntry(REDUCE, 291);
   _actionMap[717][UPPER] = ActionEntry(REDUCE, 291);
   _actionMap[717][LEFT] = ActionEntry(REDUCE, 291);
   _actionMap[717][RIGHT] = ActionEntry(REDUCE, 291);
   _actionMap[717][GETPOS] = ActionEntry(REDUCE, 291);
   _actionMap[717][SUBSTR] = ActionEntry(REDUCE, 291);
   _actionMap[717][REPLACE] = ActionEntry(REDUCE, 291);
   _actionMap[717][LENGTH] = ActionEntry(REDUCE, 291);
   _actionMap[717][TRUNC] = ActionEntry(REDUCE, 291);
   _actionMap[717][STR2INT] = ActionEntry(REDUCE, 291);
   _actionMap[717][STR2LONG] = ActionEntry(REDUCE, 291);
   _actionMap[717][RANDSTR] = ActionEntry(REDUCE, 291);
   _actionMap[717][RANDINT] = ActionEntry(REDUCE, 291);
   _actionMap[717][MOD] = ActionEntry(REDUCE, 291);
   _actionMap[717][DIV] = ActionEntry(REDUCE, 291);
   _actionMap[717][LMOD] = ActionEntry(REDUCE, 291);
   _actionMap[717][LDIV] = ActionEntry(REDUCE, 291);
   _actionMap[717][POWER] = ActionEntry(REDUCE, 291);
   _actionMap[717][BITAND] = ActionEntry(REDUCE, 291);
   _actionMap[717][BITOR] = ActionEntry(REDUCE, 291);
}
void Cego::loadParser40()
{
   _actionMap[717][BITXOR] = ActionEntry(REDUCE, 291);
   _actionMap[717][BLOBSIZE] = ActionEntry(REDUCE, 291);
   _actionMap[717][BLOBREF] = ActionEntry(REDUCE, 291);
   _actionMap[717][CLOBSIZE] = ActionEntry(REDUCE, 291);
   _actionMap[717][CLOBREF] = ActionEntry(REDUCE, 291);
   _actionMap[717][CLOB2STR] = ActionEntry(REDUCE, 291);
   _actionMap[717][NEXTCOUNT] = ActionEntry(REDUCE, 291);
   _actionMap[717][SETCOUNT] = ActionEntry(REDUCE, 291);
   _actionMap[717][GETCOUNT] = ActionEntry(REDUCE, 291);
   _actionMap[717][IDENTIFIER] = ActionEntry(REDUCE, 291);
   _actionMap[717][QUALIFIEDOBJ] = ActionEntry(REDUCE, 291);
   _actionMap[717][QUALIFIEDTS] = ActionEntry(REDUCE, 291);
   _actionMap[717][QUALIFIEDPRE] = ActionEntry(REDUCE, 291);
   _actionMap[717][STRINGVAL] = ActionEntry(REDUCE, 291);
   _actionMap[717][SYSDATE] = ActionEntry(REDUCE, 291);
   _actionMap[717][NULLTOKEN] = ActionEntry(REDUCE, 291);
   _actionMap[717][TRUEVAL] = ActionEntry(REDUCE, 291);
   _actionMap[717][FALSEVAL] = ActionEntry(REDUCE, 291);
   _actionMap[717][BLOB] = ActionEntry(REDUCE, 291);
   _actionMap[717][CLOB] = ActionEntry(REDUCE, 291);
   _actionMap[717][FLOATVAL] = ActionEntry(REDUCE, 291);
   _actionMap[717][MINUS] = ActionEntry(REDUCE, 291);
   _actionMap[717][INTVAL] = ActionEntry(REDUCE, 291);
   _actionMap[718][SEMICOLON] = ActionEntry(REDUCE, 284);
   _actionMap[719][END_TOKEN] = ActionEntry(REDUCE, 286);
   _actionMap[719][ELSE] = ActionEntry(REDUCE, 286);
   _actionMap[720][THEN] = ActionEntry(SHIFT, 796);
   _actionMap[721][AND] = ActionEntry(SHIFT, 440);
   _actionMap[721][OR] = ActionEntry(SHIFT, 441);
   _actionMap[721][THEN] = ActionEntry(REDUCE, 293);
   _actionMap[722][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[722][SelectStatement] = 797;
   _actionMap[723][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[723][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[723][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[723][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[723][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[723][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[723][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[723][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[723][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[723][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[723][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[723][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[723][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[723][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[723][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[723][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[723][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[723][RIGHT] = ActionEntry(SHIFT, 163);
}
void Cego::loadParser41()
{
   _actionMap[723][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[723][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[723][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[723][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[723][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[723][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[723][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[723][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[723][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[723][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[723][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[723][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[723][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[723][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[723][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[723][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[723][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[723][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[723][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[723][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[723][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[723][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[723][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[723][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[723][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[723][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[723][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[723][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[723][LB] = ActionEntry(SHIFT, 177);
   _actionMap[723][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[723][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[723][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[723][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[723][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[723][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[723][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[723][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[723][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[723][VARREF] = ActionEntry(SHIFT, 418);
   _actionMap[723][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[723][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[723][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[723][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[723][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[723][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[723][IF] = ActionEntry(SHIFT, 412);
   _actionMap[723][BEGIN] = ActionEntry(SHIFT, 409);
   _actionMap[723][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[723][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[723][ROLLBACK] = ActionEntry(SHIFT, 33);
}
void Cego::loadParser42()
{
   _actionMap[723][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[723][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[723][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[723][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[723][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[723][VAR] = ActionEntry(SHIFT, 416);
   _actionMap[723][CURSOR] = ActionEntry(SHIFT, 411);
   _actionMap[723][CLOSE] = ActionEntry(SHIFT, 410);
   _actionMap[723][NOOP] = ActionEntry(SHIFT, 413);
   _actionMap[723][THROW] = ActionEntry(SHIFT, 415);
   _actionMap[723][RETURNTOKEN] = ActionEntry(SHIFT, 414);
   _actionMap[723][WHILE] = ActionEntry(SHIFT, 417);
   _jumpMap[723][ObjSpec] = 122;
   _jumpMap[723][Constant] = 121;
   _jumpMap[723][SignedFloat] = 120;
   _jumpMap[723][SignedInt] = 119;
   _jumpMap[723][Attribute] = 118;
   _jumpMap[723][Function] = 117;
   _jumpMap[723][Factor] = 116;
   _jumpMap[723][Term] = 115;
   _jumpMap[723][Expr] = 408;
   _jumpMap[723][ProcStatement] = 407;
   _jumpMap[723][ProcIfPart] = 406;
   _jumpMap[723][ProcBlockStart] = 405;
   _jumpMap[723][ProcStatementList] = 404;
   _jumpMap[723][ProcStmtBlock] = 798;
   _jumpMap[723][DeleteStatement] = 402;
   _jumpMap[723][UpdateStatement] = 401;
   _jumpMap[723][InsertStatement] = 400;
   _jumpMap[723][UnlockStatement] = 399;
   _jumpMap[723][LockStatement] = 398;
   _jumpMap[723][RollbackStatement] = 397;
   _jumpMap[723][CommitStatement] = 396;
   _jumpMap[723][StartStatement] = 395;
   _jumpMap[723][CasePrepare] = 113;
   _jumpMap[723][CaseClause] = 112;
   _actionMap[724][SEMICOLON] = ActionEntry(REDUCE, 262);
   _actionMap[724][EQU] = ActionEntry(SHIFT, 801);
   _jumpMap[724][ProcNoAssignment] = 800;
   _jumpMap[724][ProcInitialAssignment] = 799;
   _actionMap[725][LB] = ActionEntry(SHIFT, 802);
   _actionMap[726][BEGIN] = ActionEntry(REDUCE, 388);
   _actionMap[726][EQU] = ActionEntry(REDUCE, 388);
   _actionMap[726][DEFAULT] = ActionEntry(REDUCE, 388);
   _actionMap[726][NULLTOKEN] = ActionEntry(REDUCE, 388);
   _actionMap[726][NOT] = ActionEntry(REDUCE, 388);
   _actionMap[726][KSEP] = ActionEntry(REDUCE, 388);
   _actionMap[726][SEMICOLON] = ActionEntry(REDUCE, 388);
   _actionMap[726][RB] = ActionEntry(REDUCE, 388);
   _actionMap[727][BEGIN] = ActionEntry(REDUCE, 381);
}
void Cego::loadParser43()
{
   _actionMap[727][EQU] = ActionEntry(REDUCE, 381);
   _actionMap[727][DEFAULT] = ActionEntry(REDUCE, 381);
   _actionMap[727][NULLTOKEN] = ActionEntry(REDUCE, 381);
   _actionMap[727][NOT] = ActionEntry(REDUCE, 381);
   _actionMap[727][KSEP] = ActionEntry(REDUCE, 381);
   _actionMap[727][SEMICOLON] = ActionEntry(REDUCE, 381);
   _actionMap[727][RB] = ActionEntry(REDUCE, 381);
   _actionMap[728][BEGIN] = ActionEntry(REDUCE, 389);
   _actionMap[728][EQU] = ActionEntry(REDUCE, 389);
   _actionMap[728][DEFAULT] = ActionEntry(REDUCE, 389);
   _actionMap[728][NULLTOKEN] = ActionEntry(REDUCE, 389);
   _actionMap[728][NOT] = ActionEntry(REDUCE, 389);
   _actionMap[728][KSEP] = ActionEntry(REDUCE, 389);
   _actionMap[728][SEMICOLON] = ActionEntry(REDUCE, 389);
   _actionMap[728][RB] = ActionEntry(REDUCE, 389);
   _actionMap[729][BEGIN] = ActionEntry(REDUCE, 380);
   _actionMap[729][EQU] = ActionEntry(REDUCE, 380);
   _actionMap[729][DEFAULT] = ActionEntry(REDUCE, 380);
   _actionMap[729][NULLTOKEN] = ActionEntry(REDUCE, 380);
   _actionMap[729][NOT] = ActionEntry(REDUCE, 380);
   _actionMap[729][KSEP] = ActionEntry(REDUCE, 380);
   _actionMap[729][SEMICOLON] = ActionEntry(REDUCE, 380);
   _actionMap[729][RB] = ActionEntry(REDUCE, 380);
   _actionMap[730][LB] = ActionEntry(SHIFT, 803);
   _actionMap[731][BEGIN] = ActionEntry(REDUCE, 384);
   _actionMap[731][EQU] = ActionEntry(REDUCE, 384);
   _actionMap[731][DEFAULT] = ActionEntry(REDUCE, 384);
   _actionMap[731][NULLTOKEN] = ActionEntry(REDUCE, 384);
   _actionMap[731][NOT] = ActionEntry(REDUCE, 384);
   _actionMap[731][KSEP] = ActionEntry(REDUCE, 384);
   _actionMap[731][SEMICOLON] = ActionEntry(REDUCE, 384);
   _actionMap[731][RB] = ActionEntry(REDUCE, 384);
   _actionMap[732][BEGIN] = ActionEntry(REDUCE, 383);
   _actionMap[732][EQU] = ActionEntry(REDUCE, 383);
   _actionMap[732][DEFAULT] = ActionEntry(REDUCE, 383);
   _actionMap[732][NULLTOKEN] = ActionEntry(REDUCE, 383);
   _actionMap[732][NOT] = ActionEntry(REDUCE, 383);
   _actionMap[732][KSEP] = ActionEntry(REDUCE, 383);
   _actionMap[732][SEMICOLON] = ActionEntry(REDUCE, 383);
   _actionMap[732][RB] = ActionEntry(REDUCE, 383);
   _actionMap[733][BEGIN] = ActionEntry(REDUCE, 377);
   _actionMap[733][EQU] = ActionEntry(REDUCE, 377);
   _actionMap[733][DEFAULT] = ActionEntry(REDUCE, 377);
   _actionMap[733][NULLTOKEN] = ActionEntry(REDUCE, 377);
   _actionMap[733][NOT] = ActionEntry(REDUCE, 377);
   _actionMap[733][KSEP] = ActionEntry(REDUCE, 377);
   _actionMap[733][SEMICOLON] = ActionEntry(REDUCE, 377);
   _actionMap[733][RB] = ActionEntry(REDUCE, 377);
   _actionMap[734][BEGIN] = ActionEntry(REDUCE, 378);
   _actionMap[734][EQU] = ActionEntry(REDUCE, 378);
}
void Cego::loadParser44()
{
   _actionMap[734][DEFAULT] = ActionEntry(REDUCE, 378);
   _actionMap[734][NULLTOKEN] = ActionEntry(REDUCE, 378);
   _actionMap[734][NOT] = ActionEntry(REDUCE, 378);
   _actionMap[734][KSEP] = ActionEntry(REDUCE, 378);
   _actionMap[734][SEMICOLON] = ActionEntry(REDUCE, 378);
   _actionMap[734][RB] = ActionEntry(REDUCE, 378);
   _actionMap[735][BEGIN] = ActionEntry(REDUCE, 385);
   _actionMap[735][EQU] = ActionEntry(REDUCE, 385);
   _actionMap[735][DEFAULT] = ActionEntry(REDUCE, 385);
   _actionMap[735][NULLTOKEN] = ActionEntry(REDUCE, 385);
   _actionMap[735][NOT] = ActionEntry(REDUCE, 385);
   _actionMap[735][KSEP] = ActionEntry(REDUCE, 385);
   _actionMap[735][SEMICOLON] = ActionEntry(REDUCE, 385);
   _actionMap[735][RB] = ActionEntry(REDUCE, 385);
   _actionMap[736][LB] = ActionEntry(SHIFT, 804);
   _actionMap[737][BEGIN] = ActionEntry(REDUCE, 386);
   _actionMap[737][EQU] = ActionEntry(REDUCE, 386);
   _actionMap[737][DEFAULT] = ActionEntry(REDUCE, 386);
   _actionMap[737][NULLTOKEN] = ActionEntry(REDUCE, 386);
   _actionMap[737][NOT] = ActionEntry(REDUCE, 386);
   _actionMap[737][KSEP] = ActionEntry(REDUCE, 386);
   _actionMap[737][SEMICOLON] = ActionEntry(REDUCE, 386);
   _actionMap[737][RB] = ActionEntry(REDUCE, 386);
   _actionMap[738][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[738][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[738][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[738][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[738][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[738][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[738][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[738][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[738][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[738][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[738][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[738][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[738][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[738][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[738][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[738][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[738][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[738][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[738][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[738][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[738][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[738][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[738][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[738][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[738][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[738][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[738][RANDINT] = ActionEntry(SHIFT, 161);
}
void Cego::loadParser45()
{
   _actionMap[738][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[738][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[738][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[738][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[738][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[738][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[738][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[738][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[738][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[738][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[738][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[738][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[738][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[738][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[738][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[738][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[738][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[738][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[738][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[738][LB] = ActionEntry(SHIFT, 177);
   _actionMap[738][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[738][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[738][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[738][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[738][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[738][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[738][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[738][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[738][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[738][VARREF] = ActionEntry(SHIFT, 418);
   _actionMap[738][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[738][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[738][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[738][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[738][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[738][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[738][IF] = ActionEntry(SHIFT, 412);
   _actionMap[738][BEGIN] = ActionEntry(SHIFT, 409);
   _actionMap[738][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[738][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[738][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[738][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[738][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[738][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[738][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[738][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[738][VAR] = ActionEntry(SHIFT, 416);
   _actionMap[738][CURSOR] = ActionEntry(SHIFT, 411);
   _actionMap[738][CLOSE] = ActionEntry(SHIFT, 410);
   _actionMap[738][NOOP] = ActionEntry(SHIFT, 413);
}
void Cego::loadParser46()
{
   _actionMap[738][THROW] = ActionEntry(SHIFT, 415);
   _actionMap[738][RETURNTOKEN] = ActionEntry(SHIFT, 414);
   _actionMap[738][WHILE] = ActionEntry(SHIFT, 417);
   _jumpMap[738][ObjSpec] = 122;
   _jumpMap[738][Constant] = 121;
   _jumpMap[738][SignedFloat] = 120;
   _jumpMap[738][SignedInt] = 119;
   _jumpMap[738][Attribute] = 118;
   _jumpMap[738][Function] = 117;
   _jumpMap[738][Factor] = 116;
   _jumpMap[738][Term] = 115;
   _jumpMap[738][Expr] = 408;
   _jumpMap[738][ProcStatement] = 407;
   _jumpMap[738][ProcIfPart] = 406;
   _jumpMap[738][ProcBlockStart] = 405;
   _jumpMap[738][ProcStatementList] = 404;
   _jumpMap[738][ProcStmtBlock] = 805;
   _jumpMap[738][DeleteStatement] = 402;
   _jumpMap[738][UpdateStatement] = 401;
   _jumpMap[738][InsertStatement] = 400;
   _jumpMap[738][UnlockStatement] = 399;
   _jumpMap[738][LockStatement] = 398;
   _jumpMap[738][RollbackStatement] = 397;
   _jumpMap[738][CommitStatement] = 396;
   _jumpMap[738][StartStatement] = 395;
   _jumpMap[738][CasePrepare] = 113;
   _jumpMap[738][CaseClause] = 112;
   _actionMap[739][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[739][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[739][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[739][SEMICOLON] = ActionEntry(REDUCE, 257);
   _actionMap[740][LB] = ActionEntry(SHIFT, 806);
   _actionMap[741][IDENTIFIER] = ActionEntry(SHIFT, 809);
   _jumpMap[741][AliasAttr] = 808;
   _jumpMap[741][AliasAttrList] = 807;
   _actionMap[742][IDENTIFIER] = ActionEntry(SHIFT, 812);
   _jumpMap[742][SimpleAttr] = 811;
   _jumpMap[742][SimpleAttrList] = 810;
   _actionMap[743][IDENTIFIER] = ActionEntry(SHIFT, 581);
   _jumpMap[743][ProcArg] = 813;
   _actionMap[744][BEGIN] = ActionEntry(REDUCE, 241);
   _actionMap[745][INT] = ActionEntry(SHIFT, 733);
   _actionMap[745][LONG] = ActionEntry(SHIFT, 734);
   _actionMap[745][STRING] = ActionEntry(SHIFT, 736);
   _actionMap[745][DATETIME] = ActionEntry(SHIFT, 729);
   _actionMap[745][BOOL] = ActionEntry(SHIFT, 727);
   _actionMap[745][BIGINT] = ActionEntry(SHIFT, 725);
   _actionMap[745][FLOAT] = ActionEntry(SHIFT, 732);
   _actionMap[745][DOUBLE] = ActionEntry(SHIFT, 731);
   _actionMap[745][SMALLINT] = ActionEntry(SHIFT, 735);
}
void Cego::loadParser47()
{
   _actionMap[745][TINYINT] = ActionEntry(SHIFT, 737);
   _actionMap[745][DECIMAL] = ActionEntry(SHIFT, 730);
   _actionMap[745][BLOB] = ActionEntry(SHIFT, 726);
   _actionMap[745][CLOB] = ActionEntry(SHIFT, 728);
   _jumpMap[745][DataTypeProd] = 814;
   _actionMap[746][INT] = ActionEntry(SHIFT, 733);
   _actionMap[746][LONG] = ActionEntry(SHIFT, 734);
   _actionMap[746][STRING] = ActionEntry(SHIFT, 736);
   _actionMap[746][DATETIME] = ActionEntry(SHIFT, 729);
   _actionMap[746][BOOL] = ActionEntry(SHIFT, 727);
   _actionMap[746][BIGINT] = ActionEntry(SHIFT, 725);
   _actionMap[746][FLOAT] = ActionEntry(SHIFT, 732);
   _actionMap[746][DOUBLE] = ActionEntry(SHIFT, 731);
   _actionMap[746][SMALLINT] = ActionEntry(SHIFT, 735);
   _actionMap[746][TINYINT] = ActionEntry(SHIFT, 737);
   _actionMap[746][DECIMAL] = ActionEntry(SHIFT, 730);
   _actionMap[746][BLOB] = ActionEntry(SHIFT, 726);
   _actionMap[746][CLOB] = ActionEntry(SHIFT, 728);
   _jumpMap[746][DataTypeProd] = 815;
   _actionMap[747][INT] = ActionEntry(SHIFT, 733);
   _actionMap[747][LONG] = ActionEntry(SHIFT, 734);
   _actionMap[747][STRING] = ActionEntry(SHIFT, 736);
   _actionMap[747][DATETIME] = ActionEntry(SHIFT, 729);
   _actionMap[747][BOOL] = ActionEntry(SHIFT, 727);
   _actionMap[747][BIGINT] = ActionEntry(SHIFT, 725);
   _actionMap[747][FLOAT] = ActionEntry(SHIFT, 732);
   _actionMap[747][DOUBLE] = ActionEntry(SHIFT, 731);
   _actionMap[747][SMALLINT] = ActionEntry(SHIFT, 735);
   _actionMap[747][TINYINT] = ActionEntry(SHIFT, 737);
   _actionMap[747][DECIMAL] = ActionEntry(SHIFT, 730);
   _actionMap[747][BLOB] = ActionEntry(SHIFT, 726);
   _actionMap[747][CLOB] = ActionEntry(SHIFT, 728);
   _jumpMap[747][DataTypeProd] = 816;
   _actionMap[748][IDENTIFIER] = ActionEntry(SHIFT, 586);
   _actionMap[748][PRIMARY] = ActionEntry(SHIFT, 585);
   _jumpMap[748][ColumnDesc] = 584;
   _jumpMap[748][KeyColumn] = 817;
   _actionMap[749][SEMICOLON] = ActionEntry(REDUCE, 64);
   _actionMap[750][KSEP] = ActionEntry(REDUCE, 118);
   _actionMap[750][RB] = ActionEntry(REDUCE, 118);
   _actionMap[751][RB] = ActionEntry(REDUCE, 127);
   _actionMap[751][SEMICOLON] = ActionEntry(REDUCE, 127);
   _actionMap[751][KSEP] = ActionEntry(REDUCE, 127);
   _actionMap[751][NOT] = ActionEntry(REDUCE, 127);
   _actionMap[751][NULLTOKEN] = ActionEntry(REDUCE, 127);
   _actionMap[751][DEFAULT] = ActionEntry(SHIFT, 820);
   _jumpMap[751][DefaultDefOpt] = 819;
   _jumpMap[751][DefaultOpt] = 818;
   _actionMap[752][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[752][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
}
void Cego::loadParser48()
{
   _actionMap[752][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[752][ObjSpec] = 821;
   _actionMap[753][INSERT] = ActionEntry(SHIFT, 590);
   _actionMap[753][UPDATE] = ActionEntry(SHIFT, 591);
   _actionMap[753][DELETETOK] = ActionEntry(SHIFT, 589);
   _jumpMap[753][TriggerOp] = 822;
   _actionMap[754][LB] = ActionEntry(SHIFT, 596);
   _jumpMap[754][InsertValueSpec] = 823;
   _actionMap[755][RB] = ActionEntry(SHIFT, 825);
   _actionMap[755][KSEP] = ActionEntry(SHIFT, 824);
   _actionMap[756][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[756][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[756][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[756][KSEP] = ActionEntry(REDUCE, 153);
   _actionMap[756][RB] = ActionEntry(REDUCE, 153);
   _actionMap[757][IDENTIFIER] = ActionEntry(SHIFT, 826);
   _actionMap[758][SELECT] = ActionEntry(REDUCE, 144);
   _actionMap[758][VALUES] = ActionEntry(REDUCE, 144);
   _actionMap[759][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[759][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[759][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[759][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[759][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[759][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[759][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[759][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[759][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[759][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[759][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[759][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[759][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[759][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[759][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[759][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[759][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[759][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[759][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[759][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[759][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[759][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[759][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[759][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[759][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[759][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[759][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[759][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[759][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[759][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[759][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[759][POWER] = ActionEntry(SHIFT, 159);
}
void Cego::loadParser49()
{
   _actionMap[759][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[759][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[759][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[759][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[759][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[759][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[759][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[759][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[759][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[759][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[759][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[759][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[759][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[759][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[759][LB] = ActionEntry(SHIFT, 177);
   _actionMap[759][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[759][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[759][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[759][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[759][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[759][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[759][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[759][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[759][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[759][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[759][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[759][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[759][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[759][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[759][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[759][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[759][ObjSpec] = 122;
   _jumpMap[759][Constant] = 121;
   _jumpMap[759][SignedFloat] = 120;
   _jumpMap[759][SignedInt] = 119;
   _jumpMap[759][Attribute] = 118;
   _jumpMap[759][Function] = 117;
   _jumpMap[759][Factor] = 116;
   _jumpMap[759][Term] = 115;
   _jumpMap[759][Expr] = 827;
   _jumpMap[759][CasePrepare] = 113;
   _jumpMap[759][CaseClause] = 112;
   _actionMap[760][RB] = ActionEntry(SHIFT, 828);
   _actionMap[761][RB] = ActionEntry(SHIFT, 829);
   _actionMap[761][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[762][LEFT] = ActionEntry(REDUCE, 307);
   _actionMap[762][RIGHT] = ActionEntry(REDUCE, 307);
   _actionMap[762][INNER] = ActionEntry(REDUCE, 307);
   _actionMap[762][JOIN] = ActionEntry(REDUCE, 307);
   _actionMap[762][ENDTOKEN] = ActionEntry(REDUCE, 307);
}
void Cego::loadParser50()
{
   _actionMap[762][UNION] = ActionEntry(REDUCE, 307);
   _actionMap[762][ROWLIMIT] = ActionEntry(REDUCE, 307);
   _actionMap[762][ORDER] = ActionEntry(REDUCE, 307);
   _actionMap[762][GROUP] = ActionEntry(REDUCE, 307);
   _actionMap[762][SEMICOLON] = ActionEntry(REDUCE, 307);
   _actionMap[762][RETURNTOKEN] = ActionEntry(REDUCE, 307);
   _actionMap[762][WHERE] = ActionEntry(REDUCE, 307);
   _actionMap[762][RB] = ActionEntry(REDUCE, 307);
   _actionMap[762][BEGIN] = ActionEntry(REDUCE, 307);
   _actionMap[762][THEN] = ActionEntry(REDUCE, 307);
   _actionMap[762][AND] = ActionEntry(REDUCE, 307);
   _actionMap[762][OR] = ActionEntry(REDUCE, 307);
   _actionMap[763][SELECT] = ActionEntry(SHIFT, 34);
   _actionMap[763][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[763][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[763][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[763][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[763][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[763][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[763][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[763][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[763][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[763][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[763][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[763][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[763][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[763][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[763][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[763][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[763][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[763][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[763][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[763][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[763][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[763][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[763][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[763][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[763][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[763][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[763][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[763][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[763][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[763][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[763][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[763][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[763][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[763][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[763][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[763][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[763][BLOBREF] = ActionEntry(SHIFT, 131);
}
void Cego::loadParser51()
{
   _actionMap[763][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[763][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[763][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[763][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[763][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[763][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[763][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[763][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[763][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[763][LB] = ActionEntry(SHIFT, 177);
   _actionMap[763][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[763][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[763][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[763][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[763][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[763][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[763][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[763][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[763][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[763][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[763][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[763][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[763][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[763][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[763][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[763][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[763][ObjSpec] = 122;
   _jumpMap[763][Constant] = 121;
   _jumpMap[763][SignedFloat] = 120;
   _jumpMap[763][SignedInt] = 119;
   _jumpMap[763][Attribute] = 118;
   _jumpMap[763][ExpressionList] = 831;
   _jumpMap[763][Function] = 117;
   _jumpMap[763][Factor] = 116;
   _jumpMap[763][Term] = 115;
   _jumpMap[763][Expr] = 463;
   _jumpMap[763][SelectStatement] = 830;
   _jumpMap[763][CasePrepare] = 113;
   _jumpMap[763][CaseClause] = 112;
   _actionMap[764][LEFT] = ActionEntry(REDUCE, 309);
   _actionMap[764][RIGHT] = ActionEntry(REDUCE, 309);
   _actionMap[764][INNER] = ActionEntry(REDUCE, 309);
   _actionMap[764][JOIN] = ActionEntry(REDUCE, 309);
   _actionMap[764][ENDTOKEN] = ActionEntry(REDUCE, 309);
   _actionMap[764][UNION] = ActionEntry(REDUCE, 309);
   _actionMap[764][ROWLIMIT] = ActionEntry(REDUCE, 309);
   _actionMap[764][ORDER] = ActionEntry(REDUCE, 309);
   _actionMap[764][GROUP] = ActionEntry(REDUCE, 309);
   _actionMap[764][SEMICOLON] = ActionEntry(REDUCE, 309);
   _actionMap[764][RETURNTOKEN] = ActionEntry(REDUCE, 309);
}
void Cego::loadParser52()
{
   _actionMap[764][WHERE] = ActionEntry(REDUCE, 309);
   _actionMap[764][RB] = ActionEntry(REDUCE, 309);
   _actionMap[764][BEGIN] = ActionEntry(REDUCE, 309);
   _actionMap[764][THEN] = ActionEntry(REDUCE, 309);
   _actionMap[764][AND] = ActionEntry(REDUCE, 309);
   _actionMap[764][OR] = ActionEntry(REDUCE, 309);
   _actionMap[765][LEFT] = ActionEntry(REDUCE, 299);
   _actionMap[765][RIGHT] = ActionEntry(REDUCE, 299);
   _actionMap[765][INNER] = ActionEntry(REDUCE, 299);
   _actionMap[765][JOIN] = ActionEntry(REDUCE, 299);
   _actionMap[765][ENDTOKEN] = ActionEntry(REDUCE, 299);
   _actionMap[765][UNION] = ActionEntry(REDUCE, 299);
   _actionMap[765][ROWLIMIT] = ActionEntry(REDUCE, 299);
   _actionMap[765][ORDER] = ActionEntry(REDUCE, 299);
   _actionMap[765][GROUP] = ActionEntry(REDUCE, 299);
   _actionMap[765][SEMICOLON] = ActionEntry(REDUCE, 299);
   _actionMap[765][RETURNTOKEN] = ActionEntry(REDUCE, 299);
   _actionMap[765][WHERE] = ActionEntry(REDUCE, 299);
   _actionMap[765][RB] = ActionEntry(REDUCE, 299);
   _actionMap[765][BEGIN] = ActionEntry(REDUCE, 299);
   _actionMap[765][THEN] = ActionEntry(REDUCE, 299);
   _actionMap[765][AND] = ActionEntry(REDUCE, 299);
   _actionMap[765][OR] = ActionEntry(REDUCE, 299);
   _actionMap[766][WHEN] = ActionEntry(REDUCE, 109);
   _actionMap[766][ELSE] = ActionEntry(REDUCE, 109);
   _actionMap[766][LEFT] = ActionEntry(REDUCE, 109);
   _actionMap[766][RIGHT] = ActionEntry(REDUCE, 109);
   _actionMap[766][INNER] = ActionEntry(REDUCE, 109);
   _actionMap[766][JOIN] = ActionEntry(REDUCE, 109);
   _actionMap[766][ORDER] = ActionEntry(REDUCE, 109);
   _actionMap[766][GROUP] = ActionEntry(REDUCE, 109);
   _actionMap[766][RETURNTOKEN] = ActionEntry(REDUCE, 109);
   _actionMap[766][WHERE] = ActionEntry(REDUCE, 109);
   _actionMap[766][FROM] = ActionEntry(REDUCE, 109);
   _actionMap[766][AS] = ActionEntry(REDUCE, 109);
   _actionMap[766][END_TOKEN] = ActionEntry(REDUCE, 109);
   _actionMap[766][BEGIN] = ActionEntry(REDUCE, 109);
   _actionMap[766][THEN] = ActionEntry(REDUCE, 109);
   _actionMap[766][AND] = ActionEntry(REDUCE, 109);
   _actionMap[766][OR] = ActionEntry(REDUCE, 109);
   _actionMap[766][INTOK] = ActionEntry(REDUCE, 109);
   _actionMap[766][NOT] = ActionEntry(REDUCE, 109);
   _actionMap[766][MT] = ActionEntry(REDUCE, 109);
   _actionMap[766][LT] = ActionEntry(REDUCE, 109);
   _actionMap[766][NEGATION] = ActionEntry(REDUCE, 109);
   _actionMap[766][EQU] = ActionEntry(REDUCE, 109);
   _actionMap[766][BETWEEN] = ActionEntry(REDUCE, 109);
   _actionMap[766][IS] = ActionEntry(REDUCE, 109);
   _actionMap[766][LIKE] = ActionEntry(REDUCE, 109);
   _actionMap[766][RB] = ActionEntry(REDUCE, 109);
}
void Cego::loadParser53()
{
   _actionMap[766][ENDTOKEN] = ActionEntry(REDUCE, 109);
   _actionMap[766][UNION] = ActionEntry(REDUCE, 109);
   _actionMap[766][ROWLIMIT] = ActionEntry(REDUCE, 109);
   _actionMap[766][KSEP] = ActionEntry(REDUCE, 109);
   _actionMap[766][ASC] = ActionEntry(REDUCE, 109);
   _actionMap[766][DESC] = ActionEntry(REDUCE, 109);
   _actionMap[766][PLUS] = ActionEntry(REDUCE, 109);
   _actionMap[766][MINUS] = ActionEntry(REDUCE, 109);
   _actionMap[766][DIVISION] = ActionEntry(REDUCE, 109);
   _actionMap[766][STAR] = ActionEntry(REDUCE, 109);
   _actionMap[766][CONCAT] = ActionEntry(REDUCE, 109);
   _actionMap[766][SEMICOLON] = ActionEntry(REDUCE, 109);
   _actionMap[767][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[767][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[767][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[767][WHEN] = ActionEntry(REDUCE, 112);
   _actionMap[767][ELSE] = ActionEntry(REDUCE, 112);
   _actionMap[768][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[768][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[768][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[768][KSEP] = ActionEntry(REDUCE, 375);
   _actionMap[768][RB] = ActionEntry(REDUCE, 375);
   _actionMap[769][RB] = ActionEntry(SHIFT, 833);
   _actionMap[769][KSEP] = ActionEntry(SHIFT, 832);
   _actionMap[770][KSEP] = ActionEntry(REDUCE, 115);
   _actionMap[770][RB] = ActionEntry(REDUCE, 115);
   _actionMap[771][RB] = ActionEntry(SHIFT, 834);
   _actionMap[771][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[771][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[771][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[772][SEMICOLON] = ActionEntry(REDUCE, 207);
   _actionMap[772][RB] = ActionEntry(REDUCE, 207);
   _actionMap[772][ENDTOKEN] = ActionEntry(REDUCE, 207);
   _actionMap[772][UNION] = ActionEntry(REDUCE, 207);
   _actionMap[772][ROWLIMIT] = ActionEntry(REDUCE, 207);
   _actionMap[772][ORDER] = ActionEntry(SHIFT, 837);
   _jumpMap[772][NoOrdering] = 836;
   _jumpMap[772][OrderingClause] = 835;
   _actionMap[773][ORDER] = ActionEntry(REDUCE, 198);
   _actionMap[773][ROWLIMIT] = ActionEntry(REDUCE, 198);
   _actionMap[773][UNION] = ActionEntry(REDUCE, 198);
   _actionMap[773][ENDTOKEN] = ActionEntry(REDUCE, 198);
   _actionMap[773][RB] = ActionEntry(REDUCE, 198);
   _actionMap[773][SEMICOLON] = ActionEntry(REDUCE, 198);
   _actionMap[774][BY] = ActionEntry(SHIFT, 838);
   _actionMap[775][LEFT] = ActionEntry(REDUCE, 193);
   _actionMap[775][RIGHT] = ActionEntry(REDUCE, 193);
   _actionMap[775][INNER] = ActionEntry(REDUCE, 193);
   _actionMap[775][JOIN] = ActionEntry(REDUCE, 193);
   _actionMap[775][RB] = ActionEntry(REDUCE, 193);
}
void Cego::loadParser54()
{
   _actionMap[775][ENDTOKEN] = ActionEntry(REDUCE, 193);
   _actionMap[775][UNION] = ActionEntry(REDUCE, 193);
   _actionMap[775][ROWLIMIT] = ActionEntry(REDUCE, 193);
   _actionMap[775][ORDER] = ActionEntry(REDUCE, 193);
   _actionMap[775][GROUP] = ActionEntry(REDUCE, 193);
   _actionMap[775][SEMICOLON] = ActionEntry(REDUCE, 193);
   _actionMap[775][RETURNTOKEN] = ActionEntry(REDUCE, 193);
   _actionMap[775][WHERE] = ActionEntry(REDUCE, 193);
   _actionMap[775][ON] = ActionEntry(REDUCE, 193);
   _actionMap[776][ON] = ActionEntry(SHIFT, 839);
   _actionMap[776][LEFT] = ActionEntry(REDUCE, 181);
   _actionMap[776][RIGHT] = ActionEntry(REDUCE, 181);
   _actionMap[776][INNER] = ActionEntry(REDUCE, 181);
   _actionMap[776][JOIN] = ActionEntry(REDUCE, 181);
   _actionMap[776][RB] = ActionEntry(REDUCE, 181);
   _actionMap[776][ENDTOKEN] = ActionEntry(REDUCE, 181);
   _actionMap[776][UNION] = ActionEntry(REDUCE, 181);
   _actionMap[776][ROWLIMIT] = ActionEntry(REDUCE, 181);
   _actionMap[776][ORDER] = ActionEntry(REDUCE, 181);
   _actionMap[776][GROUP] = ActionEntry(REDUCE, 181);
   _actionMap[776][SEMICOLON] = ActionEntry(REDUCE, 181);
   _actionMap[776][RETURNTOKEN] = ActionEntry(REDUCE, 181);
   _actionMap[776][WHERE] = ActionEntry(REDUCE, 181);
   _actionMap[777][IDENTIFIER] = ActionEntry(REDUCE, 187);
   _actionMap[777][QUALIFIEDOBJ] = ActionEntry(REDUCE, 187);
   _actionMap[777][QUALIFIEDTS] = ActionEntry(REDUCE, 187);
   _actionMap[778][JOIN] = ActionEntry(SHIFT, 840);
   _actionMap[779][JOIN] = ActionEntry(SHIFT, 841);
   _actionMap[780][RB] = ActionEntry(REDUCE, 189);
   _actionMap[780][ENDTOKEN] = ActionEntry(REDUCE, 189);
   _actionMap[780][UNION] = ActionEntry(REDUCE, 189);
   _actionMap[780][ROWLIMIT] = ActionEntry(REDUCE, 189);
   _actionMap[780][ORDER] = ActionEntry(REDUCE, 189);
   _actionMap[780][GROUP] = ActionEntry(REDUCE, 189);
   _actionMap[780][SEMICOLON] = ActionEntry(REDUCE, 189);
   _actionMap[780][RETURNTOKEN] = ActionEntry(REDUCE, 189);
   _actionMap[780][WHERE] = ActionEntry(REDUCE, 189);
   _actionMap[781][KSEP] = ActionEntry(SHIFT, 691);
   _actionMap[781][RB] = ActionEntry(REDUCE, 190);
   _actionMap[781][ENDTOKEN] = ActionEntry(REDUCE, 190);
   _actionMap[781][UNION] = ActionEntry(REDUCE, 190);
   _actionMap[781][ROWLIMIT] = ActionEntry(REDUCE, 190);
   _actionMap[781][ORDER] = ActionEntry(REDUCE, 190);
   _actionMap[781][GROUP] = ActionEntry(REDUCE, 190);
   _actionMap[781][SEMICOLON] = ActionEntry(REDUCE, 190);
   _actionMap[781][RETURNTOKEN] = ActionEntry(REDUCE, 190);
   _actionMap[781][WHERE] = ActionEntry(REDUCE, 190);
   _actionMap[782][SEMICOLON] = ActionEntry(REDUCE, 154);
   _actionMap[783][SEMICOLON] = ActionEntry(REDUCE, 160);
   _actionMap[784][ON] = ActionEntry(SHIFT, 844);
}
void Cego::loadParser55()
{
   _actionMap[784][VARREF] = ActionEntry(SHIFT, 845);
   _jumpMap[784][ReturnVar] = 843;
   _jumpMap[784][ReturnVarList] = 842;
   _actionMap[785][KSEP] = ActionEntry(REDUCE, 155);
   _actionMap[785][WHERE] = ActionEntry(REDUCE, 155);
   _actionMap[785][RETURNTOKEN] = ActionEntry(REDUCE, 155);
   _actionMap[785][SEMICOLON] = ActionEntry(REDUCE, 155);
   _actionMap[785][GROUP] = ActionEntry(REDUCE, 155);
   _actionMap[785][ORDER] = ActionEntry(REDUCE, 155);
   _actionMap[785][ROWLIMIT] = ActionEntry(REDUCE, 155);
   _actionMap[785][UNION] = ActionEntry(REDUCE, 155);
   _actionMap[785][ENDTOKEN] = ActionEntry(REDUCE, 155);
   _actionMap[785][RB] = ActionEntry(REDUCE, 155);
   _actionMap[786][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[786][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[786][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[786][KSEP] = ActionEntry(REDUCE, 157);
   _actionMap[786][WHERE] = ActionEntry(REDUCE, 157);
   _actionMap[786][RETURNTOKEN] = ActionEntry(REDUCE, 157);
   _actionMap[786][SEMICOLON] = ActionEntry(REDUCE, 157);
   _actionMap[786][GROUP] = ActionEntry(REDUCE, 157);
   _actionMap[786][ORDER] = ActionEntry(REDUCE, 157);
   _actionMap[786][ROWLIMIT] = ActionEntry(REDUCE, 157);
   _actionMap[786][UNION] = ActionEntry(REDUCE, 157);
   _actionMap[786][ENDTOKEN] = ActionEntry(REDUCE, 157);
   _actionMap[786][RB] = ActionEntry(REDUCE, 157);
   _actionMap[787][RB] = ActionEntry(SHIFT, 788);
   _actionMap[788][SEMICOLON] = ActionEntry(REDUCE, 63);
   _actionMap[546][DROP] = ActionEntry(SHIFT, 387);
   _actionMap[546][ADD] = ActionEntry(SHIFT, 701);
   _actionMap[546][MODIFY] = ActionEntry(SHIFT, 388);
   _actionMap[546][RENAME] = ActionEntry(SHIFT, 389);
   _jumpMap[546][AlterOption] = 385;
   _jumpMap[546][AlterList] = 700;
   _actionMap[547][IDENTIFIER] = ActionEntry(SHIFT, 702);
   _actionMap[548][IDENTIFIER] = ActionEntry(SHIFT, 586);
   _jumpMap[548][ColumnDesc] = 703;
   _actionMap[549][KEY] = ActionEntry(SHIFT, 704);
   _actionMap[550][IDENTIFIER] = ActionEntry(SHIFT, 705);
   _actionMap[551][IDENTIFIER] = ActionEntry(SHIFT, 707);
   _jumpMap[551][ColumnDesc] = 706;
   _actionMap[552][IDENTIFIER] = ActionEntry(SHIFT, 708);
   _actionMap[553][FOR] = ActionEntry(SHIFT, 709);
   _actionMap[554][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[554][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[554][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[554][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[554][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[554][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[554][RTRIM] = ActionEntry(SHIFT, 165);
}
void Cego::loadParser56()
{
   _actionMap[554][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[554][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[554][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[554][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[554][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[554][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[554][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[554][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[554][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[554][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[554][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[554][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[554][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[554][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[554][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[554][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[554][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[554][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[554][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[554][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[554][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[554][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[554][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[554][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[554][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[554][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[554][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[554][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[554][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[554][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[554][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[554][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[554][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[554][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[554][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[554][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[554][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[554][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[554][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[554][LB] = ActionEntry(SHIFT, 177);
   _actionMap[554][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[554][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[554][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[554][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[554][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[554][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[554][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[554][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[554][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[554][VARREF] = ActionEntry(SHIFT, 182);
}
void Cego::loadParser57()
{
   _actionMap[554][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[554][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[554][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[554][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[554][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[554][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[554][ObjSpec] = 122;
   _jumpMap[554][Constant] = 121;
   _jumpMap[554][SignedFloat] = 120;
   _jumpMap[554][SignedInt] = 119;
   _jumpMap[554][Attribute] = 118;
   _jumpMap[554][Function] = 117;
   _jumpMap[554][Factor] = 116;
   _jumpMap[554][Term] = 115;
   _jumpMap[554][Expr] = 710;
   _jumpMap[554][CasePrepare] = 113;
   _jumpMap[554][CaseClause] = 112;
   _actionMap[555][SEMICOLON] = ActionEntry(REDUCE, 100);
   _actionMap[556][ELSE] = ActionEntry(REDUCE, 251);
   _actionMap[556][ELSIF] = ActionEntry(REDUCE, 251);
   _actionMap[556][END_TOKEN] = ActionEntry(REDUCE, 251);
   _actionMap[556][EXCEPTION] = ActionEntry(SHIFT, 712);
   _jumpMap[556][ProcExceptionStmt] = 711;
   _actionMap[557][SEMICOLON] = ActionEntry(SHIFT, 713);
   _actionMap[558][END_TOKEN] = ActionEntry(SHIFT, 714);
   _actionMap[559][ELSE] = ActionEntry(SHIFT, 717);
   _actionMap[559][END_TOKEN] = ActionEntry(REDUCE, 290);
   _jumpMap[559][ProcElsePart] = 716;
   _jumpMap[559][ProcElseOpt] = 715;
   _actionMap[560][ELSIF] = ActionEntry(SHIFT, 561);
   _actionMap[560][END_TOKEN] = ActionEntry(REDUCE, 287);
   _actionMap[560][ELSE] = ActionEntry(REDUCE, 287);
   _jumpMap[560][ProcElsIfOpt] = 560;
   _jumpMap[560][ProcElsIfList] = 719;
   _actionMap[561][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[561][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[561][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[561][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[561][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[561][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[561][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[561][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[561][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[561][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[561][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[561][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[561][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[561][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[561][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[561][UPPER] = ActionEntry(SHIFT, 176);
}
void Cego::loadParser58()
{
   _actionMap[561][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[561][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[561][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[561][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[561][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[561][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[561][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[561][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[561][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[561][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[561][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[561][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[561][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[561][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[561][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[561][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[561][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[561][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[561][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[561][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[561][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[561][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[561][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[561][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[561][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[561][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[561][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[561][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[561][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[561][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[561][LB] = ActionEntry(SHIFT, 177);
   _actionMap[561][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[561][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[561][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[561][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[561][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[561][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[561][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[561][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[561][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[561][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[561][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[561][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[561][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[561][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[561][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[561][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[561][EXISTS] = ActionEntry(SHIFT, 275);
   _actionMap[561][NOT] = ActionEntry(SHIFT, 276);
   _jumpMap[561][ObjSpec] = 122;
}
void Cego::loadParser59()
{
   _jumpMap[561][Constant] = 121;
   _jumpMap[561][SignedFloat] = 120;
   _jumpMap[561][SignedInt] = 119;
   _jumpMap[561][Attribute] = 118;
   _jumpMap[561][Function] = 117;
   _jumpMap[561][Factor] = 116;
   _jumpMap[561][Term] = 115;
   _jumpMap[561][Expr] = 274;
   _jumpMap[561][Predicate] = 273;
   _jumpMap[561][Condition] = 721;
   _jumpMap[561][ProcElsIfCondition] = 720;
   _jumpMap[561][CasePrepare] = 113;
   _jumpMap[561][CaseClause] = 112;
   _actionMap[562][EXCEPTION] = ActionEntry(REDUCE, 253);
   _actionMap[562][END_TOKEN] = ActionEntry(REDUCE, 253);
   _actionMap[562][ELSE] = ActionEntry(REDUCE, 253);
   _actionMap[562][ELSIF] = ActionEntry(REDUCE, 253);
   _actionMap[562][VAR] = ActionEntry(REDUCE, 253);
   _actionMap[562][CURSOR] = ActionEntry(REDUCE, 253);
   _actionMap[562][CLOSE] = ActionEntry(REDUCE, 253);
   _actionMap[562][VARREF] = ActionEntry(REDUCE, 253);
   _actionMap[562][NOOP] = ActionEntry(REDUCE, 253);
   _actionMap[562][THROW] = ActionEntry(REDUCE, 253);
   _actionMap[562][RETURNTOKEN] = ActionEntry(REDUCE, 253);
   _actionMap[562][WHILE] = ActionEntry(REDUCE, 253);
   _actionMap[562][IF] = ActionEntry(REDUCE, 253);
   _actionMap[562][BEGIN] = ActionEntry(REDUCE, 253);
   _actionMap[562][UNLOCK] = ActionEntry(REDUCE, 253);
   _actionMap[562][LOCK] = ActionEntry(REDUCE, 253);
   _actionMap[562][ROLLBACK] = ActionEntry(REDUCE, 253);
   _actionMap[562][COMMIT] = ActionEntry(REDUCE, 253);
   _actionMap[562][START_TOKEN] = ActionEntry(REDUCE, 253);
   _actionMap[562][UPDATE] = ActionEntry(REDUCE, 253);
   _actionMap[562][DELETETOK] = ActionEntry(REDUCE, 253);
   _actionMap[562][INSERT] = ActionEntry(REDUCE, 253);
   _actionMap[562][FETCH] = ActionEntry(REDUCE, 253);
   _actionMap[562][LB] = ActionEntry(REDUCE, 253);
   _actionMap[562][COUNT] = ActionEntry(REDUCE, 253);
   _actionMap[562][SUM] = ActionEntry(REDUCE, 253);
   _actionMap[562][AVG] = ActionEntry(REDUCE, 253);
   _actionMap[562][MIN] = ActionEntry(REDUCE, 253);
   _actionMap[562][MAX] = ActionEntry(REDUCE, 253);
   _actionMap[562][CASE] = ActionEntry(REDUCE, 253);
   _actionMap[562][INT2ASC] = ActionEntry(REDUCE, 253);
   _actionMap[562][ASC2INT] = ActionEntry(REDUCE, 253);
   _actionMap[562][TRIM] = ActionEntry(REDUCE, 253);
   _actionMap[562][RTRIM] = ActionEntry(REDUCE, 253);
   _actionMap[562][LTRIM] = ActionEntry(REDUCE, 253);
   _actionMap[562][ROUND] = ActionEntry(REDUCE, 253);
   _actionMap[562][SCANDATE] = ActionEntry(REDUCE, 253);
}
void Cego::loadParser60()
{
   _actionMap[562][DATE2STR] = ActionEntry(REDUCE, 253);
   _actionMap[562][DATE2LONG] = ActionEntry(REDUCE, 253);
   _actionMap[562][LONG2DATE] = ActionEntry(REDUCE, 253);
   _actionMap[562][NEWDATE] = ActionEntry(REDUCE, 253);
   _actionMap[562][LOWER] = ActionEntry(REDUCE, 253);
   _actionMap[562][UPPER] = ActionEntry(REDUCE, 253);
   _actionMap[562][LEFT] = ActionEntry(REDUCE, 253);
   _actionMap[562][RIGHT] = ActionEntry(REDUCE, 253);
   _actionMap[562][GETPOS] = ActionEntry(REDUCE, 253);
   _actionMap[562][SUBSTR] = ActionEntry(REDUCE, 253);
   _actionMap[562][REPLACE] = ActionEntry(REDUCE, 253);
   _actionMap[562][LENGTH] = ActionEntry(REDUCE, 253);
   _actionMap[562][TRUNC] = ActionEntry(REDUCE, 253);
   _actionMap[562][STR2INT] = ActionEntry(REDUCE, 253);
   _actionMap[562][STR2LONG] = ActionEntry(REDUCE, 253);
   _actionMap[562][RANDSTR] = ActionEntry(REDUCE, 253);
   _actionMap[562][RANDINT] = ActionEntry(REDUCE, 253);
   _actionMap[562][MOD] = ActionEntry(REDUCE, 253);
   _actionMap[562][DIV] = ActionEntry(REDUCE, 253);
   _actionMap[562][LMOD] = ActionEntry(REDUCE, 253);
   _actionMap[562][LDIV] = ActionEntry(REDUCE, 253);
   _actionMap[562][POWER] = ActionEntry(REDUCE, 253);
   _actionMap[562][BITAND] = ActionEntry(REDUCE, 253);
   _actionMap[562][BITOR] = ActionEntry(REDUCE, 253);
   _actionMap[562][BITXOR] = ActionEntry(REDUCE, 253);
   _actionMap[562][BLOBSIZE] = ActionEntry(REDUCE, 253);
   _actionMap[562][BLOBREF] = ActionEntry(REDUCE, 253);
   _actionMap[562][CLOBSIZE] = ActionEntry(REDUCE, 253);
   _actionMap[562][CLOBREF] = ActionEntry(REDUCE, 253);
   _actionMap[562][CLOB2STR] = ActionEntry(REDUCE, 253);
   _actionMap[562][NEXTCOUNT] = ActionEntry(REDUCE, 253);
   _actionMap[562][SETCOUNT] = ActionEntry(REDUCE, 253);
   _actionMap[562][GETCOUNT] = ActionEntry(REDUCE, 253);
   _actionMap[562][IDENTIFIER] = ActionEntry(REDUCE, 253);
   _actionMap[562][QUALIFIEDOBJ] = ActionEntry(REDUCE, 253);
   _actionMap[562][QUALIFIEDTS] = ActionEntry(REDUCE, 253);
   _actionMap[562][QUALIFIEDPRE] = ActionEntry(REDUCE, 253);
   _actionMap[562][STRINGVAL] = ActionEntry(REDUCE, 253);
   _actionMap[562][SYSDATE] = ActionEntry(REDUCE, 253);
   _actionMap[562][NULLTOKEN] = ActionEntry(REDUCE, 253);
   _actionMap[562][TRUEVAL] = ActionEntry(REDUCE, 253);
   _actionMap[562][FALSEVAL] = ActionEntry(REDUCE, 253);
   _actionMap[562][BLOB] = ActionEntry(REDUCE, 253);
   _actionMap[562][CLOB] = ActionEntry(REDUCE, 253);
   _actionMap[562][FLOATVAL] = ActionEntry(REDUCE, 253);
   _actionMap[562][MINUS] = ActionEntry(REDUCE, 253);
   _actionMap[562][INTVAL] = ActionEntry(REDUCE, 253);
   _actionMap[563][SEMICOLON] = ActionEntry(REDUCE, 256);
   _actionMap[564][AS] = ActionEntry(SHIFT, 722);
   _actionMap[565][THEN] = ActionEntry(SHIFT, 723);
}
void Cego::loadParser61()
{
   _actionMap[566][AND] = ActionEntry(SHIFT, 440);
   _actionMap[566][OR] = ActionEntry(SHIFT, 441);
   _actionMap[566][THEN] = ActionEntry(REDUCE, 292);
   _actionMap[567][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[567][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[567][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[567][SEMICOLON] = ActionEntry(REDUCE, 273);
   _actionMap[568][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[568][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[568][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[568][SEMICOLON] = ActionEntry(REDUCE, 263);
   _actionMap[569][INT] = ActionEntry(SHIFT, 733);
   _actionMap[569][LONG] = ActionEntry(SHIFT, 734);
   _actionMap[569][STRING] = ActionEntry(SHIFT, 736);
   _actionMap[569][DATETIME] = ActionEntry(SHIFT, 729);
   _actionMap[569][BOOL] = ActionEntry(SHIFT, 727);
   _actionMap[569][BIGINT] = ActionEntry(SHIFT, 725);
   _actionMap[569][FLOAT] = ActionEntry(SHIFT, 732);
   _actionMap[569][DOUBLE] = ActionEntry(SHIFT, 731);
   _actionMap[569][SMALLINT] = ActionEntry(SHIFT, 735);
   _actionMap[569][TINYINT] = ActionEntry(SHIFT, 737);
   _actionMap[569][DECIMAL] = ActionEntry(SHIFT, 730);
   _actionMap[569][BLOB] = ActionEntry(SHIFT, 726);
   _actionMap[569][CLOB] = ActionEntry(SHIFT, 728);
   _jumpMap[569][DataTypeProd] = 724;
   _actionMap[570][BEGIN] = ActionEntry(SHIFT, 738);
   _actionMap[571][AND] = ActionEntry(SHIFT, 440);
   _actionMap[571][OR] = ActionEntry(SHIFT, 441);
   _actionMap[571][BEGIN] = ActionEntry(REDUCE, 295);
   _actionMap[572][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[572][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[572][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[572][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[572][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[572][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[572][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[572][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[572][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[572][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[572][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[572][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[572][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[572][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[572][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[572][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[572][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[572][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[572][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[572][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[572][REPLACE] = ActionEntry(SHIFT, 162);
}
void Cego::loadParser62()
{
   _actionMap[572][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[572][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[572][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[572][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[572][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[572][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[572][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[572][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[572][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[572][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[572][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[572][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[572][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[572][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[572][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[572][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[572][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[572][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[572][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[572][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[572][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[572][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[572][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[572][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[572][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[572][LB] = ActionEntry(SHIFT, 177);
   _actionMap[572][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[572][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[572][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[572][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[572][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[572][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[572][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[572][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[572][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[572][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[572][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[572][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[572][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[572][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[572][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[572][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[572][ObjSpec] = 122;
   _jumpMap[572][Constant] = 121;
   _jumpMap[572][SignedFloat] = 120;
   _jumpMap[572][SignedInt] = 119;
   _jumpMap[572][Attribute] = 118;
   _jumpMap[572][Function] = 117;
   _jumpMap[572][Factor] = 116;
   _jumpMap[572][Term] = 115;
}
void Cego::loadParser63()
{
   _jumpMap[572][Expr] = 739;
   _jumpMap[572][CasePrepare] = 113;
   _jumpMap[572][CaseClause] = 112;
   _actionMap[573][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[573][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[573][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[573][ObjSpec] = 740;
   _actionMap[574][SEMICOLON] = ActionEntry(REDUCE, 242);
   _actionMap[575][LB] = ActionEntry(SHIFT, 741);
   _actionMap[576][LB] = ActionEntry(SHIFT, 742);
   _actionMap[577][RB] = ActionEntry(SHIFT, 580);
   _actionMap[578][KSEP] = ActionEntry(SHIFT, 743);
   _actionMap[578][RB] = ActionEntry(REDUCE, 245);
   _actionMap[579][KSEP] = ActionEntry(REDUCE, 248);
   _actionMap[579][RB] = ActionEntry(REDUCE, 248);
   _actionMap[580][RETURNTOKEN] = ActionEntry(SHIFT, 745);
   _actionMap[580][BEGIN] = ActionEntry(REDUCE, 244);
   _jumpMap[580][ReturnOpt] = 744;
   _actionMap[581][INTOK] = ActionEntry(SHIFT, 746);
   _actionMap[581][OUTTOK] = ActionEntry(SHIFT, 747);
   _actionMap[582][RB] = ActionEntry(SHIFT, 749);
   _actionMap[582][KSEP] = ActionEntry(SHIFT, 748);
   _actionMap[583][KSEP] = ActionEntry(REDUCE, 117);
   _actionMap[583][RB] = ActionEntry(REDUCE, 117);
   _actionMap[584][KSEP] = ActionEntry(REDUCE, 119);
   _actionMap[584][RB] = ActionEntry(REDUCE, 119);
   _actionMap[585][IDENTIFIER] = ActionEntry(SHIFT, 586);
   _jumpMap[585][ColumnDesc] = 750;
   _actionMap[586][INT] = ActionEntry(SHIFT, 733);
   _actionMap[586][LONG] = ActionEntry(SHIFT, 734);
   _actionMap[586][STRING] = ActionEntry(SHIFT, 736);
   _actionMap[586][DATETIME] = ActionEntry(SHIFT, 729);
   _actionMap[586][BOOL] = ActionEntry(SHIFT, 727);
   _actionMap[586][BIGINT] = ActionEntry(SHIFT, 725);
   _actionMap[586][FLOAT] = ActionEntry(SHIFT, 732);
   _actionMap[586][DOUBLE] = ActionEntry(SHIFT, 731);
   _actionMap[586][SMALLINT] = ActionEntry(SHIFT, 735);
   _actionMap[586][TINYINT] = ActionEntry(SHIFT, 737);
   _actionMap[586][DECIMAL] = ActionEntry(SHIFT, 730);
   _actionMap[586][BLOB] = ActionEntry(SHIFT, 726);
   _actionMap[586][CLOB] = ActionEntry(SHIFT, 728);
   _jumpMap[586][DataTypeProd] = 751;
   _actionMap[587][ON] = ActionEntry(SHIFT, 752);
   _actionMap[587][OR] = ActionEntry(SHIFT, 753);
   _actionMap[588][OR] = ActionEntry(REDUCE, 105);
   _actionMap[588][ON] = ActionEntry(REDUCE, 105);
   _actionMap[589][OR] = ActionEntry(REDUCE, 108);
   _actionMap[589][ON] = ActionEntry(REDUCE, 108);
   _actionMap[590][OR] = ActionEntry(REDUCE, 106);
   _actionMap[590][ON] = ActionEntry(REDUCE, 106);
}
void Cego::loadParser64()
{
   _actionMap[591][OR] = ActionEntry(REDUCE, 107);
   _actionMap[591][ON] = ActionEntry(REDUCE, 107);
   _actionMap[592][SEMICOLON] = ActionEntry(REDUCE, 58);
   _actionMap[593][AND] = ActionEntry(SHIFT, 440);
   _actionMap[593][OR] = ActionEntry(SHIFT, 441);
   _actionMap[593][RETURNTOKEN] = ActionEntry(REDUCE, 222);
   _actionMap[593][GROUP] = ActionEntry(REDUCE, 222);
   _actionMap[593][ORDER] = ActionEntry(REDUCE, 222);
   _actionMap[593][ROWLIMIT] = ActionEntry(REDUCE, 222);
   _actionMap[593][UNION] = ActionEntry(REDUCE, 222);
   _actionMap[593][ENDTOKEN] = ActionEntry(REDUCE, 222);
   _actionMap[593][RB] = ActionEntry(REDUCE, 222);
   _actionMap[593][SEMICOLON] = ActionEntry(REDUCE, 222);
   _actionMap[594][KSEP] = ActionEntry(SHIFT, 754);
   _actionMap[594][SEMICOLON] = ActionEntry(REDUCE, 142);
   _actionMap[595][SEMICOLON] = ActionEntry(REDUCE, 148);
   _actionMap[595][KSEP] = ActionEntry(REDUCE, 148);
   _actionMap[596][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[596][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[596][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[596][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[596][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[596][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[596][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[596][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[596][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[596][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[596][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[596][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[596][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[596][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[596][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[596][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[596][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[596][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[596][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[596][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[596][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[596][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[596][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[596][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[596][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[596][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[596][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[596][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[596][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[596][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[596][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[596][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[596][BITAND] = ActionEntry(SHIFT, 126);
}
void Cego::loadParser65()
{
   _actionMap[596][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[596][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[596][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[596][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[596][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[596][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[596][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[596][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[596][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[596][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[596][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[596][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[596][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[596][LB] = ActionEntry(SHIFT, 177);
   _actionMap[596][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[596][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[596][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[596][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[596][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[596][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[596][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[596][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[596][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[596][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[596][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[596][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[596][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[596][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[596][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[596][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[596][ObjSpec] = 122;
   _jumpMap[596][Constant] = 121;
   _jumpMap[596][SignedFloat] = 120;
   _jumpMap[596][SignedInt] = 119;
   _jumpMap[596][Attribute] = 118;
   _jumpMap[596][Function] = 117;
   _jumpMap[596][Factor] = 116;
   _jumpMap[596][Term] = 115;
   _jumpMap[596][Expr] = 756;
   _jumpMap[596][InsertValueList] = 755;
   _jumpMap[596][CasePrepare] = 113;
   _jumpMap[596][CaseClause] = 112;
   _actionMap[597][RB] = ActionEntry(SHIFT, 758);
   _actionMap[597][KSEP] = ActionEntry(SHIFT, 757);
   _actionMap[598][KSEP] = ActionEntry(REDUCE, 151);
   _actionMap[598][RB] = ActionEntry(REDUCE, 151);
   _actionMap[599][LEFT] = ActionEntry(REDUCE, 296);
   _actionMap[599][RIGHT] = ActionEntry(REDUCE, 296);
   _actionMap[599][INNER] = ActionEntry(REDUCE, 296);
   _actionMap[599][JOIN] = ActionEntry(REDUCE, 296);
}
void Cego::loadParser66()
{
   _actionMap[599][ENDTOKEN] = ActionEntry(REDUCE, 296);
   _actionMap[599][UNION] = ActionEntry(REDUCE, 296);
   _actionMap[599][ROWLIMIT] = ActionEntry(REDUCE, 296);
   _actionMap[599][ORDER] = ActionEntry(REDUCE, 296);
   _actionMap[599][GROUP] = ActionEntry(REDUCE, 296);
   _actionMap[599][SEMICOLON] = ActionEntry(REDUCE, 296);
   _actionMap[599][RETURNTOKEN] = ActionEntry(REDUCE, 296);
   _actionMap[599][WHERE] = ActionEntry(REDUCE, 296);
   _actionMap[599][RB] = ActionEntry(REDUCE, 296);
   _actionMap[599][BEGIN] = ActionEntry(REDUCE, 296);
   _actionMap[599][THEN] = ActionEntry(REDUCE, 296);
   _actionMap[599][OR] = ActionEntry(REDUCE, 296);
   _actionMap[599][AND] = ActionEntry(REDUCE, 296);
   _actionMap[600][LEFT] = ActionEntry(REDUCE, 297);
   _actionMap[600][RIGHT] = ActionEntry(REDUCE, 297);
   _actionMap[600][INNER] = ActionEntry(REDUCE, 297);
   _actionMap[600][JOIN] = ActionEntry(REDUCE, 297);
   _actionMap[600][ENDTOKEN] = ActionEntry(REDUCE, 297);
   _actionMap[600][UNION] = ActionEntry(REDUCE, 297);
   _actionMap[600][ROWLIMIT] = ActionEntry(REDUCE, 297);
   _actionMap[600][ORDER] = ActionEntry(REDUCE, 297);
   _actionMap[600][GROUP] = ActionEntry(REDUCE, 297);
   _actionMap[600][SEMICOLON] = ActionEntry(REDUCE, 297);
   _actionMap[600][RETURNTOKEN] = ActionEntry(REDUCE, 297);
   _actionMap[600][WHERE] = ActionEntry(REDUCE, 297);
   _actionMap[600][RB] = ActionEntry(REDUCE, 297);
   _actionMap[600][BEGIN] = ActionEntry(REDUCE, 297);
   _actionMap[600][THEN] = ActionEntry(REDUCE, 297);
   _actionMap[600][OR] = ActionEntry(REDUCE, 297);
   _actionMap[600][AND] = ActionEntry(REDUCE, 297);
   _actionMap[601][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[601][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[601][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[601][LEFT] = ActionEntry(REDUCE, 304);
   _actionMap[601][RIGHT] = ActionEntry(REDUCE, 304);
   _actionMap[601][INNER] = ActionEntry(REDUCE, 304);
   _actionMap[601][JOIN] = ActionEntry(REDUCE, 304);
   _actionMap[601][ENDTOKEN] = ActionEntry(REDUCE, 304);
   _actionMap[601][UNION] = ActionEntry(REDUCE, 304);
   _actionMap[601][ROWLIMIT] = ActionEntry(REDUCE, 304);
   _actionMap[601][ORDER] = ActionEntry(REDUCE, 304);
   _actionMap[601][GROUP] = ActionEntry(REDUCE, 304);
   _actionMap[601][SEMICOLON] = ActionEntry(REDUCE, 304);
   _actionMap[601][RETURNTOKEN] = ActionEntry(REDUCE, 304);
   _actionMap[601][WHERE] = ActionEntry(REDUCE, 304);
   _actionMap[601][RB] = ActionEntry(REDUCE, 304);
   _actionMap[601][BEGIN] = ActionEntry(REDUCE, 304);
   _actionMap[601][THEN] = ActionEntry(REDUCE, 304);
   _actionMap[601][AND] = ActionEntry(REDUCE, 304);
   _actionMap[601][OR] = ActionEntry(REDUCE, 304);
}
void Cego::loadParser67()
{
   _actionMap[602][AND] = ActionEntry(SHIFT, 759);
   _actionMap[602][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[602][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[602][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[603][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[603][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[603][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[603][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[603][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[603][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[603][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[603][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[603][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[603][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[603][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[603][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[603][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[603][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[603][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[603][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[603][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[603][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[603][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[603][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[603][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[603][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[603][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[603][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[603][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[603][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[603][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[603][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[603][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[603][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[603][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[603][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[603][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[603][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[603][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[603][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[603][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[603][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[603][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[603][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[603][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[603][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[603][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[603][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[603][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[603][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
}
void Cego::loadParser68()
{
   _actionMap[603][LB] = ActionEntry(SHIFT, 177);
   _actionMap[603][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[603][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[603][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[603][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[603][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[603][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[603][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[603][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[603][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[603][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[603][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[603][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[603][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[603][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[603][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[603][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[603][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[603][ObjSpec] = 122;
   _jumpMap[603][Constant] = 121;
   _jumpMap[603][SignedFloat] = 120;
   _jumpMap[603][SignedInt] = 119;
   _jumpMap[603][Attribute] = 118;
   _jumpMap[603][ExpressionList] = 761;
   _jumpMap[603][Function] = 117;
   _jumpMap[603][Factor] = 116;
   _jumpMap[603][Term] = 115;
   _jumpMap[603][Expr] = 463;
   _jumpMap[603][SelectStatement] = 760;
   _jumpMap[603][CasePrepare] = 113;
   _jumpMap[603][CaseClause] = 112;
   _actionMap[604][NULLTOKEN] = ActionEntry(SHIFT, 762);
   _actionMap[605][LEFT] = ActionEntry(REDUCE, 306);
   _actionMap[605][RIGHT] = ActionEntry(REDUCE, 306);
   _actionMap[605][INNER] = ActionEntry(REDUCE, 306);
   _actionMap[605][JOIN] = ActionEntry(REDUCE, 306);
   _actionMap[605][ENDTOKEN] = ActionEntry(REDUCE, 306);
   _actionMap[605][UNION] = ActionEntry(REDUCE, 306);
   _actionMap[605][ROWLIMIT] = ActionEntry(REDUCE, 306);
   _actionMap[605][ORDER] = ActionEntry(REDUCE, 306);
   _actionMap[605][GROUP] = ActionEntry(REDUCE, 306);
   _actionMap[605][SEMICOLON] = ActionEntry(REDUCE, 306);
   _actionMap[605][RETURNTOKEN] = ActionEntry(REDUCE, 306);
   _actionMap[605][WHERE] = ActionEntry(REDUCE, 306);
   _actionMap[605][RB] = ActionEntry(REDUCE, 306);
   _actionMap[605][BEGIN] = ActionEntry(REDUCE, 306);
   _actionMap[605][THEN] = ActionEntry(REDUCE, 306);
   _actionMap[605][AND] = ActionEntry(REDUCE, 306);
   _actionMap[605][OR] = ActionEntry(REDUCE, 306);
   _actionMap[606][LEFT] = ActionEntry(REDUCE, 308);
}
void Cego::loadParser69()
{
   _actionMap[606][RIGHT] = ActionEntry(REDUCE, 308);
   _actionMap[606][INNER] = ActionEntry(REDUCE, 308);
   _actionMap[606][JOIN] = ActionEntry(REDUCE, 308);
   _actionMap[606][ENDTOKEN] = ActionEntry(REDUCE, 308);
   _actionMap[606][UNION] = ActionEntry(REDUCE, 308);
   _actionMap[606][ROWLIMIT] = ActionEntry(REDUCE, 308);
   _actionMap[606][ORDER] = ActionEntry(REDUCE, 308);
   _actionMap[606][GROUP] = ActionEntry(REDUCE, 308);
   _actionMap[606][SEMICOLON] = ActionEntry(REDUCE, 308);
   _actionMap[606][RETURNTOKEN] = ActionEntry(REDUCE, 308);
   _actionMap[606][WHERE] = ActionEntry(REDUCE, 308);
   _actionMap[606][RB] = ActionEntry(REDUCE, 308);
   _actionMap[606][BEGIN] = ActionEntry(REDUCE, 308);
   _actionMap[606][THEN] = ActionEntry(REDUCE, 308);
   _actionMap[606][AND] = ActionEntry(REDUCE, 308);
   _actionMap[606][OR] = ActionEntry(REDUCE, 308);
   _actionMap[607][LB] = ActionEntry(SHIFT, 763);
   _actionMap[608][STRINGVAL] = ActionEntry(SHIFT, 764);
   _actionMap[609][VARREF] = ActionEntry(REDUCE, 396);
   _actionMap[609][FETCH] = ActionEntry(REDUCE, 396);
   _actionMap[609][LB] = ActionEntry(REDUCE, 396);
   _actionMap[609][COUNT] = ActionEntry(REDUCE, 396);
   _actionMap[609][SUM] = ActionEntry(REDUCE, 396);
   _actionMap[609][AVG] = ActionEntry(REDUCE, 396);
   _actionMap[609][MIN] = ActionEntry(REDUCE, 396);
   _actionMap[609][MAX] = ActionEntry(REDUCE, 396);
   _actionMap[609][CASE] = ActionEntry(REDUCE, 396);
   _actionMap[609][INT2ASC] = ActionEntry(REDUCE, 396);
   _actionMap[609][ASC2INT] = ActionEntry(REDUCE, 396);
   _actionMap[609][TRIM] = ActionEntry(REDUCE, 396);
   _actionMap[609][RTRIM] = ActionEntry(REDUCE, 396);
   _actionMap[609][LTRIM] = ActionEntry(REDUCE, 396);
   _actionMap[609][ROUND] = ActionEntry(REDUCE, 396);
   _actionMap[609][SCANDATE] = ActionEntry(REDUCE, 396);
   _actionMap[609][DATE2STR] = ActionEntry(REDUCE, 396);
   _actionMap[609][DATE2LONG] = ActionEntry(REDUCE, 396);
   _actionMap[609][LONG2DATE] = ActionEntry(REDUCE, 396);
   _actionMap[609][NEWDATE] = ActionEntry(REDUCE, 396);
   _actionMap[609][LOWER] = ActionEntry(REDUCE, 396);
   _actionMap[609][UPPER] = ActionEntry(REDUCE, 396);
   _actionMap[609][LEFT] = ActionEntry(REDUCE, 396);
   _actionMap[609][RIGHT] = ActionEntry(REDUCE, 396);
   _actionMap[609][GETPOS] = ActionEntry(REDUCE, 396);
   _actionMap[609][SUBSTR] = ActionEntry(REDUCE, 396);
   _actionMap[609][REPLACE] = ActionEntry(REDUCE, 396);
   _actionMap[609][LENGTH] = ActionEntry(REDUCE, 396);
   _actionMap[609][TRUNC] = ActionEntry(REDUCE, 396);
   _actionMap[609][STR2INT] = ActionEntry(REDUCE, 396);
   _actionMap[609][STR2LONG] = ActionEntry(REDUCE, 396);
   _actionMap[609][RANDSTR] = ActionEntry(REDUCE, 396);
}
void Cego::loadParser70()
{
   _actionMap[609][RANDINT] = ActionEntry(REDUCE, 396);
   _actionMap[609][MOD] = ActionEntry(REDUCE, 396);
   _actionMap[609][DIV] = ActionEntry(REDUCE, 396);
   _actionMap[609][LMOD] = ActionEntry(REDUCE, 396);
   _actionMap[609][LDIV] = ActionEntry(REDUCE, 396);
   _actionMap[609][POWER] = ActionEntry(REDUCE, 396);
   _actionMap[609][BITAND] = ActionEntry(REDUCE, 396);
   _actionMap[609][BITOR] = ActionEntry(REDUCE, 396);
   _actionMap[609][BITXOR] = ActionEntry(REDUCE, 396);
   _actionMap[609][BLOBSIZE] = ActionEntry(REDUCE, 396);
   _actionMap[609][BLOBREF] = ActionEntry(REDUCE, 396);
   _actionMap[609][CLOBSIZE] = ActionEntry(REDUCE, 396);
   _actionMap[609][CLOBREF] = ActionEntry(REDUCE, 396);
   _actionMap[609][CLOB2STR] = ActionEntry(REDUCE, 396);
   _actionMap[609][NEXTCOUNT] = ActionEntry(REDUCE, 396);
   _actionMap[609][SETCOUNT] = ActionEntry(REDUCE, 396);
   _actionMap[609][GETCOUNT] = ActionEntry(REDUCE, 396);
   _actionMap[609][IDENTIFIER] = ActionEntry(REDUCE, 396);
   _actionMap[609][QUALIFIEDOBJ] = ActionEntry(REDUCE, 396);
   _actionMap[609][QUALIFIEDTS] = ActionEntry(REDUCE, 396);
   _actionMap[609][QUALIFIEDPRE] = ActionEntry(REDUCE, 396);
   _actionMap[609][STRINGVAL] = ActionEntry(REDUCE, 396);
   _actionMap[609][SYSDATE] = ActionEntry(REDUCE, 396);
   _actionMap[609][NULLTOKEN] = ActionEntry(REDUCE, 396);
   _actionMap[609][TRUEVAL] = ActionEntry(REDUCE, 396);
   _actionMap[609][FALSEVAL] = ActionEntry(REDUCE, 396);
   _actionMap[609][BLOB] = ActionEntry(REDUCE, 396);
   _actionMap[609][CLOB] = ActionEntry(REDUCE, 396);
   _actionMap[609][FLOATVAL] = ActionEntry(REDUCE, 396);
   _actionMap[609][MINUS] = ActionEntry(REDUCE, 396);
   _actionMap[609][INTVAL] = ActionEntry(REDUCE, 396);
   _actionMap[610][VARREF] = ActionEntry(REDUCE, 397);
   _actionMap[610][FETCH] = ActionEntry(REDUCE, 397);
   _actionMap[610][LB] = ActionEntry(REDUCE, 397);
   _actionMap[610][COUNT] = ActionEntry(REDUCE, 397);
   _actionMap[610][SUM] = ActionEntry(REDUCE, 397);
   _actionMap[610][AVG] = ActionEntry(REDUCE, 397);
   _actionMap[610][MIN] = ActionEntry(REDUCE, 397);
   _actionMap[610][MAX] = ActionEntry(REDUCE, 397);
   _actionMap[610][CASE] = ActionEntry(REDUCE, 397);
   _actionMap[610][INT2ASC] = ActionEntry(REDUCE, 397);
   _actionMap[610][ASC2INT] = ActionEntry(REDUCE, 397);
   _actionMap[610][TRIM] = ActionEntry(REDUCE, 397);
   _actionMap[610][RTRIM] = ActionEntry(REDUCE, 397);
   _actionMap[610][LTRIM] = ActionEntry(REDUCE, 397);
   _actionMap[610][ROUND] = ActionEntry(REDUCE, 397);
   _actionMap[610][SCANDATE] = ActionEntry(REDUCE, 397);
   _actionMap[610][DATE2STR] = ActionEntry(REDUCE, 397);
   _actionMap[610][DATE2LONG] = ActionEntry(REDUCE, 397);
   _actionMap[610][LONG2DATE] = ActionEntry(REDUCE, 397);
}
void Cego::loadParser71()
{
   _actionMap[610][NEWDATE] = ActionEntry(REDUCE, 397);
   _actionMap[610][LOWER] = ActionEntry(REDUCE, 397);
   _actionMap[610][UPPER] = ActionEntry(REDUCE, 397);
   _actionMap[610][LEFT] = ActionEntry(REDUCE, 397);
   _actionMap[610][RIGHT] = ActionEntry(REDUCE, 397);
   _actionMap[610][GETPOS] = ActionEntry(REDUCE, 397);
   _actionMap[610][SUBSTR] = ActionEntry(REDUCE, 397);
   _actionMap[610][REPLACE] = ActionEntry(REDUCE, 397);
   _actionMap[610][LENGTH] = ActionEntry(REDUCE, 397);
   _actionMap[610][TRUNC] = ActionEntry(REDUCE, 397);
   _actionMap[610][STR2INT] = ActionEntry(REDUCE, 397);
   _actionMap[610][STR2LONG] = ActionEntry(REDUCE, 397);
   _actionMap[610][RANDSTR] = ActionEntry(REDUCE, 397);
   _actionMap[610][RANDINT] = ActionEntry(REDUCE, 397);
   _actionMap[610][MOD] = ActionEntry(REDUCE, 397);
   _actionMap[610][DIV] = ActionEntry(REDUCE, 397);
   _actionMap[610][LMOD] = ActionEntry(REDUCE, 397);
   _actionMap[610][LDIV] = ActionEntry(REDUCE, 397);
   _actionMap[610][POWER] = ActionEntry(REDUCE, 397);
   _actionMap[610][BITAND] = ActionEntry(REDUCE, 397);
   _actionMap[610][BITOR] = ActionEntry(REDUCE, 397);
   _actionMap[610][BITXOR] = ActionEntry(REDUCE, 397);
   _actionMap[610][BLOBSIZE] = ActionEntry(REDUCE, 397);
   _actionMap[610][BLOBREF] = ActionEntry(REDUCE, 397);
   _actionMap[610][CLOBSIZE] = ActionEntry(REDUCE, 397);
   _actionMap[610][CLOBREF] = ActionEntry(REDUCE, 397);
   _actionMap[610][CLOB2STR] = ActionEntry(REDUCE, 397);
   _actionMap[610][NEXTCOUNT] = ActionEntry(REDUCE, 397);
   _actionMap[610][SETCOUNT] = ActionEntry(REDUCE, 397);
   _actionMap[610][GETCOUNT] = ActionEntry(REDUCE, 397);
   _actionMap[610][IDENTIFIER] = ActionEntry(REDUCE, 397);
   _actionMap[610][QUALIFIEDOBJ] = ActionEntry(REDUCE, 397);
   _actionMap[610][QUALIFIEDTS] = ActionEntry(REDUCE, 397);
   _actionMap[610][QUALIFIEDPRE] = ActionEntry(REDUCE, 397);
   _actionMap[610][STRINGVAL] = ActionEntry(REDUCE, 397);
   _actionMap[610][SYSDATE] = ActionEntry(REDUCE, 397);
   _actionMap[610][NULLTOKEN] = ActionEntry(REDUCE, 397);
   _actionMap[610][TRUEVAL] = ActionEntry(REDUCE, 397);
   _actionMap[610][FALSEVAL] = ActionEntry(REDUCE, 397);
   _actionMap[610][BLOB] = ActionEntry(REDUCE, 397);
   _actionMap[610][CLOB] = ActionEntry(REDUCE, 397);
   _actionMap[610][FLOATVAL] = ActionEntry(REDUCE, 397);
   _actionMap[610][MINUS] = ActionEntry(REDUCE, 397);
   _actionMap[610][INTVAL] = ActionEntry(REDUCE, 397);
   _actionMap[611][VARREF] = ActionEntry(REDUCE, 393);
   _actionMap[611][FETCH] = ActionEntry(REDUCE, 393);
   _actionMap[611][LB] = ActionEntry(REDUCE, 393);
   _actionMap[611][COUNT] = ActionEntry(REDUCE, 393);
   _actionMap[611][SUM] = ActionEntry(REDUCE, 393);
   _actionMap[611][AVG] = ActionEntry(REDUCE, 393);
}
void Cego::loadParser72()
{
   _actionMap[611][MIN] = ActionEntry(REDUCE, 393);
   _actionMap[611][MAX] = ActionEntry(REDUCE, 393);
   _actionMap[611][CASE] = ActionEntry(REDUCE, 393);
   _actionMap[611][INT2ASC] = ActionEntry(REDUCE, 393);
   _actionMap[611][ASC2INT] = ActionEntry(REDUCE, 393);
   _actionMap[611][TRIM] = ActionEntry(REDUCE, 393);
   _actionMap[611][RTRIM] = ActionEntry(REDUCE, 393);
   _actionMap[611][LTRIM] = ActionEntry(REDUCE, 393);
   _actionMap[611][ROUND] = ActionEntry(REDUCE, 393);
   _actionMap[611][SCANDATE] = ActionEntry(REDUCE, 393);
   _actionMap[611][DATE2STR] = ActionEntry(REDUCE, 393);
   _actionMap[611][DATE2LONG] = ActionEntry(REDUCE, 393);
   _actionMap[611][LONG2DATE] = ActionEntry(REDUCE, 393);
   _actionMap[611][NEWDATE] = ActionEntry(REDUCE, 393);
   _actionMap[611][LOWER] = ActionEntry(REDUCE, 393);
   _actionMap[611][UPPER] = ActionEntry(REDUCE, 393);
   _actionMap[611][LEFT] = ActionEntry(REDUCE, 393);
   _actionMap[611][RIGHT] = ActionEntry(REDUCE, 393);
   _actionMap[611][GETPOS] = ActionEntry(REDUCE, 393);
   _actionMap[611][SUBSTR] = ActionEntry(REDUCE, 393);
   _actionMap[611][REPLACE] = ActionEntry(REDUCE, 393);
   _actionMap[611][LENGTH] = ActionEntry(REDUCE, 393);
   _actionMap[611][TRUNC] = ActionEntry(REDUCE, 393);
   _actionMap[611][STR2INT] = ActionEntry(REDUCE, 393);
   _actionMap[611][STR2LONG] = ActionEntry(REDUCE, 393);
   _actionMap[611][RANDSTR] = ActionEntry(REDUCE, 393);
   _actionMap[611][RANDINT] = ActionEntry(REDUCE, 393);
   _actionMap[611][MOD] = ActionEntry(REDUCE, 393);
   _actionMap[611][DIV] = ActionEntry(REDUCE, 393);
   _actionMap[611][LMOD] = ActionEntry(REDUCE, 393);
   _actionMap[611][LDIV] = ActionEntry(REDUCE, 393);
   _actionMap[611][POWER] = ActionEntry(REDUCE, 393);
   _actionMap[611][BITAND] = ActionEntry(REDUCE, 393);
   _actionMap[611][BITOR] = ActionEntry(REDUCE, 393);
   _actionMap[611][BITXOR] = ActionEntry(REDUCE, 393);
   _actionMap[611][BLOBSIZE] = ActionEntry(REDUCE, 393);
   _actionMap[611][BLOBREF] = ActionEntry(REDUCE, 393);
   _actionMap[611][CLOBSIZE] = ActionEntry(REDUCE, 393);
   _actionMap[611][CLOBREF] = ActionEntry(REDUCE, 393);
   _actionMap[611][CLOB2STR] = ActionEntry(REDUCE, 393);
   _actionMap[611][NEXTCOUNT] = ActionEntry(REDUCE, 393);
   _actionMap[611][SETCOUNT] = ActionEntry(REDUCE, 393);
   _actionMap[611][GETCOUNT] = ActionEntry(REDUCE, 393);
   _actionMap[611][IDENTIFIER] = ActionEntry(REDUCE, 393);
   _actionMap[611][QUALIFIEDOBJ] = ActionEntry(REDUCE, 393);
   _actionMap[611][QUALIFIEDTS] = ActionEntry(REDUCE, 393);
   _actionMap[611][QUALIFIEDPRE] = ActionEntry(REDUCE, 393);
   _actionMap[611][STRINGVAL] = ActionEntry(REDUCE, 393);
   _actionMap[611][SYSDATE] = ActionEntry(REDUCE, 393);
   _actionMap[611][NULLTOKEN] = ActionEntry(REDUCE, 393);
}
void Cego::loadParser73()
{
   _actionMap[611][TRUEVAL] = ActionEntry(REDUCE, 393);
   _actionMap[611][FALSEVAL] = ActionEntry(REDUCE, 393);
   _actionMap[611][BLOB] = ActionEntry(REDUCE, 393);
   _actionMap[611][CLOB] = ActionEntry(REDUCE, 393);
   _actionMap[611][FLOATVAL] = ActionEntry(REDUCE, 393);
   _actionMap[611][MINUS] = ActionEntry(REDUCE, 393);
   _actionMap[611][INTVAL] = ActionEntry(REDUCE, 393);
   _actionMap[612][RB] = ActionEntry(SHIFT, 765);
   _actionMap[613][SEMICOLON] = ActionEntry(REDUCE, 59);
   _actionMap[614][END_TOKEN] = ActionEntry(SHIFT, 766);
   _actionMap[614][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[614][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[614][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[615][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[615][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[615][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[615][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[615][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[615][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[615][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[615][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[615][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[615][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[615][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[615][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[615][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[615][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[615][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[615][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[615][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[615][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[615][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[615][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[615][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[615][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[615][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[615][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[615][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[615][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[615][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[615][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[615][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[615][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[615][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[615][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[615][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[615][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[615][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[615][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[615][BLOBREF] = ActionEntry(SHIFT, 131);
}
void Cego::loadParser74()
{
   _actionMap[615][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[615][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[615][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[615][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[615][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[615][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[615][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[615][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[615][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[615][LB] = ActionEntry(SHIFT, 177);
   _actionMap[615][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[615][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[615][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[615][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[615][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[615][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[615][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[615][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[615][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[615][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[615][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[615][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[615][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[615][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[615][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[615][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[615][ObjSpec] = 122;
   _jumpMap[615][Constant] = 121;
   _jumpMap[615][SignedFloat] = 120;
   _jumpMap[615][SignedInt] = 119;
   _jumpMap[615][Attribute] = 118;
   _jumpMap[615][Function] = 117;
   _jumpMap[615][Factor] = 116;
   _jumpMap[615][Term] = 115;
   _jumpMap[615][Expr] = 767;
   _jumpMap[615][CasePrepare] = 113;
   _jumpMap[615][CaseClause] = 112;
   _actionMap[616][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[616][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[616][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[616][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[616][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[616][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[616][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[616][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[616][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[616][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[616][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[616][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[616][LONG2DATE] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser75()
{
   _actionMap[616][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[616][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[616][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[616][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[616][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[616][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[616][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[616][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[616][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[616][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[616][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[616][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[616][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[616][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[616][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[616][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[616][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[616][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[616][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[616][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[616][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[616][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[616][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[616][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[616][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[616][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[616][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[616][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[616][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[616][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[616][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[616][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[616][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[616][LB] = ActionEntry(SHIFT, 177);
   _actionMap[616][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[616][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[616][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[616][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[616][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[616][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[616][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[616][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[616][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[616][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[616][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[616][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[616][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[616][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[616][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[616][MAX] = ActionEntry(SHIFT, 155);
}
void Cego::loadParser76()
{
   _jumpMap[616][ObjSpec] = 122;
   _jumpMap[616][Constant] = 121;
   _jumpMap[616][SignedFloat] = 120;
   _jumpMap[616][SignedInt] = 119;
   _jumpMap[616][Attribute] = 118;
   _jumpMap[616][Function] = 117;
   _jumpMap[616][Factor] = 116;
   _jumpMap[616][Term] = 115;
   _jumpMap[616][Expr] = 768;
   _jumpMap[616][CasePrepare] = 113;
   _jumpMap[616][CaseClause] = 112;
   _actionMap[617][WHEN] = ActionEntry(REDUCE, 373);
   _actionMap[617][ELSE] = ActionEntry(REDUCE, 373);
   _actionMap[617][LEFT] = ActionEntry(REDUCE, 373);
   _actionMap[617][RIGHT] = ActionEntry(REDUCE, 373);
   _actionMap[617][INNER] = ActionEntry(REDUCE, 373);
   _actionMap[617][JOIN] = ActionEntry(REDUCE, 373);
   _actionMap[617][ORDER] = ActionEntry(REDUCE, 373);
   _actionMap[617][GROUP] = ActionEntry(REDUCE, 373);
   _actionMap[617][RETURNTOKEN] = ActionEntry(REDUCE, 373);
   _actionMap[617][WHERE] = ActionEntry(REDUCE, 373);
   _actionMap[617][FROM] = ActionEntry(REDUCE, 373);
   _actionMap[617][AS] = ActionEntry(REDUCE, 373);
   _actionMap[617][END_TOKEN] = ActionEntry(REDUCE, 373);
   _actionMap[617][BEGIN] = ActionEntry(REDUCE, 373);
   _actionMap[617][THEN] = ActionEntry(REDUCE, 373);
   _actionMap[617][AND] = ActionEntry(REDUCE, 373);
   _actionMap[617][OR] = ActionEntry(REDUCE, 373);
   _actionMap[617][INTOK] = ActionEntry(REDUCE, 373);
   _actionMap[617][NOT] = ActionEntry(REDUCE, 373);
   _actionMap[617][MT] = ActionEntry(REDUCE, 373);
   _actionMap[617][LT] = ActionEntry(REDUCE, 373);
   _actionMap[617][NEGATION] = ActionEntry(REDUCE, 373);
   _actionMap[617][EQU] = ActionEntry(REDUCE, 373);
   _actionMap[617][BETWEEN] = ActionEntry(REDUCE, 373);
   _actionMap[617][IS] = ActionEntry(REDUCE, 373);
   _actionMap[617][LIKE] = ActionEntry(REDUCE, 373);
   _actionMap[617][RB] = ActionEntry(REDUCE, 373);
   _actionMap[617][ENDTOKEN] = ActionEntry(REDUCE, 373);
   _actionMap[617][UNION] = ActionEntry(REDUCE, 373);
   _actionMap[617][ROWLIMIT] = ActionEntry(REDUCE, 373);
   _actionMap[617][KSEP] = ActionEntry(REDUCE, 373);
   _actionMap[617][ASC] = ActionEntry(REDUCE, 373);
   _actionMap[617][DESC] = ActionEntry(REDUCE, 373);
   _actionMap[617][PLUS] = ActionEntry(REDUCE, 373);
   _actionMap[617][MINUS] = ActionEntry(REDUCE, 373);
   _actionMap[617][DIVISION] = ActionEntry(REDUCE, 373);
   _actionMap[617][STAR] = ActionEntry(REDUCE, 373);
   _actionMap[617][CONCAT] = ActionEntry(REDUCE, 373);
   _actionMap[617][SEMICOLON] = ActionEntry(REDUCE, 373);
}
void Cego::loadParser77()
{
   _actionMap[618][WHEN] = ActionEntry(REDUCE, 334);
   _actionMap[618][ELSE] = ActionEntry(REDUCE, 334);
   _actionMap[618][LEFT] = ActionEntry(REDUCE, 334);
   _actionMap[618][RIGHT] = ActionEntry(REDUCE, 334);
   _actionMap[618][INNER] = ActionEntry(REDUCE, 334);
   _actionMap[618][JOIN] = ActionEntry(REDUCE, 334);
   _actionMap[618][ORDER] = ActionEntry(REDUCE, 334);
   _actionMap[618][GROUP] = ActionEntry(REDUCE, 334);
   _actionMap[618][RETURNTOKEN] = ActionEntry(REDUCE, 334);
   _actionMap[618][WHERE] = ActionEntry(REDUCE, 334);
   _actionMap[618][FROM] = ActionEntry(REDUCE, 334);
   _actionMap[618][AS] = ActionEntry(REDUCE, 334);
   _actionMap[618][END_TOKEN] = ActionEntry(REDUCE, 334);
   _actionMap[618][BEGIN] = ActionEntry(REDUCE, 334);
   _actionMap[618][THEN] = ActionEntry(REDUCE, 334);
   _actionMap[618][AND] = ActionEntry(REDUCE, 334);
   _actionMap[618][OR] = ActionEntry(REDUCE, 334);
   _actionMap[618][INTOK] = ActionEntry(REDUCE, 334);
   _actionMap[618][NOT] = ActionEntry(REDUCE, 334);
   _actionMap[618][MT] = ActionEntry(REDUCE, 334);
   _actionMap[618][LT] = ActionEntry(REDUCE, 334);
   _actionMap[618][NEGATION] = ActionEntry(REDUCE, 334);
   _actionMap[618][EQU] = ActionEntry(REDUCE, 334);
   _actionMap[618][BETWEEN] = ActionEntry(REDUCE, 334);
   _actionMap[618][IS] = ActionEntry(REDUCE, 334);
   _actionMap[618][LIKE] = ActionEntry(REDUCE, 334);
   _actionMap[618][RB] = ActionEntry(REDUCE, 334);
   _actionMap[618][ENDTOKEN] = ActionEntry(REDUCE, 334);
   _actionMap[618][UNION] = ActionEntry(REDUCE, 334);
   _actionMap[618][ROWLIMIT] = ActionEntry(REDUCE, 334);
   _actionMap[618][KSEP] = ActionEntry(REDUCE, 334);
   _actionMap[618][ASC] = ActionEntry(REDUCE, 334);
   _actionMap[618][DESC] = ActionEntry(REDUCE, 334);
   _actionMap[618][PLUS] = ActionEntry(REDUCE, 334);
   _actionMap[618][MINUS] = ActionEntry(REDUCE, 334);
   _actionMap[618][DIVISION] = ActionEntry(REDUCE, 334);
   _actionMap[618][STAR] = ActionEntry(REDUCE, 334);
   _actionMap[618][CONCAT] = ActionEntry(REDUCE, 334);
   _actionMap[618][SEMICOLON] = ActionEntry(REDUCE, 334);
   _actionMap[619][WHEN] = ActionEntry(REDUCE, 329);
   _actionMap[619][ELSE] = ActionEntry(REDUCE, 329);
   _actionMap[619][LEFT] = ActionEntry(REDUCE, 329);
   _actionMap[619][RIGHT] = ActionEntry(REDUCE, 329);
   _actionMap[619][INNER] = ActionEntry(REDUCE, 329);
   _actionMap[619][JOIN] = ActionEntry(REDUCE, 329);
   _actionMap[619][ORDER] = ActionEntry(REDUCE, 329);
   _actionMap[619][GROUP] = ActionEntry(REDUCE, 329);
   _actionMap[619][RETURNTOKEN] = ActionEntry(REDUCE, 329);
   _actionMap[619][WHERE] = ActionEntry(REDUCE, 329);
   _actionMap[619][AS] = ActionEntry(REDUCE, 329);
}
void Cego::loadParser78()
{
   _actionMap[619][FROM] = ActionEntry(REDUCE, 329);
   _actionMap[619][END_TOKEN] = ActionEntry(REDUCE, 329);
   _actionMap[619][BEGIN] = ActionEntry(REDUCE, 329);
   _actionMap[619][THEN] = ActionEntry(REDUCE, 329);
   _actionMap[619][OR] = ActionEntry(REDUCE, 329);
   _actionMap[619][AND] = ActionEntry(REDUCE, 329);
   _actionMap[619][LIKE] = ActionEntry(REDUCE, 329);
   _actionMap[619][IS] = ActionEntry(REDUCE, 329);
   _actionMap[619][BETWEEN] = ActionEntry(REDUCE, 329);
   _actionMap[619][EQU] = ActionEntry(REDUCE, 329);
   _actionMap[619][NEGATION] = ActionEntry(REDUCE, 329);
   _actionMap[619][LT] = ActionEntry(REDUCE, 329);
   _actionMap[619][MT] = ActionEntry(REDUCE, 329);
   _actionMap[619][NOT] = ActionEntry(REDUCE, 329);
   _actionMap[619][INTOK] = ActionEntry(REDUCE, 329);
   _actionMap[619][DESC] = ActionEntry(REDUCE, 329);
   _actionMap[619][ASC] = ActionEntry(REDUCE, 329);
   _actionMap[619][KSEP] = ActionEntry(REDUCE, 329);
   _actionMap[619][ROWLIMIT] = ActionEntry(REDUCE, 329);
   _actionMap[619][UNION] = ActionEntry(REDUCE, 329);
   _actionMap[619][ENDTOKEN] = ActionEntry(REDUCE, 329);
   _actionMap[619][RB] = ActionEntry(REDUCE, 329);
   _actionMap[619][CONCAT] = ActionEntry(REDUCE, 329);
   _actionMap[619][STAR] = ActionEntry(REDUCE, 329);
   _actionMap[619][DIVISION] = ActionEntry(REDUCE, 329);
   _actionMap[619][MINUS] = ActionEntry(REDUCE, 329);
   _actionMap[619][PLUS] = ActionEntry(REDUCE, 329);
   _actionMap[619][SEMICOLON] = ActionEntry(REDUCE, 329);
   _actionMap[620][WHEN] = ActionEntry(REDUCE, 362);
   _actionMap[620][ELSE] = ActionEntry(REDUCE, 362);
   _actionMap[620][LEFT] = ActionEntry(REDUCE, 362);
   _actionMap[620][RIGHT] = ActionEntry(REDUCE, 362);
   _actionMap[620][INNER] = ActionEntry(REDUCE, 362);
   _actionMap[620][JOIN] = ActionEntry(REDUCE, 362);
   _actionMap[620][ORDER] = ActionEntry(REDUCE, 362);
   _actionMap[620][GROUP] = ActionEntry(REDUCE, 362);
   _actionMap[620][RETURNTOKEN] = ActionEntry(REDUCE, 362);
   _actionMap[620][WHERE] = ActionEntry(REDUCE, 362);
   _actionMap[620][FROM] = ActionEntry(REDUCE, 362);
   _actionMap[620][AS] = ActionEntry(REDUCE, 362);
   _actionMap[620][END_TOKEN] = ActionEntry(REDUCE, 362);
   _actionMap[620][BEGIN] = ActionEntry(REDUCE, 362);
   _actionMap[620][THEN] = ActionEntry(REDUCE, 362);
   _actionMap[620][AND] = ActionEntry(REDUCE, 362);
   _actionMap[620][OR] = ActionEntry(REDUCE, 362);
   _actionMap[620][INTOK] = ActionEntry(REDUCE, 362);
   _actionMap[620][NOT] = ActionEntry(REDUCE, 362);
   _actionMap[620][MT] = ActionEntry(REDUCE, 362);
   _actionMap[620][LT] = ActionEntry(REDUCE, 362);
   _actionMap[620][NEGATION] = ActionEntry(REDUCE, 362);
}
void Cego::loadParser79()
{
   _actionMap[620][EQU] = ActionEntry(REDUCE, 362);
   _actionMap[620][BETWEEN] = ActionEntry(REDUCE, 362);
   _actionMap[620][IS] = ActionEntry(REDUCE, 362);
   _actionMap[620][LIKE] = ActionEntry(REDUCE, 362);
   _actionMap[620][RB] = ActionEntry(REDUCE, 362);
   _actionMap[620][ENDTOKEN] = ActionEntry(REDUCE, 362);
   _actionMap[620][UNION] = ActionEntry(REDUCE, 362);
   _actionMap[620][ROWLIMIT] = ActionEntry(REDUCE, 362);
   _actionMap[620][KSEP] = ActionEntry(REDUCE, 362);
   _actionMap[620][ASC] = ActionEntry(REDUCE, 362);
   _actionMap[620][DESC] = ActionEntry(REDUCE, 362);
   _actionMap[620][PLUS] = ActionEntry(REDUCE, 362);
   _actionMap[620][MINUS] = ActionEntry(REDUCE, 362);
   _actionMap[620][DIVISION] = ActionEntry(REDUCE, 362);
   _actionMap[620][STAR] = ActionEntry(REDUCE, 362);
   _actionMap[620][CONCAT] = ActionEntry(REDUCE, 362);
   _actionMap[620][SEMICOLON] = ActionEntry(REDUCE, 362);
   _actionMap[621][WHEN] = ActionEntry(REDUCE, 363);
   _actionMap[621][ELSE] = ActionEntry(REDUCE, 363);
   _actionMap[621][LEFT] = ActionEntry(REDUCE, 363);
   _actionMap[621][RIGHT] = ActionEntry(REDUCE, 363);
   _actionMap[621][INNER] = ActionEntry(REDUCE, 363);
   _actionMap[621][JOIN] = ActionEntry(REDUCE, 363);
   _actionMap[621][ORDER] = ActionEntry(REDUCE, 363);
   _actionMap[621][GROUP] = ActionEntry(REDUCE, 363);
   _actionMap[621][RETURNTOKEN] = ActionEntry(REDUCE, 363);
   _actionMap[621][WHERE] = ActionEntry(REDUCE, 363);
   _actionMap[621][FROM] = ActionEntry(REDUCE, 363);
   _actionMap[621][AS] = ActionEntry(REDUCE, 363);
   _actionMap[621][END_TOKEN] = ActionEntry(REDUCE, 363);
   _actionMap[621][BEGIN] = ActionEntry(REDUCE, 363);
   _actionMap[621][THEN] = ActionEntry(REDUCE, 363);
   _actionMap[621][AND] = ActionEntry(REDUCE, 363);
   _actionMap[621][OR] = ActionEntry(REDUCE, 363);
   _actionMap[621][INTOK] = ActionEntry(REDUCE, 363);
   _actionMap[621][NOT] = ActionEntry(REDUCE, 363);
   _actionMap[621][MT] = ActionEntry(REDUCE, 363);
   _actionMap[621][LT] = ActionEntry(REDUCE, 363);
   _actionMap[621][NEGATION] = ActionEntry(REDUCE, 363);
   _actionMap[621][EQU] = ActionEntry(REDUCE, 363);
   _actionMap[621][BETWEEN] = ActionEntry(REDUCE, 363);
   _actionMap[621][IS] = ActionEntry(REDUCE, 363);
   _actionMap[621][LIKE] = ActionEntry(REDUCE, 363);
   _actionMap[621][RB] = ActionEntry(REDUCE, 363);
   _actionMap[621][ENDTOKEN] = ActionEntry(REDUCE, 363);
   _actionMap[621][UNION] = ActionEntry(REDUCE, 363);
   _actionMap[621][ROWLIMIT] = ActionEntry(REDUCE, 363);
   _actionMap[621][KSEP] = ActionEntry(REDUCE, 363);
   _actionMap[621][ASC] = ActionEntry(REDUCE, 363);
   _actionMap[621][DESC] = ActionEntry(REDUCE, 363);
}
void Cego::loadParser80()
{
   _actionMap[621][PLUS] = ActionEntry(REDUCE, 363);
   _actionMap[621][MINUS] = ActionEntry(REDUCE, 363);
   _actionMap[621][DIVISION] = ActionEntry(REDUCE, 363);
   _actionMap[621][STAR] = ActionEntry(REDUCE, 363);
   _actionMap[621][CONCAT] = ActionEntry(REDUCE, 363);
   _actionMap[621][SEMICOLON] = ActionEntry(REDUCE, 363);
   _actionMap[622][WHEN] = ActionEntry(REDUCE, 364);
   _actionMap[622][ELSE] = ActionEntry(REDUCE, 364);
   _actionMap[622][LEFT] = ActionEntry(REDUCE, 364);
   _actionMap[622][RIGHT] = ActionEntry(REDUCE, 364);
   _actionMap[622][INNER] = ActionEntry(REDUCE, 364);
   _actionMap[622][JOIN] = ActionEntry(REDUCE, 364);
   _actionMap[622][ORDER] = ActionEntry(REDUCE, 364);
   _actionMap[622][GROUP] = ActionEntry(REDUCE, 364);
   _actionMap[622][RETURNTOKEN] = ActionEntry(REDUCE, 364);
   _actionMap[622][WHERE] = ActionEntry(REDUCE, 364);
   _actionMap[622][FROM] = ActionEntry(REDUCE, 364);
   _actionMap[622][AS] = ActionEntry(REDUCE, 364);
   _actionMap[622][END_TOKEN] = ActionEntry(REDUCE, 364);
   _actionMap[622][BEGIN] = ActionEntry(REDUCE, 364);
   _actionMap[622][THEN] = ActionEntry(REDUCE, 364);
   _actionMap[622][AND] = ActionEntry(REDUCE, 364);
   _actionMap[622][OR] = ActionEntry(REDUCE, 364);
   _actionMap[622][INTOK] = ActionEntry(REDUCE, 364);
   _actionMap[622][NOT] = ActionEntry(REDUCE, 364);
   _actionMap[622][MT] = ActionEntry(REDUCE, 364);
   _actionMap[622][LT] = ActionEntry(REDUCE, 364);
   _actionMap[622][NEGATION] = ActionEntry(REDUCE, 364);
   _actionMap[622][EQU] = ActionEntry(REDUCE, 364);
   _actionMap[622][BETWEEN] = ActionEntry(REDUCE, 364);
   _actionMap[622][IS] = ActionEntry(REDUCE, 364);
   _actionMap[622][LIKE] = ActionEntry(REDUCE, 364);
   _actionMap[622][RB] = ActionEntry(REDUCE, 364);
   _actionMap[622][ENDTOKEN] = ActionEntry(REDUCE, 364);
   _actionMap[622][UNION] = ActionEntry(REDUCE, 364);
   _actionMap[622][ROWLIMIT] = ActionEntry(REDUCE, 364);
   _actionMap[622][KSEP] = ActionEntry(REDUCE, 364);
   _actionMap[622][ASC] = ActionEntry(REDUCE, 364);
   _actionMap[622][DESC] = ActionEntry(REDUCE, 364);
   _actionMap[622][PLUS] = ActionEntry(REDUCE, 364);
   _actionMap[622][MINUS] = ActionEntry(REDUCE, 364);
   _actionMap[622][DIVISION] = ActionEntry(REDUCE, 364);
   _actionMap[622][STAR] = ActionEntry(REDUCE, 364);
   _actionMap[622][CONCAT] = ActionEntry(REDUCE, 364);
   _actionMap[622][SEMICOLON] = ActionEntry(REDUCE, 364);
   _actionMap[623][WHEN] = ActionEntry(REDUCE, 418);
   _actionMap[623][ELSE] = ActionEntry(REDUCE, 418);
   _actionMap[623][LEFT] = ActionEntry(REDUCE, 418);
   _actionMap[623][RIGHT] = ActionEntry(REDUCE, 418);
   _actionMap[623][INNER] = ActionEntry(REDUCE, 418);
}
void Cego::loadParser81()
{
   _actionMap[623][JOIN] = ActionEntry(REDUCE, 418);
   _actionMap[623][ORDER] = ActionEntry(REDUCE, 418);
   _actionMap[623][GROUP] = ActionEntry(REDUCE, 418);
   _actionMap[623][RETURNTOKEN] = ActionEntry(REDUCE, 418);
   _actionMap[623][WHERE] = ActionEntry(REDUCE, 418);
   _actionMap[623][NULLTOKEN] = ActionEntry(REDUCE, 418);
   _actionMap[623][FROM] = ActionEntry(REDUCE, 418);
   _actionMap[623][AS] = ActionEntry(REDUCE, 418);
   _actionMap[623][END_TOKEN] = ActionEntry(REDUCE, 418);
   _actionMap[623][BEGIN] = ActionEntry(REDUCE, 418);
   _actionMap[623][THEN] = ActionEntry(REDUCE, 418);
   _actionMap[623][AND] = ActionEntry(REDUCE, 418);
   _actionMap[623][OR] = ActionEntry(REDUCE, 418);
   _actionMap[623][INTOK] = ActionEntry(REDUCE, 418);
   _actionMap[623][NOT] = ActionEntry(REDUCE, 418);
   _actionMap[623][MT] = ActionEntry(REDUCE, 418);
   _actionMap[623][LT] = ActionEntry(REDUCE, 418);
   _actionMap[623][NEGATION] = ActionEntry(REDUCE, 418);
   _actionMap[623][EQU] = ActionEntry(REDUCE, 418);
   _actionMap[623][BETWEEN] = ActionEntry(REDUCE, 418);
   _actionMap[623][IS] = ActionEntry(REDUCE, 418);
   _actionMap[623][LIKE] = ActionEntry(REDUCE, 418);
   _actionMap[623][RB] = ActionEntry(REDUCE, 418);
   _actionMap[623][ENDTOKEN] = ActionEntry(REDUCE, 418);
   _actionMap[623][UNION] = ActionEntry(REDUCE, 418);
   _actionMap[623][ROWLIMIT] = ActionEntry(REDUCE, 418);
   _actionMap[623][KSEP] = ActionEntry(REDUCE, 418);
   _actionMap[623][ASC] = ActionEntry(REDUCE, 418);
   _actionMap[623][DESC] = ActionEntry(REDUCE, 418);
   _actionMap[623][PLUS] = ActionEntry(REDUCE, 418);
   _actionMap[623][MINUS] = ActionEntry(REDUCE, 418);
   _actionMap[623][DIVISION] = ActionEntry(REDUCE, 418);
   _actionMap[623][STAR] = ActionEntry(REDUCE, 418);
   _actionMap[623][CONCAT] = ActionEntry(REDUCE, 418);
   _actionMap[623][SEMICOLON] = ActionEntry(REDUCE, 418);
   _actionMap[624][WHEN] = ActionEntry(REDUCE, 365);
   _actionMap[624][ELSE] = ActionEntry(REDUCE, 365);
   _actionMap[624][LEFT] = ActionEntry(REDUCE, 365);
   _actionMap[624][RIGHT] = ActionEntry(REDUCE, 365);
   _actionMap[624][INNER] = ActionEntry(REDUCE, 365);
   _actionMap[624][JOIN] = ActionEntry(REDUCE, 365);
   _actionMap[624][ORDER] = ActionEntry(REDUCE, 365);
   _actionMap[624][GROUP] = ActionEntry(REDUCE, 365);
   _actionMap[624][RETURNTOKEN] = ActionEntry(REDUCE, 365);
   _actionMap[624][WHERE] = ActionEntry(REDUCE, 365);
   _actionMap[624][FROM] = ActionEntry(REDUCE, 365);
   _actionMap[624][AS] = ActionEntry(REDUCE, 365);
   _actionMap[624][END_TOKEN] = ActionEntry(REDUCE, 365);
   _actionMap[624][BEGIN] = ActionEntry(REDUCE, 365);
   _actionMap[624][THEN] = ActionEntry(REDUCE, 365);
}
void Cego::loadParser82()
{
   _actionMap[624][AND] = ActionEntry(REDUCE, 365);
   _actionMap[624][OR] = ActionEntry(REDUCE, 365);
   _actionMap[624][INTOK] = ActionEntry(REDUCE, 365);
   _actionMap[624][NOT] = ActionEntry(REDUCE, 365);
   _actionMap[624][MT] = ActionEntry(REDUCE, 365);
   _actionMap[624][LT] = ActionEntry(REDUCE, 365);
   _actionMap[624][NEGATION] = ActionEntry(REDUCE, 365);
   _actionMap[624][EQU] = ActionEntry(REDUCE, 365);
   _actionMap[624][BETWEEN] = ActionEntry(REDUCE, 365);
   _actionMap[624][IS] = ActionEntry(REDUCE, 365);
   _actionMap[624][LIKE] = ActionEntry(REDUCE, 365);
   _actionMap[624][RB] = ActionEntry(REDUCE, 365);
   _actionMap[624][ENDTOKEN] = ActionEntry(REDUCE, 365);
   _actionMap[624][UNION] = ActionEntry(REDUCE, 365);
   _actionMap[624][ROWLIMIT] = ActionEntry(REDUCE, 365);
   _actionMap[624][KSEP] = ActionEntry(REDUCE, 365);
   _actionMap[624][ASC] = ActionEntry(REDUCE, 365);
   _actionMap[624][DESC] = ActionEntry(REDUCE, 365);
   _actionMap[624][PLUS] = ActionEntry(REDUCE, 365);
   _actionMap[624][MINUS] = ActionEntry(REDUCE, 365);
   _actionMap[624][DIVISION] = ActionEntry(REDUCE, 365);
   _actionMap[624][STAR] = ActionEntry(REDUCE, 365);
   _actionMap[624][CONCAT] = ActionEntry(REDUCE, 365);
   _actionMap[624][SEMICOLON] = ActionEntry(REDUCE, 365);
   _actionMap[625][WHEN] = ActionEntry(REDUCE, 366);
   _actionMap[625][ELSE] = ActionEntry(REDUCE, 366);
   _actionMap[625][LEFT] = ActionEntry(REDUCE, 366);
   _actionMap[625][RIGHT] = ActionEntry(REDUCE, 366);
   _actionMap[625][INNER] = ActionEntry(REDUCE, 366);
   _actionMap[625][JOIN] = ActionEntry(REDUCE, 366);
   _actionMap[625][ORDER] = ActionEntry(REDUCE, 366);
   _actionMap[625][GROUP] = ActionEntry(REDUCE, 366);
   _actionMap[625][RETURNTOKEN] = ActionEntry(REDUCE, 366);
   _actionMap[625][WHERE] = ActionEntry(REDUCE, 366);
   _actionMap[625][FROM] = ActionEntry(REDUCE, 366);
   _actionMap[625][AS] = ActionEntry(REDUCE, 366);
   _actionMap[625][END_TOKEN] = ActionEntry(REDUCE, 366);
   _actionMap[625][BEGIN] = ActionEntry(REDUCE, 366);
   _actionMap[625][THEN] = ActionEntry(REDUCE, 366);
   _actionMap[625][AND] = ActionEntry(REDUCE, 366);
   _actionMap[625][OR] = ActionEntry(REDUCE, 366);
   _actionMap[625][INTOK] = ActionEntry(REDUCE, 366);
   _actionMap[625][NOT] = ActionEntry(REDUCE, 366);
   _actionMap[625][MT] = ActionEntry(REDUCE, 366);
   _actionMap[625][LT] = ActionEntry(REDUCE, 366);
   _actionMap[625][NEGATION] = ActionEntry(REDUCE, 366);
   _actionMap[625][EQU] = ActionEntry(REDUCE, 366);
   _actionMap[625][BETWEEN] = ActionEntry(REDUCE, 366);
   _actionMap[625][IS] = ActionEntry(REDUCE, 366);
   _actionMap[625][LIKE] = ActionEntry(REDUCE, 366);
}
void Cego::loadParser83()
{
   _actionMap[625][RB] = ActionEntry(REDUCE, 366);
   _actionMap[625][ENDTOKEN] = ActionEntry(REDUCE, 366);
   _actionMap[625][UNION] = ActionEntry(REDUCE, 366);
   _actionMap[625][ROWLIMIT] = ActionEntry(REDUCE, 366);
   _actionMap[625][KSEP] = ActionEntry(REDUCE, 366);
   _actionMap[625][ASC] = ActionEntry(REDUCE, 366);
   _actionMap[625][DESC] = ActionEntry(REDUCE, 366);
   _actionMap[625][PLUS] = ActionEntry(REDUCE, 366);
   _actionMap[625][MINUS] = ActionEntry(REDUCE, 366);
   _actionMap[625][DIVISION] = ActionEntry(REDUCE, 366);
   _actionMap[625][STAR] = ActionEntry(REDUCE, 366);
   _actionMap[625][CONCAT] = ActionEntry(REDUCE, 366);
   _actionMap[625][SEMICOLON] = ActionEntry(REDUCE, 366);
   _actionMap[626][WHEN] = ActionEntry(REDUCE, 419);
   _actionMap[626][ELSE] = ActionEntry(REDUCE, 419);
   _actionMap[626][LEFT] = ActionEntry(REDUCE, 419);
   _actionMap[626][RIGHT] = ActionEntry(REDUCE, 419);
   _actionMap[626][INNER] = ActionEntry(REDUCE, 419);
   _actionMap[626][JOIN] = ActionEntry(REDUCE, 419);
   _actionMap[626][ORDER] = ActionEntry(REDUCE, 419);
   _actionMap[626][GROUP] = ActionEntry(REDUCE, 419);
   _actionMap[626][RETURNTOKEN] = ActionEntry(REDUCE, 419);
   _actionMap[626][WHERE] = ActionEntry(REDUCE, 419);
   _actionMap[626][NULLTOKEN] = ActionEntry(REDUCE, 419);
   _actionMap[626][FROM] = ActionEntry(REDUCE, 419);
   _actionMap[626][AS] = ActionEntry(REDUCE, 419);
   _actionMap[626][END_TOKEN] = ActionEntry(REDUCE, 419);
   _actionMap[626][BEGIN] = ActionEntry(REDUCE, 419);
   _actionMap[626][THEN] = ActionEntry(REDUCE, 419);
   _actionMap[626][AND] = ActionEntry(REDUCE, 419);
   _actionMap[626][OR] = ActionEntry(REDUCE, 419);
   _actionMap[626][INTOK] = ActionEntry(REDUCE, 419);
   _actionMap[626][NOT] = ActionEntry(REDUCE, 419);
   _actionMap[626][MT] = ActionEntry(REDUCE, 419);
   _actionMap[626][LT] = ActionEntry(REDUCE, 419);
   _actionMap[626][NEGATION] = ActionEntry(REDUCE, 419);
   _actionMap[626][EQU] = ActionEntry(REDUCE, 419);
   _actionMap[626][BETWEEN] = ActionEntry(REDUCE, 419);
   _actionMap[626][IS] = ActionEntry(REDUCE, 419);
   _actionMap[626][LIKE] = ActionEntry(REDUCE, 419);
   _actionMap[626][RB] = ActionEntry(REDUCE, 419);
   _actionMap[626][ENDTOKEN] = ActionEntry(REDUCE, 419);
   _actionMap[626][UNION] = ActionEntry(REDUCE, 419);
   _actionMap[626][ROWLIMIT] = ActionEntry(REDUCE, 419);
   _actionMap[626][KSEP] = ActionEntry(REDUCE, 419);
   _actionMap[626][ASC] = ActionEntry(REDUCE, 419);
   _actionMap[626][DESC] = ActionEntry(REDUCE, 419);
   _actionMap[626][PLUS] = ActionEntry(REDUCE, 419);
   _actionMap[626][MINUS] = ActionEntry(REDUCE, 419);
   _actionMap[626][DIVISION] = ActionEntry(REDUCE, 419);
}
void Cego::loadParser84()
{
   _actionMap[626][STAR] = ActionEntry(REDUCE, 419);
   _actionMap[626][CONCAT] = ActionEntry(REDUCE, 419);
   _actionMap[626][SEMICOLON] = ActionEntry(REDUCE, 419);
   _actionMap[627][WHEN] = ActionEntry(REDUCE, 367);
   _actionMap[627][ELSE] = ActionEntry(REDUCE, 367);
   _actionMap[627][LEFT] = ActionEntry(REDUCE, 367);
   _actionMap[627][RIGHT] = ActionEntry(REDUCE, 367);
   _actionMap[627][INNER] = ActionEntry(REDUCE, 367);
   _actionMap[627][JOIN] = ActionEntry(REDUCE, 367);
   _actionMap[627][ORDER] = ActionEntry(REDUCE, 367);
   _actionMap[627][GROUP] = ActionEntry(REDUCE, 367);
   _actionMap[627][RETURNTOKEN] = ActionEntry(REDUCE, 367);
   _actionMap[627][WHERE] = ActionEntry(REDUCE, 367);
   _actionMap[627][FROM] = ActionEntry(REDUCE, 367);
   _actionMap[627][AS] = ActionEntry(REDUCE, 367);
   _actionMap[627][END_TOKEN] = ActionEntry(REDUCE, 367);
   _actionMap[627][BEGIN] = ActionEntry(REDUCE, 367);
   _actionMap[627][THEN] = ActionEntry(REDUCE, 367);
   _actionMap[627][AND] = ActionEntry(REDUCE, 367);
   _actionMap[627][OR] = ActionEntry(REDUCE, 367);
   _actionMap[627][INTOK] = ActionEntry(REDUCE, 367);
   _actionMap[627][NOT] = ActionEntry(REDUCE, 367);
   _actionMap[627][MT] = ActionEntry(REDUCE, 367);
   _actionMap[627][LT] = ActionEntry(REDUCE, 367);
   _actionMap[627][NEGATION] = ActionEntry(REDUCE, 367);
   _actionMap[627][EQU] = ActionEntry(REDUCE, 367);
   _actionMap[627][BETWEEN] = ActionEntry(REDUCE, 367);
   _actionMap[627][IS] = ActionEntry(REDUCE, 367);
   _actionMap[627][LIKE] = ActionEntry(REDUCE, 367);
   _actionMap[627][RB] = ActionEntry(REDUCE, 367);
   _actionMap[627][ENDTOKEN] = ActionEntry(REDUCE, 367);
   _actionMap[627][UNION] = ActionEntry(REDUCE, 367);
   _actionMap[627][ROWLIMIT] = ActionEntry(REDUCE, 367);
   _actionMap[627][KSEP] = ActionEntry(REDUCE, 367);
   _actionMap[627][ASC] = ActionEntry(REDUCE, 367);
   _actionMap[627][DESC] = ActionEntry(REDUCE, 367);
   _actionMap[627][PLUS] = ActionEntry(REDUCE, 367);
   _actionMap[627][MINUS] = ActionEntry(REDUCE, 367);
   _actionMap[627][DIVISION] = ActionEntry(REDUCE, 367);
   _actionMap[627][STAR] = ActionEntry(REDUCE, 367);
   _actionMap[627][CONCAT] = ActionEntry(REDUCE, 367);
   _actionMap[627][SEMICOLON] = ActionEntry(REDUCE, 367);
   _actionMap[628][WHEN] = ActionEntry(REDUCE, 368);
   _actionMap[628][ELSE] = ActionEntry(REDUCE, 368);
   _actionMap[628][LEFT] = ActionEntry(REDUCE, 368);
   _actionMap[628][RIGHT] = ActionEntry(REDUCE, 368);
   _actionMap[628][INNER] = ActionEntry(REDUCE, 368);
   _actionMap[628][JOIN] = ActionEntry(REDUCE, 368);
   _actionMap[628][ORDER] = ActionEntry(REDUCE, 368);
   _actionMap[628][GROUP] = ActionEntry(REDUCE, 368);
}
void Cego::loadParser85()
{
   _actionMap[628][RETURNTOKEN] = ActionEntry(REDUCE, 368);
   _actionMap[628][WHERE] = ActionEntry(REDUCE, 368);
   _actionMap[628][FROM] = ActionEntry(REDUCE, 368);
   _actionMap[628][AS] = ActionEntry(REDUCE, 368);
   _actionMap[628][END_TOKEN] = ActionEntry(REDUCE, 368);
   _actionMap[628][BEGIN] = ActionEntry(REDUCE, 368);
   _actionMap[628][THEN] = ActionEntry(REDUCE, 368);
   _actionMap[628][AND] = ActionEntry(REDUCE, 368);
   _actionMap[628][OR] = ActionEntry(REDUCE, 368);
   _actionMap[628][INTOK] = ActionEntry(REDUCE, 368);
   _actionMap[628][NOT] = ActionEntry(REDUCE, 368);
   _actionMap[628][MT] = ActionEntry(REDUCE, 368);
   _actionMap[628][LT] = ActionEntry(REDUCE, 368);
   _actionMap[628][NEGATION] = ActionEntry(REDUCE, 368);
   _actionMap[628][EQU] = ActionEntry(REDUCE, 368);
   _actionMap[628][BETWEEN] = ActionEntry(REDUCE, 368);
   _actionMap[628][IS] = ActionEntry(REDUCE, 368);
   _actionMap[628][LIKE] = ActionEntry(REDUCE, 368);
   _actionMap[628][RB] = ActionEntry(REDUCE, 368);
   _actionMap[628][ENDTOKEN] = ActionEntry(REDUCE, 368);
   _actionMap[628][UNION] = ActionEntry(REDUCE, 368);
   _actionMap[628][ROWLIMIT] = ActionEntry(REDUCE, 368);
   _actionMap[628][KSEP] = ActionEntry(REDUCE, 368);
   _actionMap[628][ASC] = ActionEntry(REDUCE, 368);
   _actionMap[628][DESC] = ActionEntry(REDUCE, 368);
   _actionMap[628][PLUS] = ActionEntry(REDUCE, 368);
   _actionMap[628][MINUS] = ActionEntry(REDUCE, 368);
   _actionMap[628][DIVISION] = ActionEntry(REDUCE, 368);
   _actionMap[628][STAR] = ActionEntry(REDUCE, 368);
   _actionMap[628][CONCAT] = ActionEntry(REDUCE, 368);
   _actionMap[628][SEMICOLON] = ActionEntry(REDUCE, 368);
   _actionMap[629][WHEN] = ActionEntry(REDUCE, 369);
   _actionMap[629][ELSE] = ActionEntry(REDUCE, 369);
   _actionMap[629][LEFT] = ActionEntry(REDUCE, 369);
   _actionMap[629][RIGHT] = ActionEntry(REDUCE, 369);
   _actionMap[629][INNER] = ActionEntry(REDUCE, 369);
   _actionMap[629][JOIN] = ActionEntry(REDUCE, 369);
   _actionMap[629][ORDER] = ActionEntry(REDUCE, 369);
   _actionMap[629][GROUP] = ActionEntry(REDUCE, 369);
   _actionMap[629][RETURNTOKEN] = ActionEntry(REDUCE, 369);
   _actionMap[629][WHERE] = ActionEntry(REDUCE, 369);
   _actionMap[629][FROM] = ActionEntry(REDUCE, 369);
   _actionMap[629][AS] = ActionEntry(REDUCE, 369);
   _actionMap[629][END_TOKEN] = ActionEntry(REDUCE, 369);
   _actionMap[629][BEGIN] = ActionEntry(REDUCE, 369);
   _actionMap[629][THEN] = ActionEntry(REDUCE, 369);
   _actionMap[629][AND] = ActionEntry(REDUCE, 369);
   _actionMap[629][OR] = ActionEntry(REDUCE, 369);
   _actionMap[629][INTOK] = ActionEntry(REDUCE, 369);
   _actionMap[629][NOT] = ActionEntry(REDUCE, 369);
}
void Cego::loadParser86()
{
   _actionMap[629][MT] = ActionEntry(REDUCE, 369);
   _actionMap[629][LT] = ActionEntry(REDUCE, 369);
   _actionMap[629][NEGATION] = ActionEntry(REDUCE, 369);
   _actionMap[629][EQU] = ActionEntry(REDUCE, 369);
   _actionMap[629][BETWEEN] = ActionEntry(REDUCE, 369);
   _actionMap[629][IS] = ActionEntry(REDUCE, 369);
   _actionMap[629][LIKE] = ActionEntry(REDUCE, 369);
   _actionMap[629][RB] = ActionEntry(REDUCE, 369);
   _actionMap[629][ENDTOKEN] = ActionEntry(REDUCE, 369);
   _actionMap[629][UNION] = ActionEntry(REDUCE, 369);
   _actionMap[629][ROWLIMIT] = ActionEntry(REDUCE, 369);
   _actionMap[629][KSEP] = ActionEntry(REDUCE, 369);
   _actionMap[629][ASC] = ActionEntry(REDUCE, 369);
   _actionMap[629][DESC] = ActionEntry(REDUCE, 369);
   _actionMap[629][PLUS] = ActionEntry(REDUCE, 369);
   _actionMap[629][MINUS] = ActionEntry(REDUCE, 369);
   _actionMap[629][DIVISION] = ActionEntry(REDUCE, 369);
   _actionMap[629][STAR] = ActionEntry(REDUCE, 369);
   _actionMap[629][CONCAT] = ActionEntry(REDUCE, 369);
   _actionMap[629][SEMICOLON] = ActionEntry(REDUCE, 369);
   _actionMap[630][WHEN] = ActionEntry(REDUCE, 330);
   _actionMap[630][ELSE] = ActionEntry(REDUCE, 330);
   _actionMap[630][LEFT] = ActionEntry(REDUCE, 330);
   _actionMap[630][RIGHT] = ActionEntry(REDUCE, 330);
   _actionMap[630][INNER] = ActionEntry(REDUCE, 330);
   _actionMap[630][JOIN] = ActionEntry(REDUCE, 330);
   _actionMap[630][ORDER] = ActionEntry(REDUCE, 330);
   _actionMap[630][GROUP] = ActionEntry(REDUCE, 330);
   _actionMap[630][RETURNTOKEN] = ActionEntry(REDUCE, 330);
   _actionMap[630][WHERE] = ActionEntry(REDUCE, 330);
   _actionMap[630][AS] = ActionEntry(REDUCE, 330);
   _actionMap[630][FROM] = ActionEntry(REDUCE, 330);
   _actionMap[630][END_TOKEN] = ActionEntry(REDUCE, 330);
   _actionMap[630][BEGIN] = ActionEntry(REDUCE, 330);
   _actionMap[630][THEN] = ActionEntry(REDUCE, 330);
   _actionMap[630][OR] = ActionEntry(REDUCE, 330);
   _actionMap[630][AND] = ActionEntry(REDUCE, 330);
   _actionMap[630][LIKE] = ActionEntry(REDUCE, 330);
   _actionMap[630][IS] = ActionEntry(REDUCE, 330);
   _actionMap[630][BETWEEN] = ActionEntry(REDUCE, 330);
   _actionMap[630][EQU] = ActionEntry(REDUCE, 330);
   _actionMap[630][NEGATION] = ActionEntry(REDUCE, 330);
   _actionMap[630][LT] = ActionEntry(REDUCE, 330);
   _actionMap[630][MT] = ActionEntry(REDUCE, 330);
   _actionMap[630][NOT] = ActionEntry(REDUCE, 330);
   _actionMap[630][INTOK] = ActionEntry(REDUCE, 330);
   _actionMap[630][DESC] = ActionEntry(REDUCE, 330);
   _actionMap[630][ASC] = ActionEntry(REDUCE, 330);
   _actionMap[630][KSEP] = ActionEntry(REDUCE, 330);
   _actionMap[630][ROWLIMIT] = ActionEntry(REDUCE, 330);
}
void Cego::loadParser87()
{
   _actionMap[630][UNION] = ActionEntry(REDUCE, 330);
   _actionMap[630][ENDTOKEN] = ActionEntry(REDUCE, 330);
   _actionMap[630][RB] = ActionEntry(REDUCE, 330);
   _actionMap[630][CONCAT] = ActionEntry(REDUCE, 330);
   _actionMap[630][STAR] = ActionEntry(REDUCE, 330);
   _actionMap[630][DIVISION] = ActionEntry(REDUCE, 330);
   _actionMap[630][MINUS] = ActionEntry(REDUCE, 330);
   _actionMap[630][PLUS] = ActionEntry(REDUCE, 330);
   _actionMap[630][SEMICOLON] = ActionEntry(REDUCE, 330);
   _actionMap[631][WHEN] = ActionEntry(REDUCE, 327);
   _actionMap[631][ELSE] = ActionEntry(REDUCE, 327);
   _actionMap[631][LEFT] = ActionEntry(REDUCE, 327);
   _actionMap[631][RIGHT] = ActionEntry(REDUCE, 327);
   _actionMap[631][INNER] = ActionEntry(REDUCE, 327);
   _actionMap[631][JOIN] = ActionEntry(REDUCE, 327);
   _actionMap[631][ORDER] = ActionEntry(REDUCE, 327);
   _actionMap[631][GROUP] = ActionEntry(REDUCE, 327);
   _actionMap[631][RETURNTOKEN] = ActionEntry(REDUCE, 327);
   _actionMap[631][WHERE] = ActionEntry(REDUCE, 327);
   _actionMap[631][AS] = ActionEntry(REDUCE, 327);
   _actionMap[631][FROM] = ActionEntry(REDUCE, 327);
   _actionMap[631][END_TOKEN] = ActionEntry(REDUCE, 327);
   _actionMap[631][BEGIN] = ActionEntry(REDUCE, 327);
   _actionMap[631][THEN] = ActionEntry(REDUCE, 327);
   _actionMap[631][OR] = ActionEntry(REDUCE, 327);
   _actionMap[631][AND] = ActionEntry(REDUCE, 327);
   _actionMap[631][LIKE] = ActionEntry(REDUCE, 327);
   _actionMap[631][IS] = ActionEntry(REDUCE, 327);
   _actionMap[631][BETWEEN] = ActionEntry(REDUCE, 327);
   _actionMap[631][EQU] = ActionEntry(REDUCE, 327);
   _actionMap[631][NEGATION] = ActionEntry(REDUCE, 327);
   _actionMap[631][LT] = ActionEntry(REDUCE, 327);
   _actionMap[631][MT] = ActionEntry(REDUCE, 327);
   _actionMap[631][NOT] = ActionEntry(REDUCE, 327);
   _actionMap[631][INTOK] = ActionEntry(REDUCE, 327);
   _actionMap[631][DESC] = ActionEntry(REDUCE, 327);
   _actionMap[631][ASC] = ActionEntry(REDUCE, 327);
   _actionMap[631][KSEP] = ActionEntry(REDUCE, 327);
   _actionMap[631][ROWLIMIT] = ActionEntry(REDUCE, 327);
   _actionMap[631][UNION] = ActionEntry(REDUCE, 327);
   _actionMap[631][ENDTOKEN] = ActionEntry(REDUCE, 327);
   _actionMap[631][RB] = ActionEntry(REDUCE, 327);
   _actionMap[631][CONCAT] = ActionEntry(REDUCE, 327);
   _actionMap[631][STAR] = ActionEntry(REDUCE, 327);
   _actionMap[631][DIVISION] = ActionEntry(REDUCE, 327);
   _actionMap[631][MINUS] = ActionEntry(REDUCE, 327);
   _actionMap[631][PLUS] = ActionEntry(REDUCE, 327);
   _actionMap[631][SEMICOLON] = ActionEntry(REDUCE, 327);
   _actionMap[632][WHEN] = ActionEntry(REDUCE, 340);
   _actionMap[632][ELSE] = ActionEntry(REDUCE, 340);
}
void Cego::loadParser88()
{
   _actionMap[632][LEFT] = ActionEntry(REDUCE, 340);
   _actionMap[632][RIGHT] = ActionEntry(REDUCE, 340);
   _actionMap[632][INNER] = ActionEntry(REDUCE, 340);
   _actionMap[632][JOIN] = ActionEntry(REDUCE, 340);
   _actionMap[632][ORDER] = ActionEntry(REDUCE, 340);
   _actionMap[632][GROUP] = ActionEntry(REDUCE, 340);
   _actionMap[632][RETURNTOKEN] = ActionEntry(REDUCE, 340);
   _actionMap[632][WHERE] = ActionEntry(REDUCE, 340);
   _actionMap[632][FROM] = ActionEntry(REDUCE, 340);
   _actionMap[632][AS] = ActionEntry(REDUCE, 340);
   _actionMap[632][END_TOKEN] = ActionEntry(REDUCE, 340);
   _actionMap[632][BEGIN] = ActionEntry(REDUCE, 340);
   _actionMap[632][THEN] = ActionEntry(REDUCE, 340);
   _actionMap[632][AND] = ActionEntry(REDUCE, 340);
   _actionMap[632][OR] = ActionEntry(REDUCE, 340);
   _actionMap[632][INTOK] = ActionEntry(REDUCE, 340);
   _actionMap[632][NOT] = ActionEntry(REDUCE, 340);
   _actionMap[632][MT] = ActionEntry(REDUCE, 340);
   _actionMap[632][LT] = ActionEntry(REDUCE, 340);
   _actionMap[632][NEGATION] = ActionEntry(REDUCE, 340);
   _actionMap[632][EQU] = ActionEntry(REDUCE, 340);
   _actionMap[632][BETWEEN] = ActionEntry(REDUCE, 340);
   _actionMap[632][IS] = ActionEntry(REDUCE, 340);
   _actionMap[632][LIKE] = ActionEntry(REDUCE, 340);
   _actionMap[632][RB] = ActionEntry(REDUCE, 340);
   _actionMap[632][ENDTOKEN] = ActionEntry(REDUCE, 340);
   _actionMap[632][UNION] = ActionEntry(REDUCE, 340);
   _actionMap[632][ROWLIMIT] = ActionEntry(REDUCE, 340);
   _actionMap[632][KSEP] = ActionEntry(REDUCE, 340);
   _actionMap[632][ASC] = ActionEntry(REDUCE, 340);
   _actionMap[632][DESC] = ActionEntry(REDUCE, 340);
   _actionMap[632][PLUS] = ActionEntry(REDUCE, 340);
   _actionMap[632][MINUS] = ActionEntry(REDUCE, 340);
   _actionMap[632][DIVISION] = ActionEntry(REDUCE, 340);
   _actionMap[632][STAR] = ActionEntry(REDUCE, 340);
   _actionMap[632][CONCAT] = ActionEntry(REDUCE, 340);
   _actionMap[632][SEMICOLON] = ActionEntry(REDUCE, 340);
   _actionMap[633][WHEN] = ActionEntry(REDUCE, 341);
   _actionMap[633][ELSE] = ActionEntry(REDUCE, 341);
   _actionMap[633][LEFT] = ActionEntry(REDUCE, 341);
   _actionMap[633][RIGHT] = ActionEntry(REDUCE, 341);
   _actionMap[633][INNER] = ActionEntry(REDUCE, 341);
   _actionMap[633][JOIN] = ActionEntry(REDUCE, 341);
   _actionMap[633][ORDER] = ActionEntry(REDUCE, 341);
   _actionMap[633][GROUP] = ActionEntry(REDUCE, 341);
   _actionMap[633][RETURNTOKEN] = ActionEntry(REDUCE, 341);
   _actionMap[633][WHERE] = ActionEntry(REDUCE, 341);
   _actionMap[633][FROM] = ActionEntry(REDUCE, 341);
   _actionMap[633][AS] = ActionEntry(REDUCE, 341);
   _actionMap[633][END_TOKEN] = ActionEntry(REDUCE, 341);
}
void Cego::loadParser89()
{
   _actionMap[633][BEGIN] = ActionEntry(REDUCE, 341);
   _actionMap[633][THEN] = ActionEntry(REDUCE, 341);
   _actionMap[633][AND] = ActionEntry(REDUCE, 341);
   _actionMap[633][OR] = ActionEntry(REDUCE, 341);
   _actionMap[633][INTOK] = ActionEntry(REDUCE, 341);
   _actionMap[633][NOT] = ActionEntry(REDUCE, 341);
   _actionMap[633][MT] = ActionEntry(REDUCE, 341);
   _actionMap[633][LT] = ActionEntry(REDUCE, 341);
   _actionMap[633][NEGATION] = ActionEntry(REDUCE, 341);
   _actionMap[633][EQU] = ActionEntry(REDUCE, 341);
   _actionMap[633][BETWEEN] = ActionEntry(REDUCE, 341);
   _actionMap[633][IS] = ActionEntry(REDUCE, 341);
   _actionMap[633][LIKE] = ActionEntry(REDUCE, 341);
   _actionMap[633][RB] = ActionEntry(REDUCE, 341);
   _actionMap[633][ENDTOKEN] = ActionEntry(REDUCE, 341);
   _actionMap[633][UNION] = ActionEntry(REDUCE, 341);
   _actionMap[633][ROWLIMIT] = ActionEntry(REDUCE, 341);
   _actionMap[633][KSEP] = ActionEntry(REDUCE, 341);
   _actionMap[633][ASC] = ActionEntry(REDUCE, 341);
   _actionMap[633][DESC] = ActionEntry(REDUCE, 341);
   _actionMap[633][PLUS] = ActionEntry(REDUCE, 341);
   _actionMap[633][MINUS] = ActionEntry(REDUCE, 341);
   _actionMap[633][DIVISION] = ActionEntry(REDUCE, 341);
   _actionMap[633][STAR] = ActionEntry(REDUCE, 341);
   _actionMap[633][CONCAT] = ActionEntry(REDUCE, 341);
   _actionMap[633][SEMICOLON] = ActionEntry(REDUCE, 341);
   _actionMap[634][WHEN] = ActionEntry(REDUCE, 358);
   _actionMap[634][ELSE] = ActionEntry(REDUCE, 358);
   _actionMap[634][LEFT] = ActionEntry(REDUCE, 358);
   _actionMap[634][RIGHT] = ActionEntry(REDUCE, 358);
   _actionMap[634][INNER] = ActionEntry(REDUCE, 358);
   _actionMap[634][JOIN] = ActionEntry(REDUCE, 358);
   _actionMap[634][ORDER] = ActionEntry(REDUCE, 358);
   _actionMap[634][GROUP] = ActionEntry(REDUCE, 358);
   _actionMap[634][RETURNTOKEN] = ActionEntry(REDUCE, 358);
   _actionMap[634][WHERE] = ActionEntry(REDUCE, 358);
   _actionMap[634][FROM] = ActionEntry(REDUCE, 358);
   _actionMap[634][AS] = ActionEntry(REDUCE, 358);
   _actionMap[634][END_TOKEN] = ActionEntry(REDUCE, 358);
   _actionMap[634][BEGIN] = ActionEntry(REDUCE, 358);
   _actionMap[634][THEN] = ActionEntry(REDUCE, 358);
   _actionMap[634][AND] = ActionEntry(REDUCE, 358);
   _actionMap[634][OR] = ActionEntry(REDUCE, 358);
   _actionMap[634][INTOK] = ActionEntry(REDUCE, 358);
   _actionMap[634][NOT] = ActionEntry(REDUCE, 358);
   _actionMap[634][MT] = ActionEntry(REDUCE, 358);
   _actionMap[634][LT] = ActionEntry(REDUCE, 358);
   _actionMap[634][NEGATION] = ActionEntry(REDUCE, 358);
   _actionMap[634][EQU] = ActionEntry(REDUCE, 358);
   _actionMap[634][BETWEEN] = ActionEntry(REDUCE, 358);
}
void Cego::loadParser90()
{
   _actionMap[634][IS] = ActionEntry(REDUCE, 358);
   _actionMap[634][LIKE] = ActionEntry(REDUCE, 358);
   _actionMap[634][RB] = ActionEntry(REDUCE, 358);
   _actionMap[634][ENDTOKEN] = ActionEntry(REDUCE, 358);
   _actionMap[634][UNION] = ActionEntry(REDUCE, 358);
   _actionMap[634][ROWLIMIT] = ActionEntry(REDUCE, 358);
   _actionMap[634][KSEP] = ActionEntry(REDUCE, 358);
   _actionMap[634][ASC] = ActionEntry(REDUCE, 358);
   _actionMap[634][DESC] = ActionEntry(REDUCE, 358);
   _actionMap[634][PLUS] = ActionEntry(REDUCE, 358);
   _actionMap[634][MINUS] = ActionEntry(REDUCE, 358);
   _actionMap[634][DIVISION] = ActionEntry(REDUCE, 358);
   _actionMap[634][STAR] = ActionEntry(REDUCE, 358);
   _actionMap[634][CONCAT] = ActionEntry(REDUCE, 358);
   _actionMap[634][SEMICOLON] = ActionEntry(REDUCE, 358);
   _actionMap[635][VARREF] = ActionEntry(SHIFT, 770);
   _jumpMap[635][FetchArgList] = 769;
   _actionMap[636][WHEN] = ActionEntry(REDUCE, 372);
   _actionMap[636][ELSE] = ActionEntry(REDUCE, 372);
   _actionMap[636][LEFT] = ActionEntry(REDUCE, 372);
   _actionMap[636][RIGHT] = ActionEntry(REDUCE, 372);
   _actionMap[636][INNER] = ActionEntry(REDUCE, 372);
   _actionMap[636][JOIN] = ActionEntry(REDUCE, 372);
   _actionMap[636][ORDER] = ActionEntry(REDUCE, 372);
   _actionMap[636][GROUP] = ActionEntry(REDUCE, 372);
   _actionMap[636][RETURNTOKEN] = ActionEntry(REDUCE, 372);
   _actionMap[636][WHERE] = ActionEntry(REDUCE, 372);
   _actionMap[636][FROM] = ActionEntry(REDUCE, 372);
   _actionMap[636][AS] = ActionEntry(REDUCE, 372);
   _actionMap[636][END_TOKEN] = ActionEntry(REDUCE, 372);
   _actionMap[636][BEGIN] = ActionEntry(REDUCE, 372);
   _actionMap[636][THEN] = ActionEntry(REDUCE, 372);
   _actionMap[636][AND] = ActionEntry(REDUCE, 372);
   _actionMap[636][OR] = ActionEntry(REDUCE, 372);
   _actionMap[636][INTOK] = ActionEntry(REDUCE, 372);
   _actionMap[636][NOT] = ActionEntry(REDUCE, 372);
   _actionMap[636][MT] = ActionEntry(REDUCE, 372);
   _actionMap[636][LT] = ActionEntry(REDUCE, 372);
   _actionMap[636][NEGATION] = ActionEntry(REDUCE, 372);
   _actionMap[636][EQU] = ActionEntry(REDUCE, 372);
   _actionMap[636][BETWEEN] = ActionEntry(REDUCE, 372);
   _actionMap[636][IS] = ActionEntry(REDUCE, 372);
   _actionMap[636][LIKE] = ActionEntry(REDUCE, 372);
   _actionMap[636][RB] = ActionEntry(REDUCE, 372);
   _actionMap[636][ENDTOKEN] = ActionEntry(REDUCE, 372);
   _actionMap[636][UNION] = ActionEntry(REDUCE, 372);
   _actionMap[636][ROWLIMIT] = ActionEntry(REDUCE, 372);
   _actionMap[636][KSEP] = ActionEntry(REDUCE, 372);
   _actionMap[636][ASC] = ActionEntry(REDUCE, 372);
   _actionMap[636][DESC] = ActionEntry(REDUCE, 372);
}
void Cego::loadParser91()
{
   _actionMap[636][PLUS] = ActionEntry(REDUCE, 372);
   _actionMap[636][MINUS] = ActionEntry(REDUCE, 372);
   _actionMap[636][DIVISION] = ActionEntry(REDUCE, 372);
   _actionMap[636][STAR] = ActionEntry(REDUCE, 372);
   _actionMap[636][CONCAT] = ActionEntry(REDUCE, 372);
   _actionMap[636][SEMICOLON] = ActionEntry(REDUCE, 372);
   _actionMap[637][WHEN] = ActionEntry(REDUCE, 348);
   _actionMap[637][ELSE] = ActionEntry(REDUCE, 348);
   _actionMap[637][LEFT] = ActionEntry(REDUCE, 348);
   _actionMap[637][RIGHT] = ActionEntry(REDUCE, 348);
   _actionMap[637][INNER] = ActionEntry(REDUCE, 348);
   _actionMap[637][JOIN] = ActionEntry(REDUCE, 348);
   _actionMap[637][ORDER] = ActionEntry(REDUCE, 348);
   _actionMap[637][GROUP] = ActionEntry(REDUCE, 348);
   _actionMap[637][RETURNTOKEN] = ActionEntry(REDUCE, 348);
   _actionMap[637][WHERE] = ActionEntry(REDUCE, 348);
   _actionMap[637][FROM] = ActionEntry(REDUCE, 348);
   _actionMap[637][AS] = ActionEntry(REDUCE, 348);
   _actionMap[637][END_TOKEN] = ActionEntry(REDUCE, 348);
   _actionMap[637][BEGIN] = ActionEntry(REDUCE, 348);
   _actionMap[637][THEN] = ActionEntry(REDUCE, 348);
   _actionMap[637][AND] = ActionEntry(REDUCE, 348);
   _actionMap[637][OR] = ActionEntry(REDUCE, 348);
   _actionMap[637][INTOK] = ActionEntry(REDUCE, 348);
   _actionMap[637][NOT] = ActionEntry(REDUCE, 348);
   _actionMap[637][MT] = ActionEntry(REDUCE, 348);
   _actionMap[637][LT] = ActionEntry(REDUCE, 348);
   _actionMap[637][NEGATION] = ActionEntry(REDUCE, 348);
   _actionMap[637][EQU] = ActionEntry(REDUCE, 348);
   _actionMap[637][BETWEEN] = ActionEntry(REDUCE, 348);
   _actionMap[637][IS] = ActionEntry(REDUCE, 348);
   _actionMap[637][LIKE] = ActionEntry(REDUCE, 348);
   _actionMap[637][RB] = ActionEntry(REDUCE, 348);
   _actionMap[637][ENDTOKEN] = ActionEntry(REDUCE, 348);
   _actionMap[637][UNION] = ActionEntry(REDUCE, 348);
   _actionMap[637][ROWLIMIT] = ActionEntry(REDUCE, 348);
   _actionMap[637][KSEP] = ActionEntry(REDUCE, 348);
   _actionMap[637][ASC] = ActionEntry(REDUCE, 348);
   _actionMap[637][DESC] = ActionEntry(REDUCE, 348);
   _actionMap[637][PLUS] = ActionEntry(REDUCE, 348);
   _actionMap[637][MINUS] = ActionEntry(REDUCE, 348);
   _actionMap[637][DIVISION] = ActionEntry(REDUCE, 348);
   _actionMap[637][STAR] = ActionEntry(REDUCE, 348);
   _actionMap[637][CONCAT] = ActionEntry(REDUCE, 348);
   _actionMap[637][SEMICOLON] = ActionEntry(REDUCE, 348);
   _actionMap[638][WHEN] = ActionEntry(REDUCE, 342);
   _actionMap[638][ELSE] = ActionEntry(REDUCE, 342);
   _actionMap[638][LEFT] = ActionEntry(REDUCE, 342);
   _actionMap[638][RIGHT] = ActionEntry(REDUCE, 342);
   _actionMap[638][INNER] = ActionEntry(REDUCE, 342);
}
void Cego::loadParser92()
{
   _actionMap[638][JOIN] = ActionEntry(REDUCE, 342);
   _actionMap[638][ORDER] = ActionEntry(REDUCE, 342);
   _actionMap[638][GROUP] = ActionEntry(REDUCE, 342);
   _actionMap[638][RETURNTOKEN] = ActionEntry(REDUCE, 342);
   _actionMap[638][WHERE] = ActionEntry(REDUCE, 342);
   _actionMap[638][FROM] = ActionEntry(REDUCE, 342);
   _actionMap[638][AS] = ActionEntry(REDUCE, 342);
   _actionMap[638][END_TOKEN] = ActionEntry(REDUCE, 342);
   _actionMap[638][BEGIN] = ActionEntry(REDUCE, 342);
   _actionMap[638][THEN] = ActionEntry(REDUCE, 342);
   _actionMap[638][AND] = ActionEntry(REDUCE, 342);
   _actionMap[638][OR] = ActionEntry(REDUCE, 342);
   _actionMap[638][INTOK] = ActionEntry(REDUCE, 342);
   _actionMap[638][NOT] = ActionEntry(REDUCE, 342);
   _actionMap[638][MT] = ActionEntry(REDUCE, 342);
   _actionMap[638][LT] = ActionEntry(REDUCE, 342);
   _actionMap[638][NEGATION] = ActionEntry(REDUCE, 342);
   _actionMap[638][EQU] = ActionEntry(REDUCE, 342);
   _actionMap[638][BETWEEN] = ActionEntry(REDUCE, 342);
   _actionMap[638][IS] = ActionEntry(REDUCE, 342);
   _actionMap[638][LIKE] = ActionEntry(REDUCE, 342);
   _actionMap[638][RB] = ActionEntry(REDUCE, 342);
   _actionMap[638][ENDTOKEN] = ActionEntry(REDUCE, 342);
   _actionMap[638][UNION] = ActionEntry(REDUCE, 342);
   _actionMap[638][ROWLIMIT] = ActionEntry(REDUCE, 342);
   _actionMap[638][KSEP] = ActionEntry(REDUCE, 342);
   _actionMap[638][ASC] = ActionEntry(REDUCE, 342);
   _actionMap[638][DESC] = ActionEntry(REDUCE, 342);
   _actionMap[638][PLUS] = ActionEntry(REDUCE, 342);
   _actionMap[638][MINUS] = ActionEntry(REDUCE, 342);
   _actionMap[638][DIVISION] = ActionEntry(REDUCE, 342);
   _actionMap[638][STAR] = ActionEntry(REDUCE, 342);
   _actionMap[638][CONCAT] = ActionEntry(REDUCE, 342);
   _actionMap[638][SEMICOLON] = ActionEntry(REDUCE, 342);
   _actionMap[639][WHEN] = ActionEntry(REDUCE, 343);
   _actionMap[639][ELSE] = ActionEntry(REDUCE, 343);
   _actionMap[639][LEFT] = ActionEntry(REDUCE, 343);
   _actionMap[639][RIGHT] = ActionEntry(REDUCE, 343);
   _actionMap[639][INNER] = ActionEntry(REDUCE, 343);
   _actionMap[639][JOIN] = ActionEntry(REDUCE, 343);
   _actionMap[639][ORDER] = ActionEntry(REDUCE, 343);
   _actionMap[639][GROUP] = ActionEntry(REDUCE, 343);
   _actionMap[639][RETURNTOKEN] = ActionEntry(REDUCE, 343);
   _actionMap[639][WHERE] = ActionEntry(REDUCE, 343);
   _actionMap[639][FROM] = ActionEntry(REDUCE, 343);
   _actionMap[639][AS] = ActionEntry(REDUCE, 343);
   _actionMap[639][END_TOKEN] = ActionEntry(REDUCE, 343);
   _actionMap[639][BEGIN] = ActionEntry(REDUCE, 343);
   _actionMap[639][THEN] = ActionEntry(REDUCE, 343);
   _actionMap[639][AND] = ActionEntry(REDUCE, 343);
}
void Cego::loadParser93()
{
   _actionMap[639][OR] = ActionEntry(REDUCE, 343);
   _actionMap[639][INTOK] = ActionEntry(REDUCE, 343);
   _actionMap[639][NOT] = ActionEntry(REDUCE, 343);
   _actionMap[639][MT] = ActionEntry(REDUCE, 343);
   _actionMap[639][LT] = ActionEntry(REDUCE, 343);
   _actionMap[639][NEGATION] = ActionEntry(REDUCE, 343);
   _actionMap[639][EQU] = ActionEntry(REDUCE, 343);
   _actionMap[639][BETWEEN] = ActionEntry(REDUCE, 343);
   _actionMap[639][IS] = ActionEntry(REDUCE, 343);
   _actionMap[639][LIKE] = ActionEntry(REDUCE, 343);
   _actionMap[639][RB] = ActionEntry(REDUCE, 343);
   _actionMap[639][ENDTOKEN] = ActionEntry(REDUCE, 343);
   _actionMap[639][UNION] = ActionEntry(REDUCE, 343);
   _actionMap[639][ROWLIMIT] = ActionEntry(REDUCE, 343);
   _actionMap[639][KSEP] = ActionEntry(REDUCE, 343);
   _actionMap[639][ASC] = ActionEntry(REDUCE, 343);
   _actionMap[639][DESC] = ActionEntry(REDUCE, 343);
   _actionMap[639][PLUS] = ActionEntry(REDUCE, 343);
   _actionMap[639][MINUS] = ActionEntry(REDUCE, 343);
   _actionMap[639][DIVISION] = ActionEntry(REDUCE, 343);
   _actionMap[639][STAR] = ActionEntry(REDUCE, 343);
   _actionMap[639][CONCAT] = ActionEntry(REDUCE, 343);
   _actionMap[639][SEMICOLON] = ActionEntry(REDUCE, 343);
   _actionMap[640][WHEN] = ActionEntry(REDUCE, 333);
   _actionMap[640][ELSE] = ActionEntry(REDUCE, 333);
   _actionMap[640][LEFT] = ActionEntry(REDUCE, 333);
   _actionMap[640][RIGHT] = ActionEntry(REDUCE, 333);
   _actionMap[640][INNER] = ActionEntry(REDUCE, 333);
   _actionMap[640][JOIN] = ActionEntry(REDUCE, 333);
   _actionMap[640][ORDER] = ActionEntry(REDUCE, 333);
   _actionMap[640][GROUP] = ActionEntry(REDUCE, 333);
   _actionMap[640][RETURNTOKEN] = ActionEntry(REDUCE, 333);
   _actionMap[640][WHERE] = ActionEntry(REDUCE, 333);
   _actionMap[640][FROM] = ActionEntry(REDUCE, 333);
   _actionMap[640][AS] = ActionEntry(REDUCE, 333);
   _actionMap[640][END_TOKEN] = ActionEntry(REDUCE, 333);
   _actionMap[640][BEGIN] = ActionEntry(REDUCE, 333);
   _actionMap[640][THEN] = ActionEntry(REDUCE, 333);
   _actionMap[640][AND] = ActionEntry(REDUCE, 333);
   _actionMap[640][OR] = ActionEntry(REDUCE, 333);
   _actionMap[640][INTOK] = ActionEntry(REDUCE, 333);
   _actionMap[640][NOT] = ActionEntry(REDUCE, 333);
   _actionMap[640][MT] = ActionEntry(REDUCE, 333);
   _actionMap[640][LT] = ActionEntry(REDUCE, 333);
   _actionMap[640][NEGATION] = ActionEntry(REDUCE, 333);
   _actionMap[640][EQU] = ActionEntry(REDUCE, 333);
   _actionMap[640][BETWEEN] = ActionEntry(REDUCE, 333);
   _actionMap[640][IS] = ActionEntry(REDUCE, 333);
   _actionMap[640][LIKE] = ActionEntry(REDUCE, 333);
   _actionMap[640][RB] = ActionEntry(REDUCE, 333);
}
void Cego::loadParser94()
{
   _actionMap[640][ENDTOKEN] = ActionEntry(REDUCE, 333);
   _actionMap[640][UNION] = ActionEntry(REDUCE, 333);
   _actionMap[640][ROWLIMIT] = ActionEntry(REDUCE, 333);
   _actionMap[640][KSEP] = ActionEntry(REDUCE, 333);
   _actionMap[640][ASC] = ActionEntry(REDUCE, 333);
   _actionMap[640][DESC] = ActionEntry(REDUCE, 333);
   _actionMap[640][PLUS] = ActionEntry(REDUCE, 333);
   _actionMap[640][MINUS] = ActionEntry(REDUCE, 333);
   _actionMap[640][DIVISION] = ActionEntry(REDUCE, 333);
   _actionMap[640][STAR] = ActionEntry(REDUCE, 333);
   _actionMap[640][CONCAT] = ActionEntry(REDUCE, 333);
   _actionMap[640][SEMICOLON] = ActionEntry(REDUCE, 333);
   _actionMap[641][WHEN] = ActionEntry(REDUCE, 346);
   _actionMap[641][ELSE] = ActionEntry(REDUCE, 346);
   _actionMap[641][LEFT] = ActionEntry(REDUCE, 346);
   _actionMap[641][RIGHT] = ActionEntry(REDUCE, 346);
   _actionMap[641][INNER] = ActionEntry(REDUCE, 346);
   _actionMap[641][JOIN] = ActionEntry(REDUCE, 346);
   _actionMap[641][ORDER] = ActionEntry(REDUCE, 346);
   _actionMap[641][GROUP] = ActionEntry(REDUCE, 346);
   _actionMap[641][RETURNTOKEN] = ActionEntry(REDUCE, 346);
   _actionMap[641][WHERE] = ActionEntry(REDUCE, 346);
   _actionMap[641][FROM] = ActionEntry(REDUCE, 346);
   _actionMap[641][AS] = ActionEntry(REDUCE, 346);
   _actionMap[641][END_TOKEN] = ActionEntry(REDUCE, 346);
   _actionMap[641][BEGIN] = ActionEntry(REDUCE, 346);
   _actionMap[641][THEN] = ActionEntry(REDUCE, 346);
   _actionMap[641][AND] = ActionEntry(REDUCE, 346);
   _actionMap[641][OR] = ActionEntry(REDUCE, 346);
   _actionMap[641][INTOK] = ActionEntry(REDUCE, 346);
   _actionMap[641][NOT] = ActionEntry(REDUCE, 346);
   _actionMap[641][MT] = ActionEntry(REDUCE, 346);
   _actionMap[641][LT] = ActionEntry(REDUCE, 346);
   _actionMap[641][NEGATION] = ActionEntry(REDUCE, 346);
   _actionMap[641][EQU] = ActionEntry(REDUCE, 346);
   _actionMap[641][BETWEEN] = ActionEntry(REDUCE, 346);
   _actionMap[641][IS] = ActionEntry(REDUCE, 346);
   _actionMap[641][LIKE] = ActionEntry(REDUCE, 346);
   _actionMap[641][RB] = ActionEntry(REDUCE, 346);
   _actionMap[641][ENDTOKEN] = ActionEntry(REDUCE, 346);
   _actionMap[641][UNION] = ActionEntry(REDUCE, 346);
   _actionMap[641][ROWLIMIT] = ActionEntry(REDUCE, 346);
   _actionMap[641][KSEP] = ActionEntry(REDUCE, 346);
   _actionMap[641][ASC] = ActionEntry(REDUCE, 346);
   _actionMap[641][DESC] = ActionEntry(REDUCE, 346);
   _actionMap[641][PLUS] = ActionEntry(REDUCE, 346);
   _actionMap[641][MINUS] = ActionEntry(REDUCE, 346);
   _actionMap[641][DIVISION] = ActionEntry(REDUCE, 346);
   _actionMap[641][STAR] = ActionEntry(REDUCE, 346);
   _actionMap[641][CONCAT] = ActionEntry(REDUCE, 346);
}
void Cego::loadParser95()
{
   _actionMap[641][SEMICOLON] = ActionEntry(REDUCE, 346);
   _actionMap[642][WHEN] = ActionEntry(REDUCE, 351);
   _actionMap[642][ELSE] = ActionEntry(REDUCE, 351);
   _actionMap[642][LEFT] = ActionEntry(REDUCE, 351);
   _actionMap[642][RIGHT] = ActionEntry(REDUCE, 351);
   _actionMap[642][INNER] = ActionEntry(REDUCE, 351);
   _actionMap[642][JOIN] = ActionEntry(REDUCE, 351);
   _actionMap[642][ORDER] = ActionEntry(REDUCE, 351);
   _actionMap[642][GROUP] = ActionEntry(REDUCE, 351);
   _actionMap[642][RETURNTOKEN] = ActionEntry(REDUCE, 351);
   _actionMap[642][WHERE] = ActionEntry(REDUCE, 351);
   _actionMap[642][FROM] = ActionEntry(REDUCE, 351);
   _actionMap[642][AS] = ActionEntry(REDUCE, 351);
   _actionMap[642][END_TOKEN] = ActionEntry(REDUCE, 351);
   _actionMap[642][BEGIN] = ActionEntry(REDUCE, 351);
   _actionMap[642][THEN] = ActionEntry(REDUCE, 351);
   _actionMap[642][AND] = ActionEntry(REDUCE, 351);
   _actionMap[642][OR] = ActionEntry(REDUCE, 351);
   _actionMap[642][INTOK] = ActionEntry(REDUCE, 351);
   _actionMap[642][NOT] = ActionEntry(REDUCE, 351);
   _actionMap[642][MT] = ActionEntry(REDUCE, 351);
   _actionMap[642][LT] = ActionEntry(REDUCE, 351);
   _actionMap[642][NEGATION] = ActionEntry(REDUCE, 351);
   _actionMap[642][EQU] = ActionEntry(REDUCE, 351);
   _actionMap[642][BETWEEN] = ActionEntry(REDUCE, 351);
   _actionMap[642][IS] = ActionEntry(REDUCE, 351);
   _actionMap[642][LIKE] = ActionEntry(REDUCE, 351);
   _actionMap[642][RB] = ActionEntry(REDUCE, 351);
   _actionMap[642][ENDTOKEN] = ActionEntry(REDUCE, 351);
   _actionMap[642][UNION] = ActionEntry(REDUCE, 351);
   _actionMap[642][ROWLIMIT] = ActionEntry(REDUCE, 351);
   _actionMap[642][KSEP] = ActionEntry(REDUCE, 351);
   _actionMap[642][ASC] = ActionEntry(REDUCE, 351);
   _actionMap[642][DESC] = ActionEntry(REDUCE, 351);
   _actionMap[642][PLUS] = ActionEntry(REDUCE, 351);
   _actionMap[642][MINUS] = ActionEntry(REDUCE, 351);
   _actionMap[642][DIVISION] = ActionEntry(REDUCE, 351);
   _actionMap[642][STAR] = ActionEntry(REDUCE, 351);
   _actionMap[642][CONCAT] = ActionEntry(REDUCE, 351);
   _actionMap[642][SEMICOLON] = ActionEntry(REDUCE, 351);
   _actionMap[643][WHEN] = ActionEntry(REDUCE, 360);
   _actionMap[643][ELSE] = ActionEntry(REDUCE, 360);
   _actionMap[643][LEFT] = ActionEntry(REDUCE, 360);
   _actionMap[643][RIGHT] = ActionEntry(REDUCE, 360);
   _actionMap[643][INNER] = ActionEntry(REDUCE, 360);
   _actionMap[643][JOIN] = ActionEntry(REDUCE, 360);
   _actionMap[643][ORDER] = ActionEntry(REDUCE, 360);
   _actionMap[643][GROUP] = ActionEntry(REDUCE, 360);
   _actionMap[643][RETURNTOKEN] = ActionEntry(REDUCE, 360);
   _actionMap[643][WHERE] = ActionEntry(REDUCE, 360);
}
void Cego::loadParser96()
{
   _actionMap[643][FROM] = ActionEntry(REDUCE, 360);
   _actionMap[643][AS] = ActionEntry(REDUCE, 360);
   _actionMap[643][END_TOKEN] = ActionEntry(REDUCE, 360);
   _actionMap[643][BEGIN] = ActionEntry(REDUCE, 360);
   _actionMap[643][THEN] = ActionEntry(REDUCE, 360);
   _actionMap[643][AND] = ActionEntry(REDUCE, 360);
   _actionMap[643][OR] = ActionEntry(REDUCE, 360);
   _actionMap[643][INTOK] = ActionEntry(REDUCE, 360);
   _actionMap[643][NOT] = ActionEntry(REDUCE, 360);
   _actionMap[643][MT] = ActionEntry(REDUCE, 360);
   _actionMap[643][LT] = ActionEntry(REDUCE, 360);
   _actionMap[643][NEGATION] = ActionEntry(REDUCE, 360);
   _actionMap[643][EQU] = ActionEntry(REDUCE, 360);
   _actionMap[643][BETWEEN] = ActionEntry(REDUCE, 360);
   _actionMap[643][IS] = ActionEntry(REDUCE, 360);
   _actionMap[643][LIKE] = ActionEntry(REDUCE, 360);
   _actionMap[643][RB] = ActionEntry(REDUCE, 360);
   _actionMap[643][ENDTOKEN] = ActionEntry(REDUCE, 360);
   _actionMap[643][UNION] = ActionEntry(REDUCE, 360);
   _actionMap[643][ROWLIMIT] = ActionEntry(REDUCE, 360);
   _actionMap[643][KSEP] = ActionEntry(REDUCE, 360);
   _actionMap[643][ASC] = ActionEntry(REDUCE, 360);
   _actionMap[643][DESC] = ActionEntry(REDUCE, 360);
   _actionMap[643][PLUS] = ActionEntry(REDUCE, 360);
   _actionMap[643][MINUS] = ActionEntry(REDUCE, 360);
   _actionMap[643][DIVISION] = ActionEntry(REDUCE, 360);
   _actionMap[643][STAR] = ActionEntry(REDUCE, 360);
   _actionMap[643][CONCAT] = ActionEntry(REDUCE, 360);
   _actionMap[643][SEMICOLON] = ActionEntry(REDUCE, 360);
   _actionMap[644][WHEN] = ActionEntry(REDUCE, 359);
   _actionMap[644][ELSE] = ActionEntry(REDUCE, 359);
   _actionMap[644][LEFT] = ActionEntry(REDUCE, 359);
   _actionMap[644][RIGHT] = ActionEntry(REDUCE, 359);
   _actionMap[644][INNER] = ActionEntry(REDUCE, 359);
   _actionMap[644][JOIN] = ActionEntry(REDUCE, 359);
   _actionMap[644][ORDER] = ActionEntry(REDUCE, 359);
   _actionMap[644][GROUP] = ActionEntry(REDUCE, 359);
   _actionMap[644][RETURNTOKEN] = ActionEntry(REDUCE, 359);
   _actionMap[644][WHERE] = ActionEntry(REDUCE, 359);
   _actionMap[644][FROM] = ActionEntry(REDUCE, 359);
   _actionMap[644][AS] = ActionEntry(REDUCE, 359);
   _actionMap[644][END_TOKEN] = ActionEntry(REDUCE, 359);
   _actionMap[644][BEGIN] = ActionEntry(REDUCE, 359);
   _actionMap[644][THEN] = ActionEntry(REDUCE, 359);
   _actionMap[644][AND] = ActionEntry(REDUCE, 359);
   _actionMap[644][OR] = ActionEntry(REDUCE, 359);
   _actionMap[644][INTOK] = ActionEntry(REDUCE, 359);
   _actionMap[644][NOT] = ActionEntry(REDUCE, 359);
   _actionMap[644][MT] = ActionEntry(REDUCE, 359);
   _actionMap[644][LT] = ActionEntry(REDUCE, 359);
}
void Cego::loadParser97()
{
   _actionMap[644][NEGATION] = ActionEntry(REDUCE, 359);
   _actionMap[644][EQU] = ActionEntry(REDUCE, 359);
   _actionMap[644][BETWEEN] = ActionEntry(REDUCE, 359);
   _actionMap[644][IS] = ActionEntry(REDUCE, 359);
   _actionMap[644][LIKE] = ActionEntry(REDUCE, 359);
   _actionMap[644][RB] = ActionEntry(REDUCE, 359);
   _actionMap[644][ENDTOKEN] = ActionEntry(REDUCE, 359);
   _actionMap[644][UNION] = ActionEntry(REDUCE, 359);
   _actionMap[644][ROWLIMIT] = ActionEntry(REDUCE, 359);
   _actionMap[644][KSEP] = ActionEntry(REDUCE, 359);
   _actionMap[644][ASC] = ActionEntry(REDUCE, 359);
   _actionMap[644][DESC] = ActionEntry(REDUCE, 359);
   _actionMap[644][PLUS] = ActionEntry(REDUCE, 359);
   _actionMap[644][MINUS] = ActionEntry(REDUCE, 359);
   _actionMap[644][DIVISION] = ActionEntry(REDUCE, 359);
   _actionMap[644][STAR] = ActionEntry(REDUCE, 359);
   _actionMap[644][CONCAT] = ActionEntry(REDUCE, 359);
   _actionMap[644][SEMICOLON] = ActionEntry(REDUCE, 359);
   _actionMap[645][WHEN] = ActionEntry(REDUCE, 344);
   _actionMap[645][ELSE] = ActionEntry(REDUCE, 344);
   _actionMap[645][LEFT] = ActionEntry(REDUCE, 344);
   _actionMap[645][RIGHT] = ActionEntry(REDUCE, 344);
   _actionMap[645][INNER] = ActionEntry(REDUCE, 344);
   _actionMap[645][JOIN] = ActionEntry(REDUCE, 344);
   _actionMap[645][ORDER] = ActionEntry(REDUCE, 344);
   _actionMap[645][GROUP] = ActionEntry(REDUCE, 344);
   _actionMap[645][RETURNTOKEN] = ActionEntry(REDUCE, 344);
   _actionMap[645][WHERE] = ActionEntry(REDUCE, 344);
   _actionMap[645][FROM] = ActionEntry(REDUCE, 344);
   _actionMap[645][AS] = ActionEntry(REDUCE, 344);
   _actionMap[645][END_TOKEN] = ActionEntry(REDUCE, 344);
   _actionMap[645][BEGIN] = ActionEntry(REDUCE, 344);
   _actionMap[645][THEN] = ActionEntry(REDUCE, 344);
   _actionMap[645][AND] = ActionEntry(REDUCE, 344);
   _actionMap[645][OR] = ActionEntry(REDUCE, 344);
   _actionMap[645][INTOK] = ActionEntry(REDUCE, 344);
   _actionMap[645][NOT] = ActionEntry(REDUCE, 344);
   _actionMap[645][MT] = ActionEntry(REDUCE, 344);
   _actionMap[645][LT] = ActionEntry(REDUCE, 344);
   _actionMap[645][NEGATION] = ActionEntry(REDUCE, 344);
   _actionMap[645][EQU] = ActionEntry(REDUCE, 344);
   _actionMap[645][BETWEEN] = ActionEntry(REDUCE, 344);
   _actionMap[645][IS] = ActionEntry(REDUCE, 344);
   _actionMap[645][LIKE] = ActionEntry(REDUCE, 344);
   _actionMap[645][RB] = ActionEntry(REDUCE, 344);
   _actionMap[645][ENDTOKEN] = ActionEntry(REDUCE, 344);
   _actionMap[645][UNION] = ActionEntry(REDUCE, 344);
   _actionMap[645][ROWLIMIT] = ActionEntry(REDUCE, 344);
   _actionMap[645][KSEP] = ActionEntry(REDUCE, 344);
   _actionMap[645][ASC] = ActionEntry(REDUCE, 344);
}
void Cego::loadParser98()
{
   _actionMap[645][DESC] = ActionEntry(REDUCE, 344);
   _actionMap[645][PLUS] = ActionEntry(REDUCE, 344);
   _actionMap[645][MINUS] = ActionEntry(REDUCE, 344);
   _actionMap[645][DIVISION] = ActionEntry(REDUCE, 344);
   _actionMap[645][STAR] = ActionEntry(REDUCE, 344);
   _actionMap[645][CONCAT] = ActionEntry(REDUCE, 344);
   _actionMap[645][SEMICOLON] = ActionEntry(REDUCE, 344);
   _actionMap[646][WHEN] = ActionEntry(REDUCE, 337);
   _actionMap[646][ELSE] = ActionEntry(REDUCE, 337);
   _actionMap[646][LEFT] = ActionEntry(REDUCE, 337);
   _actionMap[646][RIGHT] = ActionEntry(REDUCE, 337);
   _actionMap[646][INNER] = ActionEntry(REDUCE, 337);
   _actionMap[646][JOIN] = ActionEntry(REDUCE, 337);
   _actionMap[646][ORDER] = ActionEntry(REDUCE, 337);
   _actionMap[646][GROUP] = ActionEntry(REDUCE, 337);
   _actionMap[646][RETURNTOKEN] = ActionEntry(REDUCE, 337);
   _actionMap[646][WHERE] = ActionEntry(REDUCE, 337);
   _actionMap[646][FROM] = ActionEntry(REDUCE, 337);
   _actionMap[646][AS] = ActionEntry(REDUCE, 337);
   _actionMap[646][END_TOKEN] = ActionEntry(REDUCE, 337);
   _actionMap[646][BEGIN] = ActionEntry(REDUCE, 337);
   _actionMap[646][THEN] = ActionEntry(REDUCE, 337);
   _actionMap[646][AND] = ActionEntry(REDUCE, 337);
   _actionMap[646][OR] = ActionEntry(REDUCE, 337);
   _actionMap[646][INTOK] = ActionEntry(REDUCE, 337);
   _actionMap[646][NOT] = ActionEntry(REDUCE, 337);
   _actionMap[646][MT] = ActionEntry(REDUCE, 337);
   _actionMap[646][LT] = ActionEntry(REDUCE, 337);
   _actionMap[646][NEGATION] = ActionEntry(REDUCE, 337);
   _actionMap[646][EQU] = ActionEntry(REDUCE, 337);
   _actionMap[646][BETWEEN] = ActionEntry(REDUCE, 337);
   _actionMap[646][IS] = ActionEntry(REDUCE, 337);
   _actionMap[646][LIKE] = ActionEntry(REDUCE, 337);
   _actionMap[646][RB] = ActionEntry(REDUCE, 337);
   _actionMap[646][ENDTOKEN] = ActionEntry(REDUCE, 337);
   _actionMap[646][UNION] = ActionEntry(REDUCE, 337);
   _actionMap[646][ROWLIMIT] = ActionEntry(REDUCE, 337);
   _actionMap[646][KSEP] = ActionEntry(REDUCE, 337);
   _actionMap[646][ASC] = ActionEntry(REDUCE, 337);
   _actionMap[646][DESC] = ActionEntry(REDUCE, 337);
   _actionMap[646][PLUS] = ActionEntry(REDUCE, 337);
   _actionMap[646][MINUS] = ActionEntry(REDUCE, 337);
   _actionMap[646][DIVISION] = ActionEntry(REDUCE, 337);
   _actionMap[646][STAR] = ActionEntry(REDUCE, 337);
   _actionMap[646][CONCAT] = ActionEntry(REDUCE, 337);
   _actionMap[646][SEMICOLON] = ActionEntry(REDUCE, 337);
   _actionMap[647][WHEN] = ActionEntry(REDUCE, 331);
   _actionMap[647][ELSE] = ActionEntry(REDUCE, 331);
   _actionMap[647][LEFT] = ActionEntry(REDUCE, 331);
   _actionMap[647][RIGHT] = ActionEntry(REDUCE, 331);
}
void Cego::loadParser99()
{
   _actionMap[647][INNER] = ActionEntry(REDUCE, 331);
   _actionMap[647][JOIN] = ActionEntry(REDUCE, 331);
   _actionMap[647][ORDER] = ActionEntry(REDUCE, 331);
   _actionMap[647][GROUP] = ActionEntry(REDUCE, 331);
   _actionMap[647][RETURNTOKEN] = ActionEntry(REDUCE, 331);
   _actionMap[647][WHERE] = ActionEntry(REDUCE, 331);
   _actionMap[647][AS] = ActionEntry(REDUCE, 331);
   _actionMap[647][FROM] = ActionEntry(REDUCE, 331);
   _actionMap[647][END_TOKEN] = ActionEntry(REDUCE, 331);
   _actionMap[647][BEGIN] = ActionEntry(REDUCE, 331);
   _actionMap[647][THEN] = ActionEntry(REDUCE, 331);
   _actionMap[647][OR] = ActionEntry(REDUCE, 331);
   _actionMap[647][AND] = ActionEntry(REDUCE, 331);
   _actionMap[647][LIKE] = ActionEntry(REDUCE, 331);
   _actionMap[647][IS] = ActionEntry(REDUCE, 331);
   _actionMap[647][BETWEEN] = ActionEntry(REDUCE, 331);
   _actionMap[647][EQU] = ActionEntry(REDUCE, 331);
   _actionMap[647][NEGATION] = ActionEntry(REDUCE, 331);
   _actionMap[647][LT] = ActionEntry(REDUCE, 331);
   _actionMap[647][MT] = ActionEntry(REDUCE, 331);
   _actionMap[647][NOT] = ActionEntry(REDUCE, 331);
   _actionMap[647][INTOK] = ActionEntry(REDUCE, 331);
   _actionMap[647][DESC] = ActionEntry(REDUCE, 331);
   _actionMap[647][ASC] = ActionEntry(REDUCE, 331);
   _actionMap[647][KSEP] = ActionEntry(REDUCE, 331);
   _actionMap[647][ROWLIMIT] = ActionEntry(REDUCE, 331);
   _actionMap[647][UNION] = ActionEntry(REDUCE, 331);
   _actionMap[647][ENDTOKEN] = ActionEntry(REDUCE, 331);
   _actionMap[647][RB] = ActionEntry(REDUCE, 331);
   _actionMap[647][CONCAT] = ActionEntry(REDUCE, 331);
   _actionMap[647][STAR] = ActionEntry(REDUCE, 331);
   _actionMap[647][DIVISION] = ActionEntry(REDUCE, 331);
   _actionMap[647][MINUS] = ActionEntry(REDUCE, 331);
   _actionMap[647][PLUS] = ActionEntry(REDUCE, 331);
   _actionMap[647][SEMICOLON] = ActionEntry(REDUCE, 331);
   _actionMap[648][WHEN] = ActionEntry(REDUCE, 332);
   _actionMap[648][ELSE] = ActionEntry(REDUCE, 332);
   _actionMap[648][LEFT] = ActionEntry(REDUCE, 332);
   _actionMap[648][RIGHT] = ActionEntry(REDUCE, 332);
   _actionMap[648][INNER] = ActionEntry(REDUCE, 332);
   _actionMap[648][JOIN] = ActionEntry(REDUCE, 332);
   _actionMap[648][ORDER] = ActionEntry(REDUCE, 332);
   _actionMap[648][GROUP] = ActionEntry(REDUCE, 332);
   _actionMap[648][RETURNTOKEN] = ActionEntry(REDUCE, 332);
   _actionMap[648][WHERE] = ActionEntry(REDUCE, 332);
   _actionMap[648][AS] = ActionEntry(REDUCE, 332);
   _actionMap[648][FROM] = ActionEntry(REDUCE, 332);
   _actionMap[648][END_TOKEN] = ActionEntry(REDUCE, 332);
   _actionMap[648][BEGIN] = ActionEntry(REDUCE, 332);
   _actionMap[648][THEN] = ActionEntry(REDUCE, 332);
}
void Cego::loadParser100()
{
   _actionMap[648][OR] = ActionEntry(REDUCE, 332);
   _actionMap[648][AND] = ActionEntry(REDUCE, 332);
   _actionMap[648][LIKE] = ActionEntry(REDUCE, 332);
   _actionMap[648][IS] = ActionEntry(REDUCE, 332);
   _actionMap[648][BETWEEN] = ActionEntry(REDUCE, 332);
   _actionMap[648][EQU] = ActionEntry(REDUCE, 332);
   _actionMap[648][NEGATION] = ActionEntry(REDUCE, 332);
   _actionMap[648][LT] = ActionEntry(REDUCE, 332);
   _actionMap[648][MT] = ActionEntry(REDUCE, 332);
   _actionMap[648][NOT] = ActionEntry(REDUCE, 332);
   _actionMap[648][INTOK] = ActionEntry(REDUCE, 332);
   _actionMap[648][DESC] = ActionEntry(REDUCE, 332);
   _actionMap[648][ASC] = ActionEntry(REDUCE, 332);
   _actionMap[648][KSEP] = ActionEntry(REDUCE, 332);
   _actionMap[648][ROWLIMIT] = ActionEntry(REDUCE, 332);
   _actionMap[648][UNION] = ActionEntry(REDUCE, 332);
   _actionMap[648][ENDTOKEN] = ActionEntry(REDUCE, 332);
   _actionMap[648][RB] = ActionEntry(REDUCE, 332);
   _actionMap[648][CONCAT] = ActionEntry(REDUCE, 332);
   _actionMap[648][STAR] = ActionEntry(REDUCE, 332);
   _actionMap[648][DIVISION] = ActionEntry(REDUCE, 332);
   _actionMap[648][MINUS] = ActionEntry(REDUCE, 332);
   _actionMap[648][PLUS] = ActionEntry(REDUCE, 332);
   _actionMap[648][SEMICOLON] = ActionEntry(REDUCE, 332);
   _actionMap[649][WHEN] = ActionEntry(REDUCE, 357);
   _actionMap[649][ELSE] = ActionEntry(REDUCE, 357);
   _actionMap[649][LEFT] = ActionEntry(REDUCE, 357);
   _actionMap[649][RIGHT] = ActionEntry(REDUCE, 357);
   _actionMap[649][INNER] = ActionEntry(REDUCE, 357);
   _actionMap[649][JOIN] = ActionEntry(REDUCE, 357);
   _actionMap[649][ORDER] = ActionEntry(REDUCE, 357);
   _actionMap[649][GROUP] = ActionEntry(REDUCE, 357);
   _actionMap[649][RETURNTOKEN] = ActionEntry(REDUCE, 357);
   _actionMap[649][WHERE] = ActionEntry(REDUCE, 357);
   _actionMap[649][FROM] = ActionEntry(REDUCE, 357);
   _actionMap[649][AS] = ActionEntry(REDUCE, 357);
   _actionMap[649][END_TOKEN] = ActionEntry(REDUCE, 357);
   _actionMap[649][BEGIN] = ActionEntry(REDUCE, 357);
   _actionMap[649][THEN] = ActionEntry(REDUCE, 357);
   _actionMap[649][AND] = ActionEntry(REDUCE, 357);
   _actionMap[649][OR] = ActionEntry(REDUCE, 357);
   _actionMap[649][INTOK] = ActionEntry(REDUCE, 357);
   _actionMap[649][NOT] = ActionEntry(REDUCE, 357);
   _actionMap[649][MT] = ActionEntry(REDUCE, 357);
   _actionMap[649][LT] = ActionEntry(REDUCE, 357);
   _actionMap[649][NEGATION] = ActionEntry(REDUCE, 357);
   _actionMap[649][EQU] = ActionEntry(REDUCE, 357);
   _actionMap[649][BETWEEN] = ActionEntry(REDUCE, 357);
   _actionMap[649][IS] = ActionEntry(REDUCE, 357);
   _actionMap[649][LIKE] = ActionEntry(REDUCE, 357);
}
void Cego::loadParser101()
{
   _actionMap[649][RB] = ActionEntry(REDUCE, 357);
   _actionMap[649][ENDTOKEN] = ActionEntry(REDUCE, 357);
   _actionMap[649][UNION] = ActionEntry(REDUCE, 357);
   _actionMap[649][ROWLIMIT] = ActionEntry(REDUCE, 357);
   _actionMap[649][KSEP] = ActionEntry(REDUCE, 357);
   _actionMap[649][ASC] = ActionEntry(REDUCE, 357);
   _actionMap[649][DESC] = ActionEntry(REDUCE, 357);
   _actionMap[649][PLUS] = ActionEntry(REDUCE, 357);
   _actionMap[649][MINUS] = ActionEntry(REDUCE, 357);
   _actionMap[649][DIVISION] = ActionEntry(REDUCE, 357);
   _actionMap[649][STAR] = ActionEntry(REDUCE, 357);
   _actionMap[649][CONCAT] = ActionEntry(REDUCE, 357);
   _actionMap[649][SEMICOLON] = ActionEntry(REDUCE, 357);
   _actionMap[650][WHEN] = ActionEntry(REDUCE, 370);
   _actionMap[650][ELSE] = ActionEntry(REDUCE, 370);
   _actionMap[650][LEFT] = ActionEntry(REDUCE, 370);
   _actionMap[650][RIGHT] = ActionEntry(REDUCE, 370);
   _actionMap[650][INNER] = ActionEntry(REDUCE, 370);
   _actionMap[650][JOIN] = ActionEntry(REDUCE, 370);
   _actionMap[650][ORDER] = ActionEntry(REDUCE, 370);
   _actionMap[650][GROUP] = ActionEntry(REDUCE, 370);
   _actionMap[650][RETURNTOKEN] = ActionEntry(REDUCE, 370);
   _actionMap[650][WHERE] = ActionEntry(REDUCE, 370);
   _actionMap[650][FROM] = ActionEntry(REDUCE, 370);
   _actionMap[650][AS] = ActionEntry(REDUCE, 370);
   _actionMap[650][END_TOKEN] = ActionEntry(REDUCE, 370);
   _actionMap[650][BEGIN] = ActionEntry(REDUCE, 370);
   _actionMap[650][THEN] = ActionEntry(REDUCE, 370);
   _actionMap[650][AND] = ActionEntry(REDUCE, 370);
   _actionMap[650][OR] = ActionEntry(REDUCE, 370);
   _actionMap[650][INTOK] = ActionEntry(REDUCE, 370);
   _actionMap[650][NOT] = ActionEntry(REDUCE, 370);
   _actionMap[650][MT] = ActionEntry(REDUCE, 370);
   _actionMap[650][LT] = ActionEntry(REDUCE, 370);
   _actionMap[650][NEGATION] = ActionEntry(REDUCE, 370);
   _actionMap[650][EQU] = ActionEntry(REDUCE, 370);
   _actionMap[650][BETWEEN] = ActionEntry(REDUCE, 370);
   _actionMap[650][IS] = ActionEntry(REDUCE, 370);
   _actionMap[650][LIKE] = ActionEntry(REDUCE, 370);
   _actionMap[650][RB] = ActionEntry(REDUCE, 370);
   _actionMap[650][ENDTOKEN] = ActionEntry(REDUCE, 370);
   _actionMap[650][UNION] = ActionEntry(REDUCE, 370);
   _actionMap[650][ROWLIMIT] = ActionEntry(REDUCE, 370);
   _actionMap[650][KSEP] = ActionEntry(REDUCE, 370);
   _actionMap[650][ASC] = ActionEntry(REDUCE, 370);
   _actionMap[650][DESC] = ActionEntry(REDUCE, 370);
   _actionMap[650][PLUS] = ActionEntry(REDUCE, 370);
   _actionMap[650][MINUS] = ActionEntry(REDUCE, 370);
   _actionMap[650][DIVISION] = ActionEntry(REDUCE, 370);
   _actionMap[650][STAR] = ActionEntry(REDUCE, 370);
}
void Cego::loadParser102()
{
   _actionMap[650][CONCAT] = ActionEntry(REDUCE, 370);
   _actionMap[650][SEMICOLON] = ActionEntry(REDUCE, 370);
   _actionMap[651][WHEN] = ActionEntry(REDUCE, 361);
   _actionMap[651][ELSE] = ActionEntry(REDUCE, 361);
   _actionMap[651][FROM] = ActionEntry(REDUCE, 361);
   _actionMap[651][AS] = ActionEntry(REDUCE, 361);
   _actionMap[651][END_TOKEN] = ActionEntry(REDUCE, 361);
   _actionMap[651][BEGIN] = ActionEntry(REDUCE, 361);
   _actionMap[651][THEN] = ActionEntry(REDUCE, 361);
   _actionMap[651][LEFT] = ActionEntry(REDUCE, 361);
   _actionMap[651][RIGHT] = ActionEntry(REDUCE, 361);
   _actionMap[651][INNER] = ActionEntry(REDUCE, 361);
   _actionMap[651][JOIN] = ActionEntry(REDUCE, 361);
   _actionMap[651][ORDER] = ActionEntry(REDUCE, 361);
   _actionMap[651][GROUP] = ActionEntry(REDUCE, 361);
   _actionMap[651][RETURNTOKEN] = ActionEntry(REDUCE, 361);
   _actionMap[651][WHERE] = ActionEntry(REDUCE, 361);
   _actionMap[651][AND] = ActionEntry(REDUCE, 361);
   _actionMap[651][OR] = ActionEntry(REDUCE, 361);
   _actionMap[651][INTOK] = ActionEntry(REDUCE, 361);
   _actionMap[651][NOT] = ActionEntry(REDUCE, 361);
   _actionMap[651][MT] = ActionEntry(REDUCE, 361);
   _actionMap[651][LT] = ActionEntry(REDUCE, 361);
   _actionMap[651][NEGATION] = ActionEntry(REDUCE, 361);
   _actionMap[651][EQU] = ActionEntry(REDUCE, 361);
   _actionMap[651][BETWEEN] = ActionEntry(REDUCE, 361);
   _actionMap[651][IS] = ActionEntry(REDUCE, 361);
   _actionMap[651][LIKE] = ActionEntry(REDUCE, 361);
   _actionMap[651][RB] = ActionEntry(REDUCE, 361);
   _actionMap[651][ENDTOKEN] = ActionEntry(REDUCE, 361);
   _actionMap[651][UNION] = ActionEntry(REDUCE, 361);
   _actionMap[651][ROWLIMIT] = ActionEntry(REDUCE, 361);
   _actionMap[651][KSEP] = ActionEntry(REDUCE, 361);
   _actionMap[651][ASC] = ActionEntry(REDUCE, 361);
   _actionMap[651][DESC] = ActionEntry(REDUCE, 361);
   _actionMap[651][PLUS] = ActionEntry(REDUCE, 361);
   _actionMap[651][MINUS] = ActionEntry(REDUCE, 361);
   _actionMap[651][DIVISION] = ActionEntry(REDUCE, 361);
   _actionMap[651][STAR] = ActionEntry(REDUCE, 361);
   _actionMap[651][CONCAT] = ActionEntry(REDUCE, 361);
   _actionMap[651][SEMICOLON] = ActionEntry(REDUCE, 361);
   _actionMap[652][WHEN] = ActionEntry(REDUCE, 355);
   _actionMap[652][ELSE] = ActionEntry(REDUCE, 355);
   _actionMap[652][FROM] = ActionEntry(REDUCE, 355);
   _actionMap[652][AS] = ActionEntry(REDUCE, 355);
   _actionMap[652][END_TOKEN] = ActionEntry(REDUCE, 355);
   _actionMap[652][BEGIN] = ActionEntry(REDUCE, 355);
   _actionMap[652][THEN] = ActionEntry(REDUCE, 355);
   _actionMap[652][LEFT] = ActionEntry(REDUCE, 355);
   _actionMap[652][RIGHT] = ActionEntry(REDUCE, 355);
}
void Cego::loadParser103()
{
   _actionMap[652][INNER] = ActionEntry(REDUCE, 355);
   _actionMap[652][JOIN] = ActionEntry(REDUCE, 355);
   _actionMap[652][ORDER] = ActionEntry(REDUCE, 355);
   _actionMap[652][GROUP] = ActionEntry(REDUCE, 355);
   _actionMap[652][RETURNTOKEN] = ActionEntry(REDUCE, 355);
   _actionMap[652][WHERE] = ActionEntry(REDUCE, 355);
   _actionMap[652][AND] = ActionEntry(REDUCE, 355);
   _actionMap[652][OR] = ActionEntry(REDUCE, 355);
   _actionMap[652][INTOK] = ActionEntry(REDUCE, 355);
   _actionMap[652][NOT] = ActionEntry(REDUCE, 355);
   _actionMap[652][MT] = ActionEntry(REDUCE, 355);
   _actionMap[652][LT] = ActionEntry(REDUCE, 355);
   _actionMap[652][NEGATION] = ActionEntry(REDUCE, 355);
   _actionMap[652][EQU] = ActionEntry(REDUCE, 355);
   _actionMap[652][BETWEEN] = ActionEntry(REDUCE, 355);
   _actionMap[652][IS] = ActionEntry(REDUCE, 355);
   _actionMap[652][LIKE] = ActionEntry(REDUCE, 355);
   _actionMap[652][RB] = ActionEntry(REDUCE, 355);
   _actionMap[652][ENDTOKEN] = ActionEntry(REDUCE, 355);
   _actionMap[652][UNION] = ActionEntry(REDUCE, 355);
   _actionMap[652][ROWLIMIT] = ActionEntry(REDUCE, 355);
   _actionMap[652][KSEP] = ActionEntry(REDUCE, 355);
   _actionMap[652][ASC] = ActionEntry(REDUCE, 355);
   _actionMap[652][DESC] = ActionEntry(REDUCE, 355);
   _actionMap[652][PLUS] = ActionEntry(REDUCE, 355);
   _actionMap[652][MINUS] = ActionEntry(REDUCE, 355);
   _actionMap[652][DIVISION] = ActionEntry(REDUCE, 355);
   _actionMap[652][STAR] = ActionEntry(REDUCE, 355);
   _actionMap[652][CONCAT] = ActionEntry(REDUCE, 355);
   _actionMap[652][SEMICOLON] = ActionEntry(REDUCE, 355);
   _actionMap[653][WHEN] = ActionEntry(REDUCE, 356);
   _actionMap[653][ELSE] = ActionEntry(REDUCE, 356);
   _actionMap[653][FROM] = ActionEntry(REDUCE, 356);
   _actionMap[653][AS] = ActionEntry(REDUCE, 356);
   _actionMap[653][END_TOKEN] = ActionEntry(REDUCE, 356);
   _actionMap[653][BEGIN] = ActionEntry(REDUCE, 356);
   _actionMap[653][THEN] = ActionEntry(REDUCE, 356);
   _actionMap[653][LEFT] = ActionEntry(REDUCE, 356);
   _actionMap[653][RIGHT] = ActionEntry(REDUCE, 356);
   _actionMap[653][INNER] = ActionEntry(REDUCE, 356);
   _actionMap[653][JOIN] = ActionEntry(REDUCE, 356);
   _actionMap[653][ORDER] = ActionEntry(REDUCE, 356);
   _actionMap[653][GROUP] = ActionEntry(REDUCE, 356);
   _actionMap[653][RETURNTOKEN] = ActionEntry(REDUCE, 356);
   _actionMap[653][WHERE] = ActionEntry(REDUCE, 356);
   _actionMap[653][AND] = ActionEntry(REDUCE, 356);
   _actionMap[653][OR] = ActionEntry(REDUCE, 356);
   _actionMap[653][INTOK] = ActionEntry(REDUCE, 356);
   _actionMap[653][NOT] = ActionEntry(REDUCE, 356);
   _actionMap[653][MT] = ActionEntry(REDUCE, 356);
}
void Cego::loadParser104()
{
   _actionMap[653][LT] = ActionEntry(REDUCE, 356);
   _actionMap[653][NEGATION] = ActionEntry(REDUCE, 356);
   _actionMap[653][EQU] = ActionEntry(REDUCE, 356);
   _actionMap[653][BETWEEN] = ActionEntry(REDUCE, 356);
   _actionMap[653][IS] = ActionEntry(REDUCE, 356);
   _actionMap[653][LIKE] = ActionEntry(REDUCE, 356);
   _actionMap[653][RB] = ActionEntry(REDUCE, 356);
   _actionMap[653][ENDTOKEN] = ActionEntry(REDUCE, 356);
   _actionMap[653][UNION] = ActionEntry(REDUCE, 356);
   _actionMap[653][ROWLIMIT] = ActionEntry(REDUCE, 356);
   _actionMap[653][KSEP] = ActionEntry(REDUCE, 356);
   _actionMap[653][ASC] = ActionEntry(REDUCE, 356);
   _actionMap[653][DESC] = ActionEntry(REDUCE, 356);
   _actionMap[653][PLUS] = ActionEntry(REDUCE, 356);
   _actionMap[653][MINUS] = ActionEntry(REDUCE, 356);
   _actionMap[653][DIVISION] = ActionEntry(REDUCE, 356);
   _actionMap[653][STAR] = ActionEntry(REDUCE, 356);
   _actionMap[653][CONCAT] = ActionEntry(REDUCE, 356);
   _actionMap[653][SEMICOLON] = ActionEntry(REDUCE, 356);
   _actionMap[654][WHEN] = ActionEntry(REDUCE, 350);
   _actionMap[654][ELSE] = ActionEntry(REDUCE, 350);
   _actionMap[654][FROM] = ActionEntry(REDUCE, 350);
   _actionMap[654][AS] = ActionEntry(REDUCE, 350);
   _actionMap[654][END_TOKEN] = ActionEntry(REDUCE, 350);
   _actionMap[654][BEGIN] = ActionEntry(REDUCE, 350);
   _actionMap[654][THEN] = ActionEntry(REDUCE, 350);
   _actionMap[654][LEFT] = ActionEntry(REDUCE, 350);
   _actionMap[654][RIGHT] = ActionEntry(REDUCE, 350);
   _actionMap[654][INNER] = ActionEntry(REDUCE, 350);
   _actionMap[654][JOIN] = ActionEntry(REDUCE, 350);
   _actionMap[654][ORDER] = ActionEntry(REDUCE, 350);
   _actionMap[654][GROUP] = ActionEntry(REDUCE, 350);
   _actionMap[654][RETURNTOKEN] = ActionEntry(REDUCE, 350);
   _actionMap[654][WHERE] = ActionEntry(REDUCE, 350);
   _actionMap[654][AND] = ActionEntry(REDUCE, 350);
   _actionMap[654][OR] = ActionEntry(REDUCE, 350);
   _actionMap[654][INTOK] = ActionEntry(REDUCE, 350);
   _actionMap[654][NOT] = ActionEntry(REDUCE, 350);
   _actionMap[654][MT] = ActionEntry(REDUCE, 350);
   _actionMap[654][LT] = ActionEntry(REDUCE, 350);
   _actionMap[654][NEGATION] = ActionEntry(REDUCE, 350);
   _actionMap[654][EQU] = ActionEntry(REDUCE, 350);
   _actionMap[654][BETWEEN] = ActionEntry(REDUCE, 350);
   _actionMap[654][IS] = ActionEntry(REDUCE, 350);
   _actionMap[654][LIKE] = ActionEntry(REDUCE, 350);
   _actionMap[654][RB] = ActionEntry(REDUCE, 350);
   _actionMap[654][ENDTOKEN] = ActionEntry(REDUCE, 350);
   _actionMap[654][UNION] = ActionEntry(REDUCE, 350);
   _actionMap[654][ROWLIMIT] = ActionEntry(REDUCE, 350);
   _actionMap[654][KSEP] = ActionEntry(REDUCE, 350);
}
void Cego::loadParser105()
{
   _actionMap[654][ASC] = ActionEntry(REDUCE, 350);
   _actionMap[654][DESC] = ActionEntry(REDUCE, 350);
   _actionMap[654][PLUS] = ActionEntry(REDUCE, 350);
   _actionMap[654][MINUS] = ActionEntry(REDUCE, 350);
   _actionMap[654][DIVISION] = ActionEntry(REDUCE, 350);
   _actionMap[654][STAR] = ActionEntry(REDUCE, 350);
   _actionMap[654][CONCAT] = ActionEntry(REDUCE, 350);
   _actionMap[654][SEMICOLON] = ActionEntry(REDUCE, 350);
   _actionMap[655][WHEN] = ActionEntry(REDUCE, 347);
   _actionMap[655][ELSE] = ActionEntry(REDUCE, 347);
   _actionMap[655][FROM] = ActionEntry(REDUCE, 347);
   _actionMap[655][AS] = ActionEntry(REDUCE, 347);
   _actionMap[655][END_TOKEN] = ActionEntry(REDUCE, 347);
   _actionMap[655][BEGIN] = ActionEntry(REDUCE, 347);
   _actionMap[655][THEN] = ActionEntry(REDUCE, 347);
   _actionMap[655][LEFT] = ActionEntry(REDUCE, 347);
   _actionMap[655][RIGHT] = ActionEntry(REDUCE, 347);
   _actionMap[655][INNER] = ActionEntry(REDUCE, 347);
   _actionMap[655][JOIN] = ActionEntry(REDUCE, 347);
   _actionMap[655][ORDER] = ActionEntry(REDUCE, 347);
   _actionMap[655][GROUP] = ActionEntry(REDUCE, 347);
   _actionMap[655][RETURNTOKEN] = ActionEntry(REDUCE, 347);
   _actionMap[655][WHERE] = ActionEntry(REDUCE, 347);
   _actionMap[655][AND] = ActionEntry(REDUCE, 347);
   _actionMap[655][OR] = ActionEntry(REDUCE, 347);
   _actionMap[655][INTOK] = ActionEntry(REDUCE, 347);
   _actionMap[655][NOT] = ActionEntry(REDUCE, 347);
   _actionMap[655][MT] = ActionEntry(REDUCE, 347);
   _actionMap[655][LT] = ActionEntry(REDUCE, 347);
   _actionMap[655][NEGATION] = ActionEntry(REDUCE, 347);
   _actionMap[655][EQU] = ActionEntry(REDUCE, 347);
   _actionMap[655][BETWEEN] = ActionEntry(REDUCE, 347);
   _actionMap[655][IS] = ActionEntry(REDUCE, 347);
   _actionMap[655][LIKE] = ActionEntry(REDUCE, 347);
   _actionMap[655][RB] = ActionEntry(REDUCE, 347);
   _actionMap[655][ENDTOKEN] = ActionEntry(REDUCE, 347);
   _actionMap[655][UNION] = ActionEntry(REDUCE, 347);
   _actionMap[655][ROWLIMIT] = ActionEntry(REDUCE, 347);
   _actionMap[655][KSEP] = ActionEntry(REDUCE, 347);
   _actionMap[655][ASC] = ActionEntry(REDUCE, 347);
   _actionMap[655][DESC] = ActionEntry(REDUCE, 347);
   _actionMap[655][PLUS] = ActionEntry(REDUCE, 347);
   _actionMap[655][MINUS] = ActionEntry(REDUCE, 347);
   _actionMap[655][DIVISION] = ActionEntry(REDUCE, 347);
   _actionMap[655][STAR] = ActionEntry(REDUCE, 347);
   _actionMap[655][CONCAT] = ActionEntry(REDUCE, 347);
   _actionMap[655][SEMICOLON] = ActionEntry(REDUCE, 347);
   _actionMap[656][WHEN] = ActionEntry(REDUCE, 338);
   _actionMap[656][ELSE] = ActionEntry(REDUCE, 338);
   _actionMap[656][FROM] = ActionEntry(REDUCE, 338);
}
void Cego::loadParser106()
{
   _actionMap[656][AS] = ActionEntry(REDUCE, 338);
   _actionMap[656][END_TOKEN] = ActionEntry(REDUCE, 338);
   _actionMap[656][BEGIN] = ActionEntry(REDUCE, 338);
   _actionMap[656][THEN] = ActionEntry(REDUCE, 338);
   _actionMap[656][LEFT] = ActionEntry(REDUCE, 338);
   _actionMap[656][RIGHT] = ActionEntry(REDUCE, 338);
   _actionMap[656][INNER] = ActionEntry(REDUCE, 338);
   _actionMap[656][JOIN] = ActionEntry(REDUCE, 338);
   _actionMap[656][ORDER] = ActionEntry(REDUCE, 338);
   _actionMap[656][GROUP] = ActionEntry(REDUCE, 338);
   _actionMap[656][RETURNTOKEN] = ActionEntry(REDUCE, 338);
   _actionMap[656][WHERE] = ActionEntry(REDUCE, 338);
   _actionMap[656][AND] = ActionEntry(REDUCE, 338);
   _actionMap[656][OR] = ActionEntry(REDUCE, 338);
   _actionMap[656][INTOK] = ActionEntry(REDUCE, 338);
   _actionMap[656][NOT] = ActionEntry(REDUCE, 338);
   _actionMap[656][MT] = ActionEntry(REDUCE, 338);
   _actionMap[656][LT] = ActionEntry(REDUCE, 338);
   _actionMap[656][NEGATION] = ActionEntry(REDUCE, 338);
   _actionMap[656][EQU] = ActionEntry(REDUCE, 338);
   _actionMap[656][BETWEEN] = ActionEntry(REDUCE, 338);
   _actionMap[656][IS] = ActionEntry(REDUCE, 338);
   _actionMap[656][LIKE] = ActionEntry(REDUCE, 338);
   _actionMap[656][RB] = ActionEntry(REDUCE, 338);
   _actionMap[656][ENDTOKEN] = ActionEntry(REDUCE, 338);
   _actionMap[656][UNION] = ActionEntry(REDUCE, 338);
   _actionMap[656][ROWLIMIT] = ActionEntry(REDUCE, 338);
   _actionMap[656][KSEP] = ActionEntry(REDUCE, 338);
   _actionMap[656][ASC] = ActionEntry(REDUCE, 338);
   _actionMap[656][DESC] = ActionEntry(REDUCE, 338);
   _actionMap[656][PLUS] = ActionEntry(REDUCE, 338);
   _actionMap[656][MINUS] = ActionEntry(REDUCE, 338);
   _actionMap[656][DIVISION] = ActionEntry(REDUCE, 338);
   _actionMap[656][STAR] = ActionEntry(REDUCE, 338);
   _actionMap[656][CONCAT] = ActionEntry(REDUCE, 338);
   _actionMap[656][SEMICOLON] = ActionEntry(REDUCE, 338);
   _actionMap[657][WHEN] = ActionEntry(REDUCE, 336);
   _actionMap[657][ELSE] = ActionEntry(REDUCE, 336);
   _actionMap[657][FROM] = ActionEntry(REDUCE, 336);
   _actionMap[657][AS] = ActionEntry(REDUCE, 336);
   _actionMap[657][END_TOKEN] = ActionEntry(REDUCE, 336);
   _actionMap[657][BEGIN] = ActionEntry(REDUCE, 336);
   _actionMap[657][THEN] = ActionEntry(REDUCE, 336);
   _actionMap[657][LEFT] = ActionEntry(REDUCE, 336);
   _actionMap[657][RIGHT] = ActionEntry(REDUCE, 336);
   _actionMap[657][INNER] = ActionEntry(REDUCE, 336);
   _actionMap[657][JOIN] = ActionEntry(REDUCE, 336);
   _actionMap[657][ORDER] = ActionEntry(REDUCE, 336);
   _actionMap[657][GROUP] = ActionEntry(REDUCE, 336);
   _actionMap[657][RETURNTOKEN] = ActionEntry(REDUCE, 336);
}
void Cego::loadParser107()
{
   _actionMap[657][WHERE] = ActionEntry(REDUCE, 336);
   _actionMap[657][AND] = ActionEntry(REDUCE, 336);
   _actionMap[657][OR] = ActionEntry(REDUCE, 336);
   _actionMap[657][INTOK] = ActionEntry(REDUCE, 336);
   _actionMap[657][NOT] = ActionEntry(REDUCE, 336);
   _actionMap[657][MT] = ActionEntry(REDUCE, 336);
   _actionMap[657][LT] = ActionEntry(REDUCE, 336);
   _actionMap[657][NEGATION] = ActionEntry(REDUCE, 336);
   _actionMap[657][EQU] = ActionEntry(REDUCE, 336);
   _actionMap[657][BETWEEN] = ActionEntry(REDUCE, 336);
   _actionMap[657][IS] = ActionEntry(REDUCE, 336);
   _actionMap[657][LIKE] = ActionEntry(REDUCE, 336);
   _actionMap[657][RB] = ActionEntry(REDUCE, 336);
   _actionMap[657][ENDTOKEN] = ActionEntry(REDUCE, 336);
   _actionMap[657][UNION] = ActionEntry(REDUCE, 336);
   _actionMap[657][ROWLIMIT] = ActionEntry(REDUCE, 336);
   _actionMap[657][KSEP] = ActionEntry(REDUCE, 336);
   _actionMap[657][ASC] = ActionEntry(REDUCE, 336);
   _actionMap[657][DESC] = ActionEntry(REDUCE, 336);
   _actionMap[657][PLUS] = ActionEntry(REDUCE, 336);
   _actionMap[657][MINUS] = ActionEntry(REDUCE, 336);
   _actionMap[657][DIVISION] = ActionEntry(REDUCE, 336);
   _actionMap[657][STAR] = ActionEntry(REDUCE, 336);
   _actionMap[657][CONCAT] = ActionEntry(REDUCE, 336);
   _actionMap[657][SEMICOLON] = ActionEntry(REDUCE, 336);
   _actionMap[658][WHEN] = ActionEntry(REDUCE, 339);
   _actionMap[658][ELSE] = ActionEntry(REDUCE, 339);
   _actionMap[658][FROM] = ActionEntry(REDUCE, 339);
   _actionMap[658][AS] = ActionEntry(REDUCE, 339);
   _actionMap[658][END_TOKEN] = ActionEntry(REDUCE, 339);
   _actionMap[658][BEGIN] = ActionEntry(REDUCE, 339);
   _actionMap[658][THEN] = ActionEntry(REDUCE, 339);
   _actionMap[658][LEFT] = ActionEntry(REDUCE, 339);
   _actionMap[658][RIGHT] = ActionEntry(REDUCE, 339);
   _actionMap[658][INNER] = ActionEntry(REDUCE, 339);
   _actionMap[658][JOIN] = ActionEntry(REDUCE, 339);
   _actionMap[658][ORDER] = ActionEntry(REDUCE, 339);
   _actionMap[658][GROUP] = ActionEntry(REDUCE, 339);
   _actionMap[658][RETURNTOKEN] = ActionEntry(REDUCE, 339);
   _actionMap[658][WHERE] = ActionEntry(REDUCE, 339);
   _actionMap[658][AND] = ActionEntry(REDUCE, 339);
   _actionMap[658][OR] = ActionEntry(REDUCE, 339);
   _actionMap[658][INTOK] = ActionEntry(REDUCE, 339);
   _actionMap[658][NOT] = ActionEntry(REDUCE, 339);
   _actionMap[658][MT] = ActionEntry(REDUCE, 339);
   _actionMap[658][LT] = ActionEntry(REDUCE, 339);
   _actionMap[658][NEGATION] = ActionEntry(REDUCE, 339);
   _actionMap[658][EQU] = ActionEntry(REDUCE, 339);
   _actionMap[658][BETWEEN] = ActionEntry(REDUCE, 339);
   _actionMap[658][IS] = ActionEntry(REDUCE, 339);
}
void Cego::loadParser108()
{
   _actionMap[658][LIKE] = ActionEntry(REDUCE, 339);
   _actionMap[658][RB] = ActionEntry(REDUCE, 339);
   _actionMap[658][ENDTOKEN] = ActionEntry(REDUCE, 339);
   _actionMap[658][UNION] = ActionEntry(REDUCE, 339);
   _actionMap[658][ROWLIMIT] = ActionEntry(REDUCE, 339);
   _actionMap[658][KSEP] = ActionEntry(REDUCE, 339);
   _actionMap[658][ASC] = ActionEntry(REDUCE, 339);
   _actionMap[658][DESC] = ActionEntry(REDUCE, 339);
   _actionMap[658][PLUS] = ActionEntry(REDUCE, 339);
   _actionMap[658][MINUS] = ActionEntry(REDUCE, 339);
   _actionMap[658][DIVISION] = ActionEntry(REDUCE, 339);
   _actionMap[658][STAR] = ActionEntry(REDUCE, 339);
   _actionMap[658][CONCAT] = ActionEntry(REDUCE, 339);
   _actionMap[658][SEMICOLON] = ActionEntry(REDUCE, 339);
   _actionMap[659][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[659][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[659][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[659][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[659][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[659][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[659][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[659][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[659][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[659][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[659][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[659][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[659][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[659][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[659][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[659][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[659][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[659][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[659][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[659][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[659][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[659][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[659][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[659][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[659][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[659][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[659][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[659][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[659][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[659][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[659][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[659][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[659][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[659][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[659][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[659][BLOBSIZE] = ActionEntry(SHIFT, 130);
}
void Cego::loadParser109()
{
   _actionMap[659][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[659][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[659][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[659][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[659][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[659][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[659][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[659][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[659][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[659][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[659][LB] = ActionEntry(SHIFT, 177);
   _actionMap[659][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[659][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[659][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[659][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[659][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[659][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[659][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[659][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[659][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[659][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[659][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[659][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[659][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[659][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[659][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[659][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[659][ObjSpec] = 122;
   _jumpMap[659][Constant] = 121;
   _jumpMap[659][SignedFloat] = 120;
   _jumpMap[659][SignedInt] = 119;
   _jumpMap[659][Attribute] = 118;
   _jumpMap[659][Function] = 117;
   _jumpMap[659][Factor] = 116;
   _jumpMap[659][Term] = 115;
   _jumpMap[659][Expr] = 771;
   _jumpMap[659][CasePrepare] = 113;
   _jumpMap[659][CaseClause] = 112;
   _actionMap[660][WHEN] = ActionEntry(REDUCE, 349);
   _actionMap[660][ELSE] = ActionEntry(REDUCE, 349);
   _actionMap[660][FROM] = ActionEntry(REDUCE, 349);
   _actionMap[660][AS] = ActionEntry(REDUCE, 349);
   _actionMap[660][END_TOKEN] = ActionEntry(REDUCE, 349);
   _actionMap[660][BEGIN] = ActionEntry(REDUCE, 349);
   _actionMap[660][THEN] = ActionEntry(REDUCE, 349);
   _actionMap[660][LEFT] = ActionEntry(REDUCE, 349);
   _actionMap[660][RIGHT] = ActionEntry(REDUCE, 349);
   _actionMap[660][INNER] = ActionEntry(REDUCE, 349);
   _actionMap[660][JOIN] = ActionEntry(REDUCE, 349);
   _actionMap[660][ORDER] = ActionEntry(REDUCE, 349);
}
void Cego::loadParser110()
{
   _actionMap[660][GROUP] = ActionEntry(REDUCE, 349);
   _actionMap[660][RETURNTOKEN] = ActionEntry(REDUCE, 349);
   _actionMap[660][WHERE] = ActionEntry(REDUCE, 349);
   _actionMap[660][AND] = ActionEntry(REDUCE, 349);
   _actionMap[660][OR] = ActionEntry(REDUCE, 349);
   _actionMap[660][INTOK] = ActionEntry(REDUCE, 349);
   _actionMap[660][NOT] = ActionEntry(REDUCE, 349);
   _actionMap[660][MT] = ActionEntry(REDUCE, 349);
   _actionMap[660][LT] = ActionEntry(REDUCE, 349);
   _actionMap[660][NEGATION] = ActionEntry(REDUCE, 349);
   _actionMap[660][EQU] = ActionEntry(REDUCE, 349);
   _actionMap[660][BETWEEN] = ActionEntry(REDUCE, 349);
   _actionMap[660][IS] = ActionEntry(REDUCE, 349);
   _actionMap[660][LIKE] = ActionEntry(REDUCE, 349);
   _actionMap[660][RB] = ActionEntry(REDUCE, 349);
   _actionMap[660][ENDTOKEN] = ActionEntry(REDUCE, 349);
   _actionMap[660][UNION] = ActionEntry(REDUCE, 349);
   _actionMap[660][ROWLIMIT] = ActionEntry(REDUCE, 349);
   _actionMap[660][KSEP] = ActionEntry(REDUCE, 349);
   _actionMap[660][ASC] = ActionEntry(REDUCE, 349);
   _actionMap[660][DESC] = ActionEntry(REDUCE, 349);
   _actionMap[660][PLUS] = ActionEntry(REDUCE, 349);
   _actionMap[660][MINUS] = ActionEntry(REDUCE, 349);
   _actionMap[660][DIVISION] = ActionEntry(REDUCE, 349);
   _actionMap[660][STAR] = ActionEntry(REDUCE, 349);
   _actionMap[660][CONCAT] = ActionEntry(REDUCE, 349);
   _actionMap[660][SEMICOLON] = ActionEntry(REDUCE, 349);
   _actionMap[661][WHEN] = ActionEntry(REDUCE, 328);
   _actionMap[661][ELSE] = ActionEntry(REDUCE, 328);
   _actionMap[661][AS] = ActionEntry(REDUCE, 328);
   _actionMap[661][FROM] = ActionEntry(REDUCE, 328);
   _actionMap[661][END_TOKEN] = ActionEntry(REDUCE, 328);
   _actionMap[661][BEGIN] = ActionEntry(REDUCE, 328);
   _actionMap[661][THEN] = ActionEntry(REDUCE, 328);
   _actionMap[661][LEFT] = ActionEntry(REDUCE, 328);
   _actionMap[661][RIGHT] = ActionEntry(REDUCE, 328);
   _actionMap[661][INNER] = ActionEntry(REDUCE, 328);
   _actionMap[661][JOIN] = ActionEntry(REDUCE, 328);
   _actionMap[661][ORDER] = ActionEntry(REDUCE, 328);
   _actionMap[661][GROUP] = ActionEntry(REDUCE, 328);
   _actionMap[661][RETURNTOKEN] = ActionEntry(REDUCE, 328);
   _actionMap[661][WHERE] = ActionEntry(REDUCE, 328);
   _actionMap[661][OR] = ActionEntry(REDUCE, 328);
   _actionMap[661][AND] = ActionEntry(REDUCE, 328);
   _actionMap[661][LIKE] = ActionEntry(REDUCE, 328);
   _actionMap[661][IS] = ActionEntry(REDUCE, 328);
   _actionMap[661][BETWEEN] = ActionEntry(REDUCE, 328);
   _actionMap[661][EQU] = ActionEntry(REDUCE, 328);
   _actionMap[661][NEGATION] = ActionEntry(REDUCE, 328);
   _actionMap[661][LT] = ActionEntry(REDUCE, 328);
}
void Cego::loadParser111()
{
   _actionMap[661][MT] = ActionEntry(REDUCE, 328);
   _actionMap[661][NOT] = ActionEntry(REDUCE, 328);
   _actionMap[661][INTOK] = ActionEntry(REDUCE, 328);
   _actionMap[661][DESC] = ActionEntry(REDUCE, 328);
   _actionMap[661][ASC] = ActionEntry(REDUCE, 328);
   _actionMap[661][KSEP] = ActionEntry(REDUCE, 328);
   _actionMap[661][ROWLIMIT] = ActionEntry(REDUCE, 328);
   _actionMap[661][UNION] = ActionEntry(REDUCE, 328);
   _actionMap[661][ENDTOKEN] = ActionEntry(REDUCE, 328);
   _actionMap[661][RB] = ActionEntry(REDUCE, 328);
   _actionMap[661][CONCAT] = ActionEntry(REDUCE, 328);
   _actionMap[661][STAR] = ActionEntry(REDUCE, 328);
   _actionMap[661][DIVISION] = ActionEntry(REDUCE, 328);
   _actionMap[661][MINUS] = ActionEntry(REDUCE, 328);
   _actionMap[661][PLUS] = ActionEntry(REDUCE, 328);
   _actionMap[661][SEMICOLON] = ActionEntry(REDUCE, 328);
   _actionMap[662][WHEN] = ActionEntry(REDUCE, 353);
   _actionMap[662][ELSE] = ActionEntry(REDUCE, 353);
   _actionMap[662][FROM] = ActionEntry(REDUCE, 353);
   _actionMap[662][AS] = ActionEntry(REDUCE, 353);
   _actionMap[662][END_TOKEN] = ActionEntry(REDUCE, 353);
   _actionMap[662][BEGIN] = ActionEntry(REDUCE, 353);
   _actionMap[662][THEN] = ActionEntry(REDUCE, 353);
   _actionMap[662][LEFT] = ActionEntry(REDUCE, 353);
   _actionMap[662][RIGHT] = ActionEntry(REDUCE, 353);
   _actionMap[662][INNER] = ActionEntry(REDUCE, 353);
   _actionMap[662][JOIN] = ActionEntry(REDUCE, 353);
   _actionMap[662][ORDER] = ActionEntry(REDUCE, 353);
   _actionMap[662][GROUP] = ActionEntry(REDUCE, 353);
   _actionMap[662][RETURNTOKEN] = ActionEntry(REDUCE, 353);
   _actionMap[662][WHERE] = ActionEntry(REDUCE, 353);
   _actionMap[662][AND] = ActionEntry(REDUCE, 353);
   _actionMap[662][OR] = ActionEntry(REDUCE, 353);
   _actionMap[662][INTOK] = ActionEntry(REDUCE, 353);
   _actionMap[662][NOT] = ActionEntry(REDUCE, 353);
   _actionMap[662][MT] = ActionEntry(REDUCE, 353);
   _actionMap[662][LT] = ActionEntry(REDUCE, 353);
   _actionMap[662][NEGATION] = ActionEntry(REDUCE, 353);
   _actionMap[662][EQU] = ActionEntry(REDUCE, 353);
   _actionMap[662][BETWEEN] = ActionEntry(REDUCE, 353);
   _actionMap[662][IS] = ActionEntry(REDUCE, 353);
   _actionMap[662][LIKE] = ActionEntry(REDUCE, 353);
   _actionMap[662][RB] = ActionEntry(REDUCE, 353);
   _actionMap[662][ENDTOKEN] = ActionEntry(REDUCE, 353);
   _actionMap[662][UNION] = ActionEntry(REDUCE, 353);
   _actionMap[662][ROWLIMIT] = ActionEntry(REDUCE, 353);
   _actionMap[662][KSEP] = ActionEntry(REDUCE, 353);
   _actionMap[662][ASC] = ActionEntry(REDUCE, 353);
   _actionMap[662][DESC] = ActionEntry(REDUCE, 353);
   _actionMap[662][PLUS] = ActionEntry(REDUCE, 353);
}
void Cego::loadParser112()
{
   _actionMap[662][MINUS] = ActionEntry(REDUCE, 353);
   _actionMap[662][DIVISION] = ActionEntry(REDUCE, 353);
   _actionMap[662][STAR] = ActionEntry(REDUCE, 353);
   _actionMap[662][CONCAT] = ActionEntry(REDUCE, 353);
   _actionMap[662][SEMICOLON] = ActionEntry(REDUCE, 353);
   _actionMap[663][WHEN] = ActionEntry(REDUCE, 354);
   _actionMap[663][ELSE] = ActionEntry(REDUCE, 354);
   _actionMap[663][FROM] = ActionEntry(REDUCE, 354);
   _actionMap[663][AS] = ActionEntry(REDUCE, 354);
   _actionMap[663][END_TOKEN] = ActionEntry(REDUCE, 354);
   _actionMap[663][BEGIN] = ActionEntry(REDUCE, 354);
   _actionMap[663][THEN] = ActionEntry(REDUCE, 354);
   _actionMap[663][LEFT] = ActionEntry(REDUCE, 354);
   _actionMap[663][RIGHT] = ActionEntry(REDUCE, 354);
   _actionMap[663][INNER] = ActionEntry(REDUCE, 354);
   _actionMap[663][JOIN] = ActionEntry(REDUCE, 354);
   _actionMap[663][ORDER] = ActionEntry(REDUCE, 354);
   _actionMap[663][GROUP] = ActionEntry(REDUCE, 354);
   _actionMap[663][RETURNTOKEN] = ActionEntry(REDUCE, 354);
   _actionMap[663][WHERE] = ActionEntry(REDUCE, 354);
   _actionMap[663][AND] = ActionEntry(REDUCE, 354);
   _actionMap[663][OR] = ActionEntry(REDUCE, 354);
   _actionMap[663][INTOK] = ActionEntry(REDUCE, 354);
   _actionMap[663][NOT] = ActionEntry(REDUCE, 354);
   _actionMap[663][MT] = ActionEntry(REDUCE, 354);
   _actionMap[663][LT] = ActionEntry(REDUCE, 354);
   _actionMap[663][NEGATION] = ActionEntry(REDUCE, 354);
   _actionMap[663][EQU] = ActionEntry(REDUCE, 354);
   _actionMap[663][BETWEEN] = ActionEntry(REDUCE, 354);
   _actionMap[663][IS] = ActionEntry(REDUCE, 354);
   _actionMap[663][LIKE] = ActionEntry(REDUCE, 354);
   _actionMap[663][RB] = ActionEntry(REDUCE, 354);
   _actionMap[663][ENDTOKEN] = ActionEntry(REDUCE, 354);
   _actionMap[663][UNION] = ActionEntry(REDUCE, 354);
   _actionMap[663][ROWLIMIT] = ActionEntry(REDUCE, 354);
   _actionMap[663][KSEP] = ActionEntry(REDUCE, 354);
   _actionMap[663][ASC] = ActionEntry(REDUCE, 354);
   _actionMap[663][DESC] = ActionEntry(REDUCE, 354);
   _actionMap[663][PLUS] = ActionEntry(REDUCE, 354);
   _actionMap[663][MINUS] = ActionEntry(REDUCE, 354);
   _actionMap[663][DIVISION] = ActionEntry(REDUCE, 354);
   _actionMap[663][STAR] = ActionEntry(REDUCE, 354);
   _actionMap[663][CONCAT] = ActionEntry(REDUCE, 354);
   _actionMap[663][SEMICOLON] = ActionEntry(REDUCE, 354);
   _actionMap[664][WHEN] = ActionEntry(REDUCE, 335);
   _actionMap[664][ELSE] = ActionEntry(REDUCE, 335);
   _actionMap[664][FROM] = ActionEntry(REDUCE, 335);
   _actionMap[664][AS] = ActionEntry(REDUCE, 335);
   _actionMap[664][END_TOKEN] = ActionEntry(REDUCE, 335);
   _actionMap[664][BEGIN] = ActionEntry(REDUCE, 335);
}
void Cego::loadParser113()
{
   _actionMap[664][THEN] = ActionEntry(REDUCE, 335);
   _actionMap[664][LEFT] = ActionEntry(REDUCE, 335);
   _actionMap[664][RIGHT] = ActionEntry(REDUCE, 335);
   _actionMap[664][INNER] = ActionEntry(REDUCE, 335);
   _actionMap[664][JOIN] = ActionEntry(REDUCE, 335);
   _actionMap[664][ORDER] = ActionEntry(REDUCE, 335);
   _actionMap[664][GROUP] = ActionEntry(REDUCE, 335);
   _actionMap[664][RETURNTOKEN] = ActionEntry(REDUCE, 335);
   _actionMap[664][WHERE] = ActionEntry(REDUCE, 335);
   _actionMap[664][AND] = ActionEntry(REDUCE, 335);
   _actionMap[664][OR] = ActionEntry(REDUCE, 335);
   _actionMap[664][INTOK] = ActionEntry(REDUCE, 335);
   _actionMap[664][NOT] = ActionEntry(REDUCE, 335);
   _actionMap[664][MT] = ActionEntry(REDUCE, 335);
   _actionMap[664][LT] = ActionEntry(REDUCE, 335);
   _actionMap[664][NEGATION] = ActionEntry(REDUCE, 335);
   _actionMap[664][EQU] = ActionEntry(REDUCE, 335);
   _actionMap[664][BETWEEN] = ActionEntry(REDUCE, 335);
   _actionMap[664][IS] = ActionEntry(REDUCE, 335);
   _actionMap[664][LIKE] = ActionEntry(REDUCE, 335);
   _actionMap[664][RB] = ActionEntry(REDUCE, 335);
   _actionMap[664][ENDTOKEN] = ActionEntry(REDUCE, 335);
   _actionMap[664][UNION] = ActionEntry(REDUCE, 335);
   _actionMap[664][ROWLIMIT] = ActionEntry(REDUCE, 335);
   _actionMap[664][KSEP] = ActionEntry(REDUCE, 335);
   _actionMap[664][ASC] = ActionEntry(REDUCE, 335);
   _actionMap[664][DESC] = ActionEntry(REDUCE, 335);
   _actionMap[664][PLUS] = ActionEntry(REDUCE, 335);
   _actionMap[664][MINUS] = ActionEntry(REDUCE, 335);
   _actionMap[664][DIVISION] = ActionEntry(REDUCE, 335);
   _actionMap[664][STAR] = ActionEntry(REDUCE, 335);
   _actionMap[664][CONCAT] = ActionEntry(REDUCE, 335);
   _actionMap[664][SEMICOLON] = ActionEntry(REDUCE, 335);
   _actionMap[665][WHEN] = ActionEntry(REDUCE, 352);
   _actionMap[665][ELSE] = ActionEntry(REDUCE, 352);
   _actionMap[665][FROM] = ActionEntry(REDUCE, 352);
   _actionMap[665][AS] = ActionEntry(REDUCE, 352);
   _actionMap[665][END_TOKEN] = ActionEntry(REDUCE, 352);
   _actionMap[665][BEGIN] = ActionEntry(REDUCE, 352);
   _actionMap[665][THEN] = ActionEntry(REDUCE, 352);
   _actionMap[665][LEFT] = ActionEntry(REDUCE, 352);
   _actionMap[665][RIGHT] = ActionEntry(REDUCE, 352);
   _actionMap[665][INNER] = ActionEntry(REDUCE, 352);
   _actionMap[665][JOIN] = ActionEntry(REDUCE, 352);
   _actionMap[665][ORDER] = ActionEntry(REDUCE, 352);
   _actionMap[665][GROUP] = ActionEntry(REDUCE, 352);
   _actionMap[665][RETURNTOKEN] = ActionEntry(REDUCE, 352);
   _actionMap[665][WHERE] = ActionEntry(REDUCE, 352);
   _actionMap[665][AND] = ActionEntry(REDUCE, 352);
   _actionMap[665][OR] = ActionEntry(REDUCE, 352);
}
void Cego::loadParser114()
{
   _actionMap[665][INTOK] = ActionEntry(REDUCE, 352);
   _actionMap[665][NOT] = ActionEntry(REDUCE, 352);
   _actionMap[665][MT] = ActionEntry(REDUCE, 352);
   _actionMap[665][LT] = ActionEntry(REDUCE, 352);
   _actionMap[665][NEGATION] = ActionEntry(REDUCE, 352);
   _actionMap[665][EQU] = ActionEntry(REDUCE, 352);
   _actionMap[665][BETWEEN] = ActionEntry(REDUCE, 352);
   _actionMap[665][IS] = ActionEntry(REDUCE, 352);
   _actionMap[665][LIKE] = ActionEntry(REDUCE, 352);
   _actionMap[665][RB] = ActionEntry(REDUCE, 352);
   _actionMap[665][ENDTOKEN] = ActionEntry(REDUCE, 352);
   _actionMap[665][UNION] = ActionEntry(REDUCE, 352);
   _actionMap[665][ROWLIMIT] = ActionEntry(REDUCE, 352);
   _actionMap[665][KSEP] = ActionEntry(REDUCE, 352);
   _actionMap[665][ASC] = ActionEntry(REDUCE, 352);
   _actionMap[665][DESC] = ActionEntry(REDUCE, 352);
   _actionMap[665][PLUS] = ActionEntry(REDUCE, 352);
   _actionMap[665][MINUS] = ActionEntry(REDUCE, 352);
   _actionMap[665][DIVISION] = ActionEntry(REDUCE, 352);
   _actionMap[665][STAR] = ActionEntry(REDUCE, 352);
   _actionMap[665][CONCAT] = ActionEntry(REDUCE, 352);
   _actionMap[665][SEMICOLON] = ActionEntry(REDUCE, 352);
   _actionMap[666][WHEN] = ActionEntry(REDUCE, 345);
   _actionMap[666][ELSE] = ActionEntry(REDUCE, 345);
   _actionMap[666][FROM] = ActionEntry(REDUCE, 345);
   _actionMap[666][AS] = ActionEntry(REDUCE, 345);
   _actionMap[666][END_TOKEN] = ActionEntry(REDUCE, 345);
   _actionMap[666][BEGIN] = ActionEntry(REDUCE, 345);
   _actionMap[666][THEN] = ActionEntry(REDUCE, 345);
   _actionMap[666][LEFT] = ActionEntry(REDUCE, 345);
   _actionMap[666][RIGHT] = ActionEntry(REDUCE, 345);
   _actionMap[666][INNER] = ActionEntry(REDUCE, 345);
   _actionMap[666][JOIN] = ActionEntry(REDUCE, 345);
   _actionMap[666][ORDER] = ActionEntry(REDUCE, 345);
   _actionMap[666][GROUP] = ActionEntry(REDUCE, 345);
   _actionMap[666][RETURNTOKEN] = ActionEntry(REDUCE, 345);
   _actionMap[666][WHERE] = ActionEntry(REDUCE, 345);
   _actionMap[666][AND] = ActionEntry(REDUCE, 345);
   _actionMap[666][OR] = ActionEntry(REDUCE, 345);
   _actionMap[666][INTOK] = ActionEntry(REDUCE, 345);
   _actionMap[666][NOT] = ActionEntry(REDUCE, 345);
   _actionMap[666][MT] = ActionEntry(REDUCE, 345);
   _actionMap[666][LT] = ActionEntry(REDUCE, 345);
   _actionMap[666][NEGATION] = ActionEntry(REDUCE, 345);
   _actionMap[666][EQU] = ActionEntry(REDUCE, 345);
   _actionMap[666][BETWEEN] = ActionEntry(REDUCE, 345);
   _actionMap[666][IS] = ActionEntry(REDUCE, 345);
   _actionMap[666][LIKE] = ActionEntry(REDUCE, 345);
   _actionMap[666][RB] = ActionEntry(REDUCE, 345);
   _actionMap[666][ENDTOKEN] = ActionEntry(REDUCE, 345);
}
void Cego::loadParser115()
{
   _actionMap[666][UNION] = ActionEntry(REDUCE, 345);
   _actionMap[666][ROWLIMIT] = ActionEntry(REDUCE, 345);
   _actionMap[666][KSEP] = ActionEntry(REDUCE, 345);
   _actionMap[666][ASC] = ActionEntry(REDUCE, 345);
   _actionMap[666][DESC] = ActionEntry(REDUCE, 345);
   _actionMap[666][PLUS] = ActionEntry(REDUCE, 345);
   _actionMap[666][MINUS] = ActionEntry(REDUCE, 345);
   _actionMap[666][DIVISION] = ActionEntry(REDUCE, 345);
   _actionMap[666][STAR] = ActionEntry(REDUCE, 345);
   _actionMap[666][CONCAT] = ActionEntry(REDUCE, 345);
   _actionMap[666][SEMICOLON] = ActionEntry(REDUCE, 345);
   _actionMap[667][WHEN] = ActionEntry(REDUCE, 407);
   _actionMap[667][ELSE] = ActionEntry(REDUCE, 407);
   _actionMap[667][FROM] = ActionEntry(REDUCE, 407);
   _actionMap[667][AS] = ActionEntry(REDUCE, 407);
   _actionMap[667][END_TOKEN] = ActionEntry(REDUCE, 407);
   _actionMap[667][BEGIN] = ActionEntry(REDUCE, 407);
   _actionMap[667][THEN] = ActionEntry(REDUCE, 407);
   _actionMap[667][LEFT] = ActionEntry(REDUCE, 407);
   _actionMap[667][RIGHT] = ActionEntry(REDUCE, 407);
   _actionMap[667][INNER] = ActionEntry(REDUCE, 407);
   _actionMap[667][JOIN] = ActionEntry(REDUCE, 407);
   _actionMap[667][ORDER] = ActionEntry(REDUCE, 407);
   _actionMap[667][GROUP] = ActionEntry(REDUCE, 407);
   _actionMap[667][RETURNTOKEN] = ActionEntry(REDUCE, 407);
   _actionMap[667][WHERE] = ActionEntry(REDUCE, 407);
   _actionMap[667][AND] = ActionEntry(REDUCE, 407);
   _actionMap[667][OR] = ActionEntry(REDUCE, 407);
   _actionMap[667][INTOK] = ActionEntry(REDUCE, 407);
   _actionMap[667][MT] = ActionEntry(REDUCE, 407);
   _actionMap[667][LT] = ActionEntry(REDUCE, 407);
   _actionMap[667][NEGATION] = ActionEntry(REDUCE, 407);
   _actionMap[667][EQU] = ActionEntry(REDUCE, 407);
   _actionMap[667][BETWEEN] = ActionEntry(REDUCE, 407);
   _actionMap[667][IS] = ActionEntry(REDUCE, 407);
   _actionMap[667][LIKE] = ActionEntry(REDUCE, 407);
   _actionMap[667][ENDTOKEN] = ActionEntry(REDUCE, 407);
   _actionMap[667][UNION] = ActionEntry(REDUCE, 407);
   _actionMap[667][ROWLIMIT] = ActionEntry(REDUCE, 407);
   _actionMap[667][ASC] = ActionEntry(REDUCE, 407);
   _actionMap[667][DESC] = ActionEntry(REDUCE, 407);
   _actionMap[667][PLUS] = ActionEntry(REDUCE, 407);
   _actionMap[667][MINUS] = ActionEntry(REDUCE, 407);
   _actionMap[667][DIVISION] = ActionEntry(REDUCE, 407);
   _actionMap[667][STAR] = ActionEntry(REDUCE, 407);
   _actionMap[667][CONCAT] = ActionEntry(REDUCE, 407);
   _actionMap[667][NULLTOKEN] = ActionEntry(REDUCE, 407);
   _actionMap[667][NOT] = ActionEntry(REDUCE, 407);
   _actionMap[667][KSEP] = ActionEntry(REDUCE, 407);
   _actionMap[667][SEMICOLON] = ActionEntry(REDUCE, 407);
}
void Cego::loadParser116()
{
   _actionMap[667][RB] = ActionEntry(REDUCE, 407);
   _actionMap[668][INTVAL] = ActionEntry(SHIFT, 345);
   _actionMap[669][WHEN] = ActionEntry(REDUCE, 413);
   _actionMap[669][ELSE] = ActionEntry(REDUCE, 413);
   _actionMap[669][FROM] = ActionEntry(REDUCE, 413);
   _actionMap[669][AS] = ActionEntry(REDUCE, 413);
   _actionMap[669][END_TOKEN] = ActionEntry(REDUCE, 413);
   _actionMap[669][BEGIN] = ActionEntry(REDUCE, 413);
   _actionMap[669][THEN] = ActionEntry(REDUCE, 413);
   _actionMap[669][LEFT] = ActionEntry(REDUCE, 413);
   _actionMap[669][RIGHT] = ActionEntry(REDUCE, 413);
   _actionMap[669][INNER] = ActionEntry(REDUCE, 413);
   _actionMap[669][JOIN] = ActionEntry(REDUCE, 413);
   _actionMap[669][ORDER] = ActionEntry(REDUCE, 413);
   _actionMap[669][GROUP] = ActionEntry(REDUCE, 413);
   _actionMap[669][RETURNTOKEN] = ActionEntry(REDUCE, 413);
   _actionMap[669][WHERE] = ActionEntry(REDUCE, 413);
   _actionMap[669][AND] = ActionEntry(REDUCE, 413);
   _actionMap[669][OR] = ActionEntry(REDUCE, 413);
   _actionMap[669][INTOK] = ActionEntry(REDUCE, 413);
   _actionMap[669][MT] = ActionEntry(REDUCE, 413);
   _actionMap[669][LT] = ActionEntry(REDUCE, 413);
   _actionMap[669][NEGATION] = ActionEntry(REDUCE, 413);
   _actionMap[669][EQU] = ActionEntry(REDUCE, 413);
   _actionMap[669][BETWEEN] = ActionEntry(REDUCE, 413);
   _actionMap[669][IS] = ActionEntry(REDUCE, 413);
   _actionMap[669][LIKE] = ActionEntry(REDUCE, 413);
   _actionMap[669][ENDTOKEN] = ActionEntry(REDUCE, 413);
   _actionMap[669][UNION] = ActionEntry(REDUCE, 413);
   _actionMap[669][ROWLIMIT] = ActionEntry(REDUCE, 413);
   _actionMap[669][ASC] = ActionEntry(REDUCE, 413);
   _actionMap[669][DESC] = ActionEntry(REDUCE, 413);
   _actionMap[669][PLUS] = ActionEntry(REDUCE, 413);
   _actionMap[669][MINUS] = ActionEntry(REDUCE, 413);
   _actionMap[669][DIVISION] = ActionEntry(REDUCE, 413);
   _actionMap[669][STAR] = ActionEntry(REDUCE, 413);
   _actionMap[669][CONCAT] = ActionEntry(REDUCE, 413);
   _actionMap[669][NULLTOKEN] = ActionEntry(REDUCE, 413);
   _actionMap[669][NOT] = ActionEntry(REDUCE, 413);
   _actionMap[669][KSEP] = ActionEntry(REDUCE, 413);
   _actionMap[669][SEMICOLON] = ActionEntry(REDUCE, 413);
   _actionMap[669][RB] = ActionEntry(REDUCE, 413);
   _actionMap[670][FLOATVAL] = ActionEntry(SHIFT, 346);
   _actionMap[671][WHEN] = ActionEntry(REDUCE, 412);
   _actionMap[671][ELSE] = ActionEntry(REDUCE, 412);
   _actionMap[671][FROM] = ActionEntry(REDUCE, 412);
   _actionMap[671][AS] = ActionEntry(REDUCE, 412);
   _actionMap[671][END_TOKEN] = ActionEntry(REDUCE, 412);
   _actionMap[671][BEGIN] = ActionEntry(REDUCE, 412);
   _actionMap[671][THEN] = ActionEntry(REDUCE, 412);
}
void Cego::loadParser117()
{
   _actionMap[671][LEFT] = ActionEntry(REDUCE, 412);
   _actionMap[671][RIGHT] = ActionEntry(REDUCE, 412);
   _actionMap[671][INNER] = ActionEntry(REDUCE, 412);
   _actionMap[671][JOIN] = ActionEntry(REDUCE, 412);
   _actionMap[671][ORDER] = ActionEntry(REDUCE, 412);
   _actionMap[671][GROUP] = ActionEntry(REDUCE, 412);
   _actionMap[671][RETURNTOKEN] = ActionEntry(REDUCE, 412);
   _actionMap[671][WHERE] = ActionEntry(REDUCE, 412);
   _actionMap[671][AND] = ActionEntry(REDUCE, 412);
   _actionMap[671][OR] = ActionEntry(REDUCE, 412);
   _actionMap[671][INTOK] = ActionEntry(REDUCE, 412);
   _actionMap[671][MT] = ActionEntry(REDUCE, 412);
   _actionMap[671][LT] = ActionEntry(REDUCE, 412);
   _actionMap[671][NEGATION] = ActionEntry(REDUCE, 412);
   _actionMap[671][EQU] = ActionEntry(REDUCE, 412);
   _actionMap[671][BETWEEN] = ActionEntry(REDUCE, 412);
   _actionMap[671][IS] = ActionEntry(REDUCE, 412);
   _actionMap[671][LIKE] = ActionEntry(REDUCE, 412);
   _actionMap[671][ENDTOKEN] = ActionEntry(REDUCE, 412);
   _actionMap[671][UNION] = ActionEntry(REDUCE, 412);
   _actionMap[671][ROWLIMIT] = ActionEntry(REDUCE, 412);
   _actionMap[671][ASC] = ActionEntry(REDUCE, 412);
   _actionMap[671][DESC] = ActionEntry(REDUCE, 412);
   _actionMap[671][PLUS] = ActionEntry(REDUCE, 412);
   _actionMap[671][MINUS] = ActionEntry(REDUCE, 412);
   _actionMap[671][DIVISION] = ActionEntry(REDUCE, 412);
   _actionMap[671][STAR] = ActionEntry(REDUCE, 412);
   _actionMap[671][CONCAT] = ActionEntry(REDUCE, 412);
   _actionMap[671][NULLTOKEN] = ActionEntry(REDUCE, 412);
   _actionMap[671][NOT] = ActionEntry(REDUCE, 412);
   _actionMap[671][KSEP] = ActionEntry(REDUCE, 412);
   _actionMap[671][SEMICOLON] = ActionEntry(REDUCE, 412);
   _actionMap[671][RB] = ActionEntry(REDUCE, 412);
   _actionMap[672][WHEN] = ActionEntry(REDUCE, 406);
   _actionMap[672][ELSE] = ActionEntry(REDUCE, 406);
   _actionMap[672][FROM] = ActionEntry(REDUCE, 406);
   _actionMap[672][AS] = ActionEntry(REDUCE, 406);
   _actionMap[672][END_TOKEN] = ActionEntry(REDUCE, 406);
   _actionMap[672][BEGIN] = ActionEntry(REDUCE, 406);
   _actionMap[672][THEN] = ActionEntry(REDUCE, 406);
   _actionMap[672][LEFT] = ActionEntry(REDUCE, 406);
   _actionMap[672][RIGHT] = ActionEntry(REDUCE, 406);
   _actionMap[672][INNER] = ActionEntry(REDUCE, 406);
   _actionMap[672][JOIN] = ActionEntry(REDUCE, 406);
   _actionMap[672][ORDER] = ActionEntry(REDUCE, 406);
   _actionMap[672][GROUP] = ActionEntry(REDUCE, 406);
   _actionMap[672][RETURNTOKEN] = ActionEntry(REDUCE, 406);
   _actionMap[672][WHERE] = ActionEntry(REDUCE, 406);
   _actionMap[672][AND] = ActionEntry(REDUCE, 406);
   _actionMap[672][OR] = ActionEntry(REDUCE, 406);
}
void Cego::loadParser118()
{
   _actionMap[672][INTOK] = ActionEntry(REDUCE, 406);
   _actionMap[672][MT] = ActionEntry(REDUCE, 406);
   _actionMap[672][LT] = ActionEntry(REDUCE, 406);
   _actionMap[672][NEGATION] = ActionEntry(REDUCE, 406);
   _actionMap[672][EQU] = ActionEntry(REDUCE, 406);
   _actionMap[672][BETWEEN] = ActionEntry(REDUCE, 406);
   _actionMap[672][IS] = ActionEntry(REDUCE, 406);
   _actionMap[672][LIKE] = ActionEntry(REDUCE, 406);
   _actionMap[672][ENDTOKEN] = ActionEntry(REDUCE, 406);
   _actionMap[672][UNION] = ActionEntry(REDUCE, 406);
   _actionMap[672][ROWLIMIT] = ActionEntry(REDUCE, 406);
   _actionMap[672][ASC] = ActionEntry(REDUCE, 406);
   _actionMap[672][DESC] = ActionEntry(REDUCE, 406);
   _actionMap[672][PLUS] = ActionEntry(REDUCE, 406);
   _actionMap[672][MINUS] = ActionEntry(REDUCE, 406);
   _actionMap[672][DIVISION] = ActionEntry(REDUCE, 406);
   _actionMap[672][STAR] = ActionEntry(REDUCE, 406);
   _actionMap[672][CONCAT] = ActionEntry(REDUCE, 406);
   _actionMap[672][NULLTOKEN] = ActionEntry(REDUCE, 406);
   _actionMap[672][NOT] = ActionEntry(REDUCE, 406);
   _actionMap[672][KSEP] = ActionEntry(REDUCE, 406);
   _actionMap[672][SEMICOLON] = ActionEntry(REDUCE, 406);
   _actionMap[672][RB] = ActionEntry(REDUCE, 406);
   _actionMap[673][WHEN] = ActionEntry(REDUCE, 408);
   _actionMap[673][ELSE] = ActionEntry(REDUCE, 408);
   _actionMap[673][FROM] = ActionEntry(REDUCE, 408);
   _actionMap[673][AS] = ActionEntry(REDUCE, 408);
   _actionMap[673][END_TOKEN] = ActionEntry(REDUCE, 408);
   _actionMap[673][BEGIN] = ActionEntry(REDUCE, 408);
   _actionMap[673][THEN] = ActionEntry(REDUCE, 408);
   _actionMap[673][LEFT] = ActionEntry(REDUCE, 408);
   _actionMap[673][RIGHT] = ActionEntry(REDUCE, 408);
   _actionMap[673][INNER] = ActionEntry(REDUCE, 408);
   _actionMap[673][JOIN] = ActionEntry(REDUCE, 408);
   _actionMap[673][ORDER] = ActionEntry(REDUCE, 408);
   _actionMap[673][GROUP] = ActionEntry(REDUCE, 408);
   _actionMap[673][RETURNTOKEN] = ActionEntry(REDUCE, 408);
   _actionMap[673][WHERE] = ActionEntry(REDUCE, 408);
   _actionMap[673][AND] = ActionEntry(REDUCE, 408);
   _actionMap[673][OR] = ActionEntry(REDUCE, 408);
   _actionMap[673][INTOK] = ActionEntry(REDUCE, 408);
   _actionMap[673][MT] = ActionEntry(REDUCE, 408);
   _actionMap[673][LT] = ActionEntry(REDUCE, 408);
   _actionMap[673][NEGATION] = ActionEntry(REDUCE, 408);
   _actionMap[673][EQU] = ActionEntry(REDUCE, 408);
   _actionMap[673][BETWEEN] = ActionEntry(REDUCE, 408);
   _actionMap[673][IS] = ActionEntry(REDUCE, 408);
   _actionMap[673][LIKE] = ActionEntry(REDUCE, 408);
   _actionMap[673][ENDTOKEN] = ActionEntry(REDUCE, 408);
   _actionMap[673][UNION] = ActionEntry(REDUCE, 408);
}
void Cego::loadParser119()
{
   _actionMap[673][ROWLIMIT] = ActionEntry(REDUCE, 408);
   _actionMap[673][ASC] = ActionEntry(REDUCE, 408);
   _actionMap[673][DESC] = ActionEntry(REDUCE, 408);
   _actionMap[673][PLUS] = ActionEntry(REDUCE, 408);
   _actionMap[673][MINUS] = ActionEntry(REDUCE, 408);
   _actionMap[673][DIVISION] = ActionEntry(REDUCE, 408);
   _actionMap[673][STAR] = ActionEntry(REDUCE, 408);
   _actionMap[673][CONCAT] = ActionEntry(REDUCE, 408);
   _actionMap[673][NULLTOKEN] = ActionEntry(REDUCE, 408);
   _actionMap[673][NOT] = ActionEntry(REDUCE, 408);
   _actionMap[673][KSEP] = ActionEntry(REDUCE, 408);
   _actionMap[673][SEMICOLON] = ActionEntry(REDUCE, 408);
   _actionMap[673][RB] = ActionEntry(REDUCE, 408);
   _actionMap[674][WHEN] = ActionEntry(REDUCE, 409);
   _actionMap[674][ELSE] = ActionEntry(REDUCE, 409);
   _actionMap[674][FROM] = ActionEntry(REDUCE, 409);
   _actionMap[674][AS] = ActionEntry(REDUCE, 409);
   _actionMap[674][END_TOKEN] = ActionEntry(REDUCE, 409);
   _actionMap[674][BEGIN] = ActionEntry(REDUCE, 409);
   _actionMap[674][THEN] = ActionEntry(REDUCE, 409);
   _actionMap[674][LEFT] = ActionEntry(REDUCE, 409);
   _actionMap[674][RIGHT] = ActionEntry(REDUCE, 409);
   _actionMap[674][INNER] = ActionEntry(REDUCE, 409);
   _actionMap[674][JOIN] = ActionEntry(REDUCE, 409);
   _actionMap[674][ORDER] = ActionEntry(REDUCE, 409);
   _actionMap[674][GROUP] = ActionEntry(REDUCE, 409);
   _actionMap[674][RETURNTOKEN] = ActionEntry(REDUCE, 409);
   _actionMap[674][WHERE] = ActionEntry(REDUCE, 409);
   _actionMap[674][AND] = ActionEntry(REDUCE, 409);
   _actionMap[674][OR] = ActionEntry(REDUCE, 409);
   _actionMap[674][INTOK] = ActionEntry(REDUCE, 409);
   _actionMap[674][MT] = ActionEntry(REDUCE, 409);
   _actionMap[674][LT] = ActionEntry(REDUCE, 409);
   _actionMap[674][NEGATION] = ActionEntry(REDUCE, 409);
   _actionMap[674][EQU] = ActionEntry(REDUCE, 409);
   _actionMap[674][BETWEEN] = ActionEntry(REDUCE, 409);
   _actionMap[674][IS] = ActionEntry(REDUCE, 409);
   _actionMap[674][LIKE] = ActionEntry(REDUCE, 409);
   _actionMap[674][ENDTOKEN] = ActionEntry(REDUCE, 409);
   _actionMap[674][UNION] = ActionEntry(REDUCE, 409);
   _actionMap[674][ROWLIMIT] = ActionEntry(REDUCE, 409);
   _actionMap[674][ASC] = ActionEntry(REDUCE, 409);
   _actionMap[674][DESC] = ActionEntry(REDUCE, 409);
   _actionMap[674][PLUS] = ActionEntry(REDUCE, 409);
   _actionMap[674][MINUS] = ActionEntry(REDUCE, 409);
   _actionMap[674][DIVISION] = ActionEntry(REDUCE, 409);
   _actionMap[674][STAR] = ActionEntry(REDUCE, 409);
   _actionMap[674][CONCAT] = ActionEntry(REDUCE, 409);
   _actionMap[674][NULLTOKEN] = ActionEntry(REDUCE, 409);
   _actionMap[674][NOT] = ActionEntry(REDUCE, 409);
}
void Cego::loadParser120()
{
   _actionMap[674][KSEP] = ActionEntry(REDUCE, 409);
   _actionMap[674][SEMICOLON] = ActionEntry(REDUCE, 409);
   _actionMap[674][RB] = ActionEntry(REDUCE, 409);
   _actionMap[675][SEMICOLON] = ActionEntry(REDUCE, 235);
   _actionMap[676][SEMICOLON] = ActionEntry(REDUCE, 234);
   _actionMap[677][SEMICOLON] = ActionEntry(REDUCE, 239);
   _actionMap[678][SEMICOLON] = ActionEntry(REDUCE, 236);
   _actionMap[679][SEMICOLON] = ActionEntry(REDUCE, 237);
   _actionMap[680][SEMICOLON] = ActionEntry(REDUCE, 233);
   _actionMap[681][SEMICOLON] = ActionEntry(REDUCE, 240);
   _actionMap[682][SEMICOLON] = ActionEntry(REDUCE, 238);
   _actionMap[683][SEMICOLON] = ActionEntry(REDUCE, 199);
   _actionMap[683][RB] = ActionEntry(REDUCE, 199);
   _actionMap[683][ENDTOKEN] = ActionEntry(REDUCE, 199);
   _actionMap[683][UNION] = ActionEntry(REDUCE, 199);
   _actionMap[683][ROWLIMIT] = ActionEntry(REDUCE, 199);
   _actionMap[683][ORDER] = ActionEntry(REDUCE, 199);
   _actionMap[683][GROUP] = ActionEntry(SHIFT, 774);
   _jumpMap[683][NoGroup] = 773;
   _jumpMap[683][GroupClause] = 772;
   _actionMap[684][LEFT] = ActionEntry(REDUCE, 179);
   _actionMap[684][RIGHT] = ActionEntry(REDUCE, 179);
   _actionMap[684][INNER] = ActionEntry(REDUCE, 179);
   _actionMap[684][JOIN] = ActionEntry(REDUCE, 179);
   _actionMap[684][RB] = ActionEntry(REDUCE, 179);
   _actionMap[684][ENDTOKEN] = ActionEntry(REDUCE, 179);
   _actionMap[684][UNION] = ActionEntry(REDUCE, 179);
   _actionMap[684][ROWLIMIT] = ActionEntry(REDUCE, 179);
   _actionMap[684][ORDER] = ActionEntry(REDUCE, 179);
   _actionMap[684][GROUP] = ActionEntry(REDUCE, 179);
   _actionMap[684][SEMICOLON] = ActionEntry(REDUCE, 179);
   _actionMap[684][RETURNTOKEN] = ActionEntry(REDUCE, 179);
   _actionMap[684][WHERE] = ActionEntry(REDUCE, 179);
   _actionMap[685][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[685][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[685][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[685][ObjSpec] = 535;
   _jumpMap[685][JoinTable] = 776;
   _jumpMap[685][Table] = 775;
   _actionMap[686][JOIN] = ActionEntry(SHIFT, 777);
   _actionMap[687][IDENTIFIER] = ActionEntry(REDUCE, 188);
   _actionMap[687][QUALIFIEDOBJ] = ActionEntry(REDUCE, 188);
   _actionMap[687][QUALIFIEDTS] = ActionEntry(REDUCE, 188);
   _actionMap[688][OUTER] = ActionEntry(SHIFT, 778);
   _actionMap[689][OUTER] = ActionEntry(SHIFT, 779);
   _actionMap[690][LEFT] = ActionEntry(REDUCE, 180);
   _actionMap[690][RIGHT] = ActionEntry(REDUCE, 180);
   _actionMap[690][INNER] = ActionEntry(REDUCE, 180);
   _actionMap[690][JOIN] = ActionEntry(REDUCE, 180);
   _actionMap[690][RB] = ActionEntry(REDUCE, 180);
}
void Cego::loadParser121()
{
   _actionMap[690][ENDTOKEN] = ActionEntry(REDUCE, 180);
   _actionMap[690][UNION] = ActionEntry(REDUCE, 180);
   _actionMap[690][ROWLIMIT] = ActionEntry(REDUCE, 180);
   _actionMap[690][ORDER] = ActionEntry(REDUCE, 180);
   _actionMap[690][GROUP] = ActionEntry(REDUCE, 180);
   _actionMap[690][SEMICOLON] = ActionEntry(REDUCE, 180);
   _actionMap[690][RETURNTOKEN] = ActionEntry(REDUCE, 180);
   _actionMap[690][WHERE] = ActionEntry(REDUCE, 180);
   _actionMap[691][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[691][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[691][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[691][ObjSpec] = 535;
   _jumpMap[691][Table] = 781;
   _jumpMap[691][TableList] = 780;
   _actionMap[692][KSEP] = ActionEntry(REDUCE, 192);
   _actionMap[692][LEFT] = ActionEntry(REDUCE, 192);
   _actionMap[692][RIGHT] = ActionEntry(REDUCE, 192);
   _actionMap[692][INNER] = ActionEntry(REDUCE, 192);
   _actionMap[692][JOIN] = ActionEntry(REDUCE, 192);
   _actionMap[692][RB] = ActionEntry(REDUCE, 192);
   _actionMap[692][ENDTOKEN] = ActionEntry(REDUCE, 192);
   _actionMap[692][UNION] = ActionEntry(REDUCE, 192);
   _actionMap[692][ROWLIMIT] = ActionEntry(REDUCE, 192);
   _actionMap[692][ORDER] = ActionEntry(REDUCE, 192);
   _actionMap[692][GROUP] = ActionEntry(REDUCE, 192);
   _actionMap[692][SEMICOLON] = ActionEntry(REDUCE, 192);
   _actionMap[692][RETURNTOKEN] = ActionEntry(REDUCE, 192);
   _actionMap[692][WHERE] = ActionEntry(REDUCE, 192);
   _actionMap[692][ON] = ActionEntry(REDUCE, 192);
   _actionMap[693][FROM] = ActionEntry(REDUCE, 174);
   _actionMap[693][RB] = ActionEntry(REDUCE, 174);
   _actionMap[693][SEMICOLON] = ActionEntry(REDUCE, 174);
   _actionMap[693][ENDTOKEN] = ActionEntry(REDUCE, 174);
   _actionMap[693][KSEP] = ActionEntry(REDUCE, 174);
   _actionMap[694][KSEP] = ActionEntry(REDUCE, 194);
   _actionMap[694][FROM] = ActionEntry(REDUCE, 194);
   _actionMap[694][RB] = ActionEntry(REDUCE, 194);
   _actionMap[694][SEMICOLON] = ActionEntry(REDUCE, 194);
   _actionMap[694][ENDTOKEN] = ActionEntry(REDUCE, 194);
   _actionMap[695][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[695][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[695][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[695][SEMICOLON] = ActionEntry(REDUCE, 95);
   _actionMap[696][SEMICOLON] = ActionEntry(REDUCE, 161);
   _actionMap[696][RETURNTOKEN] = ActionEntry(SHIFT, 784);
   _jumpMap[696][NoUpdateReturnOpt] = 783;
   _jumpMap[696][UpdReturnOpt] = 782;
   _actionMap[697][IDENTIFIER] = ActionEntry(SHIFT, 544);
   _jumpMap[697][Assignment] = 785;
   _actionMap[698][FLOATVAL] = ActionEntry(SHIFT, 180);
}
void Cego::loadParser122()
{
   _actionMap[698][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[698][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[698][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[698][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[698][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[698][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[698][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[698][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[698][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[698][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[698][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[698][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[698][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[698][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[698][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[698][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[698][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[698][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[698][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[698][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[698][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[698][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[698][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[698][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[698][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[698][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[698][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[698][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[698][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[698][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[698][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[698][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[698][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[698][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[698][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[698][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[698][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[698][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[698][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[698][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[698][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[698][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[698][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[698][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[698][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[698][LB] = ActionEntry(SHIFT, 177);
   _actionMap[698][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[698][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[698][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[698][TRUEVAL] = ActionEntry(SHIFT, 174);
}
void Cego::loadParser123()
{
   _actionMap[698][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[698][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[698][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[698][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[698][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[698][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[698][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[698][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[698][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[698][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[698][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[698][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[698][ObjSpec] = 122;
   _jumpMap[698][Constant] = 121;
   _jumpMap[698][SignedFloat] = 120;
   _jumpMap[698][SignedInt] = 119;
   _jumpMap[698][Attribute] = 118;
   _jumpMap[698][Function] = 117;
   _jumpMap[698][Factor] = 116;
   _jumpMap[698][Term] = 115;
   _jumpMap[698][Expr] = 786;
   _jumpMap[698][CasePrepare] = 113;
   _jumpMap[698][CaseClause] = 112;
   _actionMap[699][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[699][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[699][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[699][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[699][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[699][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[699][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[699][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[699][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[699][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[699][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[699][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[699][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[699][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[699][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[699][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[699][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[699][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[699][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[699][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[699][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[699][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[699][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[699][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[699][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[699][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[699][RANDINT] = ActionEntry(SHIFT, 161);
}
void Cego::loadParser124()
{
   _actionMap[699][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[699][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[699][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[699][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[699][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[699][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[699][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[699][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[699][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[699][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[699][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[699][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[699][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[699][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[699][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[699][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[699][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[699][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[699][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[699][LB] = ActionEntry(SHIFT, 177);
   _actionMap[699][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[699][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[699][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[699][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[699][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[699][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[699][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[699][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[699][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[699][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[699][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[699][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[699][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[699][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[699][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[699][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[699][RB] = ActionEntry(REDUCE, 280);
   _jumpMap[699][ObjSpec] = 122;
   _jumpMap[699][Constant] = 121;
   _jumpMap[699][SignedFloat] = 120;
   _jumpMap[699][SignedInt] = 119;
   _jumpMap[699][Attribute] = 118;
   _jumpMap[699][Function] = 117;
   _jumpMap[699][Factor] = 116;
   _jumpMap[699][Term] = 115;
   _jumpMap[699][Expr] = 393;
   _jumpMap[699][ProcValueList] = 392;
   _jumpMap[699][ProcValueListOpt] = 787;
   _jumpMap[699][CasePrepare] = 113;
   _jumpMap[699][CaseClause] = 112;
}
void Cego::loadParser125()
{
   _actionMap[383][SEMICOLON] = ActionEntry(REDUCE, 81);
   _actionMap[384][SEMICOLON] = ActionEntry(REDUCE, 225);
   _actionMap[385][KSEP] = ActionEntry(SHIFT, 546);
   _actionMap[385][SEMICOLON] = ActionEntry(REDUCE, 227);
   _actionMap[386][CHECK] = ActionEntry(SHIFT, 547);
   _actionMap[386][FOREIGN] = ActionEntry(SHIFT, 549);
   _actionMap[386][COLUMN] = ActionEntry(SHIFT, 548);
   _actionMap[387][COLUMN] = ActionEntry(SHIFT, 550);
   _actionMap[388][COLUMN] = ActionEntry(SHIFT, 551);
   _actionMap[389][COLUMN] = ActionEntry(SHIFT, 552);
   _actionMap[390][STRINGVAL] = ActionEntry(SHIFT, 553);
   _actionMap[391][RB] = ActionEntry(SHIFT, 394);
   _actionMap[392][KSEP] = ActionEntry(SHIFT, 554);
   _actionMap[392][RB] = ActionEntry(REDUCE, 279);
   _actionMap[393][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[393][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[393][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[393][KSEP] = ActionEntry(REDUCE, 282);
   _actionMap[393][RB] = ActionEntry(REDUCE, 282);
   _actionMap[394][SEMICOLON] = ActionEntry(REDUCE, 62);
   _actionMap[395][SEMICOLON] = ActionEntry(REDUCE, 267);
   _actionMap[396][SEMICOLON] = ActionEntry(REDUCE, 268);
   _actionMap[397][SEMICOLON] = ActionEntry(REDUCE, 269);
   _actionMap[398][SEMICOLON] = ActionEntry(REDUCE, 270);
   _actionMap[399][SEMICOLON] = ActionEntry(REDUCE, 271);
   _actionMap[400][SEMICOLON] = ActionEntry(REDUCE, 264);
   _actionMap[401][SEMICOLON] = ActionEntry(REDUCE, 266);
   _actionMap[402][SEMICOLON] = ActionEntry(REDUCE, 265);
   _actionMap[403][END_TOKEN] = ActionEntry(SHIFT, 555);
   _actionMap[404][EXCEPTION] = ActionEntry(REDUCE, 277);
   _actionMap[404][ELSE] = ActionEntry(REDUCE, 277);
   _actionMap[404][ELSIF] = ActionEntry(REDUCE, 277);
   _actionMap[404][END_TOKEN] = ActionEntry(REDUCE, 277);
   _actionMap[404][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[404][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[404][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[404][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[404][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[404][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[404][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[404][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[404][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[404][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[404][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[404][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[404][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[404][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[404][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[404][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[404][LEFT] = ActionEntry(SHIFT, 148);
}
void Cego::loadParser126()
{
   _actionMap[404][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[404][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[404][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[404][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[404][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[404][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[404][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[404][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[404][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[404][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[404][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[404][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[404][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[404][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[404][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[404][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[404][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[404][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[404][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[404][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[404][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[404][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[404][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[404][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[404][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[404][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[404][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[404][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[404][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[404][LB] = ActionEntry(SHIFT, 177);
   _actionMap[404][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[404][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[404][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[404][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[404][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[404][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[404][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[404][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[404][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[404][VARREF] = ActionEntry(SHIFT, 418);
   _actionMap[404][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[404][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[404][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[404][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[404][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[404][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[404][IF] = ActionEntry(SHIFT, 412);
   _actionMap[404][BEGIN] = ActionEntry(SHIFT, 409);
   _actionMap[404][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[404][LOCK] = ActionEntry(SHIFT, 27);
}
void Cego::loadParser127()
{
   _actionMap[404][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[404][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[404][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[404][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[404][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[404][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[404][VAR] = ActionEntry(SHIFT, 416);
   _actionMap[404][CURSOR] = ActionEntry(SHIFT, 411);
   _actionMap[404][CLOSE] = ActionEntry(SHIFT, 410);
   _actionMap[404][NOOP] = ActionEntry(SHIFT, 413);
   _actionMap[404][THROW] = ActionEntry(SHIFT, 415);
   _actionMap[404][RETURNTOKEN] = ActionEntry(SHIFT, 414);
   _actionMap[404][WHILE] = ActionEntry(SHIFT, 417);
   _jumpMap[404][ObjSpec] = 122;
   _jumpMap[404][Constant] = 121;
   _jumpMap[404][SignedFloat] = 120;
   _jumpMap[404][SignedInt] = 119;
   _jumpMap[404][Attribute] = 118;
   _jumpMap[404][Function] = 117;
   _jumpMap[404][Factor] = 116;
   _jumpMap[404][Term] = 115;
   _jumpMap[404][Expr] = 408;
   _jumpMap[404][ProcStatement] = 557;
   _jumpMap[404][ProcIfPart] = 406;
   _jumpMap[404][ProcExceptionList] = 556;
   _jumpMap[404][ProcBlockStart] = 405;
   _jumpMap[404][DeleteStatement] = 402;
   _jumpMap[404][UpdateStatement] = 401;
   _jumpMap[404][InsertStatement] = 400;
   _jumpMap[404][UnlockStatement] = 399;
   _jumpMap[404][LockStatement] = 398;
   _jumpMap[404][RollbackStatement] = 397;
   _jumpMap[404][CommitStatement] = 396;
   _jumpMap[404][StartStatement] = 395;
   _jumpMap[404][CasePrepare] = 113;
   _jumpMap[404][CaseClause] = 112;
   _actionMap[405][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[405][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[405][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[405][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[405][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[405][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[405][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[405][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[405][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[405][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[405][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[405][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[405][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[405][NEWDATE] = ActionEntry(SHIFT, 146);
}
void Cego::loadParser128()
{
   _actionMap[405][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[405][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[405][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[405][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[405][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[405][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[405][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[405][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[405][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[405][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[405][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[405][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[405][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[405][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[405][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[405][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[405][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[405][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[405][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[405][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[405][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[405][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[405][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[405][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[405][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[405][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[405][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[405][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[405][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[405][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[405][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[405][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[405][LB] = ActionEntry(SHIFT, 177);
   _actionMap[405][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[405][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[405][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[405][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[405][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[405][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[405][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[405][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[405][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[405][VARREF] = ActionEntry(SHIFT, 418);
   _actionMap[405][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[405][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[405][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[405][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[405][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[405][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[405][IF] = ActionEntry(SHIFT, 412);
}
void Cego::loadParser129()
{
   _actionMap[405][BEGIN] = ActionEntry(SHIFT, 409);
   _actionMap[405][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[405][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[405][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[405][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[405][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[405][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[405][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[405][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[405][VAR] = ActionEntry(SHIFT, 416);
   _actionMap[405][CURSOR] = ActionEntry(SHIFT, 411);
   _actionMap[405][CLOSE] = ActionEntry(SHIFT, 410);
   _actionMap[405][NOOP] = ActionEntry(SHIFT, 413);
   _actionMap[405][THROW] = ActionEntry(SHIFT, 415);
   _actionMap[405][RETURNTOKEN] = ActionEntry(SHIFT, 414);
   _actionMap[405][WHILE] = ActionEntry(SHIFT, 417);
   _jumpMap[405][ObjSpec] = 122;
   _jumpMap[405][Constant] = 121;
   _jumpMap[405][SignedFloat] = 120;
   _jumpMap[405][SignedInt] = 119;
   _jumpMap[405][Attribute] = 118;
   _jumpMap[405][Function] = 117;
   _jumpMap[405][Factor] = 116;
   _jumpMap[405][Term] = 115;
   _jumpMap[405][Expr] = 408;
   _jumpMap[405][ProcStatement] = 407;
   _jumpMap[405][ProcIfPart] = 406;
   _jumpMap[405][ProcBlockStart] = 405;
   _jumpMap[405][ProcStatementList] = 404;
   _jumpMap[405][ProcStmtBlock] = 558;
   _jumpMap[405][DeleteStatement] = 402;
   _jumpMap[405][UpdateStatement] = 401;
   _jumpMap[405][InsertStatement] = 400;
   _jumpMap[405][UnlockStatement] = 399;
   _jumpMap[405][LockStatement] = 398;
   _jumpMap[405][RollbackStatement] = 397;
   _jumpMap[405][CommitStatement] = 396;
   _jumpMap[405][StartStatement] = 395;
   _jumpMap[405][CasePrepare] = 113;
   _jumpMap[405][CaseClause] = 112;
   _actionMap[406][ELSIF] = ActionEntry(SHIFT, 561);
   _actionMap[406][END_TOKEN] = ActionEntry(REDUCE, 287);
   _actionMap[406][ELSE] = ActionEntry(REDUCE, 287);
   _jumpMap[406][ProcElsIfOpt] = 560;
   _jumpMap[406][ProcElsIfList] = 559;
   _actionMap[407][SEMICOLON] = ActionEntry(SHIFT, 562);
   _actionMap[408][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[408][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[408][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[408][SEMICOLON] = ActionEntry(REDUCE, 258);
}
void Cego::loadParser130()
{
   _actionMap[409][VAR] = ActionEntry(REDUCE, 275);
   _actionMap[409][CURSOR] = ActionEntry(REDUCE, 275);
   _actionMap[409][CLOSE] = ActionEntry(REDUCE, 275);
   _actionMap[409][VARREF] = ActionEntry(REDUCE, 275);
   _actionMap[409][NOOP] = ActionEntry(REDUCE, 275);
   _actionMap[409][THROW] = ActionEntry(REDUCE, 275);
   _actionMap[409][RETURNTOKEN] = ActionEntry(REDUCE, 275);
   _actionMap[409][WHILE] = ActionEntry(REDUCE, 275);
   _actionMap[409][IF] = ActionEntry(REDUCE, 275);
   _actionMap[409][BEGIN] = ActionEntry(REDUCE, 275);
   _actionMap[409][UNLOCK] = ActionEntry(REDUCE, 275);
   _actionMap[409][LOCK] = ActionEntry(REDUCE, 275);
   _actionMap[409][ROLLBACK] = ActionEntry(REDUCE, 275);
   _actionMap[409][COMMIT] = ActionEntry(REDUCE, 275);
   _actionMap[409][START_TOKEN] = ActionEntry(REDUCE, 275);
   _actionMap[409][UPDATE] = ActionEntry(REDUCE, 275);
   _actionMap[409][DELETETOK] = ActionEntry(REDUCE, 275);
   _actionMap[409][INSERT] = ActionEntry(REDUCE, 275);
   _actionMap[409][FETCH] = ActionEntry(REDUCE, 275);
   _actionMap[409][LB] = ActionEntry(REDUCE, 275);
   _actionMap[409][COUNT] = ActionEntry(REDUCE, 275);
   _actionMap[409][SUM] = ActionEntry(REDUCE, 275);
   _actionMap[409][AVG] = ActionEntry(REDUCE, 275);
   _actionMap[409][MIN] = ActionEntry(REDUCE, 275);
   _actionMap[409][MAX] = ActionEntry(REDUCE, 275);
   _actionMap[409][CASE] = ActionEntry(REDUCE, 275);
   _actionMap[409][INT2ASC] = ActionEntry(REDUCE, 275);
   _actionMap[409][ASC2INT] = ActionEntry(REDUCE, 275);
   _actionMap[409][TRIM] = ActionEntry(REDUCE, 275);
   _actionMap[409][RTRIM] = ActionEntry(REDUCE, 275);
   _actionMap[409][LTRIM] = ActionEntry(REDUCE, 275);
   _actionMap[409][ROUND] = ActionEntry(REDUCE, 275);
   _actionMap[409][SCANDATE] = ActionEntry(REDUCE, 275);
   _actionMap[409][DATE2STR] = ActionEntry(REDUCE, 275);
   _actionMap[409][DATE2LONG] = ActionEntry(REDUCE, 275);
   _actionMap[409][LONG2DATE] = ActionEntry(REDUCE, 275);
   _actionMap[409][NEWDATE] = ActionEntry(REDUCE, 275);
   _actionMap[409][LOWER] = ActionEntry(REDUCE, 275);
   _actionMap[409][UPPER] = ActionEntry(REDUCE, 275);
   _actionMap[409][LEFT] = ActionEntry(REDUCE, 275);
   _actionMap[409][RIGHT] = ActionEntry(REDUCE, 275);
   _actionMap[409][GETPOS] = ActionEntry(REDUCE, 275);
   _actionMap[409][SUBSTR] = ActionEntry(REDUCE, 275);
   _actionMap[409][REPLACE] = ActionEntry(REDUCE, 275);
   _actionMap[409][LENGTH] = ActionEntry(REDUCE, 275);
   _actionMap[409][TRUNC] = ActionEntry(REDUCE, 275);
   _actionMap[409][STR2INT] = ActionEntry(REDUCE, 275);
   _actionMap[409][STR2LONG] = ActionEntry(REDUCE, 275);
   _actionMap[409][RANDSTR] = ActionEntry(REDUCE, 275);
   _actionMap[409][RANDINT] = ActionEntry(REDUCE, 275);
}
void Cego::loadParser131()
{
   _actionMap[409][MOD] = ActionEntry(REDUCE, 275);
   _actionMap[409][DIV] = ActionEntry(REDUCE, 275);
   _actionMap[409][LMOD] = ActionEntry(REDUCE, 275);
   _actionMap[409][LDIV] = ActionEntry(REDUCE, 275);
   _actionMap[409][POWER] = ActionEntry(REDUCE, 275);
   _actionMap[409][BITAND] = ActionEntry(REDUCE, 275);
   _actionMap[409][BITOR] = ActionEntry(REDUCE, 275);
   _actionMap[409][BITXOR] = ActionEntry(REDUCE, 275);
   _actionMap[409][BLOBSIZE] = ActionEntry(REDUCE, 275);
   _actionMap[409][BLOBREF] = ActionEntry(REDUCE, 275);
   _actionMap[409][CLOBSIZE] = ActionEntry(REDUCE, 275);
   _actionMap[409][CLOBREF] = ActionEntry(REDUCE, 275);
   _actionMap[409][CLOB2STR] = ActionEntry(REDUCE, 275);
   _actionMap[409][NEXTCOUNT] = ActionEntry(REDUCE, 275);
   _actionMap[409][SETCOUNT] = ActionEntry(REDUCE, 275);
   _actionMap[409][GETCOUNT] = ActionEntry(REDUCE, 275);
   _actionMap[409][IDENTIFIER] = ActionEntry(REDUCE, 275);
   _actionMap[409][QUALIFIEDOBJ] = ActionEntry(REDUCE, 275);
   _actionMap[409][QUALIFIEDTS] = ActionEntry(REDUCE, 275);
   _actionMap[409][QUALIFIEDPRE] = ActionEntry(REDUCE, 275);
   _actionMap[409][STRINGVAL] = ActionEntry(REDUCE, 275);
   _actionMap[409][SYSDATE] = ActionEntry(REDUCE, 275);
   _actionMap[409][NULLTOKEN] = ActionEntry(REDUCE, 275);
   _actionMap[409][TRUEVAL] = ActionEntry(REDUCE, 275);
   _actionMap[409][FALSEVAL] = ActionEntry(REDUCE, 275);
   _actionMap[409][BLOB] = ActionEntry(REDUCE, 275);
   _actionMap[409][CLOB] = ActionEntry(REDUCE, 275);
   _actionMap[409][FLOATVAL] = ActionEntry(REDUCE, 275);
   _actionMap[409][MINUS] = ActionEntry(REDUCE, 275);
   _actionMap[409][INTVAL] = ActionEntry(REDUCE, 275);
   _actionMap[410][IDENTIFIER] = ActionEntry(SHIFT, 563);
   _actionMap[411][IDENTIFIER] = ActionEntry(SHIFT, 564);
   _actionMap[412][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[412][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[412][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[412][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[412][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[412][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[412][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[412][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[412][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[412][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[412][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[412][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[412][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[412][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[412][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[412][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[412][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[412][RIGHT] = ActionEntry(SHIFT, 163);
}
void Cego::loadParser132()
{
   _actionMap[412][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[412][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[412][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[412][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[412][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[412][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[412][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[412][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[412][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[412][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[412][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[412][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[412][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[412][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[412][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[412][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[412][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[412][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[412][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[412][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[412][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[412][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[412][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[412][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[412][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[412][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[412][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[412][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[412][LB] = ActionEntry(SHIFT, 177);
   _actionMap[412][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[412][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[412][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[412][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[412][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[412][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[412][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[412][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[412][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[412][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[412][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[412][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[412][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[412][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[412][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[412][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[412][EXISTS] = ActionEntry(SHIFT, 275);
   _actionMap[412][NOT] = ActionEntry(SHIFT, 276);
   _jumpMap[412][ObjSpec] = 122;
   _jumpMap[412][Constant] = 121;
   _jumpMap[412][SignedFloat] = 120;
}
void Cego::loadParser133()
{
   _jumpMap[412][SignedInt] = 119;
   _jumpMap[412][Attribute] = 118;
   _jumpMap[412][Function] = 117;
   _jumpMap[412][Factor] = 116;
   _jumpMap[412][Term] = 115;
   _jumpMap[412][Expr] = 274;
   _jumpMap[412][Predicate] = 273;
   _jumpMap[412][Condition] = 566;
   _jumpMap[412][ProcIfCondition] = 565;
   _jumpMap[412][CasePrepare] = 113;
   _jumpMap[412][CaseClause] = 112;
   _actionMap[413][SEMICOLON] = ActionEntry(REDUCE, 259);
   _actionMap[414][SEMICOLON] = ActionEntry(REDUCE, 272);
   _actionMap[414][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[414][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[414][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[414][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[414][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[414][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[414][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[414][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[414][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[414][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[414][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[414][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[414][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[414][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[414][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[414][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[414][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[414][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[414][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[414][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[414][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[414][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[414][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[414][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[414][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[414][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[414][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[414][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[414][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[414][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[414][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[414][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[414][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[414][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[414][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[414][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[414][BLOBREF] = ActionEntry(SHIFT, 131);
}
void Cego::loadParser134()
{
   _actionMap[414][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[414][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[414][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[414][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[414][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[414][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[414][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[414][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[414][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[414][LB] = ActionEntry(SHIFT, 177);
   _actionMap[414][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[414][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[414][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[414][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[414][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[414][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[414][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[414][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[414][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[414][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[414][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[414][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[414][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[414][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[414][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[414][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[414][ObjSpec] = 122;
   _jumpMap[414][Constant] = 121;
   _jumpMap[414][SignedFloat] = 120;
   _jumpMap[414][SignedInt] = 119;
   _jumpMap[414][Attribute] = 118;
   _jumpMap[414][Function] = 117;
   _jumpMap[414][Factor] = 116;
   _jumpMap[414][Term] = 115;
   _jumpMap[414][Expr] = 567;
   _jumpMap[414][CasePrepare] = 113;
   _jumpMap[414][CaseClause] = 112;
   _actionMap[415][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[415][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[415][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[415][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[415][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[415][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[415][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[415][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[415][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[415][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[415][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[415][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[415][LONG2DATE] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser135()
{
   _actionMap[415][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[415][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[415][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[415][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[415][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[415][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[415][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[415][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[415][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[415][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[415][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[415][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[415][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[415][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[415][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[415][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[415][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[415][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[415][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[415][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[415][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[415][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[415][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[415][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[415][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[415][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[415][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[415][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[415][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[415][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[415][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[415][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[415][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[415][LB] = ActionEntry(SHIFT, 177);
   _actionMap[415][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[415][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[415][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[415][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[415][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[415][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[415][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[415][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[415][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[415][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[415][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[415][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[415][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[415][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[415][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[415][MAX] = ActionEntry(SHIFT, 155);
}
void Cego::loadParser136()
{
   _jumpMap[415][ObjSpec] = 122;
   _jumpMap[415][Constant] = 121;
   _jumpMap[415][SignedFloat] = 120;
   _jumpMap[415][SignedInt] = 119;
   _jumpMap[415][Attribute] = 118;
   _jumpMap[415][Function] = 117;
   _jumpMap[415][Factor] = 116;
   _jumpMap[415][Term] = 115;
   _jumpMap[415][Expr] = 568;
   _jumpMap[415][CasePrepare] = 113;
   _jumpMap[415][CaseClause] = 112;
   _actionMap[416][IDENTIFIER] = ActionEntry(SHIFT, 569);
   _actionMap[417][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[417][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[417][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[417][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[417][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[417][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[417][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[417][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[417][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[417][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[417][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[417][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[417][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[417][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[417][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[417][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[417][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[417][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[417][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[417][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[417][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[417][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[417][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[417][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[417][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[417][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[417][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[417][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[417][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[417][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[417][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[417][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[417][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[417][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[417][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[417][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[417][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[417][CLOBSIZE] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser137()
{
   _actionMap[417][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[417][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[417][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[417][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[417][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[417][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[417][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[417][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[417][LB] = ActionEntry(SHIFT, 177);
   _actionMap[417][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[417][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[417][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[417][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[417][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[417][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[417][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[417][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[417][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[417][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[417][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[417][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[417][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[417][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[417][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[417][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[417][EXISTS] = ActionEntry(SHIFT, 275);
   _actionMap[417][NOT] = ActionEntry(SHIFT, 276);
   _jumpMap[417][ObjSpec] = 122;
   _jumpMap[417][Constant] = 121;
   _jumpMap[417][SignedFloat] = 120;
   _jumpMap[417][SignedInt] = 119;
   _jumpMap[417][Attribute] = 118;
   _jumpMap[417][Function] = 117;
   _jumpMap[417][Factor] = 116;
   _jumpMap[417][Term] = 115;
   _jumpMap[417][Expr] = 274;
   _jumpMap[417][Predicate] = 273;
   _jumpMap[417][Condition] = 571;
   _jumpMap[417][ProcWhileCondition] = 570;
   _jumpMap[417][CasePrepare] = 113;
   _jumpMap[417][CaseClause] = 112;
   _actionMap[418][CONCAT] = ActionEntry(REDUCE, 319);
   _actionMap[418][STAR] = ActionEntry(REDUCE, 319);
   _actionMap[418][DIVISION] = ActionEntry(REDUCE, 319);
   _actionMap[418][MINUS] = ActionEntry(REDUCE, 319);
   _actionMap[418][PLUS] = ActionEntry(REDUCE, 319);
   _actionMap[418][SEMICOLON] = ActionEntry(REDUCE, 319);
   _actionMap[418][EQU] = ActionEntry(SHIFT, 572);
   _actionMap[419][ON] = ActionEntry(SHIFT, 573);
   _actionMap[420][END_TOKEN] = ActionEntry(SHIFT, 574);
}
void Cego::loadParser138()
{
   _actionMap[421][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[421][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[421][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[421][ObjSpec] = 575;
   _actionMap[422][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[422][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[422][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[422][ObjSpec] = 576;
   _actionMap[423][IDENTIFIER] = ActionEntry(SHIFT, 581);
   _actionMap[423][RB] = ActionEntry(REDUCE, 246);
   _jumpMap[423][ProcArg] = 579;
   _jumpMap[423][ProcArgList] = 578;
   _jumpMap[423][ProcArgOpt] = 577;
   _actionMap[424][IDENTIFIER] = ActionEntry(SHIFT, 586);
   _actionMap[424][PRIMARY] = ActionEntry(SHIFT, 585);
   _jumpMap[424][ColumnDesc] = 584;
   _jumpMap[424][KeyColumn] = 583;
   _jumpMap[424][ColumnList] = 582;
   _actionMap[425][INSERT] = ActionEntry(SHIFT, 590);
   _actionMap[425][UPDATE] = ActionEntry(SHIFT, 591);
   _actionMap[425][DELETETOK] = ActionEntry(SHIFT, 589);
   _jumpMap[425][TriggerOp] = 588;
   _jumpMap[425][TriggerCondition] = 587;
   _actionMap[426][INSERT] = ActionEntry(REDUCE, 103);
   _actionMap[426][UPDATE] = ActionEntry(REDUCE, 103);
   _actionMap[426][DELETETOK] = ActionEntry(REDUCE, 103);
   _actionMap[427][INSERT] = ActionEntry(REDUCE, 102);
   _actionMap[427][UPDATE] = ActionEntry(REDUCE, 102);
   _actionMap[427][DELETETOK] = ActionEntry(REDUCE, 102);
   _actionMap[428][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[428][SelectStatement] = 592;
   _actionMap[429][SEMICOLON] = ActionEntry(REDUCE, 224);
   _actionMap[429][WHERE] = ActionEntry(SHIFT, 432);
   _jumpMap[429][NoWhere] = 431;
   _jumpMap[429][WhereClause] = 430;
   _actionMap[430][SEMICOLON] = ActionEntry(REDUCE, 165);
   _actionMap[431][RETURNTOKEN] = ActionEntry(REDUCE, 223);
   _actionMap[431][GROUP] = ActionEntry(REDUCE, 223);
   _actionMap[431][ORDER] = ActionEntry(REDUCE, 223);
   _actionMap[431][ROWLIMIT] = ActionEntry(REDUCE, 223);
   _actionMap[431][UNION] = ActionEntry(REDUCE, 223);
   _actionMap[431][ENDTOKEN] = ActionEntry(REDUCE, 223);
   _actionMap[431][RB] = ActionEntry(REDUCE, 223);
   _actionMap[431][SEMICOLON] = ActionEntry(REDUCE, 223);
   _actionMap[432][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[432][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[432][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[432][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[432][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[432][TRIM] = ActionEntry(SHIFT, 173);
}
void Cego::loadParser139()
{
   _actionMap[432][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[432][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[432][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[432][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[432][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[432][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[432][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[432][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[432][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[432][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[432][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[432][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[432][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[432][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[432][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[432][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[432][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[432][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[432][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[432][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[432][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[432][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[432][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[432][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[432][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[432][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[432][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[432][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[432][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[432][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[432][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[432][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[432][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[432][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[432][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[432][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[432][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[432][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[432][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[432][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[432][LB] = ActionEntry(SHIFT, 177);
   _actionMap[432][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[432][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[432][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[432][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[432][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[432][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[432][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[432][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[432][CASE] = ActionEntry(SHIFT, 132);
}
void Cego::loadParser140()
{
   _actionMap[432][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[432][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[432][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[432][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[432][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[432][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[432][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[432][EXISTS] = ActionEntry(SHIFT, 275);
   _actionMap[432][NOT] = ActionEntry(SHIFT, 276);
   _jumpMap[432][ObjSpec] = 122;
   _jumpMap[432][Constant] = 121;
   _jumpMap[432][SignedFloat] = 120;
   _jumpMap[432][SignedInt] = 119;
   _jumpMap[432][Attribute] = 118;
   _jumpMap[432][Function] = 117;
   _jumpMap[432][Factor] = 116;
   _jumpMap[432][Term] = 115;
   _jumpMap[432][Expr] = 274;
   _jumpMap[432][Predicate] = 273;
   _jumpMap[432][Condition] = 593;
   _jumpMap[432][CasePrepare] = 113;
   _jumpMap[432][CaseClause] = 112;
   _actionMap[433][SEMICOLON] = ActionEntry(REDUCE, 27);
   _actionMap[434][SELECT] = ActionEntry(SHIFT, 34);
   _actionMap[434][VALUES] = ActionEntry(SHIFT, 437);
   _jumpMap[434][SelectStatement] = 436;
   _jumpMap[434][InsertPrepare] = 435;
   _actionMap[435][LB] = ActionEntry(SHIFT, 596);
   _jumpMap[435][InsertValueSpec] = 595;
   _jumpMap[435][InsertValueSpecList] = 594;
   _actionMap[436][SEMICOLON] = ActionEntry(REDUCE, 143);
   _actionMap[437][LB] = ActionEntry(REDUCE, 146);
   _actionMap[438][IDENTIFIER] = ActionEntry(SHIFT, 598);
   _jumpMap[438][InsertArgList] = 597;
   _actionMap[439][SEMICOLON] = ActionEntry(REDUCE, 15);
   _actionMap[440][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[440][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[440][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[440][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[440][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[440][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[440][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[440][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[440][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[440][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[440][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[440][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[440][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[440][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[440][LOWER] = ActionEntry(SHIFT, 152);
}
void Cego::loadParser141()
{
   _actionMap[440][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[440][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[440][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[440][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[440][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[440][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[440][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[440][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[440][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[440][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[440][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[440][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[440][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[440][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[440][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[440][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[440][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[440][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[440][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[440][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[440][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[440][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[440][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[440][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[440][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[440][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[440][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[440][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[440][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[440][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[440][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[440][LB] = ActionEntry(SHIFT, 177);
   _actionMap[440][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[440][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[440][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[440][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[440][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[440][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[440][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[440][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[440][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[440][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[440][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[440][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[440][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[440][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[440][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[440][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[440][EXISTS] = ActionEntry(SHIFT, 275);
   _actionMap[440][NOT] = ActionEntry(SHIFT, 276);
}
void Cego::loadParser142()
{
   _jumpMap[440][ObjSpec] = 122;
   _jumpMap[440][Constant] = 121;
   _jumpMap[440][SignedFloat] = 120;
   _jumpMap[440][SignedInt] = 119;
   _jumpMap[440][Attribute] = 118;
   _jumpMap[440][Function] = 117;
   _jumpMap[440][Factor] = 116;
   _jumpMap[440][Term] = 115;
   _jumpMap[440][Expr] = 274;
   _jumpMap[440][Predicate] = 599;
   _jumpMap[440][CasePrepare] = 113;
   _jumpMap[440][CaseClause] = 112;
   _actionMap[441][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[441][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[441][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[441][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[441][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[441][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[441][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[441][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[441][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[441][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[441][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[441][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[441][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[441][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[441][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[441][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[441][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[441][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[441][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[441][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[441][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[441][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[441][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[441][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[441][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[441][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[441][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[441][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[441][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[441][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[441][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[441][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[441][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[441][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[441][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[441][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[441][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[441][CLOBSIZE] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser143()
{
   _actionMap[441][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[441][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[441][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[441][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[441][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[441][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[441][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[441][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[441][LB] = ActionEntry(SHIFT, 177);
   _actionMap[441][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[441][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[441][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[441][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[441][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[441][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[441][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[441][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[441][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[441][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[441][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[441][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[441][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[441][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[441][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[441][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[441][EXISTS] = ActionEntry(SHIFT, 275);
   _actionMap[441][NOT] = ActionEntry(SHIFT, 276);
   _jumpMap[441][ObjSpec] = 122;
   _jumpMap[441][Constant] = 121;
   _jumpMap[441][SignedFloat] = 120;
   _jumpMap[441][SignedInt] = 119;
   _jumpMap[441][Attribute] = 118;
   _jumpMap[441][Function] = 117;
   _jumpMap[441][Factor] = 116;
   _jumpMap[441][Term] = 115;
   _jumpMap[441][Expr] = 274;
   _jumpMap[441][Predicate] = 600;
   _jumpMap[441][CasePrepare] = 113;
   _jumpMap[441][CaseClause] = 112;
   _actionMap[442][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[442][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[442][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[442][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[442][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[442][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[442][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[442][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[442][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[442][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[442][DATE2STR] = ActionEntry(SHIFT, 138);
}
void Cego::loadParser144()
{
   _actionMap[442][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[442][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[442][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[442][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[442][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[442][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[442][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[442][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[442][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[442][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[442][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[442][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[442][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[442][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[442][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[442][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[442][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[442][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[442][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[442][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[442][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[442][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[442][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[442][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[442][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[442][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[442][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[442][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[442][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[442][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[442][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[442][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[442][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[442][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[442][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[442][LB] = ActionEntry(SHIFT, 177);
   _actionMap[442][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[442][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[442][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[442][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[442][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[442][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[442][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[442][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[442][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[442][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[442][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[442][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[442][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[442][AVG] = ActionEntry(SHIFT, 125);
}
void Cego::loadParser145()
{
   _actionMap[442][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[442][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[442][ObjSpec] = 122;
   _jumpMap[442][Constant] = 121;
   _jumpMap[442][SignedFloat] = 120;
   _jumpMap[442][SignedInt] = 119;
   _jumpMap[442][Attribute] = 118;
   _jumpMap[442][Function] = 117;
   _jumpMap[442][Factor] = 116;
   _jumpMap[442][Term] = 115;
   _jumpMap[442][Expr] = 601;
   _jumpMap[442][CasePrepare] = 113;
   _jumpMap[442][CaseClause] = 112;
   _actionMap[443][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[443][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[443][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[443][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[443][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[443][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[443][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[443][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[443][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[443][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[443][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[443][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[443][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[443][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[443][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[443][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[443][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[443][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[443][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[443][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[443][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[443][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[443][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[443][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[443][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[443][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[443][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[443][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[443][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[443][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[443][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[443][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[443][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[443][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[443][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[443][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[443][BLOBREF] = ActionEntry(SHIFT, 131);
}
void Cego::loadParser146()
{
   _actionMap[443][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[443][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[443][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[443][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[443][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[443][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[443][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[443][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[443][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[443][LB] = ActionEntry(SHIFT, 177);
   _actionMap[443][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[443][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[443][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[443][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[443][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[443][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[443][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[443][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[443][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[443][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[443][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[443][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[443][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[443][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[443][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[443][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[443][ObjSpec] = 122;
   _jumpMap[443][Constant] = 121;
   _jumpMap[443][SignedFloat] = 120;
   _jumpMap[443][SignedInt] = 119;
   _jumpMap[443][Attribute] = 118;
   _jumpMap[443][Function] = 117;
   _jumpMap[443][Factor] = 116;
   _jumpMap[443][Term] = 115;
   _jumpMap[443][Expr] = 602;
   _jumpMap[443][CasePrepare] = 113;
   _jumpMap[443][CaseClause] = 112;
   _actionMap[444][LB] = ActionEntry(SHIFT, 603);
   _actionMap[445][NOT] = ActionEntry(SHIFT, 604);
   _actionMap[445][NULLTOKEN] = ActionEntry(SHIFT, 605);
   _actionMap[446][STRINGVAL] = ActionEntry(SHIFT, 606);
   _actionMap[447][LIKE] = ActionEntry(SHIFT, 608);
   _actionMap[447][INTOK] = ActionEntry(SHIFT, 607);
   _actionMap[448][VARREF] = ActionEntry(REDUCE, 392);
   _actionMap[448][FETCH] = ActionEntry(REDUCE, 392);
   _actionMap[448][LB] = ActionEntry(REDUCE, 392);
   _actionMap[448][COUNT] = ActionEntry(REDUCE, 392);
   _actionMap[448][SUM] = ActionEntry(REDUCE, 392);
   _actionMap[448][AVG] = ActionEntry(REDUCE, 392);
   _actionMap[448][MIN] = ActionEntry(REDUCE, 392);
}
void Cego::loadParser147()
{
   _actionMap[448][MAX] = ActionEntry(REDUCE, 392);
   _actionMap[448][CASE] = ActionEntry(REDUCE, 392);
   _actionMap[448][INT2ASC] = ActionEntry(REDUCE, 392);
   _actionMap[448][ASC2INT] = ActionEntry(REDUCE, 392);
   _actionMap[448][TRIM] = ActionEntry(REDUCE, 392);
   _actionMap[448][RTRIM] = ActionEntry(REDUCE, 392);
   _actionMap[448][LTRIM] = ActionEntry(REDUCE, 392);
   _actionMap[448][ROUND] = ActionEntry(REDUCE, 392);
   _actionMap[448][SCANDATE] = ActionEntry(REDUCE, 392);
   _actionMap[448][DATE2STR] = ActionEntry(REDUCE, 392);
   _actionMap[448][DATE2LONG] = ActionEntry(REDUCE, 392);
   _actionMap[448][LONG2DATE] = ActionEntry(REDUCE, 392);
   _actionMap[448][NEWDATE] = ActionEntry(REDUCE, 392);
   _actionMap[448][LOWER] = ActionEntry(REDUCE, 392);
   _actionMap[448][UPPER] = ActionEntry(REDUCE, 392);
   _actionMap[448][LEFT] = ActionEntry(REDUCE, 392);
   _actionMap[448][RIGHT] = ActionEntry(REDUCE, 392);
   _actionMap[448][GETPOS] = ActionEntry(REDUCE, 392);
   _actionMap[448][SUBSTR] = ActionEntry(REDUCE, 392);
   _actionMap[448][REPLACE] = ActionEntry(REDUCE, 392);
   _actionMap[448][LENGTH] = ActionEntry(REDUCE, 392);
   _actionMap[448][TRUNC] = ActionEntry(REDUCE, 392);
   _actionMap[448][STR2INT] = ActionEntry(REDUCE, 392);
   _actionMap[448][STR2LONG] = ActionEntry(REDUCE, 392);
   _actionMap[448][RANDSTR] = ActionEntry(REDUCE, 392);
   _actionMap[448][RANDINT] = ActionEntry(REDUCE, 392);
   _actionMap[448][MOD] = ActionEntry(REDUCE, 392);
   _actionMap[448][DIV] = ActionEntry(REDUCE, 392);
   _actionMap[448][LMOD] = ActionEntry(REDUCE, 392);
   _actionMap[448][LDIV] = ActionEntry(REDUCE, 392);
   _actionMap[448][POWER] = ActionEntry(REDUCE, 392);
   _actionMap[448][BITAND] = ActionEntry(REDUCE, 392);
   _actionMap[448][BITOR] = ActionEntry(REDUCE, 392);
   _actionMap[448][BITXOR] = ActionEntry(REDUCE, 392);
   _actionMap[448][BLOBSIZE] = ActionEntry(REDUCE, 392);
   _actionMap[448][BLOBREF] = ActionEntry(REDUCE, 392);
   _actionMap[448][CLOBSIZE] = ActionEntry(REDUCE, 392);
   _actionMap[448][CLOBREF] = ActionEntry(REDUCE, 392);
   _actionMap[448][CLOB2STR] = ActionEntry(REDUCE, 392);
   _actionMap[448][NEXTCOUNT] = ActionEntry(REDUCE, 392);
   _actionMap[448][SETCOUNT] = ActionEntry(REDUCE, 392);
   _actionMap[448][GETCOUNT] = ActionEntry(REDUCE, 392);
   _actionMap[448][IDENTIFIER] = ActionEntry(REDUCE, 392);
   _actionMap[448][QUALIFIEDOBJ] = ActionEntry(REDUCE, 392);
   _actionMap[448][QUALIFIEDTS] = ActionEntry(REDUCE, 392);
   _actionMap[448][QUALIFIEDPRE] = ActionEntry(REDUCE, 392);
   _actionMap[448][STRINGVAL] = ActionEntry(REDUCE, 392);
   _actionMap[448][SYSDATE] = ActionEntry(REDUCE, 392);
   _actionMap[448][NULLTOKEN] = ActionEntry(REDUCE, 392);
   _actionMap[448][TRUEVAL] = ActionEntry(REDUCE, 392);
}
void Cego::loadParser148()
{
   _actionMap[448][FALSEVAL] = ActionEntry(REDUCE, 392);
   _actionMap[448][BLOB] = ActionEntry(REDUCE, 392);
   _actionMap[448][CLOB] = ActionEntry(REDUCE, 392);
   _actionMap[448][FLOATVAL] = ActionEntry(REDUCE, 392);
   _actionMap[448][MINUS] = ActionEntry(REDUCE, 392);
   _actionMap[448][INTVAL] = ActionEntry(REDUCE, 392);
   _actionMap[449][VARREF] = ActionEntry(REDUCE, 394);
   _actionMap[449][FETCH] = ActionEntry(REDUCE, 394);
   _actionMap[449][LB] = ActionEntry(REDUCE, 394);
   _actionMap[449][COUNT] = ActionEntry(REDUCE, 394);
   _actionMap[449][SUM] = ActionEntry(REDUCE, 394);
   _actionMap[449][AVG] = ActionEntry(REDUCE, 394);
   _actionMap[449][MIN] = ActionEntry(REDUCE, 394);
   _actionMap[449][MAX] = ActionEntry(REDUCE, 394);
   _actionMap[449][CASE] = ActionEntry(REDUCE, 394);
   _actionMap[449][INT2ASC] = ActionEntry(REDUCE, 394);
   _actionMap[449][ASC2INT] = ActionEntry(REDUCE, 394);
   _actionMap[449][TRIM] = ActionEntry(REDUCE, 394);
   _actionMap[449][RTRIM] = ActionEntry(REDUCE, 394);
   _actionMap[449][LTRIM] = ActionEntry(REDUCE, 394);
   _actionMap[449][ROUND] = ActionEntry(REDUCE, 394);
   _actionMap[449][SCANDATE] = ActionEntry(REDUCE, 394);
   _actionMap[449][DATE2STR] = ActionEntry(REDUCE, 394);
   _actionMap[449][DATE2LONG] = ActionEntry(REDUCE, 394);
   _actionMap[449][LONG2DATE] = ActionEntry(REDUCE, 394);
   _actionMap[449][NEWDATE] = ActionEntry(REDUCE, 394);
   _actionMap[449][LOWER] = ActionEntry(REDUCE, 394);
   _actionMap[449][UPPER] = ActionEntry(REDUCE, 394);
   _actionMap[449][LEFT] = ActionEntry(REDUCE, 394);
   _actionMap[449][RIGHT] = ActionEntry(REDUCE, 394);
   _actionMap[449][GETPOS] = ActionEntry(REDUCE, 394);
   _actionMap[449][SUBSTR] = ActionEntry(REDUCE, 394);
   _actionMap[449][REPLACE] = ActionEntry(REDUCE, 394);
   _actionMap[449][LENGTH] = ActionEntry(REDUCE, 394);
   _actionMap[449][TRUNC] = ActionEntry(REDUCE, 394);
   _actionMap[449][STR2INT] = ActionEntry(REDUCE, 394);
   _actionMap[449][STR2LONG] = ActionEntry(REDUCE, 394);
   _actionMap[449][RANDSTR] = ActionEntry(REDUCE, 394);
   _actionMap[449][RANDINT] = ActionEntry(REDUCE, 394);
   _actionMap[449][MOD] = ActionEntry(REDUCE, 394);
   _actionMap[449][DIV] = ActionEntry(REDUCE, 394);
   _actionMap[449][LMOD] = ActionEntry(REDUCE, 394);
   _actionMap[449][LDIV] = ActionEntry(REDUCE, 394);
   _actionMap[449][POWER] = ActionEntry(REDUCE, 394);
   _actionMap[449][BITAND] = ActionEntry(REDUCE, 394);
   _actionMap[449][BITOR] = ActionEntry(REDUCE, 394);
   _actionMap[449][BITXOR] = ActionEntry(REDUCE, 394);
   _actionMap[449][BLOBSIZE] = ActionEntry(REDUCE, 394);
   _actionMap[449][BLOBREF] = ActionEntry(REDUCE, 394);
   _actionMap[449][CLOBSIZE] = ActionEntry(REDUCE, 394);
}
void Cego::loadParser149()
{
   _actionMap[449][CLOBREF] = ActionEntry(REDUCE, 394);
   _actionMap[449][CLOB2STR] = ActionEntry(REDUCE, 394);
   _actionMap[449][NEXTCOUNT] = ActionEntry(REDUCE, 394);
   _actionMap[449][SETCOUNT] = ActionEntry(REDUCE, 394);
   _actionMap[449][GETCOUNT] = ActionEntry(REDUCE, 394);
   _actionMap[449][IDENTIFIER] = ActionEntry(REDUCE, 394);
   _actionMap[449][QUALIFIEDOBJ] = ActionEntry(REDUCE, 394);
   _actionMap[449][QUALIFIEDTS] = ActionEntry(REDUCE, 394);
   _actionMap[449][QUALIFIEDPRE] = ActionEntry(REDUCE, 394);
   _actionMap[449][STRINGVAL] = ActionEntry(REDUCE, 394);
   _actionMap[449][SYSDATE] = ActionEntry(REDUCE, 394);
   _actionMap[449][NULLTOKEN] = ActionEntry(REDUCE, 394);
   _actionMap[449][TRUEVAL] = ActionEntry(REDUCE, 394);
   _actionMap[449][FALSEVAL] = ActionEntry(REDUCE, 394);
   _actionMap[449][BLOB] = ActionEntry(REDUCE, 394);
   _actionMap[449][CLOB] = ActionEntry(REDUCE, 394);
   _actionMap[449][FLOATVAL] = ActionEntry(REDUCE, 394);
   _actionMap[449][MINUS] = ActionEntry(REDUCE, 394);
   _actionMap[449][INTVAL] = ActionEntry(REDUCE, 394);
   _actionMap[449][EQU] = ActionEntry(SHIFT, 609);
   _actionMap[450][VARREF] = ActionEntry(REDUCE, 395);
   _actionMap[450][FETCH] = ActionEntry(REDUCE, 395);
   _actionMap[450][LB] = ActionEntry(REDUCE, 395);
   _actionMap[450][COUNT] = ActionEntry(REDUCE, 395);
   _actionMap[450][SUM] = ActionEntry(REDUCE, 395);
   _actionMap[450][AVG] = ActionEntry(REDUCE, 395);
   _actionMap[450][MIN] = ActionEntry(REDUCE, 395);
   _actionMap[450][MAX] = ActionEntry(REDUCE, 395);
   _actionMap[450][CASE] = ActionEntry(REDUCE, 395);
   _actionMap[450][INT2ASC] = ActionEntry(REDUCE, 395);
   _actionMap[450][ASC2INT] = ActionEntry(REDUCE, 395);
   _actionMap[450][TRIM] = ActionEntry(REDUCE, 395);
   _actionMap[450][RTRIM] = ActionEntry(REDUCE, 395);
   _actionMap[450][LTRIM] = ActionEntry(REDUCE, 395);
   _actionMap[450][ROUND] = ActionEntry(REDUCE, 395);
   _actionMap[450][SCANDATE] = ActionEntry(REDUCE, 395);
   _actionMap[450][DATE2STR] = ActionEntry(REDUCE, 395);
   _actionMap[450][DATE2LONG] = ActionEntry(REDUCE, 395);
   _actionMap[450][LONG2DATE] = ActionEntry(REDUCE, 395);
   _actionMap[450][NEWDATE] = ActionEntry(REDUCE, 395);
   _actionMap[450][LOWER] = ActionEntry(REDUCE, 395);
   _actionMap[450][UPPER] = ActionEntry(REDUCE, 395);
   _actionMap[450][LEFT] = ActionEntry(REDUCE, 395);
   _actionMap[450][RIGHT] = ActionEntry(REDUCE, 395);
   _actionMap[450][GETPOS] = ActionEntry(REDUCE, 395);
   _actionMap[450][SUBSTR] = ActionEntry(REDUCE, 395);
   _actionMap[450][REPLACE] = ActionEntry(REDUCE, 395);
   _actionMap[450][LENGTH] = ActionEntry(REDUCE, 395);
   _actionMap[450][TRUNC] = ActionEntry(REDUCE, 395);
   _actionMap[450][STR2INT] = ActionEntry(REDUCE, 395);
}
void Cego::loadParser150()
{
   _actionMap[450][STR2LONG] = ActionEntry(REDUCE, 395);
   _actionMap[450][RANDSTR] = ActionEntry(REDUCE, 395);
   _actionMap[450][RANDINT] = ActionEntry(REDUCE, 395);
   _actionMap[450][MOD] = ActionEntry(REDUCE, 395);
   _actionMap[450][DIV] = ActionEntry(REDUCE, 395);
   _actionMap[450][LMOD] = ActionEntry(REDUCE, 395);
   _actionMap[450][LDIV] = ActionEntry(REDUCE, 395);
   _actionMap[450][POWER] = ActionEntry(REDUCE, 395);
   _actionMap[450][BITAND] = ActionEntry(REDUCE, 395);
   _actionMap[450][BITOR] = ActionEntry(REDUCE, 395);
   _actionMap[450][BITXOR] = ActionEntry(REDUCE, 395);
   _actionMap[450][BLOBSIZE] = ActionEntry(REDUCE, 395);
   _actionMap[450][BLOBREF] = ActionEntry(REDUCE, 395);
   _actionMap[450][CLOBSIZE] = ActionEntry(REDUCE, 395);
   _actionMap[450][CLOBREF] = ActionEntry(REDUCE, 395);
   _actionMap[450][CLOB2STR] = ActionEntry(REDUCE, 395);
   _actionMap[450][NEXTCOUNT] = ActionEntry(REDUCE, 395);
   _actionMap[450][SETCOUNT] = ActionEntry(REDUCE, 395);
   _actionMap[450][GETCOUNT] = ActionEntry(REDUCE, 395);
   _actionMap[450][IDENTIFIER] = ActionEntry(REDUCE, 395);
   _actionMap[450][QUALIFIEDOBJ] = ActionEntry(REDUCE, 395);
   _actionMap[450][QUALIFIEDTS] = ActionEntry(REDUCE, 395);
   _actionMap[450][QUALIFIEDPRE] = ActionEntry(REDUCE, 395);
   _actionMap[450][STRINGVAL] = ActionEntry(REDUCE, 395);
   _actionMap[450][SYSDATE] = ActionEntry(REDUCE, 395);
   _actionMap[450][NULLTOKEN] = ActionEntry(REDUCE, 395);
   _actionMap[450][TRUEVAL] = ActionEntry(REDUCE, 395);
   _actionMap[450][FALSEVAL] = ActionEntry(REDUCE, 395);
   _actionMap[450][BLOB] = ActionEntry(REDUCE, 395);
   _actionMap[450][CLOB] = ActionEntry(REDUCE, 395);
   _actionMap[450][FLOATVAL] = ActionEntry(REDUCE, 395);
   _actionMap[450][MINUS] = ActionEntry(REDUCE, 395);
   _actionMap[450][INTVAL] = ActionEntry(REDUCE, 395);
   _actionMap[450][EQU] = ActionEntry(SHIFT, 610);
   _actionMap[451][EQU] = ActionEntry(SHIFT, 611);
   _actionMap[452][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[452][SelectStatement] = 612;
   _actionMap[453][LEFT] = ActionEntry(REDUCE, 311);
   _actionMap[453][RIGHT] = ActionEntry(REDUCE, 311);
   _actionMap[453][INNER] = ActionEntry(REDUCE, 311);
   _actionMap[453][JOIN] = ActionEntry(REDUCE, 311);
   _actionMap[453][ENDTOKEN] = ActionEntry(REDUCE, 311);
   _actionMap[453][UNION] = ActionEntry(REDUCE, 311);
   _actionMap[453][ROWLIMIT] = ActionEntry(REDUCE, 311);
   _actionMap[453][ORDER] = ActionEntry(REDUCE, 311);
   _actionMap[453][GROUP] = ActionEntry(REDUCE, 311);
   _actionMap[453][SEMICOLON] = ActionEntry(REDUCE, 311);
   _actionMap[453][RETURNTOKEN] = ActionEntry(REDUCE, 311);
   _actionMap[453][WHERE] = ActionEntry(REDUCE, 311);
   _actionMap[453][RB] = ActionEntry(REDUCE, 311);
}
void Cego::loadParser151()
{
   _actionMap[453][BEGIN] = ActionEntry(REDUCE, 311);
   _actionMap[453][THEN] = ActionEntry(REDUCE, 311);
   _actionMap[453][AND] = ActionEntry(REDUCE, 311);
   _actionMap[453][OR] = ActionEntry(REDUCE, 311);
   _actionMap[454][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[454][SelectStatement] = 613;
   _actionMap[455][WHEN] = ActionEntry(REDUCE, 110);
   _actionMap[455][ELSE] = ActionEntry(REDUCE, 110);
   _actionMap[456][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[456][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[456][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[456][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[456][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[456][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[456][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[456][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[456][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[456][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[456][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[456][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[456][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[456][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[456][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[456][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[456][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[456][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[456][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[456][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[456][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[456][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[456][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[456][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[456][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[456][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[456][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[456][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[456][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[456][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[456][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[456][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[456][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[456][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[456][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[456][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[456][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[456][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[456][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[456][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[456][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[456][SETCOUNT] = ActionEntry(SHIFT, 167);
}
void Cego::loadParser152()
{
   _actionMap[456][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[456][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[456][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[456][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[456][LB] = ActionEntry(SHIFT, 177);
   _actionMap[456][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[456][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[456][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[456][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[456][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[456][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[456][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[456][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[456][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[456][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[456][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[456][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[456][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[456][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[456][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[456][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[456][ObjSpec] = 122;
   _jumpMap[456][Constant] = 121;
   _jumpMap[456][SignedFloat] = 120;
   _jumpMap[456][SignedInt] = 119;
   _jumpMap[456][Attribute] = 118;
   _jumpMap[456][Function] = 117;
   _jumpMap[456][Factor] = 116;
   _jumpMap[456][Term] = 115;
   _jumpMap[456][Expr] = 614;
   _jumpMap[456][CasePrepare] = 113;
   _jumpMap[456][CaseClause] = 112;
   _actionMap[457][THEN] = ActionEntry(SHIFT, 615);
   _actionMap[457][AND] = ActionEntry(SHIFT, 440);
   _actionMap[457][OR] = ActionEntry(SHIFT, 441);
   _actionMap[458][STAR] = ActionEntry(SHIFT, 286);
   _actionMap[458][DIVISION] = ActionEntry(SHIFT, 287);
   _actionMap[458][WHEN] = ActionEntry(REDUCE, 315);
   _actionMap[458][ELSE] = ActionEntry(REDUCE, 315);
   _actionMap[458][LEFT] = ActionEntry(REDUCE, 315);
   _actionMap[458][RIGHT] = ActionEntry(REDUCE, 315);
   _actionMap[458][INNER] = ActionEntry(REDUCE, 315);
   _actionMap[458][JOIN] = ActionEntry(REDUCE, 315);
   _actionMap[458][ORDER] = ActionEntry(REDUCE, 315);
   _actionMap[458][GROUP] = ActionEntry(REDUCE, 315);
   _actionMap[458][RETURNTOKEN] = ActionEntry(REDUCE, 315);
   _actionMap[458][WHERE] = ActionEntry(REDUCE, 315);
   _actionMap[458][AS] = ActionEntry(REDUCE, 315);
   _actionMap[458][FROM] = ActionEntry(REDUCE, 315);
   _actionMap[458][BEGIN] = ActionEntry(REDUCE, 315);
}
void Cego::loadParser153()
{
   _actionMap[458][THEN] = ActionEntry(REDUCE, 315);
   _actionMap[458][OR] = ActionEntry(REDUCE, 315);
   _actionMap[458][LIKE] = ActionEntry(REDUCE, 315);
   _actionMap[458][IS] = ActionEntry(REDUCE, 315);
   _actionMap[458][BETWEEN] = ActionEntry(REDUCE, 315);
   _actionMap[458][EQU] = ActionEntry(REDUCE, 315);
   _actionMap[458][NEGATION] = ActionEntry(REDUCE, 315);
   _actionMap[458][LT] = ActionEntry(REDUCE, 315);
   _actionMap[458][MT] = ActionEntry(REDUCE, 315);
   _actionMap[458][NOT] = ActionEntry(REDUCE, 315);
   _actionMap[458][INTOK] = ActionEntry(REDUCE, 315);
   _actionMap[458][END_TOKEN] = ActionEntry(REDUCE, 315);
   _actionMap[458][AND] = ActionEntry(REDUCE, 315);
   _actionMap[458][CONCAT] = ActionEntry(REDUCE, 315);
   _actionMap[458][MINUS] = ActionEntry(REDUCE, 315);
   _actionMap[458][PLUS] = ActionEntry(REDUCE, 315);
   _actionMap[458][DESC] = ActionEntry(REDUCE, 315);
   _actionMap[458][ASC] = ActionEntry(REDUCE, 315);
   _actionMap[458][KSEP] = ActionEntry(REDUCE, 315);
   _actionMap[458][ROWLIMIT] = ActionEntry(REDUCE, 315);
   _actionMap[458][UNION] = ActionEntry(REDUCE, 315);
   _actionMap[458][ENDTOKEN] = ActionEntry(REDUCE, 315);
   _actionMap[458][RB] = ActionEntry(REDUCE, 315);
   _actionMap[458][SEMICOLON] = ActionEntry(REDUCE, 315);
   _actionMap[459][STAR] = ActionEntry(SHIFT, 286);
   _actionMap[459][DIVISION] = ActionEntry(SHIFT, 287);
   _actionMap[459][WHEN] = ActionEntry(REDUCE, 313);
   _actionMap[459][ELSE] = ActionEntry(REDUCE, 313);
   _actionMap[459][LEFT] = ActionEntry(REDUCE, 313);
   _actionMap[459][RIGHT] = ActionEntry(REDUCE, 313);
   _actionMap[459][INNER] = ActionEntry(REDUCE, 313);
   _actionMap[459][JOIN] = ActionEntry(REDUCE, 313);
   _actionMap[459][ORDER] = ActionEntry(REDUCE, 313);
   _actionMap[459][GROUP] = ActionEntry(REDUCE, 313);
   _actionMap[459][RETURNTOKEN] = ActionEntry(REDUCE, 313);
   _actionMap[459][WHERE] = ActionEntry(REDUCE, 313);
   _actionMap[459][AS] = ActionEntry(REDUCE, 313);
   _actionMap[459][FROM] = ActionEntry(REDUCE, 313);
   _actionMap[459][BEGIN] = ActionEntry(REDUCE, 313);
   _actionMap[459][THEN] = ActionEntry(REDUCE, 313);
   _actionMap[459][OR] = ActionEntry(REDUCE, 313);
   _actionMap[459][LIKE] = ActionEntry(REDUCE, 313);
   _actionMap[459][IS] = ActionEntry(REDUCE, 313);
   _actionMap[459][BETWEEN] = ActionEntry(REDUCE, 313);
   _actionMap[459][EQU] = ActionEntry(REDUCE, 313);
   _actionMap[459][NEGATION] = ActionEntry(REDUCE, 313);
   _actionMap[459][LT] = ActionEntry(REDUCE, 313);
   _actionMap[459][MT] = ActionEntry(REDUCE, 313);
   _actionMap[459][NOT] = ActionEntry(REDUCE, 313);
   _actionMap[459][INTOK] = ActionEntry(REDUCE, 313);
}
void Cego::loadParser154()
{
   _actionMap[459][END_TOKEN] = ActionEntry(REDUCE, 313);
   _actionMap[459][AND] = ActionEntry(REDUCE, 313);
   _actionMap[459][CONCAT] = ActionEntry(REDUCE, 313);
   _actionMap[459][MINUS] = ActionEntry(REDUCE, 313);
   _actionMap[459][PLUS] = ActionEntry(REDUCE, 313);
   _actionMap[459][DESC] = ActionEntry(REDUCE, 313);
   _actionMap[459][ASC] = ActionEntry(REDUCE, 313);
   _actionMap[459][KSEP] = ActionEntry(REDUCE, 313);
   _actionMap[459][ROWLIMIT] = ActionEntry(REDUCE, 313);
   _actionMap[459][UNION] = ActionEntry(REDUCE, 313);
   _actionMap[459][ENDTOKEN] = ActionEntry(REDUCE, 313);
   _actionMap[459][RB] = ActionEntry(REDUCE, 313);
   _actionMap[459][SEMICOLON] = ActionEntry(REDUCE, 313);
   _actionMap[460][STAR] = ActionEntry(SHIFT, 286);
   _actionMap[460][DIVISION] = ActionEntry(SHIFT, 287);
   _actionMap[460][WHEN] = ActionEntry(REDUCE, 312);
   _actionMap[460][ELSE] = ActionEntry(REDUCE, 312);
   _actionMap[460][LEFT] = ActionEntry(REDUCE, 312);
   _actionMap[460][RIGHT] = ActionEntry(REDUCE, 312);
   _actionMap[460][INNER] = ActionEntry(REDUCE, 312);
   _actionMap[460][JOIN] = ActionEntry(REDUCE, 312);
   _actionMap[460][ORDER] = ActionEntry(REDUCE, 312);
   _actionMap[460][GROUP] = ActionEntry(REDUCE, 312);
   _actionMap[460][RETURNTOKEN] = ActionEntry(REDUCE, 312);
   _actionMap[460][WHERE] = ActionEntry(REDUCE, 312);
   _actionMap[460][AS] = ActionEntry(REDUCE, 312);
   _actionMap[460][FROM] = ActionEntry(REDUCE, 312);
   _actionMap[460][BEGIN] = ActionEntry(REDUCE, 312);
   _actionMap[460][THEN] = ActionEntry(REDUCE, 312);
   _actionMap[460][OR] = ActionEntry(REDUCE, 312);
   _actionMap[460][LIKE] = ActionEntry(REDUCE, 312);
   _actionMap[460][IS] = ActionEntry(REDUCE, 312);
   _actionMap[460][BETWEEN] = ActionEntry(REDUCE, 312);
   _actionMap[460][EQU] = ActionEntry(REDUCE, 312);
   _actionMap[460][NEGATION] = ActionEntry(REDUCE, 312);
   _actionMap[460][LT] = ActionEntry(REDUCE, 312);
   _actionMap[460][MT] = ActionEntry(REDUCE, 312);
   _actionMap[460][NOT] = ActionEntry(REDUCE, 312);
   _actionMap[460][INTOK] = ActionEntry(REDUCE, 312);
   _actionMap[460][END_TOKEN] = ActionEntry(REDUCE, 312);
   _actionMap[460][AND] = ActionEntry(REDUCE, 312);
   _actionMap[460][CONCAT] = ActionEntry(REDUCE, 312);
   _actionMap[460][MINUS] = ActionEntry(REDUCE, 312);
   _actionMap[460][PLUS] = ActionEntry(REDUCE, 312);
   _actionMap[460][DESC] = ActionEntry(REDUCE, 312);
   _actionMap[460][ASC] = ActionEntry(REDUCE, 312);
   _actionMap[460][KSEP] = ActionEntry(REDUCE, 312);
   _actionMap[460][ROWLIMIT] = ActionEntry(REDUCE, 312);
   _actionMap[460][UNION] = ActionEntry(REDUCE, 312);
   _actionMap[460][ENDTOKEN] = ActionEntry(REDUCE, 312);
}
void Cego::loadParser155()
{
   _actionMap[460][RB] = ActionEntry(REDUCE, 312);
   _actionMap[460][SEMICOLON] = ActionEntry(REDUCE, 312);
   _actionMap[461][WHEN] = ActionEntry(REDUCE, 316);
   _actionMap[461][ELSE] = ActionEntry(REDUCE, 316);
   _actionMap[461][LEFT] = ActionEntry(REDUCE, 316);
   _actionMap[461][RIGHT] = ActionEntry(REDUCE, 316);
   _actionMap[461][INNER] = ActionEntry(REDUCE, 316);
   _actionMap[461][JOIN] = ActionEntry(REDUCE, 316);
   _actionMap[461][ORDER] = ActionEntry(REDUCE, 316);
   _actionMap[461][GROUP] = ActionEntry(REDUCE, 316);
   _actionMap[461][RETURNTOKEN] = ActionEntry(REDUCE, 316);
   _actionMap[461][WHERE] = ActionEntry(REDUCE, 316);
   _actionMap[461][FROM] = ActionEntry(REDUCE, 316);
   _actionMap[461][AS] = ActionEntry(REDUCE, 316);
   _actionMap[461][END_TOKEN] = ActionEntry(REDUCE, 316);
   _actionMap[461][BEGIN] = ActionEntry(REDUCE, 316);
   _actionMap[461][THEN] = ActionEntry(REDUCE, 316);
   _actionMap[461][AND] = ActionEntry(REDUCE, 316);
   _actionMap[461][OR] = ActionEntry(REDUCE, 316);
   _actionMap[461][INTOK] = ActionEntry(REDUCE, 316);
   _actionMap[461][NOT] = ActionEntry(REDUCE, 316);
   _actionMap[461][MT] = ActionEntry(REDUCE, 316);
   _actionMap[461][LT] = ActionEntry(REDUCE, 316);
   _actionMap[461][NEGATION] = ActionEntry(REDUCE, 316);
   _actionMap[461][EQU] = ActionEntry(REDUCE, 316);
   _actionMap[461][BETWEEN] = ActionEntry(REDUCE, 316);
   _actionMap[461][IS] = ActionEntry(REDUCE, 316);
   _actionMap[461][LIKE] = ActionEntry(REDUCE, 316);
   _actionMap[461][RB] = ActionEntry(REDUCE, 316);
   _actionMap[461][ENDTOKEN] = ActionEntry(REDUCE, 316);
   _actionMap[461][UNION] = ActionEntry(REDUCE, 316);
   _actionMap[461][ROWLIMIT] = ActionEntry(REDUCE, 316);
   _actionMap[461][KSEP] = ActionEntry(REDUCE, 316);
   _actionMap[461][ASC] = ActionEntry(REDUCE, 316);
   _actionMap[461][DESC] = ActionEntry(REDUCE, 316);
   _actionMap[461][PLUS] = ActionEntry(REDUCE, 316);
   _actionMap[461][MINUS] = ActionEntry(REDUCE, 316);
   _actionMap[461][CONCAT] = ActionEntry(REDUCE, 316);
   _actionMap[461][SEMICOLON] = ActionEntry(REDUCE, 316);
   _actionMap[461][DIVISION] = ActionEntry(REDUCE, 316);
   _actionMap[461][STAR] = ActionEntry(REDUCE, 316);
   _actionMap[462][WHEN] = ActionEntry(REDUCE, 317);
   _actionMap[462][ELSE] = ActionEntry(REDUCE, 317);
   _actionMap[462][LEFT] = ActionEntry(REDUCE, 317);
   _actionMap[462][RIGHT] = ActionEntry(REDUCE, 317);
   _actionMap[462][INNER] = ActionEntry(REDUCE, 317);
   _actionMap[462][JOIN] = ActionEntry(REDUCE, 317);
   _actionMap[462][ORDER] = ActionEntry(REDUCE, 317);
   _actionMap[462][GROUP] = ActionEntry(REDUCE, 317);
   _actionMap[462][RETURNTOKEN] = ActionEntry(REDUCE, 317);
}
void Cego::loadParser156()
{
   _actionMap[462][WHERE] = ActionEntry(REDUCE, 317);
   _actionMap[462][FROM] = ActionEntry(REDUCE, 317);
   _actionMap[462][AS] = ActionEntry(REDUCE, 317);
   _actionMap[462][END_TOKEN] = ActionEntry(REDUCE, 317);
   _actionMap[462][BEGIN] = ActionEntry(REDUCE, 317);
   _actionMap[462][THEN] = ActionEntry(REDUCE, 317);
   _actionMap[462][AND] = ActionEntry(REDUCE, 317);
   _actionMap[462][OR] = ActionEntry(REDUCE, 317);
   _actionMap[462][INTOK] = ActionEntry(REDUCE, 317);
   _actionMap[462][NOT] = ActionEntry(REDUCE, 317);
   _actionMap[462][MT] = ActionEntry(REDUCE, 317);
   _actionMap[462][LT] = ActionEntry(REDUCE, 317);
   _actionMap[462][NEGATION] = ActionEntry(REDUCE, 317);
   _actionMap[462][EQU] = ActionEntry(REDUCE, 317);
   _actionMap[462][BETWEEN] = ActionEntry(REDUCE, 317);
   _actionMap[462][IS] = ActionEntry(REDUCE, 317);
   _actionMap[462][LIKE] = ActionEntry(REDUCE, 317);
   _actionMap[462][RB] = ActionEntry(REDUCE, 317);
   _actionMap[462][ENDTOKEN] = ActionEntry(REDUCE, 317);
   _actionMap[462][UNION] = ActionEntry(REDUCE, 317);
   _actionMap[462][ROWLIMIT] = ActionEntry(REDUCE, 317);
   _actionMap[462][KSEP] = ActionEntry(REDUCE, 317);
   _actionMap[462][ASC] = ActionEntry(REDUCE, 317);
   _actionMap[462][DESC] = ActionEntry(REDUCE, 317);
   _actionMap[462][PLUS] = ActionEntry(REDUCE, 317);
   _actionMap[462][MINUS] = ActionEntry(REDUCE, 317);
   _actionMap[462][CONCAT] = ActionEntry(REDUCE, 317);
   _actionMap[462][SEMICOLON] = ActionEntry(REDUCE, 317);
   _actionMap[462][DIVISION] = ActionEntry(REDUCE, 317);
   _actionMap[462][STAR] = ActionEntry(REDUCE, 317);
   _actionMap[463][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[463][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[463][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[463][KSEP] = ActionEntry(REDUCE, 376);
   _actionMap[463][RB] = ActionEntry(REDUCE, 376);
   _actionMap[464][RB] = ActionEntry(SHIFT, 617);
   _actionMap[464][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[465][WHEN] = ActionEntry(REDUCE, 374);
   _actionMap[465][ELSE] = ActionEntry(REDUCE, 374);
   _actionMap[465][LEFT] = ActionEntry(REDUCE, 374);
   _actionMap[465][RIGHT] = ActionEntry(REDUCE, 374);
   _actionMap[465][INNER] = ActionEntry(REDUCE, 374);
   _actionMap[465][JOIN] = ActionEntry(REDUCE, 374);
   _actionMap[465][ORDER] = ActionEntry(REDUCE, 374);
   _actionMap[465][GROUP] = ActionEntry(REDUCE, 374);
   _actionMap[465][RETURNTOKEN] = ActionEntry(REDUCE, 374);
   _actionMap[465][WHERE] = ActionEntry(REDUCE, 374);
   _actionMap[465][FROM] = ActionEntry(REDUCE, 374);
   _actionMap[465][AS] = ActionEntry(REDUCE, 374);
   _actionMap[465][END_TOKEN] = ActionEntry(REDUCE, 374);
}
void Cego::loadParser157()
{
   _actionMap[465][BEGIN] = ActionEntry(REDUCE, 374);
   _actionMap[465][THEN] = ActionEntry(REDUCE, 374);
   _actionMap[465][AND] = ActionEntry(REDUCE, 374);
   _actionMap[465][OR] = ActionEntry(REDUCE, 374);
   _actionMap[465][INTOK] = ActionEntry(REDUCE, 374);
   _actionMap[465][NOT] = ActionEntry(REDUCE, 374);
   _actionMap[465][MT] = ActionEntry(REDUCE, 374);
   _actionMap[465][LT] = ActionEntry(REDUCE, 374);
   _actionMap[465][NEGATION] = ActionEntry(REDUCE, 374);
   _actionMap[465][EQU] = ActionEntry(REDUCE, 374);
   _actionMap[465][BETWEEN] = ActionEntry(REDUCE, 374);
   _actionMap[465][IS] = ActionEntry(REDUCE, 374);
   _actionMap[465][LIKE] = ActionEntry(REDUCE, 374);
   _actionMap[465][RB] = ActionEntry(REDUCE, 374);
   _actionMap[465][ENDTOKEN] = ActionEntry(REDUCE, 374);
   _actionMap[465][UNION] = ActionEntry(REDUCE, 374);
   _actionMap[465][ROWLIMIT] = ActionEntry(REDUCE, 374);
   _actionMap[465][KSEP] = ActionEntry(REDUCE, 374);
   _actionMap[465][ASC] = ActionEntry(REDUCE, 374);
   _actionMap[465][DESC] = ActionEntry(REDUCE, 374);
   _actionMap[465][PLUS] = ActionEntry(REDUCE, 374);
   _actionMap[465][MINUS] = ActionEntry(REDUCE, 374);
   _actionMap[465][DIVISION] = ActionEntry(REDUCE, 374);
   _actionMap[465][STAR] = ActionEntry(REDUCE, 374);
   _actionMap[465][CONCAT] = ActionEntry(REDUCE, 374);
   _actionMap[465][SEMICOLON] = ActionEntry(REDUCE, 374);
   _actionMap[466][RB] = ActionEntry(SHIFT, 618);
   _actionMap[466][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[467][RB] = ActionEntry(SHIFT, 619);
   _actionMap[467][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[467][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[467][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[468][RB] = ActionEntry(SHIFT, 620);
   _actionMap[468][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[469][RB] = ActionEntry(SHIFT, 621);
   _actionMap[469][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[470][RB] = ActionEntry(SHIFT, 622);
   _actionMap[470][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[471][RAB] = ActionEntry(SHIFT, 623);
   _actionMap[472][RB] = ActionEntry(SHIFT, 624);
   _actionMap[472][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[473][RB] = ActionEntry(SHIFT, 625);
   _actionMap[473][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[474][RAB] = ActionEntry(SHIFT, 626);
   _actionMap[475][RB] = ActionEntry(SHIFT, 627);
   _actionMap[475][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[476][RB] = ActionEntry(SHIFT, 628);
   _actionMap[476][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[477][RB] = ActionEntry(SHIFT, 629);
   _actionMap[477][KSEP] = ActionEntry(SHIFT, 616);
}
void Cego::loadParser158()
{
   _actionMap[478][RB] = ActionEntry(SHIFT, 630);
   _actionMap[478][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[478][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[478][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[479][RB] = ActionEntry(SHIFT, 631);
   _actionMap[480][RB] = ActionEntry(SHIFT, 632);
   _actionMap[480][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[481][RB] = ActionEntry(SHIFT, 633);
   _actionMap[481][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[482][RB] = ActionEntry(SHIFT, 634);
   _actionMap[482][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[483][LB] = ActionEntry(SHIFT, 635);
   _actionMap[484][RB] = ActionEntry(SHIFT, 636);
   _actionMap[485][RB] = ActionEntry(SHIFT, 637);
   _actionMap[485][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[486][RB] = ActionEntry(SHIFT, 638);
   _actionMap[486][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[487][RB] = ActionEntry(SHIFT, 639);
   _actionMap[487][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[488][RB] = ActionEntry(SHIFT, 640);
   _actionMap[488][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[489][RB] = ActionEntry(SHIFT, 641);
   _actionMap[489][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[490][RB] = ActionEntry(SHIFT, 642);
   _actionMap[490][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[491][RB] = ActionEntry(SHIFT, 643);
   _actionMap[491][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[492][RB] = ActionEntry(SHIFT, 644);
   _actionMap[492][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[493][RB] = ActionEntry(SHIFT, 645);
   _actionMap[493][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[494][RB] = ActionEntry(SHIFT, 646);
   _actionMap[494][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[495][RB] = ActionEntry(SHIFT, 647);
   _actionMap[495][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[495][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[495][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[496][RB] = ActionEntry(SHIFT, 648);
   _actionMap[496][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[496][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[496][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[497][RB] = ActionEntry(SHIFT, 649);
   _actionMap[497][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[498][RB] = ActionEntry(SHIFT, 650);
   _actionMap[499][RB] = ActionEntry(SHIFT, 651);
   _actionMap[499][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[500][RB] = ActionEntry(SHIFT, 652);
   _actionMap[500][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[501][RB] = ActionEntry(SHIFT, 653);
   _actionMap[501][KSEP] = ActionEntry(SHIFT, 616);
}
void Cego::loadParser159()
{
   _actionMap[502][RB] = ActionEntry(SHIFT, 654);
   _actionMap[502][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[503][RB] = ActionEntry(SHIFT, 655);
   _actionMap[503][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[504][RB] = ActionEntry(SHIFT, 656);
   _actionMap[504][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[505][RB] = ActionEntry(SHIFT, 657);
   _actionMap[505][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[506][RB] = ActionEntry(SHIFT, 658);
   _actionMap[506][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[507][KSEP] = ActionEntry(SHIFT, 659);
   _actionMap[508][RB] = ActionEntry(SHIFT, 660);
   _actionMap[508][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[509][RB] = ActionEntry(SHIFT, 661);
   _actionMap[509][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[509][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[509][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[510][RB] = ActionEntry(SHIFT, 662);
   _actionMap[510][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[511][RB] = ActionEntry(SHIFT, 663);
   _actionMap[511][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[512][RB] = ActionEntry(SHIFT, 664);
   _actionMap[512][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[513][RB] = ActionEntry(SHIFT, 665);
   _actionMap[513][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[514][RB] = ActionEntry(SHIFT, 666);
   _actionMap[514][KSEP] = ActionEntry(SHIFT, 616);
   _actionMap[515][WHEN] = ActionEntry(REDUCE, 325);
   _actionMap[515][ELSE] = ActionEntry(REDUCE, 325);
   _actionMap[515][AS] = ActionEntry(REDUCE, 325);
   _actionMap[515][FROM] = ActionEntry(REDUCE, 325);
   _actionMap[515][END_TOKEN] = ActionEntry(REDUCE, 325);
   _actionMap[515][BEGIN] = ActionEntry(REDUCE, 325);
   _actionMap[515][THEN] = ActionEntry(REDUCE, 325);
   _actionMap[515][LEFT] = ActionEntry(REDUCE, 325);
   _actionMap[515][RIGHT] = ActionEntry(REDUCE, 325);
   _actionMap[515][INNER] = ActionEntry(REDUCE, 325);
   _actionMap[515][JOIN] = ActionEntry(REDUCE, 325);
   _actionMap[515][ORDER] = ActionEntry(REDUCE, 325);
   _actionMap[515][GROUP] = ActionEntry(REDUCE, 325);
   _actionMap[515][RETURNTOKEN] = ActionEntry(REDUCE, 325);
   _actionMap[515][WHERE] = ActionEntry(REDUCE, 325);
   _actionMap[515][OR] = ActionEntry(REDUCE, 325);
   _actionMap[515][AND] = ActionEntry(REDUCE, 325);
   _actionMap[515][LIKE] = ActionEntry(REDUCE, 325);
   _actionMap[515][IS] = ActionEntry(REDUCE, 325);
   _actionMap[515][BETWEEN] = ActionEntry(REDUCE, 325);
   _actionMap[515][EQU] = ActionEntry(REDUCE, 325);
   _actionMap[515][NEGATION] = ActionEntry(REDUCE, 325);
   _actionMap[515][LT] = ActionEntry(REDUCE, 325);
}
void Cego::loadParser160()
{
   _actionMap[515][MT] = ActionEntry(REDUCE, 325);
   _actionMap[515][NOT] = ActionEntry(REDUCE, 325);
   _actionMap[515][INTOK] = ActionEntry(REDUCE, 325);
   _actionMap[515][DESC] = ActionEntry(REDUCE, 325);
   _actionMap[515][ASC] = ActionEntry(REDUCE, 325);
   _actionMap[515][KSEP] = ActionEntry(REDUCE, 325);
   _actionMap[515][ROWLIMIT] = ActionEntry(REDUCE, 325);
   _actionMap[515][UNION] = ActionEntry(REDUCE, 325);
   _actionMap[515][ENDTOKEN] = ActionEntry(REDUCE, 325);
   _actionMap[515][RB] = ActionEntry(REDUCE, 325);
   _actionMap[515][CONCAT] = ActionEntry(REDUCE, 325);
   _actionMap[515][STAR] = ActionEntry(REDUCE, 325);
   _actionMap[515][DIVISION] = ActionEntry(REDUCE, 325);
   _actionMap[515][MINUS] = ActionEntry(REDUCE, 325);
   _actionMap[515][PLUS] = ActionEntry(REDUCE, 325);
   _actionMap[515][SEMICOLON] = ActionEntry(REDUCE, 325);
   _actionMap[516][WHEN] = ActionEntry(REDUCE, 324);
   _actionMap[516][ELSE] = ActionEntry(REDUCE, 324);
   _actionMap[516][AS] = ActionEntry(REDUCE, 324);
   _actionMap[516][FROM] = ActionEntry(REDUCE, 324);
   _actionMap[516][END_TOKEN] = ActionEntry(REDUCE, 324);
   _actionMap[516][BEGIN] = ActionEntry(REDUCE, 324);
   _actionMap[516][THEN] = ActionEntry(REDUCE, 324);
   _actionMap[516][LEFT] = ActionEntry(REDUCE, 324);
   _actionMap[516][RIGHT] = ActionEntry(REDUCE, 324);
   _actionMap[516][INNER] = ActionEntry(REDUCE, 324);
   _actionMap[516][JOIN] = ActionEntry(REDUCE, 324);
   _actionMap[516][ORDER] = ActionEntry(REDUCE, 324);
   _actionMap[516][GROUP] = ActionEntry(REDUCE, 324);
   _actionMap[516][RETURNTOKEN] = ActionEntry(REDUCE, 324);
   _actionMap[516][WHERE] = ActionEntry(REDUCE, 324);
   _actionMap[516][OR] = ActionEntry(REDUCE, 324);
   _actionMap[516][AND] = ActionEntry(REDUCE, 324);
   _actionMap[516][LIKE] = ActionEntry(REDUCE, 324);
   _actionMap[516][IS] = ActionEntry(REDUCE, 324);
   _actionMap[516][BETWEEN] = ActionEntry(REDUCE, 324);
   _actionMap[516][EQU] = ActionEntry(REDUCE, 324);
   _actionMap[516][NEGATION] = ActionEntry(REDUCE, 324);
   _actionMap[516][LT] = ActionEntry(REDUCE, 324);
   _actionMap[516][MT] = ActionEntry(REDUCE, 324);
   _actionMap[516][NOT] = ActionEntry(REDUCE, 324);
   _actionMap[516][INTOK] = ActionEntry(REDUCE, 324);
   _actionMap[516][DESC] = ActionEntry(REDUCE, 324);
   _actionMap[516][ASC] = ActionEntry(REDUCE, 324);
   _actionMap[516][KSEP] = ActionEntry(REDUCE, 324);
   _actionMap[516][ROWLIMIT] = ActionEntry(REDUCE, 324);
   _actionMap[516][UNION] = ActionEntry(REDUCE, 324);
   _actionMap[516][ENDTOKEN] = ActionEntry(REDUCE, 324);
   _actionMap[516][RB] = ActionEntry(REDUCE, 324);
   _actionMap[516][CONCAT] = ActionEntry(REDUCE, 324);
}
void Cego::loadParser161()
{
   _actionMap[516][STAR] = ActionEntry(REDUCE, 324);
   _actionMap[516][DIVISION] = ActionEntry(REDUCE, 324);
   _actionMap[516][MINUS] = ActionEntry(REDUCE, 324);
   _actionMap[516][PLUS] = ActionEntry(REDUCE, 324);
   _actionMap[516][SEMICOLON] = ActionEntry(REDUCE, 324);
   _actionMap[517][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[517][MINUS] = ActionEntry(SHIFT, 668);
   _jumpMap[517][SignedInt] = 667;
   _actionMap[518][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[518][MINUS] = ActionEntry(SHIFT, 670);
   _jumpMap[518][SignedFloat] = 669;
   _actionMap[519][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[519][MINUS] = ActionEntry(SHIFT, 670);
   _jumpMap[519][SignedFloat] = 671;
   _actionMap[520][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[520][MINUS] = ActionEntry(SHIFT, 668);
   _jumpMap[520][SignedInt] = 672;
   _actionMap[521][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[521][MINUS] = ActionEntry(SHIFT, 668);
   _jumpMap[521][SignedInt] = 673;
   _actionMap[522][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[522][MINUS] = ActionEntry(SHIFT, 668);
   _jumpMap[522][SignedInt] = 674;
   _actionMap[523][IDENTIFIER] = ActionEntry(SHIFT, 675);
   _actionMap[524][IDENTIFIER] = ActionEntry(SHIFT, 676);
   _actionMap[525][IDENTIFIER] = ActionEntry(SHIFT, 677);
   _actionMap[526][IDENTIFIER] = ActionEntry(SHIFT, 678);
   _actionMap[527][IDENTIFIER] = ActionEntry(SHIFT, 679);
   _actionMap[528][IDENTIFIER] = ActionEntry(SHIFT, 680);
   _actionMap[529][IDENTIFIER] = ActionEntry(SHIFT, 681);
   _actionMap[530][IDENTIFIER] = ActionEntry(SHIFT, 682);
   _actionMap[531][SEMICOLON] = ActionEntry(REDUCE, 224);
   _actionMap[531][RB] = ActionEntry(REDUCE, 224);
   _actionMap[531][ENDTOKEN] = ActionEntry(REDUCE, 224);
   _actionMap[531][UNION] = ActionEntry(REDUCE, 224);
   _actionMap[531][ROWLIMIT] = ActionEntry(REDUCE, 224);
   _actionMap[531][ORDER] = ActionEntry(REDUCE, 224);
   _actionMap[531][GROUP] = ActionEntry(REDUCE, 224);
   _actionMap[531][WHERE] = ActionEntry(SHIFT, 432);
   _jumpMap[531][NoWhere] = 431;
   _jumpMap[531][WhereClause] = 683;
   _actionMap[532][WHERE] = ActionEntry(REDUCE, 178);
   _actionMap[532][RETURNTOKEN] = ActionEntry(REDUCE, 178);
   _actionMap[532][SEMICOLON] = ActionEntry(REDUCE, 178);
   _actionMap[532][GROUP] = ActionEntry(REDUCE, 178);
   _actionMap[532][ORDER] = ActionEntry(REDUCE, 178);
   _actionMap[532][ROWLIMIT] = ActionEntry(REDUCE, 178);
   _actionMap[532][UNION] = ActionEntry(REDUCE, 178);
   _actionMap[532][ENDTOKEN] = ActionEntry(REDUCE, 178);
   _actionMap[532][RB] = ActionEntry(REDUCE, 178);
}
void Cego::loadParser162()
{
   _actionMap[532][INNER] = ActionEntry(SHIFT, 686);
   _actionMap[532][JOIN] = ActionEntry(SHIFT, 687);
   _actionMap[532][LEFT] = ActionEntry(SHIFT, 688);
   _actionMap[532][RIGHT] = ActionEntry(SHIFT, 689);
   _jumpMap[532][InnerJoin] = 685;
   _jumpMap[532][JoinSpec] = 684;
   _actionMap[533][WHERE] = ActionEntry(REDUCE, 177);
   _actionMap[533][RETURNTOKEN] = ActionEntry(REDUCE, 177);
   _actionMap[533][SEMICOLON] = ActionEntry(REDUCE, 177);
   _actionMap[533][GROUP] = ActionEntry(REDUCE, 177);
   _actionMap[533][ORDER] = ActionEntry(REDUCE, 177);
   _actionMap[533][ROWLIMIT] = ActionEntry(REDUCE, 177);
   _actionMap[533][UNION] = ActionEntry(REDUCE, 177);
   _actionMap[533][ENDTOKEN] = ActionEntry(REDUCE, 177);
   _actionMap[533][RB] = ActionEntry(REDUCE, 177);
   _actionMap[534][KSEP] = ActionEntry(SHIFT, 691);
   _actionMap[534][RB] = ActionEntry(REDUCE, 190);
   _actionMap[534][ENDTOKEN] = ActionEntry(REDUCE, 190);
   _actionMap[534][UNION] = ActionEntry(REDUCE, 190);
   _actionMap[534][ROWLIMIT] = ActionEntry(REDUCE, 190);
   _actionMap[534][ORDER] = ActionEntry(REDUCE, 190);
   _actionMap[534][GROUP] = ActionEntry(REDUCE, 190);
   _actionMap[534][SEMICOLON] = ActionEntry(REDUCE, 190);
   _actionMap[534][RETURNTOKEN] = ActionEntry(REDUCE, 190);
   _actionMap[534][WHERE] = ActionEntry(REDUCE, 190);
   _actionMap[534][INNER] = ActionEntry(SHIFT, 686);
   _actionMap[534][JOIN] = ActionEntry(SHIFT, 687);
   _actionMap[534][LEFT] = ActionEntry(SHIFT, 688);
   _actionMap[534][RIGHT] = ActionEntry(SHIFT, 689);
   _jumpMap[534][InnerJoin] = 685;
   _jumpMap[534][JoinSpec] = 690;
   _actionMap[535][KSEP] = ActionEntry(REDUCE, 191);
   _actionMap[535][IDENTIFIER] = ActionEntry(SHIFT, 692);
   _actionMap[535][LEFT] = ActionEntry(REDUCE, 191);
   _actionMap[535][RIGHT] = ActionEntry(REDUCE, 191);
   _actionMap[535][INNER] = ActionEntry(REDUCE, 191);
   _actionMap[535][JOIN] = ActionEntry(REDUCE, 191);
   _actionMap[535][RB] = ActionEntry(REDUCE, 191);
   _actionMap[535][ENDTOKEN] = ActionEntry(REDUCE, 191);
   _actionMap[535][UNION] = ActionEntry(REDUCE, 191);
   _actionMap[535][ROWLIMIT] = ActionEntry(REDUCE, 191);
   _actionMap[535][ORDER] = ActionEntry(REDUCE, 191);
   _actionMap[535][GROUP] = ActionEntry(REDUCE, 191);
   _actionMap[535][SEMICOLON] = ActionEntry(REDUCE, 191);
   _actionMap[535][RETURNTOKEN] = ActionEntry(REDUCE, 191);
   _actionMap[535][WHERE] = ActionEntry(REDUCE, 191);
   _actionMap[535][ON] = ActionEntry(REDUCE, 191);
   _actionMap[536][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[536][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[536][INTVAL] = ActionEntry(SHIFT, 179);
}
void Cego::loadParser163()
{
   _actionMap[536][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[536][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[536][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[536][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[536][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[536][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[536][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[536][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[536][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[536][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[536][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[536][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[536][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[536][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[536][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[536][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[536][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[536][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[536][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[536][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[536][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[536][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[536][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[536][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[536][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[536][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[536][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[536][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[536][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[536][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[536][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[536][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[536][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[536][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[536][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[536][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[536][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[536][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[536][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[536][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[536][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[536][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[536][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[536][LB] = ActionEntry(SHIFT, 177);
   _actionMap[536][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[536][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[536][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[536][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[536][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[536][BLOB] = ActionEntry(SHIFT, 129);
}
void Cego::loadParser164()
{
   _actionMap[536][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[536][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[536][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[536][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[536][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[536][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[536][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[536][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[536][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[536][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[536][ObjSpec] = 122;
   _jumpMap[536][Constant] = 121;
   _jumpMap[536][SignedFloat] = 120;
   _jumpMap[536][SignedInt] = 119;
   _jumpMap[536][Attribute] = 118;
   _jumpMap[536][Function] = 117;
   _jumpMap[536][Factor] = 116;
   _jumpMap[536][Term] = 115;
   _jumpMap[536][Expr] = 363;
   _jumpMap[536][SelectItem] = 693;
   _jumpMap[536][CasePrepare] = 113;
   _jumpMap[536][CaseClause] = 112;
   _actionMap[537][KSEP] = ActionEntry(REDUCE, 176);
   _actionMap[537][FROM] = ActionEntry(REDUCE, 176);
   _actionMap[537][RB] = ActionEntry(REDUCE, 176);
   _actionMap[537][SEMICOLON] = ActionEntry(REDUCE, 176);
   _actionMap[537][ENDTOKEN] = ActionEntry(REDUCE, 176);
   _actionMap[538][KSEP] = ActionEntry(REDUCE, 195);
   _actionMap[538][FROM] = ActionEntry(REDUCE, 195);
   _actionMap[538][RB] = ActionEntry(REDUCE, 195);
   _actionMap[538][SEMICOLON] = ActionEntry(REDUCE, 195);
   _actionMap[538][ENDTOKEN] = ActionEntry(REDUCE, 195);
   _actionMap[539][IDENTIFIER] = ActionEntry(SHIFT, 694);
   _actionMap[540][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[540][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[540][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[540][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[540][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[540][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[540][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[540][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[540][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[540][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[540][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[540][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[540][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[540][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[540][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[540][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[540][LEFT] = ActionEntry(SHIFT, 148);
}
void Cego::loadParser165()
{
   _actionMap[540][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[540][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[540][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[540][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[540][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[540][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[540][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[540][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[540][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[540][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[540][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[540][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[540][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[540][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[540][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[540][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[540][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[540][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[540][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[540][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[540][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[540][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[540][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[540][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[540][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[540][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[540][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[540][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[540][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[540][LB] = ActionEntry(SHIFT, 177);
   _actionMap[540][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[540][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[540][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[540][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[540][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[540][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[540][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[540][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[540][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[540][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[540][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[540][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[540][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[540][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[540][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[540][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[540][ObjSpec] = 122;
   _jumpMap[540][Constant] = 121;
   _jumpMap[540][SignedFloat] = 120;
   _jumpMap[540][SignedInt] = 119;
}
void Cego::loadParser166()
{
   _jumpMap[540][Attribute] = 118;
   _jumpMap[540][Function] = 117;
   _jumpMap[540][Factor] = 116;
   _jumpMap[540][Term] = 115;
   _jumpMap[540][Expr] = 695;
   _jumpMap[540][CasePrepare] = 113;
   _jumpMap[540][CaseClause] = 112;
   _actionMap[541][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[541][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[541][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[541][SEMICOLON] = ActionEntry(REDUCE, 90);
   _actionMap[542][KSEP] = ActionEntry(SHIFT, 697);
   _actionMap[542][SEMICOLON] = ActionEntry(REDUCE, 224);
   _actionMap[542][RETURNTOKEN] = ActionEntry(REDUCE, 224);
   _actionMap[542][WHERE] = ActionEntry(SHIFT, 432);
   _jumpMap[542][NoWhere] = 431;
   _jumpMap[542][WhereClause] = 696;
   _actionMap[543][KSEP] = ActionEntry(REDUCE, 156);
   _actionMap[543][WHERE] = ActionEntry(REDUCE, 156);
   _actionMap[543][RETURNTOKEN] = ActionEntry(REDUCE, 156);
   _actionMap[543][SEMICOLON] = ActionEntry(REDUCE, 156);
   _actionMap[543][GROUP] = ActionEntry(REDUCE, 156);
   _actionMap[543][ORDER] = ActionEntry(REDUCE, 156);
   _actionMap[543][ROWLIMIT] = ActionEntry(REDUCE, 156);
   _actionMap[543][UNION] = ActionEntry(REDUCE, 156);
   _actionMap[543][ENDTOKEN] = ActionEntry(REDUCE, 156);
   _actionMap[543][RB] = ActionEntry(REDUCE, 156);
   _actionMap[544][EQU] = ActionEntry(SHIFT, 698);
   _actionMap[545][LB] = ActionEntry(SHIFT, 699);
   _actionMap[220][SEMICOLON] = ActionEntry(REDUCE, 84);
   _actionMap[221][SEMICOLON] = ActionEntry(REDUCE, 85);
   _actionMap[222][SEMICOLON] = ActionEntry(REDUCE, 78);
   _actionMap[223][SEMICOLON] = ActionEntry(REDUCE, 82);
   _actionMap[224][SEMICOLON] = ActionEntry(REDUCE, 94);
   _actionMap[225][TO] = ActionEntry(REDUCE, 96);
   _actionMap[225][SEMICOLON] = ActionEntry(REDUCE, 96);
   _actionMap[226][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[226][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[226][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[226][ObjSpec] = 383;
   _actionMap[227][SEMICOLON] = ActionEntry(REDUCE, 80);
   _actionMap[228][SEMICOLON] = ActionEntry(REDUCE, 77);
   _actionMap[229][SEMICOLON] = ActionEntry(REDUCE, 83);
   _actionMap[230][SEMICOLON] = ActionEntry(REDUCE, 79);
   _actionMap[231][ADD] = ActionEntry(SHIFT, 386);
   _actionMap[231][DROP] = ActionEntry(SHIFT, 387);
   _actionMap[231][MODIFY] = ActionEntry(SHIFT, 388);
   _actionMap[231][RENAME] = ActionEntry(SHIFT, 389);
   _jumpMap[231][AlterOption] = 385;
   _jumpMap[231][AlterList] = 384;
}
void Cego::loadParser167()
{
   _actionMap[232][BY] = ActionEntry(SHIFT, 390);
   _actionMap[233][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[233][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[233][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[233][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[233][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[233][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[233][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[233][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[233][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[233][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[233][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[233][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[233][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[233][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[233][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[233][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[233][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[233][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[233][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[233][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[233][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[233][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[233][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[233][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[233][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[233][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[233][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[233][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[233][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[233][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[233][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[233][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[233][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[233][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[233][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[233][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[233][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[233][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[233][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[233][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[233][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[233][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[233][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[233][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[233][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[233][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[233][LB] = ActionEntry(SHIFT, 177);
   _actionMap[233][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[233][SYSDATE] = ActionEntry(SHIFT, 170);
}
void Cego::loadParser168()
{
   _actionMap[233][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[233][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[233][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[233][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[233][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[233][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[233][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[233][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[233][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[233][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[233][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[233][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[233][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[233][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[233][RB] = ActionEntry(REDUCE, 280);
   _jumpMap[233][ObjSpec] = 122;
   _jumpMap[233][Constant] = 121;
   _jumpMap[233][SignedFloat] = 120;
   _jumpMap[233][SignedInt] = 119;
   _jumpMap[233][Attribute] = 118;
   _jumpMap[233][Function] = 117;
   _jumpMap[233][Factor] = 116;
   _jumpMap[233][Term] = 115;
   _jumpMap[233][Expr] = 393;
   _jumpMap[233][ProcValueList] = 392;
   _jumpMap[233][ProcValueListOpt] = 391;
   _jumpMap[233][CasePrepare] = 113;
   _jumpMap[233][CaseClause] = 112;
   _actionMap[234][SEMICOLON] = ActionEntry(REDUCE, 92);
   _actionMap[235][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[235][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[235][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[235][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[235][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[235][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[235][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[235][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[235][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[235][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[235][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[235][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[235][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[235][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[235][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[235][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[235][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[235][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[235][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[235][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[235][REPLACE] = ActionEntry(SHIFT, 162);
}
void Cego::loadParser169()
{
   _actionMap[235][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[235][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[235][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[235][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[235][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[235][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[235][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[235][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[235][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[235][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[235][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[235][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[235][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[235][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[235][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[235][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[235][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[235][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[235][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[235][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[235][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[235][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[235][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[235][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[235][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[235][LB] = ActionEntry(SHIFT, 177);
   _actionMap[235][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[235][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[235][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[235][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[235][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[235][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[235][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[235][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[235][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[235][VARREF] = ActionEntry(SHIFT, 418);
   _actionMap[235][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[235][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[235][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[235][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[235][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[235][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[235][IF] = ActionEntry(SHIFT, 412);
   _actionMap[235][BEGIN] = ActionEntry(SHIFT, 409);
   _actionMap[235][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[235][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[235][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[235][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[235][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[235][UPDATE] = ActionEntry(SHIFT, 43);
}
void Cego::loadParser170()
{
   _actionMap[235][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[235][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[235][VAR] = ActionEntry(SHIFT, 416);
   _actionMap[235][CURSOR] = ActionEntry(SHIFT, 411);
   _actionMap[235][CLOSE] = ActionEntry(SHIFT, 410);
   _actionMap[235][NOOP] = ActionEntry(SHIFT, 413);
   _actionMap[235][THROW] = ActionEntry(SHIFT, 415);
   _actionMap[235][RETURNTOKEN] = ActionEntry(SHIFT, 414);
   _actionMap[235][WHILE] = ActionEntry(SHIFT, 417);
   _jumpMap[235][ObjSpec] = 122;
   _jumpMap[235][Constant] = 121;
   _jumpMap[235][SignedFloat] = 120;
   _jumpMap[235][SignedInt] = 119;
   _jumpMap[235][Attribute] = 118;
   _jumpMap[235][Function] = 117;
   _jumpMap[235][Factor] = 116;
   _jumpMap[235][Term] = 115;
   _jumpMap[235][Expr] = 408;
   _jumpMap[235][ProcStatement] = 407;
   _jumpMap[235][ProcIfPart] = 406;
   _jumpMap[235][ProcBlockStart] = 405;
   _jumpMap[235][ProcStatementList] = 404;
   _jumpMap[235][ProcStmtBlock] = 403;
   _jumpMap[235][DeleteStatement] = 402;
   _jumpMap[235][UpdateStatement] = 401;
   _jumpMap[235][InsertStatement] = 400;
   _jumpMap[235][UnlockStatement] = 399;
   _jumpMap[235][LockStatement] = 398;
   _jumpMap[235][RollbackStatement] = 397;
   _jumpMap[235][CommitStatement] = 396;
   _jumpMap[235][StartStatement] = 395;
   _jumpMap[235][CasePrepare] = 113;
   _jumpMap[235][CaseClause] = 112;
   _actionMap[236][IDENTIFIER] = ActionEntry(SHIFT, 419);
   _actionMap[237][ON] = ActionEntry(REDUCE, 134);
   _actionMap[237][IDENTIFIER] = ActionEntry(REDUCE, 134);
   _actionMap[238][ON] = ActionEntry(REDUCE, 133);
   _actionMap[238][IDENTIFIER] = ActionEntry(REDUCE, 133);
   _actionMap[239][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[239][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[239][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[239][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[239][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[239][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[239][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[239][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[239][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[239][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[239][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[239][DATE2LONG] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser171()
{
   _actionMap[239][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[239][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[239][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[239][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[239][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[239][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[239][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[239][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[239][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[239][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[239][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[239][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[239][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[239][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[239][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[239][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[239][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[239][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[239][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[239][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[239][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[239][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[239][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[239][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[239][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[239][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[239][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[239][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[239][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[239][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[239][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[239][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[239][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[239][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[239][LB] = ActionEntry(SHIFT, 177);
   _actionMap[239][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[239][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[239][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[239][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[239][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[239][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[239][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[239][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[239][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[239][VARREF] = ActionEntry(SHIFT, 418);
   _actionMap[239][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[239][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[239][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[239][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[239][MIN] = ActionEntry(SHIFT, 154);
}
void Cego::loadParser172()
{
   _actionMap[239][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[239][IF] = ActionEntry(SHIFT, 412);
   _actionMap[239][BEGIN] = ActionEntry(SHIFT, 409);
   _actionMap[239][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[239][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[239][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[239][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[239][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[239][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[239][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[239][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[239][VAR] = ActionEntry(SHIFT, 416);
   _actionMap[239][CURSOR] = ActionEntry(SHIFT, 411);
   _actionMap[239][CLOSE] = ActionEntry(SHIFT, 410);
   _actionMap[239][NOOP] = ActionEntry(SHIFT, 413);
   _actionMap[239][THROW] = ActionEntry(SHIFT, 415);
   _actionMap[239][RETURNTOKEN] = ActionEntry(SHIFT, 414);
   _actionMap[239][WHILE] = ActionEntry(SHIFT, 417);
   _jumpMap[239][ObjSpec] = 122;
   _jumpMap[239][Constant] = 121;
   _jumpMap[239][SignedFloat] = 120;
   _jumpMap[239][SignedInt] = 119;
   _jumpMap[239][Attribute] = 118;
   _jumpMap[239][Function] = 117;
   _jumpMap[239][Factor] = 116;
   _jumpMap[239][Term] = 115;
   _jumpMap[239][Expr] = 408;
   _jumpMap[239][ProcStatement] = 407;
   _jumpMap[239][ProcIfPart] = 406;
   _jumpMap[239][ProcBlockStart] = 405;
   _jumpMap[239][ProcStatementList] = 404;
   _jumpMap[239][ProcStmtBlock] = 420;
   _jumpMap[239][DeleteStatement] = 402;
   _jumpMap[239][UpdateStatement] = 401;
   _jumpMap[239][InsertStatement] = 400;
   _jumpMap[239][UnlockStatement] = 399;
   _jumpMap[239][LockStatement] = 398;
   _jumpMap[239][RollbackStatement] = 397;
   _jumpMap[239][CommitStatement] = 396;
   _jumpMap[239][StartStatement] = 395;
   _jumpMap[239][CasePrepare] = 113;
   _jumpMap[239][CaseClause] = 112;
   _actionMap[240][ON] = ActionEntry(SHIFT, 421);
   _actionMap[241][SEMICOLON] = ActionEntry(REDUCE, 93);
   _actionMap[242][ON] = ActionEntry(SHIFT, 422);
   _actionMap[243][LB] = ActionEntry(SHIFT, 423);
   _actionMap[244][LB] = ActionEntry(SHIFT, 424);
   _actionMap[245][BEFORE] = ActionEntry(SHIFT, 427);
   _actionMap[245][AFTER] = ActionEntry(SHIFT, 426);
   _jumpMap[245][TriggerEvent] = 425;
}
void Cego::loadParser173()
{
   _actionMap[246][AS] = ActionEntry(SHIFT, 428);
   _actionMap[247][IDENTIFIER] = ActionEntry(SHIFT, 381);
   _actionMap[247][WHERE] = ActionEntry(REDUCE, 167);
   _actionMap[247][RETURNTOKEN] = ActionEntry(REDUCE, 167);
   _actionMap[247][SEMICOLON] = ActionEntry(REDUCE, 167);
   _actionMap[247][GROUP] = ActionEntry(REDUCE, 167);
   _actionMap[247][ORDER] = ActionEntry(REDUCE, 167);
   _actionMap[247][ROWLIMIT] = ActionEntry(REDUCE, 167);
   _actionMap[247][UNION] = ActionEntry(REDUCE, 167);
   _actionMap[247][ENDTOKEN] = ActionEntry(REDUCE, 167);
   _actionMap[247][RB] = ActionEntry(REDUCE, 167);
   _jumpMap[247][NoWhere] = 431;
   _jumpMap[247][WhereClause] = 430;
   _jumpMap[247][UpdDelAlias] = 429;
   _actionMap[248][SEMICOLON] = ActionEntry(REDUCE, 25);
   _actionMap[249][SEMICOLON] = ActionEntry(REDUCE, 29);
   _actionMap[250][SEMICOLON] = ActionEntry(REDUCE, 24);
   _actionMap[251][SEMICOLON] = ActionEntry(REDUCE, 28);
   _actionMap[252][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[252][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[252][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[252][ObjSpec] = 433;
   _actionMap[253][SEMICOLON] = ActionEntry(REDUCE, 30);
   _actionMap[254][SEMICOLON] = ActionEntry(REDUCE, 23);
   _actionMap[255][SEMICOLON] = ActionEntry(REDUCE, 26);
   _actionMap[256][COUNTER] = ActionEntry(REDUCE, 87);
   _actionMap[256][ALIAS] = ActionEntry(REDUCE, 87);
   _actionMap[256][BTREE] = ActionEntry(REDUCE, 87);
   _actionMap[256][INDEX] = ActionEntry(REDUCE, 87);
   _actionMap[256][TRIGGER] = ActionEntry(REDUCE, 87);
   _actionMap[256][CHECK] = ActionEntry(REDUCE, 87);
   _actionMap[256][FOREIGN] = ActionEntry(REDUCE, 87);
   _actionMap[256][PROCEDURE] = ActionEntry(REDUCE, 87);
   _actionMap[256][VIEW] = ActionEntry(REDUCE, 87);
   _actionMap[256][AVLTREE] = ActionEntry(REDUCE, 87);
   _actionMap[256][TABLE] = ActionEntry(REDUCE, 87);
   _actionMap[257][LB] = ActionEntry(SHIFT, 438);
   _actionMap[257][VALUES] = ActionEntry(REDUCE, 145);
   _actionMap[257][SELECT] = ActionEntry(REDUCE, 145);
   _jumpMap[257][SelectStatement] = 436;
   _jumpMap[257][InsertPrepare] = 435;
   _jumpMap[257][InsertArgSpec] = 434;
   _actionMap[258][SEMICOLON] = ActionEntry(REDUCE, 98);
   _actionMap[258][IDENTIFIER] = ActionEntry(REDUCE, 98);
   _actionMap[259][SEMICOLON] = ActionEntry(REDUCE, 7);
   _actionMap[260][IDENTIFIER] = ActionEntry(SHIFT, 439);
   _actionMap[261][SEMICOLON] = ActionEntry(REDUCE, 14);
   _actionMap[262][SEMICOLON] = ActionEntry(REDUCE, 6);
   _actionMap[263][SEMICOLON] = ActionEntry(REDUCE, 12);
   _actionMap[264][SEMICOLON] = ActionEntry(REDUCE, 9);
}
void Cego::loadParser174()
{
   _actionMap[265][SEMICOLON] = ActionEntry(REDUCE, 8);
   _actionMap[266][SEMICOLON] = ActionEntry(REDUCE, 4);
   _actionMap[267][SEMICOLON] = ActionEntry(REDUCE, 10);
   _actionMap[268][SEMICOLON] = ActionEntry(REDUCE, 3);
   _actionMap[269][SEMICOLON] = ActionEntry(REDUCE, 11);
   _actionMap[270][SEMICOLON] = ActionEntry(REDUCE, 13);
   _actionMap[271][SEMICOLON] = ActionEntry(REDUCE, 5);
   _actionMap[272][AND] = ActionEntry(SHIFT, 440);
   _actionMap[272][OR] = ActionEntry(SHIFT, 441);
   _actionMap[272][SEMICOLON] = ActionEntry(REDUCE, 73);
   _actionMap[273][LEFT] = ActionEntry(REDUCE, 298);
   _actionMap[273][RIGHT] = ActionEntry(REDUCE, 298);
   _actionMap[273][INNER] = ActionEntry(REDUCE, 298);
   _actionMap[273][JOIN] = ActionEntry(REDUCE, 298);
   _actionMap[273][ENDTOKEN] = ActionEntry(REDUCE, 298);
   _actionMap[273][UNION] = ActionEntry(REDUCE, 298);
   _actionMap[273][ROWLIMIT] = ActionEntry(REDUCE, 298);
   _actionMap[273][ORDER] = ActionEntry(REDUCE, 298);
   _actionMap[273][GROUP] = ActionEntry(REDUCE, 298);
   _actionMap[273][SEMICOLON] = ActionEntry(REDUCE, 298);
   _actionMap[273][RETURNTOKEN] = ActionEntry(REDUCE, 298);
   _actionMap[273][WHERE] = ActionEntry(REDUCE, 298);
   _actionMap[273][RB] = ActionEntry(REDUCE, 298);
   _actionMap[273][BEGIN] = ActionEntry(REDUCE, 298);
   _actionMap[273][THEN] = ActionEntry(REDUCE, 298);
   _actionMap[273][OR] = ActionEntry(REDUCE, 298);
   _actionMap[273][AND] = ActionEntry(REDUCE, 298);
   _actionMap[274][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[274][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[274][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[274][INTOK] = ActionEntry(SHIFT, 444);
   _actionMap[274][NOT] = ActionEntry(SHIFT, 447);
   _actionMap[274][BETWEEN] = ActionEntry(SHIFT, 443);
   _actionMap[274][IS] = ActionEntry(SHIFT, 445);
   _actionMap[274][LIKE] = ActionEntry(SHIFT, 446);
   _actionMap[274][LEFT] = ActionEntry(REDUCE, 310);
   _actionMap[274][RIGHT] = ActionEntry(REDUCE, 310);
   _actionMap[274][INNER] = ActionEntry(REDUCE, 310);
   _actionMap[274][JOIN] = ActionEntry(REDUCE, 310);
   _actionMap[274][ENDTOKEN] = ActionEntry(REDUCE, 310);
   _actionMap[274][UNION] = ActionEntry(REDUCE, 310);
   _actionMap[274][ROWLIMIT] = ActionEntry(REDUCE, 310);
   _actionMap[274][ORDER] = ActionEntry(REDUCE, 310);
   _actionMap[274][GROUP] = ActionEntry(REDUCE, 310);
   _actionMap[274][SEMICOLON] = ActionEntry(REDUCE, 310);
   _actionMap[274][RETURNTOKEN] = ActionEntry(REDUCE, 310);
   _actionMap[274][WHERE] = ActionEntry(REDUCE, 310);
   _actionMap[274][RB] = ActionEntry(REDUCE, 310);
   _actionMap[274][BEGIN] = ActionEntry(REDUCE, 310);
   _actionMap[274][THEN] = ActionEntry(REDUCE, 310);
}
void Cego::loadParser175()
{
   _actionMap[274][AND] = ActionEntry(REDUCE, 310);
   _actionMap[274][OR] = ActionEntry(REDUCE, 310);
   _actionMap[274][EQU] = ActionEntry(SHIFT, 448);
   _actionMap[274][NEGATION] = ActionEntry(SHIFT, 451);
   _actionMap[274][LT] = ActionEntry(SHIFT, 449);
   _actionMap[274][MT] = ActionEntry(SHIFT, 450);
   _jumpMap[274][Comparison] = 442;
   _actionMap[275][LB] = ActionEntry(SHIFT, 452);
   _actionMap[276][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[276][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[276][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[276][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[276][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[276][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[276][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[276][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[276][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[276][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[276][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[276][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[276][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[276][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[276][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[276][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[276][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[276][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[276][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[276][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[276][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[276][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[276][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[276][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[276][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[276][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[276][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[276][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[276][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[276][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[276][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[276][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[276][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[276][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[276][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[276][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[276][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[276][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[276][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[276][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[276][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[276][SETCOUNT] = ActionEntry(SHIFT, 167);
}
void Cego::loadParser176()
{
   _actionMap[276][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[276][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[276][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[276][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[276][LB] = ActionEntry(SHIFT, 177);
   _actionMap[276][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[276][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[276][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[276][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[276][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[276][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[276][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[276][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[276][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[276][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[276][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[276][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[276][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[276][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[276][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[276][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[276][EXISTS] = ActionEntry(SHIFT, 275);
   _actionMap[276][NOT] = ActionEntry(SHIFT, 276);
   _jumpMap[276][ObjSpec] = 122;
   _jumpMap[276][Constant] = 121;
   _jumpMap[276][SignedFloat] = 120;
   _jumpMap[276][SignedInt] = 119;
   _jumpMap[276][Attribute] = 118;
   _jumpMap[276][Function] = 117;
   _jumpMap[276][Factor] = 116;
   _jumpMap[276][Term] = 115;
   _jumpMap[276][Expr] = 274;
   _jumpMap[276][Predicate] = 453;
   _jumpMap[276][CasePrepare] = 113;
   _jumpMap[276][CaseClause] = 112;
   _actionMap[277][AS] = ActionEntry(SHIFT, 454);
   _actionMap[278][SEMICOLON] = ActionEntry(REDUCE, 140);
   _actionMap[279][SEMICOLON] = ActionEntry(REDUCE, 141);
   _actionMap[280][ELSE] = ActionEntry(SHIFT, 456);
   _actionMap[280][WHEN] = ActionEntry(SHIFT, 282);
   _jumpMap[280][CaseCondition] = 455;
   _actionMap[281][WHEN] = ActionEntry(REDUCE, 111);
   _actionMap[281][ELSE] = ActionEntry(REDUCE, 111);
   _actionMap[282][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[282][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[282][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[282][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[282][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[282][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[282][RTRIM] = ActionEntry(SHIFT, 165);
}
void Cego::loadParser177()
{
   _actionMap[282][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[282][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[282][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[282][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[282][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[282][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[282][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[282][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[282][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[282][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[282][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[282][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[282][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[282][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[282][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[282][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[282][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[282][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[282][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[282][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[282][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[282][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[282][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[282][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[282][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[282][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[282][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[282][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[282][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[282][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[282][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[282][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[282][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[282][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[282][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[282][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[282][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[282][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[282][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[282][LB] = ActionEntry(SHIFT, 177);
   _actionMap[282][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[282][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[282][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[282][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[282][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[282][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[282][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[282][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[282][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[282][VARREF] = ActionEntry(SHIFT, 182);
}
void Cego::loadParser178()
{
   _actionMap[282][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[282][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[282][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[282][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[282][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[282][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[282][EXISTS] = ActionEntry(SHIFT, 275);
   _actionMap[282][NOT] = ActionEntry(SHIFT, 276);
   _jumpMap[282][ObjSpec] = 122;
   _jumpMap[282][Constant] = 121;
   _jumpMap[282][SignedFloat] = 120;
   _jumpMap[282][SignedInt] = 119;
   _jumpMap[282][Attribute] = 118;
   _jumpMap[282][Function] = 117;
   _jumpMap[282][Factor] = 116;
   _jumpMap[282][Term] = 115;
   _jumpMap[282][Expr] = 274;
   _jumpMap[282][Predicate] = 273;
   _jumpMap[282][Condition] = 457;
   _jumpMap[282][CasePrepare] = 113;
   _jumpMap[282][CaseClause] = 112;
   _actionMap[283][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[283][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[283][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[283][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[283][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[283][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[283][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[283][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[283][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[283][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[283][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[283][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[283][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[283][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[283][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[283][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[283][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[283][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[283][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[283][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[283][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[283][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[283][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[283][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[283][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[283][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[283][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[283][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[283][STR2LONG] = ActionEntry(SHIFT, 172);
}
void Cego::loadParser179()
{
   _actionMap[283][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[283][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[283][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[283][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[283][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[283][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[283][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[283][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[283][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[283][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[283][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[283][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[283][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[283][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[283][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[283][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[283][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[283][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[283][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[283][LB] = ActionEntry(SHIFT, 177);
   _actionMap[283][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[283][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[283][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[283][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[283][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[283][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[283][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[283][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[283][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[283][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[283][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[283][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[283][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[283][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[283][ObjSpec] = 122;
   _jumpMap[283][Constant] = 121;
   _jumpMap[283][SignedFloat] = 120;
   _jumpMap[283][SignedInt] = 119;
   _jumpMap[283][Attribute] = 118;
   _jumpMap[283][Function] = 117;
   _jumpMap[283][Factor] = 116;
   _jumpMap[283][Term] = 458;
   _jumpMap[283][CasePrepare] = 113;
   _jumpMap[283][CaseClause] = 112;
   _actionMap[284][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[284][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[284][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[284][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[284][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[284][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
}
void Cego::loadParser180()
{
   _actionMap[284][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[284][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[284][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[284][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[284][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[284][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[284][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[284][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[284][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[284][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[284][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[284][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[284][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[284][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[284][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[284][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[284][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[284][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[284][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[284][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[284][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[284][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[284][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[284][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[284][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[284][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[284][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[284][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[284][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[284][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[284][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[284][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[284][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[284][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[284][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[284][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[284][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[284][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[284][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[284][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[284][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[284][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[284][LB] = ActionEntry(SHIFT, 177);
   _actionMap[284][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[284][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[284][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[284][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[284][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[284][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[284][CLOB] = ActionEntry(SHIFT, 133);
}
void Cego::loadParser181()
{
   _actionMap[284][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[284][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[284][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[284][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[284][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[284][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[284][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[284][ObjSpec] = 122;
   _jumpMap[284][Constant] = 121;
   _jumpMap[284][SignedFloat] = 120;
   _jumpMap[284][SignedInt] = 119;
   _jumpMap[284][Attribute] = 118;
   _jumpMap[284][Function] = 117;
   _jumpMap[284][Factor] = 116;
   _jumpMap[284][Term] = 459;
   _jumpMap[284][CasePrepare] = 113;
   _jumpMap[284][CaseClause] = 112;
   _actionMap[285][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[285][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[285][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[285][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[285][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[285][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[285][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[285][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[285][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[285][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[285][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[285][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[285][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[285][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[285][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[285][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[285][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[285][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[285][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[285][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[285][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[285][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[285][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[285][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[285][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[285][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[285][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[285][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[285][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[285][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[285][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[285][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[285][DIV] = ActionEntry(SHIFT, 140);
}
void Cego::loadParser182()
{
   _actionMap[285][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[285][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[285][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[285][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[285][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[285][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[285][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[285][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[285][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[285][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[285][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[285][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[285][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[285][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[285][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[285][LB] = ActionEntry(SHIFT, 177);
   _actionMap[285][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[285][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[285][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[285][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[285][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[285][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[285][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[285][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[285][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[285][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[285][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[285][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[285][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[285][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[285][ObjSpec] = 122;
   _jumpMap[285][Constant] = 121;
   _jumpMap[285][SignedFloat] = 120;
   _jumpMap[285][SignedInt] = 119;
   _jumpMap[285][Attribute] = 118;
   _jumpMap[285][Function] = 117;
   _jumpMap[285][Factor] = 116;
   _jumpMap[285][Term] = 460;
   _jumpMap[285][CasePrepare] = 113;
   _jumpMap[285][CaseClause] = 112;
   _actionMap[286][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[286][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[286][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[286][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[286][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[286][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[286][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[286][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[286][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[286][TRIM] = ActionEntry(SHIFT, 173);
}
void Cego::loadParser183()
{
   _actionMap[286][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[286][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[286][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[286][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[286][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[286][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[286][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[286][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[286][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[286][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[286][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[286][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[286][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[286][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[286][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[286][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[286][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[286][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[286][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[286][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[286][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[286][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[286][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[286][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[286][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[286][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[286][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[286][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[286][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[286][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[286][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[286][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[286][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[286][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[286][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[286][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[286][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[286][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[286][LB] = ActionEntry(SHIFT, 177);
   _actionMap[286][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[286][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[286][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[286][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[286][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[286][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[286][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[286][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[286][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[286][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[286][SUM] = ActionEntry(SHIFT, 169);
}
void Cego::loadParser184()
{
   _actionMap[286][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[286][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[286][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[286][ObjSpec] = 122;
   _jumpMap[286][Constant] = 121;
   _jumpMap[286][SignedFloat] = 120;
   _jumpMap[286][SignedInt] = 119;
   _jumpMap[286][Attribute] = 118;
   _jumpMap[286][Function] = 117;
   _jumpMap[286][Factor] = 461;
   _jumpMap[286][CasePrepare] = 113;
   _jumpMap[286][CaseClause] = 112;
   _actionMap[287][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[287][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[287][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[287][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[287][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[287][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[287][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[287][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[287][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[287][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[287][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[287][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[287][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[287][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[287][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[287][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[287][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[287][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[287][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[287][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[287][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[287][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[287][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[287][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[287][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[287][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[287][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[287][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[287][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[287][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[287][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[287][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[287][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[287][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[287][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[287][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[287][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[287][BITOR] = ActionEntry(SHIFT, 127);
}
void Cego::loadParser185()
{
   _actionMap[287][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[287][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[287][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[287][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[287][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[287][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[287][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[287][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[287][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[287][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[287][LB] = ActionEntry(SHIFT, 177);
   _actionMap[287][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[287][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[287][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[287][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[287][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[287][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[287][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[287][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[287][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[287][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[287][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[287][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[287][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[287][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[287][ObjSpec] = 122;
   _jumpMap[287][Constant] = 121;
   _jumpMap[287][SignedFloat] = 120;
   _jumpMap[287][SignedInt] = 119;
   _jumpMap[287][Attribute] = 118;
   _jumpMap[287][Function] = 117;
   _jumpMap[287][Factor] = 462;
   _jumpMap[287][CasePrepare] = 113;
   _jumpMap[287][CaseClause] = 112;
   _actionMap[288][RB] = ActionEntry(SHIFT, 465);
   _actionMap[288][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[288][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[288][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[288][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[288][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[288][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[288][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[288][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[288][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[288][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[288][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[288][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[288][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[288][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[288][LOWER] = ActionEntry(SHIFT, 152);
}
void Cego::loadParser186()
{
   _actionMap[288][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[288][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[288][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[288][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[288][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[288][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[288][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[288][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[288][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[288][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[288][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[288][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[288][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[288][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[288][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[288][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[288][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[288][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[288][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[288][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[288][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[288][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[288][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[288][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[288][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[288][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[288][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[288][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[288][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[288][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[288][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[288][LB] = ActionEntry(SHIFT, 177);
   _actionMap[288][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[288][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[288][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[288][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[288][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[288][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[288][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[288][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[288][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[288][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[288][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[288][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[288][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[288][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[288][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[288][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[288][ObjSpec] = 122;
   _jumpMap[288][Constant] = 121;
}
void Cego::loadParser187()
{
   _jumpMap[288][SignedFloat] = 120;
   _jumpMap[288][SignedInt] = 119;
   _jumpMap[288][Attribute] = 118;
   _jumpMap[288][ExpressionList] = 464;
   _jumpMap[288][Function] = 117;
   _jumpMap[288][Factor] = 116;
   _jumpMap[288][Term] = 115;
   _jumpMap[288][Expr] = 463;
   _jumpMap[288][CasePrepare] = 113;
   _jumpMap[288][CaseClause] = 112;
   _actionMap[289][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[289][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[289][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[289][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[289][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[289][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[289][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[289][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[289][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[289][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[289][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[289][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[289][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[289][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[289][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[289][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[289][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[289][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[289][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[289][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[289][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[289][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[289][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[289][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[289][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[289][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[289][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[289][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[289][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[289][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[289][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[289][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[289][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[289][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[289][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[289][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[289][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[289][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[289][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[289][CLOB2STR] = ActionEntry(SHIFT, 136);
}
void Cego::loadParser188()
{
   _actionMap[289][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[289][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[289][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[289][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[289][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[289][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[289][LB] = ActionEntry(SHIFT, 177);
   _actionMap[289][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[289][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[289][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[289][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[289][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[289][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[289][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[289][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[289][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[289][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[289][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[289][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[289][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[289][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[289][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[289][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[289][ObjSpec] = 122;
   _jumpMap[289][Constant] = 121;
   _jumpMap[289][SignedFloat] = 120;
   _jumpMap[289][SignedInt] = 119;
   _jumpMap[289][Attribute] = 118;
   _jumpMap[289][ExpressionList] = 466;
   _jumpMap[289][Function] = 117;
   _jumpMap[289][Factor] = 116;
   _jumpMap[289][Term] = 115;
   _jumpMap[289][Expr] = 463;
   _jumpMap[289][CasePrepare] = 113;
   _jumpMap[289][CaseClause] = 112;
   _actionMap[290][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[290][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[290][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[290][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[290][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[290][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[290][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[290][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[290][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[290][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[290][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[290][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[290][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[290][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[290][LOWER] = ActionEntry(SHIFT, 152);
}
void Cego::loadParser189()
{
   _actionMap[290][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[290][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[290][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[290][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[290][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[290][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[290][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[290][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[290][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[290][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[290][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[290][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[290][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[290][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[290][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[290][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[290][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[290][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[290][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[290][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[290][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[290][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[290][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[290][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[290][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[290][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[290][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[290][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[290][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[290][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[290][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[290][LB] = ActionEntry(SHIFT, 177);
   _actionMap[290][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[290][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[290][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[290][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[290][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[290][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[290][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[290][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[290][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[290][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[290][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[290][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[290][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[290][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[290][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[290][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[290][ObjSpec] = 122;
   _jumpMap[290][Constant] = 121;
}
void Cego::loadParser190()
{
   _jumpMap[290][SignedFloat] = 120;
   _jumpMap[290][SignedInt] = 119;
   _jumpMap[290][Attribute] = 118;
   _jumpMap[290][Function] = 117;
   _jumpMap[290][Factor] = 116;
   _jumpMap[290][Term] = 115;
   _jumpMap[290][Expr] = 467;
   _jumpMap[290][CasePrepare] = 113;
   _jumpMap[290][CaseClause] = 112;
   _actionMap[291][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[291][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[291][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[291][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[291][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[291][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[291][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[291][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[291][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[291][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[291][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[291][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[291][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[291][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[291][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[291][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[291][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[291][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[291][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[291][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[291][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[291][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[291][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[291][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[291][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[291][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[291][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[291][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[291][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[291][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[291][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[291][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[291][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[291][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[291][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[291][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[291][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[291][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[291][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[291][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[291][NEXTCOUNT] = ActionEntry(SHIFT, 157);
}
void Cego::loadParser191()
{
   _actionMap[291][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[291][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[291][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[291][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[291][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[291][LB] = ActionEntry(SHIFT, 177);
   _actionMap[291][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[291][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[291][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[291][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[291][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[291][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[291][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[291][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[291][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[291][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[291][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[291][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[291][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[291][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[291][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[291][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[291][ObjSpec] = 122;
   _jumpMap[291][Constant] = 121;
   _jumpMap[291][SignedFloat] = 120;
   _jumpMap[291][SignedInt] = 119;
   _jumpMap[291][Attribute] = 118;
   _jumpMap[291][ExpressionList] = 468;
   _jumpMap[291][Function] = 117;
   _jumpMap[291][Factor] = 116;
   _jumpMap[291][Term] = 115;
   _jumpMap[291][Expr] = 463;
   _jumpMap[291][CasePrepare] = 113;
   _jumpMap[291][CaseClause] = 112;
   _actionMap[292][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[292][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[292][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[292][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[292][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[292][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[292][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[292][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[292][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[292][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[292][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[292][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[292][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[292][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[292][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[292][UPPER] = ActionEntry(SHIFT, 176);
}
void Cego::loadParser192()
{
   _actionMap[292][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[292][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[292][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[292][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[292][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[292][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[292][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[292][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[292][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[292][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[292][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[292][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[292][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[292][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[292][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[292][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[292][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[292][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[292][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[292][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[292][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[292][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[292][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[292][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[292][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[292][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[292][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[292][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[292][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[292][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[292][LB] = ActionEntry(SHIFT, 177);
   _actionMap[292][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[292][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[292][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[292][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[292][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[292][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[292][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[292][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[292][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[292][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[292][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[292][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[292][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[292][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[292][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[292][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[292][ObjSpec] = 122;
   _jumpMap[292][Constant] = 121;
   _jumpMap[292][SignedFloat] = 120;
}
void Cego::loadParser193()
{
   _jumpMap[292][SignedInt] = 119;
   _jumpMap[292][Attribute] = 118;
   _jumpMap[292][ExpressionList] = 469;
   _jumpMap[292][Function] = 117;
   _jumpMap[292][Factor] = 116;
   _jumpMap[292][Term] = 115;
   _jumpMap[292][Expr] = 463;
   _jumpMap[292][CasePrepare] = 113;
   _jumpMap[292][CaseClause] = 112;
   _actionMap[293][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[293][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[293][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[293][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[293][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[293][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[293][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[293][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[293][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[293][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[293][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[293][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[293][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[293][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[293][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[293][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[293][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[293][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[293][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[293][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[293][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[293][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[293][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[293][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[293][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[293][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[293][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[293][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[293][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[293][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[293][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[293][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[293][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[293][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[293][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[293][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[293][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[293][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[293][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[293][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[293][NEXTCOUNT] = ActionEntry(SHIFT, 157);
}
void Cego::loadParser194()
{
   _actionMap[293][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[293][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[293][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[293][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[293][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[293][LB] = ActionEntry(SHIFT, 177);
   _actionMap[293][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[293][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[293][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[293][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[293][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[293][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[293][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[293][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[293][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[293][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[293][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[293][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[293][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[293][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[293][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[293][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[293][ObjSpec] = 122;
   _jumpMap[293][Constant] = 121;
   _jumpMap[293][SignedFloat] = 120;
   _jumpMap[293][SignedInt] = 119;
   _jumpMap[293][Attribute] = 118;
   _jumpMap[293][ExpressionList] = 470;
   _jumpMap[293][Function] = 117;
   _jumpMap[293][Factor] = 116;
   _jumpMap[293][Term] = 115;
   _jumpMap[293][Expr] = 463;
   _jumpMap[293][CasePrepare] = 113;
   _jumpMap[293][CaseClause] = 112;
   _actionMap[294][INTVAL] = ActionEntry(SHIFT, 471);
   _actionMap[295][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[295][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[295][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[295][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[295][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[295][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[295][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[295][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[295][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[295][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[295][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[295][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[295][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[295][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[295][LOWER] = ActionEntry(SHIFT, 152);
}
void Cego::loadParser195()
{
   _actionMap[295][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[295][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[295][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[295][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[295][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[295][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[295][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[295][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[295][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[295][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[295][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[295][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[295][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[295][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[295][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[295][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[295][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[295][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[295][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[295][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[295][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[295][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[295][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[295][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[295][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[295][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[295][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[295][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[295][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[295][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[295][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[295][LB] = ActionEntry(SHIFT, 177);
   _actionMap[295][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[295][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[295][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[295][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[295][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[295][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[295][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[295][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[295][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[295][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[295][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[295][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[295][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[295][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[295][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[295][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[295][ObjSpec] = 122;
   _jumpMap[295][Constant] = 121;
}
void Cego::loadParser196()
{
   _jumpMap[295][SignedFloat] = 120;
   _jumpMap[295][SignedInt] = 119;
   _jumpMap[295][Attribute] = 118;
   _jumpMap[295][ExpressionList] = 472;
   _jumpMap[295][Function] = 117;
   _jumpMap[295][Factor] = 116;
   _jumpMap[295][Term] = 115;
   _jumpMap[295][Expr] = 463;
   _jumpMap[295][CasePrepare] = 113;
   _jumpMap[295][CaseClause] = 112;
   _actionMap[296][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[296][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[296][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[296][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[296][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[296][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[296][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[296][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[296][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[296][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[296][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[296][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[296][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[296][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[296][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[296][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[296][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[296][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[296][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[296][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[296][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[296][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[296][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[296][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[296][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[296][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[296][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[296][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[296][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[296][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[296][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[296][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[296][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[296][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[296][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[296][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[296][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[296][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[296][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[296][CLOB2STR] = ActionEntry(SHIFT, 136);
}
void Cego::loadParser197()
{
   _actionMap[296][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[296][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[296][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[296][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[296][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[296][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[296][LB] = ActionEntry(SHIFT, 177);
   _actionMap[296][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[296][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[296][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[296][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[296][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[296][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[296][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[296][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[296][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[296][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[296][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[296][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[296][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[296][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[296][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[296][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[296][ObjSpec] = 122;
   _jumpMap[296][Constant] = 121;
   _jumpMap[296][SignedFloat] = 120;
   _jumpMap[296][SignedInt] = 119;
   _jumpMap[296][Attribute] = 118;
   _jumpMap[296][ExpressionList] = 473;
   _jumpMap[296][Function] = 117;
   _jumpMap[296][Factor] = 116;
   _jumpMap[296][Term] = 115;
   _jumpMap[296][Expr] = 463;
   _jumpMap[296][CasePrepare] = 113;
   _jumpMap[296][CaseClause] = 112;
   _actionMap[297][INTVAL] = ActionEntry(SHIFT, 474);
   _actionMap[298][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[298][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[298][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[298][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[298][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[298][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[298][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[298][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[298][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[298][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[298][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[298][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[298][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[298][NEWDATE] = ActionEntry(SHIFT, 146);
}
void Cego::loadParser198()
{
   _actionMap[298][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[298][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[298][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[298][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[298][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[298][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[298][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[298][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[298][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[298][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[298][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[298][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[298][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[298][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[298][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[298][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[298][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[298][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[298][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[298][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[298][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[298][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[298][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[298][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[298][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[298][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[298][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[298][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[298][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[298][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[298][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[298][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[298][LB] = ActionEntry(SHIFT, 177);
   _actionMap[298][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[298][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[298][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[298][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[298][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[298][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[298][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[298][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[298][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[298][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[298][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[298][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[298][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[298][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[298][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[298][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[298][ObjSpec] = 122;
}
void Cego::loadParser199()
{
   _jumpMap[298][Constant] = 121;
   _jumpMap[298][SignedFloat] = 120;
   _jumpMap[298][SignedInt] = 119;
   _jumpMap[298][Attribute] = 118;
   _jumpMap[298][ExpressionList] = 475;
   _jumpMap[298][Function] = 117;
   _jumpMap[298][Factor] = 116;
   _jumpMap[298][Term] = 115;
   _jumpMap[298][Expr] = 463;
   _jumpMap[298][CasePrepare] = 113;
   _jumpMap[298][CaseClause] = 112;
   _actionMap[299][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[299][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[299][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[299][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[299][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[299][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[299][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[299][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[299][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[299][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[299][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[299][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[299][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[299][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[299][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[299][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[299][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[299][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[299][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[299][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[299][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[299][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[299][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[299][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[299][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[299][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[299][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[299][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[299][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[299][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[299][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[299][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[299][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[299][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[299][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[299][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[299][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[299][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[299][CLOBREF] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser200()
{
   _actionMap[299][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[299][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[299][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[299][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[299][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[299][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[299][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[299][LB] = ActionEntry(SHIFT, 177);
   _actionMap[299][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[299][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[299][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[299][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[299][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[299][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[299][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[299][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[299][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[299][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[299][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[299][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[299][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[299][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[299][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[299][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[299][ObjSpec] = 122;
   _jumpMap[299][Constant] = 121;
   _jumpMap[299][SignedFloat] = 120;
   _jumpMap[299][SignedInt] = 119;
   _jumpMap[299][Attribute] = 118;
   _jumpMap[299][ExpressionList] = 476;
   _jumpMap[299][Function] = 117;
   _jumpMap[299][Factor] = 116;
   _jumpMap[299][Term] = 115;
   _jumpMap[299][Expr] = 463;
   _jumpMap[299][CasePrepare] = 113;
   _jumpMap[299][CaseClause] = 112;
   _actionMap[300][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[300][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[300][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[300][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[300][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[300][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[300][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[300][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[300][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[300][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[300][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[300][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[300][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[300][NEWDATE] = ActionEntry(SHIFT, 146);
}
void Cego::loadParser201()
{
   _actionMap[300][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[300][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[300][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[300][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[300][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[300][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[300][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[300][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[300][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[300][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[300][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[300][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[300][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[300][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[300][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[300][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[300][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[300][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[300][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[300][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[300][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[300][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[300][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[300][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[300][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[300][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[300][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[300][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[300][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[300][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[300][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[300][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[300][LB] = ActionEntry(SHIFT, 177);
   _actionMap[300][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[300][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[300][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[300][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[300][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[300][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[300][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[300][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[300][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[300][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[300][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[300][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[300][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[300][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[300][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[300][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[300][ObjSpec] = 122;
}
void Cego::loadParser202()
{
   _jumpMap[300][Constant] = 121;
   _jumpMap[300][SignedFloat] = 120;
   _jumpMap[300][SignedInt] = 119;
   _jumpMap[300][Attribute] = 118;
   _jumpMap[300][ExpressionList] = 477;
   _jumpMap[300][Function] = 117;
   _jumpMap[300][Factor] = 116;
   _jumpMap[300][Term] = 115;
   _jumpMap[300][Expr] = 463;
   _jumpMap[300][CasePrepare] = 113;
   _jumpMap[300][CaseClause] = 112;
   _actionMap[301][STAR] = ActionEntry(SHIFT, 479);
   _actionMap[301][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[301][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[301][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[301][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[301][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[301][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[301][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[301][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[301][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[301][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[301][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[301][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[301][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[301][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[301][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[301][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[301][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[301][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[301][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[301][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[301][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[301][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[301][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[301][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[301][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[301][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[301][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[301][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[301][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[301][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[301][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[301][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[301][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[301][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[301][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[301][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[301][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[301][CLOBSIZE] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser203()
{
   _actionMap[301][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[301][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[301][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[301][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[301][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[301][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[301][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[301][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[301][LB] = ActionEntry(SHIFT, 177);
   _actionMap[301][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[301][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[301][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[301][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[301][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[301][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[301][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[301][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[301][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[301][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[301][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[301][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[301][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[301][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[301][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[301][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[301][ObjSpec] = 122;
   _jumpMap[301][Constant] = 121;
   _jumpMap[301][SignedFloat] = 120;
   _jumpMap[301][SignedInt] = 119;
   _jumpMap[301][Attribute] = 118;
   _jumpMap[301][Function] = 117;
   _jumpMap[301][Factor] = 116;
   _jumpMap[301][Term] = 115;
   _jumpMap[301][Expr] = 478;
   _jumpMap[301][CasePrepare] = 113;
   _jumpMap[301][CaseClause] = 112;
   _actionMap[302][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[302][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[302][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[302][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[302][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[302][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[302][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[302][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[302][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[302][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[302][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[302][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[302][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[302][NEWDATE] = ActionEntry(SHIFT, 146);
}
void Cego::loadParser204()
{
   _actionMap[302][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[302][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[302][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[302][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[302][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[302][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[302][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[302][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[302][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[302][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[302][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[302][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[302][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[302][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[302][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[302][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[302][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[302][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[302][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[302][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[302][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[302][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[302][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[302][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[302][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[302][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[302][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[302][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[302][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[302][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[302][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[302][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[302][LB] = ActionEntry(SHIFT, 177);
   _actionMap[302][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[302][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[302][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[302][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[302][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[302][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[302][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[302][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[302][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[302][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[302][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[302][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[302][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[302][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[302][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[302][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[302][ObjSpec] = 122;
}
void Cego::loadParser205()
{
   _jumpMap[302][Constant] = 121;
   _jumpMap[302][SignedFloat] = 120;
   _jumpMap[302][SignedInt] = 119;
   _jumpMap[302][Attribute] = 118;
   _jumpMap[302][ExpressionList] = 480;
   _jumpMap[302][Function] = 117;
   _jumpMap[302][Factor] = 116;
   _jumpMap[302][Term] = 115;
   _jumpMap[302][Expr] = 463;
   _jumpMap[302][CasePrepare] = 113;
   _jumpMap[302][CaseClause] = 112;
   _actionMap[303][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[303][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[303][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[303][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[303][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[303][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[303][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[303][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[303][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[303][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[303][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[303][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[303][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[303][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[303][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[303][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[303][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[303][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[303][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[303][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[303][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[303][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[303][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[303][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[303][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[303][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[303][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[303][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[303][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[303][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[303][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[303][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[303][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[303][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[303][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[303][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[303][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[303][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[303][CLOBREF] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser206()
{
   _actionMap[303][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[303][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[303][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[303][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[303][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[303][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[303][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[303][LB] = ActionEntry(SHIFT, 177);
   _actionMap[303][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[303][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[303][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[303][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[303][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[303][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[303][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[303][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[303][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[303][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[303][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[303][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[303][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[303][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[303][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[303][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[303][ObjSpec] = 122;
   _jumpMap[303][Constant] = 121;
   _jumpMap[303][SignedFloat] = 120;
   _jumpMap[303][SignedInt] = 119;
   _jumpMap[303][Attribute] = 118;
   _jumpMap[303][ExpressionList] = 481;
   _jumpMap[303][Function] = 117;
   _jumpMap[303][Factor] = 116;
   _jumpMap[303][Term] = 115;
   _jumpMap[303][Expr] = 463;
   _jumpMap[303][CasePrepare] = 113;
   _jumpMap[303][CaseClause] = 112;
   _actionMap[304][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[304][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[304][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[304][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[304][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[304][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[304][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[304][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[304][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[304][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[304][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[304][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[304][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[304][NEWDATE] = ActionEntry(SHIFT, 146);
}
void Cego::loadParser207()
{
   _actionMap[304][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[304][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[304][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[304][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[304][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[304][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[304][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[304][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[304][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[304][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[304][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[304][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[304][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[304][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[304][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[304][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[304][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[304][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[304][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[304][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[304][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[304][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[304][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[304][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[304][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[304][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[304][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[304][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[304][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[304][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[304][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[304][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[304][LB] = ActionEntry(SHIFT, 177);
   _actionMap[304][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[304][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[304][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[304][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[304][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[304][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[304][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[304][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[304][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[304][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[304][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[304][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[304][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[304][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[304][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[304][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[304][ObjSpec] = 122;
}
void Cego::loadParser208()
{
   _jumpMap[304][Constant] = 121;
   _jumpMap[304][SignedFloat] = 120;
   _jumpMap[304][SignedInt] = 119;
   _jumpMap[304][Attribute] = 118;
   _jumpMap[304][ExpressionList] = 482;
   _jumpMap[304][Function] = 117;
   _jumpMap[304][Factor] = 116;
   _jumpMap[304][Term] = 115;
   _jumpMap[304][Expr] = 463;
   _jumpMap[304][CasePrepare] = 113;
   _jumpMap[304][CaseClause] = 112;
   _actionMap[305][INTO] = ActionEntry(SHIFT, 483);
   _actionMap[306][IDENTIFIER] = ActionEntry(SHIFT, 484);
   _actionMap[307][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[307][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[307][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[307][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[307][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[307][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[307][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[307][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[307][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[307][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[307][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[307][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[307][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[307][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[307][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[307][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[307][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[307][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[307][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[307][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[307][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[307][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[307][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[307][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[307][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[307][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[307][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[307][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[307][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[307][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[307][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[307][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[307][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[307][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[307][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[307][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[307][BLOBREF] = ActionEntry(SHIFT, 131);
}
void Cego::loadParser209()
{
   _actionMap[307][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[307][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[307][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[307][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[307][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[307][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[307][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[307][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[307][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[307][LB] = ActionEntry(SHIFT, 177);
   _actionMap[307][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[307][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[307][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[307][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[307][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[307][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[307][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[307][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[307][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[307][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[307][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[307][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[307][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[307][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[307][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[307][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[307][ObjSpec] = 122;
   _jumpMap[307][Constant] = 121;
   _jumpMap[307][SignedFloat] = 120;
   _jumpMap[307][SignedInt] = 119;
   _jumpMap[307][Attribute] = 118;
   _jumpMap[307][ExpressionList] = 485;
   _jumpMap[307][Function] = 117;
   _jumpMap[307][Factor] = 116;
   _jumpMap[307][Term] = 115;
   _jumpMap[307][Expr] = 463;
   _jumpMap[307][CasePrepare] = 113;
   _jumpMap[307][CaseClause] = 112;
   _actionMap[308][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[308][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[308][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[308][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[308][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[308][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[308][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[308][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[308][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[308][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[308][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[308][DATE2LONG] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser210()
{
   _actionMap[308][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[308][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[308][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[308][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[308][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[308][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[308][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[308][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[308][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[308][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[308][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[308][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[308][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[308][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[308][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[308][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[308][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[308][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[308][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[308][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[308][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[308][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[308][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[308][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[308][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[308][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[308][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[308][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[308][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[308][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[308][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[308][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[308][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[308][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[308][LB] = ActionEntry(SHIFT, 177);
   _actionMap[308][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[308][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[308][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[308][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[308][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[308][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[308][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[308][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[308][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[308][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[308][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[308][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[308][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[308][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[308][MIN] = ActionEntry(SHIFT, 154);
}
void Cego::loadParser211()
{
   _actionMap[308][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[308][ObjSpec] = 122;
   _jumpMap[308][Constant] = 121;
   _jumpMap[308][SignedFloat] = 120;
   _jumpMap[308][SignedInt] = 119;
   _jumpMap[308][Attribute] = 118;
   _jumpMap[308][ExpressionList] = 486;
   _jumpMap[308][Function] = 117;
   _jumpMap[308][Factor] = 116;
   _jumpMap[308][Term] = 115;
   _jumpMap[308][Expr] = 463;
   _jumpMap[308][CasePrepare] = 113;
   _jumpMap[308][CaseClause] = 112;
   _actionMap[309][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[309][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[309][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[309][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[309][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[309][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[309][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[309][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[309][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[309][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[309][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[309][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[309][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[309][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[309][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[309][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[309][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[309][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[309][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[309][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[309][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[309][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[309][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[309][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[309][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[309][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[309][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[309][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[309][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[309][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[309][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[309][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[309][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[309][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[309][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[309][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[309][BLOBREF] = ActionEntry(SHIFT, 131);
}
void Cego::loadParser212()
{
   _actionMap[309][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[309][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[309][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[309][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[309][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[309][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[309][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[309][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[309][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[309][LB] = ActionEntry(SHIFT, 177);
   _actionMap[309][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[309][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[309][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[309][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[309][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[309][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[309][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[309][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[309][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[309][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[309][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[309][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[309][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[309][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[309][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[309][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[309][ObjSpec] = 122;
   _jumpMap[309][Constant] = 121;
   _jumpMap[309][SignedFloat] = 120;
   _jumpMap[309][SignedInt] = 119;
   _jumpMap[309][Attribute] = 118;
   _jumpMap[309][ExpressionList] = 487;
   _jumpMap[309][Function] = 117;
   _jumpMap[309][Factor] = 116;
   _jumpMap[309][Term] = 115;
   _jumpMap[309][Expr] = 463;
   _jumpMap[309][CasePrepare] = 113;
   _jumpMap[309][CaseClause] = 112;
   _actionMap[310][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[310][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[310][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[310][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[310][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[310][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[310][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[310][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[310][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[310][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[310][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[310][DATE2LONG] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser213()
{
   _actionMap[310][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[310][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[310][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[310][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[310][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[310][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[310][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[310][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[310][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[310][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[310][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[310][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[310][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[310][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[310][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[310][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[310][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[310][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[310][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[310][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[310][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[310][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[310][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[310][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[310][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[310][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[310][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[310][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[310][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[310][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[310][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[310][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[310][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[310][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[310][LB] = ActionEntry(SHIFT, 177);
   _actionMap[310][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[310][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[310][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[310][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[310][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[310][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[310][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[310][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[310][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[310][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[310][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[310][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[310][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[310][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[310][MIN] = ActionEntry(SHIFT, 154);
}
void Cego::loadParser214()
{
   _actionMap[310][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[310][ObjSpec] = 122;
   _jumpMap[310][Constant] = 121;
   _jumpMap[310][SignedFloat] = 120;
   _jumpMap[310][SignedInt] = 119;
   _jumpMap[310][Attribute] = 118;
   _jumpMap[310][ExpressionList] = 488;
   _jumpMap[310][Function] = 117;
   _jumpMap[310][Factor] = 116;
   _jumpMap[310][Term] = 115;
   _jumpMap[310][Expr] = 463;
   _jumpMap[310][CasePrepare] = 113;
   _jumpMap[310][CaseClause] = 112;
   _actionMap[311][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[311][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[311][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[311][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[311][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[311][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[311][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[311][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[311][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[311][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[311][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[311][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[311][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[311][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[311][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[311][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[311][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[311][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[311][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[311][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[311][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[311][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[311][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[311][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[311][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[311][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[311][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[311][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[311][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[311][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[311][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[311][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[311][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[311][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[311][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[311][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[311][BLOBREF] = ActionEntry(SHIFT, 131);
}
void Cego::loadParser215()
{
   _actionMap[311][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[311][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[311][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[311][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[311][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[311][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[311][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[311][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[311][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[311][LB] = ActionEntry(SHIFT, 177);
   _actionMap[311][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[311][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[311][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[311][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[311][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[311][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[311][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[311][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[311][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[311][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[311][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[311][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[311][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[311][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[311][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[311][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[311][ObjSpec] = 122;
   _jumpMap[311][Constant] = 121;
   _jumpMap[311][SignedFloat] = 120;
   _jumpMap[311][SignedInt] = 119;
   _jumpMap[311][Attribute] = 118;
   _jumpMap[311][ExpressionList] = 489;
   _jumpMap[311][Function] = 117;
   _jumpMap[311][Factor] = 116;
   _jumpMap[311][Term] = 115;
   _jumpMap[311][Expr] = 463;
   _jumpMap[311][CasePrepare] = 113;
   _jumpMap[311][CaseClause] = 112;
   _actionMap[312][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[312][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[312][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[312][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[312][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[312][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[312][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[312][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[312][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[312][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[312][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[312][DATE2LONG] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser216()
{
   _actionMap[312][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[312][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[312][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[312][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[312][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[312][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[312][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[312][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[312][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[312][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[312][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[312][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[312][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[312][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[312][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[312][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[312][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[312][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[312][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[312][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[312][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[312][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[312][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[312][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[312][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[312][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[312][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[312][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[312][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[312][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[312][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[312][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[312][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[312][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[312][LB] = ActionEntry(SHIFT, 177);
   _actionMap[312][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[312][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[312][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[312][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[312][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[312][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[312][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[312][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[312][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[312][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[312][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[312][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[312][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[312][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[312][MIN] = ActionEntry(SHIFT, 154);
}
void Cego::loadParser217()
{
   _actionMap[312][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[312][ObjSpec] = 122;
   _jumpMap[312][Constant] = 121;
   _jumpMap[312][SignedFloat] = 120;
   _jumpMap[312][SignedInt] = 119;
   _jumpMap[312][Attribute] = 118;
   _jumpMap[312][ExpressionList] = 490;
   _jumpMap[312][Function] = 117;
   _jumpMap[312][Factor] = 116;
   _jumpMap[312][Term] = 115;
   _jumpMap[312][Expr] = 463;
   _jumpMap[312][CasePrepare] = 113;
   _jumpMap[312][CaseClause] = 112;
   _actionMap[313][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[313][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[313][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[313][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[313][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[313][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[313][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[313][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[313][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[313][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[313][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[313][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[313][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[313][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[313][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[313][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[313][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[313][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[313][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[313][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[313][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[313][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[313][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[313][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[313][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[313][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[313][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[313][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[313][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[313][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[313][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[313][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[313][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[313][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[313][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[313][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[313][BLOBREF] = ActionEntry(SHIFT, 131);
}
void Cego::loadParser218()
{
   _actionMap[313][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[313][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[313][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[313][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[313][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[313][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[313][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[313][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[313][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[313][LB] = ActionEntry(SHIFT, 177);
   _actionMap[313][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[313][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[313][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[313][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[313][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[313][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[313][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[313][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[313][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[313][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[313][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[313][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[313][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[313][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[313][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[313][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[313][ObjSpec] = 122;
   _jumpMap[313][Constant] = 121;
   _jumpMap[313][SignedFloat] = 120;
   _jumpMap[313][SignedInt] = 119;
   _jumpMap[313][Attribute] = 118;
   _jumpMap[313][ExpressionList] = 491;
   _jumpMap[313][Function] = 117;
   _jumpMap[313][Factor] = 116;
   _jumpMap[313][Term] = 115;
   _jumpMap[313][Expr] = 463;
   _jumpMap[313][CasePrepare] = 113;
   _jumpMap[313][CaseClause] = 112;
   _actionMap[314][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[314][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[314][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[314][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[314][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[314][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[314][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[314][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[314][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[314][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[314][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[314][DATE2LONG] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser219()
{
   _actionMap[314][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[314][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[314][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[314][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[314][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[314][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[314][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[314][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[314][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[314][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[314][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[314][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[314][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[314][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[314][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[314][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[314][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[314][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[314][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[314][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[314][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[314][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[314][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[314][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[314][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[314][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[314][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[314][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[314][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[314][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[314][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[314][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[314][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[314][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[314][LB] = ActionEntry(SHIFT, 177);
   _actionMap[314][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[314][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[314][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[314][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[314][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[314][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[314][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[314][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[314][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[314][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[314][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[314][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[314][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[314][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[314][MIN] = ActionEntry(SHIFT, 154);
}
void Cego::loadParser220()
{
   _actionMap[314][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[314][ObjSpec] = 122;
   _jumpMap[314][Constant] = 121;
   _jumpMap[314][SignedFloat] = 120;
   _jumpMap[314][SignedInt] = 119;
   _jumpMap[314][Attribute] = 118;
   _jumpMap[314][ExpressionList] = 492;
   _jumpMap[314][Function] = 117;
   _jumpMap[314][Factor] = 116;
   _jumpMap[314][Term] = 115;
   _jumpMap[314][Expr] = 463;
   _jumpMap[314][CasePrepare] = 113;
   _jumpMap[314][CaseClause] = 112;
   _actionMap[315][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[315][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[315][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[315][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[315][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[315][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[315][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[315][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[315][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[315][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[315][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[315][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[315][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[315][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[315][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[315][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[315][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[315][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[315][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[315][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[315][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[315][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[315][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[315][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[315][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[315][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[315][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[315][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[315][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[315][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[315][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[315][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[315][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[315][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[315][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[315][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[315][BLOBREF] = ActionEntry(SHIFT, 131);
}
void Cego::loadParser221()
{
   _actionMap[315][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[315][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[315][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[315][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[315][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[315][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[315][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[315][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[315][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[315][LB] = ActionEntry(SHIFT, 177);
   _actionMap[315][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[315][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[315][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[315][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[315][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[315][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[315][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[315][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[315][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[315][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[315][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[315][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[315][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[315][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[315][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[315][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[315][ObjSpec] = 122;
   _jumpMap[315][Constant] = 121;
   _jumpMap[315][SignedFloat] = 120;
   _jumpMap[315][SignedInt] = 119;
   _jumpMap[315][Attribute] = 118;
   _jumpMap[315][ExpressionList] = 493;
   _jumpMap[315][Function] = 117;
   _jumpMap[315][Factor] = 116;
   _jumpMap[315][Term] = 115;
   _jumpMap[315][Expr] = 463;
   _jumpMap[315][CasePrepare] = 113;
   _jumpMap[315][CaseClause] = 112;
   _actionMap[316][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[316][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[316][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[316][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[316][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[316][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[316][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[316][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[316][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[316][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[316][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[316][DATE2LONG] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser222()
{
   _actionMap[316][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[316][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[316][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[316][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[316][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[316][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[316][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[316][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[316][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[316][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[316][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[316][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[316][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[316][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[316][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[316][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[316][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[316][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[316][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[316][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[316][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[316][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[316][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[316][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[316][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[316][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[316][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[316][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[316][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[316][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[316][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[316][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[316][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[316][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[316][LB] = ActionEntry(SHIFT, 177);
   _actionMap[316][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[316][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[316][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[316][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[316][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[316][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[316][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[316][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[316][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[316][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[316][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[316][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[316][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[316][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[316][MIN] = ActionEntry(SHIFT, 154);
}
void Cego::loadParser223()
{
   _actionMap[316][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[316][ObjSpec] = 122;
   _jumpMap[316][Constant] = 121;
   _jumpMap[316][SignedFloat] = 120;
   _jumpMap[316][SignedInt] = 119;
   _jumpMap[316][Attribute] = 118;
   _jumpMap[316][ExpressionList] = 494;
   _jumpMap[316][Function] = 117;
   _jumpMap[316][Factor] = 116;
   _jumpMap[316][Term] = 115;
   _jumpMap[316][Expr] = 463;
   _jumpMap[316][CasePrepare] = 113;
   _jumpMap[316][CaseClause] = 112;
   _actionMap[317][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[317][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[317][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[317][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[317][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[317][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[317][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[317][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[317][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[317][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[317][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[317][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[317][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[317][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[317][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[317][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[317][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[317][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[317][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[317][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[317][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[317][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[317][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[317][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[317][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[317][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[317][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[317][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[317][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[317][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[317][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[317][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[317][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[317][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[317][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[317][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[317][BLOBREF] = ActionEntry(SHIFT, 131);
}
void Cego::loadParser224()
{
   _actionMap[317][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[317][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[317][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[317][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[317][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[317][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[317][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[317][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[317][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[317][LB] = ActionEntry(SHIFT, 177);
   _actionMap[317][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[317][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[317][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[317][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[317][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[317][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[317][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[317][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[317][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[317][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[317][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[317][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[317][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[317][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[317][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[317][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[317][ObjSpec] = 122;
   _jumpMap[317][Constant] = 121;
   _jumpMap[317][SignedFloat] = 120;
   _jumpMap[317][SignedInt] = 119;
   _jumpMap[317][Attribute] = 118;
   _jumpMap[317][Function] = 117;
   _jumpMap[317][Factor] = 116;
   _jumpMap[317][Term] = 115;
   _jumpMap[317][Expr] = 495;
   _jumpMap[317][CasePrepare] = 113;
   _jumpMap[317][CaseClause] = 112;
   _actionMap[318][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[318][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[318][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[318][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[318][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[318][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[318][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[318][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[318][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[318][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[318][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[318][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[318][LONG2DATE] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser225()
{
   _actionMap[318][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[318][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[318][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[318][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[318][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[318][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[318][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[318][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[318][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[318][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[318][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[318][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[318][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[318][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[318][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[318][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[318][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[318][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[318][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[318][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[318][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[318][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[318][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[318][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[318][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[318][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[318][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[318][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[318][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[318][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[318][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[318][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[318][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[318][LB] = ActionEntry(SHIFT, 177);
   _actionMap[318][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[318][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[318][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[318][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[318][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[318][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[318][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[318][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[318][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[318][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[318][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[318][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[318][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[318][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[318][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[318][MAX] = ActionEntry(SHIFT, 155);
}
void Cego::loadParser226()
{
   _jumpMap[318][ObjSpec] = 122;
   _jumpMap[318][Constant] = 121;
   _jumpMap[318][SignedFloat] = 120;
   _jumpMap[318][SignedInt] = 119;
   _jumpMap[318][Attribute] = 118;
   _jumpMap[318][Function] = 117;
   _jumpMap[318][Factor] = 116;
   _jumpMap[318][Term] = 115;
   _jumpMap[318][Expr] = 496;
   _jumpMap[318][CasePrepare] = 113;
   _jumpMap[318][CaseClause] = 112;
   _actionMap[319][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[319][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[319][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[319][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[319][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[319][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[319][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[319][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[319][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[319][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[319][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[319][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[319][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[319][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[319][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[319][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[319][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[319][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[319][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[319][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[319][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[319][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[319][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[319][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[319][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[319][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[319][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[319][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[319][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[319][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[319][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[319][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[319][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[319][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[319][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[319][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[319][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[319][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[319][CLOBREF] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser227()
{
   _actionMap[319][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[319][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[319][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[319][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[319][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[319][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[319][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[319][LB] = ActionEntry(SHIFT, 177);
   _actionMap[319][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[319][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[319][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[319][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[319][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[319][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[319][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[319][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[319][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[319][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[319][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[319][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[319][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[319][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[319][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[319][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[319][ObjSpec] = 122;
   _jumpMap[319][Constant] = 121;
   _jumpMap[319][SignedFloat] = 120;
   _jumpMap[319][SignedInt] = 119;
   _jumpMap[319][Attribute] = 118;
   _jumpMap[319][ExpressionList] = 497;
   _jumpMap[319][Function] = 117;
   _jumpMap[319][Factor] = 116;
   _jumpMap[319][Term] = 115;
   _jumpMap[319][Expr] = 463;
   _jumpMap[319][CasePrepare] = 113;
   _jumpMap[319][CaseClause] = 112;
   _actionMap[320][IDENTIFIER] = ActionEntry(SHIFT, 498);
   _actionMap[321][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[321][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[321][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[321][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[321][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[321][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[321][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[321][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[321][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[321][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[321][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[321][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[321][LONG2DATE] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser228()
{
   _actionMap[321][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[321][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[321][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[321][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[321][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[321][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[321][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[321][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[321][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[321][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[321][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[321][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[321][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[321][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[321][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[321][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[321][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[321][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[321][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[321][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[321][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[321][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[321][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[321][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[321][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[321][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[321][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[321][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[321][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[321][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[321][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[321][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[321][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[321][LB] = ActionEntry(SHIFT, 177);
   _actionMap[321][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[321][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[321][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[321][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[321][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[321][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[321][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[321][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[321][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[321][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[321][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[321][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[321][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[321][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[321][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[321][MAX] = ActionEntry(SHIFT, 155);
}
void Cego::loadParser229()
{
   _jumpMap[321][ObjSpec] = 122;
   _jumpMap[321][Constant] = 121;
   _jumpMap[321][SignedFloat] = 120;
   _jumpMap[321][SignedInt] = 119;
   _jumpMap[321][Attribute] = 118;
   _jumpMap[321][ExpressionList] = 499;
   _jumpMap[321][Function] = 117;
   _jumpMap[321][Factor] = 116;
   _jumpMap[321][Term] = 115;
   _jumpMap[321][Expr] = 463;
   _jumpMap[321][CasePrepare] = 113;
   _jumpMap[321][CaseClause] = 112;
   _actionMap[322][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[322][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[322][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[322][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[322][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[322][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[322][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[322][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[322][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[322][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[322][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[322][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[322][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[322][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[322][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[322][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[322][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[322][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[322][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[322][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[322][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[322][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[322][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[322][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[322][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[322][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[322][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[322][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[322][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[322][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[322][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[322][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[322][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[322][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[322][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[322][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[322][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[322][CLOBSIZE] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser230()
{
   _actionMap[322][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[322][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[322][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[322][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[322][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[322][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[322][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[322][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[322][LB] = ActionEntry(SHIFT, 177);
   _actionMap[322][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[322][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[322][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[322][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[322][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[322][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[322][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[322][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[322][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[322][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[322][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[322][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[322][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[322][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[322][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[322][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[322][ObjSpec] = 122;
   _jumpMap[322][Constant] = 121;
   _jumpMap[322][SignedFloat] = 120;
   _jumpMap[322][SignedInt] = 119;
   _jumpMap[322][Attribute] = 118;
   _jumpMap[322][ExpressionList] = 500;
   _jumpMap[322][Function] = 117;
   _jumpMap[322][Factor] = 116;
   _jumpMap[322][Term] = 115;
   _jumpMap[322][Expr] = 463;
   _jumpMap[322][CasePrepare] = 113;
   _jumpMap[322][CaseClause] = 112;
   _actionMap[323][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[323][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[323][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[323][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[323][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[323][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[323][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[323][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[323][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[323][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[323][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[323][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[323][LONG2DATE] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser231()
{
   _actionMap[323][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[323][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[323][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[323][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[323][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[323][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[323][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[323][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[323][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[323][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[323][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[323][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[323][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[323][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[323][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[323][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[323][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[323][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[323][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[323][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[323][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[323][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[323][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[323][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[323][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[323][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[323][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[323][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[323][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[323][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[323][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[323][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[323][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[323][LB] = ActionEntry(SHIFT, 177);
   _actionMap[323][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[323][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[323][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[323][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[323][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[323][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[323][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[323][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[323][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[323][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[323][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[323][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[323][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[323][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[323][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[323][MAX] = ActionEntry(SHIFT, 155);
}
void Cego::loadParser232()
{
   _jumpMap[323][ObjSpec] = 122;
   _jumpMap[323][Constant] = 121;
   _jumpMap[323][SignedFloat] = 120;
   _jumpMap[323][SignedInt] = 119;
   _jumpMap[323][Attribute] = 118;
   _jumpMap[323][ExpressionList] = 501;
   _jumpMap[323][Function] = 117;
   _jumpMap[323][Factor] = 116;
   _jumpMap[323][Term] = 115;
   _jumpMap[323][Expr] = 463;
   _jumpMap[323][CasePrepare] = 113;
   _jumpMap[323][CaseClause] = 112;
   _actionMap[324][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[324][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[324][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[324][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[324][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[324][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[324][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[324][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[324][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[324][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[324][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[324][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[324][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[324][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[324][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[324][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[324][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[324][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[324][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[324][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[324][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[324][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[324][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[324][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[324][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[324][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[324][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[324][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[324][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[324][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[324][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[324][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[324][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[324][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[324][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[324][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[324][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[324][CLOBSIZE] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser233()
{
   _actionMap[324][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[324][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[324][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[324][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[324][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[324][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[324][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[324][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[324][LB] = ActionEntry(SHIFT, 177);
   _actionMap[324][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[324][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[324][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[324][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[324][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[324][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[324][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[324][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[324][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[324][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[324][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[324][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[324][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[324][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[324][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[324][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[324][ObjSpec] = 122;
   _jumpMap[324][Constant] = 121;
   _jumpMap[324][SignedFloat] = 120;
   _jumpMap[324][SignedInt] = 119;
   _jumpMap[324][Attribute] = 118;
   _jumpMap[324][ExpressionList] = 502;
   _jumpMap[324][Function] = 117;
   _jumpMap[324][Factor] = 116;
   _jumpMap[324][Term] = 115;
   _jumpMap[324][Expr] = 463;
   _jumpMap[324][CasePrepare] = 113;
   _jumpMap[324][CaseClause] = 112;
   _actionMap[325][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[325][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[325][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[325][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[325][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[325][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[325][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[325][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[325][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[325][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[325][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[325][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[325][LONG2DATE] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser234()
{
   _actionMap[325][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[325][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[325][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[325][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[325][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[325][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[325][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[325][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[325][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[325][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[325][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[325][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[325][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[325][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[325][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[325][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[325][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[325][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[325][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[325][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[325][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[325][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[325][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[325][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[325][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[325][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[325][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[325][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[325][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[325][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[325][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[325][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[325][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[325][LB] = ActionEntry(SHIFT, 177);
   _actionMap[325][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[325][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[325][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[325][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[325][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[325][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[325][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[325][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[325][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[325][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[325][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[325][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[325][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[325][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[325][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[325][MAX] = ActionEntry(SHIFT, 155);
}
void Cego::loadParser235()
{
   _jumpMap[325][ObjSpec] = 122;
   _jumpMap[325][Constant] = 121;
   _jumpMap[325][SignedFloat] = 120;
   _jumpMap[325][SignedInt] = 119;
   _jumpMap[325][Attribute] = 118;
   _jumpMap[325][ExpressionList] = 503;
   _jumpMap[325][Function] = 117;
   _jumpMap[325][Factor] = 116;
   _jumpMap[325][Term] = 115;
   _jumpMap[325][Expr] = 463;
   _jumpMap[325][CasePrepare] = 113;
   _jumpMap[325][CaseClause] = 112;
   _actionMap[326][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[326][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[326][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[326][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[326][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[326][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[326][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[326][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[326][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[326][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[326][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[326][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[326][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[326][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[326][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[326][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[326][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[326][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[326][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[326][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[326][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[326][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[326][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[326][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[326][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[326][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[326][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[326][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[326][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[326][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[326][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[326][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[326][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[326][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[326][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[326][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[326][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[326][CLOBSIZE] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser236()
{
   _actionMap[326][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[326][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[326][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[326][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[326][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[326][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[326][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[326][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[326][LB] = ActionEntry(SHIFT, 177);
   _actionMap[326][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[326][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[326][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[326][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[326][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[326][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[326][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[326][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[326][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[326][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[326][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[326][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[326][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[326][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[326][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[326][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[326][ObjSpec] = 122;
   _jumpMap[326][Constant] = 121;
   _jumpMap[326][SignedFloat] = 120;
   _jumpMap[326][SignedInt] = 119;
   _jumpMap[326][Attribute] = 118;
   _jumpMap[326][ExpressionList] = 504;
   _jumpMap[326][Function] = 117;
   _jumpMap[326][Factor] = 116;
   _jumpMap[326][Term] = 115;
   _jumpMap[326][Expr] = 463;
   _jumpMap[326][CasePrepare] = 113;
   _jumpMap[326][CaseClause] = 112;
   _actionMap[327][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[327][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[327][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[327][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[327][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[327][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[327][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[327][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[327][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[327][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[327][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[327][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[327][LONG2DATE] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser237()
{
   _actionMap[327][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[327][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[327][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[327][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[327][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[327][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[327][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[327][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[327][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[327][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[327][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[327][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[327][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[327][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[327][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[327][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[327][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[327][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[327][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[327][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[327][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[327][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[327][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[327][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[327][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[327][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[327][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[327][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[327][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[327][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[327][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[327][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[327][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[327][LB] = ActionEntry(SHIFT, 177);
   _actionMap[327][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[327][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[327][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[327][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[327][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[327][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[327][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[327][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[327][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[327][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[327][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[327][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[327][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[327][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[327][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[327][MAX] = ActionEntry(SHIFT, 155);
}
void Cego::loadParser238()
{
   _jumpMap[327][ObjSpec] = 122;
   _jumpMap[327][Constant] = 121;
   _jumpMap[327][SignedFloat] = 120;
   _jumpMap[327][SignedInt] = 119;
   _jumpMap[327][Attribute] = 118;
   _jumpMap[327][ExpressionList] = 505;
   _jumpMap[327][Function] = 117;
   _jumpMap[327][Factor] = 116;
   _jumpMap[327][Term] = 115;
   _jumpMap[327][Expr] = 463;
   _jumpMap[327][CasePrepare] = 113;
   _jumpMap[327][CaseClause] = 112;
   _actionMap[328][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[328][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[328][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[328][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[328][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[328][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[328][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[328][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[328][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[328][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[328][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[328][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[328][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[328][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[328][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[328][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[328][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[328][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[328][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[328][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[328][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[328][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[328][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[328][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[328][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[328][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[328][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[328][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[328][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[328][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[328][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[328][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[328][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[328][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[328][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[328][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[328][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[328][CLOBSIZE] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser239()
{
   _actionMap[328][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[328][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[328][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[328][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[328][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[328][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[328][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[328][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[328][LB] = ActionEntry(SHIFT, 177);
   _actionMap[328][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[328][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[328][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[328][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[328][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[328][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[328][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[328][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[328][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[328][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[328][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[328][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[328][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[328][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[328][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[328][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[328][ObjSpec] = 122;
   _jumpMap[328][Constant] = 121;
   _jumpMap[328][SignedFloat] = 120;
   _jumpMap[328][SignedInt] = 119;
   _jumpMap[328][Attribute] = 118;
   _jumpMap[328][ExpressionList] = 506;
   _jumpMap[328][Function] = 117;
   _jumpMap[328][Factor] = 116;
   _jumpMap[328][Term] = 115;
   _jumpMap[328][Expr] = 463;
   _jumpMap[328][CasePrepare] = 113;
   _jumpMap[328][CaseClause] = 112;
   _actionMap[329][IDENTIFIER] = ActionEntry(SHIFT, 507);
   _actionMap[330][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[330][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[330][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[330][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[330][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[330][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[330][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[330][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[330][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[330][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[330][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[330][DATE2LONG] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser240()
{
   _actionMap[330][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[330][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[330][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[330][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[330][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[330][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[330][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[330][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[330][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[330][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[330][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[330][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[330][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[330][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[330][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[330][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[330][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[330][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[330][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[330][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[330][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[330][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[330][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[330][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[330][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[330][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[330][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[330][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[330][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[330][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[330][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[330][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[330][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[330][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[330][LB] = ActionEntry(SHIFT, 177);
   _actionMap[330][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[330][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[330][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[330][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[330][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[330][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[330][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[330][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[330][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[330][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[330][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[330][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[330][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[330][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[330][MIN] = ActionEntry(SHIFT, 154);
}
void Cego::loadParser241()
{
   _actionMap[330][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[330][ObjSpec] = 122;
   _jumpMap[330][Constant] = 121;
   _jumpMap[330][SignedFloat] = 120;
   _jumpMap[330][SignedInt] = 119;
   _jumpMap[330][Attribute] = 118;
   _jumpMap[330][ExpressionList] = 508;
   _jumpMap[330][Function] = 117;
   _jumpMap[330][Factor] = 116;
   _jumpMap[330][Term] = 115;
   _jumpMap[330][Expr] = 463;
   _jumpMap[330][CasePrepare] = 113;
   _jumpMap[330][CaseClause] = 112;
   _actionMap[331][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[331][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[331][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[331][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[331][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[331][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[331][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[331][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[331][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[331][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[331][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[331][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[331][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[331][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[331][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[331][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[331][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[331][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[331][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[331][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[331][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[331][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[331][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[331][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[331][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[331][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[331][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[331][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[331][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[331][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[331][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[331][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[331][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[331][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[331][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[331][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[331][BLOBREF] = ActionEntry(SHIFT, 131);
}
void Cego::loadParser242()
{
   _actionMap[331][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[331][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[331][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[331][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[331][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[331][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[331][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[331][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[331][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[331][LB] = ActionEntry(SHIFT, 177);
   _actionMap[331][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[331][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[331][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[331][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[331][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[331][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[331][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[331][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[331][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[331][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[331][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[331][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[331][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[331][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[331][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[331][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[331][ObjSpec] = 122;
   _jumpMap[331][Constant] = 121;
   _jumpMap[331][SignedFloat] = 120;
   _jumpMap[331][SignedInt] = 119;
   _jumpMap[331][Attribute] = 118;
   _jumpMap[331][Function] = 117;
   _jumpMap[331][Factor] = 116;
   _jumpMap[331][Term] = 115;
   _jumpMap[331][Expr] = 509;
   _jumpMap[331][CasePrepare] = 113;
   _jumpMap[331][CaseClause] = 112;
   _actionMap[332][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[332][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[332][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[332][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[332][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[332][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[332][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[332][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[332][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[332][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[332][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[332][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[332][LONG2DATE] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser243()
{
   _actionMap[332][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[332][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[332][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[332][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[332][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[332][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[332][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[332][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[332][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[332][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[332][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[332][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[332][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[332][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[332][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[332][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[332][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[332][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[332][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[332][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[332][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[332][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[332][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[332][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[332][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[332][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[332][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[332][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[332][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[332][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[332][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[332][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[332][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[332][LB] = ActionEntry(SHIFT, 177);
   _actionMap[332][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[332][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[332][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[332][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[332][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[332][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[332][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[332][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[332][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[332][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[332][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[332][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[332][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[332][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[332][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[332][MAX] = ActionEntry(SHIFT, 155);
}
void Cego::loadParser244()
{
   _jumpMap[332][ObjSpec] = 122;
   _jumpMap[332][Constant] = 121;
   _jumpMap[332][SignedFloat] = 120;
   _jumpMap[332][SignedInt] = 119;
   _jumpMap[332][Attribute] = 118;
   _jumpMap[332][ExpressionList] = 510;
   _jumpMap[332][Function] = 117;
   _jumpMap[332][Factor] = 116;
   _jumpMap[332][Term] = 115;
   _jumpMap[332][Expr] = 463;
   _jumpMap[332][CasePrepare] = 113;
   _jumpMap[332][CaseClause] = 112;
   _actionMap[333][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[333][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[333][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[333][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[333][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[333][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[333][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[333][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[333][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[333][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[333][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[333][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[333][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[333][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[333][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[333][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[333][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[333][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[333][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[333][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[333][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[333][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[333][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[333][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[333][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[333][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[333][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[333][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[333][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[333][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[333][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[333][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[333][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[333][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[333][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[333][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[333][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[333][CLOBSIZE] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser245()
{
   _actionMap[333][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[333][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[333][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[333][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[333][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[333][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[333][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[333][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[333][LB] = ActionEntry(SHIFT, 177);
   _actionMap[333][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[333][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[333][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[333][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[333][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[333][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[333][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[333][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[333][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[333][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[333][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[333][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[333][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[333][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[333][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[333][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[333][ObjSpec] = 122;
   _jumpMap[333][Constant] = 121;
   _jumpMap[333][SignedFloat] = 120;
   _jumpMap[333][SignedInt] = 119;
   _jumpMap[333][Attribute] = 118;
   _jumpMap[333][ExpressionList] = 511;
   _jumpMap[333][Function] = 117;
   _jumpMap[333][Factor] = 116;
   _jumpMap[333][Term] = 115;
   _jumpMap[333][Expr] = 463;
   _jumpMap[333][CasePrepare] = 113;
   _jumpMap[333][CaseClause] = 112;
   _actionMap[334][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[334][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[334][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[334][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[334][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[334][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[334][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[334][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[334][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[334][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[334][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[334][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[334][LONG2DATE] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser246()
{
   _actionMap[334][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[334][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[334][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[334][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[334][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[334][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[334][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[334][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[334][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[334][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[334][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[334][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[334][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[334][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[334][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[334][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[334][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[334][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[334][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[334][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[334][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[334][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[334][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[334][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[334][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[334][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[334][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[334][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[334][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[334][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[334][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[334][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[334][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[334][LB] = ActionEntry(SHIFT, 177);
   _actionMap[334][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[334][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[334][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[334][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[334][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[334][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[334][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[334][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[334][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[334][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[334][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[334][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[334][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[334][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[334][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[334][MAX] = ActionEntry(SHIFT, 155);
}
void Cego::loadParser247()
{
   _jumpMap[334][ObjSpec] = 122;
   _jumpMap[334][Constant] = 121;
   _jumpMap[334][SignedFloat] = 120;
   _jumpMap[334][SignedInt] = 119;
   _jumpMap[334][Attribute] = 118;
   _jumpMap[334][ExpressionList] = 512;
   _jumpMap[334][Function] = 117;
   _jumpMap[334][Factor] = 116;
   _jumpMap[334][Term] = 115;
   _jumpMap[334][Expr] = 463;
   _jumpMap[334][CasePrepare] = 113;
   _jumpMap[334][CaseClause] = 112;
   _actionMap[335][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[335][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[335][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[335][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[335][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[335][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[335][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[335][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[335][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[335][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[335][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[335][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[335][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[335][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[335][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[335][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[335][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[335][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[335][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[335][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[335][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[335][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[335][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[335][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[335][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[335][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[335][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[335][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[335][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[335][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[335][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[335][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[335][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[335][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[335][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[335][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[335][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[335][CLOBSIZE] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser248()
{
   _actionMap[335][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[335][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[335][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[335][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[335][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[335][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[335][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[335][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[335][LB] = ActionEntry(SHIFT, 177);
   _actionMap[335][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[335][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[335][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[335][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[335][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[335][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[335][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[335][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[335][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[335][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[335][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[335][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[335][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[335][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[335][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[335][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[335][ObjSpec] = 122;
   _jumpMap[335][Constant] = 121;
   _jumpMap[335][SignedFloat] = 120;
   _jumpMap[335][SignedInt] = 119;
   _jumpMap[335][Attribute] = 118;
   _jumpMap[335][ExpressionList] = 513;
   _jumpMap[335][Function] = 117;
   _jumpMap[335][Factor] = 116;
   _jumpMap[335][Term] = 115;
   _jumpMap[335][Expr] = 463;
   _jumpMap[335][CasePrepare] = 113;
   _jumpMap[335][CaseClause] = 112;
   _actionMap[336][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[336][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[336][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[336][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[336][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[336][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[336][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[336][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[336][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[336][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[336][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[336][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[336][LONG2DATE] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser249()
{
   _actionMap[336][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[336][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[336][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[336][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[336][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[336][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[336][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[336][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[336][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[336][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[336][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[336][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[336][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[336][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[336][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[336][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[336][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[336][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[336][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[336][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[336][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[336][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[336][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[336][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[336][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[336][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[336][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[336][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[336][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[336][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[336][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[336][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[336][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[336][LB] = ActionEntry(SHIFT, 177);
   _actionMap[336][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[336][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[336][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[336][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[336][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[336][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[336][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[336][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[336][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[336][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[336][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[336][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[336][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[336][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[336][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[336][MAX] = ActionEntry(SHIFT, 155);
}
void Cego::loadParser250()
{
   _jumpMap[336][ObjSpec] = 122;
   _jumpMap[336][Constant] = 121;
   _jumpMap[336][SignedFloat] = 120;
   _jumpMap[336][SignedInt] = 119;
   _jumpMap[336][Attribute] = 118;
   _jumpMap[336][ExpressionList] = 514;
   _jumpMap[336][Function] = 117;
   _jumpMap[336][Factor] = 116;
   _jumpMap[336][Term] = 115;
   _jumpMap[336][Expr] = 463;
   _jumpMap[336][CasePrepare] = 113;
   _jumpMap[336][CaseClause] = 112;
   _actionMap[337][RB] = ActionEntry(SHIFT, 515);
   _actionMap[338][RB] = ActionEntry(SHIFT, 516);
   _actionMap[338][AND] = ActionEntry(SHIFT, 440);
   _actionMap[338][OR] = ActionEntry(SHIFT, 441);
   _actionMap[339][RB] = ActionEntry(SHIFT, 517);
   _actionMap[340][RB] = ActionEntry(SHIFT, 518);
   _actionMap[341][RB] = ActionEntry(SHIFT, 519);
   _actionMap[342][RB] = ActionEntry(SHIFT, 520);
   _actionMap[343][RB] = ActionEntry(SHIFT, 521);
   _actionMap[344][RB] = ActionEntry(SHIFT, 522);
   _actionMap[345][WHEN] = ActionEntry(REDUCE, 402);
   _actionMap[345][ELSE] = ActionEntry(REDUCE, 402);
   _actionMap[345][AS] = ActionEntry(REDUCE, 402);
   _actionMap[345][FROM] = ActionEntry(REDUCE, 402);
   _actionMap[345][END_TOKEN] = ActionEntry(REDUCE, 402);
   _actionMap[345][BEGIN] = ActionEntry(REDUCE, 402);
   _actionMap[345][THEN] = ActionEntry(REDUCE, 402);
   _actionMap[345][LEFT] = ActionEntry(REDUCE, 402);
   _actionMap[345][RIGHT] = ActionEntry(REDUCE, 402);
   _actionMap[345][INNER] = ActionEntry(REDUCE, 402);
   _actionMap[345][JOIN] = ActionEntry(REDUCE, 402);
   _actionMap[345][ORDER] = ActionEntry(REDUCE, 402);
   _actionMap[345][GROUP] = ActionEntry(REDUCE, 402);
   _actionMap[345][RETURNTOKEN] = ActionEntry(REDUCE, 402);
   _actionMap[345][WHERE] = ActionEntry(REDUCE, 402);
   _actionMap[345][NULLTOKEN] = ActionEntry(REDUCE, 402);
   _actionMap[345][OR] = ActionEntry(REDUCE, 402);
   _actionMap[345][AND] = ActionEntry(REDUCE, 402);
   _actionMap[345][LIKE] = ActionEntry(REDUCE, 402);
   _actionMap[345][IS] = ActionEntry(REDUCE, 402);
   _actionMap[345][BETWEEN] = ActionEntry(REDUCE, 402);
   _actionMap[345][EQU] = ActionEntry(REDUCE, 402);
   _actionMap[345][NEGATION] = ActionEntry(REDUCE, 402);
   _actionMap[345][LT] = ActionEntry(REDUCE, 402);
   _actionMap[345][MT] = ActionEntry(REDUCE, 402);
   _actionMap[345][NOT] = ActionEntry(REDUCE, 402);
   _actionMap[345][INTOK] = ActionEntry(REDUCE, 402);
   _actionMap[345][DESC] = ActionEntry(REDUCE, 402);
}
void Cego::loadParser251()
{
   _actionMap[345][ASC] = ActionEntry(REDUCE, 402);
   _actionMap[345][KSEP] = ActionEntry(REDUCE, 402);
   _actionMap[345][ROWLIMIT] = ActionEntry(REDUCE, 402);
   _actionMap[345][UNION] = ActionEntry(REDUCE, 402);
   _actionMap[345][ENDTOKEN] = ActionEntry(REDUCE, 402);
   _actionMap[345][RB] = ActionEntry(REDUCE, 402);
   _actionMap[345][CONCAT] = ActionEntry(REDUCE, 402);
   _actionMap[345][STAR] = ActionEntry(REDUCE, 402);
   _actionMap[345][DIVISION] = ActionEntry(REDUCE, 402);
   _actionMap[345][MINUS] = ActionEntry(REDUCE, 402);
   _actionMap[345][PLUS] = ActionEntry(REDUCE, 402);
   _actionMap[345][SEMICOLON] = ActionEntry(REDUCE, 402);
   _actionMap[346][WHEN] = ActionEntry(REDUCE, 404);
   _actionMap[346][ELSE] = ActionEntry(REDUCE, 404);
   _actionMap[346][AS] = ActionEntry(REDUCE, 404);
   _actionMap[346][FROM] = ActionEntry(REDUCE, 404);
   _actionMap[346][END_TOKEN] = ActionEntry(REDUCE, 404);
   _actionMap[346][BEGIN] = ActionEntry(REDUCE, 404);
   _actionMap[346][THEN] = ActionEntry(REDUCE, 404);
   _actionMap[346][LEFT] = ActionEntry(REDUCE, 404);
   _actionMap[346][RIGHT] = ActionEntry(REDUCE, 404);
   _actionMap[346][INNER] = ActionEntry(REDUCE, 404);
   _actionMap[346][JOIN] = ActionEntry(REDUCE, 404);
   _actionMap[346][ORDER] = ActionEntry(REDUCE, 404);
   _actionMap[346][GROUP] = ActionEntry(REDUCE, 404);
   _actionMap[346][RETURNTOKEN] = ActionEntry(REDUCE, 404);
   _actionMap[346][WHERE] = ActionEntry(REDUCE, 404);
   _actionMap[346][NULLTOKEN] = ActionEntry(REDUCE, 404);
   _actionMap[346][OR] = ActionEntry(REDUCE, 404);
   _actionMap[346][AND] = ActionEntry(REDUCE, 404);
   _actionMap[346][LIKE] = ActionEntry(REDUCE, 404);
   _actionMap[346][IS] = ActionEntry(REDUCE, 404);
   _actionMap[346][BETWEEN] = ActionEntry(REDUCE, 404);
   _actionMap[346][EQU] = ActionEntry(REDUCE, 404);
   _actionMap[346][NEGATION] = ActionEntry(REDUCE, 404);
   _actionMap[346][LT] = ActionEntry(REDUCE, 404);
   _actionMap[346][MT] = ActionEntry(REDUCE, 404);
   _actionMap[346][NOT] = ActionEntry(REDUCE, 404);
   _actionMap[346][INTOK] = ActionEntry(REDUCE, 404);
   _actionMap[346][DESC] = ActionEntry(REDUCE, 404);
   _actionMap[346][ASC] = ActionEntry(REDUCE, 404);
   _actionMap[346][KSEP] = ActionEntry(REDUCE, 404);
   _actionMap[346][ROWLIMIT] = ActionEntry(REDUCE, 404);
   _actionMap[346][UNION] = ActionEntry(REDUCE, 404);
   _actionMap[346][ENDTOKEN] = ActionEntry(REDUCE, 404);
   _actionMap[346][RB] = ActionEntry(REDUCE, 404);
   _actionMap[346][CONCAT] = ActionEntry(REDUCE, 404);
   _actionMap[346][STAR] = ActionEntry(REDUCE, 404);
   _actionMap[346][DIVISION] = ActionEntry(REDUCE, 404);
   _actionMap[346][MINUS] = ActionEntry(REDUCE, 404);
}
void Cego::loadParser252()
{
   _actionMap[346][PLUS] = ActionEntry(REDUCE, 404);
   _actionMap[346][SEMICOLON] = ActionEntry(REDUCE, 404);
   _actionMap[347][WHEN] = ActionEntry(REDUCE, 400);
   _actionMap[347][ELSE] = ActionEntry(REDUCE, 400);
   _actionMap[347][FROM] = ActionEntry(REDUCE, 400);
   _actionMap[347][AS] = ActionEntry(REDUCE, 400);
   _actionMap[347][END_TOKEN] = ActionEntry(REDUCE, 400);
   _actionMap[347][BEGIN] = ActionEntry(REDUCE, 400);
   _actionMap[347][THEN] = ActionEntry(REDUCE, 400);
   _actionMap[347][LEFT] = ActionEntry(REDUCE, 400);
   _actionMap[347][RIGHT] = ActionEntry(REDUCE, 400);
   _actionMap[347][INNER] = ActionEntry(REDUCE, 400);
   _actionMap[347][JOIN] = ActionEntry(REDUCE, 400);
   _actionMap[347][GROUP] = ActionEntry(REDUCE, 400);
   _actionMap[347][RETURNTOKEN] = ActionEntry(REDUCE, 400);
   _actionMap[347][WHERE] = ActionEntry(REDUCE, 400);
   _actionMap[347][HAVING] = ActionEntry(REDUCE, 400);
   _actionMap[347][ORDER] = ActionEntry(REDUCE, 400);
   _actionMap[347][AND] = ActionEntry(REDUCE, 400);
   _actionMap[347][OR] = ActionEntry(REDUCE, 400);
   _actionMap[347][INTOK] = ActionEntry(REDUCE, 400);
   _actionMap[347][NOT] = ActionEntry(REDUCE, 400);
   _actionMap[347][MT] = ActionEntry(REDUCE, 400);
   _actionMap[347][LT] = ActionEntry(REDUCE, 400);
   _actionMap[347][NEGATION] = ActionEntry(REDUCE, 400);
   _actionMap[347][EQU] = ActionEntry(REDUCE, 400);
   _actionMap[347][BETWEEN] = ActionEntry(REDUCE, 400);
   _actionMap[347][IS] = ActionEntry(REDUCE, 400);
   _actionMap[347][LIKE] = ActionEntry(REDUCE, 400);
   _actionMap[347][RB] = ActionEntry(REDUCE, 400);
   _actionMap[347][ENDTOKEN] = ActionEntry(REDUCE, 400);
   _actionMap[347][UNION] = ActionEntry(REDUCE, 400);
   _actionMap[347][ROWLIMIT] = ActionEntry(REDUCE, 400);
   _actionMap[347][KSEP] = ActionEntry(REDUCE, 400);
   _actionMap[347][ASC] = ActionEntry(REDUCE, 400);
   _actionMap[347][DESC] = ActionEntry(REDUCE, 400);
   _actionMap[347][PLUS] = ActionEntry(REDUCE, 400);
   _actionMap[347][MINUS] = ActionEntry(REDUCE, 400);
   _actionMap[347][DIVISION] = ActionEntry(REDUCE, 400);
   _actionMap[347][STAR] = ActionEntry(REDUCE, 400);
   _actionMap[347][CONCAT] = ActionEntry(REDUCE, 400);
   _actionMap[347][SEMICOLON] = ActionEntry(REDUCE, 400);
   _actionMap[348][TO] = ActionEntry(SHIFT, 523);
   _actionMap[349][TO] = ActionEntry(SHIFT, 524);
   _actionMap[350][TO] = ActionEntry(SHIFT, 525);
   _actionMap[351][TO] = ActionEntry(SHIFT, 526);
   _actionMap[352][TO] = ActionEntry(SHIFT, 527);
   _actionMap[353][TO] = ActionEntry(SHIFT, 528);
   _actionMap[354][TO] = ActionEntry(SHIFT, 529);
   _actionMap[355][TO] = ActionEntry(SHIFT, 530);
}
void Cego::loadParser253()
{
   _actionMap[356][SEMICOLON] = ActionEntry(REDUCE, 50);
   _actionMap[357][SEMICOLON] = ActionEntry(REDUCE, 49);
   _actionMap[358][SEMICOLON] = ActionEntry(REDUCE, 168);
   _actionMap[358][RB] = ActionEntry(REDUCE, 168);
   _actionMap[359][SEMICOLON] = ActionEntry(REDUCE, 170);
   _actionMap[359][RB] = ActionEntry(REDUCE, 170);
   _actionMap[360][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[360][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[360][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[360][ObjSpec] = 535;
   _jumpMap[360][Table] = 534;
   _jumpMap[360][TableList] = 533;
   _jumpMap[360][JoinSpecList] = 532;
   _jumpMap[360][TableSource] = 531;
   _actionMap[361][KSEP] = ActionEntry(SHIFT, 536);
   _actionMap[361][FROM] = ActionEntry(REDUCE, 172);
   _actionMap[361][RB] = ActionEntry(REDUCE, 172);
   _actionMap[361][SEMICOLON] = ActionEntry(REDUCE, 172);
   _actionMap[361][ENDTOKEN] = ActionEntry(REDUCE, 172);
   _actionMap[362][FROM] = ActionEntry(REDUCE, 175);
   _actionMap[362][RB] = ActionEntry(REDUCE, 175);
   _actionMap[362][SEMICOLON] = ActionEntry(REDUCE, 175);
   _actionMap[362][ENDTOKEN] = ActionEntry(REDUCE, 175);
   _actionMap[362][KSEP] = ActionEntry(REDUCE, 175);
   _actionMap[363][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[363][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[363][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[363][KSEP] = ActionEntry(REDUCE, 196);
   _actionMap[363][AS] = ActionEntry(SHIFT, 539);
   _actionMap[363][FROM] = ActionEntry(REDUCE, 196);
   _actionMap[363][RB] = ActionEntry(REDUCE, 196);
   _actionMap[363][SEMICOLON] = ActionEntry(REDUCE, 196);
   _actionMap[363][ENDTOKEN] = ActionEntry(REDUCE, 196);
   _jumpMap[363][NoAliasOpt] = 538;
   _jumpMap[363][AliasOpt] = 537;
   _actionMap[364][SEMICOLON] = ActionEntry(REDUCE, 45);
   _actionMap[365][SEMICOLON] = ActionEntry(REDUCE, 44);
   _actionMap[366][SEMICOLON] = ActionEntry(REDUCE, 47);
   _actionMap[367][SEMICOLON] = ActionEntry(REDUCE, 46);
   _actionMap[368][TO] = ActionEntry(SHIFT, 540);
   _actionMap[369][SEMICOLON] = ActionEntry(REDUCE, 43);
   _actionMap[370][SEMICOLON] = ActionEntry(REDUCE, 42);
   _actionMap[371][SEMICOLON] = ActionEntry(REDUCE, 48);
   _actionMap[372][SEMICOLON] = ActionEntry(REDUCE, 35);
   _actionMap[373][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[373][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[373][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[373][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[373][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[373][TRIM] = ActionEntry(SHIFT, 173);
}
void Cego::loadParser254()
{
   _actionMap[373][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[373][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[373][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[373][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[373][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[373][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[373][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[373][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[373][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[373][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[373][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[373][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[373][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[373][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[373][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[373][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[373][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[373][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[373][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[373][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[373][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[373][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[373][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[373][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[373][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[373][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[373][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[373][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[373][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[373][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[373][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[373][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[373][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[373][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[373][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[373][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[373][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[373][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[373][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[373][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[373][LB] = ActionEntry(SHIFT, 177);
   _actionMap[373][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[373][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[373][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[373][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[373][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[373][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[373][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[373][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[373][CASE] = ActionEntry(SHIFT, 132);
}
void Cego::loadParser255()
{
   _actionMap[373][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[373][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[373][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[373][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[373][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[373][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[373][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[373][ObjSpec] = 122;
   _jumpMap[373][Constant] = 121;
   _jumpMap[373][SignedFloat] = 120;
   _jumpMap[373][SignedInt] = 119;
   _jumpMap[373][Attribute] = 118;
   _jumpMap[373][Function] = 117;
   _jumpMap[373][Factor] = 116;
   _jumpMap[373][Term] = 115;
   _jumpMap[373][Expr] = 541;
   _jumpMap[373][CasePrepare] = 113;
   _jumpMap[373][CaseClause] = 112;
   _actionMap[374][SEMICOLON] = ActionEntry(REDUCE, 33);
   _actionMap[375][SEMICOLON] = ActionEntry(REDUCE, 31);
   _actionMap[376][SEMICOLON] = ActionEntry(REDUCE, 34);
   _actionMap[377][SEMICOLON] = ActionEntry(REDUCE, 32);
   _actionMap[378][SEMICOLON] = ActionEntry(REDUCE, 76);
   _actionMap[379][SET] = ActionEntry(SHIFT, 380);
   _actionMap[380][IDENTIFIER] = ActionEntry(SHIFT, 544);
   _jumpMap[380][Assignment] = 543;
   _jumpMap[380][UpdateList] = 542;
   _actionMap[381][SET] = ActionEntry(REDUCE, 166);
   _actionMap[381][WHERE] = ActionEntry(REDUCE, 166);
   _actionMap[381][RETURNTOKEN] = ActionEntry(REDUCE, 166);
   _actionMap[381][SEMICOLON] = ActionEntry(REDUCE, 166);
   _actionMap[381][GROUP] = ActionEntry(REDUCE, 166);
   _actionMap[381][ORDER] = ActionEntry(REDUCE, 166);
   _actionMap[381][ROWLIMIT] = ActionEntry(REDUCE, 166);
   _actionMap[381][UNION] = ActionEntry(REDUCE, 166);
   _actionMap[381][ENDTOKEN] = ActionEntry(REDUCE, 166);
   _actionMap[381][RB] = ActionEntry(REDUCE, 166);
   _actionMap[382][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[382][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[382][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[382][ObjSpec] = 545;
   _actionMap[46][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[46][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[46][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[46][ObjSpec] = 220;
   _actionMap[47][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[47][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[47][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[47][ObjSpec] = 221;
   _actionMap[48][IDENTIFIER] = ActionEntry(SHIFT, 62);
}
void Cego::loadParser256()
{
   _actionMap[48][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[48][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[48][ObjSpec] = 222;
   _actionMap[49][FOR] = ActionEntry(REDUCE, 135);
   _actionMap[49][SEMICOLON] = ActionEntry(REDUCE, 135);
   _actionMap[49][QUALIFIEDOBJ] = ActionEntry(REDUCE, 135);
   _actionMap[49][QUALIFIEDTS] = ActionEntry(REDUCE, 135);
   _actionMap[49][ON] = ActionEntry(REDUCE, 135);
   _actionMap[49][IDENTIFIER] = ActionEntry(REDUCE, 135);
   _actionMap[50][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[50][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[50][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[50][ObjSpec] = 223;
   _actionMap[51][IDENTIFIER] = ActionEntry(SHIFT, 225);
   _jumpMap[51][CounterId] = 224;
   _actionMap[52][KEY] = ActionEntry(SHIFT, 226);
   _actionMap[53][FOR] = ActionEntry(REDUCE, 136);
   _actionMap[53][SEMICOLON] = ActionEntry(REDUCE, 136);
   _actionMap[53][QUALIFIEDOBJ] = ActionEntry(REDUCE, 136);
   _actionMap[53][QUALIFIEDTS] = ActionEntry(REDUCE, 136);
   _actionMap[53][ON] = ActionEntry(REDUCE, 136);
   _actionMap[53][IDENTIFIER] = ActionEntry(REDUCE, 136);
   _actionMap[54][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[54][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[54][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[54][ObjSpec] = 227;
   _actionMap[55][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[55][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[55][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[55][ObjSpec] = 228;
   _actionMap[56][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[56][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[56][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[56][ObjSpec] = 229;
   _actionMap[57][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[57][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[57][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[57][ObjSpec] = 230;
   _actionMap[58][ENDTOKEN] = ActionEntry(ACCEPT, 0);
   _actionMap[59][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[59][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[59][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[59][ObjSpec] = 231;
   _actionMap[60][IDENTIFIED] = ActionEntry(SHIFT, 232);
   _actionMap[61][LB] = ActionEntry(SHIFT, 233);
   _actionMap[62][BEGIN] = ActionEntry(REDUCE, 420);
   _actionMap[62][TO] = ActionEntry(REDUCE, 420);
   _actionMap[62][VALUES] = ActionEntry(REDUCE, 420);
   _actionMap[62][SELECT] = ActionEntry(REDUCE, 420);
   _actionMap[62][SET] = ActionEntry(REDUCE, 420);
}
void Cego::loadParser257()
{
   _actionMap[62][AS] = ActionEntry(REDUCE, 420);
   _actionMap[62][BEFORE] = ActionEntry(REDUCE, 420);
   _actionMap[62][AFTER] = ActionEntry(REDUCE, 420);
   _actionMap[62][DROP] = ActionEntry(REDUCE, 420);
   _actionMap[62][MODIFY] = ActionEntry(REDUCE, 420);
   _actionMap[62][RENAME] = ActionEntry(REDUCE, 420);
   _actionMap[62][ADD] = ActionEntry(REDUCE, 420);
   _actionMap[62][KSEP] = ActionEntry(REDUCE, 420);
   _actionMap[62][LEFT] = ActionEntry(REDUCE, 420);
   _actionMap[62][RIGHT] = ActionEntry(REDUCE, 420);
   _actionMap[62][INNER] = ActionEntry(REDUCE, 420);
   _actionMap[62][JOIN] = ActionEntry(REDUCE, 420);
   _actionMap[62][RB] = ActionEntry(REDUCE, 420);
   _actionMap[62][ENDTOKEN] = ActionEntry(REDUCE, 420);
   _actionMap[62][UNION] = ActionEntry(REDUCE, 420);
   _actionMap[62][ROWLIMIT] = ActionEntry(REDUCE, 420);
   _actionMap[62][ORDER] = ActionEntry(REDUCE, 420);
   _actionMap[62][GROUP] = ActionEntry(REDUCE, 420);
   _actionMap[62][SEMICOLON] = ActionEntry(REDUCE, 420);
   _actionMap[62][RETURNTOKEN] = ActionEntry(REDUCE, 420);
   _actionMap[62][WHERE] = ActionEntry(REDUCE, 420);
   _actionMap[62][LB] = ActionEntry(REDUCE, 420);
   _actionMap[62][ON] = ActionEntry(REDUCE, 420);
   _actionMap[62][IDENTIFIER] = ActionEntry(REDUCE, 420);
   _actionMap[63][BEGIN] = ActionEntry(REDUCE, 421);
   _actionMap[63][TO] = ActionEntry(REDUCE, 421);
   _actionMap[63][VALUES] = ActionEntry(REDUCE, 421);
   _actionMap[63][SELECT] = ActionEntry(REDUCE, 421);
   _actionMap[63][SET] = ActionEntry(REDUCE, 421);
   _actionMap[63][AS] = ActionEntry(REDUCE, 421);
   _actionMap[63][BEFORE] = ActionEntry(REDUCE, 421);
   _actionMap[63][AFTER] = ActionEntry(REDUCE, 421);
   _actionMap[63][DROP] = ActionEntry(REDUCE, 421);
   _actionMap[63][MODIFY] = ActionEntry(REDUCE, 421);
   _actionMap[63][RENAME] = ActionEntry(REDUCE, 421);
   _actionMap[63][ADD] = ActionEntry(REDUCE, 421);
   _actionMap[63][KSEP] = ActionEntry(REDUCE, 421);
   _actionMap[63][LEFT] = ActionEntry(REDUCE, 421);
   _actionMap[63][RIGHT] = ActionEntry(REDUCE, 421);
   _actionMap[63][INNER] = ActionEntry(REDUCE, 421);
   _actionMap[63][JOIN] = ActionEntry(REDUCE, 421);
   _actionMap[63][RB] = ActionEntry(REDUCE, 421);
   _actionMap[63][ENDTOKEN] = ActionEntry(REDUCE, 421);
   _actionMap[63][UNION] = ActionEntry(REDUCE, 421);
   _actionMap[63][ROWLIMIT] = ActionEntry(REDUCE, 421);
   _actionMap[63][ORDER] = ActionEntry(REDUCE, 421);
   _actionMap[63][GROUP] = ActionEntry(REDUCE, 421);
   _actionMap[63][SEMICOLON] = ActionEntry(REDUCE, 421);
   _actionMap[63][RETURNTOKEN] = ActionEntry(REDUCE, 421);
   _actionMap[63][WHERE] = ActionEntry(REDUCE, 421);
}
void Cego::loadParser258()
{
   _actionMap[63][LB] = ActionEntry(REDUCE, 421);
   _actionMap[63][ON] = ActionEntry(REDUCE, 421);
   _actionMap[63][IDENTIFIER] = ActionEntry(REDUCE, 421);
   _actionMap[64][BEGIN] = ActionEntry(REDUCE, 422);
   _actionMap[64][TO] = ActionEntry(REDUCE, 422);
   _actionMap[64][VALUES] = ActionEntry(REDUCE, 422);
   _actionMap[64][SELECT] = ActionEntry(REDUCE, 422);
   _actionMap[64][SET] = ActionEntry(REDUCE, 422);
   _actionMap[64][AS] = ActionEntry(REDUCE, 422);
   _actionMap[64][BEFORE] = ActionEntry(REDUCE, 422);
   _actionMap[64][AFTER] = ActionEntry(REDUCE, 422);
   _actionMap[64][DROP] = ActionEntry(REDUCE, 422);
   _actionMap[64][MODIFY] = ActionEntry(REDUCE, 422);
   _actionMap[64][RENAME] = ActionEntry(REDUCE, 422);
   _actionMap[64][ADD] = ActionEntry(REDUCE, 422);
   _actionMap[64][KSEP] = ActionEntry(REDUCE, 422);
   _actionMap[64][LEFT] = ActionEntry(REDUCE, 422);
   _actionMap[64][RIGHT] = ActionEntry(REDUCE, 422);
   _actionMap[64][INNER] = ActionEntry(REDUCE, 422);
   _actionMap[64][JOIN] = ActionEntry(REDUCE, 422);
   _actionMap[64][RB] = ActionEntry(REDUCE, 422);
   _actionMap[64][ENDTOKEN] = ActionEntry(REDUCE, 422);
   _actionMap[64][UNION] = ActionEntry(REDUCE, 422);
   _actionMap[64][ROWLIMIT] = ActionEntry(REDUCE, 422);
   _actionMap[64][ORDER] = ActionEntry(REDUCE, 422);
   _actionMap[64][GROUP] = ActionEntry(REDUCE, 422);
   _actionMap[64][SEMICOLON] = ActionEntry(REDUCE, 422);
   _actionMap[64][RETURNTOKEN] = ActionEntry(REDUCE, 422);
   _actionMap[64][WHERE] = ActionEntry(REDUCE, 422);
   _actionMap[64][ON] = ActionEntry(REDUCE, 422);
   _actionMap[64][IDENTIFIER] = ActionEntry(REDUCE, 422);
   _actionMap[64][LB] = ActionEntry(REDUCE, 422);
   _actionMap[65][IDENTIFIER] = ActionEntry(SHIFT, 234);
   _actionMap[66][SEMICOLON] = ActionEntry(REDUCE, 74);
   _actionMap[67][BEGIN] = ActionEntry(SHIFT, 235);
   _actionMap[68][BTREE] = ActionEntry(SHIFT, 49);
   _actionMap[68][INDEX] = ActionEntry(SHIFT, 53);
   _actionMap[68][AVLTREE] = ActionEntry(SHIFT, 238);
   _jumpMap[68][BtreeType] = 237;
   _jumpMap[68][IndexType] = 236;
   _actionMap[69][BEGIN] = ActionEntry(SHIFT, 239);
   _actionMap[70][SEMICOLON] = ActionEntry(REDUCE, 60);
   _actionMap[71][IDENTIFIER] = ActionEntry(SHIFT, 240);
   _actionMap[72][IDENTIFIER] = ActionEntry(SHIFT, 225);
   _jumpMap[72][CounterId] = 241;
   _actionMap[73][BTREE] = ActionEntry(SHIFT, 49);
   _actionMap[73][INDEX] = ActionEntry(SHIFT, 53);
   _actionMap[73][AVLTREE] = ActionEntry(SHIFT, 238);
   _jumpMap[73][BtreeType] = 237;
   _jumpMap[73][IndexType] = 242;
}
void Cego::loadParser259()
{
   _actionMap[74][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[74][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[74][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[74][ObjSpec] = 243;
   _actionMap[75][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[75][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[75][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[75][ObjSpec] = 244;
   _actionMap[76][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[76][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[76][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[76][ObjSpec] = 245;
   _actionMap[77][AVLTREE] = ActionEntry(REDUCE, 131);
   _actionMap[77][BTREE] = ActionEntry(REDUCE, 131);
   _actionMap[77][INDEX] = ActionEntry(REDUCE, 131);
   _actionMap[78][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[78][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[78][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[78][ObjSpec] = 246;
   _actionMap[79][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[79][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[79][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[79][ObjSpec] = 247;
   _actionMap[80][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[80][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[80][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[80][ObjSpec] = 248;
   _actionMap[81][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[81][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[81][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[81][ObjSpec] = 249;
   _actionMap[82][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[82][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[82][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[82][ObjSpec] = 250;
   _actionMap[83][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[83][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[83][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[83][ObjSpec] = 251;
   _actionMap[84][KEY] = ActionEntry(SHIFT, 252);
   _actionMap[85][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[85][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[85][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[85][ObjSpec] = 253;
   _actionMap[86][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[86][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[86][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[86][ObjSpec] = 254;
   _actionMap[87][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[87][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
}
void Cego::loadParser260()
{
   _actionMap[87][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[87][ObjSpec] = 255;
   _actionMap[88][EXISTS] = ActionEntry(SHIFT, 256);
   _actionMap[89][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[89][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[89][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[89][ObjSpec] = 257;
   _actionMap[90][IDENTIFIER] = ActionEntry(SHIFT, 258);
   _actionMap[90][SEMICOLON] = ActionEntry(REDUCE, 97);
   _actionMap[91][IDENTIFIER] = ActionEntry(REDUCE, 99);
   _actionMap[91][SEMICOLON] = ActionEntry(REDUCE, 99);
   _actionMap[92][FOR] = ActionEntry(SHIFT, 260);
   _actionMap[92][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[92][TableSetOpt] = 259;
   _actionMap[93][FOR] = ActionEntry(SHIFT, 260);
   _actionMap[93][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[93][TableSetOpt] = 261;
   _actionMap[94][FOR] = ActionEntry(SHIFT, 260);
   _actionMap[94][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[94][TableSetOpt] = 262;
   _actionMap[95][FOR] = ActionEntry(SHIFT, 260);
   _actionMap[95][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[95][TableSetOpt] = 263;
   _actionMap[96][FOR] = ActionEntry(SHIFT, 260);
   _actionMap[96][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[96][TableSetOpt] = 264;
   _actionMap[97][FOR] = ActionEntry(SHIFT, 260);
   _actionMap[97][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[97][TableSetOpt] = 265;
   _actionMap[98][FOR] = ActionEntry(SHIFT, 260);
   _actionMap[98][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[98][TableSetOpt] = 266;
   _actionMap[99][FOR] = ActionEntry(SHIFT, 260);
   _actionMap[99][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[99][TableSetOpt] = 267;
   _actionMap[100][FOR] = ActionEntry(SHIFT, 260);
   _actionMap[100][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[100][TableSetOpt] = 268;
   _actionMap[101][SEMICOLON] = ActionEntry(REDUCE, 2);
   _actionMap[102][FOR] = ActionEntry(SHIFT, 260);
   _actionMap[102][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[102][TableSetOpt] = 269;
   _actionMap[103][FOR] = ActionEntry(SHIFT, 260);
   _actionMap[103][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[103][TableSetOpt] = 270;
   _actionMap[104][FOR] = ActionEntry(SHIFT, 260);
   _actionMap[104][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[104][TableSetOpt] = 271;
   _actionMap[105][SEMICOLON] = ActionEntry(REDUCE, 75);
   _actionMap[106][SEMICOLON] = ActionEntry(REDUCE, 61);
}
void Cego::loadParser261()
{
   _actionMap[107][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[107][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[107][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[107][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[107][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[107][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[107][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[107][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[107][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[107][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[107][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[107][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[107][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[107][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[107][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[107][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[107][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[107][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[107][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[107][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[107][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[107][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[107][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[107][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[107][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[107][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[107][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[107][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[107][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[107][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[107][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[107][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[107][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[107][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[107][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[107][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[107][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[107][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[107][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[107][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[107][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[107][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[107][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[107][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[107][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[107][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[107][LB] = ActionEntry(SHIFT, 177);
   _actionMap[107][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[107][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[107][NULLTOKEN] = ActionEntry(SHIFT, 158);
}
void Cego::loadParser262()
{
   _actionMap[107][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[107][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[107][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[107][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[107][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[107][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[107][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[107][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[107][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[107][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[107][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[107][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[107][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[107][EXISTS] = ActionEntry(SHIFT, 275);
   _actionMap[107][NOT] = ActionEntry(SHIFT, 276);
   _jumpMap[107][ObjSpec] = 122;
   _jumpMap[107][Constant] = 121;
   _jumpMap[107][SignedFloat] = 120;
   _jumpMap[107][SignedInt] = 119;
   _jumpMap[107][Attribute] = 118;
   _jumpMap[107][Function] = 117;
   _jumpMap[107][Factor] = 116;
   _jumpMap[107][Term] = 115;
   _jumpMap[107][Expr] = 274;
   _jumpMap[107][Predicate] = 273;
   _jumpMap[107][Condition] = 272;
   _jumpMap[107][CasePrepare] = 113;
   _jumpMap[107][CaseClause] = 112;
   _actionMap[108][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[108][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[108][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[108][ObjSpec] = 277;
   _actionMap[109][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[109][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[109][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[109][ObjSpec] = 278;
   _actionMap[110][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[110][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[110][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[110][ObjSpec] = 279;
   _actionMap[111][SEMICOLON] = ActionEntry(REDUCE, 52);
   _actionMap[112][WHEN] = ActionEntry(REDUCE, 326);
   _actionMap[112][ELSE] = ActionEntry(REDUCE, 326);
   _actionMap[112][LEFT] = ActionEntry(REDUCE, 326);
   _actionMap[112][RIGHT] = ActionEntry(REDUCE, 326);
   _actionMap[112][INNER] = ActionEntry(REDUCE, 326);
   _actionMap[112][JOIN] = ActionEntry(REDUCE, 326);
   _actionMap[112][ORDER] = ActionEntry(REDUCE, 326);
   _actionMap[112][GROUP] = ActionEntry(REDUCE, 326);
   _actionMap[112][RETURNTOKEN] = ActionEntry(REDUCE, 326);
}
void Cego::loadParser263()
{
   _actionMap[112][WHERE] = ActionEntry(REDUCE, 326);
   _actionMap[112][AS] = ActionEntry(REDUCE, 326);
   _actionMap[112][FROM] = ActionEntry(REDUCE, 326);
   _actionMap[112][END_TOKEN] = ActionEntry(REDUCE, 326);
   _actionMap[112][BEGIN] = ActionEntry(REDUCE, 326);
   _actionMap[112][THEN] = ActionEntry(REDUCE, 326);
   _actionMap[112][OR] = ActionEntry(REDUCE, 326);
   _actionMap[112][AND] = ActionEntry(REDUCE, 326);
   _actionMap[112][LIKE] = ActionEntry(REDUCE, 326);
   _actionMap[112][IS] = ActionEntry(REDUCE, 326);
   _actionMap[112][BETWEEN] = ActionEntry(REDUCE, 326);
   _actionMap[112][EQU] = ActionEntry(REDUCE, 326);
   _actionMap[112][NEGATION] = ActionEntry(REDUCE, 326);
   _actionMap[112][LT] = ActionEntry(REDUCE, 326);
   _actionMap[112][MT] = ActionEntry(REDUCE, 326);
   _actionMap[112][NOT] = ActionEntry(REDUCE, 326);
   _actionMap[112][INTOK] = ActionEntry(REDUCE, 326);
   _actionMap[112][DESC] = ActionEntry(REDUCE, 326);
   _actionMap[112][ASC] = ActionEntry(REDUCE, 326);
   _actionMap[112][KSEP] = ActionEntry(REDUCE, 326);
   _actionMap[112][ROWLIMIT] = ActionEntry(REDUCE, 326);
   _actionMap[112][UNION] = ActionEntry(REDUCE, 326);
   _actionMap[112][ENDTOKEN] = ActionEntry(REDUCE, 326);
   _actionMap[112][RB] = ActionEntry(REDUCE, 326);
   _actionMap[112][CONCAT] = ActionEntry(REDUCE, 326);
   _actionMap[112][STAR] = ActionEntry(REDUCE, 326);
   _actionMap[112][DIVISION] = ActionEntry(REDUCE, 326);
   _actionMap[112][MINUS] = ActionEntry(REDUCE, 326);
   _actionMap[112][PLUS] = ActionEntry(REDUCE, 326);
   _actionMap[112][SEMICOLON] = ActionEntry(REDUCE, 326);
   _actionMap[113][WHEN] = ActionEntry(SHIFT, 282);
   _jumpMap[113][CaseCondition] = 281;
   _jumpMap[113][CaseConditionList] = 280;
   _actionMap[114][PLUS] = ActionEntry(SHIFT, 285);
   _actionMap[114][MINUS] = ActionEntry(SHIFT, 284);
   _actionMap[114][CONCAT] = ActionEntry(SHIFT, 283);
   _actionMap[114][SEMICOLON] = ActionEntry(REDUCE, 91);
   _actionMap[115][STAR] = ActionEntry(SHIFT, 286);
   _actionMap[115][DIVISION] = ActionEntry(SHIFT, 287);
   _actionMap[115][WHEN] = ActionEntry(REDUCE, 314);
   _actionMap[115][ELSE] = ActionEntry(REDUCE, 314);
   _actionMap[115][LEFT] = ActionEntry(REDUCE, 314);
   _actionMap[115][RIGHT] = ActionEntry(REDUCE, 314);
   _actionMap[115][INNER] = ActionEntry(REDUCE, 314);
   _actionMap[115][JOIN] = ActionEntry(REDUCE, 314);
   _actionMap[115][ORDER] = ActionEntry(REDUCE, 314);
   _actionMap[115][GROUP] = ActionEntry(REDUCE, 314);
   _actionMap[115][RETURNTOKEN] = ActionEntry(REDUCE, 314);
   _actionMap[115][WHERE] = ActionEntry(REDUCE, 314);
   _actionMap[115][AS] = ActionEntry(REDUCE, 314);
}
void Cego::loadParser264()
{
   _actionMap[115][FROM] = ActionEntry(REDUCE, 314);
   _actionMap[115][END_TOKEN] = ActionEntry(REDUCE, 314);
   _actionMap[115][BEGIN] = ActionEntry(REDUCE, 314);
   _actionMap[115][THEN] = ActionEntry(REDUCE, 314);
   _actionMap[115][OR] = ActionEntry(REDUCE, 314);
   _actionMap[115][AND] = ActionEntry(REDUCE, 314);
   _actionMap[115][LIKE] = ActionEntry(REDUCE, 314);
   _actionMap[115][IS] = ActionEntry(REDUCE, 314);
   _actionMap[115][BETWEEN] = ActionEntry(REDUCE, 314);
   _actionMap[115][EQU] = ActionEntry(REDUCE, 314);
   _actionMap[115][NEGATION] = ActionEntry(REDUCE, 314);
   _actionMap[115][LT] = ActionEntry(REDUCE, 314);
   _actionMap[115][MT] = ActionEntry(REDUCE, 314);
   _actionMap[115][NOT] = ActionEntry(REDUCE, 314);
   _actionMap[115][INTOK] = ActionEntry(REDUCE, 314);
   _actionMap[115][DESC] = ActionEntry(REDUCE, 314);
   _actionMap[115][ASC] = ActionEntry(REDUCE, 314);
   _actionMap[115][KSEP] = ActionEntry(REDUCE, 314);
   _actionMap[115][ROWLIMIT] = ActionEntry(REDUCE, 314);
   _actionMap[115][UNION] = ActionEntry(REDUCE, 314);
   _actionMap[115][ENDTOKEN] = ActionEntry(REDUCE, 314);
   _actionMap[115][RB] = ActionEntry(REDUCE, 314);
   _actionMap[115][CONCAT] = ActionEntry(REDUCE, 314);
   _actionMap[115][MINUS] = ActionEntry(REDUCE, 314);
   _actionMap[115][PLUS] = ActionEntry(REDUCE, 314);
   _actionMap[115][SEMICOLON] = ActionEntry(REDUCE, 314);
   _actionMap[116][WHEN] = ActionEntry(REDUCE, 318);
   _actionMap[116][ELSE] = ActionEntry(REDUCE, 318);
   _actionMap[116][LEFT] = ActionEntry(REDUCE, 318);
   _actionMap[116][RIGHT] = ActionEntry(REDUCE, 318);
   _actionMap[116][INNER] = ActionEntry(REDUCE, 318);
   _actionMap[116][JOIN] = ActionEntry(REDUCE, 318);
   _actionMap[116][ORDER] = ActionEntry(REDUCE, 318);
   _actionMap[116][GROUP] = ActionEntry(REDUCE, 318);
   _actionMap[116][RETURNTOKEN] = ActionEntry(REDUCE, 318);
   _actionMap[116][WHERE] = ActionEntry(REDUCE, 318);
   _actionMap[116][FROM] = ActionEntry(REDUCE, 318);
   _actionMap[116][AS] = ActionEntry(REDUCE, 318);
   _actionMap[116][END_TOKEN] = ActionEntry(REDUCE, 318);
   _actionMap[116][BEGIN] = ActionEntry(REDUCE, 318);
   _actionMap[116][THEN] = ActionEntry(REDUCE, 318);
   _actionMap[116][AND] = ActionEntry(REDUCE, 318);
   _actionMap[116][OR] = ActionEntry(REDUCE, 318);
   _actionMap[116][INTOK] = ActionEntry(REDUCE, 318);
   _actionMap[116][NOT] = ActionEntry(REDUCE, 318);
   _actionMap[116][MT] = ActionEntry(REDUCE, 318);
   _actionMap[116][LT] = ActionEntry(REDUCE, 318);
   _actionMap[116][NEGATION] = ActionEntry(REDUCE, 318);
   _actionMap[116][EQU] = ActionEntry(REDUCE, 318);
   _actionMap[116][BETWEEN] = ActionEntry(REDUCE, 318);
}
void Cego::loadParser265()
{
   _actionMap[116][IS] = ActionEntry(REDUCE, 318);
   _actionMap[116][LIKE] = ActionEntry(REDUCE, 318);
   _actionMap[116][RB] = ActionEntry(REDUCE, 318);
   _actionMap[116][ENDTOKEN] = ActionEntry(REDUCE, 318);
   _actionMap[116][UNION] = ActionEntry(REDUCE, 318);
   _actionMap[116][ROWLIMIT] = ActionEntry(REDUCE, 318);
   _actionMap[116][KSEP] = ActionEntry(REDUCE, 318);
   _actionMap[116][ASC] = ActionEntry(REDUCE, 318);
   _actionMap[116][DESC] = ActionEntry(REDUCE, 318);
   _actionMap[116][PLUS] = ActionEntry(REDUCE, 318);
   _actionMap[116][MINUS] = ActionEntry(REDUCE, 318);
   _actionMap[116][DIVISION] = ActionEntry(REDUCE, 318);
   _actionMap[116][STAR] = ActionEntry(REDUCE, 318);
   _actionMap[116][CONCAT] = ActionEntry(REDUCE, 318);
   _actionMap[116][SEMICOLON] = ActionEntry(REDUCE, 318);
   _actionMap[117][WHEN] = ActionEntry(REDUCE, 323);
   _actionMap[117][ELSE] = ActionEntry(REDUCE, 323);
   _actionMap[117][LEFT] = ActionEntry(REDUCE, 323);
   _actionMap[117][RIGHT] = ActionEntry(REDUCE, 323);
   _actionMap[117][INNER] = ActionEntry(REDUCE, 323);
   _actionMap[117][JOIN] = ActionEntry(REDUCE, 323);
   _actionMap[117][ORDER] = ActionEntry(REDUCE, 323);
   _actionMap[117][GROUP] = ActionEntry(REDUCE, 323);
   _actionMap[117][RETURNTOKEN] = ActionEntry(REDUCE, 323);
   _actionMap[117][WHERE] = ActionEntry(REDUCE, 323);
   _actionMap[117][AS] = ActionEntry(REDUCE, 323);
   _actionMap[117][FROM] = ActionEntry(REDUCE, 323);
   _actionMap[117][END_TOKEN] = ActionEntry(REDUCE, 323);
   _actionMap[117][BEGIN] = ActionEntry(REDUCE, 323);
   _actionMap[117][THEN] = ActionEntry(REDUCE, 323);
   _actionMap[117][OR] = ActionEntry(REDUCE, 323);
   _actionMap[117][AND] = ActionEntry(REDUCE, 323);
   _actionMap[117][LIKE] = ActionEntry(REDUCE, 323);
   _actionMap[117][IS] = ActionEntry(REDUCE, 323);
   _actionMap[117][BETWEEN] = ActionEntry(REDUCE, 323);
   _actionMap[117][EQU] = ActionEntry(REDUCE, 323);
   _actionMap[117][NEGATION] = ActionEntry(REDUCE, 323);
   _actionMap[117][LT] = ActionEntry(REDUCE, 323);
   _actionMap[117][MT] = ActionEntry(REDUCE, 323);
   _actionMap[117][NOT] = ActionEntry(REDUCE, 323);
   _actionMap[117][INTOK] = ActionEntry(REDUCE, 323);
   _actionMap[117][DESC] = ActionEntry(REDUCE, 323);
   _actionMap[117][ASC] = ActionEntry(REDUCE, 323);
   _actionMap[117][KSEP] = ActionEntry(REDUCE, 323);
   _actionMap[117][ROWLIMIT] = ActionEntry(REDUCE, 323);
   _actionMap[117][UNION] = ActionEntry(REDUCE, 323);
   _actionMap[117][ENDTOKEN] = ActionEntry(REDUCE, 323);
   _actionMap[117][RB] = ActionEntry(REDUCE, 323);
   _actionMap[117][CONCAT] = ActionEntry(REDUCE, 323);
   _actionMap[117][STAR] = ActionEntry(REDUCE, 323);
}
void Cego::loadParser266()
{
   _actionMap[117][DIVISION] = ActionEntry(REDUCE, 323);
   _actionMap[117][MINUS] = ActionEntry(REDUCE, 323);
   _actionMap[117][PLUS] = ActionEntry(REDUCE, 323);
   _actionMap[117][SEMICOLON] = ActionEntry(REDUCE, 323);
   _actionMap[118][WHEN] = ActionEntry(REDUCE, 322);
   _actionMap[118][ELSE] = ActionEntry(REDUCE, 322);
   _actionMap[118][LEFT] = ActionEntry(REDUCE, 322);
   _actionMap[118][RIGHT] = ActionEntry(REDUCE, 322);
   _actionMap[118][INNER] = ActionEntry(REDUCE, 322);
   _actionMap[118][JOIN] = ActionEntry(REDUCE, 322);
   _actionMap[118][ORDER] = ActionEntry(REDUCE, 322);
   _actionMap[118][GROUP] = ActionEntry(REDUCE, 322);
   _actionMap[118][RETURNTOKEN] = ActionEntry(REDUCE, 322);
   _actionMap[118][WHERE] = ActionEntry(REDUCE, 322);
   _actionMap[118][AS] = ActionEntry(REDUCE, 322);
   _actionMap[118][FROM] = ActionEntry(REDUCE, 322);
   _actionMap[118][END_TOKEN] = ActionEntry(REDUCE, 322);
   _actionMap[118][BEGIN] = ActionEntry(REDUCE, 322);
   _actionMap[118][THEN] = ActionEntry(REDUCE, 322);
   _actionMap[118][OR] = ActionEntry(REDUCE, 322);
   _actionMap[118][AND] = ActionEntry(REDUCE, 322);
   _actionMap[118][LIKE] = ActionEntry(REDUCE, 322);
   _actionMap[118][IS] = ActionEntry(REDUCE, 322);
   _actionMap[118][BETWEEN] = ActionEntry(REDUCE, 322);
   _actionMap[118][EQU] = ActionEntry(REDUCE, 322);
   _actionMap[118][NEGATION] = ActionEntry(REDUCE, 322);
   _actionMap[118][LT] = ActionEntry(REDUCE, 322);
   _actionMap[118][MT] = ActionEntry(REDUCE, 322);
   _actionMap[118][NOT] = ActionEntry(REDUCE, 322);
   _actionMap[118][INTOK] = ActionEntry(REDUCE, 322);
   _actionMap[118][DESC] = ActionEntry(REDUCE, 322);
   _actionMap[118][ASC] = ActionEntry(REDUCE, 322);
   _actionMap[118][KSEP] = ActionEntry(REDUCE, 322);
   _actionMap[118][ROWLIMIT] = ActionEntry(REDUCE, 322);
   _actionMap[118][UNION] = ActionEntry(REDUCE, 322);
   _actionMap[118][ENDTOKEN] = ActionEntry(REDUCE, 322);
   _actionMap[118][RB] = ActionEntry(REDUCE, 322);
   _actionMap[118][CONCAT] = ActionEntry(REDUCE, 322);
   _actionMap[118][STAR] = ActionEntry(REDUCE, 322);
   _actionMap[118][DIVISION] = ActionEntry(REDUCE, 322);
   _actionMap[118][MINUS] = ActionEntry(REDUCE, 322);
   _actionMap[118][PLUS] = ActionEntry(REDUCE, 322);
   _actionMap[118][SEMICOLON] = ActionEntry(REDUCE, 322);
   _actionMap[119][WHEN] = ActionEntry(REDUCE, 405);
   _actionMap[119][ELSE] = ActionEntry(REDUCE, 405);
   _actionMap[119][LEFT] = ActionEntry(REDUCE, 405);
   _actionMap[119][RIGHT] = ActionEntry(REDUCE, 405);
   _actionMap[119][INNER] = ActionEntry(REDUCE, 405);
   _actionMap[119][JOIN] = ActionEntry(REDUCE, 405);
   _actionMap[119][ORDER] = ActionEntry(REDUCE, 405);
}
void Cego::loadParser267()
{
   _actionMap[119][GROUP] = ActionEntry(REDUCE, 405);
   _actionMap[119][RETURNTOKEN] = ActionEntry(REDUCE, 405);
   _actionMap[119][WHERE] = ActionEntry(REDUCE, 405);
   _actionMap[119][NULLTOKEN] = ActionEntry(REDUCE, 405);
   _actionMap[119][FROM] = ActionEntry(REDUCE, 405);
   _actionMap[119][AS] = ActionEntry(REDUCE, 405);
   _actionMap[119][END_TOKEN] = ActionEntry(REDUCE, 405);
   _actionMap[119][BEGIN] = ActionEntry(REDUCE, 405);
   _actionMap[119][THEN] = ActionEntry(REDUCE, 405);
   _actionMap[119][AND] = ActionEntry(REDUCE, 405);
   _actionMap[119][OR] = ActionEntry(REDUCE, 405);
   _actionMap[119][INTOK] = ActionEntry(REDUCE, 405);
   _actionMap[119][NOT] = ActionEntry(REDUCE, 405);
   _actionMap[119][MT] = ActionEntry(REDUCE, 405);
   _actionMap[119][LT] = ActionEntry(REDUCE, 405);
   _actionMap[119][NEGATION] = ActionEntry(REDUCE, 405);
   _actionMap[119][EQU] = ActionEntry(REDUCE, 405);
   _actionMap[119][BETWEEN] = ActionEntry(REDUCE, 405);
   _actionMap[119][IS] = ActionEntry(REDUCE, 405);
   _actionMap[119][LIKE] = ActionEntry(REDUCE, 405);
   _actionMap[119][RB] = ActionEntry(REDUCE, 405);
   _actionMap[119][ENDTOKEN] = ActionEntry(REDUCE, 405);
   _actionMap[119][UNION] = ActionEntry(REDUCE, 405);
   _actionMap[119][ROWLIMIT] = ActionEntry(REDUCE, 405);
   _actionMap[119][KSEP] = ActionEntry(REDUCE, 405);
   _actionMap[119][ASC] = ActionEntry(REDUCE, 405);
   _actionMap[119][DESC] = ActionEntry(REDUCE, 405);
   _actionMap[119][PLUS] = ActionEntry(REDUCE, 405);
   _actionMap[119][MINUS] = ActionEntry(REDUCE, 405);
   _actionMap[119][DIVISION] = ActionEntry(REDUCE, 405);
   _actionMap[119][STAR] = ActionEntry(REDUCE, 405);
   _actionMap[119][CONCAT] = ActionEntry(REDUCE, 405);
   _actionMap[119][SEMICOLON] = ActionEntry(REDUCE, 405);
   _actionMap[120][WHEN] = ActionEntry(REDUCE, 411);
   _actionMap[120][ELSE] = ActionEntry(REDUCE, 411);
   _actionMap[120][LEFT] = ActionEntry(REDUCE, 411);
   _actionMap[120][RIGHT] = ActionEntry(REDUCE, 411);
   _actionMap[120][INNER] = ActionEntry(REDUCE, 411);
   _actionMap[120][JOIN] = ActionEntry(REDUCE, 411);
   _actionMap[120][ORDER] = ActionEntry(REDUCE, 411);
   _actionMap[120][GROUP] = ActionEntry(REDUCE, 411);
   _actionMap[120][RETURNTOKEN] = ActionEntry(REDUCE, 411);
   _actionMap[120][WHERE] = ActionEntry(REDUCE, 411);
   _actionMap[120][NULLTOKEN] = ActionEntry(REDUCE, 411);
   _actionMap[120][FROM] = ActionEntry(REDUCE, 411);
   _actionMap[120][AS] = ActionEntry(REDUCE, 411);
   _actionMap[120][END_TOKEN] = ActionEntry(REDUCE, 411);
   _actionMap[120][BEGIN] = ActionEntry(REDUCE, 411);
   _actionMap[120][THEN] = ActionEntry(REDUCE, 411);
   _actionMap[120][AND] = ActionEntry(REDUCE, 411);
}
void Cego::loadParser268()
{
   _actionMap[120][OR] = ActionEntry(REDUCE, 411);
   _actionMap[120][INTOK] = ActionEntry(REDUCE, 411);
   _actionMap[120][NOT] = ActionEntry(REDUCE, 411);
   _actionMap[120][MT] = ActionEntry(REDUCE, 411);
   _actionMap[120][LT] = ActionEntry(REDUCE, 411);
   _actionMap[120][NEGATION] = ActionEntry(REDUCE, 411);
   _actionMap[120][EQU] = ActionEntry(REDUCE, 411);
   _actionMap[120][BETWEEN] = ActionEntry(REDUCE, 411);
   _actionMap[120][IS] = ActionEntry(REDUCE, 411);
   _actionMap[120][LIKE] = ActionEntry(REDUCE, 411);
   _actionMap[120][RB] = ActionEntry(REDUCE, 411);
   _actionMap[120][ENDTOKEN] = ActionEntry(REDUCE, 411);
   _actionMap[120][UNION] = ActionEntry(REDUCE, 411);
   _actionMap[120][ROWLIMIT] = ActionEntry(REDUCE, 411);
   _actionMap[120][KSEP] = ActionEntry(REDUCE, 411);
   _actionMap[120][ASC] = ActionEntry(REDUCE, 411);
   _actionMap[120][DESC] = ActionEntry(REDUCE, 411);
   _actionMap[120][PLUS] = ActionEntry(REDUCE, 411);
   _actionMap[120][MINUS] = ActionEntry(REDUCE, 411);
   _actionMap[120][DIVISION] = ActionEntry(REDUCE, 411);
   _actionMap[120][STAR] = ActionEntry(REDUCE, 411);
   _actionMap[120][CONCAT] = ActionEntry(REDUCE, 411);
   _actionMap[120][SEMICOLON] = ActionEntry(REDUCE, 411);
   _actionMap[121][WHEN] = ActionEntry(REDUCE, 320);
   _actionMap[121][ELSE] = ActionEntry(REDUCE, 320);
   _actionMap[121][LEFT] = ActionEntry(REDUCE, 320);
   _actionMap[121][RIGHT] = ActionEntry(REDUCE, 320);
   _actionMap[121][INNER] = ActionEntry(REDUCE, 320);
   _actionMap[121][JOIN] = ActionEntry(REDUCE, 320);
   _actionMap[121][ORDER] = ActionEntry(REDUCE, 320);
   _actionMap[121][GROUP] = ActionEntry(REDUCE, 320);
   _actionMap[121][RETURNTOKEN] = ActionEntry(REDUCE, 320);
   _actionMap[121][WHERE] = ActionEntry(REDUCE, 320);
   _actionMap[121][AS] = ActionEntry(REDUCE, 320);
   _actionMap[121][FROM] = ActionEntry(REDUCE, 320);
   _actionMap[121][END_TOKEN] = ActionEntry(REDUCE, 320);
   _actionMap[121][BEGIN] = ActionEntry(REDUCE, 320);
   _actionMap[121][THEN] = ActionEntry(REDUCE, 320);
   _actionMap[121][OR] = ActionEntry(REDUCE, 320);
   _actionMap[121][AND] = ActionEntry(REDUCE, 320);
   _actionMap[121][LIKE] = ActionEntry(REDUCE, 320);
   _actionMap[121][IS] = ActionEntry(REDUCE, 320);
   _actionMap[121][BETWEEN] = ActionEntry(REDUCE, 320);
   _actionMap[121][EQU] = ActionEntry(REDUCE, 320);
   _actionMap[121][NEGATION] = ActionEntry(REDUCE, 320);
   _actionMap[121][LT] = ActionEntry(REDUCE, 320);
   _actionMap[121][MT] = ActionEntry(REDUCE, 320);
   _actionMap[121][NOT] = ActionEntry(REDUCE, 320);
   _actionMap[121][INTOK] = ActionEntry(REDUCE, 320);
   _actionMap[121][DESC] = ActionEntry(REDUCE, 320);
}
void Cego::loadParser269()
{
   _actionMap[121][ASC] = ActionEntry(REDUCE, 320);
   _actionMap[121][KSEP] = ActionEntry(REDUCE, 320);
   _actionMap[121][ROWLIMIT] = ActionEntry(REDUCE, 320);
   _actionMap[121][UNION] = ActionEntry(REDUCE, 320);
   _actionMap[121][ENDTOKEN] = ActionEntry(REDUCE, 320);
   _actionMap[121][RB] = ActionEntry(REDUCE, 320);
   _actionMap[121][CONCAT] = ActionEntry(REDUCE, 320);
   _actionMap[121][STAR] = ActionEntry(REDUCE, 320);
   _actionMap[121][DIVISION] = ActionEntry(REDUCE, 320);
   _actionMap[121][MINUS] = ActionEntry(REDUCE, 320);
   _actionMap[121][PLUS] = ActionEntry(REDUCE, 320);
   _actionMap[121][SEMICOLON] = ActionEntry(REDUCE, 320);
   _actionMap[122][LB] = ActionEntry(SHIFT, 288);
   _actionMap[123][WHEN] = ActionEntry(REDUCE, 410);
   _actionMap[123][ELSE] = ActionEntry(REDUCE, 410);
   _actionMap[123][LEFT] = ActionEntry(REDUCE, 410);
   _actionMap[123][RIGHT] = ActionEntry(REDUCE, 410);
   _actionMap[123][INNER] = ActionEntry(REDUCE, 410);
   _actionMap[123][JOIN] = ActionEntry(REDUCE, 410);
   _actionMap[123][ORDER] = ActionEntry(REDUCE, 410);
   _actionMap[123][GROUP] = ActionEntry(REDUCE, 410);
   _actionMap[123][RETURNTOKEN] = ActionEntry(REDUCE, 410);
   _actionMap[123][WHERE] = ActionEntry(REDUCE, 410);
   _actionMap[123][NULLTOKEN] = ActionEntry(REDUCE, 410);
   _actionMap[123][FROM] = ActionEntry(REDUCE, 410);
   _actionMap[123][AS] = ActionEntry(REDUCE, 410);
   _actionMap[123][END_TOKEN] = ActionEntry(REDUCE, 410);
   _actionMap[123][BEGIN] = ActionEntry(REDUCE, 410);
   _actionMap[123][THEN] = ActionEntry(REDUCE, 410);
   _actionMap[123][AND] = ActionEntry(REDUCE, 410);
   _actionMap[123][OR] = ActionEntry(REDUCE, 410);
   _actionMap[123][INTOK] = ActionEntry(REDUCE, 410);
   _actionMap[123][NOT] = ActionEntry(REDUCE, 410);
   _actionMap[123][MT] = ActionEntry(REDUCE, 410);
   _actionMap[123][LT] = ActionEntry(REDUCE, 410);
   _actionMap[123][NEGATION] = ActionEntry(REDUCE, 410);
   _actionMap[123][EQU] = ActionEntry(REDUCE, 410);
   _actionMap[123][BETWEEN] = ActionEntry(REDUCE, 410);
   _actionMap[123][IS] = ActionEntry(REDUCE, 410);
   _actionMap[123][LIKE] = ActionEntry(REDUCE, 410);
   _actionMap[123][RB] = ActionEntry(REDUCE, 410);
   _actionMap[123][ENDTOKEN] = ActionEntry(REDUCE, 410);
   _actionMap[123][UNION] = ActionEntry(REDUCE, 410);
   _actionMap[123][ROWLIMIT] = ActionEntry(REDUCE, 410);
   _actionMap[123][KSEP] = ActionEntry(REDUCE, 410);
   _actionMap[123][ASC] = ActionEntry(REDUCE, 410);
   _actionMap[123][DESC] = ActionEntry(REDUCE, 410);
   _actionMap[123][PLUS] = ActionEntry(REDUCE, 410);
   _actionMap[123][MINUS] = ActionEntry(REDUCE, 410);
   _actionMap[123][DIVISION] = ActionEntry(REDUCE, 410);
}
void Cego::loadParser270()
{
   _actionMap[123][STAR] = ActionEntry(REDUCE, 410);
   _actionMap[123][CONCAT] = ActionEntry(REDUCE, 410);
   _actionMap[123][SEMICOLON] = ActionEntry(REDUCE, 410);
   _actionMap[124][LB] = ActionEntry(SHIFT, 289);
   _actionMap[125][LB] = ActionEntry(SHIFT, 290);
   _actionMap[126][LB] = ActionEntry(SHIFT, 291);
   _actionMap[127][LB] = ActionEntry(SHIFT, 292);
   _actionMap[128][LB] = ActionEntry(SHIFT, 293);
   _actionMap[129][LAB] = ActionEntry(SHIFT, 294);
   _actionMap[130][LB] = ActionEntry(SHIFT, 295);
   _actionMap[131][LB] = ActionEntry(SHIFT, 296);
   _actionMap[132][WHEN] = ActionEntry(REDUCE, 113);
   _actionMap[133][LAB] = ActionEntry(SHIFT, 297);
   _actionMap[134][LB] = ActionEntry(SHIFT, 298);
   _actionMap[135][LB] = ActionEntry(SHIFT, 299);
   _actionMap[136][LB] = ActionEntry(SHIFT, 300);
   _actionMap[137][LB] = ActionEntry(SHIFT, 301);
   _actionMap[138][LB] = ActionEntry(SHIFT, 302);
   _actionMap[139][LB] = ActionEntry(SHIFT, 303);
   _actionMap[140][LB] = ActionEntry(SHIFT, 304);
   _actionMap[141][WHEN] = ActionEntry(REDUCE, 417);
   _actionMap[141][ELSE] = ActionEntry(REDUCE, 417);
   _actionMap[141][LEFT] = ActionEntry(REDUCE, 417);
   _actionMap[141][RIGHT] = ActionEntry(REDUCE, 417);
   _actionMap[141][INNER] = ActionEntry(REDUCE, 417);
   _actionMap[141][JOIN] = ActionEntry(REDUCE, 417);
   _actionMap[141][ORDER] = ActionEntry(REDUCE, 417);
   _actionMap[141][GROUP] = ActionEntry(REDUCE, 417);
   _actionMap[141][RETURNTOKEN] = ActionEntry(REDUCE, 417);
   _actionMap[141][WHERE] = ActionEntry(REDUCE, 417);
   _actionMap[141][FROM] = ActionEntry(REDUCE, 417);
   _actionMap[141][AS] = ActionEntry(REDUCE, 417);
   _actionMap[141][END_TOKEN] = ActionEntry(REDUCE, 417);
   _actionMap[141][BEGIN] = ActionEntry(REDUCE, 417);
   _actionMap[141][THEN] = ActionEntry(REDUCE, 417);
   _actionMap[141][NULLTOKEN] = ActionEntry(REDUCE, 417);
   _actionMap[141][AND] = ActionEntry(REDUCE, 417);
   _actionMap[141][OR] = ActionEntry(REDUCE, 417);
   _actionMap[141][INTOK] = ActionEntry(REDUCE, 417);
   _actionMap[141][NOT] = ActionEntry(REDUCE, 417);
   _actionMap[141][MT] = ActionEntry(REDUCE, 417);
   _actionMap[141][LT] = ActionEntry(REDUCE, 417);
   _actionMap[141][NEGATION] = ActionEntry(REDUCE, 417);
   _actionMap[141][EQU] = ActionEntry(REDUCE, 417);
   _actionMap[141][BETWEEN] = ActionEntry(REDUCE, 417);
   _actionMap[141][IS] = ActionEntry(REDUCE, 417);
   _actionMap[141][LIKE] = ActionEntry(REDUCE, 417);
   _actionMap[141][RB] = ActionEntry(REDUCE, 417);
   _actionMap[141][ENDTOKEN] = ActionEntry(REDUCE, 417);
   _actionMap[141][UNION] = ActionEntry(REDUCE, 417);
}
void Cego::loadParser271()
{
   _actionMap[141][ROWLIMIT] = ActionEntry(REDUCE, 417);
   _actionMap[141][KSEP] = ActionEntry(REDUCE, 417);
   _actionMap[141][ASC] = ActionEntry(REDUCE, 417);
   _actionMap[141][DESC] = ActionEntry(REDUCE, 417);
   _actionMap[141][PLUS] = ActionEntry(REDUCE, 417);
   _actionMap[141][MINUS] = ActionEntry(REDUCE, 417);
   _actionMap[141][DIVISION] = ActionEntry(REDUCE, 417);
   _actionMap[141][STAR] = ActionEntry(REDUCE, 417);
   _actionMap[141][CONCAT] = ActionEntry(REDUCE, 417);
   _actionMap[141][SEMICOLON] = ActionEntry(REDUCE, 417);
   _actionMap[142][IDENTIFIER] = ActionEntry(SHIFT, 305);
   _actionMap[143][LB] = ActionEntry(SHIFT, 306);
   _actionMap[144][LB] = ActionEntry(SHIFT, 307);
   _actionMap[145][LB] = ActionEntry(SHIFT, 308);
   _actionMap[146][LB] = ActionEntry(SHIFT, 309);
   _actionMap[147][LB] = ActionEntry(SHIFT, 310);
   _actionMap[148][LB] = ActionEntry(SHIFT, 311);
   _actionMap[149][LB] = ActionEntry(SHIFT, 312);
   _actionMap[150][LB] = ActionEntry(SHIFT, 313);
   _actionMap[151][LB] = ActionEntry(SHIFT, 314);
   _actionMap[152][LB] = ActionEntry(SHIFT, 315);
   _actionMap[153][LB] = ActionEntry(SHIFT, 316);
   _actionMap[154][LB] = ActionEntry(SHIFT, 317);
   _actionMap[155][LB] = ActionEntry(SHIFT, 318);
   _actionMap[156][LB] = ActionEntry(SHIFT, 319);
   _actionMap[157][LB] = ActionEntry(SHIFT, 320);
   _actionMap[158][WHEN] = ActionEntry(REDUCE, 415);
   _actionMap[158][ELSE] = ActionEntry(REDUCE, 415);
   _actionMap[158][LEFT] = ActionEntry(REDUCE, 415);
   _actionMap[158][RIGHT] = ActionEntry(REDUCE, 415);
   _actionMap[158][INNER] = ActionEntry(REDUCE, 415);
   _actionMap[158][JOIN] = ActionEntry(REDUCE, 415);
   _actionMap[158][ORDER] = ActionEntry(REDUCE, 415);
   _actionMap[158][GROUP] = ActionEntry(REDUCE, 415);
   _actionMap[158][RETURNTOKEN] = ActionEntry(REDUCE, 415);
   _actionMap[158][WHERE] = ActionEntry(REDUCE, 415);
   _actionMap[158][FROM] = ActionEntry(REDUCE, 415);
   _actionMap[158][AS] = ActionEntry(REDUCE, 415);
   _actionMap[158][END_TOKEN] = ActionEntry(REDUCE, 415);
   _actionMap[158][BEGIN] = ActionEntry(REDUCE, 415);
   _actionMap[158][THEN] = ActionEntry(REDUCE, 415);
   _actionMap[158][NULLTOKEN] = ActionEntry(REDUCE, 415);
   _actionMap[158][AND] = ActionEntry(REDUCE, 415);
   _actionMap[158][OR] = ActionEntry(REDUCE, 415);
   _actionMap[158][INTOK] = ActionEntry(REDUCE, 415);
   _actionMap[158][NOT] = ActionEntry(REDUCE, 415);
   _actionMap[158][MT] = ActionEntry(REDUCE, 415);
   _actionMap[158][LT] = ActionEntry(REDUCE, 415);
   _actionMap[158][NEGATION] = ActionEntry(REDUCE, 415);
   _actionMap[158][EQU] = ActionEntry(REDUCE, 415);
}
void Cego::loadParser272()
{
   _actionMap[158][BETWEEN] = ActionEntry(REDUCE, 415);
   _actionMap[158][IS] = ActionEntry(REDUCE, 415);
   _actionMap[158][LIKE] = ActionEntry(REDUCE, 415);
   _actionMap[158][RB] = ActionEntry(REDUCE, 415);
   _actionMap[158][ENDTOKEN] = ActionEntry(REDUCE, 415);
   _actionMap[158][UNION] = ActionEntry(REDUCE, 415);
   _actionMap[158][ROWLIMIT] = ActionEntry(REDUCE, 415);
   _actionMap[158][KSEP] = ActionEntry(REDUCE, 415);
   _actionMap[158][ASC] = ActionEntry(REDUCE, 415);
   _actionMap[158][DESC] = ActionEntry(REDUCE, 415);
   _actionMap[158][PLUS] = ActionEntry(REDUCE, 415);
   _actionMap[158][MINUS] = ActionEntry(REDUCE, 415);
   _actionMap[158][DIVISION] = ActionEntry(REDUCE, 415);
   _actionMap[158][STAR] = ActionEntry(REDUCE, 415);
   _actionMap[158][CONCAT] = ActionEntry(REDUCE, 415);
   _actionMap[158][SEMICOLON] = ActionEntry(REDUCE, 415);
   _actionMap[159][LB] = ActionEntry(SHIFT, 321);
   _actionMap[160][LB] = ActionEntry(SHIFT, 322);
   _actionMap[161][LB] = ActionEntry(SHIFT, 323);
   _actionMap[162][LB] = ActionEntry(SHIFT, 324);
   _actionMap[163][LB] = ActionEntry(SHIFT, 325);
   _actionMap[164][LB] = ActionEntry(SHIFT, 326);
   _actionMap[165][LB] = ActionEntry(SHIFT, 327);
   _actionMap[166][LB] = ActionEntry(SHIFT, 328);
   _actionMap[167][LB] = ActionEntry(SHIFT, 329);
   _actionMap[168][LB] = ActionEntry(SHIFT, 330);
   _actionMap[169][LB] = ActionEntry(SHIFT, 331);
   _actionMap[170][WHEN] = ActionEntry(REDUCE, 414);
   _actionMap[170][ELSE] = ActionEntry(REDUCE, 414);
   _actionMap[170][FROM] = ActionEntry(REDUCE, 414);
   _actionMap[170][AS] = ActionEntry(REDUCE, 414);
   _actionMap[170][END_TOKEN] = ActionEntry(REDUCE, 414);
   _actionMap[170][BEGIN] = ActionEntry(REDUCE, 414);
   _actionMap[170][THEN] = ActionEntry(REDUCE, 414);
   _actionMap[170][LEFT] = ActionEntry(REDUCE, 414);
   _actionMap[170][RIGHT] = ActionEntry(REDUCE, 414);
   _actionMap[170][INNER] = ActionEntry(REDUCE, 414);
   _actionMap[170][JOIN] = ActionEntry(REDUCE, 414);
   _actionMap[170][ORDER] = ActionEntry(REDUCE, 414);
   _actionMap[170][GROUP] = ActionEntry(REDUCE, 414);
   _actionMap[170][RETURNTOKEN] = ActionEntry(REDUCE, 414);
   _actionMap[170][WHERE] = ActionEntry(REDUCE, 414);
   _actionMap[170][NULLTOKEN] = ActionEntry(REDUCE, 414);
   _actionMap[170][AND] = ActionEntry(REDUCE, 414);
   _actionMap[170][OR] = ActionEntry(REDUCE, 414);
   _actionMap[170][INTOK] = ActionEntry(REDUCE, 414);
   _actionMap[170][NOT] = ActionEntry(REDUCE, 414);
   _actionMap[170][MT] = ActionEntry(REDUCE, 414);
   _actionMap[170][LT] = ActionEntry(REDUCE, 414);
   _actionMap[170][NEGATION] = ActionEntry(REDUCE, 414);
}
void Cego::loadParser273()
{
   _actionMap[170][EQU] = ActionEntry(REDUCE, 414);
   _actionMap[170][BETWEEN] = ActionEntry(REDUCE, 414);
   _actionMap[170][IS] = ActionEntry(REDUCE, 414);
   _actionMap[170][LIKE] = ActionEntry(REDUCE, 414);
   _actionMap[170][RB] = ActionEntry(REDUCE, 414);
   _actionMap[170][ENDTOKEN] = ActionEntry(REDUCE, 414);
   _actionMap[170][UNION] = ActionEntry(REDUCE, 414);
   _actionMap[170][ROWLIMIT] = ActionEntry(REDUCE, 414);
   _actionMap[170][KSEP] = ActionEntry(REDUCE, 414);
   _actionMap[170][ASC] = ActionEntry(REDUCE, 414);
   _actionMap[170][DESC] = ActionEntry(REDUCE, 414);
   _actionMap[170][PLUS] = ActionEntry(REDUCE, 414);
   _actionMap[170][MINUS] = ActionEntry(REDUCE, 414);
   _actionMap[170][DIVISION] = ActionEntry(REDUCE, 414);
   _actionMap[170][STAR] = ActionEntry(REDUCE, 414);
   _actionMap[170][CONCAT] = ActionEntry(REDUCE, 414);
   _actionMap[170][SEMICOLON] = ActionEntry(REDUCE, 414);
   _actionMap[171][LB] = ActionEntry(SHIFT, 332);
   _actionMap[172][LB] = ActionEntry(SHIFT, 333);
   _actionMap[173][LB] = ActionEntry(SHIFT, 334);
   _actionMap[174][WHEN] = ActionEntry(REDUCE, 416);
   _actionMap[174][ELSE] = ActionEntry(REDUCE, 416);
   _actionMap[174][FROM] = ActionEntry(REDUCE, 416);
   _actionMap[174][AS] = ActionEntry(REDUCE, 416);
   _actionMap[174][END_TOKEN] = ActionEntry(REDUCE, 416);
   _actionMap[174][BEGIN] = ActionEntry(REDUCE, 416);
   _actionMap[174][THEN] = ActionEntry(REDUCE, 416);
   _actionMap[174][LEFT] = ActionEntry(REDUCE, 416);
   _actionMap[174][RIGHT] = ActionEntry(REDUCE, 416);
   _actionMap[174][INNER] = ActionEntry(REDUCE, 416);
   _actionMap[174][JOIN] = ActionEntry(REDUCE, 416);
   _actionMap[174][ORDER] = ActionEntry(REDUCE, 416);
   _actionMap[174][GROUP] = ActionEntry(REDUCE, 416);
   _actionMap[174][RETURNTOKEN] = ActionEntry(REDUCE, 416);
   _actionMap[174][WHERE] = ActionEntry(REDUCE, 416);
   _actionMap[174][NULLTOKEN] = ActionEntry(REDUCE, 416);
   _actionMap[174][AND] = ActionEntry(REDUCE, 416);
   _actionMap[174][OR] = ActionEntry(REDUCE, 416);
   _actionMap[174][INTOK] = ActionEntry(REDUCE, 416);
   _actionMap[174][NOT] = ActionEntry(REDUCE, 416);
   _actionMap[174][MT] = ActionEntry(REDUCE, 416);
   _actionMap[174][LT] = ActionEntry(REDUCE, 416);
   _actionMap[174][NEGATION] = ActionEntry(REDUCE, 416);
   _actionMap[174][EQU] = ActionEntry(REDUCE, 416);
   _actionMap[174][BETWEEN] = ActionEntry(REDUCE, 416);
   _actionMap[174][IS] = ActionEntry(REDUCE, 416);
   _actionMap[174][LIKE] = ActionEntry(REDUCE, 416);
   _actionMap[174][RB] = ActionEntry(REDUCE, 416);
   _actionMap[174][ENDTOKEN] = ActionEntry(REDUCE, 416);
   _actionMap[174][UNION] = ActionEntry(REDUCE, 416);
}
void Cego::loadParser274()
{
   _actionMap[174][ROWLIMIT] = ActionEntry(REDUCE, 416);
   _actionMap[174][KSEP] = ActionEntry(REDUCE, 416);
   _actionMap[174][ASC] = ActionEntry(REDUCE, 416);
   _actionMap[174][DESC] = ActionEntry(REDUCE, 416);
   _actionMap[174][PLUS] = ActionEntry(REDUCE, 416);
   _actionMap[174][MINUS] = ActionEntry(REDUCE, 416);
   _actionMap[174][DIVISION] = ActionEntry(REDUCE, 416);
   _actionMap[174][STAR] = ActionEntry(REDUCE, 416);
   _actionMap[174][CONCAT] = ActionEntry(REDUCE, 416);
   _actionMap[174][SEMICOLON] = ActionEntry(REDUCE, 416);
   _actionMap[175][LB] = ActionEntry(SHIFT, 335);
   _actionMap[176][LB] = ActionEntry(SHIFT, 336);
   _actionMap[177][LONG] = ActionEntry(SHIFT, 342);
   _actionMap[177][BIGINT] = ActionEntry(SHIFT, 339);
   _actionMap[177][SMALLINT] = ActionEntry(SHIFT, 343);
   _actionMap[177][TINYINT] = ActionEntry(SHIFT, 344);
   _actionMap[177][DOUBLE] = ActionEntry(SHIFT, 341);
   _actionMap[177][DECIMAL] = ActionEntry(SHIFT, 340);
   _actionMap[177][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[177][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[177][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[177][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[177][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[177][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[177][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[177][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[177][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[177][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[177][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[177][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[177][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[177][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[177][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[177][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[177][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[177][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[177][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[177][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[177][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[177][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[177][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[177][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[177][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[177][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[177][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[177][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[177][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[177][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[177][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[177][POWER] = ActionEntry(SHIFT, 159);
}
void Cego::loadParser275()
{
   _actionMap[177][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[177][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[177][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[177][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[177][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[177][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[177][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[177][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[177][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[177][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[177][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[177][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[177][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[177][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[177][LB] = ActionEntry(SHIFT, 177);
   _actionMap[177][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[177][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[177][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[177][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[177][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[177][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[177][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[177][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[177][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[177][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[177][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[177][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[177][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[177][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[177][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[177][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[177][EXISTS] = ActionEntry(SHIFT, 275);
   _actionMap[177][NOT] = ActionEntry(SHIFT, 276);
   _actionMap[177][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[177][ObjSpec] = 122;
   _jumpMap[177][Constant] = 121;
   _jumpMap[177][SignedFloat] = 120;
   _jumpMap[177][SignedInt] = 119;
   _jumpMap[177][Attribute] = 118;
   _jumpMap[177][Function] = 117;
   _jumpMap[177][Factor] = 116;
   _jumpMap[177][Term] = 115;
   _jumpMap[177][Expr] = 274;
   _jumpMap[177][Predicate] = 273;
   _jumpMap[177][Condition] = 338;
   _jumpMap[177][SelectStatement] = 337;
   _jumpMap[177][CasePrepare] = 113;
   _jumpMap[177][CaseClause] = 112;
   _actionMap[178][FLOATVAL] = ActionEntry(SHIFT, 346);
   _actionMap[178][INTVAL] = ActionEntry(SHIFT, 345);
}
void Cego::loadParser276()
{
   _actionMap[179][WHEN] = ActionEntry(REDUCE, 401);
   _actionMap[179][ELSE] = ActionEntry(REDUCE, 401);
   _actionMap[179][AS] = ActionEntry(REDUCE, 401);
   _actionMap[179][FROM] = ActionEntry(REDUCE, 401);
   _actionMap[179][END_TOKEN] = ActionEntry(REDUCE, 401);
   _actionMap[179][BEGIN] = ActionEntry(REDUCE, 401);
   _actionMap[179][THEN] = ActionEntry(REDUCE, 401);
   _actionMap[179][LEFT] = ActionEntry(REDUCE, 401);
   _actionMap[179][RIGHT] = ActionEntry(REDUCE, 401);
   _actionMap[179][INNER] = ActionEntry(REDUCE, 401);
   _actionMap[179][JOIN] = ActionEntry(REDUCE, 401);
   _actionMap[179][ORDER] = ActionEntry(REDUCE, 401);
   _actionMap[179][GROUP] = ActionEntry(REDUCE, 401);
   _actionMap[179][RETURNTOKEN] = ActionEntry(REDUCE, 401);
   _actionMap[179][WHERE] = ActionEntry(REDUCE, 401);
   _actionMap[179][NULLTOKEN] = ActionEntry(REDUCE, 401);
   _actionMap[179][OR] = ActionEntry(REDUCE, 401);
   _actionMap[179][AND] = ActionEntry(REDUCE, 401);
   _actionMap[179][LIKE] = ActionEntry(REDUCE, 401);
   _actionMap[179][IS] = ActionEntry(REDUCE, 401);
   _actionMap[179][BETWEEN] = ActionEntry(REDUCE, 401);
   _actionMap[179][EQU] = ActionEntry(REDUCE, 401);
   _actionMap[179][NEGATION] = ActionEntry(REDUCE, 401);
   _actionMap[179][LT] = ActionEntry(REDUCE, 401);
   _actionMap[179][MT] = ActionEntry(REDUCE, 401);
   _actionMap[179][NOT] = ActionEntry(REDUCE, 401);
   _actionMap[179][INTOK] = ActionEntry(REDUCE, 401);
   _actionMap[179][DESC] = ActionEntry(REDUCE, 401);
   _actionMap[179][ASC] = ActionEntry(REDUCE, 401);
   _actionMap[179][KSEP] = ActionEntry(REDUCE, 401);
   _actionMap[179][ROWLIMIT] = ActionEntry(REDUCE, 401);
   _actionMap[179][UNION] = ActionEntry(REDUCE, 401);
   _actionMap[179][ENDTOKEN] = ActionEntry(REDUCE, 401);
   _actionMap[179][RB] = ActionEntry(REDUCE, 401);
   _actionMap[179][CONCAT] = ActionEntry(REDUCE, 401);
   _actionMap[179][STAR] = ActionEntry(REDUCE, 401);
   _actionMap[179][DIVISION] = ActionEntry(REDUCE, 401);
   _actionMap[179][MINUS] = ActionEntry(REDUCE, 401);
   _actionMap[179][PLUS] = ActionEntry(REDUCE, 401);
   _actionMap[179][SEMICOLON] = ActionEntry(REDUCE, 401);
   _actionMap[180][WHEN] = ActionEntry(REDUCE, 403);
   _actionMap[180][ELSE] = ActionEntry(REDUCE, 403);
   _actionMap[180][AS] = ActionEntry(REDUCE, 403);
   _actionMap[180][FROM] = ActionEntry(REDUCE, 403);
   _actionMap[180][END_TOKEN] = ActionEntry(REDUCE, 403);
   _actionMap[180][BEGIN] = ActionEntry(REDUCE, 403);
   _actionMap[180][THEN] = ActionEntry(REDUCE, 403);
   _actionMap[180][LEFT] = ActionEntry(REDUCE, 403);
   _actionMap[180][RIGHT] = ActionEntry(REDUCE, 403);
   _actionMap[180][INNER] = ActionEntry(REDUCE, 403);
}
void Cego::loadParser277()
{
   _actionMap[180][JOIN] = ActionEntry(REDUCE, 403);
   _actionMap[180][ORDER] = ActionEntry(REDUCE, 403);
   _actionMap[180][GROUP] = ActionEntry(REDUCE, 403);
   _actionMap[180][RETURNTOKEN] = ActionEntry(REDUCE, 403);
   _actionMap[180][WHERE] = ActionEntry(REDUCE, 403);
   _actionMap[180][NULLTOKEN] = ActionEntry(REDUCE, 403);
   _actionMap[180][OR] = ActionEntry(REDUCE, 403);
   _actionMap[180][AND] = ActionEntry(REDUCE, 403);
   _actionMap[180][LIKE] = ActionEntry(REDUCE, 403);
   _actionMap[180][IS] = ActionEntry(REDUCE, 403);
   _actionMap[180][BETWEEN] = ActionEntry(REDUCE, 403);
   _actionMap[180][EQU] = ActionEntry(REDUCE, 403);
   _actionMap[180][NEGATION] = ActionEntry(REDUCE, 403);
   _actionMap[180][LT] = ActionEntry(REDUCE, 403);
   _actionMap[180][MT] = ActionEntry(REDUCE, 403);
   _actionMap[180][NOT] = ActionEntry(REDUCE, 403);
   _actionMap[180][INTOK] = ActionEntry(REDUCE, 403);
   _actionMap[180][DESC] = ActionEntry(REDUCE, 403);
   _actionMap[180][ASC] = ActionEntry(REDUCE, 403);
   _actionMap[180][KSEP] = ActionEntry(REDUCE, 403);
   _actionMap[180][ROWLIMIT] = ActionEntry(REDUCE, 403);
   _actionMap[180][UNION] = ActionEntry(REDUCE, 403);
   _actionMap[180][ENDTOKEN] = ActionEntry(REDUCE, 403);
   _actionMap[180][RB] = ActionEntry(REDUCE, 403);
   _actionMap[180][CONCAT] = ActionEntry(REDUCE, 403);
   _actionMap[180][STAR] = ActionEntry(REDUCE, 403);
   _actionMap[180][DIVISION] = ActionEntry(REDUCE, 403);
   _actionMap[180][MINUS] = ActionEntry(REDUCE, 403);
   _actionMap[180][PLUS] = ActionEntry(REDUCE, 403);
   _actionMap[180][SEMICOLON] = ActionEntry(REDUCE, 403);
   _actionMap[181][WHEN] = ActionEntry(REDUCE, 398);
   _actionMap[181][ELSE] = ActionEntry(REDUCE, 398);
   _actionMap[181][FROM] = ActionEntry(REDUCE, 398);
   _actionMap[181][AS] = ActionEntry(REDUCE, 398);
   _actionMap[181][END_TOKEN] = ActionEntry(REDUCE, 398);
   _actionMap[181][BEGIN] = ActionEntry(REDUCE, 398);
   _actionMap[181][THEN] = ActionEntry(REDUCE, 398);
   _actionMap[181][LEFT] = ActionEntry(REDUCE, 398);
   _actionMap[181][RIGHT] = ActionEntry(REDUCE, 398);
   _actionMap[181][INNER] = ActionEntry(REDUCE, 398);
   _actionMap[181][JOIN] = ActionEntry(REDUCE, 398);
   _actionMap[181][ORDER] = ActionEntry(REDUCE, 398);
   _actionMap[181][GROUP] = ActionEntry(REDUCE, 398);
   _actionMap[181][RETURNTOKEN] = ActionEntry(REDUCE, 398);
   _actionMap[181][WHERE] = ActionEntry(REDUCE, 398);
   _actionMap[181][AND] = ActionEntry(REDUCE, 398);
   _actionMap[181][OR] = ActionEntry(REDUCE, 398);
   _actionMap[181][INTOK] = ActionEntry(REDUCE, 398);
   _actionMap[181][NOT] = ActionEntry(REDUCE, 398);
   _actionMap[181][MT] = ActionEntry(REDUCE, 398);
}
void Cego::loadParser278()
{
   _actionMap[181][LT] = ActionEntry(REDUCE, 398);
   _actionMap[181][NEGATION] = ActionEntry(REDUCE, 398);
   _actionMap[181][EQU] = ActionEntry(REDUCE, 398);
   _actionMap[181][BETWEEN] = ActionEntry(REDUCE, 398);
   _actionMap[181][IS] = ActionEntry(REDUCE, 398);
   _actionMap[181][LIKE] = ActionEntry(REDUCE, 398);
   _actionMap[181][RB] = ActionEntry(REDUCE, 398);
   _actionMap[181][ENDTOKEN] = ActionEntry(REDUCE, 398);
   _actionMap[181][UNION] = ActionEntry(REDUCE, 398);
   _actionMap[181][ROWLIMIT] = ActionEntry(REDUCE, 398);
   _actionMap[181][KSEP] = ActionEntry(REDUCE, 398);
   _actionMap[181][ASC] = ActionEntry(REDUCE, 398);
   _actionMap[181][DESC] = ActionEntry(REDUCE, 398);
   _actionMap[181][PLUS] = ActionEntry(REDUCE, 398);
   _actionMap[181][MINUS] = ActionEntry(REDUCE, 398);
   _actionMap[181][LB] = ActionEntry(REDUCE, 420);
   _actionMap[181][DIVISION] = ActionEntry(REDUCE, 398);
   _actionMap[181][STAR] = ActionEntry(REDUCE, 398);
   _actionMap[181][CONCAT] = ActionEntry(REDUCE, 398);
   _actionMap[181][SEMICOLON] = ActionEntry(REDUCE, 398);
   _actionMap[182][WHEN] = ActionEntry(REDUCE, 319);
   _actionMap[182][ELSE] = ActionEntry(REDUCE, 319);
   _actionMap[182][AS] = ActionEntry(REDUCE, 319);
   _actionMap[182][FROM] = ActionEntry(REDUCE, 319);
   _actionMap[182][END_TOKEN] = ActionEntry(REDUCE, 319);
   _actionMap[182][BEGIN] = ActionEntry(REDUCE, 319);
   _actionMap[182][THEN] = ActionEntry(REDUCE, 319);
   _actionMap[182][LEFT] = ActionEntry(REDUCE, 319);
   _actionMap[182][RIGHT] = ActionEntry(REDUCE, 319);
   _actionMap[182][INNER] = ActionEntry(REDUCE, 319);
   _actionMap[182][JOIN] = ActionEntry(REDUCE, 319);
   _actionMap[182][ORDER] = ActionEntry(REDUCE, 319);
   _actionMap[182][GROUP] = ActionEntry(REDUCE, 319);
   _actionMap[182][RETURNTOKEN] = ActionEntry(REDUCE, 319);
   _actionMap[182][WHERE] = ActionEntry(REDUCE, 319);
   _actionMap[182][OR] = ActionEntry(REDUCE, 319);
   _actionMap[182][AND] = ActionEntry(REDUCE, 319);
   _actionMap[182][LIKE] = ActionEntry(REDUCE, 319);
   _actionMap[182][IS] = ActionEntry(REDUCE, 319);
   _actionMap[182][BETWEEN] = ActionEntry(REDUCE, 319);
   _actionMap[182][EQU] = ActionEntry(REDUCE, 319);
   _actionMap[182][NEGATION] = ActionEntry(REDUCE, 319);
   _actionMap[182][LT] = ActionEntry(REDUCE, 319);
   _actionMap[182][MT] = ActionEntry(REDUCE, 319);
   _actionMap[182][NOT] = ActionEntry(REDUCE, 319);
   _actionMap[182][INTOK] = ActionEntry(REDUCE, 319);
   _actionMap[182][CONCAT] = ActionEntry(REDUCE, 319);
   _actionMap[182][STAR] = ActionEntry(REDUCE, 319);
   _actionMap[182][DIVISION] = ActionEntry(REDUCE, 319);
   _actionMap[182][MINUS] = ActionEntry(REDUCE, 319);
}
void Cego::loadParser279()
{
   _actionMap[182][PLUS] = ActionEntry(REDUCE, 319);
   _actionMap[182][DESC] = ActionEntry(REDUCE, 319);
   _actionMap[182][ASC] = ActionEntry(REDUCE, 319);
   _actionMap[182][KSEP] = ActionEntry(REDUCE, 319);
   _actionMap[182][ROWLIMIT] = ActionEntry(REDUCE, 319);
   _actionMap[182][UNION] = ActionEntry(REDUCE, 319);
   _actionMap[182][ENDTOKEN] = ActionEntry(REDUCE, 319);
   _actionMap[182][RB] = ActionEntry(REDUCE, 319);
   _actionMap[182][SEMICOLON] = ActionEntry(REDUCE, 319);
   _actionMap[183][WHEN] = ActionEntry(REDUCE, 399);
   _actionMap[183][ELSE] = ActionEntry(REDUCE, 399);
   _actionMap[183][FROM] = ActionEntry(REDUCE, 399);
   _actionMap[183][AS] = ActionEntry(REDUCE, 399);
   _actionMap[183][END_TOKEN] = ActionEntry(REDUCE, 399);
   _actionMap[183][BEGIN] = ActionEntry(REDUCE, 399);
   _actionMap[183][THEN] = ActionEntry(REDUCE, 399);
   _actionMap[183][LEFT] = ActionEntry(REDUCE, 399);
   _actionMap[183][RIGHT] = ActionEntry(REDUCE, 399);
   _actionMap[183][INNER] = ActionEntry(REDUCE, 399);
   _actionMap[183][JOIN] = ActionEntry(REDUCE, 399);
   _actionMap[183][ORDER] = ActionEntry(REDUCE, 399);
   _actionMap[183][GROUP] = ActionEntry(REDUCE, 399);
   _actionMap[183][RETURNTOKEN] = ActionEntry(REDUCE, 399);
   _actionMap[183][WHERE] = ActionEntry(REDUCE, 399);
   _actionMap[183][AND] = ActionEntry(REDUCE, 399);
   _actionMap[183][OR] = ActionEntry(REDUCE, 399);
   _actionMap[183][INTOK] = ActionEntry(REDUCE, 399);
   _actionMap[183][NOT] = ActionEntry(REDUCE, 399);
   _actionMap[183][MT] = ActionEntry(REDUCE, 399);
   _actionMap[183][LT] = ActionEntry(REDUCE, 399);
   _actionMap[183][NEGATION] = ActionEntry(REDUCE, 399);
   _actionMap[183][EQU] = ActionEntry(REDUCE, 399);
   _actionMap[183][BETWEEN] = ActionEntry(REDUCE, 399);
   _actionMap[183][IS] = ActionEntry(REDUCE, 399);
   _actionMap[183][LIKE] = ActionEntry(REDUCE, 399);
   _actionMap[183][RB] = ActionEntry(REDUCE, 399);
   _actionMap[183][ENDTOKEN] = ActionEntry(REDUCE, 399);
   _actionMap[183][UNION] = ActionEntry(REDUCE, 399);
   _actionMap[183][ROWLIMIT] = ActionEntry(REDUCE, 399);
   _actionMap[183][KSEP] = ActionEntry(REDUCE, 399);
   _actionMap[183][ASC] = ActionEntry(REDUCE, 399);
   _actionMap[183][DESC] = ActionEntry(REDUCE, 399);
   _actionMap[183][PLUS] = ActionEntry(REDUCE, 399);
   _actionMap[183][MINUS] = ActionEntry(REDUCE, 399);
   _actionMap[183][LB] = ActionEntry(REDUCE, 421);
   _actionMap[183][DIVISION] = ActionEntry(REDUCE, 399);
   _actionMap[183][STAR] = ActionEntry(REDUCE, 399);
   _actionMap[183][CONCAT] = ActionEntry(REDUCE, 399);
   _actionMap[183][SEMICOLON] = ActionEntry(REDUCE, 399);
   _actionMap[184][STAR] = ActionEntry(SHIFT, 347);
}
void Cego::loadParser280()
{
   _actionMap[185][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[185][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[185][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[185][ObjSpec] = 348;
   _actionMap[186][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[186][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[186][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[186][ObjSpec] = 349;
   _actionMap[187][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[187][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[187][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[187][ObjSpec] = 350;
   _actionMap[188][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[188][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[188][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[188][ObjSpec] = 351;
   _actionMap[189][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[189][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[189][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[189][ObjSpec] = 352;
   _actionMap[190][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[190][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[190][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[190][ObjSpec] = 353;
   _actionMap[191][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[191][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[191][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[191][ObjSpec] = 354;
   _actionMap[192][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[192][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[192][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[192][ObjSpec] = 355;
   _actionMap[193][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[193][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[193][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[193][ObjSpec] = 356;
   _actionMap[194][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[194][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[194][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[194][ObjSpec] = 357;
   _actionMap[195][SEMICOLON] = ActionEntry(REDUCE, 171);
   _actionMap[195][FROM] = ActionEntry(SHIFT, 360);
   _actionMap[195][RB] = ActionEntry(REDUCE, 171);
   _jumpMap[195][NoFromOption] = 359;
   _jumpMap[195][FromOption] = 358;
   _actionMap[196][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[196][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[196][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[196][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[196][ASC2INT] = ActionEntry(SHIFT, 124);
}
void Cego::loadParser281()
{
   _actionMap[196][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[196][RTRIM] = ActionEntry(SHIFT, 165);
   _actionMap[196][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[196][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[196][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[196][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[196][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[196][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[196][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[196][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[196][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[196][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[196][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[196][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[196][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[196][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[196][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[196][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[196][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[196][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[196][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[196][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[196][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[196][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[196][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[196][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[196][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[196][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[196][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[196][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[196][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[196][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[196][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[196][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[196][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[196][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[196][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[196][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[196][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[196][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[196][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[196][LB] = ActionEntry(SHIFT, 177);
   _actionMap[196][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[196][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[196][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[196][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[196][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[196][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[196][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[196][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
}
void Cego::loadParser282()
{
   _actionMap[196][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[196][VARREF] = ActionEntry(SHIFT, 182);
   _actionMap[196][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[196][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[196][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[196][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[196][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[196][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[196][ObjSpec] = 122;
   _jumpMap[196][Constant] = 121;
   _jumpMap[196][SignedFloat] = 120;
   _jumpMap[196][SignedInt] = 119;
   _jumpMap[196][Attribute] = 118;
   _jumpMap[196][Function] = 117;
   _jumpMap[196][Factor] = 116;
   _jumpMap[196][Term] = 115;
   _jumpMap[196][Expr] = 363;
   _jumpMap[196][SelectItem] = 362;
   _jumpMap[196][SelectionList] = 361;
   _jumpMap[196][CasePrepare] = 113;
   _jumpMap[196][CaseClause] = 112;
   _actionMap[197][VARREF] = ActionEntry(REDUCE, 215);
   _actionMap[197][FETCH] = ActionEntry(REDUCE, 215);
   _actionMap[197][LB] = ActionEntry(REDUCE, 215);
   _actionMap[197][COUNT] = ActionEntry(REDUCE, 215);
   _actionMap[197][SUM] = ActionEntry(REDUCE, 215);
   _actionMap[197][AVG] = ActionEntry(REDUCE, 215);
   _actionMap[197][MIN] = ActionEntry(REDUCE, 215);
   _actionMap[197][MAX] = ActionEntry(REDUCE, 215);
   _actionMap[197][CASE] = ActionEntry(REDUCE, 215);
   _actionMap[197][INT2ASC] = ActionEntry(REDUCE, 215);
   _actionMap[197][ASC2INT] = ActionEntry(REDUCE, 215);
   _actionMap[197][TRIM] = ActionEntry(REDUCE, 215);
   _actionMap[197][RTRIM] = ActionEntry(REDUCE, 215);
   _actionMap[197][LTRIM] = ActionEntry(REDUCE, 215);
   _actionMap[197][ROUND] = ActionEntry(REDUCE, 215);
   _actionMap[197][SCANDATE] = ActionEntry(REDUCE, 215);
   _actionMap[197][DATE2STR] = ActionEntry(REDUCE, 215);
   _actionMap[197][DATE2LONG] = ActionEntry(REDUCE, 215);
   _actionMap[197][LONG2DATE] = ActionEntry(REDUCE, 215);
   _actionMap[197][NEWDATE] = ActionEntry(REDUCE, 215);
   _actionMap[197][LOWER] = ActionEntry(REDUCE, 215);
   _actionMap[197][UPPER] = ActionEntry(REDUCE, 215);
   _actionMap[197][LEFT] = ActionEntry(REDUCE, 215);
   _actionMap[197][RIGHT] = ActionEntry(REDUCE, 215);
   _actionMap[197][GETPOS] = ActionEntry(REDUCE, 215);
   _actionMap[197][SUBSTR] = ActionEntry(REDUCE, 215);
   _actionMap[197][REPLACE] = ActionEntry(REDUCE, 215);
   _actionMap[197][LENGTH] = ActionEntry(REDUCE, 215);
   _actionMap[197][TRUNC] = ActionEntry(REDUCE, 215);
}
void Cego::loadParser283()
{
   _actionMap[197][STR2INT] = ActionEntry(REDUCE, 215);
   _actionMap[197][STR2LONG] = ActionEntry(REDUCE, 215);
   _actionMap[197][RANDSTR] = ActionEntry(REDUCE, 215);
   _actionMap[197][RANDINT] = ActionEntry(REDUCE, 215);
   _actionMap[197][MOD] = ActionEntry(REDUCE, 215);
   _actionMap[197][DIV] = ActionEntry(REDUCE, 215);
   _actionMap[197][LMOD] = ActionEntry(REDUCE, 215);
   _actionMap[197][LDIV] = ActionEntry(REDUCE, 215);
   _actionMap[197][POWER] = ActionEntry(REDUCE, 215);
   _actionMap[197][BITAND] = ActionEntry(REDUCE, 215);
   _actionMap[197][BITOR] = ActionEntry(REDUCE, 215);
   _actionMap[197][BITXOR] = ActionEntry(REDUCE, 215);
   _actionMap[197][BLOBSIZE] = ActionEntry(REDUCE, 215);
   _actionMap[197][BLOBREF] = ActionEntry(REDUCE, 215);
   _actionMap[197][CLOBSIZE] = ActionEntry(REDUCE, 215);
   _actionMap[197][CLOBREF] = ActionEntry(REDUCE, 215);
   _actionMap[197][CLOB2STR] = ActionEntry(REDUCE, 215);
   _actionMap[197][NEXTCOUNT] = ActionEntry(REDUCE, 215);
   _actionMap[197][SETCOUNT] = ActionEntry(REDUCE, 215);
   _actionMap[197][GETCOUNT] = ActionEntry(REDUCE, 215);
   _actionMap[197][IDENTIFIER] = ActionEntry(REDUCE, 215);
   _actionMap[197][QUALIFIEDOBJ] = ActionEntry(REDUCE, 215);
   _actionMap[197][QUALIFIEDTS] = ActionEntry(REDUCE, 215);
   _actionMap[197][QUALIFIEDPRE] = ActionEntry(REDUCE, 215);
   _actionMap[197][STRINGVAL] = ActionEntry(REDUCE, 215);
   _actionMap[197][SYSDATE] = ActionEntry(REDUCE, 215);
   _actionMap[197][NULLTOKEN] = ActionEntry(REDUCE, 215);
   _actionMap[197][TRUEVAL] = ActionEntry(REDUCE, 215);
   _actionMap[197][FALSEVAL] = ActionEntry(REDUCE, 215);
   _actionMap[197][BLOB] = ActionEntry(REDUCE, 215);
   _actionMap[197][CLOB] = ActionEntry(REDUCE, 215);
   _actionMap[197][FLOATVAL] = ActionEntry(REDUCE, 215);
   _actionMap[197][MINUS] = ActionEntry(REDUCE, 215);
   _actionMap[197][INTVAL] = ActionEntry(REDUCE, 215);
   _actionMap[198][VARREF] = ActionEntry(REDUCE, 214);
   _actionMap[198][FETCH] = ActionEntry(REDUCE, 214);
   _actionMap[198][LB] = ActionEntry(REDUCE, 214);
   _actionMap[198][COUNT] = ActionEntry(REDUCE, 214);
   _actionMap[198][SUM] = ActionEntry(REDUCE, 214);
   _actionMap[198][AVG] = ActionEntry(REDUCE, 214);
   _actionMap[198][MIN] = ActionEntry(REDUCE, 214);
   _actionMap[198][MAX] = ActionEntry(REDUCE, 214);
   _actionMap[198][CASE] = ActionEntry(REDUCE, 214);
   _actionMap[198][INT2ASC] = ActionEntry(REDUCE, 214);
   _actionMap[198][ASC2INT] = ActionEntry(REDUCE, 214);
   _actionMap[198][TRIM] = ActionEntry(REDUCE, 214);
   _actionMap[198][RTRIM] = ActionEntry(REDUCE, 214);
   _actionMap[198][LTRIM] = ActionEntry(REDUCE, 214);
   _actionMap[198][ROUND] = ActionEntry(REDUCE, 214);
   _actionMap[198][SCANDATE] = ActionEntry(REDUCE, 214);
}
void Cego::loadParser284()
{
   _actionMap[198][DATE2STR] = ActionEntry(REDUCE, 214);
   _actionMap[198][DATE2LONG] = ActionEntry(REDUCE, 214);
   _actionMap[198][LONG2DATE] = ActionEntry(REDUCE, 214);
   _actionMap[198][NEWDATE] = ActionEntry(REDUCE, 214);
   _actionMap[198][LOWER] = ActionEntry(REDUCE, 214);
   _actionMap[198][UPPER] = ActionEntry(REDUCE, 214);
   _actionMap[198][LEFT] = ActionEntry(REDUCE, 214);
   _actionMap[198][RIGHT] = ActionEntry(REDUCE, 214);
   _actionMap[198][GETPOS] = ActionEntry(REDUCE, 214);
   _actionMap[198][SUBSTR] = ActionEntry(REDUCE, 214);
   _actionMap[198][REPLACE] = ActionEntry(REDUCE, 214);
   _actionMap[198][LENGTH] = ActionEntry(REDUCE, 214);
   _actionMap[198][TRUNC] = ActionEntry(REDUCE, 214);
   _actionMap[198][STR2INT] = ActionEntry(REDUCE, 214);
   _actionMap[198][STR2LONG] = ActionEntry(REDUCE, 214);
   _actionMap[198][RANDSTR] = ActionEntry(REDUCE, 214);
   _actionMap[198][RANDINT] = ActionEntry(REDUCE, 214);
   _actionMap[198][MOD] = ActionEntry(REDUCE, 214);
   _actionMap[198][DIV] = ActionEntry(REDUCE, 214);
   _actionMap[198][LMOD] = ActionEntry(REDUCE, 214);
   _actionMap[198][LDIV] = ActionEntry(REDUCE, 214);
   _actionMap[198][POWER] = ActionEntry(REDUCE, 214);
   _actionMap[198][BITAND] = ActionEntry(REDUCE, 214);
   _actionMap[198][BITOR] = ActionEntry(REDUCE, 214);
   _actionMap[198][BITXOR] = ActionEntry(REDUCE, 214);
   _actionMap[198][BLOBSIZE] = ActionEntry(REDUCE, 214);
   _actionMap[198][BLOBREF] = ActionEntry(REDUCE, 214);
   _actionMap[198][CLOBSIZE] = ActionEntry(REDUCE, 214);
   _actionMap[198][CLOBREF] = ActionEntry(REDUCE, 214);
   _actionMap[198][CLOB2STR] = ActionEntry(REDUCE, 214);
   _actionMap[198][NEXTCOUNT] = ActionEntry(REDUCE, 214);
   _actionMap[198][SETCOUNT] = ActionEntry(REDUCE, 214);
   _actionMap[198][GETCOUNT] = ActionEntry(REDUCE, 214);
   _actionMap[198][IDENTIFIER] = ActionEntry(REDUCE, 214);
   _actionMap[198][QUALIFIEDOBJ] = ActionEntry(REDUCE, 214);
   _actionMap[198][QUALIFIEDTS] = ActionEntry(REDUCE, 214);
   _actionMap[198][QUALIFIEDPRE] = ActionEntry(REDUCE, 214);
   _actionMap[198][STRINGVAL] = ActionEntry(REDUCE, 214);
   _actionMap[198][SYSDATE] = ActionEntry(REDUCE, 214);
   _actionMap[198][NULLTOKEN] = ActionEntry(REDUCE, 214);
   _actionMap[198][TRUEVAL] = ActionEntry(REDUCE, 214);
   _actionMap[198][FALSEVAL] = ActionEntry(REDUCE, 214);
   _actionMap[198][BLOB] = ActionEntry(REDUCE, 214);
   _actionMap[198][CLOB] = ActionEntry(REDUCE, 214);
   _actionMap[198][FLOATVAL] = ActionEntry(REDUCE, 214);
   _actionMap[198][MINUS] = ActionEntry(REDUCE, 214);
   _actionMap[198][INTVAL] = ActionEntry(REDUCE, 214);
   _actionMap[199][FROM] = ActionEntry(REDUCE, 173);
   _actionMap[199][RB] = ActionEntry(REDUCE, 173);
   _actionMap[199][SEMICOLON] = ActionEntry(REDUCE, 173);
}
void Cego::loadParser285()
{
   _actionMap[199][ENDTOKEN] = ActionEntry(REDUCE, 173);
   _actionMap[200][OFF] = ActionEntry(SHIFT, 364);
   _actionMap[200][ON] = ActionEntry(SHIFT, 365);
   _actionMap[201][OFF] = ActionEntry(SHIFT, 366);
   _actionMap[201][ON] = ActionEntry(SHIFT, 367);
   _actionMap[202][IDENTIFIER] = ActionEntry(SHIFT, 225);
   _jumpMap[202][CounterId] = 368;
   _actionMap[203][OFF] = ActionEntry(SHIFT, 369);
   _actionMap[203][ON] = ActionEntry(SHIFT, 370);
   _actionMap[204][IDENTIFIER] = ActionEntry(SHIFT, 371);
   _actionMap[205][IDENTIFIER] = ActionEntry(SHIFT, 372);
   _actionMap[206][EQU] = ActionEntry(SHIFT, 373);
   _actionMap[207][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[207][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[207][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[207][ObjSpec] = 374;
   _actionMap[208][SEMICOLON] = ActionEntry(REDUCE, 21);
   _actionMap[209][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[209][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[209][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[209][ObjSpec] = 375;
   _actionMap[210][SEMICOLON] = ActionEntry(REDUCE, 22);
   _actionMap[211][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[211][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[211][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[211][ObjSpec] = 376;
   _actionMap[212][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[212][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[212][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[212][ObjSpec] = 377;
   _actionMap[213][SEMICOLON] = ActionEntry(REDUCE, 137);
   _actionMap[214][SEMICOLON] = ActionEntry(REDUCE, 17);
   _actionMap[215][SEMICOLON] = ActionEntry(REDUCE, 18);
   _actionMap[216][SEMICOLON] = ActionEntry(REDUCE, 19);
   _actionMap[217][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[217][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[217][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[217][ObjSpec] = 378;
   _actionMap[218][IDENTIFIER] = ActionEntry(SHIFT, 381);
   _actionMap[218][SET] = ActionEntry(REDUCE, 167);
   _jumpMap[218][UpdDelAlias] = 379;
   _actionMap[219][CALL] = ActionEntry(SHIFT, 382);
   _actionMap[1][TABLE] = ActionEntry(SHIFT, 55);
   _actionMap[1][AVLTREE] = ActionEntry(SHIFT, 48);
   _actionMap[1][VIEW] = ActionEntry(SHIFT, 57);
   _actionMap[1][PROCEDURE] = ActionEntry(SHIFT, 54);
   _actionMap[1][FOREIGN] = ActionEntry(SHIFT, 52);
   _actionMap[1][CHECK] = ActionEntry(SHIFT, 50);
   _actionMap[1][TRIGGER] = ActionEntry(SHIFT, 56);
   _actionMap[1][ALIAS] = ActionEntry(SHIFT, 47);
}
void Cego::loadParser286()
{
   _actionMap[1][COUNTER] = ActionEntry(SHIFT, 51);
   _actionMap[1][BTREE] = ActionEntry(SHIFT, 49);
   _actionMap[1][INDEX] = ActionEntry(SHIFT, 53);
   _jumpMap[1][BtreeType] = 46;
   _actionMap[2][SEMICOLON] = ActionEntry(SHIFT, 58);
   _actionMap[3][SEMICOLON] = ActionEntry(REDUCE, 37);
   _actionMap[4][SEMICOLON] = ActionEntry(REDUCE, 38);
   _actionMap[5][SEMICOLON] = ActionEntry(REDUCE, 39);
   _actionMap[6][SEMICOLON] = ActionEntry(REDUCE, 40);
   _actionMap[7][SEMICOLON] = ActionEntry(REDUCE, 41);
   _actionMap[8][SEMICOLON] = ActionEntry(REDUCE, 53);
   _actionMap[9][SEMICOLON] = ActionEntry(REDUCE, 55);
   _actionMap[10][SEMICOLON] = ActionEntry(REDUCE, 54);
   _actionMap[11][SEMICOLON] = ActionEntry(REDUCE, 51);
   _actionMap[12][SEMICOLON] = ActionEntry(REDUCE, 56);
   _actionMap[13][SEMICOLON] = ActionEntry(REDUCE, 57);
   _actionMap[14][TABLE] = ActionEntry(SHIFT, 59);
   _actionMap[15][IDENTIFIER] = ActionEntry(SHIFT, 60);
   _actionMap[16][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[16][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[16][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[16][ObjSpec] = 61;
   _actionMap[17][AVLTREE] = ActionEntry(SHIFT, 65);
   _actionMap[18][SEMICOLON] = ActionEntry(REDUCE, 138);
   _actionMap[19][VIEW] = ActionEntry(SHIFT, 78);
   _actionMap[19][TABLE] = ActionEntry(SHIFT, 75);
   _actionMap[19][PRIMARY] = ActionEntry(SHIFT, 73);
   _actionMap[19][ALIAS] = ActionEntry(SHIFT, 71);
   _actionMap[19][COUNTER] = ActionEntry(SHIFT, 72);
   _actionMap[19][PROCEDURE] = ActionEntry(SHIFT, 74);
   _actionMap[19][UNIQUE] = ActionEntry(SHIFT, 77);
   _actionMap[19][AVLTREE] = ActionEntry(REDUCE, 132);
   _actionMap[19][BTREE] = ActionEntry(REDUCE, 132);
   _actionMap[19][INDEX] = ActionEntry(REDUCE, 132);
   _actionMap[19][TRIGGER] = ActionEntry(SHIFT, 76);
   _jumpMap[19][ProcDef] = 70;
   _jumpMap[19][ProcHead] = 69;
   _jumpMap[19][IndexOption] = 68;
   _jumpMap[19][TriggerHead] = 67;
   _jumpMap[19][TriggerDef] = 66;
   _actionMap[20][FROM] = ActionEntry(SHIFT, 79);
   _actionMap[21][TABLE] = ActionEntry(SHIFT, 86);
   _actionMap[21][AVLTREE] = ActionEntry(SHIFT, 82);
   _actionMap[21][VIEW] = ActionEntry(SHIFT, 87);
   _actionMap[21][FOREIGN] = ActionEntry(SHIFT, 84);
   _actionMap[21][CHECK] = ActionEntry(SHIFT, 83);
   _actionMap[21][ALIAS] = ActionEntry(SHIFT, 81);
   _actionMap[21][PROCEDURE] = ActionEntry(SHIFT, 85);
   _actionMap[21][BTREE] = ActionEntry(SHIFT, 49);
   _actionMap[21][INDEX] = ActionEntry(SHIFT, 53);
}
void Cego::loadParser287()
{
   _jumpMap[21][BtreeType] = 80;
   _actionMap[22][COUNTER] = ActionEntry(REDUCE, 86);
   _actionMap[22][IF] = ActionEntry(SHIFT, 88);
   _actionMap[22][ALIAS] = ActionEntry(REDUCE, 86);
   _actionMap[22][BTREE] = ActionEntry(REDUCE, 86);
   _actionMap[22][INDEX] = ActionEntry(REDUCE, 86);
   _actionMap[22][TRIGGER] = ActionEntry(REDUCE, 86);
   _actionMap[22][CHECK] = ActionEntry(REDUCE, 86);
   _actionMap[22][FOREIGN] = ActionEntry(REDUCE, 86);
   _actionMap[22][PROCEDURE] = ActionEntry(REDUCE, 86);
   _actionMap[22][VIEW] = ActionEntry(REDUCE, 86);
   _actionMap[22][AVLTREE] = ActionEntry(REDUCE, 86);
   _actionMap[22][TABLE] = ActionEntry(REDUCE, 86);
   _actionMap[23][INTO] = ActionEntry(SHIFT, 89);
   _actionMap[24][IDENTIFIER] = ActionEntry(SHIFT, 91);
   _jumpMap[24][JdbcArgList] = 90;
   _actionMap[25][TABLESET] = ActionEntry(SHIFT, 101);
   _actionMap[25][TABLE] = ActionEntry(SHIFT, 100);
   _actionMap[25][PROCEDURE] = ActionEntry(SHIFT, 98);
   _actionMap[25][VIEW] = ActionEntry(SHIFT, 104);
   _actionMap[25][AVLTREE] = ActionEntry(SHIFT, 94);
   _actionMap[25][KEY] = ActionEntry(SHIFT, 97);
   _actionMap[25][COUNTER] = ActionEntry(SHIFT, 96);
   _actionMap[25][SYSOBJ] = ActionEntry(SHIFT, 99);
   _actionMap[25][TMPOBJ] = ActionEntry(SHIFT, 102);
   _actionMap[25][CHECK] = ActionEntry(SHIFT, 95);
   _actionMap[25][TRIGGER] = ActionEntry(SHIFT, 103);
   _actionMap[25][ALIAS] = ActionEntry(SHIFT, 93);
   _actionMap[25][BTREE] = ActionEntry(SHIFT, 49);
   _actionMap[25][INDEX] = ActionEntry(SHIFT, 53);
   _jumpMap[25][BtreeType] = 92;
   _actionMap[26][VIEW] = ActionEntry(SHIFT, 108);
   _actionMap[26][CONDITION] = ActionEntry(SHIFT, 107);
   _actionMap[26][PROCEDURE] = ActionEntry(SHIFT, 74);
   _actionMap[26][TRIGGER] = ActionEntry(SHIFT, 76);
   _jumpMap[26][ProcDef] = 106;
   _jumpMap[26][ProcHead] = 69;
   _jumpMap[26][TriggerHead] = 67;
   _jumpMap[26][TriggerDef] = 105;
   _actionMap[27][TABLE] = ActionEntry(SHIFT, 109);
   _actionMap[28][TABLE] = ActionEntry(SHIFT, 110);
   _actionMap[29][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[29][SelectStatement] = 111;
   _actionMap[30][FLOATVAL] = ActionEntry(SHIFT, 180);
   _actionMap[30][MINUS] = ActionEntry(SHIFT, 178);
   _actionMap[30][INTVAL] = ActionEntry(SHIFT, 179);
   _actionMap[30][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[30][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[30][TRIM] = ActionEntry(SHIFT, 173);
   _actionMap[30][RTRIM] = ActionEntry(SHIFT, 165);
}
void Cego::loadParser288()
{
   _actionMap[30][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[30][ROUND] = ActionEntry(SHIFT, 164);
   _actionMap[30][SCANDATE] = ActionEntry(SHIFT, 166);
   _actionMap[30][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[30][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[30][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[30][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[30][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[30][UPPER] = ActionEntry(SHIFT, 176);
   _actionMap[30][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[30][RIGHT] = ActionEntry(SHIFT, 163);
   _actionMap[30][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[30][SUBSTR] = ActionEntry(SHIFT, 168);
   _actionMap[30][REPLACE] = ActionEntry(SHIFT, 162);
   _actionMap[30][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[30][TRUNC] = ActionEntry(SHIFT, 175);
   _actionMap[30][STR2INT] = ActionEntry(SHIFT, 171);
   _actionMap[30][STR2LONG] = ActionEntry(SHIFT, 172);
   _actionMap[30][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[30][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[30][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[30][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[30][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[30][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[30][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[30][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[30][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[30][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[30][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[30][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[30][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[30][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[30][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[30][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[30][SETCOUNT] = ActionEntry(SHIFT, 167);
   _actionMap[30][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[30][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[30][QUALIFIEDOBJ] = ActionEntry(SHIFT, 183);
   _actionMap[30][QUALIFIEDPRE] = ActionEntry(SHIFT, 184);
   _actionMap[30][LB] = ActionEntry(SHIFT, 177);
   _actionMap[30][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[30][SYSDATE] = ActionEntry(SHIFT, 170);
   _actionMap[30][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[30][TRUEVAL] = ActionEntry(SHIFT, 174);
   _actionMap[30][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[30][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[30][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[30][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[30][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[30][VARREF] = ActionEntry(SHIFT, 182);
}
void Cego::loadParser289()
{
   _actionMap[30][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[30][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[30][SUM] = ActionEntry(SHIFT, 169);
   _actionMap[30][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[30][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[30][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[30][ObjSpec] = 122;
   _jumpMap[30][Constant] = 121;
   _jumpMap[30][SignedFloat] = 120;
   _jumpMap[30][SignedInt] = 119;
   _jumpMap[30][Attribute] = 118;
   _jumpMap[30][Function] = 117;
   _jumpMap[30][Factor] = 116;
   _jumpMap[30][Term] = 115;
   _jumpMap[30][Expr] = 114;
   _jumpMap[30][CasePrepare] = 113;
   _jumpMap[30][CaseClause] = 112;
   _actionMap[31][TABLE] = ActionEntry(SHIFT, 190);
   _actionMap[31][AVLTREE] = ActionEntry(SHIFT, 186);
   _actionMap[31][KEY] = ActionEntry(SHIFT, 188);
   _actionMap[31][PROCEDURE] = ActionEntry(SHIFT, 189);
   _actionMap[31][VIEW] = ActionEntry(SHIFT, 192);
   _actionMap[31][CHECK] = ActionEntry(SHIFT, 187);
   _actionMap[31][TRIGGER] = ActionEntry(SHIFT, 191);
   _actionMap[31][BTREE] = ActionEntry(SHIFT, 49);
   _actionMap[31][INDEX] = ActionEntry(SHIFT, 53);
   _jumpMap[31][BtreeType] = 185;
   _actionMap[32][TABLE] = ActionEntry(SHIFT, 194);
   _actionMap[32][AVLTREE] = ActionEntry(SHIFT, 193);
   _actionMap[33][SEMICOLON] = ActionEntry(REDUCE, 139);
   _actionMap[34][INTVAL] = ActionEntry(REDUCE, 216);
   _actionMap[34][MINUS] = ActionEntry(REDUCE, 216);
   _actionMap[34][FLOATVAL] = ActionEntry(REDUCE, 216);
   _actionMap[34][CLOB] = ActionEntry(REDUCE, 216);
   _actionMap[34][BLOB] = ActionEntry(REDUCE, 216);
   _actionMap[34][FALSEVAL] = ActionEntry(REDUCE, 216);
   _actionMap[34][TRUEVAL] = ActionEntry(REDUCE, 216);
   _actionMap[34][NULLTOKEN] = ActionEntry(REDUCE, 216);
   _actionMap[34][SYSDATE] = ActionEntry(REDUCE, 216);
   _actionMap[34][STRINGVAL] = ActionEntry(REDUCE, 216);
   _actionMap[34][QUALIFIEDPRE] = ActionEntry(REDUCE, 216);
   _actionMap[34][QUALIFIEDTS] = ActionEntry(REDUCE, 216);
   _actionMap[34][QUALIFIEDOBJ] = ActionEntry(REDUCE, 216);
   _actionMap[34][IDENTIFIER] = ActionEntry(REDUCE, 216);
   _actionMap[34][GETCOUNT] = ActionEntry(REDUCE, 216);
   _actionMap[34][SETCOUNT] = ActionEntry(REDUCE, 216);
   _actionMap[34][NEXTCOUNT] = ActionEntry(REDUCE, 216);
   _actionMap[34][CLOB2STR] = ActionEntry(REDUCE, 216);
   _actionMap[34][CLOBREF] = ActionEntry(REDUCE, 216);
   _actionMap[34][CLOBSIZE] = ActionEntry(REDUCE, 216);
}
void Cego::loadParser290()
{
   _actionMap[34][BLOBREF] = ActionEntry(REDUCE, 216);
   _actionMap[34][BLOBSIZE] = ActionEntry(REDUCE, 216);
   _actionMap[34][BITXOR] = ActionEntry(REDUCE, 216);
   _actionMap[34][BITOR] = ActionEntry(REDUCE, 216);
   _actionMap[34][BITAND] = ActionEntry(REDUCE, 216);
   _actionMap[34][POWER] = ActionEntry(REDUCE, 216);
   _actionMap[34][LDIV] = ActionEntry(REDUCE, 216);
   _actionMap[34][LMOD] = ActionEntry(REDUCE, 216);
   _actionMap[34][DIV] = ActionEntry(REDUCE, 216);
   _actionMap[34][MOD] = ActionEntry(REDUCE, 216);
   _actionMap[34][RANDINT] = ActionEntry(REDUCE, 216);
   _actionMap[34][RANDSTR] = ActionEntry(REDUCE, 216);
   _actionMap[34][STR2LONG] = ActionEntry(REDUCE, 216);
   _actionMap[34][STR2INT] = ActionEntry(REDUCE, 216);
   _actionMap[34][TRUNC] = ActionEntry(REDUCE, 216);
   _actionMap[34][LENGTH] = ActionEntry(REDUCE, 216);
   _actionMap[34][REPLACE] = ActionEntry(REDUCE, 216);
   _actionMap[34][SUBSTR] = ActionEntry(REDUCE, 216);
   _actionMap[34][GETPOS] = ActionEntry(REDUCE, 216);
   _actionMap[34][RIGHT] = ActionEntry(REDUCE, 216);
   _actionMap[34][LEFT] = ActionEntry(REDUCE, 216);
   _actionMap[34][UPPER] = ActionEntry(REDUCE, 216);
   _actionMap[34][LOWER] = ActionEntry(REDUCE, 216);
   _actionMap[34][NEWDATE] = ActionEntry(REDUCE, 216);
   _actionMap[34][LONG2DATE] = ActionEntry(REDUCE, 216);
   _actionMap[34][DATE2LONG] = ActionEntry(REDUCE, 216);
   _actionMap[34][DATE2STR] = ActionEntry(REDUCE, 216);
   _actionMap[34][SCANDATE] = ActionEntry(REDUCE, 216);
   _actionMap[34][ROUND] = ActionEntry(REDUCE, 216);
   _actionMap[34][LTRIM] = ActionEntry(REDUCE, 216);
   _actionMap[34][RTRIM] = ActionEntry(REDUCE, 216);
   _actionMap[34][TRIM] = ActionEntry(REDUCE, 216);
   _actionMap[34][ASC2INT] = ActionEntry(REDUCE, 216);
   _actionMap[34][INT2ASC] = ActionEntry(REDUCE, 216);
   _actionMap[34][CASE] = ActionEntry(REDUCE, 216);
   _actionMap[34][MAX] = ActionEntry(REDUCE, 216);
   _actionMap[34][MIN] = ActionEntry(REDUCE, 216);
   _actionMap[34][AVG] = ActionEntry(REDUCE, 216);
   _actionMap[34][SUM] = ActionEntry(REDUCE, 216);
   _actionMap[34][COUNT] = ActionEntry(REDUCE, 216);
   _actionMap[34][LB] = ActionEntry(REDUCE, 216);
   _actionMap[34][FETCH] = ActionEntry(REDUCE, 216);
   _actionMap[34][VARREF] = ActionEntry(REDUCE, 216);
   _actionMap[34][DISTINCT] = ActionEntry(SHIFT, 198);
   _actionMap[34][STAR] = ActionEntry(SHIFT, 199);
   _jumpMap[34][NoDistinctOpt] = 197;
   _jumpMap[34][DistinctOpt] = 196;
   _jumpMap[34][Selection] = 195;
   _actionMap[35][TABLESET] = ActionEntry(SHIFT, 205);
   _actionMap[35][GRACE] = ActionEntry(SHIFT, 203);
}
void Cego::loadParser291()
{
   _actionMap[35][APPEND] = ActionEntry(SHIFT, 200);
   _actionMap[35][AUTOCOMMIT] = ActionEntry(SHIFT, 201);
   _actionMap[35][ISOLATION] = ActionEntry(SHIFT, 204);
   _actionMap[35][IDENTIFIER] = ActionEntry(SHIFT, 206);
   _actionMap[35][COUNTER] = ActionEntry(SHIFT, 202);
   _actionMap[36][POOL] = ActionEntry(SHIFT, 208);
   _actionMap[36][SYSTEMSPACE] = ActionEntry(SHIFT, 210);
   _actionMap[36][PROCEDURE] = ActionEntry(SHIFT, 209);
   _actionMap[36][VIEW] = ActionEntry(SHIFT, 212);
   _actionMap[36][CHECK] = ActionEntry(SHIFT, 207);
   _actionMap[36][TRIGGER] = ActionEntry(SHIFT, 211);
   _actionMap[37][TRANSACTION] = ActionEntry(SHIFT, 213);
   _actionMap[38][SEMICOLON] = ActionEntry(REDUCE, 1);
   _actionMap[39][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[39][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[39][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[39][ObjSpec] = 214;
   _actionMap[40][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[40][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[40][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[40][ObjSpec] = 215;
   _actionMap[41][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[41][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[41][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[41][ObjSpec] = 216;
   _actionMap[42][TABLE] = ActionEntry(SHIFT, 217);
   _actionMap[43][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[43][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[43][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[43][ObjSpec] = 218;
   _actionMap[44][SEMICOLON] = ActionEntry(REDUCE, 20);
   _actionMap[45][EQU] = ActionEntry(SHIFT, 219);
   _actionMap[0][DROP] = ActionEntry(SHIFT, 22);
   _actionMap[0][RENAME] = ActionEntry(SHIFT, 31);
   _actionMap[0][ALTER] = ActionEntry(SHIFT, 14);
   _actionMap[0][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[0][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[0][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[0][SELECT] = ActionEntry(SHIFT, 34);
   _actionMap[0][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[0][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[0][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[0][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[0][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[0][SYNC] = ActionEntry(SHIFT, 38);
   _actionMap[0][LIST] = ActionEntry(SHIFT, 25);
   _actionMap[0][TABLEINFO] = ActionEntry(SHIFT, 39);
   _actionMap[0][TABLESIZE] = ActionEntry(SHIFT, 40);
   _actionMap[0][TUPLEINFO] = ActionEntry(SHIFT, 41);
   _actionMap[0][UPTIME] = ActionEntry(SHIFT, 44);
}
void Cego::loadParser292()
{
   _actionMap[0][SHOW] = ActionEntry(SHIFT, 36);
   _actionMap[0][DESC] = ActionEntry(SHIFT, 21);
   _actionMap[0][SET] = ActionEntry(SHIFT, 35);
   _actionMap[0][AUTHORIZE] = ActionEntry(SHIFT, 15);
   _actionMap[0][REORGANIZE] = ActionEntry(SHIFT, 32);
   _actionMap[0][PLAN] = ActionEntry(SHIFT, 29);
   _actionMap[0][CREATE] = ActionEntry(SHIFT, 19);
   _actionMap[0][LOAD] = ActionEntry(SHIFT, 26);
   _actionMap[0][CALL] = ActionEntry(SHIFT, 16);
   _actionMap[0][VARREF] = ActionEntry(SHIFT, 45);
   _actionMap[0][TRUNCATE] = ActionEntry(SHIFT, 42);
   _actionMap[0][PRINT] = ActionEntry(SHIFT, 30);
   _actionMap[0][CHECK] = ActionEntry(SHIFT, 17);
   _actionMap[0][JDBC] = ActionEntry(SHIFT, 24);
   _jumpMap[0][RenameStatement] = 13;
   _jumpMap[0][AlterStatement] = 12;
   _jumpMap[0][SelectStatement] = 11;
   _jumpMap[0][DeleteStatement] = 10;
   _jumpMap[0][UpdateStatement] = 9;
   _jumpMap[0][InsertStatement] = 8;
   _jumpMap[0][UnlockStatement] = 7;
   _jumpMap[0][LockStatement] = 6;
   _jumpMap[0][RollbackStatement] = 5;
   _jumpMap[0][CommitStatement] = 4;
   _jumpMap[0][StartStatement] = 3;
   _jumpMap[0][Statement] = 2;
   _jumpMap[0][DropOpt] = 1;
}
void Cego::loadParser293()
{
   _prodInfo.Insert(ProdEntry(422, ObjSpec, 1));
   _prodInfo.Insert(ProdEntry(421, ObjSpec, 1));
   _prodInfo.Insert(ProdEntry(420, ObjSpec, 1));
   _prodInfo.Insert(ProdEntry(419, Constant, 4));
   _prodInfo.I