--
-- ### Verification of advanced join ( failed before 2.47.15 )
-- 
--

drop if exists table acc_company;
create table acc_company ( cpid int, cpname string(20));

drop if exists table acc_company2group;
create table acc_company2group(cpid int, gpid int);

drop if exists table acc_contact2group;
create table acc_contact2group(ctid int not null, gpid int not null);
create primary btree on acc_contact2group(ctid, gpid);

drop if exists table acc_groupright;
create table acc_groupright(gpid int, gpright string(10));

insert into acc_company values ( 1, 'Cp001');
insert into acc_company values ( 2, 'Cp002');
insert into acc_company values ( 3, 'Cp003');

-- cpid 1 in group 2
insert into acc_company2group values ( 1, 2);

-- cpid 1,2,3 in group 11
insert into acc_company2group values ( 1, 11);
insert into acc_company2group values ( 2, 11);
insert into acc_company2group values ( 3, 11);

-- ctid 836 in group 2
insert into acc_contact2group values ( 836, 2);
insert into acc_groupright values ( 2, 'RGRead');
insert into acc_groupright values ( 11, 'RGRead');

@
create procedure checkSelect001(msg out string(20)) return string(10)
begin
	var res string(10) = 'ERROR';
	var i int;
	
	cursor xCur as

	       select count(*) from acc_company2group cp2g, acc_company cp,
   	       	      acc_contact2group ct2g,
   		      acc_groupright gr
	       where
		cp2g.cpid = cp.cpid
		and cp2g.gpid = ct2g.gpid
		and ct2g.ctid = 836
		and cp2g.gpid = gr.gpid
		and gr.gpright = 'RGRead';


        if fetch xCur into ( :i ) = true
        then 
	     if :i = 1 
	     then
		:res = 'ok';
	     end;
	end;
	close xCur;

	:msg = 'Number of companies is 1';

	return :res;
end;
@


:r = call checkSelect001(:msg);
insert into checklog values ('GATE-H', :msg, :r);

drop procedure checkSelect001;

drop table acc_company;
drop table acc_company2group;
drop table acc_contact2group;	
drop table acc_groupright;


