--
-- ### check indent formatting for stored procedure  
-- 


drop if exists table t1;
create table t1 ( a  int, b string(20), c string(20));
drop if exists table t2;
create table t2 ( a  int, b string(20), c string(20));
drop if exists table t3;
create table t3 ( a  int, b int);


drop if exists procedure checkIndent;
@
create procedure checkIndent()
return int
begin
   var a int;
   var b int;
   var c int;



   cursor indentCursor as select t1.a, count(*) from t1, t2
                           where t1.a = t2.a and t1.b = 'X' and t2.b = 'Y'
                           group by t1.a having count(*) > 1 rowlimit 10;


  insert into t2 ( a, b, c )
   	  select a, b, c from t2 where a = 3 and not exists ( select a from t3 where b = 4 );

   update t1 set b='Updated'
   where a = 42
       and b = 'Error'
       and c is not null; 


   while fetch indentCursor into ( :a, :b ) = true
   begin
      :c = :c + :a ;
   end;


   return :c;
end;
@

show procedure checkIndent;
