// Copyright (c) 2015-2016 Nuxi, https://nuxi.nl/
//
// SPDX-License-Identifier: BSD-2-Clause

#ifdef __wasilibc_use_wasip2
#include <wasi/wasip2.h>
#include <wasi/file_utils.h>
#include <common/errors.h>
#else
#include <wasi/api.h>
#endif
#include <errno.h>
#include <string.h>
#include <unistd.h>

int __wasilibc_nocwd_symlinkat(const char *path1, int fd, const char *path2) {

#ifdef __wasilibc_use_wasip2
  // Translate the file descriptor to an internal handle
  filesystem_borrow_descriptor_t file_handle;
  if (fd_to_file_handle(fd, &file_handle) < 0)
    return -1;

  // Convert the paths into WASI paths
  wasip2_string_t path1_wasi, path2_wasi;
  if (wasip2_string_from_c(path1, &path1_wasi) < 0)
    return -1;
  if (wasip2_string_from_c(path2, &path2_wasi) < 0)
    return -1;

  // Construct the link
  filesystem_error_code_t error_code;
  // path1 is the path for the existing file; path2 is the path for the new link
  bool ok = filesystem_method_descriptor_symlink_at(file_handle,
                                                    &path1_wasi,
                                                    &path2_wasi,
                                                    &error_code);
  // Check for errors
  if (!ok) {
    translate_error(error_code);
    return -1;
  }

#else

  __wasi_errno_t error = __wasi_path_symlink(path1, fd, path2);
  if (error != 0) {
    errno = error;
    return -1;
  }
#endif
  return 0;
}
