# IPC API Reference (Auto-Generated)

> **Note**: This file is auto-generated by `scripts/generateIpcDocs.js`. Do not edit manually.
>
> **Last Generated**: 2025-11-21T20:31:13.353Z

## Overview

This document lists all IPC (Inter-Process Communication) channels registered in the application.

- **Request/Response** channels use `ipcMain.handle()` and expect a return value
- **Event** channels use `ipcMain.on()` for fire-and-forget notifications

**Total Channels**: 38

---

## Authentication

| Channel | Type | Description | Location |
|---------|------|-------------|----------|
| `submitForm` | Event | Handle form submission for SSO/authentication workflows | [`app/login/index.js:26`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/login/index.js#L26) |

## Connection Management

| Channel | Type | Description | Location |
|---------|------|-------------|----------|
| `offline-retry` | Event | Retry connection when user clicks retry button on offline page | [`app/connectionManager/index.js:42`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/connectionManager/index.js#L42) |

## Core Application

| Channel | Type | Description | Location |
|---------|------|-------------|----------|
| `config-file-changed` | Event | Restart application when configuration file changes | [`app/index.js:138`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/index.js#L138) |
| `get-app-version` | Request/Response | Get application version number | [`app/index.js:164`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/index.js#L164) |
| `get-config` | Request/Response | Get current application configuration | [`app/index.js:140`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/index.js#L140) |
| `get-navigation-state` | Request/Response | Get current navigation state (can go back/forward) | [`app/index.js:187`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/index.js#L187) |
| `navigate-back` | Event | Navigate back in browser history | [`app/index.js:169`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/index.js#L169) |
| `navigate-forward` | Event | Navigate forward in browser history | [`app/index.js:178`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/index.js#L178) |
| `set-badge-count` | Request/Response | Set application badge count (dock/taskbar notification) | [`app/index.js:162`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/index.js#L162) |
| `user-status-changed` | Request/Response | Handle user status changes from Teams (e.g., Available, Busy, Away) | [`app/index.js:160`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/index.js#L160) |

## Custom Background

| Channel | Type | Description | Location |
|---------|------|-------------|----------|
| `get-custom-bg-list` | Request/Response | Get list of custom background images for Teams meetings | [`app/customBackground/index.js:15`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/customBackground/index.js#L15) |

## Idle Monitoring

| Channel | Type | Description | Location |
|---------|------|-------------|----------|
| `get-system-idle-state` | Request/Response | Get system idle state to sync with Teams presence | [`app/idle/monitor.js:15`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/idle/monitor.js#L15) |

## Incoming Calls

| Channel | Type | Description | Location |
|---------|------|-------------|----------|
| `incoming-call-action` | Event | Handle incoming call actions (accept/decline) | [`app/incomingCallToast/index.js:28`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/incomingCallToast/index.js#L28) |

## Main Window

| Channel | Type | Description | Location |
|---------|------|-------------|----------|
| `call-connected` | Request/Response | Notify when a call is connected | [`app/mainAppWindow/browserWindowManager.js:150`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/mainAppWindow/browserWindowManager.js#L150) |
| `call-disconnected` | Request/Response | Notify when a call is disconnected | [`app/mainAppWindow/browserWindowManager.js:152`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/mainAppWindow/browserWindowManager.js#L152) |
| `select-source` | Event | Handle screen sharing source selection from user | [`app/mainAppWindow/browserWindowManager.js:135`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/mainAppWindow/browserWindowManager.js#L135) |

## Menus & Tray

| Channel | Type | Description | Location |
|---------|------|-------------|----------|
| `tray-update` | Event | Update tray icon based on Teams status (notifications, badge count) | [`app/menus/tray.js:22`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/menus/tray.js#L22) |

## Microsoft Graph API

| Channel | Type | Description | Location |
|---------|------|-------------|----------|
| `graph-api-create-calendar-event` | Request/Response | Create a new calendar event | [`app/graphApi/ipcHandlers.js:32`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/graphApi/ipcHandlers.js#L32) |
| `graph-api-get-calendar-events` | Request/Response | Get calendar events with optional OData query options | [`app/graphApi/ipcHandlers.js:20`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/graphApi/ipcHandlers.js#L20) |
| `graph-api-get-calendar-view` | Request/Response | Get calendar view for a specific time range | [`app/graphApi/ipcHandlers.js:26`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/graphApi/ipcHandlers.js#L26) |
| `graph-api-get-mail-messages` | Request/Response | Get mail messages with optional OData query options | [`app/graphApi/ipcHandlers.js:38`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/graphApi/ipcHandlers.js#L38) |
| `graph-api-get-user-profile` | Request/Response | Get current user profile from Microsoft Graph API | [`app/graphApi/ipcHandlers.js:14`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/graphApi/ipcHandlers.js#L14) |

## Notifications

| Channel | Type | Description | Location |
|---------|------|-------------|----------|
| `play-notification-sound` | Request/Response | Play notification sound for Teams messages and calls | [`app/notifications/service.js:36`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/notifications/service.js#L36) |
| `show-notification` | Request/Response | Show system notification for Teams activity | [`app/notifications/service.js:38`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/notifications/service.js#L38) |

## Notifications (Custom)

| Channel | Type | Description | Location |
|---------|------|-------------|----------|
| `notification-show-toast` | Event | Display custom in-app toast notification in bottom-right corner | [`app/notificationSystem/index.js:17`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/notificationSystem/index.js#L17) |
| `notification-toast-click` | Event | Handle toast clicks - close the window and focus main window | [`app/notificationSystem/index.js:19`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/notificationSystem/index.js#L19) |

## Partitions & Zoom

| Channel | Type | Description | Location |
|---------|------|-------------|----------|
| `get-zoom-level` | Request/Response | Get current zoom level for a partition | [`app/partitions/manager.js:12`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/partitions/manager.js#L12) |
| `save-zoom-level` | Request/Response | Save zoom level for a partition | [`app/partitions/manager.js:14`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/partitions/manager.js#L14) |

## Screen Sharing

| Channel | Type | Description | Location |
|---------|------|-------------|----------|
| `cancel-desktop-media` | Event | Cancel desktop media selection dialog | [`app/screenSharing/service.js:20`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/screenSharing/service.js#L20) |
| `choose-desktop-media` | Request/Response | Select desktop media source for screen sharing | [`app/screenSharing/service.js:18`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/screenSharing/service.js#L18) |
| `desktop-capturer-get-sources` | Request/Response | Get available desktop capturer sources (screens/windows) for sharing | [`app/screenSharing/service.js:16`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/screenSharing/service.js#L16) |
| `get-screen-share-screen` | Request/Response | Get screen share screen details | [`app/screenSharing/service.js:30`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/screenSharing/service.js#L30) |
| `get-screen-share-stream` | Request/Response | Get screen share stream for thumbnail preview | [`app/screenSharing/service.js:28`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/screenSharing/service.js#L28) |
| `get-screen-sharing-status` | Request/Response | Get current screen sharing status | [`app/screenSharing/service.js:26`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/screenSharing/service.js#L26) |
| `resize-preview-window` | Event | Resize screen sharing preview window | [`app/screenSharing/service.js:32`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/screenSharing/service.js#L32) |
| `screen-sharing-started` | Event | Notify when screen sharing session starts | [`app/screenSharing/service.js:22`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/screenSharing/service.js#L22) |
| `screen-sharing-stopped` | Event | Notify when screen sharing session stops | [`app/screenSharing/service.js:24`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/screenSharing/service.js#L24) |
| `stop-screen-sharing-from-thumbnail` | Event | Stop screen sharing from thumbnail preview | [`app/screenSharing/service.js:34`](https://github.com/IsmaelMartinez/teams-for-linux/blob/develop/app/screenSharing/service.js#L34) |

---

## Channel Security

All IPC channels are validated through the security layer in `app/security/ipcValidator.js`.
See the [IPC Channel Validation documentation](./security-architecture.md#ipc-channel-validation) for more information.

## Adding New Channels

When adding a new IPC channel:

1. Register the channel with `ipcMain.handle()` or `ipcMain.on()`
2. Add the channel to the allowlist in `app/security/ipcValidator.js`
3. Add a comment above the registration describing its purpose
4. Run `npm run generate-ipc-docs` to update this documentation

---

*Generated by `scripts/generateIpcDocs.js`*
