/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.evaluator;

import java.io.Serializable;
import net.sf.ehcache.Element;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.ScopeNode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;

public class SubtreeScopeEvaluator
implements Evaluator<ScopeNode> {
    private final ScopeNode node;
    private final String baseId;
    private final boolean baseIsContextEntry;
    private final boolean dereferencing;
    private final Store db;
    private String contextEntryId;

    public SubtreeScopeEvaluator(Store db, ScopeNode node) throws Exception {
        this.db = db;
        this.node = node;
        if (node.getScope() != SearchScope.SUBTREE) {
            throw new IllegalStateException(I18n.err(I18n.ERR_727, new Object[0]));
        }
        this.baseId = node.getBaseId();
        this.baseIsContextEntry = this.getContextEntryId() == this.baseId;
        this.dereferencing = node.getDerefAliases().isDerefInSearching() || node.getDerefAliases().isDerefAlways();
    }

    private String getContextEntryId() throws Exception {
        if (this.contextEntryId == null) {
            try {
                this.contextEntryId = this.db.getEntryId(((Partition)((Object)this.db)).getSuffixDn());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.contextEntryId == null) {
            return Partition.DEFAULT_ID;
        }
        return this.contextEntryId;
    }

    private boolean isDescendant(String candidateId) throws LdapException {
        String tmp = candidateId;
        do {
            ParentIdAndRdn parentIdAndRdn;
            if ((parentIdAndRdn = this.db.getRdnIndex().reverseLookup(tmp)) == null) {
                return false;
            }
            tmp = parentIdAndRdn.getParentId();
            if (!tmp.equals(Partition.ROOT_ID)) continue;
            return false;
        } while (!tmp.equals(this.baseId));
        return true;
    }

    @Override
    public boolean evaluate(IndexEntry<?, String> indexEntry) throws LdapException {
        boolean isDescendant;
        String id = indexEntry.getId();
        Entry entry = indexEntry.getEntry();
        if (null == entry) {
            entry = this.db.fetch(indexEntry.getId());
            if (null == entry) {
                return false;
            }
            indexEntry.setEntry(entry);
        }
        boolean bl = isDescendant = this.baseIsContextEntry || this.baseId.equals(id) || this.isDescendant(id);
        if (!this.isDereferencing()) {
            return isDescendant;
        }
        if (this.db.getAliasCache() != null) {
            Element element = this.db.getAliasCache().get((Serializable)((Object)id));
            if (element != null && element.getValue() != null) {
                Dn dn = (Dn)element.getValue();
                return false;
            }
        } else if (null != this.db.getAliasIndex().reverseLookup(id)) {
            return false;
        }
        if (isDescendant) {
            return true;
        }
        return this.db.getSubAliasIndex().forward(this.baseId, id);
    }

    @Override
    public boolean evaluate(Entry candidate) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_721, new Object[0]));
    }

    @Override
    public ScopeNode getExpression() {
        return this.node;
    }

    public String getBaseId() {
        return this.baseId;
    }

    public boolean isDereferencing() {
        return this.dereferencing;
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("SubstreeScopeEvaluator : ").append(this.node).append('\n');
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

