/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.directory.SearchControls;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCache {
    private static final Logger LOG = LoggerFactory.getLogger(GroupCache.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private final PartitionNexus nexus;
    private AttributeType OBJECT_CLASS_AT;
    private AttributeType MEMBER_AT;
    private AttributeType UNIQUE_MEMBER_AT;
    private SchemaManager schemaManager;
    private DnFactory dnFactory;
    private Dn administratorsGroupDn;
    private static final Set<Dn> EMPTY_GROUPS = new HashSet<Dn>();
    private Cache ehCache;

    public GroupCache(DirectoryService dirService) throws LdapException {
        this.schemaManager = dirService.getSchemaManager();
        this.dnFactory = dirService.getDnFactory();
        this.nexus = dirService.getPartitionNexus();
        this.OBJECT_CLASS_AT = this.schemaManager.getAttributeType("objectClass");
        this.MEMBER_AT = this.schemaManager.getAttributeType("member");
        this.UNIQUE_MEMBER_AT = this.schemaManager.getAttributeType("uniqueMember");
        this.administratorsGroupDn = this.parseNormalized("cn=Administrators,ou=groups,ou=system");
        this.ehCache = dirService.getCacheService().getCache("groupCache");
        this.initialize(dirService.getAdminSession());
    }

    private Dn parseNormalized(String name) throws LdapException {
        Dn dn = this.dnFactory.create(name);
        return dn;
    }

    private void initialize(CoreSession session) throws LdapException {
        Set<String> suffixes = this.nexus.listSuffixes();
        for (String suffix : suffixes) {
            OrNode filter = new OrNode();
            filter.addNode(new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("groupOfNames")));
            filter.addNode(new EqualityNode<String>(this.OBJECT_CLASS_AT, new StringValue("groupOfUniqueNames")));
            Dn baseDn = this.dnFactory.create(suffix);
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(new String[]{"*", "+"});
            SearchOperationContext searchOperationContext = new SearchOperationContext(session, baseDn, filter, ctls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            EntryFilteringCursor results = this.nexus.search(searchOperationContext);
            try {
                while (results.next()) {
                    Entry result = (Entry)results.get();
                    Dn groupDn = result.getDn().apply(this.schemaManager);
                    Attribute members = this.getMemberAttribute(result);
                    if (members != null) {
                        HashSet<String> memberSet = new HashSet<String>(members.size());
                        this.addMembers(memberSet, members);
                        Element cacheElement = new Element(groupDn.getNormName(), memberSet);
                        this.ehCache.put(cacheElement);
                        continue;
                    }
                    LOG.warn("Found group '{}' without any member or uniqueMember attributes", (Object)groupDn.getName());
                }
                results.close();
            }
            catch (Exception e) {
                LOG.error("Exception while initializing the groupCache:  {}", e.getCause());
                LdapOperationException le = new LdapOperationException(e.getMessage(), e);
                throw le;
            }
        }
        if (IS_DEBUG) {
            LOG.debug("group cache contents on startup:\n {}", (Object)this.ehCache.getAllWithLoader(this.ehCache.getKeys(), null));
        }
    }

    private Attribute getMemberAttribute(Entry entry) throws LdapException {
        Attribute member = entry.get(this.MEMBER_AT);
        if (member != null) {
            return member;
        }
        Attribute uniqueMember = entry.get(this.UNIQUE_MEMBER_AT);
        if (uniqueMember != null) {
            return uniqueMember;
        }
        return null;
    }

    private void addMembers(Set<String> memberSet, Attribute members) throws LdapException {
        for (Value value : members) {
            String memberDn = value.getString();
            try {
                memberDn = this.parseNormalized(memberDn).getNormName();
            }
            catch (LdapException e) {
                LOG.warn("Malformed member Dn in groupOf[Unique]Names entry.  Member not added to GroupCache.", e);
            }
            memberSet.add(memberDn);
        }
    }

    private void removeMembers(Set<String> memberSet, Attribute members) throws LdapException {
        for (Value value : members) {
            String memberDn = value.getString();
            try {
                memberDn = this.parseNormalized(memberDn).getNormName();
            }
            catch (LdapException e) {
                LOG.warn("Malformed member Dn in groupOf[Unique]Names entry.  Member not removed from GroupCache.", e);
            }
            memberSet.remove(memberDn);
        }
    }

    public void groupAdded(Dn name, Entry entry) throws LdapException {
        Attribute members = this.getMemberAttribute(entry);
        if (members == null) {
            return;
        }
        HashSet<String> memberSet = new HashSet<String>(members.size());
        this.addMembers(memberSet, members);
        Element cacheElement = new Element(name.getNormName(), memberSet);
        this.ehCache.put(cacheElement);
        if (IS_DEBUG) {
            LOG.debug("group cache contents after adding '{}' :\n {}", (Object)name.getName(), (Object)this.ehCache.getAllWithLoader(this.ehCache.getKeys(), null));
        }
    }

    public void groupDeleted(Dn name, Entry entry) throws LdapException {
        Attribute members = this.getMemberAttribute(entry);
        if (members == null) {
            return;
        }
        this.ehCache.remove((Serializable)((Object)name.getNormName()));
        if (IS_DEBUG) {
            LOG.debug("group cache contents after deleting '{}' :\n {}", (Object)name.getName(), (Object)this.ehCache.getAllWithLoader(this.ehCache.getKeys(), null));
        }
    }

    private void modify(Set<String> memberSet, ModificationOperation modOp, Attribute members) throws LdapException {
        switch (modOp) {
            case ADD_ATTRIBUTE: {
                this.addMembers(memberSet, members);
                break;
            }
            case REPLACE_ATTRIBUTE: {
                if (members.size() <= 0) break;
                memberSet.clear();
                this.addMembers(memberSet, members);
                break;
            }
            case REMOVE_ATTRIBUTE: {
                this.removeMembers(memberSet, members);
                break;
            }
            default: {
                throw new InternalError(I18n.err(I18n.ERR_235, new Object[]{modOp}));
            }
        }
    }

    public void groupModified(Dn name, List<Modification> mods, Entry entry, SchemaManager schemaManager) throws LdapException {
        Attribute members = null;
        AttributeType memberAttr = null;
        Attribute oc = entry.get(this.OBJECT_CLASS_AT);
        if (oc.contains("groupOfNames")) {
            members = entry.get(this.MEMBER_AT);
            memberAttr = schemaManager.getAttributeType("member");
        }
        if (oc.contains("groupOfUniqueNames")) {
            members = entry.get(this.UNIQUE_MEMBER_AT);
            memberAttr = schemaManager.getAttributeType("uniqueMember");
        }
        if (members == null) {
            return;
        }
        for (Modification modification : mods) {
            if (memberAttr.getOid() != modification.getAttribute().getId()) continue;
            Element memSetElement = this.ehCache.get((Serializable)((Object)name.getNormName()));
            if (memSetElement == null) break;
            Set memberSet = (Set)((Object)memSetElement.getValue());
            this.modify(memberSet, modification.getOperation(), modification.getAttribute());
            break;
        }
        if (IS_DEBUG) {
            LOG.debug("group cache contents after modifying '{}' :\n {}", (Object)name.getName(), (Object)this.ehCache.getAllWithLoader(this.ehCache.getKeys(), null));
        }
    }

    public void groupModified(Dn name, ModificationOperation modOp, Entry mods) throws LdapException {
        Attribute members = this.getMemberAttribute(mods);
        if (members == null) {
            return;
        }
        Element memSetElement = this.ehCache.get((Serializable)((Object)name.getNormName()));
        if (memSetElement != null) {
            Set memberSet = (Set)((Object)memSetElement.getValue());
            this.modify(memberSet, modOp, members);
        }
        if (IS_DEBUG) {
            LOG.debug("group cache contents after modifying '{}' :\n {}", (Object)name.getName(), (Object)this.ehCache.getAllWithLoader(this.ehCache.getKeys(), null));
        }
    }

    public final boolean isPrincipalAnAdministrator(Dn principalDn) {
        if (principalDn.getNormName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system")) {
            return true;
        }
        Element cacheElement = this.ehCache.get((Serializable)((Object)this.administratorsGroupDn.getNormName()));
        if (cacheElement == null) {
            LOG.warn("What do you mean there is no administrators group? This is bad news.");
            return false;
        }
        Set members = (Set)((Object)cacheElement.getValue());
        return members.contains(principalDn.getNormName());
    }

    public Set<Dn> getGroups(String member) throws LdapException {
        Dn normMember;
        try {
            normMember = this.parseNormalized(member);
        }
        catch (LdapException e) {
            LOG.warn("Malformed member Dn.  Could not find groups for member '{}' in GroupCache. Returning empty set for groups!", (Object)member, (Object)e);
            return EMPTY_GROUPS;
        }
        HashSet<Dn> memberGroups = null;
        for (Object obj : this.ehCache.getKeys()) {
            Set members;
            String group = (String)obj;
            Element element = this.ehCache.get((Serializable)((Object)group));
            if (element == null || (members = (Set)((Object)element.getValue())) == null || !members.contains(normMember.getNormName())) continue;
            if (memberGroups == null) {
                memberGroups = new HashSet<Dn>();
            }
            memberGroups.add(this.parseNormalized(group));
        }
        if (memberGroups == null) {
            return EMPTY_GROUPS;
        }
        return memberGroups;
    }

    public boolean groupRenamed(Dn oldName, Dn newName) {
        Element membersElement = this.ehCache.get((Serializable)((Object)oldName.getNormName()));
        if (membersElement != null) {
            Set members = (Set)((Object)membersElement.getValue());
            this.ehCache.remove((Serializable)((Object)oldName.getNormName()));
            Element cacheElement = new Element(newName.getNormName(), members);
            this.ehCache.put(cacheElement);
            if (IS_DEBUG) {
                LOG.debug("group cache contents after renaming '{}' :\n{}", (Object)oldName.getName(), (Object)this.ehCache.getAllWithLoader(this.ehCache.getKeys(), null));
            }
            return true;
        }
        return false;
    }
}

